package Date::Manip::TZ::asdama00;
# Copyright (c) 2008-2010 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 20 14:19:42 EST 2009
#    Data version: tzdata2009s
#    Code version: tzcode2009r

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::asdama00 - Support for the Asia/Damascus time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

use vars qw(%Dates %LastRule);

use vars qw($VERSION);
$VERSION="6.00";

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,2,25,12],'+02:25:12',[2,25,12],
          'LMT',0,[1919,12,31,21,34,47],[1919,12,31,23,59,59] ],
     ],
   1919 =>
     [
        [ [1919,12,31,21,34,48],[1919,12,31,23,34,48],'+02:00:00',[2,0,0],
          'EET',0,[1920,4,17,23,59,59],[1920,4,18,1,59,59] ],
     ],
   1920 =>
     [
        [ [1920,4,18,0,0,0],[1920,4,18,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1920,10,2,22,59,59],[1920,10,3,1,59,59] ],
        [ [1920,10,2,23,0,0],[1920,10,3,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1921,4,16,23,59,59],[1921,4,17,1,59,59] ],
     ],
   1921 =>
     [
        [ [1921,4,17,0,0,0],[1921,4,17,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1921,10,1,22,59,59],[1921,10,2,1,59,59] ],
        [ [1921,10,1,23,0,0],[1921,10,2,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1922,4,15,23,59,59],[1922,4,16,1,59,59] ],
     ],
   1922 =>
     [
        [ [1922,4,16,0,0,0],[1922,4,16,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1922,9,30,22,59,59],[1922,10,1,1,59,59] ],
        [ [1922,9,30,23,0,0],[1922,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1923,4,14,23,59,59],[1923,4,15,1,59,59] ],
     ],
   1923 =>
     [
        [ [1923,4,15,0,0,0],[1923,4,15,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1923,10,6,22,59,59],[1923,10,7,1,59,59] ],
        [ [1923,10,6,23,0,0],[1923,10,7,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1962,4,28,23,59,59],[1962,4,29,1,59,59] ],
     ],
   1962 =>
     [
        [ [1962,4,29,0,0,0],[1962,4,29,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1962,9,30,22,59,59],[1962,10,1,1,59,59] ],
        [ [1962,9,30,23,0,0],[1962,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1963,4,30,23,59,59],[1963,5,1,1,59,59] ],
     ],
   1963 =>
     [
        [ [1963,5,1,0,0,0],[1963,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1963,9,29,22,59,59],[1963,9,30,1,59,59] ],
        [ [1963,9,29,23,0,0],[1963,9,30,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1964,4,30,23,59,59],[1964,5,1,1,59,59] ],
     ],
   1964 =>
     [
        [ [1964,5,1,0,0,0],[1964,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1964,9,30,22,59,59],[1964,10,1,1,59,59] ],
        [ [1964,9,30,23,0,0],[1964,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1965,4,30,23,59,59],[1965,5,1,1,59,59] ],
     ],
   1965 =>
     [
        [ [1965,5,1,0,0,0],[1965,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1965,9,29,22,59,59],[1965,9,30,1,59,59] ],
        [ [1965,9,29,23,0,0],[1965,9,30,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1966,4,23,23,59,59],[1966,4,24,1,59,59] ],
     ],
   1966 =>
     [
        [ [1966,4,24,0,0,0],[1966,4,24,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1966,9,30,22,59,59],[1966,10,1,1,59,59] ],
        [ [1966,9,30,23,0,0],[1966,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1967,4,30,23,59,59],[1967,5,1,1,59,59] ],
     ],
   1967 =>
     [
        [ [1967,5,1,0,0,0],[1967,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1967,9,30,22,59,59],[1967,10,1,1,59,59] ],
        [ [1967,9,30,23,0,0],[1967,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1968,4,30,23,59,59],[1968,5,1,1,59,59] ],
     ],
   1968 =>
     [
        [ [1968,5,1,0,0,0],[1968,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1968,9,30,22,59,59],[1968,10,1,1,59,59] ],
        [ [1968,9,30,23,0,0],[1968,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1969,4,30,23,59,59],[1969,5,1,1,59,59] ],
     ],
   1969 =>
     [
        [ [1969,5,1,0,0,0],[1969,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1969,9,30,22,59,59],[1969,10,1,1,59,59] ],
        [ [1969,9,30,23,0,0],[1969,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1970,4,30,23,59,59],[1970,5,1,1,59,59] ],
     ],
   1970 =>
     [
        [ [1970,5,1,0,0,0],[1970,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1970,9,30,22,59,59],[1970,10,1,1,59,59] ],
        [ [1970,9,30,23,0,0],[1970,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1971,4,30,23,59,59],[1971,5,1,1,59,59] ],
     ],
   1971 =>
     [
        [ [1971,5,1,0,0,0],[1971,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1971,9,30,22,59,59],[1971,10,1,1,59,59] ],
        [ [1971,9,30,23,0,0],[1971,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1972,4,30,23,59,59],[1972,5,1,1,59,59] ],
     ],
   1972 =>
     [
        [ [1972,5,1,0,0,0],[1972,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1972,9,30,22,59,59],[1972,10,1,1,59,59] ],
        [ [1972,9,30,23,0,0],[1972,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1973,4,30,23,59,59],[1973,5,1,1,59,59] ],
     ],
   1973 =>
     [
        [ [1973,5,1,0,0,0],[1973,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1973,9,30,22,59,59],[1973,10,1,1,59,59] ],
        [ [1973,9,30,23,0,0],[1973,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1974,4,30,23,59,59],[1974,5,1,1,59,59] ],
     ],
   1974 =>
     [
        [ [1974,5,1,0,0,0],[1974,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1974,9,30,22,59,59],[1974,10,1,1,59,59] ],
        [ [1974,9,30,23,0,0],[1974,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1975,4,30,23,59,59],[1975,5,1,1,59,59] ],
     ],
   1975 =>
     [
        [ [1975,5,1,0,0,0],[1975,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1975,9,30,22,59,59],[1975,10,1,1,59,59] ],
        [ [1975,9,30,23,0,0],[1975,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1976,4,30,23,59,59],[1976,5,1,1,59,59] ],
     ],
   1976 =>
     [
        [ [1976,5,1,0,0,0],[1976,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1976,9,30,22,59,59],[1976,10,1,1,59,59] ],
        [ [1976,9,30,23,0,0],[1976,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1977,4,30,23,59,59],[1977,5,1,1,59,59] ],
     ],
   1977 =>
     [
        [ [1977,5,1,0,0,0],[1977,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1977,8,31,22,59,59],[1977,9,1,1,59,59] ],
        [ [1977,8,31,23,0,0],[1977,9,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1978,4,30,23,59,59],[1978,5,1,1,59,59] ],
     ],
   1978 =>
     [
        [ [1978,5,1,0,0,0],[1978,5,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1978,8,31,22,59,59],[1978,9,1,1,59,59] ],
        [ [1978,8,31,23,0,0],[1978,9,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1983,4,8,23,59,59],[1983,4,9,1,59,59] ],
     ],
   1983 =>
     [
        [ [1983,4,9,0,0,0],[1983,4,9,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1983,9,30,22,59,59],[1983,10,1,1,59,59] ],
        [ [1983,9,30,23,0,0],[1983,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1984,4,8,23,59,59],[1984,4,9,1,59,59] ],
     ],
   1984 =>
     [
        [ [1984,4,9,0,0,0],[1984,4,9,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1984,9,30,22,59,59],[1984,10,1,1,59,59] ],
        [ [1984,9,30,23,0,0],[1984,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1986,2,15,23,59,59],[1986,2,16,1,59,59] ],
     ],
   1986 =>
     [
        [ [1986,2,16,0,0,0],[1986,2,16,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1986,10,8,22,59,59],[1986,10,9,1,59,59] ],
        [ [1986,10,8,23,0,0],[1986,10,9,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1987,2,28,23,59,59],[1987,3,1,1,59,59] ],
     ],
   1987 =>
     [
        [ [1987,3,1,0,0,0],[1987,3,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1987,10,30,22,59,59],[1987,10,31,1,59,59] ],
        [ [1987,10,30,23,0,0],[1987,10,31,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1988,3,14,23,59,59],[1988,3,15,1,59,59] ],
     ],
   1988 =>
     [
        [ [1988,3,15,0,0,0],[1988,3,15,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1988,10,30,22,59,59],[1988,10,31,1,59,59] ],
        [ [1988,10,30,23,0,0],[1988,10,31,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1989,3,30,23,59,59],[1989,3,31,1,59,59] ],
     ],
   1989 =>
     [
        [ [1989,3,31,0,0,0],[1989,3,31,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1989,9,30,22,59,59],[1989,10,1,1,59,59] ],
        [ [1989,9,30,23,0,0],[1989,10,1,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1990,3,31,23,59,59],[1990,4,1,1,59,59] ],
     ],
   1990 =>
     [
        [ [1990,4,1,0,0,0],[1990,4,1,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1990,9,29,22,59,59],[1990,9,30,1,59,59] ],
        [ [1990,9,29,23,0,0],[1990,9,30,1,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1991,3,31,21,59,59],[1991,3,31,23,59,59] ],
     ],
   1991 =>
     [
        [ [1991,3,31,22,0,0],[1991,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1991,9,30,20,59,59],[1991,9,30,23,59,59] ],
        [ [1991,9,30,21,0,0],[1991,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1992,4,7,21,59,59],[1992,4,7,23,59,59] ],
     ],
   1992 =>
     [
        [ [1992,4,7,22,0,0],[1992,4,8,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1992,9,30,20,59,59],[1992,9,30,23,59,59] ],
        [ [1992,9,30,21,0,0],[1992,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1993,3,25,21,59,59],[1993,3,25,23,59,59] ],
     ],
   1993 =>
     [
        [ [1993,3,25,22,0,0],[1993,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1993,9,24,20,59,59],[1993,9,24,23,59,59] ],
        [ [1993,9,24,21,0,0],[1993,9,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1994,3,31,21,59,59],[1994,3,31,23,59,59] ],
     ],
   1994 =>
     [
        [ [1994,3,31,22,0,0],[1994,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1994,9,30,20,59,59],[1994,9,30,23,59,59] ],
        [ [1994,9,30,21,0,0],[1994,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1995,3,31,21,59,59],[1995,3,31,23,59,59] ],
     ],
   1995 =>
     [
        [ [1995,3,31,22,0,0],[1995,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1995,9,30,20,59,59],[1995,9,30,23,59,59] ],
        [ [1995,9,30,21,0,0],[1995,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1996,3,31,21,59,59],[1996,3,31,23,59,59] ],
     ],
   1996 =>
     [
        [ [1996,3,31,22,0,0],[1996,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1996,9,30,20,59,59],[1996,9,30,23,59,59] ],
        [ [1996,9,30,21,0,0],[1996,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1997,3,30,21,59,59],[1997,3,30,23,59,59] ],
     ],
   1997 =>
     [
        [ [1997,3,30,22,0,0],[1997,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1997,9,30,20,59,59],[1997,9,30,23,59,59] ],
        [ [1997,9,30,21,0,0],[1997,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1998,3,29,21,59,59],[1998,3,29,23,59,59] ],
     ],
   1998 =>
     [
        [ [1998,3,29,22,0,0],[1998,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1998,9,30,20,59,59],[1998,9,30,23,59,59] ],
        [ [1998,9,30,21,0,0],[1998,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1999,3,31,21,59,59],[1999,3,31,23,59,59] ],
     ],
   1999 =>
     [
        [ [1999,3,31,22,0,0],[1999,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1999,9,30,20,59,59],[1999,9,30,23,59,59] ],
        [ [1999,9,30,21,0,0],[1999,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2000,3,31,21,59,59],[2000,3,31,23,59,59] ],
     ],
   2000 =>
     [
        [ [2000,3,31,22,0,0],[2000,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2000,9,30,20,59,59],[2000,9,30,23,59,59] ],
        [ [2000,9,30,21,0,0],[2000,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2001,3,31,21,59,59],[2001,3,31,23,59,59] ],
     ],
   2001 =>
     [
        [ [2001,3,31,22,0,0],[2001,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2001,9,30,20,59,59],[2001,9,30,23,59,59] ],
        [ [2001,9,30,21,0,0],[2001,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2002,3,31,21,59,59],[2002,3,31,23,59,59] ],
     ],
   2002 =>
     [
        [ [2002,3,31,22,0,0],[2002,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2002,9,30,20,59,59],[2002,9,30,23,59,59] ],
        [ [2002,9,30,21,0,0],[2002,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2003,3,31,21,59,59],[2003,3,31,23,59,59] ],
     ],
   2003 =>
     [
        [ [2003,3,31,22,0,0],[2003,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2003,9,30,20,59,59],[2003,9,30,23,59,59] ],
        [ [2003,9,30,21,0,0],[2003,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2004,3,31,21,59,59],[2004,3,31,23,59,59] ],
     ],
   2004 =>
     [
        [ [2004,3,31,22,0,0],[2004,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2004,9,30,20,59,59],[2004,9,30,23,59,59] ],
        [ [2004,9,30,21,0,0],[2004,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2005,3,31,21,59,59],[2005,3,31,23,59,59] ],
     ],
   2005 =>
     [
        [ [2005,3,31,22,0,0],[2005,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2005,9,30,20,59,59],[2005,9,30,23,59,59] ],
        [ [2005,9,30,21,0,0],[2005,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2006,3,31,21,59,59],[2006,3,31,23,59,59] ],
     ],
   2006 =>
     [
        [ [2006,3,31,22,0,0],[2006,4,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2006,9,21,20,59,59],[2006,9,21,23,59,59] ],
        [ [2006,9,21,21,0,0],[2006,9,21,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2007,3,29,21,59,59],[2007,3,29,23,59,59] ],
     ],
   2007 =>
     [
        [ [2007,3,29,22,0,0],[2007,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2007,11,1,20,59,59],[2007,11,1,23,59,59] ],
        [ [2007,11,1,21,0,0],[2007,11,1,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2008,4,3,21,59,59],[2008,4,3,23,59,59] ],
     ],
   2008 =>
     [
        [ [2008,4,3,22,0,0],[2008,4,4,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2008,10,31,20,59,59],[2008,10,31,23,59,59] ],
        [ [2008,10,31,21,0,0],[2008,10,31,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2009,3,26,21,59,59],[2009,3,26,23,59,59] ],
     ],
   2009 =>
     [
        [ [2009,3,26,22,0,0],[2009,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2009,10,29,20,59,59],[2009,10,29,23,59,59] ],
        [ [2009,10,29,21,0,0],[2009,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2010,3,25,21,59,59],[2010,3,25,23,59,59] ],
     ],
   2010 =>
     [
        [ [2010,3,25,22,0,0],[2010,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2010,10,28,20,59,59],[2010,10,28,23,59,59] ],
        [ [2010,10,28,21,0,0],[2010,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2011,3,24,21,59,59],[2011,3,24,23,59,59] ],
     ],
   2011 =>
     [
        [ [2011,3,24,22,0,0],[2011,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2011,10,27,20,59,59],[2011,10,27,23,59,59] ],
        [ [2011,10,27,21,0,0],[2011,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2012,3,29,21,59,59],[2012,3,29,23,59,59] ],
     ],
   2012 =>
     [
        [ [2012,3,29,22,0,0],[2012,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2012,10,25,20,59,59],[2012,10,25,23,59,59] ],
        [ [2012,10,25,21,0,0],[2012,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2013,3,28,21,59,59],[2013,3,28,23,59,59] ],
     ],
   2013 =>
     [
        [ [2013,3,28,22,0,0],[2013,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2013,10,24,20,59,59],[2013,10,24,23,59,59] ],
        [ [2013,10,24,21,0,0],[2013,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2014,3,27,21,59,59],[2014,3,27,23,59,59] ],
     ],
   2014 =>
     [
        [ [2014,3,27,22,0,0],[2014,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2014,10,30,20,59,59],[2014,10,30,23,59,59] ],
        [ [2014,10,30,21,0,0],[2014,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2015,3,26,21,59,59],[2015,3,26,23,59,59] ],
     ],
   2015 =>
     [
        [ [2015,3,26,22,0,0],[2015,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2015,10,29,20,59,59],[2015,10,29,23,59,59] ],
        [ [2015,10,29,21,0,0],[2015,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2016,3,24,21,59,59],[2016,3,24,23,59,59] ],
     ],
   2016 =>
     [
        [ [2016,3,24,22,0,0],[2016,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2016,10,27,20,59,59],[2016,10,27,23,59,59] ],
        [ [2016,10,27,21,0,0],[2016,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2017,3,30,21,59,59],[2017,3,30,23,59,59] ],
     ],
   2017 =>
     [
        [ [2017,3,30,22,0,0],[2017,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2017,10,26,20,59,59],[2017,10,26,23,59,59] ],
        [ [2017,10,26,21,0,0],[2017,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2018,3,29,21,59,59],[2018,3,29,23,59,59] ],
     ],
   2018 =>
     [
        [ [2018,3,29,22,0,0],[2018,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2018,10,25,20,59,59],[2018,10,25,23,59,59] ],
        [ [2018,10,25,21,0,0],[2018,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2019,3,28,21,59,59],[2019,3,28,23,59,59] ],
     ],
   2019 =>
     [
        [ [2019,3,28,22,0,0],[2019,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2019,10,24,20,59,59],[2019,10,24,23,59,59] ],
        [ [2019,10,24,21,0,0],[2019,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2020,3,26,21,59,59],[2020,3,26,23,59,59] ],
     ],
   2020 =>
     [
        [ [2020,3,26,22,0,0],[2020,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2020,10,29,20,59,59],[2020,10,29,23,59,59] ],
        [ [2020,10,29,21,0,0],[2020,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2021,3,25,21,59,59],[2021,3,25,23,59,59] ],
     ],
   2021 =>
     [
        [ [2021,3,25,22,0,0],[2021,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2021,10,28,20,59,59],[2021,10,28,23,59,59] ],
        [ [2021,10,28,21,0,0],[2021,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2022,3,24,21,59,59],[2022,3,24,23,59,59] ],
     ],
   2022 =>
     [
        [ [2022,3,24,22,0,0],[2022,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2022,10,27,20,59,59],[2022,10,27,23,59,59] ],
        [ [2022,10,27,21,0,0],[2022,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2023,3,30,21,59,59],[2023,3,30,23,59,59] ],
     ],
   2023 =>
     [
        [ [2023,3,30,22,0,0],[2023,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2023,10,26,20,59,59],[2023,10,26,23,59,59] ],
        [ [2023,10,26,21,0,0],[2023,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2024,3,28,21,59,59],[2024,3,28,23,59,59] ],
     ],
   2024 =>
     [
        [ [2024,3,28,22,0,0],[2024,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2024,10,24,20,59,59],[2024,10,24,23,59,59] ],
        [ [2024,10,24,21,0,0],[2024,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2025,3,27,21,59,59],[2025,3,27,23,59,59] ],
     ],
   2025 =>
     [
        [ [2025,3,27,22,0,0],[2025,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2025,10,30,20,59,59],[2025,10,30,23,59,59] ],
        [ [2025,10,30,21,0,0],[2025,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2026,3,26,21,59,59],[2026,3,26,23,59,59] ],
     ],
   2026 =>
     [
        [ [2026,3,26,22,0,0],[2026,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2026,10,29,20,59,59],[2026,10,29,23,59,59] ],
        [ [2026,10,29,21,0,0],[2026,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2027,3,25,21,59,59],[2027,3,25,23,59,59] ],
     ],
   2027 =>
     [
        [ [2027,3,25,22,0,0],[2027,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2027,10,28,20,59,59],[2027,10,28,23,59,59] ],
        [ [2027,10,28,21,0,0],[2027,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2028,3,30,21,59,59],[2028,3,30,23,59,59] ],
     ],
   2028 =>
     [
        [ [2028,3,30,22,0,0],[2028,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2028,10,26,20,59,59],[2028,10,26,23,59,59] ],
        [ [2028,10,26,21,0,0],[2028,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2029,3,29,21,59,59],[2029,3,29,23,59,59] ],
     ],
   2029 =>
     [
        [ [2029,3,29,22,0,0],[2029,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2029,10,25,20,59,59],[2029,10,25,23,59,59] ],
        [ [2029,10,25,21,0,0],[2029,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2030,3,28,21,59,59],[2030,3,28,23,59,59] ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+03:00:00',
                'stdoff' => '+02:00:00',

               },
   'rules'  => {
                '03' => {
                         'flag'    => 'last',
                         'dow'     => '5',
                         'num'     => '0',
                         'type'    => 'w',
                         'time'    => '00:00:00',
                         'isdst'   => '1',
                         'abb'     => 'EEST',
                        },
                '10' => {
                         'flag'    => 'last',
                         'dow'     => '5',
                         'num'     => '0',
                         'type'    => 'w',
                         'time'    => '00:00:00',
                         'isdst'   => '0',
                         'abb'     => 'EET',
                        },

               },
);

1;
