package CIF::Message::FeedMalware;
use base 'CIF::Message::Feed';

use strict;
use warnings;

__PACKAGE__->table('feed_malware');

sub mapIndex {
    my $self = shift;
    my $r = shift;
    my $idx = $self->SUPER::mapIndex($r);
    delete($idx->{'rec'});
    return {
       %$idx,
       hash_sha1    => $r->hash_sha1(),
       hash_md5     => $r->hash_md5(),
    };
}

sub generate {
    my $self = shift;
    my @recs = @_;
    @recs = $self->SUPER::aggregateFeed('hash_md5',@recs);
    @recs = map { $self->mapIndex($_) } @recs;

    return(@recs);
}

1;
