/* c/zx-dap-aux.c - WARNING: This file was auto generated by xsd2sg.pl. DO NOT EDIT!
 * $Id$ */
/* Code generation design Copyright (c) 2006 Sampo Kellomaki (sampo@iki.fi),
 * All Rights Reserved. NO WARRANTY. See file COPYING for terms and conditions
 * of use. Some aspects of code generation were driven by schema
 * descriptions that were used as input and may be subject to their own copyright.
 * Code generation uses a template, whose copyright statement follows. */

/** aux-templ.c  -  Auxiliary functions template: cloning, freeing, walking data
 ** Copyright (c) 2010 Sampo Kellomaki (sampo@iki.fi), All Rights Reserved.
 ** Copyright (c) 2006 Symlabs (symlabs@symlabs.com), All Rights Reserved.
 ** Author: Sampo Kellomaki (sampo@iki.fi)
 ** This is confidential unpublished proprietary source code of the author.
 ** NO WARRANTY, not even implied warranties. Contains trade secrets.
 ** Distribution prohibited unless authorized in writing.
 ** Licensed under Apache License 2.0, see file COPYING.
 ** Id: aux-templ.c,v 1.12 2008-10-04 23:42:14 sampo Exp $
 **
 ** 30.5.2006, created, Sampo Kellomaki (sampo@iki.fi)
 ** 6.8.2006, factored from enc-templ.c to separate file --Sampo
 **
 ** N.B: wo=wire order (needed for exc-c14n), so=schema order
 **/

#include <memory.h>
#include "errmac.h"
#include "zx.h"
#include "c/zx-const.h"
#include "c/zx-data.h"
#include "c/zx-dap-data.h"



#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_Create
#define EL_STRUCT zx_dap_Create_s
#define EL_NS     dap
#define EL_TAG    Create

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_Create) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_Create(struct zx_ctx* c, struct zx_dap_Create_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->itemID);

  for (se = &x->Extension->gg;
       se && se->g.tok == zx_lu_Extension_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Extension(c, (struct zx_lu_Extension_s*)se);
  for (se = &x->Subscription->gg;
       se && se->g.tok == zx_dap_Subscription_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_Subscription(c, (struct zx_dap_Subscription_s*)se);
  for (se = &x->CreateItem->gg;
       se && se->g.tok == zx_dap_CreateItem_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_CreateItem(c, (struct zx_dap_CreateItem_s*)se);
  for (se = &x->ResultQuery->gg;
       se && se->g.tok == zx_dap_ResultQuery_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_ResultQuery(c, (struct zx_dap_ResultQuery_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_Create) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_Create_s* zx_DEEP_CLONE_dap_Create(struct zx_ctx* c, struct zx_dap_Create_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_Create_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_Create_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->itemID = zx_clone_attr(c, x->itemID);

  for (enn = 0, e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Extension(c,(struct zx_lu_Extension_s*)e,dup_strs);
  	  if (!enn)
  	      x->Extension = (struct zx_lu_Extension_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->Subscription->gg;
       e && e->g.tok == zx_dap_Subscription_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_Subscription(c,(struct zx_dap_Subscription_s*)e,dup_strs);
  	  if (!enn)
  	      x->Subscription = (struct zx_dap_Subscription_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->CreateItem->gg;
       e && e->g.tok == zx_dap_CreateItem_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_CreateItem(c,(struct zx_dap_CreateItem_s*)e,dup_strs);
  	  if (!enn)
  	      x->CreateItem = (struct zx_dap_CreateItem_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->ResultQuery->gg;
       e && e->g.tok == zx_dap_ResultQuery_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_ResultQuery(c,(struct zx_dap_ResultQuery_s*)e,dup_strs);
  	  if (!enn)
  	      x->ResultQuery = (struct zx_dap_ResultQuery_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_Create) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_Create(struct zx_ctx* c, struct zx_dap_Create_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Extension(c, (struct zx_lu_Extension_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->Subscription->gg;
       e && e->g.tok == zx_dap_Subscription_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_Subscription(c, (struct zx_dap_Subscription_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->CreateItem->gg;
       e && e->g.tok == zx_dap_CreateItem_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_CreateItem(c, (struct zx_dap_CreateItem_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->ResultQuery->gg;
       e && e->g.tok == zx_dap_ResultQuery_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_ResultQuery(c, (struct zx_dap_ResultQuery_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_Create) */

int zx_WALK_WO_dap_Create(struct zx_ctx* c, struct zx_dap_Create_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_CreateItem
#define EL_STRUCT zx_dap_CreateItem_s
#define EL_NS     dap
#define EL_TAG    CreateItem

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_CreateItem) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_CreateItem(struct zx_ctx* c, struct zx_dap_CreateItem_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->id);
  zx_dup_attr(c, x->itemID);
  zx_dup_attr(c, x->objectType);

  for (se = &x->NewData->gg;
       se && se->g.tok == zx_dap_NewData_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_NewData(c, (struct zx_dap_NewData_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_CreateItem) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_CreateItem_s* zx_DEEP_CLONE_dap_CreateItem(struct zx_ctx* c, struct zx_dap_CreateItem_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_CreateItem_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_CreateItem_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->id = zx_clone_attr(c, x->id);
  x->itemID = zx_clone_attr(c, x->itemID);
  x->objectType = zx_clone_attr(c, x->objectType);

  for (enn = 0, e = &x->NewData->gg;
       e && e->g.tok == zx_dap_NewData_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_NewData(c,(struct zx_dap_NewData_s*)e,dup_strs);
  	  if (!enn)
  	      x->NewData = (struct zx_dap_NewData_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_CreateItem) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_CreateItem(struct zx_ctx* c, struct zx_dap_CreateItem_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->NewData->gg;
       e && e->g.tok == zx_dap_NewData_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_NewData(c, (struct zx_dap_NewData_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_CreateItem) */

int zx_WALK_WO_dap_CreateItem(struct zx_ctx* c, struct zx_dap_CreateItem_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_CreateResponse
#define EL_STRUCT zx_dap_CreateResponse_s
#define EL_NS     dap
#define EL_TAG    CreateResponse

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_CreateResponse) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_CreateResponse(struct zx_ctx* c, struct zx_dap_CreateResponse_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->timeStamp);
  zx_dup_attr(c, x->itemIDRef);

  for (se = &x->Status->gg;
       se && se->g.tok == zx_lu_Status_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Status(c, (struct zx_lu_Status_s*)se);
  for (se = &x->Extension->gg;
       se && se->g.tok == zx_lu_Extension_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Extension(c, (struct zx_lu_Extension_s*)se);
  for (se = &x->ItemData->gg;
       se && se->g.tok == zx_dap_ItemData_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_ItemData(c, (struct zx_dap_ItemData_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_CreateResponse) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_CreateResponse_s* zx_DEEP_CLONE_dap_CreateResponse(struct zx_ctx* c, struct zx_dap_CreateResponse_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_CreateResponse_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_CreateResponse_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->timeStamp = zx_clone_attr(c, x->timeStamp);
  x->itemIDRef = zx_clone_attr(c, x->itemIDRef);

  for (enn = 0, e = &x->Status->gg;
       e && e->g.tok == zx_lu_Status_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Status(c,(struct zx_lu_Status_s*)e,dup_strs);
  	  if (!enn)
  	      x->Status = (struct zx_lu_Status_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Extension(c,(struct zx_lu_Extension_s*)e,dup_strs);
  	  if (!enn)
  	      x->Extension = (struct zx_lu_Extension_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->ItemData->gg;
       e && e->g.tok == zx_dap_ItemData_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_ItemData(c,(struct zx_dap_ItemData_s*)e,dup_strs);
  	  if (!enn)
  	      x->ItemData = (struct zx_dap_ItemData_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_CreateResponse) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_CreateResponse(struct zx_ctx* c, struct zx_dap_CreateResponse_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->Status->gg;
       e && e->g.tok == zx_lu_Status_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Status(c, (struct zx_lu_Status_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Extension(c, (struct zx_lu_Extension_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->ItemData->gg;
       e && e->g.tok == zx_dap_ItemData_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_ItemData(c, (struct zx_dap_ItemData_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_CreateResponse) */

int zx_WALK_WO_dap_CreateResponse(struct zx_ctx* c, struct zx_dap_CreateResponse_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_Data
#define EL_STRUCT zx_dap_Data_s
#define EL_NS     dap
#define EL_TAG    Data

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_Data) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_Data(struct zx_ctx* c, struct zx_dap_Data_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->nextOffset);
  zx_dup_attr(c, x->notSorted);
  zx_dup_attr(c, x->remaining);
  zx_dup_attr(c, x->setID);
  zx_dup_attr(c, x->changeFormat);
  zx_dup_attr(c, x->itemIDRef);

  for (se = &x->LDIF->gg;
       se && se->g.tok == zx_dap_LDIF_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_LDIF(c, (struct zx_dap_LDIF_s*)se);
  for (se = &x->Subscription->gg;
       se && se->g.tok == zx_dap_Subscription_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_Subscription(c, (struct zx_dap_Subscription_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_Data) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_Data_s* zx_DEEP_CLONE_dap_Data(struct zx_ctx* c, struct zx_dap_Data_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_Data_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_Data_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->nextOffset = zx_clone_attr(c, x->nextOffset);
  x->notSorted = zx_clone_attr(c, x->notSorted);
  x->remaining = zx_clone_attr(c, x->remaining);
  x->setID = zx_clone_attr(c, x->setID);
  x->changeFormat = zx_clone_attr(c, x->changeFormat);
  x->itemIDRef = zx_clone_attr(c, x->itemIDRef);

  for (enn = 0, e = &x->LDIF->gg;
       e && e->g.tok == zx_dap_LDIF_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_LDIF(c,(struct zx_dap_LDIF_s*)e,dup_strs);
  	  if (!enn)
  	      x->LDIF = (struct zx_dap_LDIF_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->Subscription->gg;
       e && e->g.tok == zx_dap_Subscription_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_Subscription(c,(struct zx_dap_Subscription_s*)e,dup_strs);
  	  if (!enn)
  	      x->Subscription = (struct zx_dap_Subscription_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_Data) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_Data(struct zx_ctx* c, struct zx_dap_Data_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->LDIF->gg;
       e && e->g.tok == zx_dap_LDIF_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_LDIF(c, (struct zx_dap_LDIF_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->Subscription->gg;
       e && e->g.tok == zx_dap_Subscription_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_Subscription(c, (struct zx_dap_Subscription_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_Data) */

int zx_WALK_WO_dap_Data(struct zx_ctx* c, struct zx_dap_Data_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_Delete
#define EL_STRUCT zx_dap_Delete_s
#define EL_NS     dap
#define EL_TAG    Delete

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_Delete) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_Delete(struct zx_ctx* c, struct zx_dap_Delete_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->itemID);

  for (se = &x->Extension->gg;
       se && se->g.tok == zx_lu_Extension_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Extension(c, (struct zx_lu_Extension_s*)se);
  for (se = &x->DeleteItem->gg;
       se && se->g.tok == zx_dap_DeleteItem_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_DeleteItem(c, (struct zx_dap_DeleteItem_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_Delete) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_Delete_s* zx_DEEP_CLONE_dap_Delete(struct zx_ctx* c, struct zx_dap_Delete_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_Delete_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_Delete_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->itemID = zx_clone_attr(c, x->itemID);

  for (enn = 0, e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Extension(c,(struct zx_lu_Extension_s*)e,dup_strs);
  	  if (!enn)
  	      x->Extension = (struct zx_lu_Extension_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->DeleteItem->gg;
       e && e->g.tok == zx_dap_DeleteItem_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_DeleteItem(c,(struct zx_dap_DeleteItem_s*)e,dup_strs);
  	  if (!enn)
  	      x->DeleteItem = (struct zx_dap_DeleteItem_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_Delete) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_Delete(struct zx_ctx* c, struct zx_dap_Delete_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Extension(c, (struct zx_lu_Extension_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->DeleteItem->gg;
       e && e->g.tok == zx_dap_DeleteItem_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_DeleteItem(c, (struct zx_dap_DeleteItem_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_Delete) */

int zx_WALK_WO_dap_Delete(struct zx_ctx* c, struct zx_dap_Delete_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_DeleteItem
#define EL_STRUCT zx_dap_DeleteItem_s
#define EL_NS     dap
#define EL_TAG    DeleteItem

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_DeleteItem) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_DeleteItem(struct zx_ctx* c, struct zx_dap_DeleteItem_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->id);
  zx_dup_attr(c, x->notChangedSince);
  zx_dup_attr(c, x->itemID);
  zx_dup_attr(c, x->objectType);
  zx_dup_attr(c, x->predefined);

  for (se = &x->Select->gg;
       se && se->g.tok == zx_dap_Select_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_Select(c, (struct zx_dap_Select_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_DeleteItem) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_DeleteItem_s* zx_DEEP_CLONE_dap_DeleteItem(struct zx_ctx* c, struct zx_dap_DeleteItem_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_DeleteItem_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_DeleteItem_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->id = zx_clone_attr(c, x->id);
  x->notChangedSince = zx_clone_attr(c, x->notChangedSince);
  x->itemID = zx_clone_attr(c, x->itemID);
  x->objectType = zx_clone_attr(c, x->objectType);
  x->predefined = zx_clone_attr(c, x->predefined);

  for (enn = 0, e = &x->Select->gg;
       e && e->g.tok == zx_dap_Select_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_Select(c,(struct zx_dap_Select_s*)e,dup_strs);
  	  if (!enn)
  	      x->Select = (struct zx_dap_Select_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_DeleteItem) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_DeleteItem(struct zx_ctx* c, struct zx_dap_DeleteItem_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->Select->gg;
       e && e->g.tok == zx_dap_Select_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_Select(c, (struct zx_dap_Select_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_DeleteItem) */

int zx_WALK_WO_dap_DeleteItem(struct zx_ctx* c, struct zx_dap_DeleteItem_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_DeleteResponse
#define EL_STRUCT zx_dap_DeleteResponse_s
#define EL_NS     dap
#define EL_TAG    DeleteResponse

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_DeleteResponse) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_DeleteResponse(struct zx_ctx* c, struct zx_dap_DeleteResponse_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->itemIDRef);

  for (se = &x->Status->gg;
       se && se->g.tok == zx_lu_Status_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Status(c, (struct zx_lu_Status_s*)se);
  for (se = &x->Extension->gg;
       se && se->g.tok == zx_lu_Extension_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Extension(c, (struct zx_lu_Extension_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_DeleteResponse) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_DeleteResponse_s* zx_DEEP_CLONE_dap_DeleteResponse(struct zx_ctx* c, struct zx_dap_DeleteResponse_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_DeleteResponse_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_DeleteResponse_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->itemIDRef = zx_clone_attr(c, x->itemIDRef);

  for (enn = 0, e = &x->Status->gg;
       e && e->g.tok == zx_lu_Status_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Status(c,(struct zx_lu_Status_s*)e,dup_strs);
  	  if (!enn)
  	      x->Status = (struct zx_lu_Status_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Extension(c,(struct zx_lu_Extension_s*)e,dup_strs);
  	  if (!enn)
  	      x->Extension = (struct zx_lu_Extension_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_DeleteResponse) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_DeleteResponse(struct zx_ctx* c, struct zx_dap_DeleteResponse_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->Status->gg;
       e && e->g.tok == zx_lu_Status_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Status(c, (struct zx_lu_Status_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Extension(c, (struct zx_lu_Extension_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_DeleteResponse) */

int zx_WALK_WO_dap_DeleteResponse(struct zx_ctx* c, struct zx_dap_DeleteResponse_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_ItemData
#define EL_STRUCT zx_dap_ItemData_s
#define EL_NS     dap
#define EL_TAG    ItemData

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_ItemData) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_ItemData(struct zx_ctx* c, struct zx_dap_ItemData_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->notSorted);
  zx_dup_attr(c, x->changeFormat);
  zx_dup_attr(c, x->itemIDRef);

  for (se = &x->LDIF->gg;
       se && se->g.tok == zx_dap_LDIF_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_LDIF(c, (struct zx_dap_LDIF_s*)se);
  for (se = &x->Subscription->gg;
       se && se->g.tok == zx_dap_Subscription_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_Subscription(c, (struct zx_dap_Subscription_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_ItemData) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_ItemData_s* zx_DEEP_CLONE_dap_ItemData(struct zx_ctx* c, struct zx_dap_ItemData_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_ItemData_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_ItemData_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->notSorted = zx_clone_attr(c, x->notSorted);
  x->changeFormat = zx_clone_attr(c, x->changeFormat);
  x->itemIDRef = zx_clone_attr(c, x->itemIDRef);

  for (enn = 0, e = &x->LDIF->gg;
       e && e->g.tok == zx_dap_LDIF_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_LDIF(c,(struct zx_dap_LDIF_s*)e,dup_strs);
  	  if (!enn)
  	      x->LDIF = (struct zx_dap_LDIF_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->Subscription->gg;
       e && e->g.tok == zx_dap_Subscription_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_Subscription(c,(struct zx_dap_Subscription_s*)e,dup_strs);
  	  if (!enn)
  	      x->Subscription = (struct zx_dap_Subscription_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_ItemData) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_ItemData(struct zx_ctx* c, struct zx_dap_ItemData_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->LDIF->gg;
       e && e->g.tok == zx_dap_LDIF_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_LDIF(c, (struct zx_dap_LDIF_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->Subscription->gg;
       e && e->g.tok == zx_dap_Subscription_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_Subscription(c, (struct zx_dap_Subscription_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_ItemData) */

int zx_WALK_WO_dap_ItemData(struct zx_ctx* c, struct zx_dap_ItemData_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_LDIF
#define EL_STRUCT zx_dap_LDIF_s
#define EL_NS     dap
#define EL_TAG    LDIF

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_LDIF) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_LDIF(struct zx_ctx* c, struct zx_dap_LDIF_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->lang);
  zx_dup_attr(c, x->ACC);
  zx_dup_attr(c, x->ACCTime);
  zx_dup_attr(c, x->id);
  zx_dup_attr(c, x->modificationTime);
  zx_dup_attr(c, x->modifier);
  zx_dup_attr(c, x->script);


}

/* FUNC(zx_DEEP_CLONE_dap_LDIF) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_LDIF_s* zx_DEEP_CLONE_dap_LDIF(struct zx_ctx* c, struct zx_dap_LDIF_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_LDIF_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_LDIF_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->lang = zx_clone_attr(c, x->lang);
  x->ACC = zx_clone_attr(c, x->ACC);
  x->ACCTime = zx_clone_attr(c, x->ACCTime);
  x->id = zx_clone_attr(c, x->id);
  x->modificationTime = zx_clone_attr(c, x->modificationTime);
  x->modifier = zx_clone_attr(c, x->modifier);
  x->script = zx_clone_attr(c, x->script);


  return x;
}

/* FUNC(zx_WALK_SO_dap_LDIF) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_LDIF(struct zx_ctx* c, struct zx_dap_LDIF_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;


  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_LDIF) */

int zx_WALK_WO_dap_LDIF(struct zx_ctx* c, struct zx_dap_LDIF_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_Modify
#define EL_STRUCT zx_dap_Modify_s
#define EL_NS     dap
#define EL_TAG    Modify

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_Modify) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_Modify(struct zx_ctx* c, struct zx_dap_Modify_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->itemID);

  for (se = &x->Extension->gg;
       se && se->g.tok == zx_lu_Extension_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Extension(c, (struct zx_lu_Extension_s*)se);
  for (se = &x->Subscription->gg;
       se && se->g.tok == zx_dap_Subscription_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_Subscription(c, (struct zx_dap_Subscription_s*)se);
  for (se = &x->ModifyItem->gg;
       se && se->g.tok == zx_dap_ModifyItem_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_ModifyItem(c, (struct zx_dap_ModifyItem_s*)se);
  for (se = &x->ResultQuery->gg;
       se && se->g.tok == zx_dap_ResultQuery_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_ResultQuery(c, (struct zx_dap_ResultQuery_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_Modify) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_Modify_s* zx_DEEP_CLONE_dap_Modify(struct zx_ctx* c, struct zx_dap_Modify_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_Modify_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_Modify_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->itemID = zx_clone_attr(c, x->itemID);

  for (enn = 0, e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Extension(c,(struct zx_lu_Extension_s*)e,dup_strs);
  	  if (!enn)
  	      x->Extension = (struct zx_lu_Extension_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->Subscription->gg;
       e && e->g.tok == zx_dap_Subscription_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_Subscription(c,(struct zx_dap_Subscription_s*)e,dup_strs);
  	  if (!enn)
  	      x->Subscription = (struct zx_dap_Subscription_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->ModifyItem->gg;
       e && e->g.tok == zx_dap_ModifyItem_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_ModifyItem(c,(struct zx_dap_ModifyItem_s*)e,dup_strs);
  	  if (!enn)
  	      x->ModifyItem = (struct zx_dap_ModifyItem_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->ResultQuery->gg;
       e && e->g.tok == zx_dap_ResultQuery_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_ResultQuery(c,(struct zx_dap_ResultQuery_s*)e,dup_strs);
  	  if (!enn)
  	      x->ResultQuery = (struct zx_dap_ResultQuery_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_Modify) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_Modify(struct zx_ctx* c, struct zx_dap_Modify_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Extension(c, (struct zx_lu_Extension_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->Subscription->gg;
       e && e->g.tok == zx_dap_Subscription_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_Subscription(c, (struct zx_dap_Subscription_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->ModifyItem->gg;
       e && e->g.tok == zx_dap_ModifyItem_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_ModifyItem(c, (struct zx_dap_ModifyItem_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->ResultQuery->gg;
       e && e->g.tok == zx_dap_ResultQuery_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_ResultQuery(c, (struct zx_dap_ResultQuery_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_Modify) */

int zx_WALK_WO_dap_Modify(struct zx_ctx* c, struct zx_dap_Modify_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_ModifyItem
#define EL_STRUCT zx_dap_ModifyItem_s
#define EL_NS     dap
#define EL_TAG    ModifyItem

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_ModifyItem) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_ModifyItem(struct zx_ctx* c, struct zx_dap_ModifyItem_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->id);
  zx_dup_attr(c, x->notChangedSince);
  zx_dup_attr(c, x->overrideAllowed);
  zx_dup_attr(c, x->itemID);
  zx_dup_attr(c, x->objectType);
  zx_dup_attr(c, x->predefined);

  for (se = &x->Select->gg;
       se && se->g.tok == zx_dap_Select_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_Select(c, (struct zx_dap_Select_s*)se);
  for (se = &x->NewData->gg;
       se && se->g.tok == zx_dap_NewData_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_NewData(c, (struct zx_dap_NewData_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_ModifyItem) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_ModifyItem_s* zx_DEEP_CLONE_dap_ModifyItem(struct zx_ctx* c, struct zx_dap_ModifyItem_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_ModifyItem_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_ModifyItem_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->id = zx_clone_attr(c, x->id);
  x->notChangedSince = zx_clone_attr(c, x->notChangedSince);
  x->overrideAllowed = zx_clone_attr(c, x->overrideAllowed);
  x->itemID = zx_clone_attr(c, x->itemID);
  x->objectType = zx_clone_attr(c, x->objectType);
  x->predefined = zx_clone_attr(c, x->predefined);

  for (enn = 0, e = &x->Select->gg;
       e && e->g.tok == zx_dap_Select_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_Select(c,(struct zx_dap_Select_s*)e,dup_strs);
  	  if (!enn)
  	      x->Select = (struct zx_dap_Select_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->NewData->gg;
       e && e->g.tok == zx_dap_NewData_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_NewData(c,(struct zx_dap_NewData_s*)e,dup_strs);
  	  if (!enn)
  	      x->NewData = (struct zx_dap_NewData_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_ModifyItem) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_ModifyItem(struct zx_ctx* c, struct zx_dap_ModifyItem_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->Select->gg;
       e && e->g.tok == zx_dap_Select_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_Select(c, (struct zx_dap_Select_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->NewData->gg;
       e && e->g.tok == zx_dap_NewData_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_NewData(c, (struct zx_dap_NewData_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_ModifyItem) */

int zx_WALK_WO_dap_ModifyItem(struct zx_ctx* c, struct zx_dap_ModifyItem_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_ModifyResponse
#define EL_STRUCT zx_dap_ModifyResponse_s
#define EL_NS     dap
#define EL_TAG    ModifyResponse

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_ModifyResponse) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_ModifyResponse(struct zx_ctx* c, struct zx_dap_ModifyResponse_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->timeStamp);
  zx_dup_attr(c, x->itemIDRef);

  for (se = &x->Status->gg;
       se && se->g.tok == zx_lu_Status_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Status(c, (struct zx_lu_Status_s*)se);
  for (se = &x->Extension->gg;
       se && se->g.tok == zx_lu_Extension_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Extension(c, (struct zx_lu_Extension_s*)se);
  for (se = &x->ItemData->gg;
       se && se->g.tok == zx_dap_ItemData_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_ItemData(c, (struct zx_dap_ItemData_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_ModifyResponse) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_ModifyResponse_s* zx_DEEP_CLONE_dap_ModifyResponse(struct zx_ctx* c, struct zx_dap_ModifyResponse_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_ModifyResponse_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_ModifyResponse_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->timeStamp = zx_clone_attr(c, x->timeStamp);
  x->itemIDRef = zx_clone_attr(c, x->itemIDRef);

  for (enn = 0, e = &x->Status->gg;
       e && e->g.tok == zx_lu_Status_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Status(c,(struct zx_lu_Status_s*)e,dup_strs);
  	  if (!enn)
  	      x->Status = (struct zx_lu_Status_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Extension(c,(struct zx_lu_Extension_s*)e,dup_strs);
  	  if (!enn)
  	      x->Extension = (struct zx_lu_Extension_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->ItemData->gg;
       e && e->g.tok == zx_dap_ItemData_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_ItemData(c,(struct zx_dap_ItemData_s*)e,dup_strs);
  	  if (!enn)
  	      x->ItemData = (struct zx_dap_ItemData_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_ModifyResponse) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_ModifyResponse(struct zx_ctx* c, struct zx_dap_ModifyResponse_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->Status->gg;
       e && e->g.tok == zx_lu_Status_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Status(c, (struct zx_lu_Status_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Extension(c, (struct zx_lu_Extension_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->ItemData->gg;
       e && e->g.tok == zx_dap_ItemData_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_ItemData(c, (struct zx_dap_ItemData_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_ModifyResponse) */

int zx_WALK_WO_dap_ModifyResponse(struct zx_ctx* c, struct zx_dap_ModifyResponse_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_NewData
#define EL_STRUCT zx_dap_NewData_s
#define EL_NS     dap
#define EL_TAG    NewData

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_NewData) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_NewData(struct zx_ctx* c, struct zx_dap_NewData_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */


  for (se = &x->LDIF->gg;
       se && se->g.tok == zx_dap_LDIF_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_LDIF(c, (struct zx_dap_LDIF_s*)se);
  for (se = &x->Subscription->gg;
       se && se->g.tok == zx_dap_Subscription_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_Subscription(c, (struct zx_dap_Subscription_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_NewData) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_NewData_s* zx_DEEP_CLONE_dap_NewData(struct zx_ctx* c, struct zx_dap_NewData_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_NewData_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_NewData_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */


  for (enn = 0, e = &x->LDIF->gg;
       e && e->g.tok == zx_dap_LDIF_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_LDIF(c,(struct zx_dap_LDIF_s*)e,dup_strs);
  	  if (!enn)
  	      x->LDIF = (struct zx_dap_LDIF_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->Subscription->gg;
       e && e->g.tok == zx_dap_Subscription_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_Subscription(c,(struct zx_dap_Subscription_s*)e,dup_strs);
  	  if (!enn)
  	      x->Subscription = (struct zx_dap_Subscription_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_NewData) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_NewData(struct zx_ctx* c, struct zx_dap_NewData_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->LDIF->gg;
       e && e->g.tok == zx_dap_LDIF_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_LDIF(c, (struct zx_dap_LDIF_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->Subscription->gg;
       e && e->g.tok == zx_dap_Subscription_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_Subscription(c, (struct zx_dap_Subscription_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_NewData) */

int zx_WALK_WO_dap_NewData(struct zx_ctx* c, struct zx_dap_NewData_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_Notification
#define EL_STRUCT zx_dap_Notification_s
#define EL_NS     dap
#define EL_TAG    Notification

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_Notification) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_Notification(struct zx_ctx* c, struct zx_dap_Notification_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->endReason);
  zx_dup_attr(c, x->expires);
  zx_dup_attr(c, x->id);
  zx_dup_attr(c, x->subscriptionID);

  for (se = &x->TestResult->gg;
       se && se->g.tok == zx_lu_TestResult_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_TestResult(c, (struct zx_lu_TestResult_s*)se);
  for (se = &x->ItemData->gg;
       se && se->g.tok == zx_dap_ItemData_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_ItemData(c, (struct zx_dap_ItemData_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_Notification) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_Notification_s* zx_DEEP_CLONE_dap_Notification(struct zx_ctx* c, struct zx_dap_Notification_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_Notification_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_Notification_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->endReason = zx_clone_attr(c, x->endReason);
  x->expires = zx_clone_attr(c, x->expires);
  x->id = zx_clone_attr(c, x->id);
  x->subscriptionID = zx_clone_attr(c, x->subscriptionID);

  for (enn = 0, e = &x->TestResult->gg;
       e && e->g.tok == zx_lu_TestResult_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_TestResult(c,(struct zx_lu_TestResult_s*)e,dup_strs);
  	  if (!enn)
  	      x->TestResult = (struct zx_lu_TestResult_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->ItemData->gg;
       e && e->g.tok == zx_dap_ItemData_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_ItemData(c,(struct zx_dap_ItemData_s*)e,dup_strs);
  	  if (!enn)
  	      x->ItemData = (struct zx_dap_ItemData_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_Notification) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_Notification(struct zx_ctx* c, struct zx_dap_Notification_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->TestResult->gg;
       e && e->g.tok == zx_lu_TestResult_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_TestResult(c, (struct zx_lu_TestResult_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->ItemData->gg;
       e && e->g.tok == zx_dap_ItemData_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_ItemData(c, (struct zx_dap_ItemData_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_Notification) */

int zx_WALK_WO_dap_Notification(struct zx_ctx* c, struct zx_dap_Notification_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_Notify
#define EL_STRUCT zx_dap_Notify_s
#define EL_NS     dap
#define EL_TAG    Notify

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_Notify) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_Notify(struct zx_ctx* c, struct zx_dap_Notify_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->timeStamp);
  zx_dup_attr(c, x->itemID);

  for (se = &x->Extension->gg;
       se && se->g.tok == zx_lu_Extension_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Extension(c, (struct zx_lu_Extension_s*)se);
  for (se = &x->Notification->gg;
       se && se->g.tok == zx_dap_Notification_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_Notification(c, (struct zx_dap_Notification_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_Notify) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_Notify_s* zx_DEEP_CLONE_dap_Notify(struct zx_ctx* c, struct zx_dap_Notify_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_Notify_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_Notify_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->timeStamp = zx_clone_attr(c, x->timeStamp);
  x->itemID = zx_clone_attr(c, x->itemID);

  for (enn = 0, e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Extension(c,(struct zx_lu_Extension_s*)e,dup_strs);
  	  if (!enn)
  	      x->Extension = (struct zx_lu_Extension_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->Notification->gg;
       e && e->g.tok == zx_dap_Notification_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_Notification(c,(struct zx_dap_Notification_s*)e,dup_strs);
  	  if (!enn)
  	      x->Notification = (struct zx_dap_Notification_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_Notify) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_Notify(struct zx_ctx* c, struct zx_dap_Notify_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Extension(c, (struct zx_lu_Extension_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->Notification->gg;
       e && e->g.tok == zx_dap_Notification_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_Notification(c, (struct zx_dap_Notification_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_Notify) */

int zx_WALK_WO_dap_Notify(struct zx_ctx* c, struct zx_dap_Notify_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_NotifyResponse
#define EL_STRUCT zx_dap_NotifyResponse_s
#define EL_NS     dap
#define EL_TAG    NotifyResponse

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_NotifyResponse) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_NotifyResponse(struct zx_ctx* c, struct zx_dap_NotifyResponse_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->itemIDRef);

  for (se = &x->Status->gg;
       se && se->g.tok == zx_lu_Status_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Status(c, (struct zx_lu_Status_s*)se);
  for (se = &x->Extension->gg;
       se && se->g.tok == zx_lu_Extension_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Extension(c, (struct zx_lu_Extension_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_NotifyResponse) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_NotifyResponse_s* zx_DEEP_CLONE_dap_NotifyResponse(struct zx_ctx* c, struct zx_dap_NotifyResponse_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_NotifyResponse_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_NotifyResponse_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->itemIDRef = zx_clone_attr(c, x->itemIDRef);

  for (enn = 0, e = &x->Status->gg;
       e && e->g.tok == zx_lu_Status_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Status(c,(struct zx_lu_Status_s*)e,dup_strs);
  	  if (!enn)
  	      x->Status = (struct zx_lu_Status_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Extension(c,(struct zx_lu_Extension_s*)e,dup_strs);
  	  if (!enn)
  	      x->Extension = (struct zx_lu_Extension_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_NotifyResponse) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_NotifyResponse(struct zx_ctx* c, struct zx_dap_NotifyResponse_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->Status->gg;
       e && e->g.tok == zx_lu_Status_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Status(c, (struct zx_lu_Status_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Extension(c, (struct zx_lu_Extension_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_NotifyResponse) */

int zx_WALK_WO_dap_NotifyResponse(struct zx_ctx* c, struct zx_dap_NotifyResponse_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_Query
#define EL_STRUCT zx_dap_Query_s
#define EL_NS     dap
#define EL_TAG    Query

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_Query) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_Query(struct zx_ctx* c, struct zx_dap_Query_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->itemID);

  for (se = &x->Extension->gg;
       se && se->g.tok == zx_lu_Extension_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Extension(c, (struct zx_lu_Extension_s*)se);
  for (se = &x->TestItem->gg;
       se && se->g.tok == zx_dap_TestItem_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_TestItem(c, (struct zx_dap_TestItem_s*)se);
  for (se = &x->QueryItem->gg;
       se && se->g.tok == zx_dap_QueryItem_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_QueryItem(c, (struct zx_dap_QueryItem_s*)se);
  for (se = &x->Subscription->gg;
       se && se->g.tok == zx_dap_Subscription_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_Subscription(c, (struct zx_dap_Subscription_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_Query) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_Query_s* zx_DEEP_CLONE_dap_Query(struct zx_ctx* c, struct zx_dap_Query_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_Query_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_Query_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->itemID = zx_clone_attr(c, x->itemID);

  for (enn = 0, e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Extension(c,(struct zx_lu_Extension_s*)e,dup_strs);
  	  if (!enn)
  	      x->Extension = (struct zx_lu_Extension_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->TestItem->gg;
       e && e->g.tok == zx_dap_TestItem_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_TestItem(c,(struct zx_dap_TestItem_s*)e,dup_strs);
  	  if (!enn)
  	      x->TestItem = (struct zx_dap_TestItem_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->QueryItem->gg;
       e && e->g.tok == zx_dap_QueryItem_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_QueryItem(c,(struct zx_dap_QueryItem_s*)e,dup_strs);
  	  if (!enn)
  	      x->QueryItem = (struct zx_dap_QueryItem_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->Subscription->gg;
       e && e->g.tok == zx_dap_Subscription_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_Subscription(c,(struct zx_dap_Subscription_s*)e,dup_strs);
  	  if (!enn)
  	      x->Subscription = (struct zx_dap_Subscription_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_Query) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_Query(struct zx_ctx* c, struct zx_dap_Query_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Extension(c, (struct zx_lu_Extension_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->TestItem->gg;
       e && e->g.tok == zx_dap_TestItem_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_TestItem(c, (struct zx_dap_TestItem_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->QueryItem->gg;
       e && e->g.tok == zx_dap_QueryItem_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_QueryItem(c, (struct zx_dap_QueryItem_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->Subscription->gg;
       e && e->g.tok == zx_dap_Subscription_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_Subscription(c, (struct zx_dap_Subscription_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_Query) */

int zx_WALK_WO_dap_Query(struct zx_ctx* c, struct zx_dap_Query_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_QueryItem
#define EL_STRUCT zx_dap_QueryItem_s
#define EL_NS     dap
#define EL_TAG    QueryItem

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_QueryItem) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_QueryItem(struct zx_ctx* c, struct zx_dap_QueryItem_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->changedSince);
  zx_dup_attr(c, x->contingency);
  zx_dup_attr(c, x->count);
  zx_dup_attr(c, x->includeCommonAttributes);
  zx_dup_attr(c, x->offset);
  zx_dup_attr(c, x->setID);
  zx_dup_attr(c, x->setReq);
  zx_dup_attr(c, x->itemID);
  zx_dup_attr(c, x->itemIDRef);
  zx_dup_attr(c, x->objectType);
  zx_dup_attr(c, x->predefined);

  zx_dup_strs_simple_elems(c, x->ChangeFormat);
  for (se = &x->Select->gg;
       se && se->g.tok == zx_dap_Select_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_Select(c, (struct zx_dap_Select_s*)se);
  zx_dup_strs_simple_elems(c, x->Sort);

}

/* FUNC(zx_DEEP_CLONE_dap_QueryItem) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_QueryItem_s* zx_DEEP_CLONE_dap_QueryItem(struct zx_ctx* c, struct zx_dap_QueryItem_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_QueryItem_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_QueryItem_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->changedSince = zx_clone_attr(c, x->changedSince);
  x->contingency = zx_clone_attr(c, x->contingency);
  x->count = zx_clone_attr(c, x->count);
  x->includeCommonAttributes = zx_clone_attr(c, x->includeCommonAttributes);
  x->offset = zx_clone_attr(c, x->offset);
  x->setID = zx_clone_attr(c, x->setID);
  x->setReq = zx_clone_attr(c, x->setReq);
  x->itemID = zx_clone_attr(c, x->itemID);
  x->itemIDRef = zx_clone_attr(c, x->itemIDRef);
  x->objectType = zx_clone_attr(c, x->objectType);
  x->predefined = zx_clone_attr(c, x->predefined);

  x->ChangeFormat = zx_deep_clone_simple_elems(c,x->ChangeFormat, dup_strs);
  for (enn = 0, e = &x->Select->gg;
       e && e->g.tok == zx_dap_Select_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_Select(c,(struct zx_dap_Select_s*)e,dup_strs);
  	  if (!enn)
  	      x->Select = (struct zx_dap_Select_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  x->Sort = zx_deep_clone_simple_elems(c,x->Sort, dup_strs);

  return x;
}

/* FUNC(zx_WALK_SO_dap_QueryItem) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_QueryItem(struct zx_ctx* c, struct zx_dap_QueryItem_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  ret = zx_walk_so_simple_elems(c, x->ChangeFormat, ctx, callback);
  if (ret)
    return ret;
  for (e = &x->Select->gg;
       e && e->g.tok == zx_dap_Select_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_Select(c, (struct zx_dap_Select_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  ret = zx_walk_so_simple_elems(c, x->Sort, ctx, callback);
  if (ret)
    return ret;

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_QueryItem) */

int zx_WALK_WO_dap_QueryItem(struct zx_ctx* c, struct zx_dap_QueryItem_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_QueryResponse
#define EL_STRUCT zx_dap_QueryResponse_s
#define EL_NS     dap
#define EL_TAG    QueryResponse

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_QueryResponse) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_QueryResponse(struct zx_ctx* c, struct zx_dap_QueryResponse_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->timeStamp);
  zx_dup_attr(c, x->itemIDRef);

  for (se = &x->Status->gg;
       se && se->g.tok == zx_lu_Status_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Status(c, (struct zx_lu_Status_s*)se);
  for (se = &x->Extension->gg;
       se && se->g.tok == zx_lu_Extension_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Extension(c, (struct zx_lu_Extension_s*)se);
  for (se = &x->TestResult->gg;
       se && se->g.tok == zx_dst_TestResult_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dst_TestResult(c, (struct zx_dst_TestResult_s*)se);
  for (se = &x->Data->gg;
       se && se->g.tok == zx_dap_Data_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_Data(c, (struct zx_dap_Data_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_QueryResponse) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_QueryResponse_s* zx_DEEP_CLONE_dap_QueryResponse(struct zx_ctx* c, struct zx_dap_QueryResponse_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_QueryResponse_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_QueryResponse_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->timeStamp = zx_clone_attr(c, x->timeStamp);
  x->itemIDRef = zx_clone_attr(c, x->itemIDRef);

  for (enn = 0, e = &x->Status->gg;
       e && e->g.tok == zx_lu_Status_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Status(c,(struct zx_lu_Status_s*)e,dup_strs);
  	  if (!enn)
  	      x->Status = (struct zx_lu_Status_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Extension(c,(struct zx_lu_Extension_s*)e,dup_strs);
  	  if (!enn)
  	      x->Extension = (struct zx_lu_Extension_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->TestResult->gg;
       e && e->g.tok == zx_dst_TestResult_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dst_TestResult(c,(struct zx_dst_TestResult_s*)e,dup_strs);
  	  if (!enn)
  	      x->TestResult = (struct zx_dst_TestResult_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->Data->gg;
       e && e->g.tok == zx_dap_Data_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_Data(c,(struct zx_dap_Data_s*)e,dup_strs);
  	  if (!enn)
  	      x->Data = (struct zx_dap_Data_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_QueryResponse) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_QueryResponse(struct zx_ctx* c, struct zx_dap_QueryResponse_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->Status->gg;
       e && e->g.tok == zx_lu_Status_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Status(c, (struct zx_lu_Status_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Extension(c, (struct zx_lu_Extension_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->TestResult->gg;
       e && e->g.tok == zx_dst_TestResult_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dst_TestResult(c, (struct zx_dst_TestResult_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->Data->gg;
       e && e->g.tok == zx_dap_Data_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_Data(c, (struct zx_dap_Data_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_QueryResponse) */

int zx_WALK_WO_dap_QueryResponse(struct zx_ctx* c, struct zx_dap_QueryResponse_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_ResultQuery
#define EL_STRUCT zx_dap_ResultQuery_s
#define EL_NS     dap
#define EL_TAG    ResultQuery

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_ResultQuery) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_ResultQuery(struct zx_ctx* c, struct zx_dap_ResultQuery_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->changedSince);
  zx_dup_attr(c, x->contingency);
  zx_dup_attr(c, x->includeCommonAttributes);
  zx_dup_attr(c, x->itemID);
  zx_dup_attr(c, x->itemIDRef);
  zx_dup_attr(c, x->objectType);
  zx_dup_attr(c, x->predefined);

  zx_dup_strs_simple_elems(c, x->ChangeFormat);
  for (se = &x->Select->gg;
       se && se->g.tok == zx_dap_Select_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_Select(c, (struct zx_dap_Select_s*)se);
  zx_dup_strs_simple_elems(c, x->Sort);

}

/* FUNC(zx_DEEP_CLONE_dap_ResultQuery) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_ResultQuery_s* zx_DEEP_CLONE_dap_ResultQuery(struct zx_ctx* c, struct zx_dap_ResultQuery_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_ResultQuery_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_ResultQuery_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->changedSince = zx_clone_attr(c, x->changedSince);
  x->contingency = zx_clone_attr(c, x->contingency);
  x->includeCommonAttributes = zx_clone_attr(c, x->includeCommonAttributes);
  x->itemID = zx_clone_attr(c, x->itemID);
  x->itemIDRef = zx_clone_attr(c, x->itemIDRef);
  x->objectType = zx_clone_attr(c, x->objectType);
  x->predefined = zx_clone_attr(c, x->predefined);

  x->ChangeFormat = zx_deep_clone_simple_elems(c,x->ChangeFormat, dup_strs);
  for (enn = 0, e = &x->Select->gg;
       e && e->g.tok == zx_dap_Select_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_Select(c,(struct zx_dap_Select_s*)e,dup_strs);
  	  if (!enn)
  	      x->Select = (struct zx_dap_Select_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  x->Sort = zx_deep_clone_simple_elems(c,x->Sort, dup_strs);

  return x;
}

/* FUNC(zx_WALK_SO_dap_ResultQuery) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_ResultQuery(struct zx_ctx* c, struct zx_dap_ResultQuery_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  ret = zx_walk_so_simple_elems(c, x->ChangeFormat, ctx, callback);
  if (ret)
    return ret;
  for (e = &x->Select->gg;
       e && e->g.tok == zx_dap_Select_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_Select(c, (struct zx_dap_Select_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  ret = zx_walk_so_simple_elems(c, x->Sort, ctx, callback);
  if (ret)
    return ret;

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_ResultQuery) */

int zx_WALK_WO_dap_ResultQuery(struct zx_ctx* c, struct zx_dap_ResultQuery_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_Select
#define EL_STRUCT zx_dap_Select_s
#define EL_NS     dap
#define EL_TAG    Select

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_Select) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_Select(struct zx_ctx* c, struct zx_dap_Select_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->attributes);
  zx_dup_attr(c, x->derefaliases);
  zx_dup_attr(c, x->scope);
  zx_dup_attr(c, x->sizelimit);
  zx_dup_attr(c, x->timelimit);
  zx_dup_attr(c, x->typesonly);

  zx_dup_strs_simple_elems(c, x->dn);
  zx_dup_strs_simple_elems(c, x->filter);

}

/* FUNC(zx_DEEP_CLONE_dap_Select) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_Select_s* zx_DEEP_CLONE_dap_Select(struct zx_ctx* c, struct zx_dap_Select_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_Select_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_Select_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->attributes = zx_clone_attr(c, x->attributes);
  x->derefaliases = zx_clone_attr(c, x->derefaliases);
  x->scope = zx_clone_attr(c, x->scope);
  x->sizelimit = zx_clone_attr(c, x->sizelimit);
  x->timelimit = zx_clone_attr(c, x->timelimit);
  x->typesonly = zx_clone_attr(c, x->typesonly);

  x->dn = zx_deep_clone_simple_elems(c,x->dn, dup_strs);
  x->filter = zx_deep_clone_simple_elems(c,x->filter, dup_strs);

  return x;
}

/* FUNC(zx_WALK_SO_dap_Select) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_Select(struct zx_ctx* c, struct zx_dap_Select_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  ret = zx_walk_so_simple_elems(c, x->dn, ctx, callback);
  if (ret)
    return ret;
  ret = zx_walk_so_simple_elems(c, x->filter, ctx, callback);
  if (ret)
    return ret;

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_Select) */

int zx_WALK_WO_dap_Select(struct zx_ctx* c, struct zx_dap_Select_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_Subscription
#define EL_STRUCT zx_dap_Subscription_s
#define EL_NS     dap
#define EL_TAG    Subscription

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_Subscription) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_Subscription(struct zx_ctx* c, struct zx_dap_Subscription_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->adminNotifyToRef);
  zx_dup_attr(c, x->expires);
  zx_dup_attr(c, x->id);
  zx_dup_attr(c, x->includeData);
  zx_dup_attr(c, x->notifyToRef);
  zx_dup_attr(c, x->starts);
  zx_dup_attr(c, x->subscriptionID);

  for (se = &x->RefItem->gg;
       se && se->g.tok == zx_subs_RefItem_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_subs_RefItem(c, (struct zx_subs_RefItem_s*)se);
  for (se = &x->Extension->gg;
       se && se->g.tok == zx_lu_Extension_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_lu_Extension(c, (struct zx_lu_Extension_s*)se);
  for (se = &x->ResultQuery->gg;
       se && se->g.tok == zx_dap_ResultQuery_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_ResultQuery(c, (struct zx_dap_ResultQuery_s*)se);
  zx_dup_strs_simple_elems(c, x->Aggregation);
  zx_dup_strs_simple_elems(c, x->Trigger);

}

/* FUNC(zx_DEEP_CLONE_dap_Subscription) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_Subscription_s* zx_DEEP_CLONE_dap_Subscription(struct zx_ctx* c, struct zx_dap_Subscription_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_Subscription_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_Subscription_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->adminNotifyToRef = zx_clone_attr(c, x->adminNotifyToRef);
  x->expires = zx_clone_attr(c, x->expires);
  x->id = zx_clone_attr(c, x->id);
  x->includeData = zx_clone_attr(c, x->includeData);
  x->notifyToRef = zx_clone_attr(c, x->notifyToRef);
  x->starts = zx_clone_attr(c, x->starts);
  x->subscriptionID = zx_clone_attr(c, x->subscriptionID);

  for (enn = 0, e = &x->RefItem->gg;
       e && e->g.tok == zx_subs_RefItem_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_subs_RefItem(c,(struct zx_subs_RefItem_s*)e,dup_strs);
  	  if (!enn)
  	      x->RefItem = (struct zx_subs_RefItem_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_lu_Extension(c,(struct zx_lu_Extension_s*)e,dup_strs);
  	  if (!enn)
  	      x->Extension = (struct zx_lu_Extension_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  for (enn = 0, e = &x->ResultQuery->gg;
       e && e->g.tok == zx_dap_ResultQuery_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_ResultQuery(c,(struct zx_dap_ResultQuery_s*)e,dup_strs);
  	  if (!enn)
  	      x->ResultQuery = (struct zx_dap_ResultQuery_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }
  x->Aggregation = zx_deep_clone_simple_elems(c,x->Aggregation, dup_strs);
  x->Trigger = zx_deep_clone_simple_elems(c,x->Trigger, dup_strs);

  return x;
}

/* FUNC(zx_WALK_SO_dap_Subscription) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_Subscription(struct zx_ctx* c, struct zx_dap_Subscription_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->RefItem->gg;
       e && e->g.tok == zx_subs_RefItem_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_subs_RefItem(c, (struct zx_subs_RefItem_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->Extension->gg;
       e && e->g.tok == zx_lu_Extension_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_lu_Extension(c, (struct zx_lu_Extension_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  for (e = &x->ResultQuery->gg;
       e && e->g.tok == zx_dap_ResultQuery_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_ResultQuery(c, (struct zx_dap_ResultQuery_s*)e, ctx, callback);
    if (ret)
      return ret;
  }
  ret = zx_walk_so_simple_elems(c, x->Aggregation, ctx, callback);
  if (ret)
    return ret;
  ret = zx_walk_so_simple_elems(c, x->Trigger, ctx, callback);
  if (ret)
    return ret;

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_Subscription) */

int zx_WALK_WO_dap_Subscription(struct zx_ctx* c, struct zx_dap_Subscription_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_TestItem
#define EL_STRUCT zx_dap_TestItem_s
#define EL_NS     dap
#define EL_TAG    TestItem

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_TestItem) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_TestItem(struct zx_ctx* c, struct zx_dap_TestItem_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->id);
  zx_dup_attr(c, x->itemID);
  zx_dup_attr(c, x->objectType);
  zx_dup_attr(c, x->predefined);

  for (se = &x->TestOp->gg;
       se && se->g.tok == zx_dap_TestOp_ELEM;
       se = (struct zx_elem_s*)se->g.n)
    zx_DUP_STRS_dap_TestOp(c, (struct zx_dap_TestOp_s*)se);

}

/* FUNC(zx_DEEP_CLONE_dap_TestItem) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_TestItem_s* zx_DEEP_CLONE_dap_TestItem(struct zx_ctx* c, struct zx_dap_TestItem_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_TestItem_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_TestItem_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->id = zx_clone_attr(c, x->id);
  x->itemID = zx_clone_attr(c, x->itemID);
  x->objectType = zx_clone_attr(c, x->objectType);
  x->predefined = zx_clone_attr(c, x->predefined);

  for (enn = 0, e = &x->TestOp->gg;
       e && e->g.tok == zx_dap_TestOp_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
  	  en=(struct zx_elem_s*)zx_DEEP_CLONE_dap_TestOp(c,(struct zx_dap_TestOp_s*)e,dup_strs);
  	  if (!enn)
  	      x->TestOp = (struct zx_dap_TestOp_s*)en;
  	  else
  	      enn->g.n = &en->g;
  	  enn = en;
  }

  return x;
}

/* FUNC(zx_WALK_SO_dap_TestItem) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_TestItem(struct zx_ctx* c, struct zx_dap_TestItem_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  for (e = &x->TestOp->gg;
       e && e->g.tok == zx_dap_TestOp_ELEM;
       e = (struct zx_elem_s*)e->g.n) {
    ret = zx_WALK_SO_dap_TestOp(c, (struct zx_dap_TestOp_s*)e, ctx, callback);
    if (ret)
      return ret;
  }

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_TestItem) */

int zx_WALK_WO_dap_TestItem(struct zx_ctx* c, struct zx_dap_TestItem_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif




#ifdef EL_NAME
#undef EL_NAME
#endif
#ifdef EL_STRUCT
#undef EL_STRUCT
#endif
#ifdef EL_NS
#undef EL_NS
#endif
#ifdef EL_TAG
#undef EL_TAG
#endif

#define EL_NAME   dap_TestOp
#define EL_STRUCT zx_dap_TestOp_s
#define EL_NS     dap
#define EL_TAG    TestOp

#ifdef ZX_ENA_AUX

/* FUNC(zx_DUP_STRS_dap_TestOp) */

/* Depth first traversal of data structure to copy its simple strings
 * to memory allocated from the memory allocator. The decoder will
 * use the underlying wireprotocol PDU buffer for strings, i.e.
 * strings are not copied - they point to the real data. If the
 * datastructure needs to outlast the protocol data or needs a different
 * memory allocation strategy, you need to call this function.  */

/* Called by: */
void zx_DUP_STRS_dap_TestOp(struct zx_ctx* c, struct zx_dap_TestOp_s* x)
{
  struct zx_elem_s* se  MAYBE_UNUSED;
  zx_dup_strs_common(c, &x->gg);
  /* *** deal with xmlns specifications in exc c14n way */

  zx_dup_attr(c, x->attributes);
  zx_dup_attr(c, x->derefaliases);
  zx_dup_attr(c, x->scope);
  zx_dup_attr(c, x->sizelimit);
  zx_dup_attr(c, x->timelimit);
  zx_dup_attr(c, x->typesonly);

  zx_dup_strs_simple_elems(c, x->dn);
  zx_dup_strs_simple_elems(c, x->filter);

}

/* FUNC(zx_DEEP_CLONE_dap_TestOp) */

/* Depth first traversal of data structure to clone it and its sublements.
 * The simple strings are handled as a special case according to dup_strs flag. */

/* Called by: */
struct zx_dap_TestOp_s* zx_DEEP_CLONE_dap_TestOp(struct zx_ctx* c, struct zx_dap_TestOp_s* x, int dup_strs)
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  struct zx_elem_s* en  MAYBE_UNUSED;
  struct zx_elem_s* enn MAYBE_UNUSED;

  x = (struct zx_dap_TestOp_s*)zx_clone_elem_common(c, &x->gg, sizeof(struct zx_dap_TestOp_s), dup_strs);
  /* *** deal with xmlns specifications in exc c14n way */

  x->attributes = zx_clone_attr(c, x->attributes);
  x->derefaliases = zx_clone_attr(c, x->derefaliases);
  x->scope = zx_clone_attr(c, x->scope);
  x->sizelimit = zx_clone_attr(c, x->sizelimit);
  x->timelimit = zx_clone_attr(c, x->timelimit);
  x->typesonly = zx_clone_attr(c, x->typesonly);

  x->dn = zx_deep_clone_simple_elems(c,x->dn, dup_strs);
  x->filter = zx_deep_clone_simple_elems(c,x->filter, dup_strs);

  return x;
}

/* FUNC(zx_WALK_SO_dap_TestOp) */

/* Depth first traversal of the tree in either schema order or the wire order. */
 
int zx_WALK_SO_dap_TestOp(struct zx_ctx* c, struct zx_dap_TestOp_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  struct zx_elem_s* e   MAYBE_UNUSED;
  int ret = callback(&x->gg.g, ctx);
  if (ret)
    return ret;
  
  /* *** deal with xmlns specifications in exc c14n way */


  
  ret = zx_walk_so_unknown_attributes(c, &x->gg, ctx, callback); 
  if (ret)
    return ret;

  ret = zx_walk_so_simple_elems(c, x->dn, ctx, callback);
  if (ret)
    return ret;
  ret = zx_walk_so_simple_elems(c, x->filter, ctx, callback);
  if (ret)
    return ret;

  
  return zx_walk_so_unknown_elems_and_content(c, &x->gg, ctx, callback);
}

/* FUNC(zx_WALK_WO_dap_TestOp) */

int zx_WALK_WO_dap_TestOp(struct zx_ctx* c, struct zx_dap_TestOp_s* x, void* ctx, int (*callback)(struct zx_node_s* node, void* ctx))
{
  ERR("*** walk_wo not implemented %d", 0);
  return 0;
}

#endif


/* EOF -- c/zx-dap-aux.c */
