# Load the Module::Install bundled in ./inc/
use inc::Module::Install;
use Config;
use POSIX qw/strftime/;

if ($^O eq 'cygwin' || $^O eq 'MSWin32' || $^O eq 'MSWin64') {
   $ENV{'CYGWIN'}='nodosfilewarning' if $^O eq 'cygwin';
}
configure_requires 'LWP' => '0';

BEGIN {
   unshift @ExtUtils::MakeMaker::Overridable, 'pm_to_blib';
};

use fai::Term::Menus;

my $process_id='';
$process_id=pop @ARGV if $ARGV[$#ARGV-1]=~/^\d+$/;
my $install_cygwin_without_asking=0;
foreach my $arg (@ARGV) {
   if ($arg=~/INSTALL_*CYGWIN\s*=\*1/i) {
      $install_cygwin_without_asking=1;
      last;
   }
}

# Define metadata
name            'Net-FullAuto';
sign;
version         '0.59';
author          'Brian M. Kelly <Brian.Kelly@fullautosoftware.net>';
license         'gpl';
perl_version    '5.006';

my $editor='';my $selection='';
if ($^O eq 'MSWin32' || $^O eq 'MSWin64') {
#if (1) {

   my %Menu_win_to_cyg=(

         Label  => 'Menu_win_to_cyg',
         Item_1 => {

            Text => "Install Cygwin Linux Emulation Layer for Windows",

         },
         Item_2 => {
 
            Text    => "DO *NOT* Install Cygwin (FullAuto Install will END)",
            Default => "*",
 
         },
         Banner => "   Would you like to install Cygwin?",

   );
   if ($install_cygwin_without_asking) {
      $selection='Install';
   } else {
      $selection=Menu(\%Menu_win_to_cyg);
   }
   exit if $selection eq ']quit[';
   if ($selection!~/NOT/) {
      if ($@) {
         do{my$p='LWP';eval"use $p;1"or do{
         my$e=$ENV{PERL_EXTUTILS_AUTOINSTALL};
         (!defined($e)||$e!~m/--(?:default|skip|testonly)/and-t STDIN or
         eval"use ExtUtils::MakeMaker;WriteMakefile(PREREQ_PM=>{'$p'}
         );1"and exit)and print"==> $p required."and print
         "*** Installing $p\n"and
         do{if (eval '$>' and lc(`sudo -V`) =~ /version/){system('sudo',
         $^X,"-MCPANPLUS","-e","CPANPLUS::install $p");eval"use $p;1"
         ||system('sudo', $^X, "-MCPAN", "-e", "CPAN::install $p")}eval{
         require CPANPLUS;CPANPLUS::install $p};eval"use $p;1"or eval{
         require CPAN;CPAN::install $p};eval"use $p;1"||die"*** Please
         manually install $p from cpan.org first...\n"}}}
      }
      my @editors=('vim     (ViIMproved - enhanced vi editor)',
                   "emacs   (The extensible, customizable,\n           ".
                   "              self-documenting real-time\n         ".
                   "                display editor)",
                   'mc      (Midnight Commander visual shell)',
                   "joe     (Fast and simple editor that\n             ".
                   '            emulates 5 other editors)', 
                  );
      my $tp='';
      unless ($tp=find_editor('TextPad.exe')) {
         if (-e "C:\\Program Files\\TextPad 5\\TextPad.exe") {
            $tp='default';
         }
      }
      if ($tp) {
         push @editors, 'TextPad (The Text Editor for Windows)';
      }

      my $banner="   In order is use the integrated edit features\n".
                 "   you will need to choose an editor.";
      my %Menu_select_editor=();
      if (-e "C:\\Program Files\\Windows NT\\Accessories\\wordpad.exe") {
         $banner="   In order is use the integrated edit features\n".
                 "   you will need to choose an editor. MS Wordpad\n".
                 "   is set as the default - and is recommended if\n".
                 "   you are not familiar with the other listed\n".
                 "   editors.";
         %Menu_select_editor=(

               Label  => 'Menu_select_editor',
               Item_1 => {

                  Text => "Wordpad (Microsoft Wordpad -\n               ".
                          "          Available on all Windows Systems)",
                  Default => "*",

               },
               Item_2 => {

                  Text    => "]C[",
                  Convey  => \@editors,

               },
               Banner => $banner,

         );
      } else {
         %Menu_select_editor=(

               Label  => 'Menu_select_editor',
               Item_1 => {

                  Text    => "]C[",
                  Convey  => \@editors,

               },
               Banner => $banner,

         );
      }
      
      if ($install_cygwin_without_asking) {
         if (-e "C:\\Program Files\\Windows NT\\Accessories\\wordpad.exe") {
            $selection='wordpad';
            $editor="\"/cygdrive/c/Program Files/Windows NT/".
                    "Accessories/wordpad.exe\"";
         }
      } elsif (0<$#editors) {
         $selection=Menu(\%Menu_select_editor);
         if ($selection=~/TextPad/) {
            if ($tp eq 'default') {
               $editor="\"/cygdrive".
                  "/c/Program Files/TextPad 5/TextPad.exe\"";
            } else {
               $tp=~s/\\/\//g;
               $tp=~s/^([A-Za-z]):(.*)/$1$2/;
               $editor="\"/cygdrive/$tp\"";
            }
         } elsif ($selection=~/vim/) {
            $editor='"/bin/vim-nox.exe"';
         } elsif ($selection=~/emacs/) {
            $editor='"/bin/emacs-nox.exe"';
         } elsif ($selection=~/joe/) {
            $editor='"/bin/joe.exe"';
         } elsif ($selection=~/mc/) {
            $editor='"/bin/mc.exe"';
         }
      } elsif (0==$#editors) {
         $selection=$editors[0];
      }
      exit if $selection eq ']quit[';
      require LWP;
      my $ua=LWP::UserAgent->new;
      my $response = $ua->get('http://www.cygwin.com/setup.exe');
      open(CP,">setup.exe") || die $!;
      binmode(CP);
      if ($response->is_success) {
         open(CP,">setup.exe") || die $!;
         binmode(CP);
         print CP $response->content;
      } else {
         my $response = $ua->get('http://www.fullautosoftware.net/setup.exe');
         if ($response->is_success) {
            open(CP,">setup.exe") || die $!;
            binmode(CP);
            print CP $response->content;
         } else {
            die $response->status_line;
         }
      }
      close(CP) || die $!;
      chmod 0755, 'setup.exe';
      my $setup_cmd='';
      if ($selection!~/[Ww]ordpad/s) {
         $setup_cmd='cmd /c ".\\setup.exe -D -P gcc4-core,gcc4-g++,'
                   .'make,openssh,perl,perl-libwin32,db4.5,'
                   .$selection.' -A -q"';
      } else {
         $setup_cmd='cmd /c ".\\setup.exe -D -P gcc4-core,gcc4-g++,'
                   .'make,openssh,perl,perl-libwin32,db4.5 -A -q"';
      }
      if ($selection=~/[Ww]ordpad/) {
         $editor='"'.'/cygdrive'.
            '/c/Program Files/Windows NT/Accessories/wordpad.exe'.'"';
      } else {
         $editor="/bin/${selection}.exe";
      }
      my $pwd=`cmd /c chdir`;
      chmod($pwd);
      my $cygpath=$pwd;
      $cygpath=~s/^(.):/\/cygdrive\/$1/;
      $cygpath=~s/\\/\//g;
      system($setup_cmd);
      if ($^O eq 'cygwin') {
         system('cmd /c C:\\\\cygwin\\\\bin\\\\bash -ic '.
                '"/usr/bin/cpan -i Net::FullAuto"');
      } else {
         system('cmd /c C:\\cygwin\\bin\\bash -ic '.
                '"/usr/bin/cpan -i Net::FullAuto"');
      }
      exit;
   } elsif ($process_id) {
      exit;
   }
   my $die="\n       FATAL ERROR! : Cygwin Linux Emulation Layer".
           "\n                      is required to use FullAuto".
           "\n                      on Windows - goto www.cygwin.com.".
           "\n\n           Be sure to install the following programs in ".
           "\n           addition to the base package:".
           "\n\n           OpenSSH [as provided by Cygwin]".
           "\n           inetutils \(if telnet and/or ftp services are desired\)".
           "\n           perl [as provided by Cygwin] (*NOT* CPAN)".
           "\n           libwin32 [as provided by Cygwin] (*NOT* CPAN)".
           "\n           gcc [as provided by Cygwin]".
           "\n           Oracle Berkeley DB [as provided by Cygwin]".
           "\n\n           **IMPORTANT** - the FullAuto install, either manual".
           "\n           or via CPAN, must be run *inside* a Cygwin bash shell".
           "\n           when installing FullAuto on Microsoft Windows.".
           "\n\n";
   die $die;
}

unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_conf.pm") {
   my @editors=();
   my $banner="   In order is use the integrated edit features\n".
              "   you will need to choose an editor.";
   if ($^O eq 'cygwin') {
      my $tp='';
      my $mount=`/bin/mount -p`;
      $mount=~s/^.*(\/\S+).*$/$1/s;
      unless ($tp=find_editor('TextPad.exe')) {
         if (-e $mount."/c/Program Files/TextPad 5/TextPad.exe") {
            $tp='default';
         }
      }
      if ($tp) {
         push @editors, 'TextPad (The Text Editor for Windows)';
      }
      my $wordpad=0;
      if (-e $mount.
             "/c/Program Files/Windows NT/Accessories/wordpad.exe") {
         $banner="   In order is use the integrated edit features\n".
                 "   you will need to choose an editor. MS Wordpad\n".
                 "   is set as the default - and is recommended if\n".
                 "   you are not familiar with the other listed\n".
                 "   editors.";
         $wordpad=1;
      }
      if (-e '/bin/vim-nox.exe') {
         push @editors,'vim';
      }
      if (-e '/bin/emacs-nox.exe') {
         push @editors, 'emacs';
      }
      if (-e '/bin/joe.exe') {
         push @editors, 'joe';
      }
      if (-e '/bin/mc.exe') {
         push @editors, 'mc';
      }
      my %Menu_select_editor=();
      if ($wordpad) {
         %Menu_select_editor=(

               Label  => 'Menu_select_editor',
               Item_1 => {

                  Text => "Wordpad (Microsoft Wordpad -\n               ".
                          "          Available on all Windows Systems)",
                  Default => "*",

               },
               Item_2 => {

                  Text    => "]C[",
                  Convey  => \@editors,

               },
               Banner => $banner,

         );
         $selection=Menu(\%Menu_select_editor);
      } else {
         %Menu_select_editor=(

               Label  => 'Menu_select_editor',
               Item_1 => {

                  Text    => "]C[",
                  Convey  => \@editors,

               },
               Banner => $banner,

         );
         $selection=Menu(\%Menu_select_editor);
      }
      if ($selection=~/TextPad/) {
         if ($tp eq 'default') {
            $editor="\"$mount".
               "/c/Program Files/TextPad 5/TextPad.exe\"";
         } else {
            $tp=~s/\\/\//g;
            $tp=~s/^([A-Za-z]):(.*)/$1$2/;
            $editor="\"$mount/$tp\"";
         }
      } elsif ($selection=~/vim/) {
         $editor='"/bin/vim-nox.exe"';
      } elsif ($selection=~/emacs/) {
         $editor='"/bin/emacs-nox.exe"';
      } elsif ($selection=~/joe/) {
         $editor='"/bin/joe.exe"';
      } elsif ($selection=~/mc/) {
         $editor='"/bin/mc.exe"';
      }
   } else {
      if (-e '/usr/bin/vi') {
         push @editors, 'vi';   
      }
      if (-e '/usr/bin/emacs') {
         push @editors, 'emacs';
      }
      if (1<$#editors) {
         my %Menu_select_editor=(

            Label  => 'Menu_select_editor',
            Item_1 => {

               Text    => "]C[",
               Convey  => \@editors,

            },
            Banner => $banner,

         );
         $selection=Menu(\%Menu_select_editor);
         if ($selection=~/vi/) {
            $editor='"/usr/bin/vi"';
         } elsif ($selection=~/emacs/) {
            $editor='"/usr/bin/emacs"';
         }
      } elsif (1==$#editors) {
         $editor=$editors[0];
      } else {
         $editor='\'\'';
      }
   }
}

if ($^O eq 'cygwin' && !can_cc()) {
   my $die="\n       FATAL ERROR! : The Gnu C Compiler 'gcc'".
           "\n                      version 4 as provided by Cygwin".
           "\n                      is required to install FullAuto".
           "\n                      on Windows.".
           "\n(Hint: Run Cygwin setup.exe and install 'gcc4-core' ".
           "and 'gcc4-g++' under the Category 'Devel' ).".
           "\n\n";
   die $die;
} elsif (!can_cc()) {

   my $moreinfo='';
   if ($Config{cc} and $Config{cc}!~/^\s*$/) {
      $moreinfo="\n\n                      You are running $^X version $].\n".
           "\n                      The Config.pm file for this perl installation".
           "\n                      contains \"$Config{cc}\" as the compiler used".
           "\n                      to build this perl, but this compiler does not".
           "\n                      exist in the PATH and may not be installed on".
           "\n                      this host.\n";
           "\n                      Retrofitting an existing perl installation to".
           "\n                      work properly with a new compiler for building".
           "\n                      CPAN modules, is tricky and NOT recommended.".
           "\n                      Often the available perl (especially on Unix".
           "\n                      systems) is highly integrated with the host".
           "\n                      OS and many of its features and utilities.".
           "\n                      Upgrading the perl, but not the overall OS".
           "\n                      is risky and may result in more than a few".
           "\n                      system problems and instabilities.\n".
           "\n                      The recommended approach is build a NEW perl".
           "\n                      from source with your choice of newly installed".
           "\n                      compiler (such as gcc) in a different location".
           "\n                      (such as /usr/local/lib) or your home directory".
           "\n                      if you lack root/admin privileges."
   }

   my $die="\n       FATAL ERROR! : A C Compiler (such as cc or gcc version 4)".
           "\n                      is required to install FullAuto";
           $moreinfo.
           "\n                      (Hint: goto www.gnu.org for gcc version 4).".
           "\n\n";
   die $die;
}

if ($^O eq 'cygwin' && !(can_run('/bin/ssh') || can_run('/bin/telnet'))) {
   my $timeout=120;my $a='';
   eval {
      $SIG{ALRM} = sub { die "alarm\n" }; # NB: \n required
      alarm $timeout;
      print "\n       *** THIS SCREEN WILL TIMEOUT IN 2 MINUTES ***\n". 
            "\n       WARNING! : The Secure Shell - 'ssh'".
            "\n                  and/or 'telnet' (via inetutils)".
            "\n                  as provided by Cygwin".
            "\n                  is required to install FullAuto".
            "\n                  on Windows.".
            "\n(Hint: Run Cygwin setup.exe and install OpenSSH ".
            "under the Category 'Net' ).".
            "\n\n";
      print "Press <ENTER> if you wish to continue, or 'N' to quit . . . [Y] ";$a=<STDIN>;
      alarm 0;
   };
   if ($@) {
      # timed out
      exit;
   } elsif ($a=~/^[Nn]$/s) {
      exit;
   }
}
if (!can_run('make') && !(($^O eq 'cygwin') && (-e "/usr/bin/make"))) {
   my $die="\n       FATAL ERROR! : Cannot locate 'make'. This program ".
           "\n                      is required to install FullAuto".
           "\n                      (Hint: goto www.gnu.org for gnumake).".
           "\n\n";
   die $die;
}

if (1) {
   # Let's find if Berkeley DB is already on the system
   my $findpath='';
   if (-e "/bin/find") {
      $findpath="/bin/";
   } elsif (-e "/usr/bin/find") {
      $findpath="/usr/bin/";
   } elsif (-e "/usr/local/bin/find") {
      $findpath="/usr/local/bin/";
   }
   my $xargspath='';
   if (-e "/bin/xargs") {
      $xargspath="/bin/";
   } elsif (-e "/usr/bin/xargs") {
      $xargspath="/usr/bin/";
   } elsif (-e "/usr/local/bin/xargs") {
      $xargspath="/usr/local/bin/";
   }
   my $greppath='';
   if (-e "/bin/grep") {
      $greppath="/bin/";
   } elsif (-e "/usr/bin/grep") {
      $greppath="/usr/bin/";
   } elsif (-e "/usr/local/bin/grep") {
      $greppath="/usr/local/bin/";
   }
   if ($findpath && $xargspath && $greppath) {
      print "\nSearching for latest verison of BerkeleyDB.\n".
            "This may take up to five minutes ...\n\n";
      #my @usr_contents=`ls -l /usr`;
      my $find_cmd="$findpath/find /usr -type f -name \"db.h\" ".
                   "| $xargspath/xargs $greppath/grep -H VERSION_STRING";
      my @output=`$find_cmd`;my @vers=();my %verhash=(); 
      $find_cmd="$findpath/find /opt -type f -name \"db.h\" ".
                   "| $xargspath/xargs $greppath/grep -H VERSION_STRING";
      my @output2=`$find_cmd`;
      push @output, @output2;
      if (-1<$#output) {
         foreach my $version (@output) {
            next unless $version=~/VERSION_STRING/;
            my @fileparts=split 'h:', $version;
            $fileparts[1]=~s/^.*DB (\d+[^:]+):.*$/$1/;
            $verhash{$fileparts[1]}=$fileparts[0].'h'; 
         }
      }
      my $header_to_use='';my $dblib='';my $ver='';
      foreach my $vr (reverse sort keys %verhash) {
         $header_to_use=$verhash{$vr};
         $vr=~s/^(^\d+[.]\d+).*$/$1/;
         chomp($vr);
         $ver=$vr;
         my $find_cmd="$findpath/find /usr -type f -name \"libdb-".$ver.".a\"";
         my @lib=`$find_cmd`;
         chomp($lib[0]);$dblib=$lib[0];last;
      }
      if ($dblib) {
         $dblib=~s/^(.*)\/.*$/$1/;
         $ENV{'BERKELEYDB_INCLUDE'}=$header_to_use;
         $ENV{'BERKELEYDB_LIB'}=$dblib;
         $ENV{'BERKELEYDB_NAME'}="-ldb-$ver";
         $ENV{'DB_FILE_INCLUDE'}=$header_to_use;
         $ENV{'DB_FILE_LIB'}=$dblib;
         $ENV{'DB_FILE_NAME'}="-ldb-$ver";
      } else {
         my $die="\n       FATAL ERROR! : Cannot locate 'BerkeleyDB'. This C Library ".
                 "\n                      is required to install FullAuto".
                 "\n                      (Hint: goto www.oracle.com for BerkeleyDB).".
                 "\n\n";
         die $die;
      }
   }
}

if (0) { ## This disables the following code testing for lynx

unless (can_run('lynx')) {
   my $timeout=120;my $a='';
   eval {
      $SIG{ALRM} = sub { die "alarm\n" }; # NB: \n required
      alarm $timeout;
      print "\n       *** THIS SCREEN WILL TIMEOUT IN 2 MINUTES ***\n".
            "\n       WARNING! : Cannot locate 'lynx'. This program ".
            "\n                  is recommended for installing FullAuto".
            "\n                  from the CPAN (Hint: goto www.gnu.org).".
            "\n\n";
      print "Press <ENTER> if you wish to continue, or 'N' to quit . . . [Y] ";$a=<STDIN>;
      alarm 0;
   };
   if ($@) {
      # timed out
      exit;
   } elsif ($a=~/^[Nn]$/s) {
      exit;
   }
}

} ## End disable block

#Specific dependencies
requires        'Module::Load::Conditional' => 0;
requires        'Term::Menus'               => 1.49;
requires        'Tie::Cache'                => 0;
requires        'MLDBM::Sync'               => 0;
requires        'Sort::Versions'            => 0;
requires        'Crypt::CBC'                => 0;
requires        'Crypt::DES'                => 0;
requires        'HTTP::Date'                => 0;
requires        'JSON'                      => 2.14;
requires        'IO::Pty'                   => 1.09;
requires        'IO::Capture::Stderr'       => 0;
requires        'IO::CaptureOutput'         => 0;
requires        'Capture::Tiny'             => 0;
requires        'Net::Telnet'               => 0;
requires        'Term::ReadKey'             => 0;
requires        'URI'                       => 0;
requires        'Email::Sender'             => 0;
requires        'MIME::Entity'              => 0;
requires        'DB_File'                   => 0;
requires        'BerkeleyDB'                => 0;
recommends      'Crypt::Rijndael'           => 0;

auto_install;

my %hash=();
eval {
   require DB_File;
   my $db = tie %hash, "DB_File", "fullauto_test_for_db_creation.db" 
      || die "Cannot tie fullauto_test_for_db_creation.db: $!" ;
   undef $db ;
   untie %hash ;
   unlink "fullauto_test_for_db_creation.db";
};
if ($@) {
   my $die="\n$@\n".
           "\n       FATAL ERROR! : Cannot create 'fullauto_test_for_db_creation.db'".
           "\n                      You may be missing the Berkeley DB 'c' library.".
           "\n                      This 'c' library is required to install FullAuto\n";
   if ($^O eq 'cygwin') {
      $die.="\n(Hint: Run Cygwin setup.exe and install Oracle Berkley DB ".
           "under the Category 'Database' ).";
   } else {
      $die.="\n(Hint: goto ->  http://www.oracle.com/technetwork/".
           "database/berkeleydb/downloads/index.html ).";
   }
   $die.="\n\n";
   die $die;
}

my $c_file='';
my $date=strftime('%D',localtime);

my $banner='';
unless (-w $Config{installsitelib}) {
   $banner="\n   *** THIS SCREEN WILL TIMEOUT AND CHOOSE 'NO' IN 2 MINUTES ***\n".
           "\n   WARNING!: You do not have permission to install FullAuto".
           "\n   to the default location -> $Config{installsitelib}.\n".
           "\n   Hint 1: You can use the PREFIX and LIB attributes to".
           "\n   set several attributes at once. The quickest way to".
           "\n   install FullAuto in a non-default location might be".
           "\n   setting PREFIX to '~'. You can do this by selecting".
           "\n   'Yes' below, or by re-running Makefile.PL with the".
           "\n   the following argument:\n".
           "\n   perl Makefile.PL PREFIX=~\n".
           "\n   This will install all FullAuto files under your home".
           "\n   directory, with man pages and libraries going into the".
           "\n   appropriate place (most likely ~/man and ~/lib)\n".
           "\n   You may also consider using the LIB attribute:\n".
           "\n   perl Makefile.PL LIB=~/lib\n".
           "\n   See the MakeMaker.pm module documetation for more".
           "\n   information:\n".
           "\n   http://search.cpan.org/~mschwern/ExtUtils-MakeMaker-6.56".
           "/lib/ExtUtils/MakeMaker.pm#PREFIX_and_LIB_attribute\n".
           "\n   Hint 2: Run perl MakeMaker.PL with an appropriate user".
           "\n   (such as root) or with a utility such as sudo if you".
           "\n   are authorized to use it (sudo perl Makefile.PL).".
           "\n   The same is true if you are attempting to install".
           "\n   FullAuto via the CPAN resposiory (i.e. 'sudo cpan')\n".
           "\n   Would like to install FullAuto to your home (~) directory?\n\n"
}

if ($banner) {

   my $timeout=120;my $selection='';
   eval {
      $SIG{ALRM} = sub { die "alarm\n" }; # NB: \n required
      alarm $timeout;
      my $menu1 = [
                  $banner,
                  [ "Yes", sub{ return 'Yes' } ],
                  [ "No   (FullAuto install will exit)", sub{ return 'No' } ],
                  #[ "Quit", sub {exit;} ],
                  ];
      $selection=&menu($menu1);
      alarm 0;
   };
   if ($@) {
      # timed out
      $selection = 'No';
   }
   if ($selection=~/No/) {
      exit;
   }
}

open(FH,">fullauto.c");

print FH '/* program: fullauto'."\n".
"   author:  Brian Kelly\n".
"   date:    $date\n".
"\n".
"   purpose: C program wrapper that calls $Config{installsitebin}/fullauto.pl script\n".
"   WARNING: This file is auto-generated by Makefile.PL, please change Makefile.PL.\n".
"            Any modifications made to this source file will be lost!\n".
'*/'."\n".
"\n".
'#define REAL_PL '.'"'.$Config{installsitebin}."/fullauto.pl\"\n".
"main(argc, argv)\n".
"char **argv;\n".
'{'."\n".
"\tsetuid(0);\n".
"\tseteuid(0);\n".
"\texecv(REAL_PL, argv);\n".
'}'."\n";

close FH;

my $timeout=120;my $selection='';my @selection=();
eval {
   $SIG{ALRM} = sub { die "alarm\n" }; # NB: \n required
   alarm $timeout;
   my @list=('Install with Default Permissions',
             'Install with Setuid Permissions',
             'Install with Setgid Permissions');
   my $banner="\n   *** THIS SCREEN WILL TIMEOUT AND CHOOSE 'Default' IN 2 MINUTES ***\n".
           "\n   Choose a Permission Setting :\n\n";
   @selection=&pick(\@list,$banner);
   alarm 0;
};
if ($@) {
   # timed out
   print "\n";
   $selection = 'Default';
}

my $permission = 'Default';
#print "SELECTION = $selection<==\n";sleep 3;
if (-1<index $selection,'Setuid') {
   $permission = 'Setuid';
} elsif (-1<index $selection,'Setgid') {
   $permission = 'Setgid';
} elsif (-1<index $selection,'quit') {
   exit;
} print "\n"; 

if ($^O eq 'cygwin') {
   `/usr/bin/touch "bin/fullauto.exe"`;
   install_script 'bin/fullauto.exe';
   unlink "bin/fullauto.exe";
} else {
   `/usr/bin/touch "bin/fullauto"`;
   install_script 'bin/fullauto';
   unlink "bin/fullauto";
}
install_script 'bin/fullauto.pl';

WriteAll;

sub menu {
    my $m = shift;
    my $choice;
    while (1) {
    print "$m->[0]\n";
    print map { "\t$_. $m->[$_][0]\n" } (1..$#$m);
    print "\n\n   PLEASE ENTER A CHOICE: ";
    chomp ($choice = <>);
    last if ( ($choice > 0) && ($choice <= $#$m ));
    print "You chose '$choice'.  That is not a valid option.\n\n";
    }
    &{$m->[$choice][1]};
}

sub find_editor {
   my $editor=$_[0];
   $editor=~s/^.*\///;
   $editor=~s/[.]exe$//;
   return 0 unless $editor;
   foreach my $path (split ':', $ENV{PATH}) {
      $path=~s/[\/]*$/\//;
      if ($^O eq 'cygwin' && (-e $path.$editor.'.exe')) {
         return $path.$editor.'.exe';
      } elsif (-e $path.$editor) {
         return $path.$editor;
      }
   } return 0;
}

package MY; # so that "SUPER" works right
sub MY::top_targets {

   my $inherited = shift->SUPER::top_targets(@_);

   $inherited =~ s/pure_all :: /pure_all :: fullauto\$(EXE_EXT) /;
   $inherited =~ s/ linkext//;

   $inherited;

}

package MY; # so that "SUPER" works right
sub MY::makefile {

   use Config;

   my $inherited = shift->SUPER::makefile(@_);

   $inherited .= "fullauto\$(EXE_EXT): fullauto.c\n\t\$(CC) fullauto.c -o \$@".
                 "\n\t\$(CP) \$@ bin\n\n";

   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_host.pm") {
      $inherited .= "lib/Net/FullAuto/Custom/fa_host.pm:".
                    "\n\t\$(CP) lib/Net/FullAuto/Distro/fa_host.pm \$@\n\n";
   } else {
      $inherited =~ s/^(.*FullAuto.*fa_host.pm.*)$//m;
      $inherited .= "lib/Net/FullAuto/Custom/fa_host.pm:".
                    "\n\t\$(NOECHO)\n\n";
      unlink "lib/Net/FullAuto/Custom/fa_host.pm";
      unlink "blib/lib/Net/FullAuto/Custom/fa_host.pm";
   }
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_maps.pm") {
      $inherited .= "lib/Net/FullAuto/Custom/fa_maps.pm:".
                    "\n\t\$(CP) lib/Net/FullAuto/Distro/fa_maps.pm \$@\n\n";
   } else {
      $inherited =~ s/^(.*Custom\/fa_maps.pm.*)$//m;
      $inherited .= "lib/Net/FullAuto/Custom/fa_maps.pm:".
                    "\n\t\$(NOECHO)\n\n";
      unlink "lib/Net/FullAuto/Custom/fa_maps.pm";
      unlink "blib/Net/FullAuto/Custom/fa_maps.pm";
   }
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_conf.pm") {
      $editor=~s/\//\\\//g;
      $inherited .= "lib/Net/FullAuto/Custom/fa_conf.pm:".
                    "\n\t\$(CP) lib/Net/FullAuto/Distro/fa_conf.pm \$@\n\n";
   } else {
      $inherited =~ s/^(.*Custom\/fa_conf.pm.*)$//m;
      $inherited .= "lib/Net/FullAuto/Custom/fa_conf.pm:".
                    "\n\t\$(NOECHO)\n\n";
      unlink "lib/Net/FullAuto/Custom/fa_conf.pm";
      unlink "blib/Net/FullAuto/Custom/fa_conf.pm";
   }
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_menu.pm") {
      $inherited .= "lib/Net/FullAuto/Custom/fa_menu.pm:".
                    "\n\t\$(CP) lib/Net/FullAuto/Distro/fa_menu.pm \$@\n\n";
   } else {
      $inherited =~ s/^(.*Custom\/fa_menu.pm.*)$//m;
      $inherited .= "lib/Net/FullAuto/Custom/fa_menu.pm:".
                    "\n\t\$(NOECHO)\n\n";
      unlink "lib/Net/FullAuto/Custom/fa_menu.pm";
      unlink "blib/lib/Net/FullAuto/Custom/fa_menu.pm";
   }
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_code.pm") {
      $inherited .= "lib/Net/FullAuto/Custom/fa_code.pm:".
                    "\n\t\$(CP) lib/Net/FullAuto/Distro/fa_code.pm \$@\n\n";
   } else {
      $inherited =~ s/^(.*Custom\/fa_code.pm.*)$//m;
      $inherited .= "lib/Net/FullAuto/Custom/fa_code.pm:".
                    "\n\t\$(NOECHO)\n\n";
      unlink "lib/Net/FullAuto/Custom/fa_code.pm";
      unlink "blib/lib/Net/FullAuto/Custom/fa_code.pm";
   }

   $inherited; 

}

package MY; # so that "SUPER" works right
sub MY::tools_other {

   use Config;

   my $inherited = shift->SUPER::tools_other(@_);

   $inherited =~
      s/^(MV.*)$/$1\nSED = sed/m;

   $inherited;

}

package MY; # so that "SUPER" works right
sub MY::constants {

   use Config;

   my $inherited = shift->SUPER::constants(@_);

   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_host.pm") {
      my $fa_h="\tlib\/Net\/FullAuto\/Custom\/fa_host.pm ".
               "\\\n\tblib\/Net\/FullAuto\/Custom\/fa_host.pm \\";
      $inherited =~
         s/(\s+lib.*Distro\/fa_host.pm \\)/$1\n\tlib\/Net\/FullAuto\/Custom\/fa_host.pm \\/m; 
      $inherited =~
         s/(\s+blib.*Distro\/fa_host.pm \\)/$1\n$fa_h/m;
   } else {
      $inherited =~ s/^(.*Custom\/fa_host.pm.*)$//;
   }
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_maps.pm") {
      my $fa_m="\tlib\/Net\/FullAuto\/Custom\/fa_maps.pm ".
               "\\\n\tblib\/Net\/FullAuto\/Custom\/fa_maps.pm \\";
      $inherited =~
         s/(\s+lib.*Distro\/fa_maps.pm \\)/$1\n\tlib\/Net\/FullAuto\/Custom\/fa_maps.pm \\/m;
      $inherited =~
         s/(\s+blib.*Distro\/fa_maps.pm \\)/$1\n$fa_m/m;
   } else {
      $inherited =~ s/^(.*Custom\/fa_maps.pm.*)$//;
   }
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_conf.pm") {
      my $fa_g="\tlib\/Net\/FullAuto\/Custom\/fa_conf.pm ".
               "\\\n\tblib\/Net\/FullAuto\/Custom\/fa_conf.pm \\";
      $inherited =~
         s/(\s+lib.*Distro\/fa_conf.pm \\)/$1\n\tlib\/Net\/FullAuto\/Custom\/fa_conf.pm \\/m;
      $inherited =~
         s/(\s+blib.*Distro\/fa_conf.pm \\)/$1\n$fa_g/m;
   } else {
      $inherited =~ s/^(.*Custom\/fa_conf.pm.*)$//;
   }
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_menu.pm") {
      my $fa_m="\tlib\/Net\/FullAuto\/Custom\/fa_menu.pm ".
               "\\\n\tblib\/Net\/FullAuto\/Custom\/fa_menu.pm \\";
      $inherited =~
         s/(\s+lib.*Distro\/fa_menu.pm \\)/$1\n\tlib\/Net\/FullAuto\/Custom\/fa_menu.pm \\/m;
      $inherited =~
         s/(\s+blib.*Distro\/fa_menu.pm \\)/$1\n$fa_m/m;
   } else {
      $inherited =~ s/^(.*Custom\/fa_menu.pm.*)$//;
   }
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_code.pm") {
      my $fa_c="\tlib\/Net\/FullAuto\/Custom\/fa_code.pm ".
               "\\\n\tblib\/Net\/FullAuto\/Custom\/fa_code.pm \\";
      $inherited =~
         s/(\s+lib.*Distro\/fa_code.pm \\)/$1\n\tlib\/Net\/FullAuto\/Custom\/fa_code.pm \\/m;
      $inherited =~
         s/(\s+blib.*Distro\/fa_code.pm \\)/$1\n$fa_c/m;
   } else {
      $inherited =~ s/^(.*Custom\/fa_code.pm.*)$//;
   }

   $inherited =~ 
      s/(PERM_RWX = \d+)/$1\nPERM_S_X = 4511\nPERM_G_X = 2551/m;
   $inherited =~
      s/(PERM_G_X = \d+)/$1\nPERM_R+X = 555\nPERM_R-X = 550\nPERM_R_X = 500/m;
   $inherited =~
      s/(PERM_R_X = \d+)/$1\nPERM_D-X = 750\nPERM_D_X = 700\nPERM_WRX = 755/m;

   $inherited;

}

package MY; # so that "SUPER works right
sub MY::installbin {

   my $inherited = shift->SUPER::installbin(@_);

   $inherited =~ s/RM_F\) \\/RM_F\) bin\/fullauto\$(EXE_EXT) fullauto.c fullauto\$(EXE_EXT)\\/;

   $inherited;

}

package MY; # so that "SUPER" works right
sub MY::install {

   use Config;

   my $inherited = shift->SUPER::install(@_);

   if ($permission eq 'Setuid') {
      $inherited =~ s/(install ::.*)$/$1 setuid_permissions/m;
   } elsif ($permission eq 'Setgid') {
      $inherited =~ s/(install ::.*)$/$1 setgid_permissions/m;
   } else {
      $inherited =~ s/(install ::.*)$/$1 default_permissions/m;
   }

   my $link='';
   unless (-e $Config{installsitebin}."/fa") {
      my $lnpath='';
      if (-e "/bin/ln") {
         $lnpath="/bin/ln";
      } elsif (-e "/usr/bin/ln") {
         $lnpath="/usr/bin/ln";
      } elsif (-e "/usr/local/bin/ln") {
         $lnpath="/usr/local/bin/ln";
      }

      if ($lnpath) {
         $link="\t\$(NOECHO) $lnpath -f -s \$(DESTINSTALLSITESCRIPT)\/fullauto\$(EXE_EXT) ".
               "\$(DESTINSTALLSITESCRIPT)\/fa\n"; 
      }

   } 

   $inherited .= "\nsetuid_permissions ::\n".
      "\t\$(NOECHO) \$(ECHO) \"Applying Setuid Permissions\"\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_S_X) \$(DESTINSTALLSITESCRIPT)\/fullauto\$(EXE_EXT)\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R_X) \$(DESTINSTALLSITESCRIPT)\/fullauto.pl\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R_X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto.pm\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_D_X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R_X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/*\n".
      $link;
   $inherited .= "\nsetgid_permissions ::\n".
      "\t\$(NOECHO) \$(ECHO) \"Applying Setgid Permissions\"\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_G_X) \$(DESTINSTALLSITESCRIPT)\/fullauto\$(EXE_EXT)\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R-X) \$(DESTINSTALLSITESCRIPT)\/fullauto.pl\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R-X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto.pm\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_D-X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R-X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/*\n".
      $link;
   $inherited .= "\ndefault_permissions ::\n".
      "\t\$(NOECHO) \$(ECHO) \"Applying Default Permissions\"\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITESCRIPT)\/fullauto\$(EXE_EXT)\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITESCRIPT)\/fullauto.pl\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto.pm\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_DIR) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/*\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_WRX) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/Custom\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_WRX) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/Custom\/*\n".
      $link; 

   $inherited;

}

package MY; # so that "SUPER" works right
sub MY::dist_core {

   my $inherited = shift->SUPER::dist_core(@_);

   $inherited =~ s/tar$/tar\n\t\$(MV) \$(DISTVNAME).tar\$(SUFFIX) dist/m;

   $inherited;

}

package MY; # so that "SUPER" worls right
sub MY::clean {

   my $inherited = shift->SUPER::clean(@_);

   $inherited =~ s/blib\s*$/blib setup\$(EXE_EXT) /m;

   $inherited;

}

package MY; # so that "SUPER" works right
sub MY::pm_to_blib {

   use Config;

   my $inherited = shift->SUPER::pm_to_blib(@_);

   unless ((-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_host.pm") &&
         ($inherited !~ /Custom\/fa_host.pm/)) {
      my $fa_h="\t  lib\/Net\/FullAuto\/Custom\/fa_host.pm ".
               "blib\/lib\/Net\/FullAuto\/Custom\/fa_host.pm";
      my $wrap='';
      $inherited =~ /\s+blib.*Distro\/fa_host.pm( \\)/m;
      $wrap=$1;
      $inherited =~
         s/(\s+blib.*Distro\/fa_host.pm).*/$1 \\\n$fa_h$wrap/m;
   } else {
      $inherited =~ s/.*Custom\/fa_host.pm.*\n//m;
   }
   unless ((-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_maps.pm") &&
         ($inherited !~ /Custom\/fa_maps.pm/)) {
      my $fa_p="\t  lib\/Net\/FullAuto\/Custom\/fa_maps.pm ".
               "blib\/lib\/Net\/FullAuto\/Custom\/fa_maps.pm";
      my $wrap='';
      $inherited =~ /\s+blib.*Distro\/fa_maps.pm( \\)/m;
      $wrap=$1;
      $inherited =~
         s/(\s+blib.*Distro\/fa_maps.pm).*/$1 \\\n$fa_p$wrap/m;
   } else {
      $inherited =~ s/.*Custom\/fa_maps.pm.*\n//m;
   }
   unless ((-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_conf.pm") &&
         ($inherited !~ /Custom\/fa_conf.pm/)) {
      my $fa_g="\t  lib\/Net\/FullAuto\/Custom\/fa_conf.pm ".
               "blib\/lib\/Net\/FullAuto\/Custom\/fa_conf.pm";
      my $wrap='';
      $inherited =~ /\s+blib.*Distro\/fa_conf.pm( \\)/m;
      $wrap=$1;
      $inherited =~
         s/(\s+blib.*Distro\/fa_conf.pm).*/$1 \\\n$fa_g$wrap/m;
   } else {
      $inherited =~ s/.*Custom\/fa_conf.pm.*\n//m;
   }
   unless ((-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_menu.pm") &&
         ($inherited !~ /Custom\/fa_menu.pm/)) {
      my $fa_m="\t  lib\/Net\/FullAuto\/Custom\/fa_menu.pm ".
               "blib\/lib\/Net\/FullAuto\/Custom\/fa_menu.pm";
      my $wrap='';
      $inherited =~ /\s+blib.*Distro\/fa_menu.pm( \\)/m;
      $wrap=$1;
      $inherited =~
         s/(\s+blib.*Distro\/fa_menu.pm).*/$1 \\\n$fa_m$wrap/m;
   } else {
      $inherited =~ s/.*Custom\/fa_menu.pm.*\n//m;
   }
   unless ((-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_code.pm") &&
         ($inherited !~ /Custom\/fa_code.pm/)) {
      my $fa_c="\t  lib\/Net\/FullAuto\/Custom\/fa_code.pm ".
               "blib\/lib\/Net\/FullAuto\/Custom\/fa_code.pm";
      my $wrap='';
      $inherited =~ /\s+blib.*Distro\/fa_code.pm( \\)/m;
      $wrap=$1;
      $inherited =~
         s/(\s+blib.*Distro\/fa_code.pm).*/$1 \\\n$fa_c$wrap/m;
   } else {
      $inherited =~ s/.*Custom\/fa_code.pm.*\n//m;
   }
   
   $inherited =~ s/\s+\\(\s*[$][(]NOE)/$1/s;
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_conf.pm") {
      $inherited .= "\t\$(SED) \'s/^#[ ]*\\(.\\)editor[ ]*[=].*/".
                 '\\1'."editor = $editor;/g\' ".
                 "<blib/lib/Net/FullAuto/Custom/fa_conf.pm >tmp_conf.pm\n".
                 "\t\$(MV) tmp_conf.pm blib/lib/Net/FullAuto/Custom/fa_conf.pm\n\n";
   } else {
      $inherited .= "\n";
   }

   $inherited;

}
