#!perl -T
use 5.006;
use strict;
use warnings;
use Test::More;
use Test::Warn;
use Test::Exception;
use XML::Twig;

use Device::PaloAlto::Firewall;

plan tests => 7;

my $fw = Device::PaloAlto::Firewall->new(uri => 'http://localhost.localdomain', username => 'test', password => 'test', debug => 1);
my $test = $fw->tester();

# No interfaces configured
$fw->meta->add_method('_send_request', sub { return XML::Twig->new()->safe_parse( no_interfaces_configured() )->simplify( forcearray => ['entry'] )->{result} } );

ok( !$test->interface_errors_logical(), "No interfaces returns false" );

# Interfaces with data
$fw->meta->add_method('_send_request', sub { return XML::Twig->new()->safe_parse( interface_counters() )->simplify( forcearray => ['entry'] )->{result} } );

ok( !$test->interface_errors_logical(), "Two interfaces with errors greater than default percent threshold" );
ok( !$test->interface_errors_logical(percent => 17), "One interface with errors greater than 17%");
ok( !$test->interface_errors_logical(percent => 18), "Tesing fractions (18.74%)");
ok( !$test->interface_errors_logical(percent => 18.73), "Tesing just below value returns 0");
ok( $test->interface_errors_logical(percent => 18.75), "Tesing just above value returns 1");
ok( $test->interface_errors_logical(percent => 20), "No interfaces with errors above 20%");



sub no_interfaces_configured {
   return <<'END'
<response status="success"><result>
  <ifnet>
    <ifnet/>
  </ifnet>
  <hw/>
</result></response>
END
}



# ethernet1/22.28 has had its ierrors manually increased to 200,000 (5.5505031%)
# ethernet1/22.30 has had its ierrors manually increased to 2,000,000 (18.7466198%)
sub interface_counters {
   return <<'END'
<response status="success"><result>
  <ifnet>
    <ifnet>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>0</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>0</obytes>
        <land>0</land>
        <name>ethernet1/1</name>
        <neighpend>0</neighpend>
        <ipackets>0</ipackets>
        <opackets>0</opackets>
        <l2_decap>0</l2_decap>
        <idrops>0</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>0</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>0</obytes>
        <land>0</land>
        <name>ethernet1/2</name>
        <neighpend>0</neighpend>
        <ipackets>0</ipackets>
        <opackets>0</opackets>
        <l2_decap>0</l2_decap>
        <idrops>0</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>0</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>0</obytes>
        <land>0</land>
        <name>ethernet1/4</name>
        <neighpend>0</neighpend>
        <ipackets>0</ipackets>
        <opackets>0</opackets>
        <l2_decap>0</l2_decap>
        <idrops>0</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>34442317</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>0</obytes>
        <land>0</land>
        <name>ethernet1/21</name>
        <neighpend>0</neighpend>
        <ipackets>110747</ipackets>
        <opackets>0</opackets>
        <l2_decap>0</l2_decap>
        <idrops>110747</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>552889204</ibytes>
        <noarp>4</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>127787709701</obytes>
        <land>0</land>
        <name>ethernet1/21.16</name>
        <neighpend>0</neighpend>
        <ipackets>7744309</ipackets>
        <opackets>380951587</opackets>
        <l2_decap>0</l2_decap>
        <idrops>4335811</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>269155412</ibytes>
        <noarp>4</noarp>
        <noroute>32</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>10919609585</obytes>
        <land>0</land>
        <name>ethernet1/21.18</name>
        <neighpend>0</neighpend>
        <ipackets>3815800</ipackets>
        <opackets>152351481</opackets>
        <l2_decap>0</l2_decap>
        <idrops>3325700</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>268387192</ibytes>
        <noarp>5</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>10504995677</obytes>
        <land>0</land>
        <name>ethernet1/21.20</name>
        <neighpend>0</neighpend>
        <ipackets>3805050</ipackets>
        <opackets>150025045</opackets>
        <l2_decap>0</l2_decap>
        <idrops>3327693</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>268526352</ibytes>
        <noarp>4</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>10505133433</obytes>
        <land>0</land>
        <name>ethernet1/21.22</name>
        <neighpend>0</neighpend>
        <ipackets>3807292</ipackets>
        <opackets>150027242</opackets>
        <l2_decap>0</l2_decap>
        <idrops>3325235</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>1042121883</ibytes>
        <noarp>17</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>801638587</obytes>
        <land>0</land>
        <name>ethernet1/21.24</name>
        <neighpend>0</neighpend>
        <ipackets>13803304</ipackets>
        <opackets>10746436</opackets>
        <l2_decap>0</l2_decap>
        <idrops>3344653</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>225931496</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>10189920</obytes>
        <land>0</land>
        <name>ethernet1/21.26</name>
        <neighpend>0</neighpend>
        <ipackets>3322522</ipackets>
        <opackets>221520</opackets>
        <l2_decap>0</l2_decap>
        <idrops>3322522</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>363434306</ibytes>
        <noarp>1527809</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>29163612</obytes>
        <land>0</land>
        <name>ethernet1/21.28</name>
        <neighpend>0</neighpend>
        <ipackets>4850331</ipackets>
        <opackets>629395</opackets>
        <l2_decap>0</l2_decap>
        <idrops>3322522</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>110</flowstate>
        <ipspoof>443</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>2200213502</ibytes>
        <noarp>17</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>475112009669</obytes>
        <land>0</land>
        <name>ethernet1/21.30</name>
        <neighpend>0</neighpend>
        <ipackets>28466101</ipackets>
        <opackets>617395308</opackets>
        <l2_decap>0</l2_decap>
        <idrops>5398486</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>722</flowstate>
        <ipspoof>10</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>621685061</ibytes>
        <noarp>1</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>207</zonechange>
        <obytes>1338990903</obytes>
        <land>0</land>
        <name>ethernet1/21.32</name>
        <neighpend>0</neighpend>
        <ipackets>9054948</ipackets>
        <opackets>5998161</opackets>
        <l2_decap>0</l2_decap>
        <idrops>8596524</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>0</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>0</obytes>
        <land>0</land>
        <name>ethernet1/22</name>
        <neighpend>0</neighpend>
        <ipackets>0</ipackets>
        <opackets>0</opackets>
        <l2_decap>0</l2_decap>
        <idrops>0</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>125</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>334812883183</ibytes>
        <noarp>4</noarp>
        <noroute>216</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>126847191345</obytes>
        <land>0</land>
        <name>ethernet1/22.16</name>
        <neighpend>0</neighpend>
        <ipackets>638174889</ipackets>
        <opackets>359529200</opackets>
        <l2_decap>0</l2_decap>
        <idrops>604047079</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>9</flowstate>
        <ipspoof>45178</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>532736076</ibytes>
        <noarp>5</noarp>
        <noroute>9</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>10976257240</obytes>
        <land>0</land>
        <name>ethernet1/22.18</name>
        <neighpend>0</neighpend>
        <ipackets>7672061</ipackets>
        <opackets>153294686</opackets>
        <l2_decap>0</l2_decap>
        <idrops>3407181</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>272059717</ibytes>
        <noarp>4</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>10505001581</obytes>
        <land>0</land>
        <name>ethernet1/22.20</name>
        <neighpend>0</neighpend>
        <ipackets>3837490</ipackets>
        <opackets>150025107</opackets>
        <l2_decap>0</l2_decap>
        <idrops>3327433</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>272236232</ibytes>
        <noarp>4</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>10505130246</obytes>
        <land>0</land>
        <name>ethernet1/22.22</name>
        <neighpend>0</neighpend>
        <ipackets>3840136</ipackets>
        <opackets>150027209</opackets>
        <l2_decap>0</l2_decap>
        <idrops>3325330</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>1042531371</ibytes>
        <noarp>17</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>794573347</obytes>
        <land>0</land>
        <name>ethernet1/22.24</name>
        <neighpend>0</neighpend>
        <ipackets>13808491</ipackets>
        <opackets>10685366</opackets>
        <l2_decap>0</l2_decap>
        <idrops>3344636</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>225931156</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>10189920</obytes>
        <land>0</land>
        <name>ethernet1/22.26</name>
        <neighpend>0</neighpend>
        <ipackets>3322517</ipackets>
        <opackets>221520</opackets>
        <l2_decap>0</l2_decap>
        <idrops>3322517</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>200000</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>251199556</ibytes>
        <noarp>280760</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>13676668</obytes>
        <land>0</land>
        <name>ethernet1/22.28</name>
        <neighpend>0</neighpend>
        <ipackets>3603277</ipackets>
        <opackets>296460</opackets>
        <l2_decap>0</l2_decap>
        <idrops>3322517</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>2000000</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>1041300858</ibytes>
        <noarp>17</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>793418413</obytes>
        <land>0</land>
        <name>ethernet1/22.30</name>
        <neighpend>0</neighpend>
        <ipackets>13792765</ipackets>
        <opackets>10668590</opackets>
        <l2_decap>0</l2_decap>
        <idrops>3344600</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>913</flowstate>
        <ipspoof>7</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>1372401233</ibytes>
        <noarp>1</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>39</zonechange>
        <obytes>460936668</obytes>
        <land>0</land>
        <name>ethernet1/22.32</name>
        <neighpend>0</neighpend>
        <ipackets>20263191</ipackets>
        <opackets>7013966</opackets>
        <l2_decap>0</l2_decap>
        <idrops>21803483</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>52372628</ibytes>
        <noarp>4</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>2534687802</obytes>
        <land>0</land>
        <name>ethernet1/23</name>
        <neighpend>0</neighpend>
        <ipackets>643675</ipackets>
        <opackets>40577777</opackets>
        <l2_decap>0</l2_decap>
        <idrops>12</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>831498385</ibytes>
        <noarp>4</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>1864156151</obytes>
        <land>0</land>
        <name>ethernet1/24</name>
        <neighpend>0</neighpend>
        <ipackets>13033811</ipackets>
        <opackets>28187439</opackets>
        <l2_decap>0</l2_decap>
        <idrops>6195127</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>0</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>0</obytes>
        <land>0</land>
        <name>dedicated-ha1</name>
        <neighpend>0</neighpend>
        <ipackets>0</ipackets>
        <opackets>0</opackets>
        <l2_decap>0</l2_decap>
        <idrops>0</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>40748398</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>84320677162</obytes>
        <land>0</land>
        <name>dedicated-ha2</name>
        <neighpend>0</neighpend>
        <ipackets>667167</ipackets>
        <opackets>254183329</opackets>
        <l2_decap>0</l2_decap>
        <idrops>0</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>0</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>0</obytes>
        <land>0</land>
        <name>vlan</name>
        <neighpend>0</neighpend>
        <ipackets>0</ipackets>
        <opackets>0</opackets>
        <l2_decap>0</l2_decap>
        <idrops>0</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>0</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>0</obytes>
        <land>0</land>
        <name>loopback</name>
        <neighpend>0</neighpend>
        <ipackets>0</ipackets>
        <opackets>0</opackets>
        <l2_decap>0</l2_decap>
        <idrops>0</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>1076347</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>0</obytes>
        <land>0</land>
        <name>loopback.1</name>
        <neighpend>0</neighpend>
        <ipackets>3416</ipackets>
        <opackets>0</opackets>
        <l2_decap>0</l2_decap>
        <idrops>6</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>31780</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>0</obytes>
        <land>0</land>
        <name>loopback.2</name>
        <neighpend>0</neighpend>
        <ipackets>454</ipackets>
        <opackets>0</opackets>
        <l2_decap>0</l2_decap>
        <idrops>0</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>0</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>0</obytes>
        <land>0</land>
        <name>loopback.3</name>
        <neighpend>0</neighpend>
        <ipackets>0</ipackets>
        <opackets>0</opackets>
        <l2_decap>0</l2_decap>
        <idrops>0</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>0</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>0</obytes>
        <land>0</land>
        <name>loopback.4</name>
        <neighpend>0</neighpend>
        <ipackets>0</ipackets>
        <opackets>0</opackets>
        <l2_decap>0</l2_decap>
        <idrops>0</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>0</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>0</obytes>
        <land>0</land>
        <name>tunnel</name>
        <neighpend>0</neighpend>
        <ipackets>0</ipackets>
        <opackets>0</opackets>
        <l2_decap>0</l2_decap>
        <idrops>0</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>0</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>0</obytes>
        <land>0</land>
        <name>tunnel.64</name>
        <neighpend>0</neighpend>
        <ipackets>0</ipackets>
        <opackets>0</opackets>
        <l2_decap>0</l2_decap>
        <idrops>0</idrops>
      </entry>
      <entry>
        <icmp_frag>0</icmp_frag>
        <ifwderrors>0</ifwderrors>
        <ierrors>0</ierrors>
        <macspoof>0</macspoof>
        <pod>0</pod>
        <flowstate>0</flowstate>
        <ipspoof>0</ipspoof>
        <teardrop>0</teardrop>
        <ibytes>0</ibytes>
        <noarp>0</noarp>
        <noroute>0</noroute>
        <noneigh>0</noneigh>
        <nomac>0</nomac>
        <l2_encap>0</l2_encap>
        <zonechange>0</zonechange>
        <obytes>0</obytes>
        <land>0</land>
        <name>tunnel.65</name>
        <neighpend>0</neighpend>
        <ipackets>0</ipackets>
        <opackets>0</opackets>
        <l2_decap>0</l2_decap>
        <idrops>0</idrops>
      </entry>
    </ifnet>
  </ifnet>
  <hw>
    <entry>
      <obytes>0</obytes>
      <name>ethernet1/1</name>
      <idrops>0</idrops>
      <ipackets>0</ipackets>
      <opackets>0</opackets>
      <ierrors>0</ierrors>
      <interface>ethernet1/1</interface>
      <ibytes>0</ibytes>
      <port>
        <tx-unicast>0</tx-unicast>
        <tx-multicast>0</tx-multicast>
        <rx-broadcast>0</rx-broadcast>
        <rx-unicast>0</rx-unicast>
        <rx-multicast>0</rx-multicast>
        <rx-bytes>0</rx-bytes>
        <tx-broadcast>0</tx-broadcast>
        <tx-bytes>0</tx-bytes>
      </port>
    </entry>
    <entry>
      <obytes>0</obytes>
      <name>ethernet1/2</name>
      <idrops>0</idrops>
      <ipackets>0</ipackets>
      <opackets>0</opackets>
      <ierrors>0</ierrors>
      <interface>ethernet1/2</interface>
      <ibytes>0</ibytes>
      <port>
        <tx-unicast>0</tx-unicast>
        <tx-multicast>0</tx-multicast>
        <rx-broadcast>0</rx-broadcast>
        <rx-unicast>0</rx-unicast>
        <rx-multicast>0</rx-multicast>
        <rx-bytes>0</rx-bytes>
        <tx-broadcast>0</tx-broadcast>
        <tx-bytes>0</tx-bytes>
      </port>
    </entry>
    <entry>
      <obytes>0</obytes>
      <name>ethernet1/4</name>
      <idrops>0</idrops>
      <ipackets>0</ipackets>
      <opackets>0</opackets>
      <ierrors>0</ierrors>
      <interface>ethernet1/4</interface>
      <ibytes>0</ibytes>
      <port>
        <tx-unicast>0</tx-unicast>
        <tx-multicast>0</tx-multicast>
        <rx-broadcast>0</rx-broadcast>
        <rx-unicast>0</rx-unicast>
        <rx-multicast>0</rx-multicast>
        <rx-bytes>0</rx-bytes>
        <tx-broadcast>0</tx-broadcast>
        <tx-bytes>0</tx-bytes>
      </port>
    </entry>
    <entry>
      <obytes>637009418438</obytes>
      <name>ethernet1/21</name>
      <idrops>0</idrops>
      <ipackets>80898377</ipackets>
      <opackets>1468346136</opackets>
      <ierrors>2117973</ierrors>
      <interface>ethernet1/21</interface>
      <ibytes>5990804625</ibytes>
      <port>
        <tx-unicast>5282519807</tx-unicast>
        <tx-multicast>0</tx-multicast>
        <rx-broadcast>42498</rx-broadcast>
        <rx-unicast>2646983169</rx-unicast>
        <rx-multicast>30057716</rx-multicast>
        <rx-bytes>1686662562746</rx-bytes>
        <tx-broadcast>1342451</tx-broadcast>
        <tx-bytes>4584239797222</tx-bytes>
      </port>
    </entry>
    <entry>
      <obytes>160906374932</obytes>
      <name>ethernet1/22</name>
      <idrops>0</idrops>
      <ipackets>710543496</ipackets>
      <opackets>841762097</opackets>
      <ierrors>2228682</ierrors>
      <interface>ethernet1/22</interface>
      <ibytes>340001736901</ibytes>
      <port>
        <tx-unicast>1465972055</tx-unicast>
        <tx-multicast>0</tx-multicast>
        <rx-broadcast>42464</rx-broadcast>
        <rx-unicast>4625819020</rx-unicast>
        <rx-multicast>30057578</rx-multicast>
        <rx-bytes>3556241697452</rx-bytes>
        <tx-broadcast>1021790</tx-broadcast>
        <tx-bytes>276960271550</tx-bytes>
      </port>
    </entry>
    <entry>
      <obytes>2534687736</obytes>
      <name>ethernet1/23</name>
      <idrops>0</idrops>
      <ipackets>754435</ipackets>
      <opackets>40577776</opackets>
      <ierrors>110760</ierrors>
      <interface>ethernet1/23</interface>
      <ibytes>59018228</ibytes>
      <port>
        <tx-unicast>34271821</tx-unicast>
        <tx-multicast>0</tx-multicast>
        <rx-broadcast>110761</rx-broadcast>
        <rx-unicast>28076617</rx-unicast>
        <rx-multicast>0</rx-multicast>
        <rx-bytes>1980888929</rx-bytes>
        <tx-broadcast>6305885</tx-broadcast>
        <tx-bytes>2812493288</tx-bytes>
      </port>
    </entry>
    <entry>
      <obytes>1864156151</obytes>
      <name>ethernet1/24</name>
      <idrops>0</idrops>
      <ipackets>13144571</ipackets>
      <opackets>28187439</opackets>
      <ierrors>110760</ierrors>
      <interface>ethernet1/24</interface>
      <ibytes>838143985</ibytes>
      <port>
        <tx-unicast>28076624</tx-unicast>
        <tx-multicast>0</tx-multicast>
        <rx-broadcast>6305885</rx-broadcast>
        <rx-unicast>34271825</rx-unicast>
        <rx-multicast>0</rx-multicast>
        <rx-bytes>2812493354</rx-bytes>
        <tx-broadcast>110760</tx-broadcast>
        <tx-bytes>1980889135</tx-bytes>
      </port>
    </entry>
    <entry>
      <obytes>84320677162</obytes>
      <name>ha2</name>
      <idrops>0</idrops>
      <ipackets>667167</ipackets>
      <opackets>254183329</opackets>
      <ierrors>0</ierrors>
      <interface>dedicated-ha2</interface>
      <ibytes>40748398</ibytes>
      <port>
        <tx-unicast>254181994</tx-unicast>
        <tx-multicast>0</tx-multicast>
        <rx-broadcast>332227</rx-broadcast>
        <rx-unicast>334940</rx-unicast>
        <rx-multicast>0</rx-multicast>
        <rx-bytes>43417066</rx-bytes>
        <tx-broadcast>21</tx-broadcast>
        <tx-bytes>85336969730</tx-bytes>
      </port>
    </entry>
    <entry>
      <obytes>0</obytes>
      <name>vlan</name>
      <idrops>0</idrops>
      <ipackets>0</ipackets>
      <opackets>0</opackets>
      <ierrors>0</ierrors>
      <interface>vlan</interface>
      <ibytes>0</ibytes>
    </entry>
    <entry>
      <obytes>0</obytes>
      <name>loopback</name>
      <idrops>0</idrops>
      <ipackets>3870</ipackets>
      <opackets>0</opackets>
      <ierrors>0</ierrors>
      <interface>loopback</interface>
      <ibytes>1108127</ibytes>
    </entry>
    <entry>
      <obytes>0</obytes>
      <name>tunnel</name>
      <idrops>0</idrops>
      <ipackets>0</ipackets>
      <opackets>0</opackets>
      <ierrors>0</ierrors>
      <interface>tunnel</interface>
      <ibytes>0</ibytes>
    </entry>
  </hw>
</result></response>
END
}

