package Acme::Cavaspazi;
# ABSTRACT: a simple script to remove spaces from filenames or file contents, but also a tribute to old school robust bioinformatics tools

use 5.012;
use warnings;
require Exporter;
our @ISA = qw(Exporter);

# Export subroutine cavaspazi
our @EXPORT = qw(cavaspazi);

$Acme::Cavaspazi::VERSION = "0.0.7";



sub cavaspazi {
    my @results = ();
    for my $i (@_) {
        my $result = $i;
        $result =~ s/ /_/g;
        push @results, $result;
    }
    # if input is a scalar, return a scalar
    if (@_ == 1) {
        return $results[0];
    } else {
        return @results;
    }
    
}

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::Cavaspazi - a simple script to remove spaces from filenames or file contents, but also a tribute to old school robust bioinformatics tools

=head1 VERSION

version 0.0.7

=head1 SYNOPSIS

  use Acme::Cavaspazi;
  my $input = "with spaces";
  my $filepath = cavaspazi($input);

=head2 cavaspazi()

Remove spaces from the input string or the strings in the input array

=head1 ACKNOWLEDGEMENTS

This module is a tribute to the resilience of pioneer bioinformaticians
working with Perl to convert files and fix formats.

The bioinformaticians trained by Nicola Vitulo are grateful for the
lack of spaces.

In those foggy times a script called C<cavaspazi.pl> became a pillar
of complex pipelines. It was cool, except it didn't remove spaces.

=back 
1;

=head1 AUTHOR

Andrea Telatin <proch@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2022 by Andrea Telatin, Nicola Vitulo.

This is free software, licensed under:

  The MIT (X11) License

=cut
