package Statocles::Event;
# ABSTRACT: Events objects for Statocles
$Statocles::Event::VERSION = '0.045';

package Statocles::Event::Pages;
$Statocles::Event::Pages::VERSION = '0.045';
use Statocles::Base 'Class';
extends 'Beam::Event';


has pages => (
    is => 'ro',
    isa => ArrayRef[ConsumerOf['Statocles::Page']],
    required => 1,
);

1;

__END__

=pod

=head1 NAME

Statocles::Event - Events objects for Statocles

=head1 VERSION

version 0.045

=head1 ATTRIBUTES

=head2 pages

An array of L<Statocles::Page> objects

=head1 EVENTS

=head2 Statocles::Event::Pages

An event with L<page objects|Statocles::Page>.

=head1 AUTHOR

Doug Bell <preaction@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Doug Bell.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
