#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use Tickit::Test;

use Tickit::Widget;

my $win = mk_window;

my $widget = TestWidget->new;
$widget->set_window( $win );

{
   my $warnings = "";
   local $SIG{__WARN__} = sub { $warnings .= join "", @_ };

   $widget->pen->chattr( fg => 2 );

   like( $warnings, qr/Pen mutation.*deprecated/, '->pen->chattr produces a warning' );
}

flush_tickit;

is_display( [ [TEXT("Hello",fg=>2), BLANK(75,fg=>2)] ],
            'Display with correct pen after pen->chattr' );

done_testing;

package TestWidget;

use base qw( Tickit::Widget );
use constant WIDGET_PEN_FROM_STYLE => 1;

sub render_to_rb
{
   my $self = shift;
   my ( $rb, undef ) = @_;

   $rb->text_at( 0, 0, "Hello" );
}

sub lines { 1 }
sub cols  { 5 }
