package Bencher::Scenario::DataDmp;

our $DATE = '2016-04-30'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark Data::Dmp',
    participants => [
        {name => 'Data::Dmp', fcall_template => 'Data::Dmp::dmp(<data>)'},
        {module => 'Data::Dump', code_template => 'my $dummy = Data::Dump::dump(<data>)'},
    ],
    datasets => [
        {
            name => 'a100-num-various',
            args => { data => [ (0, 1, -1, "+1", 1e100,
                                 -1e-100, "0123", "Inf", "-Inf", "NaN") x 10 ] },
        },
        {
            name => 'a100-num-int',
            args => { data => [ 1..100 ] },
        },
        {
            name => 'a100-str',
            args => { data => [ "a" x 100 ] },
        },
    ],
};

# ABSTRACT: Benchmark Data::Dmp

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataDmp - Benchmark Data::Dmp

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::DataDmp (from Perl distribution Bencher-Scenarios-DataDmp), released on 2016-04-30.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataDmp

To run module startup overhead benchmark:

 % bencher --module-startup -m DataDmp

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Data::Dmp> 0.19

L<Data::Dump> 1.23

=head1 BENCHMARK PARTICIPANTS

=over

=item * Data::Dmp (perl_code)

Function call template:

 Data::Dmp::dmp(<data>)



=item * Data::Dump (perl_code)

Code template:

 my $dummy = Data::Dump::dump(<data>)



=back

=head1 BENCHMARK DATASETS

=over

=item * a100-num-various

=item * a100-num-int

=item * a100-str

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataDmp >>):

 +-------------+------------------+-----------+-----------+------------+---------+---------+
 | participant | dataset          | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +-------------+------------------+-----------+-----------+------------+---------+---------+
 | Data::Dump  | a100-num-various | 2.07e+03  | 484       | 1          | 2.7e-07 | 20      |
 | Data::Dump  | a100-num-int     | 3.51e+03  | 285       | 1.7        | 2e-07   | 22      |
 | Data::Dmp   | a100-num-various | 6.4e+03   | 1.6e+02   | 3.1        | 2e-07   | 23      |
 | Data::Dmp   | a100-num-int     | 1.42e+04  | 70.5      | 6.87       | 2.5e-08 | 22      |
 | Data::Dump  | a100-str         | 8.26e+04  | 12.1      | 40         | 8.8e-09 | 26      |
 | Data::Dmp   | a100-str         | 266889    | 3.74687   | 129.16     | 0       | 20      |
 +-------------+------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m DataDmp --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Data::Dump          | 7.9       | 5.5                    | 1          | 3.5e-05 | 20      |
 | Data::Dmp           | 6.1       | 3.7                    | 1.3        | 2e-05   | 21      |
 | perl -e1 (baseline) | 2.4       | 0                      | 3.3        | 6.9e-06 | 20      |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataDmp>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-DataDmp>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataDmp>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
