package Bencher::Scenario::Accessors::Construction;

our $DATE = '2016-06-23'; # DATE
our $VERSION = '0.07'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark object construction',
    modules => {
        'Perl::Examples::Accessors' => {version=>0.05},
    },
    participants => [
        map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "${_}->new",
            };
        } keys %$classes,
    ],
    include_result_size => 1,
};

1;
# ABSTRACT: Benchmark object construction

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Construction - Benchmark object construction

=head1 VERSION

This document describes version 0.07 of Bencher::Scenario::Accessors::Construction (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-06-23.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Construction

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Construction

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors> 0.05

L<Perl::Examples::Accessors::Array> 0.05

L<Perl::Examples::Accessors::ClassAccessor> 0.05

L<Perl::Examples::Accessors::ClassAccessorArray> 0.05

L<Perl::Examples::Accessors::ClassInsideOut> 0.05

L<Perl::Examples::Accessors::ClassXSAccessor> 0.05

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.05

L<Perl::Examples::Accessors::Hash> 0.05

L<Perl::Examples::Accessors::Mo> 0.05

L<Perl::Examples::Accessors::MojoBase> 0.05

L<Perl::Examples::Accessors::Moo> 0.05

L<Perl::Examples::Accessors::Moose> 0.05

L<Perl::Examples::Accessors::Mouse> 0.05

L<Perl::Examples::Accessors::ObjectSimple> 0.05

L<Perl::Examples::Accessors::Scalar> 0.05

=head1 BENCHMARK PARTICIPANTS

=over

=item * Moose (perl_code)

Code template:

 Perl::Examples::Accessors::Moose->new



=item * Mo (perl_code)

Code template:

 Perl::Examples::Accessors::Mo->new



=item * no generator (scalar-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Scalar->new



=item * Mojo::Base (perl_code)

Code template:

 Perl::Examples::Accessors::MojoBase->new



=item * Class::Accessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessorArray->new



=item * Object::Simple (perl_code)

Code template:

 Perl::Examples::Accessors::ObjectSimple->new



=item * no generator (hash-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Hash->new



=item * Moo (perl_code)

Code template:

 Perl::Examples::Accessors::Moo->new



=item * Class::InsideOut (perl_code)

Code template:

 Perl::Examples::Accessors::ClassInsideOut->new



=item * Class::Accessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessor->new



=item * Class::XSAccessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessorArray->new



=item * Mouse (perl_code)

Code template:

 Perl::Examples::Accessors::Mouse->new



=item * no generator (array-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Array->new



=item * Class::XSAccessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessor->new



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Construction >>):

 +-----------------------------+-----------+-----------+------------+-----------------+---------+---------+
 | participant                 | rate (/s) | time (μs) | vs_slowest | result_size (b) |  errors | samples |
 +-----------------------------+-----------+-----------+------------+-----------------+---------+---------+
 | Class::InsideOut            |    170000 |     6     |       1    |             144 | 7.2e-09 |      27 |
 | Moose                       |    520000 |     1.9   |       3.2  |             120 | 3.4e-09 |      20 |
 | Mo                          |    730000 |     1.4   |       4.4  |             120 |   5e-09 |      20 |
 | Moo                         |   1070000 |     0.933 |       6.43 |             120 | 4.2e-10 |      20 |
 | Class::Accessor             |   1100000 |     0.93  |       6.4  |             120 | 1.7e-09 |      20 |
 | Mouse                       |   1500000 |     0.66  |       9    |             120 | 1.6e-09 |      21 |
 | no generator (array-based)  |   1700000 |     0.59  |      10    |              64 | 7.7e-10 |      24 |
 | no generator (hash-based)   |   1900000 |     0.52  |      12    |             120 | 9.9e-10 |      22 |
 | Object::Simple              |   1990000 |     0.503 |      11.9  |             120 | 9.1e-11 |      20 |
 | Mojo::Base                  |   2020000 |     0.496 |      12.1  |             120 | 2.7e-10 |      22 |
 | Class::Accessor::Array      |   2200000 |     0.46  |      13    |              64 | 8.3e-10 |      20 |
 | no generator (scalar-based) |   2280000 |     0.438 |      13.7  |              72 | 1.8e-10 |      20 |
 | Class::XSAccessor           |   3810000 |     0.262 |      22.9  |             120 | 1.1e-10 |      20 |
 | Class::XSAccessor::Array    |   3900000 |     0.26  |      23    |              64 | 8.8e-10 |      20 |
 +-----------------------------+-----------+-----------+------------+-----------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
