package Bencher::Scenario::Accessors::GeneratorStartup;

our $DATE = '2016-03-29'; # DATE
our $VERSION = '0.01'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark startup of various accessor generators',
    module_startup => 1,
    modules => {
    },
    participants => [
        map {
            my $spec = $classes->{$_};
            +{ (module=>$spec->{generator}) x !!$spec->{generator} };
        } keys %$classes,
    ],
};

1;
# ABSTRACT: Benchmark startup of various accessor generators

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::GeneratorStartup - Benchmark startup of various accessor generators

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::Accessors::GeneratorStartup (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-03-29.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::GeneratorStartup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Class::Accessor> 0.34

L<Class::Accessor::Array> 0.02

L<Class::XSAccessor> 1.19

L<Class::XSAccessor::Array> 1.19

L<Mo> 0.39

L<Moo> 2.000002

L<Moose> 2.1604

L<Mouse> v2.4.5

=head1 BENCHMARK PARTICIPANTS

=over

=item * Class::XSAccessor::Array (perl_code)

L<Class::XSAccessor::Array>



=item * Class::Accessor (perl_code)

L<Class::Accessor>



=item *  (perl_code)



=item *  (perl_code)



=item * Class::Accessor::Array (perl_code)

L<Class::Accessor::Array>



=item * Moose (perl_code)

L<Moose>



=item *  (perl_code)



=item * Class::XSAccessor (perl_code)

L<Class::XSAccessor>



=item * Mo (perl_code)

L<Mo>



=item * Mouse (perl_code)

L<Mouse>



=item * Moo (perl_code)

L<Moo>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::GeneratorStartup >>):

 +--------------------------+-----------+------------------------+------------+---------+---------+
 | participant              | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +--------------------------+-----------+------------------------+------------+---------+---------+
 | Moose                    | 1.8e+02   | 175                    | 1          | 0.0012  | 20      |
 | Mouse                    | 26        | 21                     | 7          | 7.7e-05 | 20      |
 | Moo                      | 20        | 15                     | 9          | 7.7e-05 | 20      |
 | Class::XSAccessor::Array | 13        | 8                      | 14         | 5.4e-05 | 20      |
 | Class::Accessor          | 1e+01     | 5                      | 1e+01      | 0.00016 | 20      |
 | Class::XSAccessor        | 12        | 7                      | 15         | 4.7e-05 | 20      |
 | Mo                       | 7         | 2                      | 26         | 3.1e-05 | 20      |
 | Class::Accessor::Array   | 6.8       | 1.8                    | 27         | 1.2e-05 | 20      |
 | perl -e1 (baseline)      | 5         | 0                      | 4e+01      | 8.4e-05 | 20      |
 +--------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
