package Bencher::Formatter::Sort;

our $DATE = '2016-01-19'; # DATE
our $VERSION = '0.31'; # VERSION

use 5.010001;
use strict;
use warnings;
#use Log::Any::IfLOG '$log';

use parent qw(Bencher::Formatter);

use Role::Tiny::With;
with 'Bencher::Role::ResultMunger';

sub munge_result {
    my ($self, $envres) = @_;

    # sort by default from slowest to fastest
    $envres->[2] = [sort {$b->{time} <=> $a->{time}} @{$envres->[2]}];
}

1;
# ABSTRACT: Sort rows

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Formatter::Sort - Sort rows

=head1 VERSION

This document describes version 0.31 of Bencher::Formatter::Sort (from Perl distribution Bencher), released on 2016-01-19.

=head1 DESCRIPTION

By default, sort from slowest (largest C<time> value) to fastest (smallest
C<time> value).

=for Pod::Coverage .*

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
