package JIRA::REST::Class::Project::Category;
use base qw( JIRA::REST::Class::Abstract );
use strict;
use warnings;
use v5.10;

our $VERSION = '0.01'; # TRIAL

# ABSTRACT: A helper class for C<JIRA::REST::Class> that represents the category of a JIRA project as an object.

__PACKAGE__->mk_data_ro_accessors(qw( description id name self ));

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

JIRA::REST::Class::Project::Category - A helper class for C<JIRA::REST::Class> that represents the category of a JIRA project as an object.

=head1 VERSION

version 0.01

=head1 READ-ONLY ACCESSORS

=head2 B<description>
The description of the project category.

=head2 B<id>
The ID of the project category.

=head2 B<name>
The name of the project category.

=head2 B<self>
Returns the JIRA REST API URL of the project category.

=head1 AUTHOR

Packy Anderson <packy@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Packy Anderson.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
