# $Id: 30assume_rrd_filename.t 426 2006-05-01 17:13:15Z nicolaw $

my $rrdfile = -d 't' ? 't/30assume_rrd_filename.rrd' : '30assume_rrd_filename.rrd';
unlink $rrdfile if -f $rrdfile;

use strict;
use Test::More tests => 4;
use lib qw(./lib ../lib);
use RRD::Simple ();

ok(RRD::Simple->create(
		bytesIn => 'GAUGE',
		bytesOut => 'GAUGE',
		faultsPerSec => 'COUNTER'
	),'create');

my $updated = time();
ok(RRD::Simple->update(
		bytesIn => 10039,
		bytesOut => 389,
		faultsPerSec => 0.4
	),'update');

ok(RRD::Simple->last() - $updated < 5 && RRD::Simple->last(),
	'last');

ok(join(',',sort RRD::Simple->sources()) eq 'bytesIn,bytesOut,faultsPerSec',
	'sources');

unlink $rrdfile if -f $rrdfile;

1;

