my $rrdfile = -d 't' ? 't/08test.rrd' : '08test.rrd';
unlink $rrdfile if -f $rrdfile;

use strict;
use Test::More tests => 4;
use lib qw(./lib ../lib);
use RRD::Simple ();

ok(RRD::Simple->create($rrdfile,
		foo => 'GAUGE',
		bar => 'COUNTER'
	),'create');

ok(RRD::Simple->update($rrdfile,
		foo => 1024,
		bar => 4096,
	),'update');

my $info = {};
ok($info = RRD::Simple->info($rrdfile),'get info'); 
ok($info->{ds}->{foo}->{type} eq 'GAUGE','check info');

unlink $rrdfile if -f $rrdfile;

__END__

$VAR1 = {
          'rra[0].cdp_prep[1].unknown_datapoints' => 0,
          'rra[2].cdp_prep[1].value' => undef,
          'ds[foo].type' => 'GAUGE',
          'rra[12].pdp_per_row' => 1,
          'rra[12].cf' => 'MIN',
          'rra[11].cdp_prep[0].value' => undef,
          'rra[5].cdp_prep[1].value' => undef,
          'rra[5].cdp_prep[0].value' => undef,
          'rra[11].cf' => 'MAX',
          'rra[3].cdp_prep[1].value' => undef,
          'rra[14].cdp_prep[1].value' => undef,
          'rra[12].cdp_prep[1].value' => undef,
          'rra[6].xff' => '0.5',
          'ds[bar].max' => undef,
          'rra[13].cdp_prep[1].unknown_datapoints' => 4,
          'rrd_version' => '0001',
          'rra[8].cdp_prep[0].unknown_datapoints' => 0,
          'rra[4].cdp_prep[1].value' => undef,
          'rra[1].cdp_prep[1].value' => undef,
          'rra[0].cdp_prep[1].value' => undef,
          'rra[15].rows' => 796,
          'rra[1].pdp_per_row' => 6,
          'rra[2].cdp_prep[1].unknown_datapoints' => 16,
          'rra[13].pdp_per_row' => 6,
          'rra[10].cdp_prep[1].value' => undef,
          'rra[8].cdp_prep[1].value' => undef,
          'rra[13].rows' => 700,
          'rra[14].cdp_prep[0].value' => undef,
          'ds[bar].unknown_sec' => 173,
          'rra[3].xff' => '0.5',
          'rra[10].cdp_prep[1].unknown_datapoints' => 16,
          'rra[1].cf' => 'AVERAGE',
          'rra[12].rows' => 599,
          'rra[0].xff' => '0.5',
          'rra[14].pdp_per_row' => 24,
          'rra[3].rows' => 796,
          'ds[bar].type' => 'COUNTER',
          'filename' => 't/08test.rrd',
          'rra[8].cdp_prep[1].unknown_datapoints' => 0,
          'rra[7].cdp_prep[1].value' => undef,
          'rra[15].cdp_prep[1].value' => undef,
          'rra[7].cdp_prep[0].unknown_datapoints' => 16,
          'rra[0].cf' => 'AVERAGE',
          'rra[5].cf' => 'LAST',
          'rra[2].cdp_prep[0].unknown_datapoints' => 16,
          'rra[5].cdp_prep[1].unknown_datapoints' => 4,
          'rra[4].xff' => '0.5',
          'rra[15].cf' => 'MIN',
          'rra[4].cdp_prep[0].value' => undef,
          'ds[foo].unknown_sec' => 173,
          'rra[6].cdp_prep[1].unknown_datapoints' => 16,
          'rra[2].xff' => '0.5',
          'rra[14].rows' => 775,
          'rra[5].pdp_per_row' => 6,
          'rra[8].rows' => 599,
          'rra[4].pdp_per_row' => 1,
          'rra[12].cdp_prep[1].unknown_datapoints' => 0,
          'rra[15].cdp_prep[1].unknown_datapoints' => 16,
          'rra[11].rows' => 796,
          'rra[14].cf' => 'MIN',
          'rra[13].cf' => 'MIN',
          'rra[8].pdp_per_row' => 1,
          'rra[14].xff' => '0.5',
          'rra[0].cdp_prep[0].unknown_datapoints' => 0,
          'rra[4].cdp_prep[0].unknown_datapoints' => 0,
          'rra[6].rows' => 775,
          'rra[7].xff' => '0.5',
          'rra[0].cdp_prep[0].value' => undef,
          'ds[bar].value' => '0',
          'rra[11].cdp_prep[1].value' => undef,
          'rra[7].pdp_per_row' => 228,
          'rra[10].cf' => 'MAX',
          'rra[8].cdp_prep[0].value' => undef,
          'rra[1].rows' => 700,
          'ds[foo].minimal_heartbeat' => 600,
          'rra[3].cdp_prep[0].unknown_datapoints' => 16,
          'rra[6].cdp_prep[0].value' => undef,
          'rra[0].rows' => 599,
          'rra[13].cdp_prep[1].value' => undef,
          'rra[9].rows' => 700,
          'rra[6].cf' => 'LAST',
          'rra[10].pdp_per_row' => 24,
          'rra[3].pdp_per_row' => 228,
          'rra[0].pdp_per_row' => 1,
          'rra[1].cdp_prep[1].unknown_datapoints' => 4,
          'rra[2].cdp_prep[0].value' => undef,
          'rra[15].pdp_per_row' => 228,
          'rra[14].cdp_prep[1].unknown_datapoints' => 16,
          'ds[foo].max' => undef,
          'rra[13].xff' => '0.5',
          'last_update' => 1134350573,
          'rra[6].cdp_prep[0].unknown_datapoints' => 16,
          'rra[4].cf' => 'LAST',
          'rra[4].cdp_prep[1].unknown_datapoints' => 0,
          'rra[7].cdp_prep[0].value' => undef,
          'rra[15].cdp_prep[0].unknown_datapoints' => 16,
          'rra[11].cdp_prep[0].unknown_datapoints' => 16,
          'ds[bar].min' => undef,
          'rra[9].cdp_prep[0].value' => undef,
          'rra[3].cdp_prep[1].unknown_datapoints' => 16,
          'rra[11].cdp_prep[1].unknown_datapoints' => 16,
          'rra[11].xff' => '0.5',
          'rra[13].cdp_prep[0].unknown_datapoints' => 4,
          'rra[10].cdp_prep[0].value' => undef,
          'rra[2].pdp_per_row' => 24,
          'rra[13].cdp_prep[0].value' => undef,
          'rra[8].cf' => 'MAX',
          'step' => 300,
          'rra[6].cdp_prep[1].value' => undef,
          'rra[3].cf' => 'AVERAGE',
          'rra[1].cdp_prep[0].value' => undef,
          'rra[9].cf' => 'MAX',
          'rra[12].xff' => '0.5',
          'rra[4].rows' => 599,
          'rra[3].cdp_prep[0].value' => undef,
          'rra[1].xff' => '0.5',
          'ds[foo].last_ds' => 'UNKN',
          'ds[bar].last_ds' => '4096',
          'rra[9].pdp_per_row' => 6,
          'rra[10].rows' => 775,
          'rra[6].pdp_per_row' => 24,
          'ds[foo].min' => undef,
          'rra[15].xff' => '0.5',
          'rra[7].cf' => 'LAST',
          'rra[2].cf' => 'AVERAGE',
          'rra[12].cdp_prep[0].unknown_datapoints' => 0,
          'rra[12].cdp_prep[0].value' => undef,
          'rra[2].rows' => 775,
          'rra[7].rows' => 796,
          'rra[9].cdp_prep[1].value' => undef,
          'rra[5].cdp_prep[0].unknown_datapoints' => 4,
          'rra[14].cdp_prep[0].unknown_datapoints' => 16,
          'ds[bar].minimal_heartbeat' => 600,
          'rra[5].xff' => '0.5',
          'rra[8].xff' => '0.5',
          'rra[10].cdp_prep[0].unknown_datapoints' => 16,
          'rra[7].cdp_prep[1].unknown_datapoints' => 16,
          'rra[9].xff' => '0.5',
          'rra[9].cdp_prep[0].unknown_datapoints' => 4,
          'rra[15].cdp_prep[0].value' => undef,
          'rra[11].pdp_per_row' => 228,
          'rra[9].cdp_prep[1].unknown_datapoints' => 4,
          'rra[1].cdp_prep[0].unknown_datapoints' => 4,
          'ds[foo].value' => '0',
          'rra[5].rows' => 700,
          'rra[10].xff' => '0.5'
        };

