'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) tkerror.n 1.19 97/10/31 12:58:53
'\" 
.so man.macros
.TH Tk::Error n 4.1 Tk "Perl/Tk Constructs"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Tk::Error \- Method invoked to process background errors
.SH SYNOPSIS
\fBrequire Tk::ErrorDialog;\fR
.br
\fIor\fR
.br
sub \fBTk::Error\fR
.br
{
.br
\& my (\fI$mainwindow,$error,@locations\fR) = \fB@_\fR;
.br
 ...
.br
}
.br
.BE
.SH DESCRIPTION
.PP
The \fBTk::Error\fR method is invoked by perl/Tk when a background 
error occurs. Two possible implementations are provided in the 
distribution and individual applications or users can define a \fBTk::error\fR
method (e.g. as a perl sub) if they wish to handle background
errors in some other manner.
.PP
A background error is one that occurs in a command that didn't
originate with the application.  For example, if an error occurs
while executing a command specified with a \fBbind\fR of \fBafter\fR
command, then it is a background error.  For a non-background error,
the error can simply be returned up through nested Tcl command
evaluations until it reaches the top-level code in the application;
then the application can report the error in whatever way it
wishes.  When a background error occurs, the unwinding ends in
the Tk library and there is no obvious way for Tk to report
the error.
.PP
.VS
When Tk detects a background error, it saves information about the
error and invokes the \fBTk::Error\fR command later when Tk is idle.
.sp 1
\fBTk::Error\fR is invoked by perl/Tk as if by the perl code:
.br
\fI$mainwindow\fR->\fBTk::Error\fR(\fI"error message"\fR,\fIlocation ...\fR);
.br
.sp 1
\fI$mainwindow\fR is the \fBMainWindow\fR associated with widget which 
detected the error, \fI"error message"\fR is a string describing the error
that has been detected, \fIlocation\fR is a list of one or more "locations"
which describe the call sequence at the point the error was detected.
.PP
The locations are a typically a mixture of perl location reports giving
script name and line number, and simple strings describing locations in 
core Tk or perl/Tk C code. 
.PP
Tk will ignore any result returned by the \fBTk::Error\fR command.
If another error occurs within the \fBTk::Error\fR command
(for example if it calls \fBdie\fR) then Tk reports this error 
itself by writing a message to stderr (this is to avoid infinite loops
due to any bugs in \fBTk::Error\fR).
.PP
If several background errors accumulate before \fBTk::Error\fR
is invoked to process them, \fBTk::Error\fR will be invoked once
for each error, in the order they occurred.
However, if \fBTk::Error\fR calls \fBTk->break\fR, then
any remaining errors are skipped without calling \fBTk::Error\fR.
.PP
The \fITk.pm\fR file includes a default (AutoLoadable) \fBTk::Error\fR 
that simply reports the error on stderr.
.PP
An alternate definition is provided via : 
.br
\fBrequire Tk::ErrorDialog;\fR
.br
that posts a dialog box containing the error message and offers
the user a chance to see a stack trace showing where the
error occurred.

.SH BUGS
If \fBafter\fR or \fBfileevent\fR are not invoked as methods of a widget
then perl/Tk is unable to provide a \fI$mainwindow\fR argument.
To support such code from earlier versions of perl/Tk 
perl/Tk therefore calls \fBTk::Error\fR with string 'Tk' instead: 
\fBTk->Tk::Error\(...\)\fR.
In this case the \fBTk::Error\fR in \fBTk::ErrorDialog\fR and similar 
implementations cannot "popup" a window as they don't know which display
to use. I mechanism to supply \fIthe\fR \fBMainWindow\fR in applications
which only have one (a very common case) should be provided.

.SH "SEE ALSO"
bind
after
fileevent

.SH KEYWORDS
background error, reporting
