use strict;
use warnings;

use Test::More tests => 90;
use Crypt::PK::DSA;

my $data = [
  {SIZE=>512,PRI_FILE=>'key_512-1.pri.pem',PUB_FILE=>'key_512-1.pub.pem',PRI=>'53faaa79adc02e31ce2865e09393d321978b0b84',PUB=>'2b7cd87cef58954dab4368d51cb96d063317e018def42fd4bb0703a3c7c7cc31b81683197e49bb0c9076f0f6bf2d210380c54f5a1f166c0b0f25b933d4f6fcfd',DSA_SHA1=>'302c02141b9ee2d783233c759384d029875e6cc8b69038d9021475e1ddede6d839c6dca249b0415eaf426a793f21',DSA_SHA256=>'302c02140363f4b1dfaf90d8d6acaf158b205ca0d3948bc702143155b536047e44b7554355fe926f7409c29d2d07',PRI_DER=>'3081f7020100024100dd47e95c66ccd30418c25aff403bdd09ef907699f7168fb34893e2722d76ab62ac31503a1d32e6ec6f8dc209ad35c90a055520d87b0496c27c22c4a75e90994f0215009043e406a88f6cc9af5d620512424fc501c418e102405057ac1eaab6313f35c23aad24f11f85c4adf5d2d81cfac94cae2a0fe9641825a8eeedda170d596b0f9ac857b59d3fd803f4eff9eb16cde387b8b48ca969778702402b7cd87cef58954dab4368d51cb96d063317e018def42fd4bb0703a3c7c7cc31b81683197e49bb0c9076f0f6bf2d210380c54f5a1f166c0b0f25b933d4f6fcfd021453faaa79adc02e31ce2865e09393d321978b0b84',PUB_DER=>'3081f03081a806072a8648ce38040130819c024100dd47e95c66ccd30418c25aff403bdd09ef907699f7168fb34893e2722d76ab62ac31503a1d32e6ec6f8dc209ad35c90a055520d87b0496c27c22c4a75e90994f0215009043e406a88f6cc9af5d620512424fc501c418e102405057ac1eaab6313f35c23aad24f11f85c4adf5d2d81cfac94cae2a0fe9641825a8eeedda170d596b0f9ac857b59d3fd803f4eff9eb16cde387b8b48ca969778703430002402b7cd87cef58954dab4368d51cb96d063317e018def42fd4bb0703a3c7c7cc31b81683197e49bb0c9076f0f6bf2d210380c54f5a1f166c0b0f25b933d4f6fcfd'},
  {SIZE=>1024,PRI_FILE=>'key_1024-1.pri.pem',PUB_FILE=>'key_1024-1.pub.pem',PRI=>'1c59ff18088e085ff6ad546f902536b7d92d4664',PUB=>'4e2f8de47faa96295eec8c12f4e69bdadcc911cb013c23ba84621abe72a6497c1ee64524ca19c4adb64e438ba72f2d0b879e362fce0208ee67136da3bf7acb2f64fb9695062c4d7d67f4f848d60ce25e03415b041c3218e22ad145a2f4e203dbdbd0ddcf92ee131d3201c179538eff896438dd7cf98c54f20218516a0192ca80',DSA_SHA1=>'302c02142596d20c3c1922aa08794d13180d5b1ef9ccf76102141df0e2d0241d50da26c812fc464afd2aff2f9be3',DSA_SHA256=>'302c02141bbb545956785ab5b34bb4606ed82ef2bde6f2c0021425dd6c191efb0c709c7266f4fb8819154b5924ab',PRI_DER=>'308201bb020100028181009de4a90812fd9998704cac7d43c789c3fa13aed3e3ad426ba063c06e722b52f217c7dc4717fc03798220d84e880ad9200b45b0ca1add4b423242bbaee134d8a91467a79423ca499857897606dffb5f53565490a8040038431959eebc9d04a319136eff5c5e353eaf8740c25286ef0dee9ea8b602ea7e948702f9087ace8249b5021500876df298aebc94a3a4ac0831743cd7be00873627028181009d5eea2e5644112c0eb3ca36d8b3578755914d076d2ced54246f67a1ecb149524c4c183143854d7b75e7b5111227c95412fd312ac22ac5c28dba33ca4aae3cb35a0f8d4a131a2aa2317ecae04e5fbea9dbee056a7dc8794f4be31c2496ac15cec6eaff1df6a6859c82476a6c172ade0112ed6ac8cbb282db0e381a87e62bb3c20281804e2f8de47faa96295eec8c12f4e69bdadcc911cb013c23ba84621abe72a6497c1ee64524ca19c4adb64e438ba72f2d0b879e362fce0208ee67136da3bf7acb2f64fb9695062c4d7d67f4f848d60ce25e03415b041c3218e22ad145a2f4e203dbdbd0ddcf92ee131d3201c179538eff896438dd7cf98c54f20218516a0192ca8002141c59ff18088e085ff6ad546f902536b7d92d4664',PUB_DER=>'308201b73082012c06072a8648ce3804013082011f028181009de4a90812fd9998704cac7d43c789c3fa13aed3e3ad426ba063c06e722b52f217c7dc4717fc03798220d84e880ad9200b45b0ca1add4b423242bbaee134d8a91467a79423ca499857897606dffb5f53565490a8040038431959eebc9d04a319136eff5c5e353eaf8740c25286ef0dee9ea8b602ea7e948702f9087ace8249b5021500876df298aebc94a3a4ac0831743cd7be00873627028181009d5eea2e5644112c0eb3ca36d8b3578755914d076d2ced54246f67a1ecb149524c4c183143854d7b75e7b5111227c95412fd312ac22ac5c28dba33ca4aae3cb35a0f8d4a131a2aa2317ecae04e5fbea9dbee056a7dc8794f4be31c2496ac15cec6eaff1df6a6859c82476a6c172ade0112ed6ac8cbb282db0e381a87e62bb3c2038184000281804e2f8de47faa96295eec8c12f4e69bdadcc911cb013c23ba84621abe72a6497c1ee64524ca19c4adb64e438ba72f2d0b879e362fce0208ee67136da3bf7acb2f64fb9695062c4d7d67f4f848d60ce25e03415b041c3218e22ad145a2f4e203dbdbd0ddcf92ee131d3201c179538eff896438dd7cf98c54f20218516a0192ca80'},
  {SIZE=>1536,PRI_FILE=>'key_1536-1.pri.pem',PUB_FILE=>'key_1536-1.pub.pem',PRI=>'630c5e35d645b884c0de84055feceed4d5cd55a1',PUB=>'67b3a9dcdbdfe145df560b5b3226827489cda4987b7103bd4b4857b4826ea1e39fb6bc56ff6eec5775963baf2ce673268e5b3b8519e6d2e1d6a7355c4be977086f288a0dc68c5823426580287bb347505c2eed5ed6b0c377b261a3941a97e2e0da0feb0cb7e7ba65c7e2e3d1704a1ce977c543c2f8c1c5e4634049ecbab3271f15d0d59a7305b6ae312677a32836ae4e2b1e4f37372df0760c152472104953955501f8e37a70e6e8ca8cd7e90bd4a79c070a79dbe20eb48cd17704c2b803e3ca',DSA_SHA1=>'302c0214534053ef9a874980e394edf7158c5a3f0effc2f4021406e384a6bb00df3dbed75ad1cfe044efd4227c72',DSA_SHA256=>'302c02141ecbfc3e5bddc6f06e25925622b9770e5c9eaf74021446f42b32a5ee8647f77419b3e114733946d442fa',PRI_DER=>'3082027b0201000281c100a4ca1614ae22c8e03cc012db3f07b5d08f82fe0b51f895d57359fb928c04a2654ca8a184776341fea9d3e18b74d562bc506d477eb9b35fa5eecda63a11fd62f95872b1dff55858b41273ae2cde311e0b7e945128b5f796a71136fbb02fab0fb17008ae2b91818ac6c5d8f5729f8d843efc042f686da1bd530dd15a88bd253024a66f94710b1444dc190a439ab8888169ea847751d767290ff00991c022a46cd10a7fef1c7263ac6793a1a2c1a26932aee4cf138e7690d7117e5eb4a2d92ff27d02150087bd7144a9eb4b7a915fa3aaf3ce33827545deff0281c100860ab0c50678098f84b43f3b64a25fe9a4c4f5830b08986ba0853b80196eb4e8bdafc262b00c26bb54175e229dd0fec2ec4be42c0511ef4959b1ea7efd2f9fd196b3e41345798fc733ddeded1e390f0cde596b31f3ac4e541c942112d6da33ce1657f238f8ae44eb88562471951af02f25e97162465ddb25113b5d3557d55cdea1fccd7a047e07dad60e1ed4131a166dd502e4c022af28e489bbcef8245ff8cefa26395b24c111a3e0616072dafb3f9c6c6d17d4404c6fd33a1827f3a99b548f0281c067b3a9dcdbdfe145df560b5b3226827489cda4987b7103bd4b4857b4826ea1e39fb6bc56ff6eec5775963baf2ce673268e5b3b8519e6d2e1d6a7355c4be977086f288a0dc68c5823426580287bb347505c2eed5ed6b0c377b261a3941a97e2e0da0feb0cb7e7ba65c7e2e3d1704a1ce977c543c2f8c1c5e4634049ecbab3271f15d0d59a7305b6ae312677a32836ae4e2b1e4f37372df0760c152472104953955501f8e37a70e6e8ca8cd7e90bd4a79c070a79dbe20eb48cd17704c2b803e3ca0214630c5e35d645b884c0de84055feceed4d5cd55a1',PUB_DER=>'30820277308201ac06072a8648ce3804013082019f0281c100a4ca1614ae22c8e03cc012db3f07b5d08f82fe0b51f895d57359fb928c04a2654ca8a184776341fea9d3e18b74d562bc506d477eb9b35fa5eecda63a11fd62f95872b1dff55858b41273ae2cde311e0b7e945128b5f796a71136fbb02fab0fb17008ae2b91818ac6c5d8f5729f8d843efc042f686da1bd530dd15a88bd253024a66f94710b1444dc190a439ab8888169ea847751d767290ff00991c022a46cd10a7fef1c7263ac6793a1a2c1a26932aee4cf138e7690d7117e5eb4a2d92ff27d02150087bd7144a9eb4b7a915fa3aaf3ce33827545deff0281c100860ab0c50678098f84b43f3b64a25fe9a4c4f5830b08986ba0853b80196eb4e8bdafc262b00c26bb54175e229dd0fec2ec4be42c0511ef4959b1ea7efd2f9fd196b3e41345798fc733ddeded1e390f0cde596b31f3ac4e541c942112d6da33ce1657f238f8ae44eb88562471951af02f25e97162465ddb25113b5d3557d55cdea1fccd7a047e07dad60e1ed4131a166dd502e4c022af28e489bbcef8245ff8cefa26395b24c111a3e0616072dafb3f9c6c6d17d4404c6fd33a1827f3a99b548f0381c4000281c067b3a9dcdbdfe145df560b5b3226827489cda4987b7103bd4b4857b4826ea1e39fb6bc56ff6eec5775963baf2ce673268e5b3b8519e6d2e1d6a7355c4be977086f288a0dc68c5823426580287bb347505c2eed5ed6b0c377b261a3941a97e2e0da0feb0cb7e7ba65c7e2e3d1704a1ce977c543c2f8c1c5e4634049ecbab3271f15d0d59a7305b6ae312677a32836ae4e2b1e4f37372df0760c152472104953955501f8e37a70e6e8ca8cd7e90bd4a79c070a79dbe20eb48cd17704c2b803e3ca'},
  {SIZE=>2048,PRI_FILE=>'key_2048-1.pri.pem',PUB_FILE=>'key_2048-1.pub.pem',PRI=>'5ca7ce7397dd512ab599883efc620734fcd0742eeb6adb07a663508cb74adf4e',PUB=>'49f560fa511efc8614fda1be58146bc92e5799788bebd7d317fb97bbbe2df363d2188b29344a33300e76da04f3bfe5ca048413991b3491f9acdd06f8347fed58a28a2f7d95a431190fa4a0fa56221562204dd97fb2db1304e936dce96d85f768e9a7bef22bfc4f81cf535a625b7b8b643a89e9416a0c2c27806e4fa20000ff617d124a168f35f9ab47855429c5c5d95582a798826a333273f024b0e2bea5d2c56535bdbb47e5312844ce71512f941b4c14db30a3a3d0face56e90dae0d02b2f5136b27dbb85fe9da160a9f76e69cbf0a5732bc1bc0ead82632250d046bdd986bfd177c58f39bc38a3ed79387ff0912cfd09198d15abfc9743c493cc62300e034',DSA_SHA1=>'304402206933c92131ae35fc927a3048cc034d201d32dfb416da1bd64908c80360db70240220530dae54a59c2e01f6c20a463fcf6943698810694ce1f8b7133a77af07cfb95e',DSA_SHA256=>'304502204b6316c274f294cbb520f80bbc4d87dc7afcaa87d8a05a677341e12fd89ee7c902210083e1b36acc4b31fb6d306a56684c81fa2b671c82b0a2564612abe14c7ced1bd2',PRI_DER=>'308203550201000282010100bae9f4e5dd259b1060ea6ff3b82c3b97e1f02b0c425b20e5d4c5d047a94d1f82509cff932ffba7c5e9b52da023903c325ae61061084dc3151ee3706523c7de8f9fea845a33415f7b53990be646a8b628d5ccbfc89b0fc7013b42ad5297281f3c0e04475544ce23f75429a5c5590d7547349ab1bae2e1167366ecccdbfe845890131692601ab0ebe62ea26dc4c01f62c501bcb34ff91d4023938a09e23d783c06092850a7dcec9a87fbb86ff497336129f67cab5c28e467f2ea39043f14233da6ef42a98d8e4c3f125b124577dbd6dd6a41293c80b542e40e309cfff667c981b678474d87fc386e6bff62f267b1e2a51a6e80788c7d598d48006e64756656465f022100b264d85ef485a50705816616ae53043812eb180375c6a1d68924ba9e741c8aaf02820100127400355ca7e838353e051904a3ab2fd02a6efc82605d435cdacfb588c30fabdc0d65ba66d7004ec30f557812bc112269f2cdcfa2354860851d991aa2155a2f06a1c5d96c738c113571f77849c5e31baf01ca9b8d95485a3665e329887d33524cec864375ee9f262464a062943b6fb9cddddfc6fc8b14639dcf52be4d3761318c9aa3a7260e3c3914a4b4561caa20a68df5acc856ea5a134d658f071364e58e79229a829c3d7d9fe499daa11fad49ec7a441d24f71e4d20517a4d5eb4bdf21348317b6bdd7b85e9871a02c32ee3b1af0231638ee4da86d04912123d90c8aed6310fff61f6aa060423a7f6abf2f05613cda96d1eadb343d43ff9bdacaab56eba0282010049f560fa511efc8614fda1be58146bc92e5799788bebd7d317fb97bbbe2df363d2188b29344a33300e76da04f3bfe5ca048413991b3491f9acdd06f8347fed58a28a2f7d95a431190fa4a0fa56221562204dd97fb2db1304e936dce96d85f768e9a7bef22bfc4f81cf535a625b7b8b643a89e9416a0c2c27806e4fa20000ff617d124a168f35f9ab47855429c5c5d95582a798826a333273f024b0e2bea5d2c56535bdbb47e5312844ce71512f941b4c14db30a3a3d0face56e90dae0d02b2f5136b27dbb85fe9da160a9f76e69cbf0a5732bc1bc0ead82632250d046bdd986bfd177c58f39bc38a3ed79387ff0912cfd09198d15abfc9743c493cc62300e03402205ca7ce7397dd512ab599883efc620734fcd0742eeb6adb07a663508cb74adf4e',PUB_DER=>'308203463082023906072a8648ce3804013082022c0282010100bae9f4e5dd259b1060ea6ff3b82c3b97e1f02b0c425b20e5d4c5d047a94d1f82509cff932ffba7c5e9b52da023903c325ae61061084dc3151ee3706523c7de8f9fea845a33415f7b53990be646a8b628d5ccbfc89b0fc7013b42ad5297281f3c0e04475544ce23f75429a5c5590d7547349ab1bae2e1167366ecccdbfe845890131692601ab0ebe62ea26dc4c01f62c501bcb34ff91d4023938a09e23d783c06092850a7dcec9a87fbb86ff497336129f67cab5c28e467f2ea39043f14233da6ef42a98d8e4c3f125b124577dbd6dd6a41293c80b542e40e309cfff667c981b678474d87fc386e6bff62f267b1e2a51a6e80788c7d598d48006e64756656465f022100b264d85ef485a50705816616ae53043812eb180375c6a1d68924ba9e741c8aaf02820100127400355ca7e838353e051904a3ab2fd02a6efc82605d435cdacfb588c30fabdc0d65ba66d7004ec30f557812bc112269f2cdcfa2354860851d991aa2155a2f06a1c5d96c738c113571f77849c5e31baf01ca9b8d95485a3665e329887d33524cec864375ee9f262464a062943b6fb9cddddfc6fc8b14639dcf52be4d3761318c9aa3a7260e3c3914a4b4561caa20a68df5acc856ea5a134d658f071364e58e79229a829c3d7d9fe499daa11fad49ec7a441d24f71e4d20517a4d5eb4bdf21348317b6bdd7b85e9871a02c32ee3b1af0231638ee4da86d04912123d90c8aed6310fff61f6aa060423a7f6abf2f05613cda96d1eadb343d43ff9bdacaab56eba03820105000282010049f560fa511efc8614fda1be58146bc92e5799788bebd7d317fb97bbbe2df363d2188b29344a33300e76da04f3bfe5ca048413991b3491f9acdd06f8347fed58a28a2f7d95a431190fa4a0fa56221562204dd97fb2db1304e936dce96d85f768e9a7bef22bfc4f81cf535a625b7b8b643a89e9416a0c2c27806e4fa20000ff617d124a168f35f9ab47855429c5c5d95582a798826a333273f024b0e2bea5d2c56535bdbb47e5312844ce71512f941b4c14db30a3a3d0face56e90dae0d02b2f5136b27dbb85fe9da160a9f76e69cbf0a5732bc1bc0ead82632250d046bdd986bfd177c58f39bc38a3ed79387ff0912cfd09198d15abfc9743c493cc62300e034'},
  {SIZE=>3072,PRI_FILE=>'key_3072-1.pri.pem',PUB_FILE=>'key_3072-1.pub.pem',PRI=>'43062c67f9f5a90a268040fdad17d1990bf88731849baa38997dce9b145285a7',PUB=>'0384463ae72b8cf36be819c9e27d1303cbcaf779976c21492876133dafb6ece83c2402f9a7260dba4b5df25512da0a332b84079c438b9a5ea42142941d8a7170a2385d79cb904748292892ccce0c24e643658e326a1a191edddcb97fc23764d1e5fb937116b0798cc10c915e16b6694b651965969723d460693fd0e1d87882ddea7bf22a4f3c66b26ee24aff8da7b54fa37369e0a240b253c805f80f975ebbc3323e3dfbe683670dd9d4c518205756692a2fb986e101a21d4dc2b29fe2561ce48a014a33db0bfd5da99dd60d5dc111b5657266320a9295be0fef3fc483a49b8826b9f2c433a2452e5898a95d93e0cd5fd00734cab519c0131db95eb9be9d564ff3b03fe1160ea619220b3dfb21e5746798ed68aca608bc261e1832d4af45ddf62e08e1934272f8a8b063e7cb74b100b9c89cf5b6c2837abb825f8595fdb648a8f5a90a270c403c01137852b2579583c5ba7632ef2d8636c4a08856a0584252892edb6b142585aa5f370d45ccb11aece796f5b18202a309a4d3f1c124683c2209',DSA_SHA1=>'304502210080df69ae68f75c230b58f1ca262c1d164eea62b128206122799c7b08b3635a7a022026603ee5655ac7ae2c351ed73f3a952420c5625404082761e2e1fc6ca698b0e8',DSA_SHA256=>'304402203ea77e1adde22694d030e1b068166241b7c3912653c1db106afb2165c94e57cc02203cf8ab667ec48a64b8a2be2219d1252853435706d2916d08b362204e57183705',PRI_DER=>'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',PUB_DER=>'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'},
  {SIZE=>4096,PRI_FILE=>'key_4096-1.pri.pem',PUB_FILE=>'key_4096-1.pub.pem',PRI=>'00b14ee1226c4aeb4d7a9ff494214918c0489d479c4d0a0107928400abe41035e5',PUB=>'2a6218a818996260e331afc85e2696b02e3b6e14c25c2b7a3a742c9600c67d371be48ce4aabb814294bd7977ea3a5cec0398330c5501784dc45df1e2fa2487a02e9c4c5ba1b7c04d172db32ee6955cc5b3ea368fd044dd068d677f28d650a281f8a3bdf67efa1b1e47b885784d7281d5a5a096b39f23f52e5482b6e2c51806c69614f2f02c441542f62f0fbb8da887998bd181cc6db9d570bb8d5a14e8e6033414bf30170bdc33569685678321a4537e52fac8fe1a45c8f940c2eda85b03a257673a4f589b0956bac61bb01afd44242d10763060169eb09459d39eb9da034a8897473c5db16e3adb56216e5b81b454fe6bc622ddf3eabe3851ecf1fb9bdd2b7cf0c43184192cc9564db5e472b8d52c0b1cb7b7be3cde77424524d9f99bee280590def04b6856fdf2d5765fdb64429bd02c0083caa2d0c57a12b16d659196e6b195f02104ab02e9083c7e5158d4440bcb7a263476c10b8a389677f94274840a0436a492651f12e959bb1338757f111e80db13c6cbff4bdfc2ecd0ef0c80c16fb4bbbb6eb2a72a1a000160a65c5e79c766b09d60bbaed6e2f4a63e50d63a949a101c2d31010d212a7481e7fbdff57c5bc1dea8230882262ce661ba10c7081993657935419621a2aecae0476d487f1e09ee241bfb12e723edc95c395a4d692ab2bb6ff5bbaa5b61334600066b1e1e1e6577757089f110f4742667df74367293278b',DSA_SHA1=>'304502203085c025a9f5fc220ec42c3d3b7c14925f7fa94ee90926ad6fb00bebad056c7102210096b0e77cbc0ccfe16d3781566a9efc8c95ffc68e042a8fbc97725935bac43588',DSA_SHA256=>'304502203e0ae9a870323e30469fd854775dd1509802801eff9620b2115b7ac84bc5ea6702210085725f39bf186a24bf98d8b03aa07a90f7dca1a092a4015d428012a92cf1ed4c',PRI_DER=>'308206560201000282020100f28559890368a4d099f36f59a9e75ac562f5d0092662332924b10987f354dc97a8aa0cd77db048d52a8bee696d781d97e6df71e02b8aa35a25d891d62d7fb34ced5ee522069b6282fa9fb7b48450f24df6585b35cacd5eb2a311a1e239d4acfed79009b287f6e4265b8b369e3aba8c901ce3c421aa46d6e526f61fefd899edfcea94f416ddad7e48fd87b4b820be28e7f8a34d86e73d984eaa9c939d2e5e7ef4549ec9506f080ae18a633657e0caab2005a174a7161232158c9f76def948def72be4120da4dff7fe535c8968c3b35eba307d5c9f0142c8343469fcbafadbd4d2274ad50266bdb783e367a8703967e53836bbd0028e09c7dd37f5d5a670ab7e0af487de28a968cf8712f2aab20637d8e0a2f05f1c2075775170d4a56124090f159c9776cfda62ce66e582834023d4ba08f7de63456cfc94cd5e0b7e7d230638aa768f32d7f89262454810c0e40e303bff463e12b7691866fb004a336edf4d4c6be131c6b4690f0e4b328289bfebe98cfdf1babf8b17607d7b0ba236bb1abd56ec1698319141d8c6c4ca154a2d7d9a323a5b6005c3a9639adee5b756d42156f8ff405decb098072454af97496d017e4a2de551ad286f5f6c89925a32e042f2fab1be11e25be5848fed6986f309d55671687403d23272fb96e2017277e39b917bd34254e4275049d5a75a00e94f01077b51de470c4867b239ec739fabdf8b0bd65d022100ef8decba0475990b9cdb3d28ea579028e587cc78c4304903e98f2358692bcad9028202000c794a5b82ddf4e62bccb6e939cbf48627c8d4fb45b05d3ee175249c5feea6f6c9bc6a080e5fdd3ba86da51b7529bb7c07da35e39859f44f13fc62d8878936d0738dd00cb322edf5e6ee5503777257ab18060cccabb15a532f9ac291d508e27b939812c9b288a06aaaa3911141fd1756094dc8e843d60eed4ee974c4b8e06bea58dab388dfc7b36d088b8b9d2a6070d3bd49f20befa0734ebfaf7312c73ffad54f69609bd3e94da4296760818afc409f3f955631284f5c416a415d150bb149728fdc75443e16677c62a0193f9ece50cdf55c5877f62164d5e95d8e8da9502927036743fb292e2c5260b7561e09f26702ca4f8d1aacc68fb4f73dee9a3febded8f217725a9a18347776778c69046b55910ca984e4ce7acfec24e3435c7e966b41415b8d3c9865535a5cc149f8518a9ec6fd7ad9c8ef8074347c16a51642b2a2326be4cffcfa7611dde0633131f0f9471702d23d2271657d3e59e334c082a1205e1387b063c84d9459af72290ec0afaaf1fef3852811faf8981f5ab803aa24ec600448b65ef2bdca0d014209fa3e7db677fd1964bba279abd9785e7604ab91810002c31fac482843313019924c850c007abb6b9fe1bbdb8b90b419b636c0f90fe02f020a6a60de8e20fe5c9bfa4efe8e6a5c3bdc3adbc2a49ed1f2203ce76d5f08bf91b354104c57bd2be1cc210e6b357e247622a2ae72c710d3910bd5f64639d4028202002a6218a818996260e331afc85e2696b02e3b6e14c25c2b7a3a742c9600c67d371be48ce4aabb814294bd7977ea3a5cec0398330c5501784dc45df1e2fa2487a02e9c4c5ba1b7c04d172db32ee6955cc5b3ea368fd044dd068d677f28d650a281f8a3bdf67efa1b1e47b885784d7281d5a5a096b39f23f52e5482b6e2c51806c69614f2f02c441542f62f0fbb8da887998bd181cc6db9d570bb8d5a14e8e6033414bf30170bdc33569685678321a4537e52fac8fe1a45c8f940c2eda85b03a257673a4f589b0956bac61bb01afd44242d10763060169eb09459d39eb9da034a8897473c5db16e3adb56216e5b81b454fe6bc622ddf3eabe3851ecf1fb9bdd2b7cf0c43184192cc9564db5e472b8d52c0b1cb7b7be3cde77424524d9f99bee280590def04b6856fdf2d5765fdb64429bd02c0083caa2d0c57a12b16d659196e6b195f02104ab02e9083c7e5158d4440bcb7a263476c10b8a389677f94274840a0436a492651f12e959bb1338757f111e80db13c6cbff4bdfc2ecd0ef0c80c16fb4bbbb6eb2a72a1a000160a65c5e79c766b09d60bbaed6e2f4a63e50d63a949a101c2d31010d212a7481e7fbdff57c5bc1dea8230882262ce661ba10c7081993657935419621a2aecae0476d487f1e09ee241bfb12e723edc95c395a4d692ab2bb6ff5bbaa5b61334600066b1e1e1e6577757089f110f4742667df74367293278b022100b14ee1226c4aeb4d7a9ff494214918c0489d479c4d0a0107928400abe41035e5',PUB_DER=>'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'},
  {SIZE=>512,PRI_FILE=>'key_512-2.pri.pem',PUB_FILE=>'key_512-2.pub.pem',PRI=>'3a56c667cd9c95dec92aeafc3987274da82a57cf',PUB=>'6d00de86363f590dbaaeb289617d5b099e0bae1e483aa464411519831106a09571f13b51353f897b18865c8f6f2d3c95d9071db89333f0ec968e8f793a5069f5',DSA_SHA1=>'302c0214141fd4af5c16d4610eb37b52d54a306d3ebd37c3021463b294e41521763d0c9ec19b96e92b4dd15d0ded',DSA_SHA256=>'302c02140aaf646c5f39a84b6bc698ac8a22700cd4c8b6280214471cc080922947385772a00c9ce379b1e27b38c5',PRI_DER=>'3081f8020100024100ec6b341b598e6a69ab7aa592b071dd86345198bd5ef70a1b08285d364691439f8b0eb1516d9d8ad140c8e8aed9923eaaef1f70e16d7ad8e730812536249db869021500d4efc32035cfac6994ba06600ae587c452c4649102410093bf6ce6f9743760a2436eaae725811ca3bfec69c974413ae185860f277b58182065ee72a83a91d6d2fd66c5d0a4e8f8cec977b29a9bcfe66c080f441a3e5dfa02406d00de86363f590dbaaeb289617d5b099e0bae1e483aa464411519831106a09571f13b51353f897b18865c8f6f2d3c95d9071db89333f0ec968e8f793a5069f502143a56c667cd9c95dec92aeafc3987274da82a57cf',PUB_DER=>'3081f13081a906072a8648ce38040130819d024100ec6b341b598e6a69ab7aa592b071dd86345198bd5ef70a1b08285d364691439f8b0eb1516d9d8ad140c8e8aed9923eaaef1f70e16d7ad8e730812536249db869021500d4efc32035cfac6994ba06600ae587c452c4649102410093bf6ce6f9743760a2436eaae725811ca3bfec69c974413ae185860f277b58182065ee72a83a91d6d2fd66c5d0a4e8f8cec977b29a9bcfe66c080f441a3e5dfa03430002406d00de86363f590dbaaeb289617d5b099e0bae1e483aa464411519831106a09571f13b51353f897b18865c8f6f2d3c95d9071db89333f0ec968e8f793a5069f5'},
  {SIZE=>1024,PRI_FILE=>'key_1024-2.pri.pem',PUB_FILE=>'key_1024-2.pub.pem',PRI=>'3e07cddee79c1312d6812e42b824fe41c800a0d1',PUB=>'11f4a38220a7ee8f0e842fe058776e655aa8490e52399d6f190e83289a3c8044e1def4f84e12ca1bce210ca33101c20e28d82db43dfe198c94158a66de392e94410e3b536d67fe1e428b2ae75d1626dcfda48b1d2469b18deade9e7b4d3ae46d20b2d89f17245bdf1a7e33ea4fc2b8fdd88ac07a3a268e0170bb2a4150060a11',DSA_SHA1=>'302d0215008ffd4c5d43bdc2d7ed52459158d686181494940b02142d40e961290fbed9a4686c276c3a18e9e4238120',DSA_SHA256=>'302d0215008f82e99fd73dc62a889ae881a14e5b644d350470021409049520599783e9659e207ebc794c8040ca06f2',PRI_DER=>'308201ba02010002818100a44cca1539a619f46a0bfddc566aad42c081ad64f17e3080a02c40f833a0eb1eabc6deeb9ad2f3efe2fb82f8714ae1d4105a29fd1db950f50a5dd6cf93e98139f5afab6cff916c66d5192e27e1bfe169927c820615796ba8542875e52b7830430462af4fc1f90d324faa12e57ee817343330bffa6a1fddb351b78592d4e801670215009c1446d67299bef01c9fa08f7fa03f96306fb4890281804b3876507dfd6f3e1fcaeaf346f59062c6f5cfc147305d5ed83525f8e51bebd29377c96b36d5d373ec90f343243e6c40770dbb35083061b0244c5fb53c25bb6aa6724a2458336520380895d8631260c5441d51b396ce1ebe9a3aeecc342fc62d50ceab15c742cf6b290b1ff4d5f7de7ec6e3ec5aff2da5d9d2b1851d3810ef0302818011f4a38220a7ee8f0e842fe058776e655aa8490e52399d6f190e83289a3c8044e1def4f84e12ca1bce210ca33101c20e28d82db43dfe198c94158a66de392e94410e3b536d67fe1e428b2ae75d1626dcfda48b1d2469b18deade9e7b4d3ae46d20b2d89f17245bdf1a7e33ea4fc2b8fdd88ac07a3a268e0170bb2a4150060a1102143e07cddee79c1312d6812e42b824fe41c800a0d1',PUB_DER=>'308201b63082012b06072a8648ce3804013082011e02818100a44cca1539a619f46a0bfddc566aad42c081ad64f17e3080a02c40f833a0eb1eabc6deeb9ad2f3efe2fb82f8714ae1d4105a29fd1db950f50a5dd6cf93e98139f5afab6cff916c66d5192e27e1bfe169927c820615796ba8542875e52b7830430462af4fc1f90d324faa12e57ee817343330bffa6a1fddb351b78592d4e801670215009c1446d67299bef01c9fa08f7fa03f96306fb4890281804b3876507dfd6f3e1fcaeaf346f59062c6f5cfc147305d5ed83525f8e51bebd29377c96b36d5d373ec90f343243e6c40770dbb35083061b0244c5fb53c25bb6aa6724a2458336520380895d8631260c5441d51b396ce1ebe9a3aeecc342fc62d50ceab15c742cf6b290b1ff4d5f7de7ec6e3ec5aff2da5d9d2b1851d3810ef030381840002818011f4a38220a7ee8f0e842fe058776e655aa8490e52399d6f190e83289a3c8044e1def4f84e12ca1bce210ca33101c20e28d82db43dfe198c94158a66de392e94410e3b536d67fe1e428b2ae75d1626dcfda48b1d2469b18deade9e7b4d3ae46d20b2d89f17245bdf1a7e33ea4fc2b8fdd88ac07a3a268e0170bb2a4150060a11'},
  {SIZE=>1536,PRI_FILE=>'key_1536-2.pri.pem',PUB_FILE=>'key_1536-2.pub.pem',PRI=>'09d7c38692f017316b0ee0ea0ed40805c5c1afbb',PUB=>'009e39f3add36d29c6cdb19daaf75ef21c16594df511789489116f2b7f9b6e1f36a638bbcc7cd4993778d04892775bcabede3a24a907edefe0411a62f63b1f150e38b2f2a66932e37fffa5e3f83ecdc1b1107ea93f71199f2cd4f3db105ec39e01aa49877a54af76644fdbd3e2f87725cd94f34c991ba6dd1b0710c675b13dad03752b3f5caed2129873286687cc9f67c3b0c8143df89965173a0961ae173bd6a0ee16bee1b86ea7c6a634f5d9fcb46959e8524f6f2e8652046b1c32ddbcc12a6d',DSA_SHA1=>'302d021500a16ed40a1ee247e2af1d638bc0e49f8a0a0ff2ab02146761128987b8965fd52ea563f5a521af928c5438',DSA_SHA256=>'302d021500a21a000884f97aced098f6ac793824e16e1d0c7f02145d44972b36d27dfba5ef643789ff1551425ce037',PRI_DER=>'3082027c0201000281c100fba98712cd16a01b0fede62bf7785b259b7c3994b3caf492fdc4b9a596550b02e2771cf5b15a12994c59212772d83f512820391d76d4dafae6dce317fda9c3b4ffe493737e86d27c9f1ab8c7295bd16f8b69155ef43cd4196430d747a350b2dce22c8d531a60d53414c95b83fd6e4a0d14baeffc3c67b2f5eff8b4d2a8591eddea82849afc5553f44a4527cb78a03aca62deaf6996209e6e46df32eb2c910e8446e9c9d421585ae62410b082a669b2a950784b37d1e542361eab0e00dc7b3c11021500a4ff288631f6560028464eeba69f3922a661761b0281c1008df52bdcf90e37df6d8e6d52db5ebba47f9605ac345919ec8b985afe7d614b2bad9371aa7c1109b5b86bb90f79c72ff7f767f3306ccad681cb372a514de86d356a960f8798ad9d91b62e87d00a962dcef16be237ff413aadd7be1601a50df3344a99b5579e2c557a6f0d6dcc54b79d3f10e6e0a7faf8e2de861f076d4030375532451835bc0c056239bf4c904ab9567ae3c0c93b028c8c0db506945ecf3737be47d5bbcd81d8881249ab57cd7c573f7bec538b999b4590c5d4eefbd64bd6a8d10281c1009e39f3add36d29c6cdb19daaf75ef21c16594df511789489116f2b7f9b6e1f36a638bbcc7cd4993778d04892775bcabede3a24a907edefe0411a62f63b1f150e38b2f2a66932e37fffa5e3f83ecdc1b1107ea93f71199f2cd4f3db105ec39e01aa49877a54af76644fdbd3e2f87725cd94f34c991ba6dd1b0710c675b13dad03752b3f5caed2129873286687cc9f67c3b0c8143df89965173a0961ae173bd6a0ee16bee1b86ea7c6a634f5d9fcb46959e8524f6f2e8652046b1c32ddbcc12a6d021409d7c38692f017316b0ee0ea0ed40805c5c1afbb',PUB_DER=>'30820278308201ac06072a8648ce3804013082019f0281c100fba98712cd16a01b0fede62bf7785b259b7c3994b3caf492fdc4b9a596550b02e2771cf5b15a12994c59212772d83f512820391d76d4dafae6dce317fda9c3b4ffe493737e86d27c9f1ab8c7295bd16f8b69155ef43cd4196430d747a350b2dce22c8d531a60d53414c95b83fd6e4a0d14baeffc3c67b2f5eff8b4d2a8591eddea82849afc5553f44a4527cb78a03aca62deaf6996209e6e46df32eb2c910e8446e9c9d421585ae62410b082a669b2a950784b37d1e542361eab0e00dc7b3c11021500a4ff288631f6560028464eeba69f3922a661761b0281c1008df52bdcf90e37df6d8e6d52db5ebba47f9605ac345919ec8b985afe7d614b2bad9371aa7c1109b5b86bb90f79c72ff7f767f3306ccad681cb372a514de86d356a960f8798ad9d91b62e87d00a962dcef16be237ff413aadd7be1601a50df3344a99b5579e2c557a6f0d6dcc54b79d3f10e6e0a7faf8e2de861f076d4030375532451835bc0c056239bf4c904ab9567ae3c0c93b028c8c0db506945ecf3737be47d5bbcd81d8881249ab57cd7c573f7bec538b999b4590c5d4eefbd64bd6a8d10381c5000281c1009e39f3add36d29c6cdb19daaf75ef21c16594df511789489116f2b7f9b6e1f36a638bbcc7cd4993778d04892775bcabede3a24a907edefe0411a62f63b1f150e38b2f2a66932e37fffa5e3f83ecdc1b1107ea93f71199f2cd4f3db105ec39e01aa49877a54af76644fdbd3e2f87725cd94f34c991ba6dd1b0710c675b13dad03752b3f5caed2129873286687cc9f67c3b0c8143df89965173a0961ae173bd6a0ee16bee1b86ea7c6a634f5d9fcb46959e8524f6f2e8652046b1c32ddbcc12a6d'},
  {SIZE=>2048,PRI_FILE=>'key_2048-2.pri.pem',PUB_FILE=>'key_2048-2.pub.pem',PRI=>'1c590fa44b9e739c76249737db6174cd9769fe79d03fc03ba516b8ef74ad586a',PUB=>'00cb10c09a261164c1aaad42837226eecc283064a3d25e402bd6585a3f32386e8625d082ba587417a54f3d4f78e0f439cb7dd7a0533c6b7be576313080efd2ade6877df67e0f3ac2199970601fcdebd6f764151e98d3ac2e3a29c98787b1b43562681388c607da5bc54e7607fa393bcba944d7a92eb9b590d01080e24c235f2c9d4b96a0ace845a1447816e54910dd52bfa92e6a0cf26453d7a93158cc6f41afdabf9642ca0f7507cba2d7149f194aa0e89a765fff0af4e1da6a62e37e61b6b7fc8a6f5fc4034da9f4929c128a8753cc05d02b2ea98b73e7523e461b888736e82738e67af73db59e3d834d4cc7b61989883b90f9cfdc4c9e421681498bef22ce32',DSA_SHA1=>'304502210080cbd2427d64f09496a3955467112d83cd03de839a21a54eb1a4fe17464d08bb0220507dde54e2a736a3cb6695b037a7f861b0cec2879b88b2d04d84a5df1b4a283f',DSA_SHA256=>'3044022072e70831aa0d612f0ee132e382665d2329c9f33f97735a3a1e798d03dbb3acc60220089021568f94ce8bb2a8f723cf108a98f8a2ec9d23d896dc5931ad2b3de09e7b',PRI_DER=>'308203570201000282010100ee7508d90986f6fb4dc0477fb20012661bf17040120df3349812e4081306ca8dba7036e7db55163259f52c5daaa55d86b8b04950386eeefb37e7abadcf8424685c04c207a47bc73e85cd72a0d5dfd32db9150ca5bc5c310ab990d24ce778b99ee424449e202b253ba83b038fcf184236910115c98fafabfd51a835d28a34c3ccc4c40a7bcc0eb1aeb06084c23a156e36d55b5cd208b032f741e7225aad202f556d5175e649417ffdb86a05ced41c3728387708d5048b90687e09516ce1b934f94d8226e9791ce62827cfaced6e53a9befd1aa08baa3888996d7f076442f07a33b83ae9a8e3f0bc7abe41eb4505f32d711fca1a19cee56d733d8b1f25a7734c49022100a6220ae5da12fbfb2cb7d8b1e07c7d12e55c11db8316594b575b6bdc215931f9028201010081ae4099eec0b8a4bb8e4b4a54f445fad55d49e7561130f51e1c2eda1f1bfde83f482d15ef890587b106eed4aaf102eb57141be1824f124c0f1a4c8e34aa74de6597d411b3fb49cbdb5b163886f5b8954cb80404065575873feef35b676d70922d43cb471ab0e199bd1da380e39d9b80ffd52e72cdeef88333d8f83d6aca2f2e6332363fc002c63df5e1af6ef215ea78a44b26627fa09c3dfdd74704eddfdeac13fc34ba96355f3d48483b970e52371606ac345ddf911ce35018364d5dcb3d8f0b6845c8ca049d168d8245836a627cfaf03c0751c9faa4fd3870f596a190efca507a546fead9d63a792d8b04beda3f543a5ab19890033174484fb3081d8c8f100282010100cb10c09a261164c1aaad42837226eecc283064a3d25e402bd6585a3f32386e8625d082ba587417a54f3d4f78e0f439cb7dd7a0533c6b7be576313080efd2ade6877df67e0f3ac2199970601fcdebd6f764151e98d3ac2e3a29c98787b1b43562681388c607da5bc54e7607fa393bcba944d7a92eb9b590d01080e24c235f2c9d4b96a0ace845a1447816e54910dd52bfa92e6a0cf26453d7a93158cc6f41afdabf9642ca0f7507cba2d7149f194aa0e89a765fff0af4e1da6a62e37e61b6b7fc8a6f5fc4034da9f4929c128a8753cc05d02b2ea98b73e7523e461b888736e82738e67af73db59e3d834d4cc7b61989883b90f9cfdc4c9e421681498bef22ce3202201c590fa44b9e739c76249737db6174cd9769fe79d03fc03ba516b8ef74ad586a',PUB_DER=>'308203483082023a06072a8648ce3804013082022d0282010100ee7508d90986f6fb4dc0477fb20012661bf17040120df3349812e4081306ca8dba7036e7db55163259f52c5daaa55d86b8b04950386eeefb37e7abadcf8424685c04c207a47bc73e85cd72a0d5dfd32db9150ca5bc5c310ab990d24ce778b99ee424449e202b253ba83b038fcf184236910115c98fafabfd51a835d28a34c3ccc4c40a7bcc0eb1aeb06084c23a156e36d55b5cd208b032f741e7225aad202f556d5175e649417ffdb86a05ced41c3728387708d5048b90687e09516ce1b934f94d8226e9791ce62827cfaced6e53a9befd1aa08baa3888996d7f076442f07a33b83ae9a8e3f0bc7abe41eb4505f32d711fca1a19cee56d733d8b1f25a7734c49022100a6220ae5da12fbfb2cb7d8b1e07c7d12e55c11db8316594b575b6bdc215931f9028201010081ae4099eec0b8a4bb8e4b4a54f445fad55d49e7561130f51e1c2eda1f1bfde83f482d15ef890587b106eed4aaf102eb57141be1824f124c0f1a4c8e34aa74de6597d411b3fb49cbdb5b163886f5b8954cb80404065575873feef35b676d70922d43cb471ab0e199bd1da380e39d9b80ffd52e72cdeef88333d8f83d6aca2f2e6332363fc002c63df5e1af6ef215ea78a44b26627fa09c3dfdd74704eddfdeac13fc34ba96355f3d48483b970e52371606ac345ddf911ce35018364d5dcb3d8f0b6845c8ca049d168d8245836a627cfaf03c0751c9faa4fd3870f596a190efca507a546fead9d63a792d8b04beda3f543a5ab19890033174484fb3081d8c8f1003820106000282010100cb10c09a261164c1aaad42837226eecc283064a3d25e402bd6585a3f32386e8625d082ba587417a54f3d4f78e0f439cb7dd7a0533c6b7be576313080efd2ade6877df67e0f3ac2199970601fcdebd6f764151e98d3ac2e3a29c98787b1b43562681388c607da5bc54e7607fa393bcba944d7a92eb9b590d01080e24c235f2c9d4b96a0ace845a1447816e54910dd52bfa92e6a0cf26453d7a93158cc6f41afdabf9642ca0f7507cba2d7149f194aa0e89a765fff0af4e1da6a62e37e61b6b7fc8a6f5fc4034da9f4929c128a8753cc05d02b2ea98b73e7523e461b888736e82738e67af73db59e3d834d4cc7b61989883b90f9cfdc4c9e421681498bef22ce32'},
  {SIZE=>3072,PRI_FILE=>'key_3072-2.pri.pem',PUB_FILE=>'key_3072-2.pub.pem',PRI=>'00c2db365bb0b2788a9d1667d78d9103e43ae3d1417c3b475dbf5a1dd72c847dde',PUB=>'0b5601ed1907996bae158b1702daaae656884f08470597e74fa894fff8f5af2ee6c576c182b58abdf7b3e24833890e4e80ca6df45a26d8e504bbcb9c4ed0977dd04ac31cb3fd1834fd488527ccc8710de82b3421ebc367c9b18ebf43b4e218973d5fd63e01448e0633a7be225cc2974306fd908067920500a275a2ff37183c14c7951c72a7186c4a8b755bea148d29ffabc9895a2c7b798f80c39038ece615051ccb077eef7ac1a08a38c4dcf7cd1132202e7672848d2317b021d3779778f4d8d5a05308ba8d36f262cd661ea53a421f22bd94b521e2e9cb7e7a2831421cbe5cff7bee38ec95b1fc1a3bb09aab2395be4e5ebba2e8fe8122dde881d284ec5677f8ffdb33224c763d9fc88651df6defc321626e1c28309d80eb978392e41daf5575e9455c74db761f03367c3faf234d28d1cec619f43aaa88d5c4705f221ab9387740d30fe600399971a26c59d1a85dc075bf4515b8e41abd925c68dd49d19282119297308cf3883bc99a61c1a7bb85c28c5f3f5d863045eac5ce1b00e33a2afa',DSA_SHA1=>'3046022100cfce16904b96e5590b17bec1f739bc7aed862e9aa08d94e3d4bd465fcde977db022100dfccf04c741c4ea5e98030f1936f0928d1550f1b5ed3fe92324fc9b3715193ce',DSA_SHA256=>'3044022069f3380c6dbe99b2bc350d5d982ba2ada5605f260d15b9fa468eff1f13a6e490022030ee9d88348dc113ee3fa819e158593081fd1df15d6a803479ff68acd8509128',PRI_DER=>'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',PUB_DER=>'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'},
  {SIZE=>4096,PRI_FILE=>'key_4096-2.pri.pem',PUB_FILE=>'key_4096-2.pub.pem',PRI=>'38d41fa4f9f1b5c0f500db4333315efaa712e71cde8d789c6752166d48961287',PUB=>'0b368f4ad35f6e0b56d933d65446716d93869555a8ea5b2d8c3739ff84b6c5e330f340b667d6614249544f60896d6a8826b2cdba78c294a8a89680dc3b21885739578b1c81bc7832aadc9ca88a892cfa0b1a7fad0c4c45f2e021b1667403063855e022d1c689fb1c18239e0c8c615ca7c73d55ebd83050fc7378dfe6e4f4f30bff7b96c5def16d27fcccf40c27acae8dc2c2816b5eabbc85ad760b988ec24c33f3e2bb9757324c72b86d9baeb1899ca05a39faab9791d880927a1c6c6ec2ca695b5bc5666c94f681f958770018801323d597003153967b4c9ef3b44c65d367c86df422f9414b206db83e4264ab1e07a2be26f16cf890ae17a7335700223d46942f560834b9b368c8182f53a94aee019160544211e221caefd9697b98952543e596ffb35c1b781d181c6a1ee46c7e046b9a7281b463a7598eb04fda97e50f50f0fc191cbc0f0099432283870afce578fdfe0571f5aee8d26e0665985106ac779ae14134a0701d8864be3a7b75512cb202e2b607e90747df8177dd527d91055f6ff655ccd42fcd1b9acb71112a57c4485c23863fce3fac5dd9669cadeec0388083a087d10265ef3b215f3f0bdb7e8b6365a48583f1db8e957c39388e1655355d55890399c09c79a3d4b210c376522b95c364a804736b38ade020968febdf79fd4caa32b8ad1a3b6b4ecc57253738f3fd91fc4f6b76dfec5a3e7016b91bc0c366e2',DSA_SHA1=>'3044022026c960994107c0fa57498d136e915430577342513bfbc13b2c366ee83e0963fd0220290cf102aece997ab5811b0b19fcfecf8f8d131cf66efa23bdfe77e77eff7863',DSA_SHA256=>'304402203d265b947a4ece7bc09fac28b44e4957f07f6797ab7fab37d0618badc7d6cdae022041a9b074d9a0f8f10c79bd585192d85a2cb3670f39d8e661ee171474a2878f89',PRI_DER=>'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',PUB_DER=>'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'},
  {SIZE=>512,PRI_FILE=>'key_512-3.pri.pem',PUB_FILE=>'key_512-3.pub.pem',PRI=>'44ad88412b165ab43a59205dee392b71a7166462',PUB=>'7354177bb79b818530f0afc8f1a8379273b3f6c22febce156e9ac187c97d99ed94e0465e96d688cd9e0896cd7fd2e755a9bd81206c5fcf28a28dde23d773270b',DSA_SHA1=>'302e021500a1a36ecd213faf706340004f766e8473d7d84a24021500b0431f94dbf71cb29424525ffcf3f46552ffd392',DSA_SHA256=>'302d02143a67062aa24c257431c3ac8ad1cd33a453ff545c0215008dfc43a31aade0136548451a4a2ca4d54f3b8715',PRI_DER=>'3081f70201000241009b328b2ee18d24b0c9f030c68038cab21d547a422f2bcced33b28b89c01f8ecc36f00d5a30d0cede004806ed3e1b1ec5231724d85756f8afabac16914c595a65021500b1e2ea9e46f4bf1f8bd158a0463e4c6fe50b1d8d024027f89024380018f5c3e2adc5d85763d82e4c54a9cacb6a1c25f7c12b29eeb0eddc7593e112a07576ad6dd4c4b78cf624d5df25a6a4cd69c7132e7a693990519302407354177bb79b818530f0afc8f1a8379273b3f6c22febce156e9ac187c97d99ed94e0465e96d688cd9e0896cd7fd2e755a9bd81206c5fcf28a28dde23d773270b021444ad88412b165ab43a59205dee392b71a7166462',PUB_DER=>'3081f03081a806072a8648ce38040130819c0241009b328b2ee18d24b0c9f030c68038cab21d547a422f2bcced33b28b89c01f8ecc36f00d5a30d0cede004806ed3e1b1ec5231724d85756f8afabac16914c595a65021500b1e2ea9e46f4bf1f8bd158a0463e4c6fe50b1d8d024027f89024380018f5c3e2adc5d85763d82e4c54a9cacb6a1c25f7c12b29eeb0eddc7593e112a07576ad6dd4c4b78cf624d5df25a6a4cd69c7132e7a693990519303430002407354177bb79b818530f0afc8f1a8379273b3f6c22febce156e9ac187c97d99ed94e0465e96d688cd9e0896cd7fd2e755a9bd81206c5fcf28a28dde23d773270b'},
  {SIZE=>1024,PRI_FILE=>'key_1024-3.pri.pem',PUB_FILE=>'key_1024-3.pub.pem',PRI=>'4589befc1e879af92d5aa5ebfb816d5cacb77297',PUB=>'0082af54957f228f659e65c974db10e4f7811f9f7a13b8e9b1dc7331284ad54f588f2b891745a36c9a5eb1e5bba4f28c4e357c494fad8f4b446421e5d823904816ce6233694c7114be15a0002ab92956b7787b1986dd6bb578b83933ab878593202ff74e94196e7fceb13fa55f5a1c4588d6c6b3c2941edda4fcd7ca66f7e2585a',DSA_SHA1=>'302c02140f83819f9e2acb17223aa75427240311a775e13402146d17093744308954cfe894790ed903a8811852b9',DSA_SHA256=>'302c0214236c3dece1c1cfda8fd6a581052aeea7a6a328e002140d790d58d2d8cc85383618eba360e414999c48e2',PRI_DER=>'308201bb0201000281810088d428e174d87c18265d9da55b384d1228c1fa6bf036401e8a41022bb32e5fbcb5ad3a75ef3ab7d90ece0b1ffbe611ed89beb2d59e2c40d570e8af8a6821936b29725074885a3a6ace615dce8fbceef93a3d3f671fd2ac4742ec0a18fc9369d003c127c603eb3b4d5d45cc9bbfdcd556e6a8418db55c453dc08f56e158e9aa03021500d452d5c4fd4bc831e0dc8c5d2d36ceda165fba9502818031bef6d3315713597c8f8e0306f9872e66ace4c54c30a76afbbfcacc2e2c4a719d947ed2b2f180ffb241ff62d7e5e000556e56ca5aa1e9e59b9a375d4b6779558787f9f931801b94cbe3a663dd9554077f597e719f276686b921a5477997d97b6953cdc8e05ad73ffeb9ebe7cff684a29021fe77d3ea432a5bb417fd422cad6a0281810082af54957f228f659e65c974db10e4f7811f9f7a13b8e9b1dc7331284ad54f588f2b891745a36c9a5eb1e5bba4f28c4e357c494fad8f4b446421e5d823904816ce6233694c7114be15a0002ab92956b7787b1986dd6bb578b83933ab878593202ff74e94196e7fceb13fa55f5a1c4588d6c6b3c2941edda4fcd7ca66f7e2585a02144589befc1e879af92d5aa5ebfb816d5cacb77297',PUB_DER=>'308201b73082012b06072a8648ce3804013082011e0281810088d428e174d87c18265d9da55b384d1228c1fa6bf036401e8a41022bb32e5fbcb5ad3a75ef3ab7d90ece0b1ffbe611ed89beb2d59e2c40d570e8af8a6821936b29725074885a3a6ace615dce8fbceef93a3d3f671fd2ac4742ec0a18fc9369d003c127c603eb3b4d5d45cc9bbfdcd556e6a8418db55c453dc08f56e158e9aa03021500d452d5c4fd4bc831e0dc8c5d2d36ceda165fba9502818031bef6d3315713597c8f8e0306f9872e66ace4c54c30a76afbbfcacc2e2c4a719d947ed2b2f180ffb241ff62d7e5e000556e56ca5aa1e9e59b9a375d4b6779558787f9f931801b94cbe3a663dd9554077f597e719f276686b921a5477997d97b6953cdc8e05ad73ffeb9ebe7cff684a29021fe77d3ea432a5bb417fd422cad6a038185000281810082af54957f228f659e65c974db10e4f7811f9f7a13b8e9b1dc7331284ad54f588f2b891745a36c9a5eb1e5bba4f28c4e357c494fad8f4b446421e5d823904816ce6233694c7114be15a0002ab92956b7787b1986dd6bb578b83933ab878593202ff74e94196e7fceb13fa55f5a1c4588d6c6b3c2941edda4fcd7ca66f7e2585a'},
  {SIZE=>1536,PRI_FILE=>'key_1536-3.pri.pem',PUB_FILE=>'key_1536-3.pub.pem',PRI=>'00f71141cf80f653272aaa38288b45424bf5145f3d',PUB=>'53f6a23eef20ee0032caa4a4ceea6eca6a4448246be18b935ddbb4982d737dd5bc216cf50b4343beca56d913175b8c984d7aa381fe55e60ff5cd5cdd12e7e1f16f29a25bc1911a2a14911dbf31c4004246e6930ed5b884ecc73332a9120c27aaa731a3249163ad91764a3883a3ea477744c9c5349abcf6291ef5ba5102aee912b475e4186eb400594474ecb6c53f996b17e2e9d1238fa2b9d44a6df4e536cff96cde614d5e146446303beba02b520ddf6fe42414391f73daacc5365e4b881d16',DSA_SHA1=>'302d0215008d3cddc5e8d7e19ced7d7859f8ec38e3a0c352be02143657b7417c64cf715eac4a1666c9e964e0ae5ac8',DSA_SHA256=>'302d02147d8330a66f4415e548a72c9bc95a172d1ce423ff021500df28aa0a60965fa6f096b95c216d419c219f8435',PRI_DER=>'3082027c0201000281c100b8dce58c5b30fa449a4d8a8c97bd8bd8279f47a15b0f4cc5ef9b566c19d3259ee57292f5d8a84fa11df9c9a3ea3183ad2cc62b7261da4815acf620387c265235c89c0ef4e7de13ce081b47dab3046a68a6858b183028567dae91fbbca6ce263af5bdc106018cf47686aea352df286af5c48d14c4fe528731c5684c5efb79e99bffd87e7c6ee52e4bb5ea536dfb85ea33a241f99adb30c5489f9c4b5b6f4a0231f74cae0986f70a0ef259e9ca18937abe8ce387c51644e0bb58950037098cc8bf021500facd6fa6fab1a552398b3fdd07fb704354ad305f0281c100b665a4de3c066541735a9a5c60707512e2e37af0ef3f36c7d73c7f419b98d1956aadac1551fb9196a1ed1f6318a0d100ec3f2e6b9dba345a9362db38b07d2e5f42ca91d4dc0168fd61a09c60c95596f7b1eda3a238db6931aced78116f4ec0cf901afd18d7143ee442a1037c3ee0efe80f120eb8bfdebf3b5c9f0e0d71f68a00393f5ce5b774cb1e44cfec7a794e34e6d7907a6c233d41a375779812f4c8283b24d8d18cfd13fbd717076004ed5cf59f2b5884e2310c069df1c5e75081a7202a0281c053f6a23eef20ee0032caa4a4ceea6eca6a4448246be18b935ddbb4982d737dd5bc216cf50b4343beca56d913175b8c984d7aa381fe55e60ff5cd5cdd12e7e1f16f29a25bc1911a2a14911dbf31c4004246e6930ed5b884ecc73332a9120c27aaa731a3249163ad91764a3883a3ea477744c9c5349abcf6291ef5ba5102aee912b475e4186eb400594474ecb6c53f996b17e2e9d1238fa2b9d44a6df4e536cff96cde614d5e146446303beba02b520ddf6fe42414391f73daacc5365e4b881d16021500f71141cf80f653272aaa38288b45424bf5145f3d',PUB_DER=>'30820277308201ac06072a8648ce3804013082019f0281c100b8dce58c5b30fa449a4d8a8c97bd8bd8279f47a15b0f4cc5ef9b566c19d3259ee57292f5d8a84fa11df9c9a3ea3183ad2cc62b7261da4815acf620387c265235c89c0ef4e7de13ce081b47dab3046a68a6858b183028567dae91fbbca6ce263af5bdc106018cf47686aea352df286af5c48d14c4fe528731c5684c5efb79e99bffd87e7c6ee52e4bb5ea536dfb85ea33a241f99adb30c5489f9c4b5b6f4a0231f74cae0986f70a0ef259e9ca18937abe8ce387c51644e0bb58950037098cc8bf021500facd6fa6fab1a552398b3fdd07fb704354ad305f0281c100b665a4de3c066541735a9a5c60707512e2e37af0ef3f36c7d73c7f419b98d1956aadac1551fb9196a1ed1f6318a0d100ec3f2e6b9dba345a9362db38b07d2e5f42ca91d4dc0168fd61a09c60c95596f7b1eda3a238db6931aced78116f4ec0cf901afd18d7143ee442a1037c3ee0efe80f120eb8bfdebf3b5c9f0e0d71f68a00393f5ce5b774cb1e44cfec7a794e34e6d7907a6c233d41a375779812f4c8283b24d8d18cfd13fbd717076004ed5cf59f2b5884e2310c069df1c5e75081a7202a0381c4000281c053f6a23eef20ee0032caa4a4ceea6eca6a4448246be18b935ddbb4982d737dd5bc216cf50b4343beca56d913175b8c984d7aa381fe55e60ff5cd5cdd12e7e1f16f29a25bc1911a2a14911dbf31c4004246e6930ed5b884ecc73332a9120c27aaa731a3249163ad91764a3883a3ea477744c9c5349abcf6291ef5ba5102aee912b475e4186eb400594474ecb6c53f996b17e2e9d1238fa2b9d44a6df4e536cff96cde614d5e146446303beba02b520ddf6fe42414391f73daacc5365e4b881d16'},
  {SIZE=>2048,PRI_FILE=>'key_2048-3.pri.pem',PUB_FILE=>'key_2048-3.pub.pem',PRI=>'193475eb231fd607055354f80d9ff3e57ec231e8dbbff55f95482fd519b74fe0',PUB=>'661321784a1ea8dc4790d824e1f816f29245e01801336a3c171019815c7a948e4c39304b4f242a8353a4f7c1b51d1a1318145769f5cdf4ede0728f383b896d4ece262706e4612711427f96651c1440f1b7ef669a9811771c777e851cc6f81fb205ea8e8e1585a0dadca1b6f5e276590716616345d8a3fba6fb3a3b7c34ed16a3214fd9d51936c39348c64af6ba30dee50e5a10c8e19a53ec88217ac3f6b8ab237fcfcf25d08a202bfff256cf68cf5d0e6d9b03296c15a3be0598d349234128ce76ac6e207702bdbfe99b545a900880400130249fbbd67ea2135ebc15150eb1814da820d81a01185b7dce2c4f6bae3a20f0a9cefa03b0cb660934022c07070ac3',DSA_SHA1=>'304502200b25566c0237e7dca7ac792b10a314ee0360337c3a5a089ba0e2e84fcae3786802210088af5f3c1fb63a286d47985b19499f727bbea199af01d36684db1d003689e4de',DSA_SHA256=>'304402201e4355145e0efe9d86a9c2c2a104e2ccc3fbe7af3f6282f3b011e0f2a3f6a056022057e94dda0220995348167aa23f80d7a91138a7b076d47416b6994b8b63cf8bae',PRI_DER=>'308203560201000282010100f25d3273dcd60ae415dfcaffa157a2781adf86a6227fcd411be3d09becde1ea2ed6ad1e3de90f41f441af965f21c739af4aa0f89d881f13e995e075d1279124deb25adcbbd43a0281e2272807fd402f74a9e07a151c1b6f95ed80a5e5fab67afb6b0d2b799d1c12e3e154a4caf48322352eb218c085fa91309f4b94b4a448651adbb7cfc6511883881ae241143b456f28844fdbfd22294dec457c9d9915c823dc68d336211832786500b775900816cdc9abdd8e97bdc3838d2f88cb172511770cc59ee067d9c8cac1776c7818a4b6d432eefdeed2429d2662f6e7885d79bfa17df116648634f4a133e95c6250cf7c9e3cbd8f74d49ad804f5c0ca1377f9efa590221009cc0f23bd00116a00b0fa28ee420c58a34d4809fa661f0755b3ea2ed51e55b0d0282010100c8c793880b0c8fbdfc0ecc7320e7fee017c5796382d00575875d4a9df8c313310054e33b46f2f3ec20cb78bc2ac5de6c86416f7359cb10e5a20b9822db9e323e416a43669fdc6bcf6ad57aadeceffb101c7a4683c3b77ab5a7e13126f1332880a70536669d35783d0c2d58b27234aeee67940e96cc8b3cb228d4e2c1dd347b324d8ac5a80ec208db47cd121e260cac787c0f7500e220a2db1f0f940d5fac2a7756b050f45bf8726610f7ab61bfb9353d3c6cf00df77110f32d038bc58597275e3942e303befdbf37b440c4f5c419551d8943f852a3f641bc454b22e5ecf6687aefb258971aa4b414c14298bab8948859985c57ce1a52ed1d21e4bb1255773dce02820100661321784a1ea8dc4790d824e1f816f29245e01801336a3c171019815c7a948e4c39304b4f242a8353a4f7c1b51d1a1318145769f5cdf4ede0728f383b896d4ece262706e4612711427f96651c1440f1b7ef669a9811771c777e851cc6f81fb205ea8e8e1585a0dadca1b6f5e276590716616345d8a3fba6fb3a3b7c34ed16a3214fd9d51936c39348c64af6ba30dee50e5a10c8e19a53ec88217ac3f6b8ab237fcfcf25d08a202bfff256cf68cf5d0e6d9b03296c15a3be0598d349234128ce76ac6e207702bdbfe99b545a900880400130249fbbd67ea2135ebc15150eb1814da820d81a01185b7dce2c4f6bae3a20f0a9cefa03b0cb660934022c07070ac30220193475eb231fd607055354f80d9ff3e57ec231e8dbbff55f95482fd519b74fe0',PUB_DER=>'308203473082023a06072a8648ce3804013082022d0282010100f25d3273dcd60ae415dfcaffa157a2781adf86a6227fcd411be3d09becde1ea2ed6ad1e3de90f41f441af965f21c739af4aa0f89d881f13e995e075d1279124deb25adcbbd43a0281e2272807fd402f74a9e07a151c1b6f95ed80a5e5fab67afb6b0d2b799d1c12e3e154a4caf48322352eb218c085fa91309f4b94b4a448651adbb7cfc6511883881ae241143b456f28844fdbfd22294dec457c9d9915c823dc68d336211832786500b775900816cdc9abdd8e97bdc3838d2f88cb172511770cc59ee067d9c8cac1776c7818a4b6d432eefdeed2429d2662f6e7885d79bfa17df116648634f4a133e95c6250cf7c9e3cbd8f74d49ad804f5c0ca1377f9efa590221009cc0f23bd00116a00b0fa28ee420c58a34d4809fa661f0755b3ea2ed51e55b0d0282010100c8c793880b0c8fbdfc0ecc7320e7fee017c5796382d00575875d4a9df8c313310054e33b46f2f3ec20cb78bc2ac5de6c86416f7359cb10e5a20b9822db9e323e416a43669fdc6bcf6ad57aadeceffb101c7a4683c3b77ab5a7e13126f1332880a70536669d35783d0c2d58b27234aeee67940e96cc8b3cb228d4e2c1dd347b324d8ac5a80ec208db47cd121e260cac787c0f7500e220a2db1f0f940d5fac2a7756b050f45bf8726610f7ab61bfb9353d3c6cf00df77110f32d038bc58597275e3942e303befdbf37b440c4f5c419551d8943f852a3f641bc454b22e5ecf6687aefb258971aa4b414c14298bab8948859985c57ce1a52ed1d21e4bb1255773dce038201050002820100661321784a1ea8dc4790d824e1f816f29245e01801336a3c171019815c7a948e4c39304b4f242a8353a4f7c1b51d1a1318145769f5cdf4ede0728f383b896d4ece262706e4612711427f96651c1440f1b7ef669a9811771c777e851cc6f81fb205ea8e8e1585a0dadca1b6f5e276590716616345d8a3fba6fb3a3b7c34ed16a3214fd9d51936c39348c64af6ba30dee50e5a10c8e19a53ec88217ac3f6b8ab237fcfcf25d08a202bfff256cf68cf5d0e6d9b03296c15a3be0598d349234128ce76ac6e207702bdbfe99b545a900880400130249fbbd67ea2135ebc15150eb1814da820d81a01185b7dce2c4f6bae3a20f0a9cefa03b0cb660934022c07070ac3'},
  {SIZE=>3072,PRI_FILE=>'key_3072-3.pri.pem',PUB_FILE=>'key_3072-3.pub.pem',PRI=>'00b7f3580347bd0036d803d6ec8b91390cde0486e1bc78e79585b91c3da0a1f654',PUB=>'2eec741d2835ff4dffa7b41c533105346c21bf6140bdbc25aec290166b1c87f1bec4c9a3b6c41f3ca5e1a170b1656485fdc98a00bc294fb8e2b95f03f1b0b104768d69de74146dd0921545babc51e7f85c35276602c319dea058b3973614866af220d5bc7aed3353ac79a506b7b5b7e3f8e957ebb2c5d1bd5bcda844df0ea275d80eb28c40f501cca3cf1d64173e244daca9e3fb53925dee37ac0eda6ae08141003f48c5580688a40d5b2b11e2fa81ad4888514a2eaf59cd23f3bb5bab4f595aec5a8639001788280272af77caa3eb16c4544708b2540d89f52cf544138bd3ac1e44c50ef9f99169a090a4ee36f61964189a03eecba84bfeec150cbd99d2b410fc2e465d9c0131d373510e48503a9a71f808f96515ab908dd942ca71f745ce7d3f50da9a202490939ca4037ff67ca3542914b0becea148979b1a78bac983863a39ac04f4ca73a24573c4d8bee1031008e7b4497304cf660d5ee300d767f7ade2945005a0fb75c9817e8351fa57cf7aab3db012702cfbe90fcd1aac50faab11df',DSA_SHA1=>'304502210093daa231cb0aaaa606e081f9dc0f877ab6e7b0bd96ef7b80885f871b72805cd402202d4f30e5f05d41138719abdb1897053c9588743f218b78044c63b4fd2f4080b3',DSA_SHA256=>'304402201cbaf998e6da4d73c94eda876a0683a72f7b808cef4b74191f40ec04810e8f16022061a8182ebddb911be3b6ac9e45576fecc3ea115285562907743ce0220e34bef9',PRI_DER=>'308204d6020100028201810080ac23af0ddcf39c3e8755c8fc9ae0ca0d698af17474bcac63e591f71397dd38ce912a9ef9f429ac3b5bf49c29e3723e45f47202c8ae050ec978ebece60436748e3cda32cfd3b072fd2719dc38dd8ffa200aa1b221a5f2478947056e20a0aba6f2475be6e71213bda62b284a0a07a20524c8edcd494933a89da43a576ed98476f46ff0f03838fedf4a902ea4abcc6f0c98749b6e7c678922b5a19042c011102b853c90fb490a268830cbbd9a74e24d0328d63f0c2851b768560b010cac03ea9b79abdbd1c0c80306d6a7eea7763b713e27e1ac45f483f7a14d64308a9fa09521609263cac314492f50487bf6c3a63f53b4a98bf8053c63cbb65dce373e70637aca6f63afabdd9dbb3106609052c4d8946cc3c2f08abf8171b18d5de415d001b69e63a07a69ef8a85fa69ac6acce63728c93a435c22e6342ab6f9438aee6dfd9f39c482751a1d1200d17903b05785eb15c35af02866275b0f42277a46c7a9205765ef756bdb9db084c2ceb2bb0380ed86dd15a121929b6cbba611908231d086ad022100b956a289913fd513bf3d085e8837f60e6490be78eff0d98d93f4d08c5e74001d0282018029004ac99e2e5aba6d99ba74da246fbbaae7ba1540cb5d35dfdcd93dcf5bb0742bd8db503ae91bb0b3d8c6847e40c86e85f7770c62691ae204e52d73d824c3510a56f0c221125cd9281522be35e4b52c5c8bc8b4eb72669841e5d4171bd92db8771c546975078070fc6c18b49823df98cb2d2584ae483a73161b1eb9768d1948e3ce2bf8da0eb922278ca17453eb67157c92a0e143cd8b817323229a98ad818418a1ad994ec0cb1a726d2118b494efb763c866f49337c22b34dd0fa4fbb73c9d4f88ab28541ce78a52255cd7c95fc3d7fc228d79a99e83d54ea4168275aa3a72fbd950891c3d42c048b9ba03c553b5d0aed83637569f59686aa57488e4746ad89c90fea0e377959075abafaefd7ccff5bd1212e547dbcd70026b9cb04012d8c97d62ba8dc1b9c3ef7eb6ff0b9e25efc3eb593ce2e604b7b662e12390f3044591d80812d309382367d21ab77ead78ce7d1606dbe22e5a3ec722bb2a6d67e5d0f0d44c00b1e80cee0583f61df7bdb9b9ebf8225a5041b633dfaf11198d7c983f60028201802eec741d2835ff4dffa7b41c533105346c21bf6140bdbc25aec290166b1c87f1bec4c9a3b6c41f3ca5e1a170b1656485fdc98a00bc294fb8e2b95f03f1b0b104768d69de74146dd0921545babc51e7f85c35276602c319dea058b3973614866af220d5bc7aed3353ac79a506b7b5b7e3f8e957ebb2c5d1bd5bcda844df0ea275d80eb28c40f501cca3cf1d64173e244daca9e3fb53925dee37ac0eda6ae08141003f48c5580688a40d5b2b11e2fa81ad4888514a2eaf59cd23f3bb5bab4f595aec5a8639001788280272af77caa3eb16c4544708b2540d89f52cf544138bd3ac1e44c50ef9f99169a090a4ee36f61964189a03eecba84bfeec150cbd99d2b410fc2e465d9c0131d373510e48503a9a71f808f96515ab908dd942ca71f745ce7d3f50da9a202490939ca4037ff67ca3542914b0becea148979b1a78bac983863a39ac04f4ca73a24573c4d8bee1031008e7b4497304cf660d5ee300d767f7ade2945005a0fb75c9817e8351fa57cf7aab3db012702cfbe90fcd1aac50faab11df022100b7f3580347bd0036d803d6ec8b91390cde0486e1bc78e79585b91c3da0a1f654',PUB_DER=>'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'},
  {SIZE=>4096,PRI_FILE=>'key_4096-3.pri.pem',PUB_FILE=>'key_4096-3.pub.pem',PRI=>'14ab4fb361bd3ea6bbf83488224966d224f6fe247fd1f7ae6ef40f098c3f4e15',PUB=>'59ee50c1c33bffc11b087f29ef0e2295ad0ce5534ba81d4edd93c6069f213695a594b6df516fd3cf29312cb11e01ada478df2371b980f6468e745925ffc623395445410b7d83ac4549e378edc757b7ab59c2ac38369b4180f207cd5f3674a968fc02e1ac243bab7af78356580474616342521ca2c1c81615418045f0239cf55f52b4c193514abd1fba7e02bd7d7db219206bc565c11f615efe768c28fff6930a961f88fa4984e775644522ea42b3fd698c79b7e6b06bb0d5f53a9ead504e80d299684485e926d37d8d111913e78e532e3816706b466a6888dfd136ce041c5d8f60b52f4bd0df145850c50640562a013a23f52d1fc4b35a0dffc55b628f7a651f621a11e4fc5176bb901791def06f003884bd3e2826b3532b72be884f52cce7a85f3b6c01093dfd8421a9a986310051e1d4a940ade05a0c40d794940921208ebe0a243fefcbcc6356cd28617218c403e0c972f8c3cc3ac0e41693a58651a01d0ac03e126cddd362aa2e73039c8d53f78b1e06e5abf67b91a5b2f1c4d2d2c593c1a397e4a5d4b486e53cd17354c1ad3a712030e23cebd6614c3e3c38c4ae31759fd8ea276ac95f19f0f644f7fde56c7c221a9911f1189e996476e5cd3d3d000d7c50e5289286e08a1afccd6e3dfea5e30ad76ef2482d16ac9321b8524e839c2522c217003dc247ff69a6eec5d8a0e87fe498b449beedc5cd44aff00e97f5a185a9',DSA_SHA1=>'304402201a99853cdf35cef247bc4d029dde5172c18f65e7ea9b69904319017d6e9bf0b5022069e8e1bba98f9ea859016ba4cbea0115ef452f9bce4f47d7216ef542bea71b3a',DSA_SHA256=>'30440220560704814ace4a241dcff64c95f89c71ad3cb2b23d5f15ce4bac5d5826afdb0802204f7deb328ba25f3b1d76f957bde23c28c08a68fe84070c4c05ea58996f42e399',PRI_DER=>'30820655020100028202010099043ca2b994c89a2999c839a41c2a79d12b626a0c8cbf73c6c65af93b28ac9ec69bab58d65bfb02f2da42f6743f63ee68e224517c04c4d0fb4286f981e84612ea19ddcd4217d0996c78c346c67e0930a882bd135761bf43f6e9fd9cb27c341cbbec64aa7b2d3193089f2e2975656555b0b274fb3348262bb52cd3e97cc0840b9f4caab0b0bd6a47b9f1ac73cb7e5a3c0c773f463605a16ef2dff07e429060d7fb9dda0839890a2d5dac70ac5d8a2ba4084e635541b9dd774db993d638ed70e405437d9bfb8a4d763dbc6d19364103bc2f2dad3e491091fb47998c754e2b098c7dfe00bab9c1d7e207744364fd2c91fc9694082598a688623f5fb4cfbccf0e9f97f700304bb6e955f5ac8a09c85b82b28a50b95ccf90728e8e13aaa82b3d08905f244bd9df07d2f0f98ff52dcd033587377b722975020fc33d725990cf40f35df744aa89efed8d94d9edc5deb807d0cbdd2652ccd2e358c0c4e5dac7235cd5d630b7a4cbb61cc8620985cd7ee67c4e3a7b8439cccb9f8bb06cee107f241219227b0f679f9dd6844e21ff7c1b52bbe3420838ccbb7d6a2bc3a73325d775ec5b4b277b9ea08f665502a90126152f8a9da01f2019dae3238d05d62615825eb8bb5a6476e12d8b5fabefa5b0f95ff57267f814fcdaf2d12fff188fc016d6e0aa0a6259c3e6532db32ace8a18e14451cadd9495099b3157afb249f6a593f5de1fcb910221008492598d9db34282ddd651a5a141ad2f2f3b928306c7b18f2245e3bb47baceb7028202000d820b8709730584eae360da462883ee99b7ca79aa9a8d13bd99ff040205a47d2db840748bb845fe20d538baa75b63ff35a57fe91c7eab39f3136a7e095404dacebe3606398df71a2e4a7ce9cc76db2a345e908048dfd58b91d296678e865862fadc8d0055d84bc2eddc422119fa6796c74408e76bb228adf4d18829771e0bb185480d64366aec6520a3c1398963e436e6176e8ea2ba75ed81251d39bbdff79b421f4b1976db9bbc71fdfb9bec22433c922c27f921b13c017b946549830318462cd80fc2c3383108d77a2add324b1cc180d57e99ea265d99aac0a00cafdccbbf9c1e259d45e410e04e14d4d434f526d03edec2ebc93a5d25a8bdf68771e94e8d3ac53dd9687c7c68edb90477cd8c06b7a159ac117518a24a28cc21da768761c0542f2898eb2cbe17e550a390f84d78dbd032acd9841e9ac4bbe9c1a64b9f7ca51ebb2ba855b6935c0dc109c064270de846e739ac63595db70914d3d747b43a51cf17056021721ef41e9fa813247ae0eb37e9227eb338fd1a194ba1392ef794de6aebb4e73bae2d7d6e10fffc7c24a19f3851b7962c40f86e36635816acaee929edb919444f5c7be739201a88cc0500885ed1736e5c723dbb97bc2e8ae66414498d416e809aa006fd2c91f3dbc0d103c79f34165fa4984ce18902d205a70ba9b46f65dde7b73bdb55830c9f1349f89a1ee47429593f4546b04483b1e0381d5daf0282020059ee50c1c33bffc11b087f29ef0e2295ad0ce5534ba81d4edd93c6069f213695a594b6df516fd3cf29312cb11e01ada478df2371b980f6468e745925ffc623395445410b7d83ac4549e378edc757b7ab59c2ac38369b4180f207cd5f3674a968fc02e1ac243bab7af78356580474616342521ca2c1c81615418045f0239cf55f52b4c193514abd1fba7e02bd7d7db219206bc565c11f615efe768c28fff6930a961f88fa4984e775644522ea42b3fd698c79b7e6b06bb0d5f53a9ead504e80d299684485e926d37d8d111913e78e532e3816706b466a6888dfd136ce041c5d8f60b52f4bd0df145850c50640562a013a23f52d1fc4b35a0dffc55b628f7a651f621a11e4fc5176bb901791def06f003884bd3e2826b3532b72be884f52cce7a85f3b6c01093dfd8421a9a986310051e1d4a940ade05a0c40d794940921208ebe0a243fefcbcc6356cd28617218c403e0c972f8c3cc3ac0e41693a58651a01d0ac03e126cddd362aa2e73039c8d53f78b1e06e5abf67b91a5b2f1c4d2d2c593c1a397e4a5d4b486e53cd17354c1ad3a712030e23cebd6614c3e3c38c4ae31759fd8ea276ac95f19f0f644f7fde56c7c221a9911f1189e996476e5cd3d3d000d7c50e5289286e08a1afccd6e3dfea5e30ad76ef2482d16ac9321b8524e839c2522c217003dc247ff69a6eec5d8a0e87fe498b449beedc5cd44aff00e97f5a185a9022014ab4fb361bd3ea6bbf83488224966d224f6fe247fd1f7ae6ef40f098c3f4e15',PUB_DER=>'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'},
];

#diag("samples_count=". @$data);

for my $h (@$data) {
  my $dsa_pri  = Crypt::PK::DSA->new->import_key(\pack("H*",$h->{PRI_DER}));
  my $dsa_pub  = Crypt::PK::DSA->new->import_key(\pack("H*",$h->{PUB_DER}));
  my $dsa_pri_h = $dsa_pri->key2hash;
  my $dsa_pub_h = $dsa_pub->key2hash;
  $h->{PRI} =~ s/^0+//;
  $h->{PUB} =~ s/^0+//;
  is($dsa_pri_h->{x}, uc $h->{PRI}, "$h->{PRI_FILE}/PRI");
  is($dsa_pri_h->{y}, uc $h->{PUB}, "$h->{PRI_FILE}/PUB");
  is($dsa_pub_h->{y}, uc $h->{PUB}, "$h->{PUB_FILE}/PUB");
  ok( $dsa_pub->verify_message(pack("H*", $h->{DSA_SHA1}), 'test-data', 'SHA1'), "$h->{PRI_FILE}/DSA_SHA1");
  ok( $dsa_pub->verify_message(pack("H*", $h->{DSA_SHA256}), 'test-data', 'SHA256'), "$h->{PRI_FILE}/DSA_SHA256");
}
