################################################################################
#
#  !!!!! Do NOT edit this file directly! -- Edit mktests.PL instead. !!!!!
#
################################################################################
#
#  Perl/Pollution/Portability
#
################################################################################
#
#  Version 3.x, Copyright (C) 2003, Marcus Holland-Moritz.
#  Version 2.x, Copyright (C) 2001, Paul Marquess.
#  Version 1.x, Copyright (C) 1999, Kenneth Albanowski.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the same terms as Perl itself.
#
################################################################################

BEGIN {
  if ($ENV{'PERL_CORE'}) {
    chdir 't' if -d 't';
    @INC = ('../lib', '../ext/Devel/PPPort/t') if -d '../lib' && -d '../ext';
    require Config; import Config;
    use vars '%Config';
    if (" $Config{'extensions'} " !~ m[ Devel/PPPort ] ) {
      print "1..0 # Skip -- Perl configured without Devel::PPPort module\n";
      exit 0;
    }
  }
  else {
    unshift @INC, 't';
  }

  eval "use Test";
  if ($@) {
    require 'testutil.pl';
    print "1..3\n";
  }
  else {
    plan(tests => 3);
  }
}

use Devel::PPPort;
use strict;
$^W = 1;

use File::Path qw/rmtree mkpath/;

my $tmp = 'ppptmp';

rmtree($tmp) if -d $tmp;
mkpath($tmp) or die "mkdir $tmp: $!\n";
chdir($tmp) or die "chdir $tmp: $!\n";

my $inc = '';
if ($ENV{'PERL_CORE'}) {
  $inc = '-I../../lib' if -d '../../lib';
}

END {
  chdir("..") if !-d $tmp && -d "../$tmp";
  rmtree($tmp);
}

ok(&Devel::PPPort::WriteFile("ppport.h"));

sub ppport
{
  my @args = shift;
  join '', `$^X $inc ppport.h @args`;
}

my @tests;

for (split /\s*={70,}\s*/, do { local $/; <DATA> }) {
  s/^\s+//; s/\s+$//;
  my($c, %f);
  ($c, @f{m/-{20,}\s+(\S+)\s+-{20,}/g}) = split /\s*-{20,}\s+\S+\s+-{20,}\s*/;
  push @tests, { code => $c, files => \%f };
}

my $t;
for $t (@tests) {
  my $f;
  for $f (keys %{$t->{files}}) {
    local *F;
    open F, ">$f" or die "open $f: $!\n";
    print F $t->{files}{$f} . "\n";
    close F;
  }

  eval $t->{code};

  unlink keys %{$t->{files}} or die "unlink: $!\n";
}

__DATA__

my $o = ppport('--help');
ok($o =~ /^Usage:/m);

---------------------------- test.xs ------------------------------------------

Perl_newSViv();

===============================================================================

ok(1);

---------------------------- test.xs ------------------------------------------

#include "ppport.h"

grok_bin();

