#!/usr/bin/perl
use strict;
use warnings;

use Test::RequiresInternet qw/getstrike.net 80/;
use Test::More tests => 6;
use Try::Tiny;
BEGIN { use_ok('WebService::Strike') };

my ($t1, $t2, $t3) = strike qw/B425907E5755031BDA4A8D1B6DCCACA97DA14C04 5D4FD5A64E436A831383773F85FB38B888B9ECC9 85DF191A921C20B2DDAFF72368CAB93BA18C5ACE/;

subtest 'order' => sub {
	plan tests => 3;
	is $t1->hash, 'B425907E5755031BDA4A8D1B6DCCACA97DA14C04', 'hash #1';
	is $t2->hash, '5D4FD5A64E436A831383773F85FB38B888B9ECC9', 'hash #2';
	is $t3->hash, '85DF191A921C20B2DDAFF72368CAB93BA18C5ACE', 'hash #3'
};

is $t1->date, 1420502400, 'date';
is $t2->title, 'FreeBSD 7.1 i386.DVD.iso', 'title';
like $t1->torrent, qr/^d/, 'torrent file starts with d';

try {
	strike 'aaa';
} catch {
	is $_->{status}, 404, 'non-existent torrent status is 404';
};
