#!/usr/bin/perl -w

# Copyright 2011 Kevin Ryde

# This file is part of Math-PlanePath.
#
# Math-PlanePath is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3, or (at your option) any later
# version.
#
# Math-PlanePath is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with Math-PlanePath.  If not, see <http://www.gnu.org/licenses/>.

use 5.004;
use strict;
use Test;
BEGIN { plan tests => 13; }

use lib 't';
use MyTestHelpers;
MyTestHelpers::nowarnings();

require Math::PlanePath::File;


#------------------------------------------------------------------------------
# VERSION

{
  my $want_version = 48;
  ok ($Math::PlanePath::File::VERSION, $want_version,
      'VERSION variable');
  ok (Math::PlanePath::File->VERSION,  $want_version,
      'VERSION class method');

  ok (eval { Math::PlanePath::File->VERSION($want_version); 1 },
      1,
      "VERSION class check $want_version");
  my $check_version = $want_version + 1000;
  ok (! eval { Math::PlanePath::File->VERSION($check_version); 1 },
      1,
      "VERSION class check $check_version");

  my $path = Math::PlanePath::File->new;
  ok ($path->VERSION,  $want_version, 'VERSION object method');

  ok (eval { $path->VERSION($want_version); 1 },
      1,
      "VERSION object check $want_version");
  ok (! eval { $path->VERSION($check_version); 1 },
      1,
      "VERSION object check $check_version");
}

#------------------------------------------------------------------------------
# no filename

{
  my $path = Math::PlanePath::File->new;
  ok ($path->n_start, 1, 'n_start()');
  ok ($path->x_negative, 0, 'x_negative()');
  ok ($path->y_negative, 0, 'y_negative()');
  my ($got_lo, $got_hi) = $path->rect_to_n_range (-1,-1, 1,1);
  ok ($got_lo, 1, "lo on empty");
  ok ($got_hi, 0, "hi on empty");
}
{
  my @pnames = map {$_->{'name'}}
    Math::PlanePath::File->parameter_info_list;
  ok (join(',',@pnames), 'filename');
}

exit 0;
