#!/usr/bin/perl

# Copyright 2008 Kevin Ryde

# This file is part of Gtk2-Ex-Xor.
#
# Gtk2-Ex-Xor is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3, or (at your option) any later
# version.
#
# Gtk2-Ex-Xor is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along
# with Gtk2-Ex-Xor.  If not, see <http://www.gnu.org/licenses/>.


# Usage: perl lasso-screenshot.pl [outputfile.png]
#

use strict;
use warnings;
use Gtk2 '-init';
use Gtk2::Ex::Lasso;

my $output_filename = (@ARGV >= 1 ? $ARGV[0]
                       : '/tmp/lasso-screenshot.png');

my $toplevel = Gtk2::Window->new('toplevel');
$toplevel->signal_connect (destroy => sub { Gtk2->main_quit });

$toplevel->set_size_request (200, 100);
$toplevel->modify_bg ('normal', Gtk2::Gdk::Color->parse ('black'));

my $lasso = Gtk2::Ex::Lasso->new (widget => $toplevel,
                                  foreground => 'white');

my $id;
$toplevel->signal_connect
  (map_event => sub {
     Gtk2::Ex::Lasso::_widget_warp_pointer ($toplevel, 40, 10);
     $lasso->start ();
     $id = $lasso->signal_connect (moved => \&save);
     Gtk2::Ex::Lasso::_widget_warp_pointer ($toplevel, 160, 70);
   });

sub save {
  my $window = $toplevel->window;
  my ($width, $height) = $window->get_size;

  my $cursor_pixbuf = Gtk2::Gdk::Pixbuf->new_from_file
    ('/tmp/hand1.xpm');
  print "cursor ",$cursor_pixbuf->get_width,"x",
    $cursor_pixbuf->get_height,"\n";

  my $x_hot = $cursor_pixbuf->get_option ('x_hot');
  my $y_hot = $cursor_pixbuf->get_option ('y_hot');
  print "hotspot $x_hot,$y_hot\n";

  my $gc = $toplevel->get_style->fg_gc ('normal');
  my ($x, $y) = $toplevel->get_pointer;
  $cursor_pixbuf->render_to_drawable ($window, $gc, 0,0,
                                      $x - $x_hot, $y - $y_hot,
                                      $cursor_pixbuf->get_width,
                                      $cursor_pixbuf->get_height,
                                      'none', 0,0);

  my $pixbuf = Gtk2::Gdk::Pixbuf->get_from_drawable ($window,
                                                     undef, # colormap
                                                     0,0, 0,0,
                                                     $width, $height);

  $pixbuf->save ($output_filename, 'png',
                 'tEXt::Title' => 'Lasso Screenshot',
                 'tEXt::Author' => 'Kevin Ryde',
                 'tEXt::Copyright' => 'Copyright 2008 Kevin Ryde',
                 'tEXt::Description'
                 => 'A sample screenshot of a Gtk2::Ex::Lasso display.
Generated by devel/lasso-screenshot.pl');

  $lasso->signal_handler_disconnect ($id);
  Glib::Timeout->add (2000, sub {
                        $lasso->abort ();
                        Gtk2->main_quit;
                        return 0; # stop timer
                      });
}

$toplevel->show_all;
Gtk2->main;
exit 0
