#!perl

use strict;
use warnings;

# This test was generated by Dist::Zilla::Plugin::Test::ReportPrereqs 0.012

use Test::More tests => 1;

use ExtUtils::MakeMaker;
use File::Spec::Functions;
use List::Util qw/max/;

my @modules = qw(
  CPAN::Meta
  CPAN::Meta::Requirements
  Capture::Tiny
  Carp
  Dist::Zilla
  Dist::Zilla::File::FromCode
  Dist::Zilla::Plugin::Authority
  Dist::Zilla::Plugin::AutoPrereqs
  Dist::Zilla::Plugin::Bootstrap::lib
  Dist::Zilla::Plugin::ConfirmRelease
  Dist::Zilla::Plugin::EOLTests
  Dist::Zilla::Plugin::Git::Check
  Dist::Zilla::Plugin::Git::Commit
  Dist::Zilla::Plugin::Git::CommitBuild
  Dist::Zilla::Plugin::Git::GatherDir
  Dist::Zilla::Plugin::Git::NextRelease
  Dist::Zilla::Plugin::Git::NextVersion::Sanitized
  Dist::Zilla::Plugin::Git::Tag
  Dist::Zilla::Plugin::GithubMeta
  Dist::Zilla::Plugin::License
  Dist::Zilla::Plugin::Manifest
  Dist::Zilla::Plugin::ManifestSkip
  Dist::Zilla::Plugin::MetaConfig
  Dist::Zilla::Plugin::MetaData::BuiltWith
  Dist::Zilla::Plugin::MetaJSON
  Dist::Zilla::Plugin::MetaProvides::Package
  Dist::Zilla::Plugin::MetaTests
  Dist::Zilla::Plugin::MetaYAML
  Dist::Zilla::Plugin::MinimumPerl
  Dist::Zilla::Plugin::ModuleBuild
  Dist::Zilla::Plugin::PerlTidy
  Dist::Zilla::Plugin::PkgVersion
  Dist::Zilla::Plugin::PodCoverageTests
  Dist::Zilla::Plugin::PodSyntaxTests
  Dist::Zilla::Plugin::PodWeaver
  Dist::Zilla::Plugin::Prereqs
  Dist::Zilla::Plugin::Prereqs::MatchInstalled
  Dist::Zilla::Plugin::ReadmeAnyFromPod
  Dist::Zilla::Plugin::ReadmeFromPod
  Dist::Zilla::Plugin::RunExtraTests
  Dist::Zilla::Plugin::Test::CPAN::Changes
  Dist::Zilla::Plugin::Test::Compile::PerFile
  Dist::Zilla::Plugin::Test::Kwalitee
  Dist::Zilla::Plugin::Test::MinimumVersion
  Dist::Zilla::Plugin::Test::Perl::Critic
  Dist::Zilla::Plugin::Test::ReportPrereqs
  Dist::Zilla::Plugin::TestRelease
  Dist::Zilla::Plugin::Twitter
  Dist::Zilla::Plugin::UploadToCPAN
  Dist::Zilla::Role::BundleDeps
  Dist::Zilla::Role::FileGatherer
  Dist::Zilla::Role::MintingProfile::ShareDir
  Dist::Zilla::Role::PluginBundle
  Dist::Zilla::Util::EmulatePhase
  ExtUtils::MakeMaker
  File::Spec::Functions
  File::pushd
  FindBin
  Git::Wrapper
  IO::Socket::SSL
  JSON
  LWP::Protocol::https
  List::Util
  Module::Build
  Module::Metadata
  Moose
  Moose::Util::TypeConstraints
  MooseX::AttributeShortcuts
  MooseX::Has::Sugar
  MooseX::StrictConstructor
  MooseX::Types
  Net::SSLeay
  Path::Class::Dir
  Path::Tiny
  Perl::PrereqScanner
  Pod::Coverage::TrustPod
  Pod::Elemental::PerlMunger
  String::Formatter
  Test::CPAN::Meta
  Test::DZil
  Test::EOL
  Test::Fatal
  Test::File::ShareDir
  Test::More
  Test::Output
  Test::Perl::Critic
  Test::Pod
  Test::Pod::Coverage
  lib
  namespace::autoclean
  perl
  strict
  utf8
  version
  warnings
);

my %exclude = map {; $_ => 1 } qw(

);

my ($source) = grep { -f $_ } qw/MYMETA.json MYMETA.yml META.json/;
$source = "META.yml" unless defined $source;

# replace modules with dynamic results from MYMETA.json if we can
# (hide CPAN::Meta from prereq scanner)
my $cpan_meta = "CPAN::Meta";
my $cpan_meta_req = "CPAN::Meta::Requirements";
my $all_requires;
if ( -f $source && eval "require $cpan_meta" ) { ## no critic
  if ( my $meta = eval { CPAN::Meta->load_file($source) } ) {

    # Get ALL modules mentioned in META (any phase/type)
    my $prereqs = $meta->prereqs;
    delete $prereqs->{develop} if not $ENV{AUTHOR_TESTING};
    my %uniq = map {$_ => 1} map { keys %$_ } map { values %$_ } values %$prereqs;
    $uniq{$_} = 1 for @modules; # don't lose any static ones
    @modules = sort grep { ! $exclude{$_} } keys %uniq;

    # If verifying, merge 'requires' only for major phases
    if ( 1 ) {
      $prereqs = $meta->effective_prereqs; # get the object, not the hash
      if (eval "require $cpan_meta_req; 1") { ## no critic
        $all_requires = $cpan_meta_req->new;
        for my $phase ( qw/configure build test runtime develop/ ) {
          $all_requires->add_requirements(
            $prereqs->requirements_for($phase, 'requires')
          );
        }
      }
    }
  }
}

my @reports = [qw/Version Module/];
my @dep_errors;
my $req_hash = defined($all_requires) ? $all_requires->as_string_hash : {};

for my $mod ( @modules ) {
  next if $mod eq 'perl';
  my $file = $mod;
  $file =~ s{::}{/}g;
  $file .= ".pm";
  my ($prefix) = grep { -e catfile($_, $file) } @INC;
  if ( $prefix ) {
    my $ver = MM->parse_version( catfile($prefix, $file) );
    $ver = "undef" unless defined $ver; # Newer MM should do this anyway
    push @reports, [$ver, $mod];

    if ( 1 && $all_requires ) {
      my $req = $req_hash->{$mod};
      if ( defined $req && length $req ) {
        if ( ! defined eval { version->parse($ver) } ) {
          push @dep_errors, "$mod version '$ver' cannot be parsed (version '$req' required)";
        }
        elsif ( ! $all_requires->accepts_module( $mod => $ver ) ) {
          push @dep_errors, "$mod version '$ver' is not in required range '$req'";
        }
      }
    }

  }
  else {
    push @reports, ["missing", $mod];

    if ( 1 && $all_requires ) {
      my $req = $req_hash->{$mod};
      if ( defined $req && length $req ) {
        push @dep_errors, "$mod is not installed (version '$req' required)";
      }
    }
  }
}

if ( @reports ) {
  my $vl = max map { length $_->[0] } @reports;
  my $ml = max map { length $_->[1] } @reports;
  splice @reports, 1, 0, ["-" x $vl, "-" x $ml];
  diag "\nVersions for all modules listed in $source (including optional ones):\n",
    map {sprintf("  %*s %*s\n",$vl,$_->[0],-$ml,$_->[1])} @reports;
}

if ( @dep_errors ) {
  diag join("\n",
    "\n*** WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING ***\n",
    "The following REQUIRED prerequisites were not satisfied:\n",
    @dep_errors,
    "\n"
  );
}

pass;

# vim: ts=2 sts=2 sw=2 et:
