#
#  Copyright (c) 1997-2002 The Protein Laboratory, University of Copenhagen
#  All rights reserved.
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#
#  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
#  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
#  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
#  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
#  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
#  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
#  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
#  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
#  SUCH DAMAGE.
#
# $Id: Printer.cls,v 1.16 2002/10/31 22:34:21 dk Exp $

object Prima::Printer( Prima::Drawable)
{
   property char * printer;
   property Point  resolution;
   property Point  size;

   method void   abort_doc();
   method Bool   begin_doc( char * docName = "");
   method Bool   begin_paint();
   method Bool   begin_paint_info();
   method void   done();
   method void   end_doc();
   method void   end_paint();
   method void   end_paint_info();
   method SV*    fonts( char * name = "", char * encoding = "");
   method SV*    font_encodings( char * encoding = "");
   method void   init( HV * profile);
   method void   new_page();
   method SV *   printers();
   method Bool   setup_dialog()                     => apc_prn_setup;
   c_only Bool   validate_owner( Handle * newOwner, HV * profile);

   method char * get_default_printer()              => apc_prn_get_default;
   method SV   * get_handle();
}
