package Business::EDI::CodeList::AllowanceOrChargeIdentificationCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {5189;}
my $usage       = 'B';

# *    5189  Allowance or charge identification code                 [B]
# Desc: Code specifying the identification of an allowance or
# charge.
# Repr: an..3

my %code_hash = (
'1' => [ 'Handling commission',
    'Fee for the processing of documentary credit, collection and payment which are charged to the customer.' ],
'2' => [ 'Amendment commission',
    'Fee for amendments in documentary credit and collection business (not extensions and increases of documentary credits).' ],
'3' => [ 'Acceptance commission',
    "Fee for the acceptance of draft in documentary credit and collection business which are drawn on us (also to be seen as a kind of 'guarantee commission')." ],
'4' => [ 'Commission for obtaining acceptance',
    "Fee for obtaining an acceptance under collections on the basis of 'documents against acceptance'." ],
'5' => [ 'Commission on delivery',
    'Fee for delivery of documents without corresponding payment.' ],
'6' => [ 'Advising commission',
    'Fee for advising documentary credits (charged also in case of confirmed credits).' ],
'7' => [ 'Confirmation commission',
    'Fee for confirmation of credit.' ],
'8' => [ 'Deferred payment commission',
    'Fee for the deferred payment period under documentary credits confirmed by bank. This fee are charges for the period from presentation of the document until due date of payment.' ],
'9' => [ 'Commission for taking up documents',
    'Fee charged to the foreign bank for the processing of documentary credit.' ],
'10' => [ 'Opening commission',
    'Fee for opening revocable documentary credit.' ],
'11' => [ 'Fee for payment under reserve',
    'Fee charged to the customer for discrepancies in credit documents in the case of which the bank have to stipulate payment under reserve.' ],
'12' => [ 'Discrepancy fee',
    'Fee charged to the foreign bank for discrepancies in credit documents.' ],
'13' => [ 'Domicilation commission',
    'Fee for the domicilation of bills with the bank.' ],
'14' => [ 'Commission for release of goods',
    'Commission for the release of goods sent to the bank.' ],
'15' => [ 'Collection commission',
    "Fee for settling collections on the basis of 'documents against payments'." ],
'16' => [ 'Negotiation commission',
    'Fee for the purchase of documents under sight credit for the first ten days.' ],
'17' => [ 'Return commission',
    'Fee for cheques, bills and collections returned unpaid and/or recalled.' ],
'18' => [ 'B/L splitting charges',
    'Fee for the splitting of bills of lading.' ],
'19' => [ 'Trust commission',
    'Fee for the handling on a fiduciary basis of imported goods that have been warehoused.' ],
'20' => [ 'Transfer commission',
    'Fee for the transfer of transferable documentary credits.' ],
'21' => [ 'Commission for opening irrevocable documentary credits',
    "Fee for opening irrevocable documentary credits. This fee is a kind of 'Guarantee commission' as compensation for the commitment into which the bank have entered on the customers behalf; similar to confirmation commission, acceptance commission." ],
'22' => [ 'Pre-advice commission',
    'Fee for the pre-advice of a documentary credit.' ],
'23' => [ 'Supervisory commission',
    'Fee for the supervising unconfirmed documentary credits with a deferred payment period.' ],
'24' => [ 'Model charges',
    'Fee for decoding telex messages.' ],
'25' => [ 'Risk commission',
    'Commission in addition to the confirmation commission for documentary credits from sensitive countries.' ],
'26' => [ 'Guarantee commission',
    'Commission for drawing up guaranties.' ],
'27' => [ 'Reimbursement commission',
    'Fee for reimbursement of, for example, documentary credits.' ],
'28' => [ 'Stamp duty',
    'Tax payable on bills in accordance with national bill of exchange legislation.' ],
'29' => [ 'Brokerage',
    'Brokers commission arising, in trade with foreign currencies.' ],
'30' => [ 'Bank charges',
    'Charges deducted/claimed by other banks involved in the transaction.' ],
'31' => [ 'Bank charges information',
    'Charges not included in the total charge amount i.e. the charges are for information only.' ],
'32' => [ 'Courier fee',
    'Fee for use of courier service.' ],
'33' => [ 'Phone fee',
    'Fee for use of phone.' ],
'34' => [ 'Postage fee',
    'Fee for postage.' ],
'35' => [ 'S.W.I.F.T. fee',
    'Fee for use of S.W.I.F.T.' ],
'36' => [ 'Telex fee',
    'Fee for telex.' ],
'37' => [ 'Penalty for late delivery of documents',
    'Penalty imposed when documents are delivered late.' ],
'38' => [ 'Penalty for late delivery of valuation of works',
    'Penalty imposed when valuation of works is delivered late.' ],
'39' => [ 'Penalty for execution of works behind schedule',
    'Penalty imposed when the execution of works is behind schedule.' ],
'40' => [ 'Other penalties',
    'Penalty imposed for other reasons.' ],
'41' => [ 'Bonus for works ahead of schedule',
    'Bonus for completing work ahead of schedule.' ],
'42' => [ 'Other bonus',
    'Bonus earned for other reasons.' ],
'44' => [ 'Project management cost',
    'Cost for project management.' ],
'45' => [ 'Pro rata retention',
    'Proportional retention charge.' ],
'46' => [ 'Contractual retention',
    'Contractual retention charge.' ],
'47' => [ 'Other retentions',
    'Retention charge not otherwise specified.' ],
'48' => [ 'Interest on arrears',
    'Interest for late payment.' ],
'49' => [ 'Interest',
    'Cost of using money.' ],
'50' => [ 'Charge per credit cover',
    'Unit charge per credit cover established.' ],
'51' => [ 'Charge per unused credit cover',
    'Unit charge per unused credit cover.' ],
'52' => [ 'Minimum commission',
    'Minimum commission charge.' ],
'53' => [ 'Factoring commission',
    'Commission charged for factoring services.' ],
'54' => [ 'Chamber of commerce charge',
    'Identifies the charges from the chamber of commerce.' ],
'55' => [ 'Transfer charges',
    'Charges for transfer.' ],
'56' => [ 'Repatriation charges',
    'Charges for repatriation.' ],
'57' => [ 'Miscellaneous charges',
    'Not specifically defined charges.' ],
'58' => [ 'Foreign exchange charges',
    'Charges for foreign exchange.' ],
'59' => [ 'Agreed debit interest charge',
    'Charge for agreed debit interest' ],
'60' => [ "Manufacturer's consumer discount",
    'A discount given by the manufacturer which should be passed on to the consumer.' ],
'61' => [ 'Fax advice charge',
    'Charge for fax advice.' ],
'62' => [ 'Due to military status',
    'Allowance granted because of the military status.' ],
'63' => [ 'Due to work accident',
    'Allowance granted to a victim of a work accident.' ],
'64' => [ 'Special agreement',
    'An allowance or charge as specified in a special agreement.' ],
'65' => [ 'Production error discount',
    'A discount given for the purchase of a product with a production error.' ],
'66' => [ 'New outlet discount',
    'A discount given at the occasion of the opening of a new outlet.' ],
'67' => [ 'Sample discount',
    'A discount given for the purchase of a sample of a product.' ],
'68' => [ 'End-of-range discount',
    'A discount given for the purchase of an end-of-range product.' ],
'69' => [ 'Charge for a customer specific finish',
    'A charge for the addition of a customer specific finish to a product.' ],
'70' => [ 'Incoterm discount',
    'A discount given for a specified Incoterm.' ],
'71' => [ 'Point of sales threshold allowance',
    'Allowance for reaching or exceeding an agreed sales threshold at the point of sales.' ],
'72' => [ 'Technical modification costs',
    'Costs for technical modifications to a product.' ],
'73' => [ 'Job-order production costs',
    'Costs of job-order production.' ],
'74' => [ 'Off-premises costs',
    'Expenses for non-local activities.' ],
'75' => [ 'Additional processing costs',
    'Costs of additional processing.' ],
'76' => [ 'Attesting charge',
    'Costs of official attestation.' ],
'77' => [ 'Rush delivery surcharge',
    'Charge for increased delivery speed.' ],
'78' => [ 'Special construction costs',
    'Charge for costs incurred as result of special constructions.' ],
'79' => [ 'Freight charges',
    'Amount to be paid for moving goods, by whatever means, from one place to another.' ],
'80' => [ 'Packing charge',
    'Charge for packing.' ],
'81' => [ 'Repair charge',
    'Charge for repair.' ],
'82' => [ 'Loading charge',
    'Charge for loading.' ],
'83' => [ 'Setup charge',
    'Charge for setup.' ],
'84' => [ 'Testing charge',
    'Charge for testing.' ],
'85' => [ 'Warehousing charge',
    'Charge for storage and handling.' ],
'86' => [ 'Gold surcharge',
    'Difference between current price and basic value contained in product price in relation to gold content.' ],
'87' => [ 'Copper surcharge',
    'Difference between current price and basic value contained in product price in relation to copper content.' ],
'88' => [ 'Material surcharge/deduction',
    "Surcharge/deduction, calculated for higher/ lower material's consumption." ],
'89' => [ 'Lead surcharge',
    'Difference between current price and basic value contained in product price in relation to lead content.' ],
'90' => [ 'Price index surcharge',
    'Higher/lower price, resulting from change in costs between the times of making offer and delivery.' ],
'91' => [ 'Platinum surcharge',
    'Difference between current price and basic value contained in product price in relation to platinum content.' ],
'92' => [ 'Silver surcharge',
    'Difference between current price and basic value contained in product price in relation to silver content.' ],
'93' => [ 'Wolfram surcharge',
    'Difference between current price and basic value contained in product price in relation to wolfram content.' ],
'94' => [ 'Aluminum surcharge',
    'Difference between current price and basic value contained in product price in relation to aluminum content.' ],
'95' => [ 'Discount',
    'A reduction from a usual or list price.' ],
'96' => [ 'Insurance',
    'Charge for insurance.' ],
'97' => [ 'Minimum order / minimum billing charge',
    'Charge for minimum order or minimum billing.' ],
'98' => [ 'Material surcharge (special materials)',
    'Surcharge for (special) materials.' ],
'99' => [ 'Surcharge',
    'An additional amount added to the usual charge.' ],
'100' => [ 'Special rebate',
    'A return of part of an amount paid for goods or services, serving as a reduction or discount.' ],
);
sub get_codes { return \%code_hash; }

1;
