=head1

Locale::CLDR::Locales::Uk - Package for language Ukrainian

=cut

package Locale::CLDR::Locales::Uk;
# This file auto generated from Data\common\main\uk.xml
#	on Wed 10 Feb  8:28:24 am GMT

use version;

our $VERSION = version->declare('v0.28.3');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => 'ArrayRef',
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal-masculine','spellout-cardinal-neuter','spellout-cardinal-feminine' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => 'HashRef',
	init_arg => undef,
	default => sub { 
		use bignum;
		return {
		'spellout-cardinal-feminine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(мінус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нуль),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(одна),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(дві),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадцять[ →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридцять[ →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(сорок[ →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(пʼятдесят[ →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шістдесят[ →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(сімдесят[ →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(вісімдесят[ →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(девʼяносто[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двісті[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(чотириста[ →→]),
				},
				'500' => {
					base_value => q(500),
					divisor => q(100),
					rule => q(пʼятсот[ →→]),
				},
				'600' => {
					base_value => q(600),
					divisor => q(100),
					rule => q(шістсот[ →→]),
				},
				'700' => {
					base_value => q(700),
					divisor => q(100),
					rule => q(сімсот[ →→]),
				},
				'800' => {
					base_value => q(800),
					divisor => q(100),
					rule => q(вісімсот[ →→]),
				},
				'900' => {
					base_value => q(900),
					divisor => q(100),
					rule => q(девʼятсот[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← тисяча[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← тисячі[ →→]),
				},
				'5000' => {
					base_value => q(5000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← тисяч[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← мільйон[ →→]),
				},
				'2000000' => {
					base_value => q(2000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← мільйони[ →→]),
				},
				'5000000' => {
					base_value => q(5000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← мільйонів[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← мільярд[ →→]),
				},
				'2000000000' => {
					base_value => q(2000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← мільярди[ →→]),
				},
				'5000000000' => {
					base_value => q(5000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← мільярдів[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← більйон[ →→]),
				},
				'2000000000000' => {
					base_value => q(2000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← більйони[ →→]),
				},
				'5000000000000' => {
					base_value => q(5000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← більйонів[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← більярд[ →→]),
				},
				'2000000000000000' => {
					base_value => q(2000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← більярди[ →→]),
				},
				'5000000000000000' => {
					base_value => q(5000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← більярдів[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-masculine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(мінус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нуль),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(один),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(два),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(три),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(чотири),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(пʼять),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(шість),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(сім),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(вісім),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(девʼять),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(десять),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(одинадцять),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(дванадцять),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(тринадцять),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(чотирнадцять),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(пʼятнадцять),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(шістнадцять),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(сімнадцять),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(вісімнадцять),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(девʼятнадцять),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадцять[ →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридцять[ →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(сорок[ →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(пʼятдесят[ →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шістдесят[ →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(сімдесят[ →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(вісімдесят[ →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(девʼяносто[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двісті[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(чотириста[ →→]),
				},
				'500' => {
					base_value => q(500),
					divisor => q(100),
					rule => q(пʼятсот[ →→]),
				},
				'600' => {
					base_value => q(600),
					divisor => q(100),
					rule => q(шістсот[ →→]),
				},
				'700' => {
					base_value => q(700),
					divisor => q(100),
					rule => q(сімсот[ →→]),
				},
				'800' => {
					base_value => q(800),
					divisor => q(100),
					rule => q(вісімсот[ →→]),
				},
				'900' => {
					base_value => q(900),
					divisor => q(100),
					rule => q(девʼятсот[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← тисяча[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← тисячі[ →→]),
				},
				'5000' => {
					base_value => q(5000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← тисяч[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← мільйон[ →→]),
				},
				'2000000' => {
					base_value => q(2000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← мільйони[ →→]),
				},
				'5000000' => {
					base_value => q(5000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← мільйонів[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← мільярд[ →→]),
				},
				'2000000000' => {
					base_value => q(2000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← мільярди[ →→]),
				},
				'5000000000' => {
					base_value => q(5000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← мільярдів[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← більйон[ →→]),
				},
				'2000000000000' => {
					base_value => q(2000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← більйони[ →→]),
				},
				'5000000000000' => {
					base_value => q(5000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← більйонів[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← більярд[ →→]),
				},
				'2000000000000000' => {
					base_value => q(2000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← більярди[ →→]),
				},
				'5000000000000000' => {
					base_value => q(5000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← більярдів[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-neuter' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(мінус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нуль),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(одне),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(два),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадцять[ →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридцять[ →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(сорок[ →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(пʼятдесят[ →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шістдесят[ →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(сімдесят[ →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(вісімдесят[ →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(девʼяносто[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двісті[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(чотириста[ →→]),
				},
				'500' => {
					base_value => q(500),
					divisor => q(100),
					rule => q(пʼятсот[ →→]),
				},
				'600' => {
					base_value => q(600),
					divisor => q(100),
					rule => q(шістсот[ →→]),
				},
				'700' => {
					base_value => q(700),
					divisor => q(100),
					rule => q(сімсот[ →→]),
				},
				'800' => {
					base_value => q(800),
					divisor => q(100),
					rule => q(вісімсот[ →→]),
				},
				'900' => {
					base_value => q(900),
					divisor => q(100),
					rule => q(девʼятсот[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← тисяча[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← тисячі[ →→]),
				},
				'5000' => {
					base_value => q(5000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← тисяч[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← мільйон[ →→]),
				},
				'2000000' => {
					base_value => q(2000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← мільйони[ →→]),
				},
				'5000000' => {
					base_value => q(5000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← мільйонів[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← мільярд[ →→]),
				},
				'2000000000' => {
					base_value => q(2000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← мільярди[ →→]),
				},
				'5000000000' => {
					base_value => q(5000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← мільярдів[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← більйон[ →→]),
				},
				'2000000000000' => {
					base_value => q(2000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← більйони[ →→]),
				},
				'5000000000000' => {
					base_value => q(5000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← більйонів[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← більярд[ →→]),
				},
				'2000000000000000' => {
					base_value => q(2000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← більярди[ →→]),
				},
				'5000000000000000' => {
					base_value => q(5000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← більярдів[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
			},
		},
	} },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'афарська',
 				'ab' => 'абхазька',
 				'ace' => 'ачехська',
 				'ach' => 'ачолі',
 				'ada' => 'адангме',
 				'ady' => 'адигейська',
 				'ae' => 'авестійська',
 				'af' => 'африкаанс',
 				'afh' => 'африхілі',
 				'agq' => 'агем',
 				'ain' => 'айнська',
 				'ak' => 'акан',
 				'akk' => 'аккадська',
 				'akz' => 'алабама',
 				'ale' => 'алеутська',
 				'alt' => 'південноалтайська',
 				'am' => 'амхарська',
 				'an' => 'арагонська',
 				'ang' => 'давньоанглійська',
 				'anp' => 'ангіка',
 				'ar' => 'арабська',
 				'ar_001' => 'сучасна стандартна арабська',
 				'arc' => 'арамейська',
 				'arn' => 'арауканська',
 				'aro' => 'араона',
 				'arp' => 'арапахо',
 				'arq' => 'алжирська арабська',
 				'arw' => 'аравакська',
 				'as' => 'ассамська',
 				'asa' => 'асу',
 				'ase' => 'американська мова рухів',
 				'ast' => 'астурська',
 				'av' => 'аварська',
 				'awa' => 'авадхі',
 				'ay' => 'аймара',
 				'az' => 'азербайджанська',
 				'az@alt=short' => 'азербайджанська',
 				'az_Arab' => 'південноазербайджанська',
 				'ba' => 'башкирська',
 				'bal' => 'балучі',
 				'ban' => 'балійська',
 				'bar' => 'баеріш',
 				'bas' => 'баса',
 				'bax' => 'бамум',
 				'bbc' => 'батак тоба',
 				'bbj' => 'гомала',
 				'be' => 'білоруська',
 				'bej' => 'беджа',
 				'bem' => 'бемба',
 				'bew' => 'бетаві',
 				'bez' => 'бена',
 				'bfd' => 'бафут',
 				'bfq' => 'бадага',
 				'bg' => 'болгарська',
 				'bgn' => 'східнобелуджійська',
 				'bho' => 'бходжпурі',
 				'bi' => 'біслама',
 				'bik' => 'бікольська',
 				'bin' => 'біні',
 				'bjn' => 'банджарська',
 				'bkm' => 'ком',
 				'bla' => 'сіксіка',
 				'bm' => 'бамбара',
 				'bn' => 'бенгальська',
 				'bo' => 'тибетська',
 				'bqi' => 'бахтіарі',
 				'br' => 'бретонська',
 				'bra' => 'брадж',
 				'brx' => 'бодо',
 				'bs' => 'боснійська',
 				'bss' => 'акус',
 				'bua' => 'бурятська',
 				'bug' => 'бугійська',
 				'bum' => 'булу',
 				'byn' => 'блін',
 				'byv' => 'медумба',
 				'ca' => 'каталонська',
 				'cad' => 'каддо',
 				'car' => 'карібська',
 				'cay' => 'кайюга',
 				'cch' => 'атсам',
 				'ce' => 'чеченська',
 				'ceb' => 'себуанська',
 				'cgg' => 'кіга',
 				'ch' => 'чаморро',
 				'chb' => 'чібча',
 				'chg' => 'чагатайська',
 				'chk' => 'чуукська',
 				'chm' => 'марійська',
 				'chn' => 'чинук жаргон',
 				'cho' => 'чокто',
 				'chp' => 'чіпев’ян',
 				'chr' => 'черокі',
 				'chy' => 'чейєнн',
 				'ckb' => 'курдська (сорані)',
 				'co' => 'корсиканська',
 				'cop' => 'коптська',
 				'cr' => 'крі',
 				'crh' => 'кримськотатарська',
 				'cs' => 'чеська',
 				'csb' => 'кашубська',
 				'cu' => 'церковнослов’янська',
 				'cv' => 'чуваська',
 				'cy' => 'валлійська',
 				'da' => 'данська',
 				'dak' => 'дакота',
 				'dar' => 'даргінська',
 				'dav' => 'таіта',
 				'de' => 'німецька',
 				'de_CH' => 'верхньонімецька (Швейцарія)',
 				'del' => 'делаварська',
 				'den' => 'слейв',
 				'dgr' => 'догрибська',
 				'din' => 'дінка',
 				'dje' => 'джерма',
 				'doi' => 'догрі',
 				'dsb' => 'нижньолужицька',
 				'dua' => 'дуала',
 				'dum' => 'середньонідерландська',
 				'dv' => 'дівехі',
 				'dyo' => 'дьола-фоні',
 				'dyu' => 'діула',
 				'dz' => 'дзонг-ке',
 				'dzg' => 'дазага',
 				'ebu' => 'ембу',
 				'ee' => 'еве',
 				'efi' => 'ефік',
 				'egy' => 'давньоєгипетська',
 				'eka' => 'екаджук',
 				'el' => 'грецька',
 				'elx' => 'еламська',
 				'en' => 'англійська',
 				'en_GB' => 'англійська британська',
 				'enm' => 'середньоанглійська',
 				'eo' => 'есперанто',
 				'es' => 'іспанська',
 				'es_ES' => 'іспанська (Європа)',
 				'et' => 'естонська',
 				'eu' => 'баскська',
 				'ewo' => 'евондо',
 				'fa' => 'перська',
 				'fan' => 'фанг',
 				'fat' => 'фанті',
 				'ff' => 'фула',
 				'fi' => 'фінська',
 				'fil' => 'філіппінська',
 				'fj' => 'фіджі',
 				'fo' => 'фарерська',
 				'fon' => 'фон',
 				'fr' => 'французька',
 				'frm' => 'середньофранцузька',
 				'fro' => 'давньофранцузька',
 				'frp' => 'арпітанська',
 				'frr' => 'фризька північна',
 				'frs' => 'фризька східна',
 				'fur' => 'фріульська',
 				'fy' => 'західнофризька',
 				'ga' => 'ірландська',
 				'gaa' => 'га',
 				'gag' => 'гагаузька',
 				'gay' => 'гайо',
 				'gba' => 'гбайя',
 				'gd' => 'гаельська',
 				'gez' => 'гєез',
 				'gil' => 'гільбертська',
 				'gl' => 'галісійська',
 				'gmh' => 'середньоверхньонімецька',
 				'gn' => 'гуарані',
 				'goh' => 'давньоверхньонімецька',
 				'gon' => 'гонді',
 				'gor' => 'горонтало',
 				'got' => 'готська',
 				'grb' => 'гребо',
 				'grc' => 'давньогрецька',
 				'gsw' => 'німецька (Швейцарія)',
 				'gu' => 'гуджараті',
 				'guz' => 'гусії',
 				'gv' => 'менкська',
 				'gwi' => 'кучін',
 				'ha' => 'хауса',
 				'hai' => 'хайда',
 				'haw' => 'гавайська',
 				'he' => 'іврит',
 				'hi' => 'гінді',
 				'hil' => 'хілігайнон',
 				'hit' => 'хітіті',
 				'hmn' => 'хмонг',
 				'ho' => 'хірі-моту',
 				'hr' => 'хорватська',
 				'hsb' => 'верхньолужицька',
 				'ht' => 'гаїтянська',
 				'hu' => 'угорська',
 				'hup' => 'хупа',
 				'hy' => 'вірменська',
 				'hz' => 'гереро',
 				'ia' => 'інтерлінгва',
 				'iba' => 'ібанська',
 				'ibb' => 'ібібіо',
 				'id' => 'індонезійська',
 				'ie' => 'інтерлінгве',
 				'ig' => 'ігбо',
 				'ii' => 'сичуань',
 				'ik' => 'інупіак',
 				'ilo' => 'ілоканська',
 				'inh' => 'інгуська',
 				'io' => 'ідо',
 				'is' => 'ісландська',
 				'it' => 'італійська',
 				'iu' => 'інуктітут',
 				'ja' => 'японська',
 				'jbo' => 'ложбан',
 				'jgo' => 'нгомба',
 				'jmc' => 'мачаме',
 				'jpr' => 'іудео-перська',
 				'jrb' => 'іудео-арабська',
 				'jv' => 'яванська',
 				'ka' => 'грузинська',
 				'kaa' => 'каракалпацька',
 				'kab' => 'кабільська',
 				'kac' => 'качін',
 				'kaj' => 'йю',
 				'kam' => 'камба',
 				'kaw' => 'каві',
 				'kbd' => 'кабардинська',
 				'kbl' => 'канембу',
 				'kcg' => 'тіап',
 				'kde' => 'маконде',
 				'kea' => 'кабувердіану',
 				'kfo' => 'коро',
 				'kg' => 'конґолезька',
 				'kha' => 'кхасі',
 				'kho' => 'хотаносакська',
 				'khq' => 'койра чіїні',
 				'ki' => 'кікуйю',
 				'kj' => 'кунама',
 				'kk' => 'казахська',
 				'kkj' => 'како',
 				'kl' => 'калааллісут',
 				'kln' => 'календжин',
 				'km' => 'кхмерська',
 				'kmb' => 'кімбунду',
 				'kn' => 'каннада',
 				'ko' => 'корейська',
 				'koi' => 'комі-перм’яцька',
 				'kok' => 'конкані',
 				'kos' => 'косрае',
 				'kpe' => 'кпеллє',
 				'kr' => 'канурі',
 				'krc' => 'карачаєво-балкарська',
 				'krl' => 'карельська',
 				'kru' => 'курукх',
 				'ks' => 'кашмірська',
 				'ksb' => 'шамбала',
 				'ksf' => 'бафіа',
 				'ksh' => 'колоніан',
 				'ku' => 'курдська',
 				'kum' => 'кумицька',
 				'kut' => 'кутенаї',
 				'kv' => 'комі',
 				'kw' => 'корнійська',
 				'ky' => 'киргизька',
 				'la' => 'латинська',
 				'lad' => 'ладіно',
 				'lag' => 'лангі',
 				'lah' => 'ланда',
 				'lam' => 'ламба',
 				'lb' => 'люксембурзька',
 				'lez' => 'лезгінська',
 				'lg' => 'ганда',
 				'li' => 'лімбургійська',
 				'lkt' => 'лакота',
 				'ln' => 'лінгала',
 				'lo' => 'лаоська',
 				'lol' => 'монго',
 				'loz' => 'лозі',
 				'lrc' => 'північна лурська',
 				'lt' => 'литовська',
 				'lu' => 'луба-катанга',
 				'lua' => 'луба-лулуа',
 				'lui' => 'луїсеньо',
 				'lun' => 'лунда',
 				'luo' => 'луо',
 				'lus' => 'лушей',
 				'luy' => 'луйя',
 				'lv' => 'латвійська',
 				'mad' => 'мадурська',
 				'maf' => 'мафа',
 				'mag' => 'магадхі',
 				'mai' => 'майтхілі',
 				'mak' => 'макасарська',
 				'man' => 'мандінго',
 				'mas' => 'масаї',
 				'mde' => 'маба',
 				'mdf' => 'мокша',
 				'mdr' => 'мандарська',
 				'men' => 'менде',
 				'mer' => 'меру',
 				'mfe' => 'маврикійська креольська',
 				'mg' => 'малагасійська',
 				'mga' => 'середньоірландська',
 				'mgh' => 'макува-меето',
 				'mgo' => 'мета',
 				'mh' => 'маршалльська',
 				'mi' => 'маорі',
 				'mic' => 'мікмак',
 				'min' => 'мінангкабау',
 				'mk' => 'македонська',
 				'ml' => 'малаялам',
 				'mn' => 'монгольська',
 				'mnc' => 'манчжурська',
 				'mni' => 'маніпурі',
 				'moh' => 'магавк',
 				'mos' => 'моссі',
 				'mr' => 'маратхі',
 				'ms' => 'малайська',
 				'mt' => 'мальтійська',
 				'mua' => 'мунданг',
 				'mul' => 'декілька мов',
 				'mus' => 'крік',
 				'mwl' => 'мірандська',
 				'mwr' => 'марварі',
 				'my' => 'бірманська',
 				'mye' => 'миін',
 				'myv' => 'ерзя',
 				'mzn' => 'мазандеранська',
 				'na' => 'науру',
 				'nap' => 'неаполітанська',
 				'naq' => 'нама',
 				'nb' => 'букмол (Норвегія)',
 				'nd' => 'ндебелє північна',
 				'nds' => 'нижньонімецька',
 				'nds_NL' => 'нижньосаксонська',
 				'ne' => 'непальська',
 				'new' => 'неварі',
 				'ng' => 'ндонга',
 				'nia' => 'ніаська',
 				'niu' => 'ніуе',
 				'njo' => 'ао нага',
 				'nl' => 'голландська',
 				'nl_BE' => 'фламандська',
 				'nmg' => 'квазіо',
 				'nn' => 'нюношк (Норвегія)',
 				'nnh' => 'нгємбун',
 				'no' => 'норвезька',
 				'nog' => 'ногайська',
 				'non' => 'давньонорвезька',
 				'nqo' => 'нко',
 				'nr' => 'ндебелє південна',
 				'nso' => 'сото північна',
 				'nus' => 'нуер',
 				'nv' => 'навахо',
 				'nwc' => 'неварі класична',
 				'ny' => 'ньянджа',
 				'nym' => 'ньямвезі',
 				'nyn' => 'ньянколе',
 				'nyo' => 'ньоро',
 				'nzi' => 'нзіма',
 				'oc' => 'окитан',
 				'oj' => 'оджібва',
 				'om' => 'оромо',
 				'or' => 'орія',
 				'os' => 'осетинська',
 				'osa' => 'осейдж',
 				'ota' => 'османська',
 				'pa' => 'панджабі',
 				'pag' => 'пангасінанська',
 				'pal' => 'пехлеві',
 				'pam' => 'пампанга',
 				'pap' => 'пап’яменто',
 				'pau' => 'палауанська',
 				'peo' => 'давньоперська',
 				'phn' => 'фінікійсько-пунічна',
 				'pi' => 'палі',
 				'pl' => 'польська',
 				'pon' => 'понапе',
 				'pro' => 'давньопровансальська',
 				'ps' => 'пушту',
 				'pt' => 'португальська',
 				'pt_PT' => 'португальська (Європа)',
 				'qu' => 'кечуа',
 				'quc' => 'кіче',
 				'raj' => 'раджастхані',
 				'rap' => 'рапануї',
 				'rar' => 'раротонга',
 				'rm' => 'ретороманська',
 				'rn' => 'рунді',
 				'ro' => 'румунська',
 				'ro_MD' => 'молдавська',
 				'rof' => 'ромбо',
 				'rom' => 'циганська',
 				'root' => 'корінь',
 				'ru' => 'російська',
 				'rup' => 'арумунська',
 				'rw' => 'кіньяруанда',
 				'rwk' => 'рва',
 				'sa' => 'санскрит',
 				'sad' => 'сандаве',
 				'sah' => 'якутська',
 				'sam' => 'самаритянська арамейська',
 				'saq' => 'самбуру',
 				'sas' => 'сасакська',
 				'sat' => 'сантальська',
 				'sba' => 'нгамбай',
 				'sbp' => 'сангу',
 				'sc' => 'сардинська',
 				'scn' => 'сицилійська',
 				'sco' => 'шотландська',
 				'sd' => 'сіндхі',
 				'sdh' => 'південнокурдська',
 				'se' => 'саамська північна',
 				'see' => 'сенека',
 				'seh' => 'сена',
 				'sel' => 'селькупська',
 				'ses' => 'койраборо сені',
 				'sg' => 'санго',
 				'sga' => 'давньоірландська',
 				'sh' => 'сербсько-хорватська',
 				'shi' => 'тачеліт',
 				'shn' => 'шанська',
 				'shu' => 'чадійська арабська',
 				'si' => 'сингальська',
 				'sid' => 'сідамо',
 				'sk' => 'словацька',
 				'sl' => 'словенська',
 				'sm' => 'самоанська',
 				'sma' => 'південносаамська',
 				'smj' => 'саамська луле',
 				'smn' => 'саамська інарі',
 				'sms' => 'саамська скольт',
 				'sn' => 'шона',
 				'snk' => 'сонінке',
 				'so' => 'сомалі',
 				'sog' => 'согдійська',
 				'sq' => 'албанська',
 				'sr' => 'сербська',
 				'srn' => 'сранан тонго',
 				'srr' => 'серер',
 				'ss' => 'сісваті',
 				'ssy' => 'сахо',
 				'st' => 'сото південна',
 				'su' => 'сунданська',
 				'suk' => 'сукума',
 				'sus' => 'сусу',
 				'sux' => 'шумерська',
 				'sv' => 'шведська',
 				'sw' => 'суахілі',
 				'swb' => 'коморська',
 				'swc' => 'конгійське суахілі',
 				'syc' => 'сирійська класична',
 				'syr' => 'сирійська',
 				'ta' => 'тамільська',
 				'te' => 'телугу',
 				'tem' => 'темне',
 				'teo' => 'тесо',
 				'ter' => 'терено',
 				'tet' => 'тетум',
 				'tg' => 'таджицька',
 				'th' => 'тайська',
 				'ti' => 'тигринья',
 				'tig' => 'тигре',
 				'tiv' => 'тів',
 				'tk' => 'туркменська',
 				'tkl' => 'токелау',
 				'tl' => 'тагальська',
 				'tlh' => 'клінгон',
 				'tli' => 'тлінгіт',
 				'tmh' => 'тамашек',
 				'tn' => 'тсвана',
 				'to' => 'тонганська',
 				'tog' => 'ньяса тонга',
 				'tpi' => 'ток-пісін',
 				'tr' => 'турецька',
 				'trv' => 'тароко',
 				'ts' => 'тсонга',
 				'tsi' => 'цимшиан',
 				'tt' => 'татарська',
 				'tum' => 'тумбука',
 				'tvl' => 'тувалу',
 				'tw' => 'тві',
 				'twq' => 'тасавак',
 				'ty' => 'таїтянська',
 				'tyv' => 'тувинська',
 				'tzm' => 'центральномароканська тамазіт',
 				'udm' => 'удмуртська',
 				'ug' => 'уйгурська',
 				'uga' => 'угаритська',
 				'uk' => 'українська',
 				'umb' => 'умбунду',
 				'und' => 'невідома мова',
 				'ur' => 'урду',
 				'uz' => 'узбецька',
 				'vai' => 'ваї',
 				've' => 'венда',
 				'vi' => 'вʼєтнамська',
 				'vo' => 'волап’юк',
 				'vot' => 'водська',
 				'vun' => 'вуньо',
 				'wa' => 'валлонська',
 				'wae' => 'валзерська',
 				'wal' => 'валамо',
 				'war' => 'варай',
 				'was' => 'вашо',
 				'wbp' => 'валпірі',
 				'wo' => 'волоф',
 				'xal' => 'калмицька',
 				'xh' => 'кхоса',
 				'xog' => 'сога',
 				'yao' => 'яо',
 				'yap' => 'яп',
 				'yav' => 'янгбен',
 				'ybb' => 'ємба',
 				'yi' => 'ідиш',
 				'yo' => 'йоруба',
 				'yue' => 'кантонська',
 				'za' => 'чжуан',
 				'zap' => 'сапотекська',
 				'zbl' => 'блісса мова',
 				'zen' => 'зенага',
 				'zgh' => 'стандартна марокканська берберська',
 				'zh' => 'китайська',
 				'zh_Hans' => 'китайська спрощена',
 				'zh_Hant' => 'китайська традиційна',
 				'zu' => 'зулуська',
 				'zun' => 'зуньї',
 				'zxx' => 'немає мовного вмісту',
 				'zza' => 'зазакі',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Afak' => 'афака',
 			'Aghb' => 'кавказька албанська',
 			'Ahom' => 'ахом',
 			'Arab' => 'арабиця',
 			'Arab@alt=variant' => 'персько-арабська',
 			'Armi' => 'Армі',
 			'Armn' => 'вірменська',
 			'Avst' => 'Авестійський',
 			'Bali' => 'Балійський',
 			'Bamu' => 'Бамум',
 			'Bass' => 'басса',
 			'Batk' => 'Батак',
 			'Beng' => 'бенгальська',
 			'Blis' => 'символи Блісса',
 			'Bopo' => 'бопомофо',
 			'Brah' => 'Брахмі',
 			'Brai' => 'шрифт Брайля',
 			'Bugi' => 'Бугійський',
 			'Buhd' => 'Бухід',
 			'Cakm' => 'Чакма',
 			'Cans' => 'уніфіковані символи канадських тубільців',
 			'Cari' => 'Каріанський',
 			'Cham' => 'Хамітський',
 			'Cher' => 'Черокі',
 			'Cirt' => 'Кирт',
 			'Copt' => 'Коптський',
 			'Cprt' => 'Кіпрський',
 			'Cyrl' => 'кирилиця',
 			'Cyrs' => 'Давньоцерковнословʼянський',
 			'Deva' => 'деванагарі',
 			'Dsrt' => 'Дезерет',
 			'Egyd' => 'Єгипетський демотичний',
 			'Egyh' => 'Єгипетський ієратичний',
 			'Egyp' => 'Єгипетський ієрогліфічний',
 			'Ethi' => 'ефіопська',
 			'Geok' => 'Кхутсурі',
 			'Geor' => 'грузинська',
 			'Glag' => 'Глаголичний',
 			'Goth' => 'Готичний',
 			'Grek' => 'грецька',
 			'Gujr' => 'гуджараті',
 			'Guru' => 'гурмухі',
 			'Hang' => 'хангиль',
 			'Hani' => 'китайська',
 			'Hano' => 'Хануну',
 			'Hans' => 'спрощена',
 			'Hans@alt=stand-alone' => 'китайська спрощена',
 			'Hant' => 'традиційна',
 			'Hant@alt=stand-alone' => 'китайська традиційна',
 			'Hebr' => 'іврит',
 			'Hira' => 'хірагана',
 			'Hmng' => 'Пахау хмонг',
 			'Hrkt' => 'Катакана чи хірагана',
 			'Hung' => 'Давньоугорський',
 			'Inds' => 'Харапський',
 			'Ital' => 'Давньоіталійський',
 			'Java' => 'Яванський',
 			'Jpan' => 'японська',
 			'Kali' => 'Кая Лі',
 			'Kana' => 'катакана',
 			'Khar' => 'Кхароштхі',
 			'Khmr' => 'кхмерська',
 			'Knda' => 'каннада',
 			'Kore' => 'корейська',
 			'Kthi' => 'Каїті',
 			'Lana' => 'Ланна',
 			'Laoo' => 'лаоська',
 			'Latf' => 'Латинський фрактурний',
 			'Latg' => 'Латинський гельський',
 			'Latn' => 'латиниця',
 			'Lepc' => 'Лепча',
 			'Limb' => 'Лімбу',
 			'Lina' => 'Лінійний А',
 			'Linb' => 'Лінійний В',
 			'Lisu' => 'абетка Фрейзера',
 			'Loma' => 'лома',
 			'Lyci' => 'Лікійський',
 			'Lydi' => 'Лідійський',
 			'Mand' => 'Мандейський',
 			'Mani' => 'Маніхейський',
 			'Maya' => 'Майя ієрогліфічний',
 			'Mero' => 'Мероїтський',
 			'Mlym' => 'малаяламська',
 			'Mong' => 'монгольська',
 			'Moon' => 'Мун',
 			'Mtei' => 'Мейтей майєк',
 			'Mymr' => 'мʼянмська',
 			'Nkoo' => 'Нко',
 			'Ogam' => 'Огамічний',
 			'Olck' => 'Сантальський',
 			'Orkh' => 'Орхонський',
 			'Orya' => 'орія',
 			'Osma' => 'Османський',
 			'Perm' => 'Давньопермський',
 			'Phag' => 'Пхагс-па',
 			'Phli' => 'Пехлеві написів',
 			'Phlp' => 'Пехлеві релігійний',
 			'Phlv' => 'Пехлеві літературний',
 			'Phnx' => 'Фінікійський',
 			'Plrd' => 'писемність Полларда',
 			'Prti' => 'Парфянський',
 			'Rjng' => 'Реджанг',
 			'Roro' => 'Ронго-ронго',
 			'Runr' => 'Рунічний',
 			'Samr' => 'Самаритянський',
 			'Sara' => 'Сараті',
 			'Saur' => 'Саураштра',
 			'Sgnw' => 'Знаковий',
 			'Shaw' => 'Шоу',
 			'Sinh' => 'сингальська',
 			'Sund' => 'Сунданський',
 			'Sylo' => 'Сілоті нагрі',
 			'Syrc' => 'Сирійський',
 			'Syre' => 'Давньосирійський естрангело',
 			'Syrj' => 'Давньосирійський західний',
 			'Syrn' => 'Давньосирійський східний',
 			'Tagb' => 'Тагбанва',
 			'Tale' => 'Тай-лі',
 			'Talu' => 'Новий тайський луе',
 			'Taml' => 'тамільська',
 			'Tang' => 'тангут',
 			'Tavt' => 'Тай-вʼєт',
 			'Telu' => 'телугу',
 			'Teng' => 'Тенгвар',
 			'Tfng' => 'Тифінаг',
 			'Tglg' => 'Тагальський',
 			'Thaa' => 'таана',
 			'Thai' => 'тайська',
 			'Tibt' => 'тибетська',
 			'Ugar' => 'Угаритський',
 			'Vaii' => 'Ваї',
 			'Visp' => 'видиме мовлення',
 			'Xpeo' => 'Давньоперський',
 			'Xsux' => 'Шумеро-аккадський клінопис',
 			'Yiii' => 'Йї',
 			'Zinh' => 'успадкована',
 			'Zmth' => 'математична',
 			'Zsym' => 'символьна',
 			'Zxxx' => 'безписемна',
 			'Zyyy' => 'звичайна',
 			'Zzzz' => 'невідома система письма',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Світ',
 			'002' => 'Африка',
 			'003' => 'Північна Америка',
 			'005' => 'Південна Америка',
 			'009' => 'Океанія',
 			'011' => 'Західна Африка',
 			'013' => 'Центральна Америка',
 			'014' => 'Східна Африка',
 			'015' => 'Північна Африка',
 			'017' => 'Центральна Африка',
 			'018' => 'Південна Африка',
 			'019' => 'Америка',
 			'021' => 'Північна Америка (регіон)',
 			'029' => 'Карибський басейн',
 			'030' => 'Східна Азія',
 			'034' => 'Південна Азія',
 			'035' => 'Південно-Східна Азія',
 			'039' => 'Південна Європа',
 			'053' => 'Австралазія',
 			'054' => 'Меланезія',
 			'057' => 'Мікронезійський регіон',
 			'061' => 'Полінезія',
 			'142' => 'Азія',
 			'143' => 'Центральна Азія',
 			'145' => 'Західна Азія',
 			'150' => 'Європа',
 			'151' => 'Східна Європа',
 			'154' => 'Північна Європа',
 			'155' => 'Західна Європа',
 			'419' => 'Латинська Америка',
 			'AC' => 'Острів Вознесіння',
 			'AD' => 'Андорра',
 			'AE' => 'Обʼєднані Арабські Емірати',
 			'AF' => 'Афганістан',
 			'AG' => 'Антигуа і Барбуда',
 			'AI' => 'Ангілья',
 			'AL' => 'Албанія',
 			'AM' => 'Вірменія',
 			'AN' => 'Нідерландські Антильські Острови',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктика',
 			'AR' => 'Аргентина',
 			'AS' => 'Американське Самоа',
 			'AT' => 'Австрія',
 			'AU' => 'Австралія',
 			'AW' => 'Аруба',
 			'AX' => 'Аландські острови',
 			'AZ' => 'Азербайджан',
 			'BA' => 'Боснія і Герцоговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Бельгія',
 			'BF' => 'Буркіна-Фасо',
 			'BG' => 'Болгарія',
 			'BH' => 'Бахрейн',
 			'BI' => 'Бурунді',
 			'BJ' => 'Бенін',
 			'BL' => 'Сен-Бартельмі',
 			'BM' => 'Бермудські острови',
 			'BN' => 'Бруней',
 			'BO' => 'Болівія',
 			'BQ' => 'Нідерландські Карибські острови',
 			'BR' => 'Бразилія',
 			'BS' => 'Багамські Острови',
 			'BT' => 'Бутан',
 			'BV' => 'Острів Буве',
 			'BW' => 'Ботсвана',
 			'BY' => 'Білорусь',
 			'BZ' => 'Беліз',
 			'CA' => 'Канада',
 			'CC' => 'Кокосові (Кілінгові) острови',
 			'CD' => 'Конго – Кіншаса',
 			'CD@alt=variant' => 'Конго (ДРК)',
 			'CF' => 'Центральноафриканська Республіка',
 			'CG' => 'Конго – Браззавіль',
 			'CG@alt=variant' => 'Конго (Республіка)',
 			'CH' => 'Швейцарія',
 			'CI' => 'Кот-д’Івуар',
 			'CI@alt=variant' => 'Берег Слонової Кістки',
 			'CK' => 'Острови Кука',
 			'CL' => 'Чилі',
 			'CM' => 'Камерун',
 			'CN' => 'Китай',
 			'CO' => 'Колумбія',
 			'CP' => 'Острів Кліппертон',
 			'CR' => 'Коста-Рика',
 			'CU' => 'Куба',
 			'CV' => 'Кабо Верде',
 			'CW' => 'Кюрасао',
 			'CX' => 'Острів Різдва',
 			'CY' => 'Кіпр',
 			'CZ' => 'Чехія',
 			'DE' => 'Німеччина',
 			'DG' => 'Дієго-Гарсія',
 			'DJ' => 'Джибуті',
 			'DK' => 'Данія',
 			'DM' => 'Домініка',
 			'DO' => 'Домініканська Республіка',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута і Мелілья',
 			'EC' => 'Еквадор',
 			'EE' => 'Естонія',
 			'EG' => 'Єгипет',
 			'EH' => 'Західна Сахара',
 			'ER' => 'Еритрея',
 			'ES' => 'Іспанія',
 			'ET' => 'Ефіопія',
 			'EU' => 'Європейський Союз',
 			'FI' => 'Фінляндія',
 			'FJ' => 'Фіджі',
 			'FK' => 'Фолклендські острови',
 			'FK@alt=variant' => 'Фолклендські (Мальвінські) острови',
 			'FM' => 'Мікронезія',
 			'FM@alt=variant' => 'Федеративні Штати Мікронезії',
 			'FO' => 'Фарерські острови',
 			'FR' => 'Франція',
 			'GA' => 'Габон',
 			'GB' => 'Велика Британія',
 			'GB@alt=short' => 'Велика Британія',
 			'GD' => 'Гренада',
 			'GE' => 'Грузія',
 			'GF' => 'Французька Гвіана',
 			'GG' => 'Гернсі',
 			'GH' => 'Гана',
 			'GI' => 'Гібралтар',
 			'GL' => 'Гренландія',
 			'GM' => 'Гамбія',
 			'GN' => 'Гвінея',
 			'GP' => 'Гваделупа',
 			'GQ' => 'Екваторіальна Гвінея',
 			'GR' => 'Греція',
 			'GS' => 'Південна Джорджія та Південні Сандвічеві острови',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвінея-Бісау',
 			'GY' => 'Гаяна',
 			'HK' => 'Гонконг, О.А.Р. Китаю',
 			'HK@alt=short' => 'Гонконг',
 			'HM' => 'Острови Херд і Мак-Дональд',
 			'HN' => 'Гондурас',
 			'HR' => 'Хорватія',
 			'HT' => 'Гаїті',
 			'HU' => 'Угорщина',
 			'IC' => 'Канарські острови',
 			'ID' => 'Індонезія',
 			'IE' => 'Ірландія',
 			'IL' => 'Ізраїль',
 			'IM' => 'Острів Мен',
 			'IN' => 'Індія',
 			'IO' => 'Британські території в Індійському океані',
 			'IQ' => 'Ірак',
 			'IR' => 'Іран',
 			'IS' => 'Ісландія',
 			'IT' => 'Італія',
 			'JE' => 'Джерсі',
 			'JM' => 'Ямайка',
 			'JO' => 'Йорданія',
 			'JP' => 'Японія',
 			'KE' => 'Кенія',
 			'KG' => 'Киргизстан',
 			'KH' => 'Камбоджа',
 			'KI' => 'Кірибаті',
 			'KM' => 'Коморські острови',
 			'KN' => 'Сент-Кітс і Невіс',
 			'KP' => 'Північна Корея',
 			'KR' => 'Південна Корея',
 			'KW' => 'Кувейт',
 			'KY' => 'Кайманові острови',
 			'KZ' => 'Казахстан',
 			'LA' => 'Лаос',
 			'LB' => 'Ліван',
 			'LC' => 'Сент-Люсія',
 			'LI' => 'Ліхтенштейн',
 			'LK' => 'Шрі-Ланка',
 			'LR' => 'Ліберія',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Люксембург',
 			'LV' => 'Латвія',
 			'LY' => 'Лівія',
 			'MA' => 'Марокко',
 			'MC' => 'Монако',
 			'MD' => 'Молдова',
 			'ME' => 'Чорногорія',
 			'MF' => 'Сен-Мартен',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршаллові Острови',
 			'MK' => 'Македонія',
 			'MK@alt=variant' => 'Македонія (КЮРМ)',
 			'ML' => 'Малі',
 			'MM' => 'Мʼянма (Бірма)',
 			'MN' => 'Монголія',
 			'MO' => 'Макао, О.А.Р Китаю',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Північні Маріанські острови',
 			'MQ' => 'Мартиніка',
 			'MR' => 'Мавританія',
 			'MS' => 'Монтсеррат',
 			'MT' => 'Мальта',
 			'MU' => 'Маврикій',
 			'MV' => 'Мальдіви',
 			'MW' => 'Малаві',
 			'MX' => 'Мексика',
 			'MY' => 'Малайзія',
 			'MZ' => 'Мозамбік',
 			'NA' => 'Намібія',
 			'NC' => 'Нова Каледонія',
 			'NE' => 'Нігер',
 			'NF' => 'Острів Норфолк',
 			'NG' => 'Нігерія',
 			'NI' => 'Нікарагуа',
 			'NL' => 'Нідерланди',
 			'NO' => 'Норвегія',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ніуе',
 			'NZ' => 'Нова Зеландія',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Французька Полінезія',
 			'PG' => 'Папуа Нова Гвінея',
 			'PH' => 'Філіппіни',
 			'PK' => 'Пакистан',
 			'PL' => 'Польща',
 			'PM' => 'Сен-Пʼєр і Мікелон',
 			'PN' => 'Острови Піткерн',
 			'PR' => 'Пуерто-Рико',
 			'PS' => 'Палестинські території',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португалія',
 			'PW' => 'Палау',
 			'PY' => 'Парагвай',
 			'QA' => 'Катар',
 			'QO' => 'Віддалені острови Океанії',
 			'RE' => 'Реюньйон',
 			'RO' => 'Румунія',
 			'RS' => 'Сербія',
 			'RU' => 'Росія',
 			'RW' => 'Руанда',
 			'SA' => 'Саудівська Аравія',
 			'SB' => 'Соломонові Острови',
 			'SC' => 'Сейшельські острови',
 			'SD' => 'Судан',
 			'SE' => 'Швеція',
 			'SG' => 'Сінгапур',
 			'SH' => 'Острів Святої Єлени',
 			'SI' => 'Словенія',
 			'SJ' => 'Острови Свальбард і Ян-Маєн',
 			'SK' => 'Словаччина',
 			'SL' => 'Сьєрра-Леоне',
 			'SM' => 'Сан-Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомалі',
 			'SR' => 'Суринам',
 			'SS' => 'Південний Судан',
 			'ST' => 'Сан-Томе і Прінсіпі',
 			'SV' => 'Сальвадор',
 			'SX' => 'Сінт-Мартен',
 			'SY' => 'Сирія',
 			'SZ' => 'Свазіленд',
 			'TA' => 'Трістан-да-Кунья',
 			'TC' => 'Острови Теркс і Кайкос',
 			'TD' => 'Чад',
 			'TF' => 'Французькі Південні Території',
 			'TG' => 'Того',
 			'TH' => 'Таїланд',
 			'TJ' => 'Таджикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Тимор-Лешті',
 			'TL@alt=variant' => 'Східний Тимор',
 			'TM' => 'Туркменістан',
 			'TN' => 'Туніс',
 			'TO' => 'Тонга',
 			'TR' => 'Туреччина',
 			'TT' => 'Тринідад і Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тайвань',
 			'TZ' => 'Танзанія',
 			'UA' => 'Україна',
 			'UG' => 'Уганда',
 			'UM' => 'Віддалені острови США',
 			'US' => 'США',
 			'US@alt=short' => 'США',
 			'UY' => 'Уругвай',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент-Вінсент і Гренадини',
 			'VE' => 'Венесуела',
 			'VG' => 'Британські Віргінські острови',
 			'VI' => 'Віргінські острови, США',
 			'VN' => 'Вʼєтнам',
 			'VU' => 'Вануату',
 			'WF' => 'Волліс і Футуна',
 			'WS' => 'Самоа',
 			'XK' => 'Косово',
 			'YE' => 'Ємен',
 			'YT' => 'Майотта',
 			'ZA' => 'Південно-Африканська Республіка',
 			'ZM' => 'Замбія',
 			'ZW' => 'Зімбабве',
 			'ZZ' => 'Невідомий регіон',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'Традиційна німецька орфографія',
 			'1994' => 'Стандартизована резьянська орфографія',
 			'1996' => 'Нова німецька орфографія з 1996 р.',
 			'1606NICT' => 'Пізньосередньофранцузська до 1606',
 			'1694ACAD' => 'Класична французька',
 			'1959ACAD' => 'Академічний',
 			'AREVELA' => 'Східновірменський',
 			'AREVMDA' => 'Західновірменський',
 			'BAKU1926' => 'Уніфікований турецький латинський алфавіт',
 			'BISKE' => 'Діалект Сан-Джорджіо/Біла',
 			'BOONT' => 'Бунтлінг',
 			'FONIPA' => 'Міжнародний фонетичний алфавіт',
 			'FONUPA' => 'Уральський фонетичний алфавіт',
 			'KKCOR' => 'Загальна орфографія',
 			'LIPAW' => 'Ліповазський діалект резьянської мови',
 			'MONOTON' => 'Монотонічний',
 			'NEDIS' => 'Натісонський діалект',
 			'NJIVA' => 'Діалект Нджіва',
 			'OSOJS' => 'Осоянський діалект',
 			'PINYIN' => 'Романізація піньїн',
 			'POLYTON' => 'Політонічний',
 			'POSIX' => 'Компʼютерний',
 			'REVISED' => 'Нова орфографія',
 			'ROZAJ' => 'Резьянський',
 			'SAAHO' => 'Сахо',
 			'SCOTLAND' => 'Шотландська англійська',
 			'SCOUSE' => 'Ліверпульський діалект',
 			'SOLBA' => 'Діалект Столвіца/Солбіка',
 			'TARASK' => 'Орфографія Тараскевича',
 			'UCCOR' => 'Уніфікована орфографія',
 			'UCRCOR' => 'Уніфікована переглянута орфографія',
 			'VALENCIA' => 'Валенсійська',
 			'WADEGILE' => 'Романізація Вейда-Джайлза',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'календар',
 			'colalternate' => 'ігнорувати сортування за символами',
 			'colbackwards' => 'зворотне сортування за діакритичними знаками',
 			'colcasefirst' => 'порядок верхнього/нижнього регістру',
 			'colcaselevel' => 'сортування з урахуванням регістру',
 			'colhiraganaquaternary' => 'сортування кана',
 			'collation' => 'порядок сортування',
 			'colnormalization' => 'уніфіковане сортування',
 			'colnumeric' => 'цифрове сортування',
 			'colstrength' => 'інтенсивність сортування',
 			'currency' => 'валюта',
 			'hc' => 'формат часу (12 або 24 години)',
 			'lb' => 'стиль розриву рядка',
 			'ms' => 'система вимірювання',
 			'numbers' => 'цифри',
 			'timezone' => 'часовий пояс',
 			'va' => 'варіант мовного коду',
 			'variabletop' => 'сортувати як символи',
 			'x' => 'особисте використання',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{буддійський календар},
 				'chinese' => q{китайський календар},
 				'coptic' => q{коптський календар},
 				'dangi' => q{календар дангі},
 				'ethiopic' => q{ефіопський календар},
 				'ethiopic-amete-alem' => q{ефіопський амете алем календар},
 				'gregorian' => q{григоріанський календар},
 				'hebrew' => q{єврейський календар},
 				'indian' => q{індійський світський календар},
 				'islamic' => q{мусульманський календар},
 				'islamic-civil' => q{мусульманський світський календар},
 				'iso8601' => q{календар ISO-8601},
 				'japanese' => q{японський календар},
 				'persian' => q{перський календар},
 				'roc' => q{китайський григоріанський календар},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{сортувати за символами},
 				'shifted' => q{сортувати, ігноруючи символи},
 			},
 			'colbackwards' => {
 				'no' => q{сортувати за діакритичними знаками уніфіковано},
 				'yes' => q{сортувати за діактричними знаками у зворотньому порядку},
 			},
 			'colcasefirst' => {
 				'lower' => q{сортувати нижній регістр наперед},
 				'no' => q{сортувати в порядку звичайного регістру},
 				'upper' => q{сортувати спершу за великими символами},
 			},
 			'colcaselevel' => {
 				'no' => q{сортувати без урахування регістру},
 				'yes' => q{сортувати з урахуванням регістру},
 			},
 			'colhiraganaquaternary' => {
 				'no' => q{сортувати кана окремо},
 				'yes' => q{сортувати за кана інакше},
 			},
 			'collation' => {
 				'big5han' => q{китайський традиційний порядок сортування Big5},
 				'compat' => q{попередній порядок сортування, для сумісності},
 				'dictionary' => q{порядок сортування за словником},
 				'ducet' => q{типовий порядок сортування Unicode},
 				'emoji' => q{порядок сортування за емодзі},
 				'eor' => q{європейські правила упорядкування},
 				'gb2312han' => q{китайський спрощений},
 				'phonebook' => q{порядок сортування за телефонним довідником},
 				'phonetic' => q{фонетичний порядок сортування},
 				'pinyin' => q{порядок сортування піньїнь},
 				'reformed' => q{реформований порядок сортування},
 				'search' => q{універсальний пошук},
 				'searchjl' => q{пошук за початковою приголосною хангул},
 				'standard' => q{стандартний порядок сортування},
 				'stroke' => q{порядок сортування за рисками},
 				'traditional' => q{традиційний порядок сортування},
 				'unihan' => q{порядок сортування за ключами ієрогліфів},
 				'zhuyin' => q{порядок сортування чжуїнь},
 			},
 			'colnormalization' => {
 				'no' => q{сортувати без уніфікації},
 				'yes' => q{сортувати за Unicode уніфіковано},
 			},
 			'colnumeric' => {
 				'no' => q{сортувати цифри окремо},
 				'yes' => q{сортувати за цифрами чисельно},
 			},
 			'colstrength' => {
 				'identical' => q{сортувати всі},
 				'primary' => q{сортувати лише за основними літерами},
 				'quaternary' => q{сортувати за діактричними знаками/регістром/шириною/кана},
 				'secondary' => q{сортувати за діактричними знаками},
 				'tertiary' => q{сортувати за діактричними знаками/регістром/шириною},
 			},
 			'hc' => {
 				'h11' => q{12-годинний формат (0–11)},
 				'h12' => q{12-годинний формат (1–12)},
 				'h23' => q{24-годинний формат (0–23)},
 				'h24' => q{24-годинний формат (1–24)},
 			},
 			'lb' => {
 				'loose' => q{вільний стиль розриву рядка},
 				'normal' => q{типовий стиль розриву рядка},
 				'strict' => q{строгий стиль розриву рядка},
 			},
 			'ms' => {
 				'metric' => q{мертична система},
 				'uksystem' => q{англійська система мір},
 				'ussystem' => q{американська система мір},
 			},
 			'numbers' => {
 				'arab' => q{арабсько-індійські цифри},
 				'arabext' => q{арабсько-індійські розширені цифри},
 				'armn' => q{вірменські цифри},
 				'armnlow' => q{вірменські малі цифри},
 				'beng' => q{бенгальські цифри},
 				'deva' => q{цифри деванагарі},
 				'ethi' => q{ефіопські цифри},
 				'finance' => q{фінансові символи чисел},
 				'fullwide' => q{цифри повної ширини},
 				'geor' => q{грузинські цифри},
 				'grek' => q{грецькі цифри},
 				'greklow' => q{грецькі малі цифри},
 				'gujr' => q{цифри гуджараті},
 				'guru' => q{цифри гурмукхі},
 				'hanidec' => q{китайські десяткові цифри},
 				'hans' => q{китайські символи чисел (спрощене письмо)},
 				'hansfin' => q{китайські фінансові символи чисел (спрощене письмо)},
 				'hant' => q{китайські символи чисел (традиційне письмо)},
 				'hantfin' => q{китайські фінансові символи чисел (традиційне письмо)},
 				'hebr' => q{цифри івриту},
 				'jpan' => q{японські цифри},
 				'jpanfin' => q{японські фінансові цифри},
 				'khmr' => q{кхмерські цифри},
 				'knda' => q{цифри каннада},
 				'laoo' => q{лаоські цифри},
 				'latn' => q{західні цифри},
 				'mlym' => q{малаяламські цифри},
 				'mong' => q{монгольські цифри},
 				'mymr' => q{м’янмські цифри},
 				'native' => q{місцеві цифри},
 				'orya' => q{цифри орія},
 				'roman' => q{римські цифри},
 				'romanlow' => q{римські малі цифри},
 				'taml' => q{тамільські традиційні цифри},
 				'tamldec' => q{тамільські цифри},
 				'telu' => q{цифри телугу},
 				'thai' => q{тайські цифри},
 				'tibt' => q{тибетські цифри},
 				'traditional' => q{традиційні символи чисел},
 				'vaii' => q{цифри ваї},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{Метрична},
 			'UK' => q{Британська},
 			'US' => q{Американська},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'BGN',
 			'numeric' => 'Цифри',
 			'tone' => 'Тон',
 			'ungegn' => 'UNGEGN',
 			'x-accents' => 'Діактричні знаки',
 			'x-fullwidth' => 'Повна ширина',
 			'x-halfwidth' => 'Половинна ширина',
 			'x-jamo' => 'Jamo',
 			'x-pinyin' => 'Піньїнь',
 			'x-publishing' => 'Публікація',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'Мова: {0}',
 			'script' => 'Система письма: {0}',
 			'region' => 'Територія: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[{а́} {е́} ё {є́} {и́} {і́} {ї́} {о́} {у́} ъ ы э {ю́} {я́}])},
			index => ['А', 'Б', 'В', 'Г', 'Ґ', 'Д', 'Е', 'Є', 'Ж', 'З', 'И', 'І', 'Ї', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ю', 'Я'],
			main => qr{(?^u:[а б в г ґ д е є ж з и і ї й к л м н о п р с т у ф х ц ч ш щ ь ю я ʼ])},
			punctuation => qr{(?^u:[\- – , ; \: ! ? . ' " “ „ « » ( ) \[ \] \{ \} § @ * / \\ №])},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Ґ', 'Д', 'Е', 'Є', 'Ж', 'З', 'И', 'І', 'Ї', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ю', 'Я'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0}…',
			'word-initial' => '…{0}',
			'word-medial' => '{0}…{1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{«},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{»},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{„},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'few' => q({0} акри),
						'many' => q({0} акрів),
						'name' => q(акри),
						'one' => q({0} акр),
						'other' => q({0} акра),
					},
					'acre-foot' => {
						'few' => q({0} акр-фути),
						'many' => q({0} акр-футів),
						'name' => q(акр-фути),
						'one' => q({0} акр-фут),
						'other' => q({0} акр-фута),
					},
					'ampere' => {
						'few' => q({0} ампери),
						'many' => q({0} амперів),
						'name' => q(ампери),
						'one' => q({0} ампер),
						'other' => q({0} ампера),
					},
					'arc-minute' => {
						'few' => q({0} мінути),
						'many' => q({0} мінут),
						'name' => q(мінути),
						'one' => q({0} мінута),
						'other' => q({0} мінути),
					},
					'arc-second' => {
						'few' => q({0} кутові секунди),
						'many' => q({0} кутових секунд),
						'name' => q(кутові секунди),
						'one' => q({0} кутова секунда),
						'other' => q({0} кутової секунди),
					},
					'astronomical-unit' => {
						'few' => q({0} астрономічні одиниці),
						'many' => q({0} астрономічних одиниць),
						'name' => q(астрономічні одиниці),
						'one' => q({0} астрономічна одиниця),
						'other' => q({0} астрономічної одиниці),
					},
					'bit' => {
						'few' => q({0} біти),
						'many' => q({0} бітів),
						'name' => q(біти),
						'one' => q({0} біт),
						'other' => q({0} біта),
					},
					'byte' => {
						'few' => q({0} байти),
						'many' => q({0} байтів),
						'name' => q(байти),
						'one' => q({0} байт),
						'other' => q({0} байта),
					},
					'calorie' => {
						'few' => q({0} калорії),
						'many' => q({0} калорій),
						'name' => q(калорії),
						'one' => q({0} калорія),
						'other' => q({0} калорії),
					},
					'carat' => {
						'few' => q({0} карати),
						'many' => q({0} каратів),
						'name' => q(карати),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					'celsius' => {
						'few' => q({0} градуси Цельсія),
						'many' => q({0} градусів Цельсія),
						'name' => q(градуси Цельсія),
						'one' => q({0} градус Цельсія),
						'other' => q({0} градуса Цельсія),
					},
					'centiliter' => {
						'few' => q({0} сантилітри),
						'many' => q({0} сантилітрів),
						'name' => q(сантилітри),
						'one' => q({0} сантилітр),
						'other' => q({0} сантилітра),
					},
					'centimeter' => {
						'few' => q({0} сантиметри),
						'many' => q({0} сантиметрів),
						'name' => q(сантиметри),
						'one' => q({0} сантиметр),
						'other' => q({0} сантиметра),
						'per' => q({0} на сантиметр),
					},
					'century' => {
						'few' => q({0} століття),
						'many' => q({0} століть),
						'name' => q(століття),
						'one' => q({0} століття),
						'other' => q({0} століття),
					},
					'coordinate' => {
						'east' => q({0} на Схід),
						'north' => q({0} на Північ),
						'south' => q({0} на Південь),
						'west' => q({0} на Захід),
					},
					'cubic-centimeter' => {
						'few' => q({0} кубічні сантиметри),
						'many' => q({0} кубічних сантиметрів),
						'name' => q(кубічні сантиметри),
						'one' => q({0} кубічний сантиметр),
						'other' => q({0} кубічного сантиметра),
						'per' => q({0} на кубічний сантиметр),
					},
					'cubic-foot' => {
						'few' => q({0} кубічні фути),
						'many' => q({0} кубічних футів),
						'name' => q(кубічні фути),
						'one' => q({0} кубічний фут),
						'other' => q({0} кубічного фута),
					},
					'cubic-inch' => {
						'few' => q({0} кубічні дюйми),
						'many' => q({0} кубічних дюймів),
						'name' => q(кубічні дюйми),
						'one' => q({0} кубічний дюйм),
						'other' => q({0} кубічного дюйма),
					},
					'cubic-kilometer' => {
						'few' => q({0} кубічні кілометри),
						'many' => q({0} кубічних кілометрів),
						'name' => q(кубічні кілометри),
						'one' => q({0} кубічний кілометр),
						'other' => q({0} кубічного кілометра),
					},
					'cubic-meter' => {
						'few' => q({0} кубічні метри),
						'many' => q({0} кубічних метрів),
						'name' => q(кубічні метри),
						'one' => q({0} кубічний метр),
						'other' => q({0} кубічного метра),
						'per' => q({0} на кубічний метр),
					},
					'cubic-mile' => {
						'few' => q({0} кубічні милі),
						'many' => q({0} кубічних миль),
						'name' => q(кубічні милі),
						'one' => q({0} кубічна миля),
						'other' => q({0} кубічної милі),
					},
					'cubic-yard' => {
						'few' => q({0} кубічні ярди),
						'many' => q({0} кубічних ярдів),
						'name' => q(кубічні ярди),
						'one' => q({0} кубічний ярд),
						'other' => q({0} кубічного ярда),
					},
					'cup' => {
						'few' => q({0} склянки),
						'many' => q({0} склянок),
						'name' => q(склянки),
						'one' => q({0} склянка),
						'other' => q({0} склянки),
					},
					'cup-metric' => {
						'few' => q({0} метричні склянки),
						'many' => q({0} метричних склянок),
						'name' => q(метричні склянки),
						'one' => q({0} метрична склянка),
						'other' => q({0} метричної склянки),
					},
					'day' => {
						'few' => q({0} дні),
						'many' => q({0} днів),
						'name' => q(дні),
						'one' => q({0} день),
						'other' => q({0} дня),
						'per' => q({0} на день),
					},
					'deciliter' => {
						'few' => q({0} децилітри),
						'many' => q({0} децилітрів),
						'name' => q(децилітри),
						'one' => q({0} децилітр),
						'other' => q({0} децилітра),
					},
					'decimeter' => {
						'few' => q({0} дециметри),
						'many' => q({0} дециметрів),
						'name' => q(дециметри),
						'one' => q({0} дециметр),
						'other' => q({0} дециметра),
					},
					'degree' => {
						'few' => q({0} градуси),
						'many' => q({0} градусів),
						'name' => q(градуси),
						'one' => q({0} градус),
						'other' => q({0} градуса),
					},
					'fahrenheit' => {
						'few' => q({0} градуси Фаренгейта),
						'many' => q({0} градусів Фаренгейта),
						'name' => q(градуси Фаренгейта),
						'one' => q({0} градус Фаренгейта),
						'other' => q({0} градуса Фаренгейта),
					},
					'fluid-ounce' => {
						'few' => q({0} рідкі унції),
						'many' => q({0} рідких унцій),
						'name' => q(рідкі унції),
						'one' => q({0} рідка унція),
						'other' => q({0} рідкої унції),
					},
					'foodcalorie' => {
						'few' => q({0} Калорії),
						'many' => q({0} Калорій),
						'name' => q(Калорії),
						'one' => q({0} Калорія),
						'other' => q({0} Калорії),
					},
					'foot' => {
						'few' => q({0} фути),
						'many' => q({0} футів),
						'name' => q(фути),
						'one' => q({0} фут),
						'other' => q({0} фута),
						'per' => q({0} на фут),
					},
					'g-force' => {
						'few' => q({0} сили тяжіння),
						'many' => q({0} сил тяжіння),
						'name' => q(сили тяжіння),
						'one' => q({0} сила тяжіння),
						'other' => q({0} сили тяжіння),
					},
					'gallon' => {
						'few' => q({0} галони),
						'many' => q({0} галонів),
						'name' => q(галони),
						'one' => q({0} галон),
						'other' => q({0} галона),
						'per' => q({0} на галон),
					},
					'generic' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'few' => q({0} гігабіти),
						'many' => q({0} гігабітів),
						'name' => q(гігабіти),
						'one' => q({0} гігабіт),
						'other' => q({0} гігабіта),
					},
					'gigabyte' => {
						'few' => q({0} гігабайти),
						'many' => q({0} гігабайтів),
						'name' => q(гігабайти),
						'one' => q({0} гігабайт),
						'other' => q({0} гігабайта),
					},
					'gigahertz' => {
						'few' => q({0} гігагерци),
						'many' => q({0} гігагерців),
						'name' => q(гігагерци),
						'one' => q({0} гігагерц),
						'other' => q({0} гігагерца),
					},
					'gigawatt' => {
						'few' => q({0} гігавати),
						'many' => q({0} гігаватів),
						'name' => q(гігавати),
						'one' => q({0} гігават),
						'other' => q({0} гігавата),
					},
					'gram' => {
						'few' => q({0} грами),
						'many' => q({0} грамів),
						'name' => q(грами),
						'one' => q({0} грам),
						'other' => q({0} грама),
						'per' => q({0} на грам),
					},
					'hectare' => {
						'few' => q({0} гектари),
						'many' => q({0} гектарів),
						'name' => q(гектари),
						'one' => q({0} гектар),
						'other' => q({0} гектара),
					},
					'hectoliter' => {
						'few' => q({0} гектолітри),
						'many' => q({0} гектолітрів),
						'name' => q(гектолітри),
						'one' => q({0} гектолітр),
						'other' => q({0} гектолітра),
					},
					'hectopascal' => {
						'few' => q({0} гектопаскалі),
						'many' => q({0} гектопаскалів),
						'name' => q(гектопаскалі),
						'one' => q({0} гектопаскаль),
						'other' => q({0} гектопаскаля),
					},
					'hertz' => {
						'few' => q({0} герци),
						'many' => q({0} герців),
						'name' => q(герци),
						'one' => q({0} герц),
						'other' => q({0} герца),
					},
					'horsepower' => {
						'few' => q({0} кінські сили),
						'many' => q({0} кінських сил),
						'name' => q(кінські сили),
						'one' => q({0} кінська сила),
						'other' => q({0} кінської сили),
					},
					'hour' => {
						'few' => q({0} години),
						'many' => q({0} годин),
						'name' => q(години),
						'one' => q({0} година),
						'other' => q({0} години),
						'per' => q({0} на годину),
					},
					'inch' => {
						'few' => q({0} дюйми),
						'many' => q({0} дюймів),
						'name' => q(дюйми),
						'one' => q({0} дюйм),
						'other' => q({0} дюйма),
						'per' => q({0} на дюйм),
					},
					'inch-hg' => {
						'few' => q({0} дюйми ртутного стовпа),
						'many' => q({0} дюймів ртутного стовпа),
						'name' => q(дюйми ртутного стовпа),
						'one' => q({0} дюйм ртутного стовпа),
						'other' => q({0} дюйма ртутного стовпа),
					},
					'joule' => {
						'few' => q({0} джоулі),
						'many' => q({0} джоулів),
						'name' => q(джоулі),
						'one' => q({0} джоуль),
						'other' => q({0} джоуля),
					},
					'karat' => {
						'few' => q({0} карати),
						'many' => q({0} каратів),
						'name' => q(карати),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					'kelvin' => {
						'few' => q({0} кельвіни),
						'many' => q({0} кельвінів),
						'name' => q(кельвіни),
						'one' => q({0} кельвін),
						'other' => q({0} кельвіна),
					},
					'kilobit' => {
						'few' => q({0} кілобіти),
						'many' => q({0} кілобітів),
						'name' => q(кілобіти),
						'one' => q({0} кілобіт),
						'other' => q({0} кілобіта),
					},
					'kilobyte' => {
						'few' => q({0} кілобайти),
						'many' => q({0} кілобайтів),
						'name' => q(кілобайти),
						'one' => q({0} кілобайт),
						'other' => q({0} кілобайта),
					},
					'kilocalorie' => {
						'few' => q({0} кілокалорії),
						'many' => q({0} кілокалорій),
						'name' => q(кілокалорії),
						'one' => q({0} кілокалорія),
						'other' => q({0} кілокалорії),
					},
					'kilogram' => {
						'few' => q({0} кілограми),
						'many' => q({0} кілограмів),
						'name' => q(кілограми),
						'one' => q({0} кілограм),
						'other' => q({0} кілограма),
						'per' => q({0} на кілограм),
					},
					'kilohertz' => {
						'few' => q({0} кілогерци),
						'many' => q({0} кілогерців),
						'name' => q(кілогерци),
						'one' => q({0} кілогерц),
						'other' => q({0} кілогерца),
					},
					'kilojoule' => {
						'few' => q({0} кілоджоулі),
						'many' => q({0} кілоджоулів),
						'name' => q(кілоджоулі),
						'one' => q({0} кілоджоуль),
						'other' => q({0} кілоджоуля),
					},
					'kilometer' => {
						'few' => q({0} кілометри),
						'many' => q({0} кілометрів),
						'name' => q(кілометри),
						'one' => q({0} кілометр),
						'other' => q({0} кілометра),
						'per' => q({0} на кілометр),
					},
					'kilometer-per-hour' => {
						'few' => q({0} кілометри на годину),
						'many' => q({0} кілометрів на годину),
						'name' => q(кілометри на годину),
						'one' => q({0} кілометр на годину),
						'other' => q({0} кілометра на годину),
					},
					'kilowatt' => {
						'few' => q({0} кіловати),
						'many' => q({0} кіловатів),
						'name' => q(кіловати),
						'one' => q({0} кіловат),
						'other' => q({0} кіловата),
					},
					'kilowatt-hour' => {
						'few' => q({0} кіловат-години),
						'many' => q({0} кіловат-годин),
						'name' => q(кіловат-години),
						'one' => q({0} кіловат-година),
						'other' => q({0} кіловат-години),
					},
					'knot' => {
						'few' => q({0} вузли),
						'many' => q({0} вузлів),
						'name' => q(вузол),
						'one' => q({0} вузол),
						'other' => q({0} вузла),
					},
					'light-year' => {
						'few' => q({0} світлові роки),
						'many' => q({0} світлових років),
						'name' => q(світлові роки),
						'one' => q({0} світловий рік),
						'other' => q({0} світлового року),
					},
					'liter' => {
						'few' => q({0} літри),
						'many' => q({0} літрів),
						'name' => q(літри),
						'one' => q({0} літр),
						'other' => q({0} літра),
						'per' => q({0} на літр),
					},
					'liter-per-100kilometers' => {
						'few' => q({0} літри на 100 кілометрів),
						'many' => q({0} літрів на 100 кілометрів),
						'name' => q(літри на 100 кілометрів),
						'one' => q({0} літр на 100 кілометрів),
						'other' => q({0} літра на 100 кілометрів),
					},
					'liter-per-kilometer' => {
						'few' => q({0} літри на кілометр),
						'many' => q({0} літрів на кілометр),
						'name' => q(літри на кілометр),
						'one' => q({0} літр на кілометр),
						'other' => q({0} літра на кілометр),
					},
					'lux' => {
						'few' => q({0} люкси),
						'many' => q({0} люксів),
						'name' => q(люкси),
						'one' => q({0} люкс),
						'other' => q({0} люкса),
					},
					'megabit' => {
						'few' => q({0} мегабіти),
						'many' => q({0} мегабітів),
						'name' => q(мегабіти),
						'one' => q({0} мегабіт),
						'other' => q({0} мегабіта),
					},
					'megabyte' => {
						'few' => q({0} мегабайти),
						'many' => q({0} мегабайтів),
						'name' => q(мегабайти),
						'one' => q({0} мегабайт),
						'other' => q({0} мегабайта),
					},
					'megahertz' => {
						'few' => q({0} мегагерци),
						'many' => q({0} мегагерців),
						'name' => q(мегагерци),
						'one' => q({0} мегагерц),
						'other' => q({0} мегагерца),
					},
					'megaliter' => {
						'few' => q({0} мегалітри),
						'many' => q({0} мегалітрів),
						'name' => q(мегалітри),
						'one' => q({0} мегалітр),
						'other' => q({0} мегалітра),
					},
					'megawatt' => {
						'few' => q({0} мегавати),
						'many' => q({0} мегават),
						'name' => q(мегавати),
						'one' => q({0} мегават),
						'other' => q({0} мегавата),
					},
					'meter' => {
						'few' => q({0} метри),
						'many' => q({0} метрів),
						'name' => q(метри),
						'one' => q({0} метр),
						'other' => q({0} метра),
						'per' => q({0} на метр),
					},
					'meter-per-second' => {
						'few' => q({0} метри на секунду),
						'many' => q({0} метрів на секунду),
						'name' => q(метри на секунду),
						'one' => q({0} метр на секунду),
						'other' => q({0} метра на секунду),
					},
					'meter-per-second-squared' => {
						'few' => q({0} метри на секунду в квадраті),
						'many' => q({0} метрів на секунду в квадраті),
						'name' => q(метри на секунду в квадраті),
						'one' => q({0} метр на секунду в квадраті),
						'other' => q({0} метра на секунду в квадраті),
					},
					'metric-ton' => {
						'few' => q({0} метричні тонни),
						'many' => q({0} метричних тонн),
						'name' => q(метричні тонни),
						'one' => q({0} метрична тонна),
						'other' => q({0} метричної тонни),
					},
					'microgram' => {
						'few' => q({0} мікрограми),
						'many' => q({0} мікрограм),
						'name' => q(мікрограми),
						'one' => q({0} мікрограм),
						'other' => q({0} мікрограма),
					},
					'micrometer' => {
						'few' => q({0} мікрометри),
						'many' => q({0} мікрометрів),
						'name' => q(мікрометри),
						'one' => q({0} мікрометр),
						'other' => q({0} мікрометра),
					},
					'microsecond' => {
						'few' => q({0} мікросекунди),
						'many' => q({0} мікросекунд),
						'name' => q(мікросекунди),
						'one' => q({0} мікросекунда),
						'other' => q({0} мікросекунди),
					},
					'mile' => {
						'few' => q({0} милі),
						'many' => q({0} миль),
						'name' => q(милі),
						'one' => q({0} миля),
						'other' => q({0} милі),
					},
					'mile-per-gallon' => {
						'few' => q({0} милі на галон),
						'many' => q({0} миль на галон),
						'name' => q(милі на галон),
						'one' => q({0} миля на галон),
						'other' => q({0} милі на галон),
					},
					'mile-per-hour' => {
						'few' => q({0} милі на годину),
						'many' => q({0} миль на годину),
						'name' => q(милі на годину),
						'one' => q({0} миля на годину),
						'other' => q({0} милі на годину),
					},
					'mile-scandinavian' => {
						'few' => q({0} скандинавські милі),
						'many' => q({0} скандинавських миль),
						'name' => q(скандинавська миля),
						'one' => q({0} скандинавська миля),
						'other' => q({0} скандинавської милі),
					},
					'milliampere' => {
						'few' => q({0} міліампери),
						'many' => q({0} міліамперів),
						'name' => q(міліампери),
						'one' => q({0} міліампер),
						'other' => q({0} міліампера),
					},
					'millibar' => {
						'few' => q({0} мілібари),
						'many' => q({0} мілібарів),
						'name' => q(мілібари),
						'one' => q({0} мілібар),
						'other' => q({0} мілібара),
					},
					'milligram' => {
						'few' => q({0} міліграми),
						'many' => q({0} міліграм),
						'name' => q(міліграми),
						'one' => q({0} міліграм),
						'other' => q({0} міліграма),
					},
					'milliliter' => {
						'few' => q({0} мілілітри),
						'many' => q({0} мілілітрів),
						'name' => q(мілілітри),
						'one' => q({0} мілілітр),
						'other' => q({0} мілілітра),
					},
					'millimeter' => {
						'few' => q({0} міліметри),
						'many' => q({0} міліметрів),
						'name' => q(міліметри),
						'one' => q({0} міліметр),
						'other' => q({0} міліметра),
					},
					'millimeter-of-mercury' => {
						'few' => q({0} міліметри ртутного стовпа),
						'many' => q({0} міліметрів ртутного стовпа),
						'name' => q(міліметри ртутного стовпа),
						'one' => q({0} міліметр ртутного стовпа),
						'other' => q({0} міліметра ртутного стовпа),
					},
					'millisecond' => {
						'few' => q({0} мілісекунди),
						'many' => q({0} мілісекунд),
						'name' => q(мілісекунди),
						'one' => q({0} мілісекунда),
						'other' => q({0} мілісекунди),
					},
					'milliwatt' => {
						'few' => q({0} мілівати),
						'many' => q({0} міліват),
						'name' => q(мілівати),
						'one' => q({0} міліват),
						'other' => q({0} мілівата),
					},
					'minute' => {
						'few' => q({0} хвилини),
						'many' => q({0} хвилин),
						'name' => q(хвилини),
						'one' => q({0} хвилина),
						'other' => q({0} хвилини),
						'per' => q({0} на хв),
					},
					'month' => {
						'few' => q({0} місяці),
						'many' => q({0} місяців),
						'name' => q(місяці),
						'one' => q({0} місяць),
						'other' => q({0} місяця),
						'per' => q({0} на місяць),
					},
					'nanometer' => {
						'few' => q({0} нанометри),
						'many' => q({0} нанометрів),
						'name' => q(нанометри),
						'one' => q({0} нанометр),
						'other' => q({0} нанометра),
					},
					'nanosecond' => {
						'few' => q({0} наносекунди),
						'many' => q({0} наносекунд),
						'name' => q(наносекунди),
						'one' => q({0} наносекунда),
						'other' => q({0} наносекунди),
					},
					'nautical-mile' => {
						'few' => q({0} морські милі),
						'many' => q({0} морських миль),
						'name' => q(морські милі),
						'one' => q({0} морська миля),
						'other' => q({0} морської милі),
					},
					'ohm' => {
						'few' => q({0} оми),
						'many' => q({0} омів),
						'name' => q(оми),
						'one' => q({0} ом),
						'other' => q({0} ома),
					},
					'ounce' => {
						'few' => q({0} унції),
						'many' => q({0} унцій),
						'name' => q(унції),
						'one' => q({0} унція),
						'other' => q({0} унції),
						'per' => q({0} на унцію),
					},
					'ounce-troy' => {
						'few' => q({0} тройські унції),
						'many' => q({0} тройських унцій),
						'name' => q(тройські унції),
						'one' => q({0} тройська унція),
						'other' => q({0} тройської унції),
					},
					'parsec' => {
						'few' => q({0} парсеки),
						'many' => q({0} парсеків),
						'name' => q(парсеки),
						'one' => q({0} парсек),
						'other' => q({0} парсека),
					},
					'per' => {
						'1' => q({0} на {1}),
					},
					'picometer' => {
						'few' => q({0} пікометри),
						'many' => q({0} пікометрів),
						'name' => q(пікометри),
						'one' => q({0} пікометр),
						'other' => q({0} пікометра),
					},
					'pint' => {
						'few' => q({0} пінти),
						'many' => q({0} пінт),
						'name' => q(пінти),
						'one' => q({0} пінта),
						'other' => q({0} пінти),
					},
					'pint-metric' => {
						'few' => q({0} метричні пінти),
						'many' => q({0} метричних пінт),
						'name' => q(метрична пінта),
						'one' => q({0} метрична пінта),
						'other' => q({0} метричної пінти),
					},
					'pound' => {
						'few' => q({0} фунти),
						'many' => q({0} фунтів),
						'name' => q(фунти),
						'one' => q({0} фунт),
						'other' => q({0} фунта),
						'per' => q({0} на фунт),
					},
					'pound-per-square-inch' => {
						'few' => q({0} фунти на квадратний дюйм),
						'many' => q({0} фунтів на квадратний дюйм),
						'name' => q(фунти на квадратний дюйм),
						'one' => q({0} фунт на квадратний дюйм),
						'other' => q({0} фунта на квадратний дюйм),
					},
					'quart' => {
						'few' => q({0} кварти),
						'many' => q({0} кварт),
						'name' => q(кварти),
						'one' => q({0} кварта),
						'other' => q({0} кварти),
					},
					'radian' => {
						'few' => q({0} радіани),
						'many' => q({0} радіанів),
						'name' => q(радіани),
						'one' => q({0} радіан),
						'other' => q({0} радіана),
					},
					'revolution' => {
						'few' => q({0} оберти),
						'many' => q({0} обертів),
						'name' => q(оберти),
						'one' => q({0} оберт),
						'other' => q({0} оберта),
					},
					'second' => {
						'few' => q({0} секунди),
						'many' => q({0} секунд),
						'name' => q(секунди),
						'one' => q({0} секунда),
						'other' => q({0} секунди),
						'per' => q({0} на секунду),
					},
					'square-centimeter' => {
						'few' => q({0} квадратні сантиметри),
						'many' => q({0} квадратних сантиметрів),
						'name' => q(квадратні сантиметри),
						'one' => q({0} квадратний сантиметр),
						'other' => q({0} квадратного сантиметра),
						'per' => q({0} на квадратний сантиметр),
					},
					'square-foot' => {
						'few' => q({0} квадратні фути),
						'many' => q({0} квадратних футів),
						'name' => q(квадратні фути),
						'one' => q({0} квадратний фут),
						'other' => q({0} квадратного фута),
					},
					'square-inch' => {
						'few' => q({0} квадратні дюйми),
						'many' => q({0} квадратних дюймів),
						'name' => q(квадратні дюйми),
						'one' => q({0} квадратний дюйм),
						'other' => q({0} квадратного дюйма),
						'per' => q({0} квадратний дюйм),
					},
					'square-kilometer' => {
						'few' => q({0} квадратні кілометри),
						'many' => q({0} квадратних кілометрів),
						'name' => q(квадратні кілометри),
						'one' => q({0} квадратний кілометр),
						'other' => q({0} квадратного кілометра),
					},
					'square-meter' => {
						'few' => q({0} квадратні метри),
						'many' => q({0} квадратних метрів),
						'name' => q(квадтратні метри),
						'one' => q({0} квадратний метр),
						'other' => q({0} квадратного метра),
						'per' => q({0} на квадратний метр),
					},
					'square-mile' => {
						'few' => q({0} квадратні милі),
						'many' => q({0} квадратних миль),
						'name' => q(квадратні милі),
						'one' => q({0} квадратна миля),
						'other' => q({0} квадратної милі),
					},
					'square-yard' => {
						'few' => q({0} квадратні ярди),
						'many' => q({0} квадратних ярдів),
						'name' => q(квадратні ярди),
						'one' => q({0} квадратний ярд),
						'other' => q({0} квадратного ярда),
					},
					'tablespoon' => {
						'few' => q({0} столові ложки),
						'many' => q({0} столових ложок),
						'name' => q(cтолові ложки),
						'one' => q({0} столова ложка),
						'other' => q({0} столової ложки),
					},
					'teaspoon' => {
						'few' => q({0} чайні ложки),
						'many' => q({0} чайних ложок),
						'name' => q(чайні ложки),
						'one' => q({0} чайна ложка),
						'other' => q({0} чайної ложки),
					},
					'terabit' => {
						'few' => q({0} терабіти),
						'many' => q({0} терабітів),
						'name' => q(терабіти),
						'one' => q({0} терабіт),
						'other' => q({0} терабіта),
					},
					'terabyte' => {
						'few' => q({0} терабайти),
						'many' => q({0} терабайтів),
						'name' => q(терабайти),
						'one' => q({0} терабайт),
						'other' => q({0} терабайта),
					},
					'ton' => {
						'few' => q({0} тонни),
						'many' => q({0} тонн),
						'name' => q(тонни),
						'one' => q({0} тонна),
						'other' => q({0} тонни),
					},
					'volt' => {
						'few' => q({0} вольти),
						'many' => q({0} вольтів),
						'name' => q(вольти),
						'one' => q({0} вольт),
						'other' => q({0} вольта),
					},
					'watt' => {
						'few' => q({0} вати),
						'many' => q({0} ватів),
						'name' => q(вати),
						'one' => q({0} ват),
						'other' => q({0} вата),
					},
					'week' => {
						'few' => q({0} тижні),
						'many' => q({0} тижнів),
						'name' => q(тижні),
						'one' => q({0} тиждень),
						'other' => q({0} тижня),
						'per' => q({0} на тиждень),
					},
					'yard' => {
						'few' => q({0} ярди),
						'many' => q({0} ярдів),
						'name' => q(ярди),
						'one' => q({0} ярд),
						'other' => q({0} ярда),
					},
					'year' => {
						'few' => q({0} роки),
						'many' => q({0} років),
						'name' => q(роки),
						'one' => q({0} рік),
						'other' => q({0} року),
						'per' => q({0} на рік),
					},
				},
				'narrow' => {
					'acre' => {
						'few' => q({0} акри),
						'many' => q({0} акрів),
						'one' => q({0} акр),
						'other' => q({0} акра),
					},
					'arc-minute' => {
						'few' => q({0}′),
						'many' => q({0}′),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'few' => q({0}″),
						'many' => q({0}″),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'few' => q({0}°C),
						'many' => q({0}°C),
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'few' => q({0} см),
						'many' => q({0} см),
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
					},
					'coordinate' => {
						'east' => q({0} Сх),
						'north' => q({0} Пн),
						'south' => q({0} Пд),
						'west' => q({0} Зх),
					},
					'cubic-kilometer' => {
						'few' => q({0} км³),
						'many' => q({0} км³),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-mile' => {
						'few' => q({0} милі³),
						'many' => q({0} миль³),
						'one' => q({0} миля³),
						'other' => q({0} милі³),
					},
					'day' => {
						'few' => q({0} дн.),
						'many' => q({0} дн.),
						'name' => q(день),
						'one' => q({0} дн.),
						'other' => q({0} дн.),
					},
					'degree' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'few' => q({0}°F),
						'many' => q({0}°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'few' => q({0} фути),
						'many' => q({0} футів),
						'one' => q({0} фут),
						'other' => q({0} фута),
					},
					'g-force' => {
						'few' => q({0} G),
						'many' => q({0} G),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'few' => q({0} г),
						'many' => q({0} г),
						'name' => q(грам),
						'one' => q({0} г),
						'other' => q({0} г),
					},
					'hectare' => {
						'few' => q({0} га),
						'many' => q({0} га),
						'one' => q({0} га),
						'other' => q({0} га),
					},
					'hectopascal' => {
						'few' => q({0} гПа),
						'many' => q({0} гПа),
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					'horsepower' => {
						'few' => q({0} к.с.),
						'many' => q({0} к.с.),
						'one' => q({0} к.с.),
						'other' => q({0} к.с.),
					},
					'hour' => {
						'few' => q({0} год),
						'many' => q({0} год),
						'name' => q(год),
						'one' => q({0} год),
						'other' => q({0} год),
					},
					'inch' => {
						'few' => q({0} дюйми),
						'many' => q({0} дюймів),
						'one' => q({0} дюйм),
						'other' => q({0} дюйма),
					},
					'inch-hg' => {
						'few' => q({0} inHg),
						'many' => q({0} inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kelvin' => {
						'few' => q({0} К),
						'many' => q({0} К),
						'one' => q({0} К),
						'other' => q({0} К),
					},
					'kilogram' => {
						'few' => q({0} кг),
						'many' => q({0} кг),
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
					},
					'kilometer' => {
						'few' => q({0} км),
						'many' => q({0} км),
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
					},
					'kilometer-per-hour' => {
						'few' => q({0} км/год),
						'many' => q({0} км/год),
						'name' => q(км/год),
						'one' => q({0} км/год),
						'other' => q({0} км/год),
					},
					'kilowatt' => {
						'few' => q({0} кВт),
						'many' => q({0} кВт),
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					'light-year' => {
						'few' => q({0} св. р.),
						'many' => q({0} св. р.),
						'one' => q({0} св. р.),
						'other' => q({0} св. р.),
					},
					'liter' => {
						'few' => q({0} л),
						'many' => q({0} л),
						'name' => q(літр),
						'one' => q({0} л),
						'other' => q({0} л),
					},
					'liter-per-100kilometers' => {
						'few' => q({0} л/100 км),
						'many' => q({0} л/100 км),
						'name' => q(л/100 км),
						'one' => q({0} л/100 км),
						'other' => q({0} л/100 км),
					},
					'meter' => {
						'few' => q({0} м),
						'many' => q({0} м),
						'name' => q(метр),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'meter-per-second' => {
						'few' => q({0} м/с),
						'many' => q({0} м/с),
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					'microsecond' => {
						'few' => q({0} мкс),
						'many' => q({0} мкс),
						'name' => q(мкс),
						'one' => q({0} мкс),
						'other' => q({0} мкс),
					},
					'mile' => {
						'few' => q({0} милі),
						'many' => q({0} миль),
						'one' => q({0} миля),
						'other' => q({0} милі),
					},
					'mile-per-hour' => {
						'few' => q({0} милі/год),
						'many' => q({0} миль/год),
						'one' => q({0} миля/год),
						'other' => q({0} милі/год),
					},
					'millibar' => {
						'few' => q({0} мбари),
						'many' => q({0} мбарів),
						'one' => q({0} мбар),
						'other' => q({0} мбара),
					},
					'millimeter' => {
						'few' => q({0} мм),
						'many' => q({0} мм),
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millisecond' => {
						'few' => q({0} мс),
						'many' => q({0} мс),
						'name' => q(мс),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'minute' => {
						'few' => q({0} хв),
						'many' => q({0} хв),
						'name' => q(хв),
						'one' => q({0} хв),
						'other' => q({0} хв),
					},
					'month' => {
						'few' => q({0} міс.),
						'many' => q({0} міс.),
						'name' => q(міс.),
						'one' => q({0} міс.),
						'other' => q({0} міс.),
					},
					'ounce' => {
						'few' => q({0} унції),
						'many' => q({0} унцій),
						'one' => q({0} унція),
						'other' => q({0} унції),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'few' => q({0} пм),
						'many' => q({0} пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pound' => {
						'few' => q({0} фунти),
						'many' => q({0} фунтів),
						'one' => q({0} фунт),
						'other' => q({0} фунта),
					},
					'second' => {
						'few' => q({0} с),
						'many' => q({0} с),
						'name' => q(с),
						'one' => q({0} с),
						'other' => q({0} с),
					},
					'square-foot' => {
						'few' => q({0} фути²),
						'many' => q({0} футів²),
						'one' => q({0} фут²),
						'other' => q({0} фута²),
					},
					'square-kilometer' => {
						'few' => q({0} км²),
						'many' => q({0} км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					'square-meter' => {
						'few' => q({0} м²),
						'many' => q({0} м²),
						'one' => q({0} м²),
						'other' => q({0} м²),
					},
					'square-mile' => {
						'few' => q({0} милі²),
						'many' => q({0} миль²),
						'one' => q({0} миля²),
						'other' => q({0} милі²),
					},
					'watt' => {
						'few' => q({0} Вт),
						'many' => q({0} Вт),
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					'week' => {
						'few' => q({0} тиж.),
						'many' => q({0} тиж.),
						'name' => q(тиж.),
						'one' => q({0} тиж.),
						'other' => q({0} тиж.),
					},
					'yard' => {
						'few' => q({0} ярди),
						'many' => q({0} ярдів),
						'one' => q({0} ярд),
						'other' => q({0} ярда),
					},
					'year' => {
						'few' => q({0} р.),
						'many' => q({0} р.),
						'name' => q(р.),
						'one' => q({0} р.),
						'other' => q({0} р.),
					},
				},
				'short' => {
					'acre' => {
						'few' => q({0} акри),
						'many' => q({0} акрів),
						'name' => q(акри),
						'one' => q({0} акр),
						'other' => q({0} акра),
					},
					'acre-foot' => {
						'few' => q({0} акр-фути),
						'many' => q({0} акр-футів),
						'name' => q(акр-фути),
						'one' => q({0} акр-фут),
						'other' => q({0} акр-фута),
					},
					'ampere' => {
						'few' => q({0} А),
						'many' => q({0} А),
						'name' => q(А),
						'one' => q({0} А),
						'other' => q({0} А),
					},
					'arc-minute' => {
						'few' => q({0} мін.),
						'many' => q({0} мін.),
						'name' => q(мінути),
						'one' => q({0} мін.),
						'other' => q({0} мін.),
					},
					'arc-second' => {
						'few' => q({0} кут. сек.),
						'many' => q({0} кут. сек.),
						'name' => q(кут. сек.),
						'one' => q({0} кут. сек.),
						'other' => q({0} кут. сек.),
					},
					'astronomical-unit' => {
						'few' => q({0} а. о.),
						'many' => q({0} а. о.),
						'name' => q(а. о.),
						'one' => q({0} а. о.),
						'other' => q({0} а. о.),
					},
					'bit' => {
						'few' => q({0} б),
						'many' => q({0} б),
						'name' => q(біт),
						'one' => q({0} б),
						'other' => q({0} б),
					},
					'byte' => {
						'few' => q({0} Б),
						'many' => q({0} Б),
						'name' => q(байт),
						'one' => q({0} Б),
						'other' => q({0} Б),
					},
					'calorie' => {
						'few' => q({0} кал),
						'many' => q({0} кал),
						'name' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					'carat' => {
						'few' => q({0} кар),
						'many' => q({0} кар),
						'name' => q(карати),
						'one' => q({0} кар),
						'other' => q({0} кар),
					},
					'celsius' => {
						'few' => q({0}°C),
						'many' => q({0}°C),
						'name' => q(градус Цельсія),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'few' => q({0} сл),
						'many' => q({0} сл),
						'name' => q(сл),
						'one' => q({0} сл),
						'other' => q({0} сл),
					},
					'centimeter' => {
						'few' => q({0} см),
						'many' => q({0} см),
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					'century' => {
						'few' => q({0} ст.),
						'many' => q({0} ст.),
						'name' => q(ст.),
						'one' => q({0} ст.),
						'other' => q({0} ст.),
					},
					'coordinate' => {
						'east' => q({0} на Сх),
						'north' => q({0} на Пн),
						'south' => q({0} на Пд),
						'west' => q({0} на Зх),
					},
					'cubic-centimeter' => {
						'few' => q({0} см³),
						'many' => q({0} см³),
						'name' => q(см³),
						'one' => q({0} см³),
						'other' => q({0} см³),
						'per' => q({0}/см³),
					},
					'cubic-foot' => {
						'few' => q({0} фути³),
						'many' => q({0} футів³),
						'name' => q(фути³),
						'one' => q({0} фут³),
						'other' => q({0} фута³),
					},
					'cubic-inch' => {
						'few' => q({0} дюйми³),
						'many' => q({0} дюймів³),
						'name' => q(дюйми³),
						'one' => q({0} дюйм³),
						'other' => q({0} дюйма³),
					},
					'cubic-kilometer' => {
						'few' => q({0} км³),
						'many' => q({0} км³),
						'name' => q(км³),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-meter' => {
						'few' => q({0} м³),
						'many' => q({0} м³),
						'name' => q(м³),
						'one' => q({0} м³),
						'other' => q({0} м³),
						'per' => q({0}/м³),
					},
					'cubic-mile' => {
						'few' => q({0} милі³),
						'many' => q({0} миль³),
						'name' => q(милі³),
						'one' => q({0} миля³),
						'other' => q({0} милі³),
					},
					'cubic-yard' => {
						'few' => q({0} ярди³),
						'many' => q({0} ярдів³),
						'name' => q(ярди³),
						'one' => q({0} ярд³),
						'other' => q({0} ярда³),
					},
					'cup' => {
						'few' => q({0} скл.),
						'many' => q({0} скл.),
						'name' => q(склянки),
						'one' => q({0} скл.),
						'other' => q({0} скл.),
					},
					'cup-metric' => {
						'few' => q({0} метричні скл.),
						'many' => q({0} метричних скл.),
						'name' => q(метричні скл.),
						'one' => q({0} метрична скл.),
						'other' => q({0} метричної скл.),
					},
					'day' => {
						'few' => q({0} дн.),
						'many' => q({0} дн.),
						'name' => q(дні),
						'one' => q({0} д.),
						'other' => q({0} дн.),
						'per' => q({0}/дн.),
					},
					'deciliter' => {
						'few' => q({0} дл),
						'many' => q({0} дл),
						'name' => q(дл),
						'one' => q({0} дл),
						'other' => q({0} дл),
					},
					'decimeter' => {
						'few' => q({0} дм),
						'many' => q({0} дм),
						'name' => q(дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					'degree' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(градуси),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'few' => q({0}°F),
						'many' => q({0}°F),
						'name' => q(градус Фаренгейта),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fluid-ounce' => {
						'few' => q({0} рід. ун.),
						'many' => q({0} рід. ун.),
						'name' => q(рід. ун.),
						'one' => q({0} рід. ун.),
						'other' => q({0} рід. ун.),
					},
					'foodcalorie' => {
						'few' => q({0} Кал),
						'many' => q({0} Кал),
						'name' => q(Кал),
						'one' => q({0} Кал),
						'other' => q({0} Кал),
					},
					'foot' => {
						'few' => q({0} фути),
						'many' => q({0} футів),
						'name' => q(фут),
						'one' => q({0} фут),
						'other' => q({0} фута),
						'per' => q({0}/фут),
					},
					'g-force' => {
						'few' => q({0} G),
						'many' => q({0} G),
						'name' => q(сили тяжіння),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gallon' => {
						'few' => q({0} гал.),
						'many' => q({0} гал.),
						'name' => q(гал.),
						'one' => q({0} гал.),
						'other' => q({0} гал.),
						'per' => q({0}/гал.),
					},
					'generic' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'few' => q({0} Гб),
						'many' => q({0} Гб),
						'name' => q(Гбіт),
						'one' => q({0} Гб),
						'other' => q({0} Гб),
					},
					'gigabyte' => {
						'few' => q({0} ГБ),
						'many' => q({0} ГБ),
						'name' => q(Гбайт),
						'one' => q({0} ГБ),
						'other' => q({0} ГБ),
					},
					'gigahertz' => {
						'few' => q({0} ГГц),
						'many' => q({0} ГГц),
						'name' => q(ГГц),
						'one' => q({0} ГГц),
						'other' => q({0} ГГц),
					},
					'gigawatt' => {
						'few' => q({0} ГВт),
						'many' => q({0} ГВт),
						'name' => q(ГВт),
						'one' => q({0} ГВт),
						'other' => q({0} ГВт),
					},
					'gram' => {
						'few' => q({0} г),
						'many' => q({0} г),
						'name' => q(грами),
						'one' => q({0} г),
						'other' => q({0} г),
						'per' => q({0}/г),
					},
					'hectare' => {
						'few' => q({0} га),
						'many' => q({0} га),
						'name' => q(гектари),
						'one' => q({0} га),
						'other' => q({0} га),
					},
					'hectoliter' => {
						'few' => q({0} гл),
						'many' => q({0} гл),
						'name' => q(гл),
						'one' => q({0} гл),
						'other' => q({0} гл),
					},
					'hectopascal' => {
						'few' => q({0} гПа),
						'many' => q({0} гПа),
						'name' => q(гПа),
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					'hertz' => {
						'few' => q({0} Гц),
						'many' => q({0} Гц),
						'name' => q(Гц),
						'one' => q({0} Гц),
						'other' => q({0} Гц),
					},
					'horsepower' => {
						'few' => q({0} к. с.),
						'many' => q({0} к. с.),
						'name' => q(к. с.),
						'one' => q({0} к. с.),
						'other' => q({0} к. с.),
					},
					'hour' => {
						'few' => q({0} год),
						'many' => q({0} год),
						'name' => q(год),
						'one' => q({0} год),
						'other' => q({0} год),
						'per' => q({0}/год),
					},
					'inch' => {
						'few' => q({0} дюйми),
						'many' => q({0} дюймів),
						'name' => q(дюйми),
						'one' => q({0} дюйм),
						'other' => q({0} дюйма),
						'per' => q({0}/дюйм),
					},
					'inch-hg' => {
						'few' => q({0} дюйми рт. ст.),
						'many' => q({0} дюймів рт. ст.),
						'name' => q(дюйми рт. ст.),
						'one' => q({0} дюйм рт. ст.),
						'other' => q({0} дюйма рт. ст.),
					},
					'joule' => {
						'few' => q({0} Дж),
						'many' => q({0} Дж),
						'name' => q(джоулі),
						'one' => q({0} Дж),
						'other' => q({0} Дж),
					},
					'karat' => {
						'few' => q({0} кар.),
						'many' => q({0} кар.),
						'name' => q(карати),
						'one' => q({0} кар.),
						'other' => q({0} кар.),
					},
					'kelvin' => {
						'few' => q({0} К),
						'many' => q({0} К),
						'name' => q(кельвін),
						'one' => q({0} К),
						'other' => q({0} К),
					},
					'kilobit' => {
						'few' => q({0} кб),
						'many' => q({0} кб),
						'name' => q(кбіт),
						'one' => q({0} кб),
						'other' => q({0} кб),
					},
					'kilobyte' => {
						'few' => q({0} кБ),
						'many' => q({0} кБ),
						'name' => q(кбайт),
						'one' => q({0} кБ),
						'other' => q({0} кБ),
					},
					'kilocalorie' => {
						'few' => q({0} Ккал),
						'many' => q({0} Ккал),
						'name' => q(Ккал),
						'one' => q({0} Ккал),
						'other' => q({0} Ккал),
					},
					'kilogram' => {
						'few' => q({0} кг),
						'many' => q({0} кг),
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
						'per' => q({0}/кг),
					},
					'kilohertz' => {
						'few' => q({0} кГц),
						'many' => q({0} кГц),
						'name' => q(кГц),
						'one' => q({0} кГц),
						'other' => q({0} кГц),
					},
					'kilojoule' => {
						'few' => q({0} кДж),
						'many' => q({0} кДж),
						'name' => q(кілоджоуль),
						'one' => q({0} кДж),
						'other' => q({0} кДж),
					},
					'kilometer' => {
						'few' => q({0} км),
						'many' => q({0} км),
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					'kilometer-per-hour' => {
						'few' => q({0} км/год),
						'many' => q({0} км/год),
						'name' => q(км/годину),
						'one' => q({0} км/год),
						'other' => q({0} км/год),
					},
					'kilowatt' => {
						'few' => q({0} кВт),
						'many' => q({0} кВт),
						'name' => q(кВт),
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					'kilowatt-hour' => {
						'few' => q({0} кВт год),
						'many' => q({0} кВт год),
						'name' => q(кВт год),
						'one' => q({0} кВт год),
						'other' => q({0} кВт год),
					},
					'knot' => {
						'few' => q({0} kn),
						'many' => q({0} kn),
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					'light-year' => {
						'few' => q({0} св. р.),
						'many' => q({0} св. р.),
						'name' => q(св. р.),
						'one' => q({0} св. р.),
						'other' => q({0} св. р.),
					},
					'liter' => {
						'few' => q({0} л),
						'many' => q({0} л),
						'name' => q(літри),
						'one' => q({0} л),
						'other' => q({0} л),
						'per' => q({0}/л),
					},
					'liter-per-100kilometers' => {
						'few' => q({0} л/100 км),
						'many' => q({0} л/100 км),
						'name' => q(л/100 км),
						'one' => q({0} л/100 км),
						'other' => q({0} л/100 км),
					},
					'liter-per-kilometer' => {
						'few' => q({0} л/км),
						'many' => q({0} л/км),
						'name' => q(літри/км),
						'one' => q({0} л/км),
						'other' => q({0} л/км),
					},
					'lux' => {
						'few' => q({0} лк),
						'many' => q({0} лк),
						'name' => q(люкс),
						'one' => q({0} лк),
						'other' => q({0} лк),
					},
					'megabit' => {
						'few' => q({0} Мб),
						'many' => q({0} Мб),
						'name' => q(Мбіт),
						'one' => q({0} Мб),
						'other' => q({0} Мб),
					},
					'megabyte' => {
						'few' => q({0} МБ),
						'many' => q({0} МБ),
						'name' => q(Мбайт),
						'one' => q({0} МБ),
						'other' => q({0} МБ),
					},
					'megahertz' => {
						'few' => q({0} МГц),
						'many' => q({0} МГц),
						'name' => q(МГц),
						'one' => q({0} МГц),
						'other' => q({0} МГц),
					},
					'megaliter' => {
						'few' => q({0} Мл),
						'many' => q({0} Мл),
						'name' => q(Мл),
						'one' => q({0} Мл),
						'other' => q({0} Мл),
					},
					'megawatt' => {
						'few' => q({0} МВт),
						'many' => q({0} МВт),
						'name' => q(МВт),
						'one' => q({0} МВт),
						'other' => q({0} МВт),
					},
					'meter' => {
						'few' => q({0} м),
						'many' => q({0} м),
						'name' => q(метри),
						'one' => q({0} м),
						'other' => q({0} м),
						'per' => q({0}/м),
					},
					'meter-per-second' => {
						'few' => q({0} м/с),
						'many' => q({0} м/с),
						'name' => q(метри/с),
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					'meter-per-second-squared' => {
						'few' => q({0} м/с²),
						'many' => q({0} м/с²),
						'name' => q(метри/с²),
						'one' => q({0} м/с²),
						'other' => q({0} м/с²),
					},
					'metric-ton' => {
						'few' => q({0} метр. т),
						'many' => q({0} метр. т),
						'name' => q(метр. т),
						'one' => q({0} метр. т),
						'other' => q({0} метр. т),
					},
					'microgram' => {
						'few' => q({0} мкг),
						'many' => q({0} мкг),
						'name' => q(мкг),
						'one' => q({0} мкг),
						'other' => q({0} мкг),
					},
					'micrometer' => {
						'few' => q({0} мкм),
						'many' => q({0} мкм),
						'name' => q(мкм),
						'one' => q({0} мкм),
						'other' => q({0} мкм),
					},
					'microsecond' => {
						'few' => q({0} мкс),
						'many' => q({0} мкс),
						'name' => q(мкс),
						'one' => q({0} мкс),
						'other' => q({0} мкс),
					},
					'mile' => {
						'few' => q({0} милі),
						'many' => q({0} миль),
						'name' => q(милі),
						'one' => q({0} миля),
						'other' => q({0} милі),
					},
					'mile-per-gallon' => {
						'few' => q({0} милі/галон),
						'many' => q({0} миль/галон),
						'name' => q(милі/галон),
						'one' => q({0} миля/галон),
						'other' => q({0} милі/галон),
					},
					'mile-per-hour' => {
						'few' => q({0} милі/год),
						'many' => q({0} миль/год),
						'name' => q(милі/год),
						'one' => q({0} миля/год),
						'other' => q({0} милі/год),
					},
					'mile-scandinavian' => {
						'few' => q({0} сканд. милі),
						'many' => q({0} сканд. миль),
						'name' => q(сканд. миля),
						'one' => q({0} сканд. миля),
						'other' => q({0} сканд. милі),
					},
					'milliampere' => {
						'few' => q({0} мА),
						'many' => q({0} мА),
						'name' => q(мА),
						'one' => q({0} мА),
						'other' => q({0} мА),
					},
					'millibar' => {
						'few' => q({0} мбари),
						'many' => q({0} мбарів),
						'name' => q(мбар),
						'one' => q({0} мбар),
						'other' => q({0} мбара),
					},
					'milligram' => {
						'few' => q({0} мг),
						'many' => q({0} мг),
						'name' => q(мг),
						'one' => q({0} мг),
						'other' => q({0} мг),
					},
					'milliliter' => {
						'few' => q({0} мл),
						'many' => q({0} мл),
						'name' => q(мл),
						'one' => q({0} мл),
						'other' => q({0} мл),
					},
					'millimeter' => {
						'few' => q({0} мм),
						'many' => q({0} мм),
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millimeter-of-mercury' => {
						'few' => q({0} мм рт. ст.),
						'many' => q({0} мм рт. ст.),
						'name' => q(мм рт. ст.),
						'one' => q({0} мм рт. ст.),
						'other' => q({0} мм рт. ст.),
					},
					'millisecond' => {
						'few' => q({0} мс),
						'many' => q({0} мс),
						'name' => q(мс),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'milliwatt' => {
						'few' => q({0} мВт),
						'many' => q({0} мВт),
						'name' => q(мВт),
						'one' => q({0} мВт),
						'other' => q({0} мВт),
					},
					'minute' => {
						'few' => q({0} хв),
						'many' => q({0} хв),
						'name' => q(хв),
						'one' => q({0} хв),
						'other' => q({0} хв),
						'per' => q({0}/хв),
					},
					'month' => {
						'few' => q({0} міс.),
						'many' => q({0} міс.),
						'name' => q(міс.),
						'one' => q({0} міс.),
						'other' => q({0} міс.),
						'per' => q({0}/міс.),
					},
					'nanometer' => {
						'few' => q({0} нм),
						'many' => q({0} нм),
						'name' => q(нм),
						'one' => q({0} нм),
						'other' => q({0} нм),
					},
					'nanosecond' => {
						'few' => q({0} нс),
						'many' => q({0} нс),
						'name' => q(нс),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					'nautical-mile' => {
						'few' => q({0} м. милі),
						'many' => q({0} м. миль),
						'name' => q(м. милі),
						'one' => q({0} м. миля),
						'other' => q({0} м. милі),
					},
					'ohm' => {
						'few' => q({0} Ом),
						'many' => q({0} Ом),
						'name' => q(оми),
						'one' => q({0} Ом),
						'other' => q({0} Ом),
					},
					'ounce' => {
						'few' => q({0} унц.),
						'many' => q({0} унц.),
						'name' => q(унц.),
						'one' => q({0} унц.),
						'other' => q({0} унц.),
						'per' => q({0}/унц.),
					},
					'ounce-troy' => {
						'few' => q({0} тр. унції),
						'many' => q({0} тр. унцій),
						'name' => q(тр. унції),
						'one' => q({0} тр. унція),
						'other' => q({0} тр. унції),
					},
					'parsec' => {
						'few' => q({0} пк),
						'many' => q({0} пк),
						'name' => q(парсеки),
						'one' => q({0} пк),
						'other' => q({0} пк),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'few' => q({0} пм),
						'many' => q({0} пм),
						'name' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pint' => {
						'few' => q({0} пінти),
						'many' => q({0} пінт),
						'name' => q(пінти),
						'one' => q({0} пінта),
						'other' => q({0} пінти),
					},
					'pint-metric' => {
						'few' => q({0} метричні пінти),
						'many' => q({0} метричних пінт),
						'name' => q(метрична пінта),
						'one' => q({0} метрична пінта),
						'other' => q({0} метричної пінти),
					},
					'pound' => {
						'few' => q({0} фунти),
						'many' => q({0} фунтів),
						'name' => q(фунти),
						'one' => q({0} фунт),
						'other' => q({0} фунта),
						'per' => q({0}/фунт),
					},
					'pound-per-square-inch' => {
						'few' => q({0} фунти/дюйм²),
						'many' => q({0} фунтів/дюйм²),
						'name' => q(фунт/дюйм²),
						'one' => q({0} фунт/дюйм²),
						'other' => q({0} фунта/дюйм²),
					},
					'quart' => {
						'few' => q({0} квар.),
						'many' => q({0} квар.),
						'name' => q(квар.),
						'one' => q({0} квар.),
						'other' => q({0} квар.),
					},
					'radian' => {
						'few' => q({0} рад.),
						'many' => q({0} рад.),
						'name' => q(радіани),
						'one' => q({0} рад.),
						'other' => q({0} рад.),
					},
					'revolution' => {
						'few' => q({0} об),
						'many' => q({0} об),
						'name' => q(об),
						'one' => q({0} об),
						'other' => q({0} об),
					},
					'second' => {
						'few' => q({0} с),
						'many' => q({0} с),
						'name' => q(с),
						'one' => q({0} с),
						'other' => q({0} с),
						'per' => q({0}/с),
					},
					'square-centimeter' => {
						'few' => q({0} см²),
						'many' => q({0} см²),
						'name' => q(см²),
						'one' => q({0} см²),
						'other' => q({0} см²),
						'per' => q({0}/см²),
					},
					'square-foot' => {
						'few' => q({0} фути²),
						'many' => q({0} футів²),
						'name' => q(фути²),
						'one' => q({0} фут²),
						'other' => q({0} фута²),
					},
					'square-inch' => {
						'few' => q({0} дюйми²),
						'many' => q({0} дюймів²),
						'name' => q(дюйми²),
						'one' => q({0} дюйм²),
						'other' => q({0} дюйма²),
						'per' => q({0}/дюйм²),
					},
					'square-kilometer' => {
						'few' => q({0} км²),
						'many' => q({0} км²),
						'name' => q(км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					'square-meter' => {
						'few' => q({0} м²),
						'many' => q({0} м²),
						'name' => q(м²),
						'one' => q({0} м²),
						'other' => q({0} м²),
						'per' => q({0}/м²),
					},
					'square-mile' => {
						'few' => q({0} милі²),
						'many' => q({0} миль²),
						'name' => q(милі²),
						'one' => q({0} миля²),
						'other' => q({0} милі²),
					},
					'square-yard' => {
						'few' => q({0} ярди²),
						'many' => q({0} ярдів²),
						'name' => q(ярди²),
						'one' => q({0} ярд²),
						'other' => q({0} ярда²),
					},
					'tablespoon' => {
						'few' => q({0} ст. л.),
						'many' => q({0} ст. л.),
						'name' => q(ст. л.),
						'one' => q({0} ст. л.),
						'other' => q({0} ст. л.),
					},
					'teaspoon' => {
						'few' => q({0} ч. л.),
						'many' => q({0} ч. л.),
						'name' => q(ч. л.),
						'one' => q({0} ч. л.),
						'other' => q({0} ч. л.),
					},
					'terabit' => {
						'few' => q({0} Тб),
						'many' => q({0} Тб),
						'name' => q(Тбіт),
						'one' => q({0} Тб),
						'other' => q({0} Тб),
					},
					'terabyte' => {
						'few' => q({0} ТБ),
						'many' => q({0} ТБ),
						'name' => q(Тбайт),
						'one' => q({0} ТБ),
						'other' => q({0} ТБ),
					},
					'ton' => {
						'few' => q({0} т),
						'many' => q({0} т),
						'name' => q(тонни),
						'one' => q({0} т),
						'other' => q({0} т),
					},
					'volt' => {
						'few' => q({0} В),
						'many' => q({0} В),
						'name' => q(вольти),
						'one' => q({0} В),
						'other' => q({0} В),
					},
					'watt' => {
						'few' => q({0} Вт),
						'many' => q({0} Вт),
						'name' => q(вати),
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					'week' => {
						'few' => q({0} тиж.),
						'many' => q({0} тиж.),
						'name' => q(тиж.),
						'one' => q({0} тиж.),
						'other' => q({0} тиж.),
						'per' => q({0}/тиж.),
					},
					'yard' => {
						'few' => q({0} ярди),
						'many' => q({0} ярдів),
						'name' => q(ярди),
						'one' => q({0} ярд),
						'other' => q({0} ярда),
					},
					'year' => {
						'few' => q({0} р.),
						'many' => q({0} р.),
						'name' => q(р.),
						'one' => q({0} р.),
						'other' => q({0} р.),
						'per' => q({0}/р.),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:так|т|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ні|н|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> 'Int',
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(Е),
			'group' => q( ),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'few' => '0 тис'.'',
					'many' => '0 тис'.'',
					'one' => '0 тис'.'',
					'other' => '0 тис'.'',
				},
				'10000' => {
					'few' => '00 тис'.'',
					'many' => '00 тис'.'',
					'one' => '00 тис'.'',
					'other' => '00 тис'.'',
				},
				'100000' => {
					'few' => '000 тис'.'',
					'many' => '000 тис'.'',
					'one' => '000 тис'.'',
					'other' => '000 тис'.'',
				},
				'1000000' => {
					'few' => '0 млн',
					'many' => '0 млн',
					'one' => '0 млн',
					'other' => '0 млн',
				},
				'10000000' => {
					'few' => '00 млн',
					'many' => '00 млн',
					'one' => '00 млн',
					'other' => '00 млн',
				},
				'100000000' => {
					'few' => '000 млн',
					'many' => '000 млн',
					'one' => '000 млн',
					'other' => '000 млн',
				},
				'1000000000' => {
					'few' => '0 млрд',
					'many' => '0 млрд',
					'one' => '0 млрд',
					'other' => '0 млрд',
				},
				'10000000000' => {
					'few' => '00 млрд',
					'many' => '00 млрд',
					'one' => '00 млрд',
					'other' => '00 млрд',
				},
				'100000000000' => {
					'few' => '000 млрд',
					'many' => '000 млрд',
					'one' => '000 млрд',
					'other' => '000 млрд',
				},
				'1000000000000' => {
					'few' => '0 трлн',
					'many' => '0 трлн',
					'one' => '0 трлн',
					'other' => '0 трлн',
				},
				'10000000000000' => {
					'few' => '00 трлн',
					'many' => '00 трлн',
					'one' => '00 трлн',
					'other' => '00 трлн',
				},
				'100000000000000' => {
					'few' => '000 трлн',
					'many' => '000 трлн',
					'one' => '000 трлн',
					'other' => '000 трлн',
				},
				'standard' => {
					'' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'few' => '0 тисячі',
					'many' => '0 тисяч',
					'one' => '0 тисяча',
					'other' => '0 тисячі',
				},
				'10000' => {
					'few' => '00 тисячі',
					'many' => '00 тисяч',
					'one' => '00 тисяча',
					'other' => '00 тисячі',
				},
				'100000' => {
					'few' => '000 тисячі',
					'many' => '000 тисяч',
					'one' => '000 тисяча',
					'other' => '000 тисячі',
				},
				'1000000' => {
					'few' => '0 мільйони',
					'many' => '0 мільйонів',
					'one' => '0 мільйон',
					'other' => '0 мільйона',
				},
				'10000000' => {
					'few' => '00 мільйони',
					'many' => '00 мільйонів',
					'one' => '00 мільйон',
					'other' => '00 мільйона',
				},
				'100000000' => {
					'few' => '000 мільйони',
					'many' => '000 мільйонів',
					'one' => '000 мільйон',
					'other' => '000 мільйона',
				},
				'1000000000' => {
					'few' => '0 мільярди',
					'many' => '0 мільярдів',
					'one' => '0 мільярд',
					'other' => '0 мільярда',
				},
				'10000000000' => {
					'few' => '00 мільярди',
					'many' => '00 мільярдів',
					'one' => '00 мільярд',
					'other' => '00 мільярда',
				},
				'100000000000' => {
					'few' => '000 мільярди',
					'many' => '000 мільярдів',
					'one' => '000 мільярд',
					'other' => '000 мільярда',
				},
				'1000000000000' => {
					'few' => '0 трильйони',
					'many' => '0 трильйонів',
					'one' => '0 трильйон',
					'other' => '0 трильйона',
				},
				'10000000000000' => {
					'few' => '00 трильйони',
					'many' => '00 трильйонів',
					'one' => '00 трильйон',
					'other' => '00 трильйона',
				},
				'100000000000000' => {
					'few' => '000 трильйони',
					'many' => '000 трильйонів',
					'one' => '000 трильйон',
					'other' => '000 трильйона',
				},
			},
			'short' => {
				'1000' => {
					'few' => '0 тис'.'',
					'many' => '0 тис'.'',
					'one' => '0 тис'.'',
					'other' => '0 тис'.'',
				},
				'10000' => {
					'few' => '00 тис'.'',
					'many' => '00 тис'.'',
					'one' => '00 тис'.'',
					'other' => '00 тис'.'',
				},
				'100000' => {
					'few' => '000 тис'.'',
					'many' => '000 тис'.'',
					'one' => '000 тис'.'',
					'other' => '000 тис'.'',
				},
				'1000000' => {
					'few' => '0 млн',
					'many' => '0 млн',
					'one' => '0 млн',
					'other' => '0 млн',
				},
				'10000000' => {
					'few' => '00 млн',
					'many' => '00 млн',
					'one' => '00 млн',
					'other' => '00 млн',
				},
				'100000000' => {
					'few' => '000 млн',
					'many' => '000 млн',
					'one' => '000 млн',
					'other' => '000 млн',
				},
				'1000000000' => {
					'few' => '0 млрд',
					'many' => '0 млрд',
					'one' => '0 млрд',
					'other' => '0 млрд',
				},
				'10000000000' => {
					'few' => '00 млрд',
					'many' => '00 млрд',
					'one' => '00 млрд',
					'other' => '00 млрд',
				},
				'100000000000' => {
					'few' => '000 млрд',
					'many' => '000 млрд',
					'one' => '000 млрд',
					'other' => '000 млрд',
				},
				'1000000000000' => {
					'few' => '0 трлн',
					'many' => '0 трлн',
					'one' => '0 трлн',
					'other' => '0 трлн',
				},
				'10000000000000' => {
					'few' => '00 трлн',
					'many' => '00 трлн',
					'one' => '00 трлн',
					'other' => '00 трлн',
				},
				'100000000000000' => {
					'few' => '000 трлн',
					'many' => '000 трлн',
					'one' => '000 трлн',
					'other' => '000 трлн',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(#,##0.00¤)',
						'positive' => '#,##0.00¤',
					},
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(андоррська песета),
				'few' => q(андоррські песети),
				'many' => q(андоррських песет),
				'one' => q(андоррська песета),
				'other' => q(андоррських песет),
			},
		},
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(дирхам ОАЕ),
				'few' => q(дирхами ОАЕ),
				'many' => q(дирхамів ОАЕ),
				'one' => q(дирхам ОАЕ),
				'other' => q(дирхама ОАЕ),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(афгані \(1927–2002\)),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(афганський афгані),
				'few' => q(афганські афгані),
				'many' => q(афганських афгані),
				'one' => q(афганський афгані),
				'other' => q(афганського афгані),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(албанський лек),
				'few' => q(албанські леки),
				'many' => q(албанських леків),
				'one' => q(албанський лек),
				'other' => q(албанського лека),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(вірменський драм),
				'few' => q(вірменські драми),
				'many' => q(вірменських драмів),
				'one' => q(вірменський драм),
				'other' => q(вірменського драма),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(нідерландський антильський гульден),
				'few' => q(нідерландські антильські гульдени),
				'many' => q(нідерландських антильських гульденів),
				'one' => q(нідерландський антильський гульден),
				'other' => q(нідерландського антильського гульдена),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(ангольська кванза),
				'few' => q(ангольські кванзи),
				'many' => q(ангольських кванз),
				'one' => q(ангольська кванза),
				'other' => q(ангольської кванзи),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(ангольська кванза \(1977–1990\)),
				'few' => q(ангольські кванзи \(1977–1990\)),
				'many' => q(ангольських кванз \(1977–1990\)),
				'one' => q(ангольська кванза \(1977–1990\)),
				'other' => q(ангольської кванзи \(1977–1990\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(ангольська нова кванза \(1990–2000\)),
				'few' => q(ангольські нові кванзи \(1990–2000\)),
				'many' => q(ангольських нових кванз \(1990–2000\)),
				'one' => q(ангольська нова кванза \(1990–2000\)),
				'other' => q(ангольської нової кванзи \(1990–2000\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(ангольська кванза реаджастадо \(1995–1999\)),
				'few' => q(ангольські кванзи реаджастадо \(1995–1999\)),
				'many' => q(ангольських кванз реаджастадо \(1995–1999\)),
				'one' => q(ангольська кванза реаджастадо \(1995–1999\)),
				'other' => q(ангольської кванзи реаджастадо \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(аргентинський австрал),
				'few' => q(аргентинські австрали),
				'many' => q(аргентинських австралів),
				'one' => q(аргентинський австрал),
				'other' => q(аргентинського австрала),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(аргентинський песо \(1983–1985\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(аргентинський песо),
				'few' => q(аргентинські песо),
				'many' => q(аргентинських песо),
				'one' => q(аргентинський песо),
				'other' => q(аргентинського песо),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(австрійський шилінг),
			},
		},
		'AUD' => {
			symbol => 'AUD',
			display_name => {
				'currency' => q(австралійський долар),
				'few' => q(австралійські долари),
				'many' => q(австралійських доларів),
				'one' => q(австралійський долар),
				'other' => q(австралійського долара),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(арубський флорин),
				'few' => q(арубські флорини),
				'many' => q(арубських флоринів),
				'one' => q(арубський флорин),
				'other' => q(арубського флорина),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(азербайджанський манат \(1993–2006\)),
				'few' => q(азербайджанські манати \(1993–2006\)),
				'many' => q(азербайджанських манатів \(1993–2006\)),
				'one' => q(азербайджанський манат \(1993–2006\)),
				'other' => q(азербайджанського маната \(1993–2006\)),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(азербайджанський манат),
				'few' => q(азербайджанські манати),
				'many' => q(азербайджанських манатів),
				'one' => q(азербайджанський манат),
				'other' => q(азербайджанського маната),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(динар \(Боснія і Герцеговина\)),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(конвертована марка Боснії і Герцеговини),
				'few' => q(конвертовані марки Боснії і Герцеговини),
				'many' => q(конвертованих марок Боснії і Герцеговини),
				'one' => q(конвертована марка Боснії і Герцеговини),
				'other' => q(конвертованої марки Боснії і Герцеговини),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(барбадоський долар),
				'few' => q(барбадоські долари),
				'many' => q(барбадоських доларів),
				'one' => q(барбадоський долар),
				'other' => q(барбадоського долара),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(бангладеська така),
				'few' => q(бангладеські таки),
				'many' => q(бангладеських так),
				'one' => q(бангладеська така),
				'other' => q(бангладеської таки),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(бельгійський франк \(конвертований\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(бельгійський франк),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(бельгійський франк \(фінансовий\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(болгарський твердий лев),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(болгарський лев),
				'few' => q(болгарські леви),
				'many' => q(болгарських левів),
				'one' => q(болгарський лев),
				'other' => q(болгарського лева),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(бахрейнський динар),
				'few' => q(бахрейнські динари),
				'many' => q(бахрейнських динарів),
				'one' => q(бахрейнський динар),
				'other' => q(бахрейнського динара),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(бурундійський франк),
				'few' => q(бурундійські франки),
				'many' => q(бурундійських франків),
				'one' => q(бурундійський франк),
				'other' => q(бурундійського франка),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(бермудський долар),
				'few' => q(бермудські долари),
				'many' => q(бермудських доларів),
				'one' => q(бермудський долар),
				'other' => q(бермудського долара),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(брунейський долар),
				'few' => q(брунейські долари),
				'many' => q(брунейських доларів),
				'one' => q(брунейський долар),
				'other' => q(брунейського долара),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(болівійський болівіано),
				'few' => q(болівійські болівіано),
				'many' => q(болівійських болівіано),
				'one' => q(болівійський болівіано),
				'other' => q(болівійського болівіано),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(болівійське песо),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(болівійський мвдол),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(бразильське нове крузейро \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(бразильське крузадо),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(бразильське крузейро \(1990–1993\)),
			},
		},
		'BRL' => {
			symbol => 'BRL',
			display_name => {
				'currency' => q(бразильський реал),
				'few' => q(бразильські реали),
				'many' => q(бразильських реалів),
				'one' => q(бразильський реал),
				'other' => q(бразильського реала),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(бразильське нове крузадо),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(бразильське крузейро),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(багамський долар),
				'few' => q(багамські долари),
				'many' => q(багамських доларів),
				'one' => q(багамський долар),
				'other' => q(багамського долара),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(бутанський нгултрум),
				'few' => q(бутанські нгултруми),
				'many' => q(бутанських нгултрумів),
				'one' => q(бутанський нгултрум),
				'other' => q(бутанського нгултрума),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(бірманський кіат),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(ботсванська пула),
				'few' => q(ботсванські пули),
				'many' => q(ботсванських пул),
				'one' => q(ботсванська пула),
				'other' => q(ботсванської пули),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(білоруський новий рубль \(1994–1999\)),
				'few' => q(білоруські нові рублі \(1994–1999\)),
				'many' => q(білоруських нових рублів \(1994–1999\)),
				'one' => q(білоруський новий рубль \(1994–1999\)),
				'other' => q(білоруського нового рубля \(1994–1999\)),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(білоруський рубль),
				'few' => q(білоруські рублі),
				'many' => q(білоруських рублів),
				'one' => q(білоруський рубль),
				'other' => q(білоруського рубля),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(белізький долар),
				'few' => q(белізькі долари),
				'many' => q(белізьких доларів),
				'one' => q(белізький долар),
				'other' => q(белізького долара),
			},
		},
		'CAD' => {
			symbol => 'CAD',
			display_name => {
				'currency' => q(канадський долар),
				'few' => q(канадські долари),
				'many' => q(канадських доларів),
				'one' => q(канадський долар),
				'other' => q(канадського долара),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(конголезький франк),
				'few' => q(конголезькі франки),
				'many' => q(конголезьких франків),
				'one' => q(конголезький франк),
				'other' => q(конголезького франка),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(євро WIR),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(швейцарський франк),
				'few' => q(швейцарські франки),
				'many' => q(швейцарських франків),
				'one' => q(швейцарський франк),
				'other' => q(швейцарського франка),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(франк WIR),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(чилійський юнідадес де фоменто),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(чилійський песо),
				'few' => q(чилійські песо),
				'many' => q(чилійських песо),
				'one' => q(чилійський песо),
				'other' => q(чилійського песо),
			},
		},
		'CNY' => {
			symbol => 'CNY',
			display_name => {
				'currency' => q(китайський юань),
				'few' => q(китайські юані),
				'many' => q(китайських юанів),
				'one' => q(китайський юань),
				'other' => q(китайського юаня),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(колумбійський песо),
				'few' => q(колумбійські песо),
				'many' => q(колумбійських песо),
				'one' => q(колумбійський песо),
				'other' => q(колумбійського песо),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(одиниця реальної вартості),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(костариканський колон),
				'few' => q(костариканські колони),
				'many' => q(костариканських колонів),
				'one' => q(костариканський колон),
				'other' => q(костариканського колона),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(старий сербський динар),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(чехословацька тверда крона),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(кубинський конвертований песо),
				'few' => q(кубинські конвертовані песо),
				'many' => q(кубинських конвертованих песо),
				'one' => q(кубинський конвертований песо),
				'other' => q(кубинського конвертованого песо),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(кубинський песо),
				'few' => q(кубинські песо),
				'many' => q(кубинськх песо),
				'one' => q(кубинський песо),
				'other' => q(кубинського песо),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(ескудо Кабо-Верде),
				'few' => q(ескудо Кабо-Верде),
				'many' => q(ескудо Кабо-Верде),
				'one' => q(ескудо Кабо-Верде),
				'other' => q(ескудо Кабо-Верде),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(кіпрський фунт),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(чеська крона),
				'few' => q(чеські крони),
				'many' => q(чеських крон),
				'one' => q(чеська крона),
				'other' => q(чеської крони),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(марка НДР),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(німецька марка),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(джибутійський франк),
				'few' => q(джибутійські франки),
				'many' => q(джибутійських франків),
				'one' => q(джибутійський франк),
				'other' => q(джибутійського франка),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(данська крона),
				'few' => q(данські крони),
				'many' => q(данських крон),
				'one' => q(данська крона),
				'other' => q(данської крони),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(домініканський песо),
				'few' => q(домініканські песо),
				'many' => q(домініканських песо),
				'one' => q(домініканський песо),
				'other' => q(домініканського песо),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(алжирський динар),
				'few' => q(алжирські динари),
				'many' => q(алжирських динарів),
				'one' => q(алжирський динар),
				'other' => q(алжирського динара),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(еквадорський сукре),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(еквадорський юнідад де валор константе),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(естонська крона),
				'few' => q(естонські крони),
				'many' => q(естонських крон),
				'one' => q(естонська крона),
				'other' => q(естонської крони),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(єгипетський фунт),
				'few' => q(єгипетські фунти),
				'many' => q(єгипетських фунтів),
				'one' => q(єгипетський фунт),
				'other' => q(єгипетського фунта),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(еритрейська накфа),
				'few' => q(еритрейські накфи),
				'many' => q(еритрейських накф),
				'one' => q(еритрейська накфа),
				'other' => q(еритрейської накфи),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(іспанська песета \("А" рахунок\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(іспанська песета \(конвертовані рахунки\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(іспанська песета),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(ефіопський бир),
				'few' => q(ефіопські бири),
				'many' => q(ефіопських бирів),
				'one' => q(ефіопський бир),
				'other' => q(ефіопського бира),
			},
		},
		'EUR' => {
			symbol => 'EUR',
			display_name => {
				'currency' => q(євро),
				'few' => q(євро),
				'many' => q(євро),
				'one' => q(євро),
				'other' => q(євро),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(фінляндська марка),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(фіджійський долар),
				'few' => q(фіджійські долари),
				'many' => q(фіджійських доларів),
				'one' => q(фіджійський долар),
				'other' => q(фіджійського долара),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(фунт Фолклендських островів),
				'few' => q(фунти Фолклендських островів),
				'many' => q(фунтів Фолклендських островів),
				'one' => q(фунт Фолклендських островів),
				'other' => q(фунта Фолклендських островів),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(французький франк),
			},
		},
		'GBP' => {
			symbol => 'GBP',
			display_name => {
				'currency' => q(англійський фунт),
				'few' => q(англійські фунти),
				'many' => q(англійських фунтів),
				'one' => q(англійський фунт),
				'other' => q(англійського фунта),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(грузинський купон),
				'few' => q(грузинські купони),
				'many' => q(грузинських купонів),
				'one' => q(грузинський купон),
				'other' => q(грузинського купона),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(грузинський ларі),
				'few' => q(грузинські ларі),
				'many' => q(грузинських ларі),
				'one' => q(грузинський ларі),
				'other' => q(грузинського ларі),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(ганський седі \(1979–2007\)),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(ганський седі),
				'few' => q(ганські седі),
				'many' => q(ганських седі),
				'one' => q(ганський седі),
				'other' => q(ганського седі),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(гібралтарський фунт),
				'few' => q(гібралтарські фунти),
				'many' => q(гібралтарських фунтів),
				'one' => q(гібралтарський фунт),
				'other' => q(гібралтарського фунта),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(гамбійський даласі),
				'few' => q(гамбійські даласі),
				'many' => q(гамбійських даласі),
				'one' => q(гамбійський даласі),
				'other' => q(гамбійського даласі),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(гвінейський франк),
				'few' => q(гвінейські франки),
				'many' => q(гвінейських франків),
				'one' => q(гвінейський франк),
				'other' => q(гвінейського франка),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(гвінейське сілі),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(еквеле \(Екваторіальна Ґвінея\)),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(грецька драхма),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(гватемальський кетсаль),
				'few' => q(гватемальські кетсалі),
				'many' => q(гватемальських кетсалів),
				'one' => q(гватемальський кетсаль),
				'other' => q(гватемальського кетсаля),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(ескудо португальської гвінеї),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(песо Гвінеї-Бісау),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(гаянський долар),
				'few' => q(гаянські долари),
				'many' => q(гаянських доларів),
				'one' => q(гаянський долар),
				'other' => q(гаянського долара),
			},
		},
		'HKD' => {
			symbol => 'HKD',
			display_name => {
				'currency' => q(гонконгський долар),
				'few' => q(гонконгські долари),
				'many' => q(гонконгських доларів),
				'one' => q(гонконгський долар),
				'other' => q(гонконгського долара),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(гондураська лемпіра),
				'few' => q(гондураські лемпіри),
				'many' => q(гондураських лемпір),
				'one' => q(гондураська лемпіра),
				'other' => q(гондураської лемпіри),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(хорватський динар),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(хорватська куна),
				'few' => q(хорватські куни),
				'many' => q(хорватських кун),
				'one' => q(хорватська куна),
				'other' => q(хорватської куни),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(гаїтянський гурд),
				'few' => q(гаїтянські гурди),
				'many' => q(гаїтянських гурдів),
				'one' => q(гаїтянський гурд),
				'other' => q(гаїтянського гурда),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(угорський форинт),
				'few' => q(угорські форинти),
				'many' => q(угорських форинтів),
				'one' => q(угорський форинт),
				'other' => q(угорського форинта),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(індонезійська рупія),
				'few' => q(індонезійські рупії),
				'many' => q(індонезійських рупій),
				'one' => q(індонезійська рупія),
				'other' => q(індонезійські рупії),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(ірландський фунт),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(ізраїльський фунт),
			},
		},
		'ILS' => {
			symbol => 'ILS',
			display_name => {
				'currency' => q(ізраїльський новий шекель),
				'few' => q(ізраїльські нові шекелі),
				'many' => q(ізраїльських нових шекелів),
				'one' => q(ізраїльський новий шекель),
				'other' => q(ізраїльського нового шекеля),
			},
		},
		'INR' => {
			symbol => 'INR',
			display_name => {
				'currency' => q(індійська рупія),
				'few' => q(індійські рупії),
				'many' => q(індійських рупій),
				'one' => q(індійська рупія),
				'other' => q(індійської рупії),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(іракський динар),
				'few' => q(іракські динари),
				'many' => q(іракських динарів),
				'one' => q(іракський динар),
				'other' => q(іракського динара),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(іранський ріал),
				'few' => q(іранські ріали),
				'many' => q(іранських ріалів),
				'one' => q(іранський ріал),
				'other' => q(іранського ріала),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(ісландська крона),
				'few' => q(ісландські кроні),
				'many' => q(ісландських крон),
				'one' => q(ісландська крона),
				'other' => q(ісландської крони),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(італійська ліра),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(ямайський долар),
				'few' => q(ямайські долари),
				'many' => q(ямайських доларів),
				'one' => q(ямайський долар),
				'other' => q(ямайського долара),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(йорданський динар),
				'few' => q(йорданські динари),
				'many' => q(йорданських динарів),
				'one' => q(йорданський динар),
				'other' => q(йорданського динара),
			},
		},
		'JPY' => {
			symbol => '¥',
			display_name => {
				'currency' => q(японська єна),
				'few' => q(японські єни),
				'many' => q(японських єн),
				'one' => q(японська єна),
				'other' => q(японської єни),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(кенійський шилінг),
				'few' => q(кенійські шилінги),
				'many' => q(кенійських шилінгів),
				'one' => q(кенійський шилінг),
				'other' => q(кенійського шилінга),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(киргизький сом),
				'few' => q(киргизькі соми),
				'many' => q(киргизьких сомів),
				'one' => q(киргизький сом),
				'other' => q(киргизького сома),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(камбоджійський рієль),
				'few' => q(камбоджійські рієлі),
				'many' => q(камбоджійських рієлів),
				'one' => q(камбоджійський рієль),
				'other' => q(камбоджійського рієля),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(коморський франк),
				'few' => q(коморські франки),
				'many' => q(коморських франків),
				'one' => q(коморський франк),
				'other' => q(коморського франка),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(північнокорейський вон),
				'few' => q(північнокорейські вони),
				'many' => q(північнокорейських вонів),
				'one' => q(північнокорейський вон),
				'other' => q(північнокорейського вона),
			},
		},
		'KRW' => {
			symbol => 'KRW',
			display_name => {
				'currency' => q(південнокорейський вон),
				'few' => q(південнокорейські вони),
				'many' => q(південнокорейських вонів),
				'one' => q(південнокорейський вон),
				'other' => q(південнокорейського вона),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(кувейтський динар),
				'few' => q(кувейтські динари),
				'many' => q(кувейтських динарів),
				'one' => q(кувейтський динар),
				'other' => q(кувейтського динара),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(долар Кайманових островів),
				'few' => q(долари Кайманових островів),
				'many' => q(доларів Кайманових островів),
				'one' => q(долар Кайманових островів),
				'other' => q(долара Кайманових островів),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(казахстанський тенге),
				'few' => q(казахстанські тенге),
				'many' => q(казахстанських тенге),
				'one' => q(казахстанський тенге),
				'other' => q(казахстанського тенге),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(лаоський кіп),
				'few' => q(лаоські кіпи),
				'many' => q(лаоських кіпів),
				'one' => q(лаоський кіп),
				'other' => q(лаоського кіпа),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(ліванський фунт),
				'few' => q(ліванські фунти),
				'many' => q(ліванських фунтів),
				'one' => q(ліванський фунт),
				'other' => q(ліванського фунта),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(шрі-ланкійська рупія),
				'few' => q(шрі-ланкійські рупії),
				'many' => q(шрі-ланкійських рупій),
				'one' => q(шрі-ланкійська рупія),
				'other' => q(шрі-ланкійської рупії),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(ліберійський долар),
				'few' => q(ліберійські долари),
				'many' => q(ліберійських доларів),
				'one' => q(ліберійський долар),
				'other' => q(ліберійського долара),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(лесотський лоті),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(литовський літ),
				'few' => q(литовські літи),
				'many' => q(литовських літів),
				'one' => q(литовський літ),
				'other' => q(литовського літа),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(литовський талон),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(люксембурґський франк \(конвертований\)),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(люксембурзький франк),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(люксембурґський франк \(фінансовий\)),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(латвійський лат),
				'few' => q(латвійські лати),
				'many' => q(латвійських латів),
				'one' => q(латвійський лат),
				'other' => q(латвійського лата),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(латвійський рубль),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(лівійський динар),
				'few' => q(лівійські динари),
				'many' => q(лівійських динарів),
				'one' => q(лівійський динар),
				'other' => q(лівійського динара),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(марокканський дирхам),
				'few' => q(марокканські дирхами),
				'many' => q(марокканських дирхамів),
				'one' => q(марокканський дирхам),
				'other' => q(марокканського дирхама),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(марокканський франк),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(молдовський лей),
				'few' => q(молдовські леї),
				'many' => q(молдовських леїв),
				'one' => q(молдовський лей),
				'other' => q(молдовського лея),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(малагасійський аріарі),
				'few' => q(малагасійські аріарі),
				'many' => q(малагасійських аріарі),
				'one' => q(малагасійський аріарі),
				'other' => q(малагасійського аріарі),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(мадагаскарський франк),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(македонський денар),
				'few' => q(македонські денари),
				'many' => q(македонських денарів),
				'one' => q(македонський денар),
				'other' => q(македонського денара),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(малійський франк),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(кʼят Мʼянми),
				'few' => q(кʼяти Мʼянми),
				'many' => q(кʼятів Мʼянми),
				'one' => q(кʼят Мʼянми),
				'other' => q(кʼята Мʼянми),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(монгольський тугрик),
				'few' => q(монгольські тугрики),
				'many' => q(монгольських тугриків),
				'one' => q(монгольський тугрик),
				'other' => q(монгольського тугрика),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(патака Макао),
				'few' => q(патаки Макао),
				'many' => q(патак Макао),
				'one' => q(патака Макао),
				'other' => q(патаки Макао),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(мавританська угія),
				'few' => q(мавританські угії),
				'many' => q(мавританських угій),
				'one' => q(мавританська угія),
				'other' => q(мавританської угії),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(мальтійська ліра),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(мальтійський фунт),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(маврикійська рупія),
				'few' => q(маврикійські рупії),
				'many' => q(маврикійських рупій),
				'one' => q(маврикійська рупія),
				'other' => q(маврикійської рупії),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(мальдівська руфія),
				'few' => q(мальдівські руфії),
				'many' => q(мальдівських руфій),
				'one' => q(мальдівська руфія),
				'other' => q(мальдівської руфії),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(малавійська квача),
				'few' => q(малавійські квачі),
				'many' => q(малавійських квач),
				'one' => q(малавійська квача),
				'other' => q(малавійської квачі),
			},
		},
		'MXN' => {
			symbol => 'MXN',
			display_name => {
				'currency' => q(мексиканський песо),
				'few' => q(мексиканські песо),
				'many' => q(мексиканських песо),
				'one' => q(мексиканський песо),
				'other' => q(мексиканського песо),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(мексиканське срібне песо \(1861–1992\)),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(мексиканський юнідад де інверсіон),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(малайзійський рингіт),
				'few' => q(малайзійські рингіти),
				'many' => q(малайзійських рингітів),
				'one' => q(малайзійський рингіт),
				'other' => q(малайзійського рингіта),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(мозамбіцький ескудо),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(старий мозамбіцький метикал),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(мозамбіцький метикал),
				'few' => q(мозамбіцькі метикали),
				'many' => q(мозамбіцьких метикалів),
				'one' => q(мозамбіцький метикал),
				'other' => q(мозамбіцького метикала),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(намібійський долар),
				'few' => q(намібійські долари),
				'many' => q(намібійських доларів),
				'one' => q(намібійський долар),
				'other' => q(намібійського долара),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(нігерійська найра),
				'few' => q(нігерійські найри),
				'many' => q(нігерійських найр),
				'one' => q(нігерійська найра),
				'other' => q(нігерійської найри),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(нікарагуанська кордоба \(1988–1991\)),
				'few' => q(нікарагуанські кордоби \(1988–1991\)),
				'many' => q(нікарагуанських кордоб \(1988–1991\)),
				'one' => q(нікарагуанська кордоба \(1988–1991\)),
				'other' => q(нікарагуанської кордоби \(1988–1991\)),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(нікарагуанська кордоба),
				'few' => q(нікарагуанські кордоби),
				'many' => q(нікарагуанських кордоб),
				'one' => q(нікарагуанська кордоба),
				'other' => q(нікарагуанської кордоби),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(нідерландський гульден),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(норвезька крона),
				'few' => q(норвезькі крони),
				'many' => q(норвезьких крон),
				'one' => q(норвезька крона),
				'other' => q(норвезької крони),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(непальська рупія),
				'few' => q(непальські рупії),
				'many' => q(непальських рупій),
				'one' => q(непальська рупія),
				'other' => q(непальської рупії),
			},
		},
		'NZD' => {
			symbol => 'NZD',
			display_name => {
				'currency' => q(новозеландський долар),
				'few' => q(новозеландські долари),
				'many' => q(новозеландських доларів),
				'one' => q(новозеландський долар),
				'other' => q(новозеландського долара),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(оманський ріал),
				'few' => q(оманські ріали),
				'many' => q(оманських ріалів),
				'one' => q(оманський ріал),
				'other' => q(оманського ріала),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(панамська бальбоа),
				'few' => q(панамські бальбоа),
				'many' => q(панамських бальбоа),
				'one' => q(панамська бальбоа),
				'other' => q(панамського бальбоа),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(перуанський інті),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(перуанський новий сол),
				'few' => q(перуанські нові соли),
				'many' => q(перуанських нових солів),
				'one' => q(перуанський новий сол),
				'other' => q(перуанського нового сола),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(перуанський сол),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(кіна Папуа Нової Гвінеї),
				'few' => q(кіни Папуа Нової Гвінеї),
				'many' => q(кін Папуа Нової Гвінеї),
				'one' => q(кіна Папуа Нової Гвінеї),
				'other' => q(кіни Папуа Нової Гвінеї),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(філіппінський песо),
				'few' => q(філіппінські песо),
				'many' => q(філіппінських песо),
				'one' => q(філіппінський песо),
				'other' => q(філіппінського песо),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(пакистанська рупія),
				'few' => q(пакистанські рупії),
				'many' => q(пакистанських рупій),
				'one' => q(пакистанська рупія),
				'other' => q(пакистанської рупії),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(польський злотий),
				'few' => q(польські злоті),
				'many' => q(польських злотих),
				'one' => q(польський злотий),
				'other' => q(польського злотого),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(польський злотий \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(португальський ескудо),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(парагвайський гуарані),
				'few' => q(парагвайські гуарані),
				'many' => q(парагвайських гуарані),
				'one' => q(парагвайський гуарані),
				'other' => q(парагвайського гуарані),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(катарський ріал),
				'few' => q(катарські ріали),
				'many' => q(катарських ріалів),
				'one' => q(катарський ріал),
				'other' => q(катарського ріала),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(родезійський долар),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(старий румунський лей),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(румунський лей),
				'few' => q(румунські леї),
				'many' => q(румунських леїв),
				'one' => q(румунський лей),
				'other' => q(румунського лея),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(сербський динар),
				'few' => q(сербські динари),
				'many' => q(сербських динарів),
				'one' => q(сербський динар),
				'other' => q(сербського динара),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(російський рубль),
				'few' => q(російські рублі),
				'many' => q(російських рублів),
				'one' => q(російський рубль),
				'other' => q(російського рубля),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(російський рубль \(1991–1998\)),
				'few' => q(російські рублі \(RUR\)),
				'many' => q(російських рублів \(RUR\)),
				'one' => q(російський рубль \(RUR\)),
				'other' => q(російського рубля \(RUR\)),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(руандійський франк),
				'few' => q(руандійські франки),
				'many' => q(руандійських франків),
				'one' => q(руандійський франк),
				'other' => q(руандійського франка),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(саудівський ріал),
				'few' => q(саудівські ріали),
				'many' => q(саудівських ріалів),
				'one' => q(саудівський ріал),
				'other' => q(саудівського ріала),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(долар Соломонових Островів),
				'few' => q(долари Соломонових Островів),
				'many' => q(доларів Соломонових Островів),
				'one' => q(долар Соломонових Островів),
				'other' => q(долара Соломонових Островів),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(сейшельська рупія),
				'few' => q(сейшельські рупії),
				'many' => q(сейшельських рупій),
				'one' => q(сейшельська рупія),
				'other' => q(сейшельської рупії),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(суданський динар),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(суданський фунт),
				'few' => q(суданські фунти),
				'many' => q(суданських фунтів),
				'one' => q(суданський фунт),
				'other' => q(суданського фунта),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(старий суданський фунт),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(шведська крона),
				'few' => q(шведські крони),
				'many' => q(шведських крон),
				'one' => q(шведська крона),
				'other' => q(шведської крони),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(сінгапурський долар),
				'few' => q(сінгапурські долари),
				'many' => q(сінгапурських доларів),
				'one' => q(сінгапурський долар),
				'other' => q(сінгапурського долара),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(фунт острова Святої Єлени),
				'few' => q(фунти острова Святої Єлени),
				'many' => q(фунтів острова Святої Єлени),
				'one' => q(фунт острова Святої Єлени),
				'other' => q(фунта острова Святої Єлени),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(словенський толар),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(словацька крона),
				'few' => q(словацькі крони),
				'many' => q(словацьких крон),
				'one' => q(словацька крона),
				'other' => q(словацької крони),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(леоне Сьєрра-Леоне),
				'few' => q(леоне Сьєрра-Леоне),
				'many' => q(леоне Сьєрра-Леоне),
				'one' => q(леоне Сьєрра-Леоне),
				'other' => q(леоне Сьєрра-Леоне),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(сомалійський шилінг),
				'few' => q(сомалійські шилінги),
				'many' => q(сомалійських шилінгів),
				'one' => q(сомалійський шилінг),
				'other' => q(сомалійського шилінга),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(суринамський долар),
				'few' => q(суринамські долари),
				'many' => q(суринамських доларів),
				'one' => q(суринамський долар),
				'other' => q(суринамського долара),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(суринамський гульден),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(південносуданський фунт),
				'few' => q(південносуданські фунти),
				'many' => q(південносуданських фунтів),
				'one' => q(південносуданський фунт),
				'other' => q(південносуданського фунта),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(добра Сан-Томе і Принсіпі),
				'few' => q(добри Сан-Томе і Принсіпі),
				'many' => q(добр Сан-Томе і Принсіпі),
				'one' => q(добра Сан-Томе і Принсіпі),
				'other' => q(добри Сан-Томе і Принсіпі),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(радянський рубль),
				'few' => q(радянські рублі),
				'many' => q(радянських рублів),
				'one' => q(радянський рубль),
				'other' => q(радянського рубля),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(сальвадорський колон),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(сирійський фунт),
				'few' => q(сирійські фунти),
				'many' => q(сирійських фунтів),
				'one' => q(сирійський фунт),
				'other' => q(сирійського фунта),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(свазілендський лілангені),
				'few' => q(свазілендські лілангені),
				'many' => q(свазілендських лілангені),
				'one' => q(свазілендський лілангені),
				'other' => q(свазілендського лілангені),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(таїландський бат),
				'few' => q(таїландські бати),
				'many' => q(таїландських батів),
				'one' => q(таїландський бат),
				'other' => q(таїландського бата),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(таджицький рубль),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(таджицький сомоні),
				'few' => q(таджицькі сомоні),
				'many' => q(таджицьких сомоні),
				'one' => q(таджицький сомоні),
				'other' => q(таджицького сомоні),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(туркменський манат \(1993–2009\)),
				'few' => q(туркменські манати \(1993–2009\)),
				'many' => q(туркменських манатів \(1993–2009\)),
				'one' => q(туркменський манат \(1993–2009\)),
				'other' => q(туркменського маната \(1993–2009\)),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(туркменський манат),
				'few' => q(туркменські манати),
				'many' => q(туркменських манатів),
				'one' => q(туркменський манат),
				'other' => q(туркменського маната),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(туніський динар),
				'few' => q(туніські динари),
				'many' => q(туніських динарів),
				'one' => q(туніський динар),
				'other' => q(туніського динара),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(тонганська паанга),
				'few' => q(тонганські паанги),
				'many' => q(тонганських паанг),
				'one' => q(тонганська паанга),
				'other' => q(тонганської паанги),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(тіморський ескудо),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(турецька ліра \(1922–2005\)),
				'few' => q(турецькі ліри \(1922–2005\)),
				'many' => q(турецьких лір \(1922–2005\)),
				'one' => q(турецька ліра \(1922–2005\)),
				'other' => q(турецької ліри \(1922–2005\)),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(турецька ліра),
				'few' => q(турецькі ліри),
				'many' => q(турецьких лір),
				'one' => q(турецька ліра),
				'other' => q(турецької ліри),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(долар Тринідаду і Тобаго),
				'few' => q(долари Тринідаду і Тобаго),
				'many' => q(доларів Тринідаду і Тобаго),
				'one' => q(долар Тринідаду і Тобаго),
				'other' => q(долара Тринідаду і Тобаго),
			},
		},
		'TWD' => {
			symbol => 'TWD',
			display_name => {
				'currency' => q(новий тайванський долар),
				'few' => q(нові тайванські долари),
				'many' => q(нових тайванських доларів),
				'one' => q(новий тайванський долар),
				'other' => q(нового тайванського долара),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(танзанійський шилінг),
				'few' => q(танзанійські шилінги),
				'many' => q(танзанійських шилінгів),
				'one' => q(танзанійський шилінг),
				'other' => q(танзанійського шилінга),
			},
		},
		'UAH' => {
			symbol => '₴',
			display_name => {
				'currency' => q(українська гривня),
				'few' => q(гривні),
				'many' => q(гривень),
				'one' => q(гривня),
				'other' => q(гривні),
			},
		},
		'UAK' => {
			symbol => 'крб.',
			display_name => {
				'currency' => q(український карбованець),
				'few' => q(українські карбованці),
				'many' => q(українських карбованців),
				'one' => q(український карбованець),
				'other' => q(українського карбованця),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(угандійський шилінг \(1966–1987\)),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(угандійський шилінг),
				'few' => q(угандійські шилінги),
				'many' => q(угандійських шилінгів),
				'one' => q(угандійський шилінг),
				'other' => q(угандійського шилінга),
			},
		},
		'USD' => {
			symbol => 'USD',
			display_name => {
				'currency' => q(долар США),
				'few' => q(долари США),
				'many' => q(доларів США),
				'one' => q(долар США),
				'other' => q(долара США),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(долар США \(наступного дня\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(долар США \(цього дня\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(уругвайський песо в індексованих одиницях),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(уругвайське песо \(1975–1993\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(уругвайський песо),
				'few' => q(уругвайські песо),
				'many' => q(уругвайських песо),
				'one' => q(уругвайський песо),
				'other' => q(уругвайського песо),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(узбецький сум),
				'few' => q(узбецькі суми),
				'many' => q(узбецьких сумів),
				'one' => q(узбецький сум),
				'other' => q(узбецького сума),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(венесуельський болівар \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(венесуельський болівар),
				'few' => q(венесуельські болівари),
				'many' => q(венесуельських боліварів),
				'one' => q(венесуельський болівар),
				'other' => q(венесуельського болівара),
			},
		},
		'VND' => {
			symbol => 'VND',
			display_name => {
				'currency' => q(вʼєтнамський донг),
				'few' => q(вʼєтнамські донги),
				'many' => q(вʼєтнамських донгів),
				'one' => q(вʼєтнамський донг),
				'other' => q(вʼєтнамського донга),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(вануатський вату),
				'few' => q(вануатські вату),
				'many' => q(вануатських вату),
				'one' => q(вануатський вату),
				'other' => q(вануатського вату),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(самоанська тала),
				'few' => q(самоанські тали),
				'many' => q(самоанських тал),
				'one' => q(самоанська тала),
				'other' => q(самоанської тали),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(центральноафриканський франк),
				'few' => q(центральноафриканські франки),
				'many' => q(центральноафриканських франків),
				'one' => q(центральноафриканський франк),
				'other' => q(центральноафриканського франка),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(срібло),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(золото),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(європейська складена валютна одиниця),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(одиниця європейського валютного фонду),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(європейська розрахункова одиниця XBC),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(європейська розрахункова одиниця XBD),
			},
		},
		'XCD' => {
			symbol => 'XCD',
			display_name => {
				'currency' => q(східнокарибський долар),
				'few' => q(східнокарибські долари),
				'many' => q(східнокарибських доларів),
				'one' => q(східнокарибський долар),
				'other' => q(східнокарибського долара),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(спеціальні права запозичення),
				'few' => q(СПЗ),
				'many' => q(СПЗ),
				'one' => q(СПЗ),
				'other' => q(СПЗ),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(європейська валютна одиниця),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(французький золотий франк),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(французький франк UIC),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(західноафриканський франк),
				'few' => q(західноафриканські франки),
				'many' => q(західноафриканських франків),
				'one' => q(західноафриканський франк),
				'other' => q(західноафриканського франка),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(паладій),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(французький тихоокеанський франк),
				'few' => q(французькі тихоокеанські франки),
				'many' => q(французьких тихоокеанських франків),
				'one' => q(французький тихоокеанський франк),
				'other' => q(французького тихоокеанського франка),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(платина),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(фонди RINET),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(код тестування валюти),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(невідома грошова одиниця),
				'few' => q(невідомі грошові одиниці),
				'many' => q(невідомих грошових одиниць),
				'one' => q(невідома грошова одиниця),
				'other' => q(невідомої грошової одиниці),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(єменський динар),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(єменський ріал),
				'few' => q(єменські ріали),
				'many' => q(єменських ріалів),
				'one' => q(єменський ріал),
				'other' => q(єменського ріала),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(югославський твердий динар),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(югославський новий динар),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(югославський конвертований динар),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(південноафриканський фінансовий ранд),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(південноафриканський ранд),
				'few' => q(південноафриканські ранди),
				'many' => q(південноафриканських рандів),
				'one' => q(південноафриканський ранд),
				'other' => q(південноафриканського ранда),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(замбійська квача \(1968–2012\)),
				'few' => q(замбійські квачі \(1968–2012\)),
				'many' => q(замбійських квач \(1968–2012\)),
				'one' => q(замбійська квача \(1968–2012\)),
				'other' => q(замбійські квачі \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(замбійська квача),
				'few' => q(замбійські квачі),
				'many' => q(замбійських квач),
				'one' => q(замбійська квача),
				'other' => q(замбійської квачі),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(заїрський новий заїр),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(заїрський заїр),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(зімбабвійський долар),
				'few' => q(зімбабвійскі долари),
				'many' => q(зімбабвійських доларів),
				'one' => q(зімбабвійського долара),
				'other' => q(зімбабвійські долари),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(зімбабвійський долар \(2009\)),
				'few' => q(зімбабвійські долари \(2009\)),
				'many' => q(зімбабвійських доларів \(2009\)),
				'one' => q(зімбабвійський долар \(2009\)),
				'other' => q(зімбабвійського долара \(2009\)),
			},
		},
		'ZWR' => {
			display_name => {
				'few' => q(зімбабвійські долари \(2008\)),
				'many' => q(зімбабвійських доларів \(2008\)),
				'one' => q(зімбабвійський долар \(2008\)),
				'other' => q(зімбабвійського долара \(2008\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'тот',
							'баб.',
							'хат.',
							'кіх.',
							'тоб.',
							'амш.',
							'барам.',
							'барм.',
							'баш.',
							'баун.',
							'аб.',
							'мис.',
							'нас.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Тот',
							'Бабе',
							'Хатур',
							'Кіхак',
							'Тобе',
							'Амшир',
							'Барамхат',
							'Бармуда',
							'Башнас',
							'Бауна',
							'Абіб',
							'Мисра',
							'Насі'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'Тот',
							'Баб',
							'Хат',
							'Кіх',
							'Тоб',
							'Амш',
							'Барам',
							'Барм',
							'Баш',
							'Баун',
							'Аб',
							'Мис',
							'Нас'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'мес.',
							'тек.',
							'хед.',
							'тах.',
							'тер.',
							'єкат.',
							'мег.',
							'міяз.',
							'ген.',
							'сен.',
							'хам.',
							'нех.',
							'паг.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'01',
							'02',
							'03',
							'04',
							'05',
							'06',
							'07',
							'08',
							'09',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'мескерема',
							'текемта',
							'хедара',
							'тахсаса',
							'тера',
							'єкатіта',
							'мегабіта',
							'міязія',
							'генбота',
							'сене',
							'хамле',
							'нехасе',
							'пагумена'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'мес.',
							'тек.',
							'хед.',
							'тах.',
							'тер.',
							'єкат.',
							'мег.',
							'міяз.',
							'ген.',
							'сен.',
							'хам.',
							'нех.',
							'паг.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'01',
							'02',
							'03',
							'04',
							'05',
							'06',
							'07',
							'08',
							'09',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'мескерема',
							'Текемт',
							'хедара',
							'тахсаса',
							'тера',
							'єкатіта',
							'мегабіта',
							'міязія',
							'генбота',
							'сене',
							'хамле',
							'нехасе',
							'пагумена'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'січ.',
							'лют.',
							'бер.',
							'квіт.',
							'трав.',
							'черв.',
							'лип.',
							'серп.',
							'вер.',
							'жовт.',
							'лист.',
							'груд.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'С',
							'Л',
							'Б',
							'К',
							'Т',
							'Ч',
							'Л',
							'С',
							'В',
							'Ж',
							'Л',
							'Г'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'січня',
							'лютого',
							'березня',
							'квітня',
							'травня',
							'червня',
							'липня',
							'серпня',
							'вересня',
							'жовтня',
							'листопада',
							'грудня'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'Січ',
							'Лют',
							'Бер',
							'Кві',
							'Тра',
							'Чер',
							'Лип',
							'Сер',
							'Вер',
							'Жов',
							'Лис',
							'Гру'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'С',
							'Л',
							'Б',
							'К',
							'Т',
							'Ч',
							'Л',
							'С',
							'В',
							'Ж',
							'Л',
							'Г'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'січень',
							'лютий',
							'березень',
							'квітень',
							'травень',
							'червень',
							'липень',
							'серпень',
							'вересень',
							'жовтень',
							'листопад',
							'грудень'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					wide => {
						nonleap => [
							'Тішри',
							'Марчешван',
							'Числьов',
							'Тебет',
							'Шеват',
							'Адар I',
							'Адар',
							'Нісан',
							'Іар',
							'Сиван',
							'Таммуз',
							'Аб',
							'Елул'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'Адар II'
						],
					},
				},
				'stand-alone' => {
					wide => {
						nonleap => [
							'Тішри',
							'Хешван',
							'Кіслев',
							'Тевет',
							'Шват',
							'Адар I',
							'Адар',
							'Нісан',
							'Іяр',
							'Сиван',
							'Таммуз',
							'Ав',
							'Елул'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'Адар II'
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'чайт.',
							'вайс.',
							'джай.',
							'асад.',
							'шрав.',
							'бхад.',
							'асв.',
							'кар.',
							'агр.',
							'паус.',
							'маг.',
							'фаль.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'чайтра',
							'вайсакха',
							'джайстха',
							'асадха',
							'шравана',
							'бхадра',
							'асвіна',
							'картіка',
							'аграхаяна',
							'пауса',
							'магха',
							'фальгуна'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'чайт.',
							'вайс.',
							'джай.',
							'асад.',
							'шрав.',
							'бхад.',
							'асв.',
							'кар.',
							'агр.',
							'паус.',
							'маг.',
							'фаль.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'чайтра',
							'вайсакха',
							'джайстха',
							'асадха',
							'шравана',
							'бхадра',
							'асвіна',
							'картіка',
							'аграхаяна',
							'пауса',
							'магха',
							'фальгуна'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'мух.',
							'саф.',
							'рабі I',
							'рабі II',
							'джум. I',
							'джум. II',
							'радж.',
							'шааб.',
							'рам.',
							'дав.',
							'зу-ль-к.',
							'зу-ль-х.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Мухаррам',
							'Сафар',
							'Рабі I',
							'Рабі II',
							'Джумада I',
							'Джумада II',
							'Раджаб',
							'Шаабан',
							'Рамадан',
							'Даввал',
							'Зу-ль-каада',
							'Зу-ль-хіджа'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'Мух',
							'Саф',
							'Рабі I',
							'Рабі II',
							'Джум I',
							'Джум II',
							'Радж',
							'Шааб',
							'Рам',
							'Дав',
							'Зу-ль-к',
							'Зу-ль-х'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'фар.',
							'орд.',
							'хор.',
							'тір',
							'мор.',
							'шах.',
							'мех.',
							'абан',
							'азер',
							'дей',
							'бах.',
							'есф.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Фарвардін',
							'Ордібехешт',
							'Хордад',
							'Тір',
							'Мордад',
							'Шахрівер',
							'Мехр',
							'Абан',
							'Азер',
							'Дей',
							'Бахман',
							'Есфанд'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'Фар',
							'Орд',
							'Хор',
							'Тір',
							'Мор',
							'Шах',
							'Мех',
							'Абан',
							'Азер',
							'Дей',
							'Бах',
							'Есф'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'Пн',
						tue => 'Вт',
						wed => 'Ср',
						thu => 'Чт',
						fri => 'Пт',
						sat => 'Сб',
						sun => 'Нд'
					},
					narrow => {
						mon => 'П',
						tue => 'В',
						wed => 'С',
						thu => 'Ч',
						fri => 'П',
						sat => 'С',
						sun => 'Н'
					},
					short => {
						mon => 'Пн',
						tue => 'Вт',
						wed => 'Ср',
						thu => 'Чт',
						fri => 'Пт',
						sat => 'Сб',
						sun => 'Нд'
					},
					wide => {
						mon => 'понеділок',
						tue => 'вівторок',
						wed => 'середа',
						thu => 'четвер',
						fri => 'пʼятниця',
						sat => 'субота',
						sun => 'неділя'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'Пн',
						tue => 'Вт',
						wed => 'Ср',
						thu => 'Чт',
						fri => 'Пт',
						sat => 'Сб',
						sun => 'Нд'
					},
					narrow => {
						mon => 'П',
						tue => 'В',
						wed => 'С',
						thu => 'Ч',
						fri => 'П',
						sat => 'С',
						sun => 'Н'
					},
					short => {
						mon => 'Пн',
						tue => 'Вт',
						wed => 'Ср',
						thu => 'Чт',
						fri => 'Пт',
						sat => 'Сб',
						sun => 'Нд'
					},
					wide => {
						mon => 'понеділок',
						tue => 'вівторок',
						wed => 'середа',
						thu => 'четвер',
						fri => 'пʼятниця',
						sat => 'субота',
						sun => 'неділя'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1-й кв.',
						1 => '2-й кв.',
						2 => '3-й кв.',
						3 => '4-й кв.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-й квартал',
						1 => '2-й квартал',
						2 => '3-й квартал',
						3 => '4-й квартал'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => '1-й кв.',
						1 => '2-й кв.',
						2 => '3-й кв.',
						3 => '4-й кв.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-й квартал',
						1 => '2-й квартал',
						2 => '3-й квартал',
						3 => '4-й квартал'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	traits		=> ['Code'],
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	handles		=> { call => 'execute_method' },
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'persian') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time > 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'night1' if $time > 0
						&& $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time > 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'night1' if $time > 0
						&& $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time > 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'night1' if $time > 0
						&& $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
				}
				last SWITCH;
				}
			if ($_ eq 'japanese') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time > 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'night1' if $time > 0
						&& $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time > 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'night1' if $time > 0
						&& $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time > 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'night1' if $time > 0
						&& $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time > 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'night1' if $time > 0
						&& $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time > 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'night1' if $time > 0
						&& $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time > 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'night1' if $time > 0
						&& $time < 400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
				}
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
				}
				last SWITCH;
				}
		}
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'midnight' => q{північ},
					'night1' => q{ночі},
					'noon' => q{пополудні},
					'morning1' => q{ранку},
					'pm' => q{пп},
					'evening1' => q{вечора},
					'afternoon1' => q{дня},
					'am' => q{дп},
				},
				'wide' => {
					'pm' => q{пп},
					'morning1' => q{ранку},
					'midnight' => q{північ},
					'noon' => q{пополудні},
					'night1' => q{ночі},
					'am' => q{дп},
					'afternoon1' => q{дня},
					'evening1' => q{вечора},
				},
				'narrow' => {
					'night1' => q{ночі},
					'noon' => q{п},
					'midnight' => q{північ},
					'morning1' => q{ранку},
					'pm' => q{пп},
					'evening1' => q{вечора},
					'afternoon1' => q{дня},
					'am' => q{дп},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'am' => q{дп},
					'pm' => q{пп},
					'morning1' => q{ранок},
					'afternoon1' => q{день},
					'evening1' => q{вечір},
					'noon' => q{полудень},
					'night1' => q{ніч},
				},
				'wide' => {
					'pm' => q{пп},
					'am' => q{дп},
					'night1' => q{ніч},
					'noon' => q{полудень},
					'evening1' => q{вечір},
					'afternoon1' => q{день},
					'morning1' => q{ранок},
				},
				'narrow' => {
					'pm' => q{пп},
					'am' => q{дп},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'ethiopic' => {
			abbreviated => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
			narrow => {
				'1' => 'ERA1'
			},
			wide => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'до н. е.',
				'1' => 'н. е.'
			},
			narrow => {
				'0' => 'до н.е.',
				'1' => 'н.е.'
			},
			wide => {
				'0' => 'до нашої ери',
				'1' => 'нашої ери'
			},
		},
		'hebrew' => {
		},
		'indian' => {
			abbreviated => {
				'0' => 'Saka'
			},
			narrow => {
				'0' => 'Saka'
			},
			wide => {
				'0' => 'Saka'
			},
		},
		'islamic' => {
		},
		'japanese' => {
			abbreviated => {
				'0' => 'Тайка (645–650)',
				'1' => 'Хакуті (650–671)',
				'2' => 'Хакухо (672–686)',
				'3' => 'Сютьо (686–701)',
				'4' => 'Тайхо (701–704)',
				'5' => 'Кейун (704–708)',
				'6' => 'Вадо (708–715)',
				'7' => 'Рейкі (715–717)',
				'8' => 'Йоро (717–724)',
				'9' => 'Дзінгі (724–729)',
				'10' => 'Темпьо (729–749)',
				'11' => 'Темпьо-кампо (749–749)',
				'12' => 'Темпьо-сьохо (749–757)',
				'13' => 'Темпьо-ходзі (757–765)',
				'14' => 'Темпьо-дзінго (765–767)',
				'15' => 'Дзінго кейун (767–770)',
				'16' => 'Хокі (770–780)',
				'17' => 'Тен’о (781–782)',
				'18' => 'Енряку (782–806)',
				'19' => 'Дайдо (806–810)',
				'20' => 'Конін (810–824)',
				'21' => 'Тентьо (824–834)',
				'22' => 'Сьова (834–848)',
				'23' => 'Кадзьо (848–851)',
				'24' => 'Ніндзю (851–854)',
				'25' => 'Сайко (854–857)',
				'26' => 'Теннан (857–859)',
				'27' => 'Дзьоган (859–877)',
				'28' => 'Генкей (877–885)',
				'29' => 'Нінна (885–889)',
				'30' => 'Кампьо (889–898)',
				'31' => 'Сьотай (898–901)',
				'32' => 'Енгі (901–923)',
				'33' => 'Ентьо (923–931)',
				'34' => 'Сьохей (931–938)',
				'35' => 'Тенгьо (938–947)',
				'36' => 'Тенряку (947–957)',
				'37' => 'Тентоку (957–961)',
				'38' => 'Ова (961–964)',
				'39' => 'Кохо (964–968)',
				'40' => 'Анна (968–970)',
				'41' => 'Тенроку (970–973)',
				'42' => 'Тен’ен (973–976)',
				'43' => 'Дзьоген (976–978)',
				'44' => 'Тенген (978–983)',
				'45' => 'Ейкан (983–985)',
				'46' => 'Канна (985–987)',
				'47' => 'Ейен (987–989)',
				'48' => 'Ейсо (989–990)',
				'49' => 'Сьоряку (990–995)',
				'50' => 'Тьотоку (995–999)',
				'51' => 'Тьохо (999–1004)',
				'52' => 'Канко (1004–1012)',
				'53' => 'Тьова (1012–1017)',
				'54' => 'Каннін (1017–1021)',
				'55' => 'Дзіан (1021–1024)',
				'56' => 'Мандзю (1024–1028)',
				'57' => 'Тьоген (1028–1037)',
				'58' => 'Тьоряку (1037–1040)',
				'59' => 'Тьокю (1040–1044)',
				'60' => 'Кантоку (1044–1046)',
				'61' => 'Ейсьо (1046–1053)',
				'62' => 'Тенгі (1053–1058)',
				'63' => 'Кохей (1058–1065)',
				'64' => 'Дзіряку (1065–1069)',
				'65' => 'Енкю (1069–1074)',
				'66' => 'Сьохо (1074–1077)',
				'67' => 'Сьоряку (1077–1081)',
				'68' => 'Ейхо (1081–1084)',
				'69' => 'Отоку (1084–1087)',
				'70' => 'Кандзі (1087–1094)',
				'71' => 'Кахо (1094–1096)',
				'72' => 'Ейсьо (1096–1097)',
				'73' => 'Сьотоку (1097–1099)',
				'74' => 'Кова (1099–1104)',
				'75' => 'Тьодзі (1104–1106)',
				'76' => 'Кадзьо (1106–1108)',
				'77' => 'Теннін (1108–1110)',
				'78' => 'Тен’ей (1110–1113)',
				'79' => 'Ейкю (1113–1118)',
				'80' => 'Ген’ей (1118–1120)',
				'81' => 'Хоан (1120–1124)',
				'82' => 'Тендзі (1124–1126)',
				'83' => 'Дайдзі (1126–1131)',
				'84' => 'Тенсьо (1131–1132)',
				'85' => 'Тьосьо (1132–1135)',
				'86' => 'Хоен (1135–1141)',
				'87' => 'Ейдзі (1141–1142)',
				'88' => 'Кодзі (1142–1144)',
				'89' => 'Теньо (1144–1145)',
				'90' => 'Кюан (1145–1151)',
				'91' => 'Німпей (1151–1154)',
				'92' => 'Кюдзю (1154–1156)',
				'93' => 'Хоген (1156–1159)',
				'94' => 'Хейдзі (1159–1160)',
				'95' => 'Ейряку (1160–1161)',
				'96' => 'Охо (1161–1163)',
				'97' => 'Тьокан (1163–1165)',
				'98' => 'Ейман (1165–1166)',
				'99' => 'Нін’ан (1166–1169)',
				'100' => 'Као (1169–1171)',
				'101' => 'Сьоан (1171–1175)',
				'102' => 'Анген (1175–1177)',
				'103' => 'Дзісьо (1177–1181)',
				'104' => 'Йова (1181–1182)',
				'105' => 'Дзюей (1182–1184)',
				'106' => 'Генряку (1184–1185)',
				'107' => 'Бундзі (1185–1190)',
				'108' => 'Кенкю (1190–1199)',
				'109' => 'Сьодзі (1199–1201)',
				'110' => 'Кеннін (1201–1204)',
				'111' => 'Генкю (1204–1206)',
				'112' => 'Кен’ей (1206–1207)',
				'113' => 'Сьоген (1207–1211)',
				'114' => 'Кенряку (1211–1213)',
				'115' => 'Кенпо (1213–1219)',
				'116' => 'Дзьокю (1219–1222)',
				'117' => 'Дзьоо (1222–1224)',
				'118' => 'Геннін (1224–1225)',
				'119' => 'Кароку (1225–1227)',
				'120' => 'Антей (1227–1229)',
				'121' => 'Канкі (1229–1232)',
				'122' => 'Дзюей (1232–1233)',
				'123' => 'Темпуку (1233–1234)',
				'124' => 'Бунряку (1234–1235)',
				'125' => 'Катей (1235–1238)',
				'126' => 'Рякунін (1238–1239)',
				'127' => 'Ен’о (1239–1240)',
				'128' => 'Ніндзі (1240–1243)',
				'129' => 'Канген (1243–1247)',
				'130' => 'Хейдзі (1247–1249)',
				'131' => 'Кентьо (1249–1256)',
				'132' => 'Коген (1256–1257)',
				'133' => 'Сьока (1257–1259)',
				'134' => 'Сьоген (1259–1260)',
				'135' => 'Бун’о (1260–1261)',
				'136' => 'Котьо (1261–1264)',
				'137' => 'Бун’ей (1264–1275)',
				'138' => 'Кендзі (1275–1278)',
				'139' => 'Коан (1278–1288)',
				'140' => 'Сьоо (1288–1293)',
				'141' => 'Ейнін (1293–1299)',
				'142' => 'Сьоан (1299–1302)',
				'143' => 'Кенген (1302–1303)',
				'144' => 'Каген (1303–1306)',
				'145' => 'Токудзі (1306–1308)',
				'146' => 'Енкей (1308–1311)',
				'147' => 'Отьо (1311–1312)',
				'148' => 'Сьова (1312–1317)',
				'149' => 'Бумпо (1317–1319)',
				'150' => 'Ген’о (1319–1321)',
				'151' => 'Генкьо (1321–1324)',
				'152' => 'Сьотю (1324–1326)',
				'153' => 'Карекі (1326–1329)',
				'154' => 'Гентоку (1329–1331)',
				'155' => 'Генко (1331–1334)',
				'156' => 'Кемму (1334–1336)',
				'157' => 'Ейген (1336–1340)',
				'158' => 'Кококу (1340–1346)',
				'159' => 'Сьохей (1346–1370)',
				'160' => 'Кентоку (1370–1372)',
				'161' => 'Бунтю (1372–1375)',
				'162' => 'Тендзю (1375–1379)',
				'163' => 'Коряку (1379–1381)',
				'164' => 'Кова (1381–1384)',
				'165' => 'Гентю (1384–1392)',
				'166' => 'Мейтоку (1384–1387)',
				'167' => 'Какей (1387–1389)',
				'168' => 'Коо (1389–1390)',
				'169' => 'Мейтоку (1390–1394)',
				'170' => 'Оей (1394–1428)',
				'171' => 'Сьотьо (1428–1429)',
				'172' => 'Ейкьо (1429–1441)',
				'173' => 'Какіцу (1441–1444)',
				'174' => 'Буннан (1444–1449)',
				'175' => 'Хотоку (1449–1452)',
				'176' => 'Кьотоку (1452–1455)',
				'177' => 'Косьо (1455–1457)',
				'178' => 'Тьороку (1457–1460)',
				'179' => 'Кансьо (1460–1466)',
				'180' => 'Бунсьо (1466–1467)',
				'181' => 'Онін (1467–1469)',
				'182' => 'Буммей (1469–1487)',
				'183' => 'Тьокьо (1487–1489)',
				'184' => 'Ентоку (1489–1492)',
				'185' => 'Мейо (1492–1501)',
				'186' => 'Бункі (1501–1504)',
				'187' => 'Ейсьо (1504–1521)',
				'188' => 'Тайей (1521–1528)',
				'189' => 'Кьороку (1528–1532)',
				'190' => 'Теммон (1532–1555)',
				'191' => 'Кодзі (1555–1558)',
				'192' => 'Ейроку (1558–1570)',
				'193' => 'Генкі (1570–1573)',
				'194' => 'Тенсьо (1573–1592)',
				'195' => 'Бунроку (1592–1596)',
				'196' => 'Кейтьо (1596–1615)',
				'197' => 'Генна (1615–1624)',
				'198' => 'Кан’ей (1624–1644)',
				'199' => 'Сьохо (1644–1648)',
				'200' => 'Кейан (1648–1652)',
				'201' => 'Сьоо (1652–1655)',
				'202' => 'Мейряку (1655–1658)',
				'203' => 'Мандзі (1658–1661)',
				'204' => 'Камбун (1661–1673)',
				'205' => 'Емпо (1673–1681)',
				'206' => 'Тенва (1681–1684)',
				'207' => 'Дзьокьо (1684–1688)',
				'208' => 'Генроку (1688–1704)',
				'209' => 'Хоей (1704–1711)',
				'210' => 'Сьотоку (1711–1716)',
				'211' => 'Кьохо (1716–1736)',
				'212' => 'Гембун (1736–1741)',
				'213' => 'Канпо (1741–1744)',
				'214' => 'Енкьо (1744–1748)',
				'215' => 'Кан’ен (1748–1751)',
				'216' => 'Хоряку (1751–1764)',
				'217' => 'Мейва (1764–1772)',
				'218' => 'Ан’ей (1772–1781)',
				'219' => 'Теммей (1781–1789)',
				'220' => 'Кансей (1789–1801)',
				'221' => 'Кьова (1801–1804)',
				'222' => 'Бунка (1804–1818)',
				'223' => 'Бунсей (1818–1830)',
				'224' => 'Тенпо (1830–1844)',
				'225' => 'Кока (1844–1848)',
				'226' => 'Каей (1848–1854)',
				'227' => 'Ансей (1854–1860)',
				'228' => 'Ман’ен (1860–1861)',
				'229' => 'Бункю (1861–1864)',
				'230' => 'Гендзі (1864–1865)',
				'231' => 'Кейо (1865–1868)',
				'232' => 'Мейдзі',
				'233' => 'Тайсьо',
				'234' => 'Сьова',
				'235' => 'Хейсей'
			},
		},
		'persian' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE, d MMMM y 'р'. G},
			'long' => q{d MMMM y 'р'. G},
			'medium' => q{d MMM y G},
			'short' => q{dd.MM.yy GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM y 'р'.},
			'long' => q{d MMMM y 'р'.},
			'medium' => q{d MMM y 'р'.},
			'short' => q{dd.MM.yy},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} 'о' {0}},
			'long' => q{{1} 'о' {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} 'о' {0}},
			'long' => q{{1} 'о' {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			E => q{ccc},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E, d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{LLL y G},
			GyMMMEd => q{E, d MMM y G},
			GyMMMd => q{d MMM y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{LL},
			MEd => q{E, dd.MM},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMEd => q{E, d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{MM.y},
			yMEd => q{E, dd.MM.y},
			yMMM => q{LLL y},
			yMMMEd => q{E, d MMM y},
			yMMMM => q{LLLL y},
			yMMMd => q{d MMM y},
			yMd => q{dd.MM.y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y 'р'.},
		},
		'generic' => {
			E => q{ccc},
			Ed => q{E, d},
			Gy => q{y G},
			GyMMM => q{LLL y G},
			GyMMMEd => q{E, d MMM y G},
			GyMMMd => q{d MMM y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, dd.MM},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMEd => q{E, d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{MM.y G},
			yyyyMEd => q{E, dd.MM.y G},
			yyyyMMM => q{LLL y G},
			yyyyMMMEd => q{E, d MMM y G},
			yyyyMMMM => q{LLLL y G},
			yyyyMMMd => q{d MMM y G},
			yyyyMd => q{dd.MM.y G},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y 'р'. G},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.MM – E, dd.MM},
				d => q{E, dd.MM – E, dd.MM},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{dd.MM – dd.MM},
				d => q{dd.MM – dd.MM},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{MM.y – MM.y},
				y => q{MM.y – MM.y},
			},
			yMEd => {
				M => q{E, dd.MM.y – E, dd.MM.y},
				d => q{E, dd.MM.y – E, dd.MM.y},
				y => q{E, dd.MM.y – E, dd.MM.y},
			},
			yMMM => {
				M => q{LLL–LLL y},
				y => q{LLL y – LLL y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y},
				d => q{E, d – E, d MMM y},
				y => q{E, d MMM y – E, d MMM y},
			},
			yMMMM => {
				M => q{LLLL – LLLL y},
				y => q{LLLL y – LLLL y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d–d MMM y},
				y => q{d MMM y – d MMM y},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y},
				d => q{dd.MM.y – dd.MM.y},
				y => q{dd.MM.y – dd.MM.y},
			},
		},
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.MM – E, dd.MM},
				d => q{E, dd.MM – E, dd.MM},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{dd.MM – dd.MM},
				d => q{dd.MM – dd.MM},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{MM.y – MM.y},
				y => q{MM.y – MM.y},
			},
			yMEd => {
				M => q{E, dd.MM.y – E, dd.MM.y},
				d => q{E, dd.MM.y – E, dd.MM.y},
				y => q{E, dd.MM.y – E, dd.MM.y},
			},
			yMMM => {
				M => q{LLL–LLL y},
				y => q{LLL y – LLL y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y},
				d => q{E, d – E, d MMM y},
				y => q{E, d MMM y – E, d MMM y},
			},
			yMMMM => {
				M => q{LLLL – LLLL y},
				y => q{LLLL y – LLLL y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d–d MMM y},
				y => q{d MMM y – d MMM y},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y},
				d => q{dd.MM.y – dd.MM.y},
				y => q{dd.MM.y – dd.MM.y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(час: {0}),
		regionFormat => q(час: {0}, літній),
		regionFormat => q(час: {0}, стандартний),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q(час: Акрі, літній),
				'generic' => q(час: Акрі),
				'standard' => q(час: Акрі, стандартний),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(за часом в Афганістані),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абіджан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Аккра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Аддис-Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмара#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Бангі#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бісау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантир#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Браззавіль#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Бужумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каїр#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Касабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакрі#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар-ес-Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Джибуті#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Ель-Аюн#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фрітаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Йоганнесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Джуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Хартум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кігалі#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Кіншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Лібревіль#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаші#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуту#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишо#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровія#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Найробі#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нджамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Ніамей#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто-Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сан-Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполі#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Туніс#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Віндгук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(за центральноафриканським часом),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(за східноафриканським часом),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(за південноафриканським часом),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(за західноафриканським літнім часом),
				'generic' => q(за західноафриканським часом),
				'standard' => q(за західноафриканським стандартним часом),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(за літнім часом на Алясці),
				'generic' => q(за часом на Алясці),
				'standard' => q(за стандартним часом на Алясці),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(за літнім часом на Амазонці),
				'generic' => q(за часом на Амазонці),
				'standard' => q(за стандартним часом на Амазонці),
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Анкоридж#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангілья#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигуа#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагуайна#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла-Ріоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Ріо-Гальєгос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Сальта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан-Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан-Луїс#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуая#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсьйон#,
		},
		'America/Bahia' => {
			exemplarCity => q#Байя#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Баїя Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белен#,
		},
		'America/Belize' => {
			exemplarCity => q#Беліз#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Саблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа-Віста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бойсе#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буенос-Айрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кембридж-Бей#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампу-Гранді#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Каєнна#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кайманові острови#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чіуауа#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Корал-Гарбор#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордоба#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Коста-Рика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куяба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кюрасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Денмарксхавн#,
		},
		'America/Dawson' => {
			exemplarCity => q#Доусон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Доусон-Крік#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детройт#,
		},
		'America/Dominica' => {
			exemplarCity => q#Домініка#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Едмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Ейрунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Сальвадор#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глейс-Бей#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нуук#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гуз-Бей#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд-Терк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гваделупа#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гуаякіль#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гаяна#,
		},
		'America/Halifax' => {
			exemplarCity => q#Галіфакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Гавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Ермосільйо#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Індіана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Індіана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Пітерсберг, Індіана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Телл Сіті, Індіана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вівей, Індіана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Вінсенс, Індіана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Вінамак, Індіана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Індіанаполіс#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Інувік#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Ікалуїт#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Ямайка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуй#,
		},
		'America/Juneau' => {
			exemplarCity => q#Джуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтічелло, Кентуккі#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендейк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла-Пас#,
		},
		'America/Lima' => {
			exemplarCity => q#Ліма#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос-Анджелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луїсвілл#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Лоуер-Принсес-Квотер#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масейо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагуа#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Маріго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиніка#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Масатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоса#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меноміні#,
		},
		'America/Merida' => {
			exemplarCity => q#Меріда#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мехіко#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Мікелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтерей#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевідео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монсеррат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Насау#,
		},
		'America/New_York' => {
			exemplarCity => q#Нью-Йорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Ніпігон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Норонья#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Б’юла, Північна Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Центр, Північна Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нью-Салем, Північна Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охінага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангніртанг#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Фінікс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт-оф-Спейн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порту-Велью#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Пуерто-Рико#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рейні-Рівер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ренкін-Інлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресіфі#,
		},
		'America/Regina' => {
			exemplarCity => q#Реджайна#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резолют#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Ріо-Бранко#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Санта-Ісабель#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарен#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантьяго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто-Домінго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сан-Паулу#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Іттоккортоорміут#,
		},
		'America/Sitka' => {
			exemplarCity => q#Сітка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сен-Бартельмі#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент-Джонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент-Кітс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Сент-Люсія#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент-Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент-Вінсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свіфт-Каррент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусігальпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Тандер-Бей#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тіхуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Вайтгорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Вінніпег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Якутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Єллоунайф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(за північноамериканським центральним літнім часом),
				'generic' => q(за північноамериканським центральним часом),
				'standard' => q(за північноамериканським центральним стандартним часом),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(за північноамериканським східним літнім часом),
				'generic' => q(за північноамериканським східним часом),
				'standard' => q(за північноамериканським східним стандартним часом),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(за північноамериканським гірським літнім часом),
				'generic' => q(за північноамериканським гірським часом),
				'standard' => q(за північноамериканським гірським стандартним часом),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(за північноамериканським тихоокеанським літнім часом),
				'generic' => q(за північноамериканським тихоокеанським часом),
				'standard' => q(за північноамериканським тихоокеанським стандартним часом),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(час: Анадир, літній),
				'generic' => q(час: Анадир),
				'standard' => q(час: Анадир, стандартний),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кейсі#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Девіс#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Дюмон-дʼЮрвіль#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маккуорі#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Моусон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Мак-Мердо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Сьова#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Тролл#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q(за літнім часом в Апіа),
				'generic' => q(за часом в Апіа),
				'standard' => q(за стандартним часом в Апіа),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(за арабським літнім часом),
				'generic' => q(за арабським часом),
				'standard' => q(за арабським стандартним часом),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонг’їр#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(за літнім аргентинським часом),
				'generic' => q(за аргентинським часом),
				'standard' => q(за стандартним аргентинським часом),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(за літнім за західноаргентинським часом),
				'generic' => q(за західноаргентинським часом),
				'standard' => q(за стандартним західноаргентинським часом),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(за вірменським літнім часом),
				'generic' => q(за вірменським часом),
				'standard' => q(за вірменським стандартним часом),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алмати#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Амман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадир#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Актобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашгабат#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахрейн#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бейрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бішкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Бруней#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Колката#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Чита#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чойбалсан#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дакка#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Ділі#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубаї#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеврон#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Гонконг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Іркутськ#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Джакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Джайпур#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Єрусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачі#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандига#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Красноярськ#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала-Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучінг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувейт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макассар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Маніла#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Маскат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Нікосія#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузнецьк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибірськ#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омськ#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пномпень#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтіанак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пхеньян#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кизилорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Янгон#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Ер-Ріяд#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хошимін#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалін#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шанхай#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сінгапур#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Середньоколимськ#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тайбей#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбілісі#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Тегеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тхімпху#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токіо#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан-Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Урумчі#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Усть-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#В’єнтьян#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Якутськ#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Єкатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Єреван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(за атлантичним літнім часом),
				'generic' => q(за атлантичним часом),
				'standard' => q(за атлантичним стандартним часом),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азорські острови#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуди#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канари#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Кабо-Верде#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарерські острови#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадейра#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рейкʼявік#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Південна Джорджія#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Острів Святої Єлени#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стенлі#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаїда#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Брісбен#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен-Хілл#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Каррі#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвін#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Евкла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Гобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Ліндеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд-Хау#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мельбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сідней#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(за літнім центральноавстралійським часом),
				'generic' => q(за центральноавстралійським часом),
				'standard' => q(за стандартним центральноавстралійським часом),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(за літнім центральнозахідним австралійським часом),
				'generic' => q(за центральнозахідним австралійським часом),
				'standard' => q(за стандартним центральнозахідним австралійським часом),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(за літнім східноавстралійським часом),
				'generic' => q(за східноавстралійським часом),
				'standard' => q(за стандартним східноавстралійським часом),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(за літнім західноавстралійським часом),
				'generic' => q(за західноавстралійським часом),
				'standard' => q(за стандартним західноавстралійським часом),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(за літнім часом в Азербайджані),
				'generic' => q(за часом в Азербайджані),
				'standard' => q(за стандартним часом в Азербайджані),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(за літнім часом на Азорських островах),
				'generic' => q(за часом на Азорських островах),
				'standard' => q(за стандартним часом на Азорських островах),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(за літнім часом у Бангладеш),
				'generic' => q(за часом у Бангладеш),
				'standard' => q(за стандартним часом у Бангладеш),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(за часом у Бутані),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(за болівійським часом),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(за літнім бразильським часом),
				'generic' => q(за бразильським часом),
				'standard' => q(за стандартним бразильським часом),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(за часом у Брунеї),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(за літнім часом на островах Кабо-Верде),
				'generic' => q(за часом на островах Кабо-Верде),
				'standard' => q(за стандартним часом на островах Кабо-Верде),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(за часом на Північних Маріанських островах),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(за літнім часом на архіпелазі Чатем),
				'generic' => q(за часом на архіпелазі Чатем),
				'standard' => q(за стандартним часом на архіпелазі Чатем),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(за літнім чилійським часом),
				'generic' => q(за чилійським часом),
				'standard' => q(за стандартним чилійським часом),
			},
		},
		'China' => {
			long => {
				'daylight' => q(за китайським літнім часом),
				'generic' => q(за китайським часом),
				'standard' => q(за китайським стандартним часом),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(за літнім часом у Чойбалсан),
				'generic' => q(за часом у Чойбалсан),
				'standard' => q(за стандартним часом у Чойбалсан),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(за часом на острові Різдва),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(за часом на Кокосових островах),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(за літнім колумбійським часом),
				'generic' => q(за колумбійським часом),
				'standard' => q(за стандартним колумбійським часом),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(за літнім часом на островах Кука),
				'generic' => q(за часом на островах Кука),
				'standard' => q(за стандартним часом на островах Кука),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(за літнім часом на Кубі),
				'generic' => q(за часом на Кубі),
				'standard' => q(за стандартним часом на Кубі),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(за часом у Девіс),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(за часом у Дюмон д’Юрвіль),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(за часом у Східному Тиморі),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(за літнім часом на острові Пасхи),
				'generic' => q(за часом на острові Пасхи),
				'standard' => q(за стандартним часом на острові Пасхи),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(за часом в Еквадорі),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Невідоме місто#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андорра#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Афіни#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлін#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брюссель#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Бухарест#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будапешт#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бюзінген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинів#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенгаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Дублін#,
			long => {
				'daylight' => q(за літнім часом в Ірландії),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гібралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернсі#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Гельсінкі#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Острів Мен#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Стамбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Джерсі#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калінінград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Київ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лісабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Любляна#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q(за літнім часом у Великій Британії),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Люксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Мальта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Марієгамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Мінськ#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париж#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгориця#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан-Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараєво#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Сімферополь#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скоп’є#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Софія#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокгольм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Таллінн#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуц#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Відень#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вільнюс#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запоріжжя#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цюрих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(за центральноєвропейським літнім часом),
				'generic' => q(за центральноєвропейським часом),
				'standard' => q(за центральноєвропейським стандартним часом),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(за східноєвропейським літнім часом),
				'generic' => q(за східноєвропейським часом),
				'standard' => q(за східноєвропейським стандартним часом),
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q(за далекосхідним європейським часом),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(за західноєвропейським літнім часом),
				'generic' => q(за західноєвропейським часом),
				'standard' => q(за західноєвропейським стандартним часом),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(за літнім часом на Фолклендських островах),
				'generic' => q(за часом на Фолклендських островах),
				'standard' => q(за стандартним часом на Фолклендських островах),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(за літнім часом на островах Фіджі),
				'generic' => q(за часом на островах Фіджі),
				'standard' => q(за стандартним часом на островах Фіджі),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(за часом Французької Гвіани),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(за часом на Французьких Південних і Антарктичних територіях),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(за Гринвічем),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(за часом на Галапагоських островах),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(за часом на острові Гамб’є),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(за літнім часом у Грузії),
				'generic' => q(за часом у Грузії),
				'standard' => q(за стандартним часом у Грузії),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(за часом на островах Гілберта),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(за літнім східним часом у Гренландії),
				'generic' => q(за східним часом у Гренландії),
				'standard' => q(за стандартним східним часом у Гренландії),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(за літнім західним часом у Гренландії),
				'generic' => q(за західним часом у Гренландії),
				'standard' => q(за стандартним західним часом у Гренландії),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(за часом на острові Гуам),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(за часом Перської затоки),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(за часом у Гаяні),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(за літнім гавайсько-алеутським часом),
				'generic' => q(за гавайсько-алеутським часом),
				'standard' => q(за стандартним гавайсько-алеутським часом),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(за літнім часом у Гонконзі),
				'generic' => q(за часом у Гонконзі),
				'standard' => q(за стандартним часом у Гонконзі),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(за літнім часом у Ховді),
				'generic' => q(за часом у Ховді),
				'standard' => q(за стандартним часом у Ховді),
			},
		},
		'India' => {
			long => {
				'standard' => q(за індійським стандартним часом),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананаріву#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Острів Різдва#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокосові острови#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморські острови#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Махе#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Мальдіви#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маврикій#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Майотта#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реюньйон#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(за часом в Індійському Океані),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(за часом в Індокитаї),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(за центральноіндонезійським часом),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(за східноіндонезійським часом),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(за західноіндонезійським часом),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(за іранським літнім часом),
				'generic' => q(за іранським часом),
				'standard' => q(за іранським стандартним часом),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(за іркутським літнім часом),
				'generic' => q(за іркутським часом),
				'standard' => q(за іркутським стандартним часом),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(за ізраїльським літнім часом),
				'generic' => q(за ізраїльським часом),
				'standard' => q(за ізраїльським стандартним часом),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(за японським літнім часом),
				'generic' => q(за японським часом),
				'standard' => q(за японським стандартним часом),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(за камчатським літнім часом),
				'generic' => q(за камчатським часом),
				'standard' => q(за камчатським стандартним часом),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(за східним часом у Казахстані),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(за західним часом у Казахстані),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(за корейським літнім часом),
				'generic' => q(за корейським часом),
				'standard' => q(за корейським стандартним часом),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(за часом на острові Косрае),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(за красноярським літнім часом),
				'generic' => q(за красноярським часом),
				'standard' => q(за красноярським стандартним часом),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(за часом у Киргизстані),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(час: Ланка),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(за часом на острові Лайн),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(за літнім часом на острові Лорд-Хау),
				'generic' => q(за часом на острові Лорд-Хау),
				'standard' => q(за стандартним часом на острові Лорд-Хау),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(за часом на острові Маккуорі),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(за магаданським літнім часом),
				'generic' => q(за магаданським часом),
				'standard' => q(за магаданським стандартним часом),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(за часом у Малайзії),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(за часом на Мальдівах),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(за часом на Маркізьких островах),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(за часом на Маршалових Островах),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(за літнім часом на острові Маврикій),
				'generic' => q(за часом на острові Маврикій),
				'standard' => q(за стандартним часом на острові Маврикій),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(за часом на станції Моусон),
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q(за літнім північнозахідним часом у Мексиці),
				'generic' => q(за північнозахідним часом у Мексиці),
				'standard' => q(за стандартним північнозахідним часом у Мексиці),
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q(за літнім тихоокеанським часом у Мексиці),
				'generic' => q(за тихоокеанським часом у Мексиці),
				'standard' => q(за стандартним тихоокеанським часом у Мексиці),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(за літнім часом в Улан-Баторі),
				'generic' => q(за часом в Улан-Баторі),
				'standard' => q(за стандартним часом в Улан-Баторі),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(за московським літнім часом),
				'generic' => q(за московським часом),
				'standard' => q(за московським стандартним часом),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(за часом у М’янмі),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(за часом на острові Науру),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(за часом у Непалі),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(за літнім часом на островах Нової Каледонії),
				'generic' => q(за часом на островах Нової Каледонії),
				'standard' => q(за стандартним часом на островах Нової Каледонії),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(за літнім часом у Новій Зеландії),
				'generic' => q(за часом у Новій Зеландії),
				'standard' => q(за стандартним часом у Новій Зеландії),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(за літнім часом у Ньюфаундленд),
				'generic' => q(за часом у Ньюфаундленд),
				'standard' => q(за стандартним часом у Ньюфаундленд),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(за часом на острові Ніуе),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(за часом на острові Норфолк),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(за літнім часом на архіпелазі Фернанду-ді-Норонья),
				'generic' => q(за часом на архіпелазі Фернанду-ді-Норонья),
				'standard' => q(за стандартним часом на архіпелазі Фернанду-ді-Норонья),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(за новосибірським літнім часом),
				'generic' => q(за новосибірським часом),
				'standard' => q(за новосибірським стандартним часом),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(за омським літнім часом),
				'generic' => q(за омським часом),
				'standard' => q(за омським стандартним часом),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апіа#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окленд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Бугенвіль#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатем#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Острів Пасхи#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Ефате#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Ендербері#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фіджі#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафуті#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагоські острови#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбер#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гвадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Гонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Джонстон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Кірітіматі#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Косрае#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваджалейн#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Маджуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркізькі острови#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мідвей#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ніуе#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго-Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Піткерн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понапе#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт-Морсбі#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сайпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Таїті#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Трук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Вейк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Волліс#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(за літнім часом у Пакистані),
				'generic' => q(за часом у Пакистані),
				'standard' => q(за стандартним часом у Пакистані),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(за часом на острові Палау),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(за часом на островах Папуа Нова Гвінея),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(за літнім парагвайським часом),
				'generic' => q(за парагвайським часом),
				'standard' => q(за стандартним парагвайським часом),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(за літнім часом у Перу),
				'generic' => q(за часом у Перу),
				'standard' => q(за стандартним часом у Перу),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(за літнім часом на Філіппінах),
				'generic' => q(за часом на Філіппінах),
				'standard' => q(за стандартним часом на Філіппінах),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(за часом на островах Фенікс),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(за літнім часом на островах Сен-П’єр і Мікелон),
				'generic' => q(за часом на островах Сен-П’єр і Мікелон),
				'standard' => q(за стандартним часом на островах Сен-П’єр і Мікелон),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(за часом на островах Піткерн),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(за часом на острові Понапе),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(час: Кизилорда, літній),
				'generic' => q(час: Кизилорда),
				'standard' => q(час: Кизилорда, стандартний),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(за часом на острові Реюньйон),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(за часом на станції Ротера),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(за сахалінським літнім часом),
				'generic' => q(за сахалінським часом),
				'standard' => q(за сахалінським стандартним часом),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(за самарським літнім часом),
				'generic' => q(за самарським часом),
				'standard' => q(за самарським стандартним часом),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(за літнім часом на острові Самоа),
				'generic' => q(за часом на острові Самоа),
				'standard' => q(за стандартним часом на острові Самоа),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(за часом на Сейшельських Островах),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(за часом у Сінгапурі),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(за часом на Соломонових островах),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(за часом на острові Південна Джорджія),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(за часом у Суринамі),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(за часом на станції Сева),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(за часом на острові Таїті),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(за літнім часом у Тайбеї),
				'generic' => q(за часом у Тайбеї),
				'standard' => q(за стандартним часом у Тайбеї),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(за часом у Таджикистані),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(за часом на островах Токелау),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(за літнім часом на островах Тонга),
				'generic' => q(за часом на островах Тонга),
				'standard' => q(за стандартним часом на островах Тонга),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(за часом на островах Чуук),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(за літнім часом у Туркменістані),
				'generic' => q(за часом у Туркменістані),
				'standard' => q(за стандартним часом у Туркменістані),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(за часом на островах Тувалу),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(за літнім часом в Уругваї),
				'generic' => q(за часом в Уругваї),
				'standard' => q(за стандартним часом в Уругваї),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(за літнім часом в Узбекистані),
				'generic' => q(за часом в Узбекистані),
				'standard' => q(за стандартним часом в Узбекистані),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(за літнім часом на островах Вануату),
				'generic' => q(за часом на островах Вануату),
				'standard' => q(за стандартним часом на островах Вануату),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(за часом у Венесуелі),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(за владивостоцьким літнім часом),
				'generic' => q(за владивостоцьким часом),
				'standard' => q(за владивостоцьким стандартним часом),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(за волгоградським літнім часом),
				'generic' => q(за волгоградським часом),
				'standard' => q(за волгоградським стандартним часом),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(за часом на станції Восток),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(за часом на острові Вейк),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(за часом на островах Волліс і Футуна),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(за якутським літнім часом),
				'generic' => q(за якутським часом),
				'standard' => q(за якутським стандартним часом),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(за єкатеринбурзьким літнім часом),
				'generic' => q(за єкатеринбурзьким часом),
				'standard' => q(за єкатеринбурзьким стандартним часом),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
