=encoding utf8

=head1

Locale::CLDR::Locales::Kok - Package for language Konkani

=cut

package Locale::CLDR::Locales::Kok;
# This file auto generated from Data\common\main\kok.xml
#	on Sun 16 Dec  4:24:11 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'अफार',
 				'ab' => 'अबखेज़ियन',
 				'ace' => 'अचायनीज',
 				'ada' => 'अडांग्मे',
 				'ady' => 'अडिघे',
 				'af' => 'अफ्रिकान्स',
 				'agq' => 'अघेम',
 				'ain' => 'आयनू',
 				'ak' => 'अकान',
 				'ale' => 'आलिट',
 				'alt' => 'दक्षिणी अल्टाय',
 				'am' => 'अमहारिक्',
 				'an' => 'आरागोनिस',
 				'anp' => 'अंगिका',
 				'ar' => 'अरेबिक',
 				'ar_001' => 'आधुनिक प्रमाणित अरेबिक',
 				'arn' => 'मापुचे',
 				'arp' => 'अरापाहो',
 				'as' => 'आसामी',
 				'asa' => 'असु',
 				'ast' => 'अस्टुरियान',
 				'av' => 'अवारिक',
 				'awa' => 'अवधी',
 				'ay' => 'ऐमरा',
 				'az' => 'अज़रबैजानी',
 				'az@alt=short' => 'अझेरी',
 				'ba' => 'बष्किर',
 				'ban' => 'बालिनिस',
 				'bas' => 'बस्सा',
 				'be' => 'बैलोरुसियन्',
 				'bem' => 'बेम्बा',
 				'bez' => 'बेना',
 				'bg' => 'बल्गेरियन',
 				'bho' => 'भोजपुरी',
 				'bi' => 'बिसलमा',
 				'bin' => 'बिनी',
 				'bla' => 'सिकसिका',
 				'bm' => 'बंबारा',
 				'bn' => 'बांग्ला',
 				'bo' => 'तिबेतियन',
 				'br' => 'ब्रेटन',
 				'brx' => 'बोडो',
 				'bs' => 'बोस्नियन',
 				'bug' => 'बगिनिस',
 				'byn' => 'ब्लीन',
 				'ca' => 'कटलान',
 				'ce' => 'चिचेन',
 				'ceb' => 'सिबौना',
 				'cgg' => 'चिगा',
 				'ch' => 'चामोर्रो',
 				'chk' => 'छुनिस',
 				'chm' => 'मारी',
 				'cho' => 'चोताव',
 				'chr' => 'चिरोकी',
 				'chy' => 'चेयनी',
 				'ckb' => 'मध्य खुर्दीश',
 				'co' => 'कोर्शियन',
 				'crs' => 'सेसेल्वा क्रयॉल फ्रेन्च',
 				'cs' => 'चेक',
 				'cu' => 'चर्च स्लेव्हीक',
 				'cv' => 'छुवास',
 				'cy' => 'वेळ्ष्',
 				'da' => 'डॅनिश',
 				'dak' => 'डाकोटा',
 				'dar' => 'दार्ग्वा',
 				'dav' => 'तायता',
 				'de' => 'जर्मन',
 				'de_AT' => 'ऑस्ट्रियन जर्मन',
 				'de_CH' => 'स्वीझ म्हान जर्मन',
 				'dgr' => 'डोगरीब',
 				'dje' => 'झर्मा',
 				'dsb' => 'लोवर सोर्बियन',
 				'dua' => 'डौल',
 				'dv' => 'दिवेही',
 				'dyo' => 'जोला-फोनी',
 				'dz' => 'झोंग्खा',
 				'dzg' => 'डाझागा',
 				'ebu' => 'एम्बु',
 				'ee' => 'एव',
 				'efi' => 'एफीक',
 				'eka' => 'एकाजुक',
 				'el' => 'ग्रीक्',
 				'en' => 'इंग्लीश',
 				'en_AU' => 'ऑस्ट्रेलियन इंग्लीश',
 				'en_CA' => 'कॅनाडीयन इंग्लीश',
 				'en_GB' => 'ब्रिटीश इंग्लीश',
 				'en_GB@alt=short' => 'युके इंग्लीश',
 				'en_US' => 'अमेरिकन इंग्लीश',
 				'en_US@alt=short' => 'युएस इंग्लीश',
 				'eo' => 'इस्परान्टो',
 				'es' => 'स्पॅनिश',
 				'es_419' => 'लॅटिन अमेरिकन स्पॅनिश',
 				'es_ES' => 'युरोपियन स्पॅनिश',
 				'es_MX' => 'मेक्सिकन स्पॅनिश',
 				'et' => 'इस्टोनियन्',
 				'eu' => 'बास्क',
 				'ewo' => 'एवोंडो',
 				'fa' => 'पर्षियन्',
 				'ff' => 'फुला',
 				'fi' => 'फिन्निष्',
 				'fil' => 'फिलिपिनो',
 				'fj' => 'फिजी',
 				'fo' => 'फेरोस्',
 				'fon' => 'फोन',
 				'fr' => 'फ्रेन्च',
 				'fr_CA' => 'कॅनाडीयन फ्रेन्च',
 				'fr_CH' => 'स्वीझ फ्रेन्च',
 				'fur' => 'फ्रिलियन',
 				'fy' => 'पश्चिमी फ्रिशियन',
 				'ga' => 'ऐरिष',
 				'gaa' => 'गा',
 				'gd' => 'स्काटस् गेलिक्',
 				'gez' => 'गेझ',
 				'gil' => 'गिलबर्टीस',
 				'gl' => 'गेलीशियन',
 				'gn' => 'गौरानी',
 				'gor' => 'गोरोंटालो',
 				'gsw' => 'स्विज जर्मन',
 				'gu' => 'गुजराती',
 				'guz' => 'गुसी',
 				'gv' => 'मॅन्स',
 				'gwi' => 'ग्विच',
 				'ha' => 'हौसा',
 				'haw' => 'हवायियान',
 				'he' => 'हिब्रू',
 				'hi' => 'हिन्दी',
 				'hil' => 'हिलीगायनॉन',
 				'hmn' => 'मोंग',
 				'hr' => 'क्रोयेषियन्',
 				'hsb' => 'अपर सोर्बियन',
 				'ht' => 'हैतियन क्रेयॉल',
 				'hu' => 'हंगेरियन्',
 				'hup' => 'हुपा',
 				'hy' => 'आर्मेनियन',
 				'hz' => 'हिरिरो',
 				'ia' => 'इन्टरलिंग्वा',
 				'iba' => 'आयबन',
 				'ibb' => 'ईबिबियो',
 				'id' => 'इंडोनेशियन',
 				'ie' => 'इन्टरलिंग्',
 				'ig' => 'इग्बो',
 				'ii' => 'सिच्युआन यी',
 				'ik' => 'इनूपेयाक्',
 				'ilo' => 'लोको',
 				'inh' => 'इंगूश',
 				'io' => 'इदो',
 				'is' => 'आईस्लान्डिक',
 				'it' => 'इटालियन',
 				'iu' => 'इन्युकट्ट',
 				'ja' => 'जपानी',
 				'jbo' => 'लोबजान',
 				'jgo' => 'न्गोंबा',
 				'jmc' => 'मचामे',
 				'jv' => 'जावनीस्',
 				'ka' => 'जार्जियन्',
 				'kab' => 'काबायले',
 				'kac' => 'काचीन',
 				'kaj' => 'जु',
 				'kam' => 'कंबा',
 				'kbd' => 'काबार्डियन',
 				'kcg' => 'त्याप',
 				'kde' => 'माकोंडे',
 				'kea' => 'काबुवर्डियनु',
 				'kfo' => 'कोरो',
 				'kha' => 'खासी',
 				'khq' => 'कोयरा छिनी',
 				'ki' => 'किकुयु',
 				'kj' => 'कुयांमा',
 				'kk' => 'कज़ख्',
 				'kkj' => 'काको',
 				'kl' => 'कालाल्लिसुट',
 				'kln' => 'कालेंजीन',
 				'km' => 'कंबोडियन',
 				'kmb' => 'किंबुंडु',
 				'kn' => 'कन्नडा',
 				'ko' => 'कोरियन्',
 				'kok' => 'कोंकणी',
 				'kpe' => 'पेल्ले',
 				'kr' => 'कानुरी',
 				'krc' => 'कराची-बाल्कर',
 				'krl' => 'कारेलियन',
 				'kru' => 'कुरुख',
 				'ks' => 'कश्मीरी',
 				'ksb' => 'शंबाला',
 				'ksf' => 'बाफिया',
 				'ksh' => 'कोलोनियन',
 				'ku' => 'कुर्दिष',
 				'kum' => 'कुमयक',
 				'kv' => 'कोमी',
 				'kw' => 'कोर्निश',
 				'ky' => 'किर्गिज़',
 				'la' => 'लाटिन',
 				'lad' => 'लाडिनो',
 				'lag' => 'लांगी',
 				'lb' => 'लक्सेमबर्गीश',
 				'lez' => 'लेझघियान',
 				'lg' => 'गांडा',
 				'li' => 'लिंबुर्ग',
 				'lkt' => 'लाकोटा',
 				'ln' => 'लिंगाला',
 				'lo' => 'लाओ',
 				'loz' => 'लोझीं',
 				'lrc' => 'उत्तरीय लुरी',
 				'lt' => 'लिथुआनियन्',
 				'lu' => 'लुबा-काटांगा',
 				'lua' => 'लुबा-लुलुआ',
 				'lun' => 'लुंडा',
 				'luo' => 'लुओ',
 				'lus' => 'मिझो',
 				'luy' => 'लुय',
 				'lv' => 'लाट्वियन् (लेट्टिष्)',
 				'mad' => 'मादुरेसे',
 				'mag' => 'मगाही',
 				'mai' => 'मैथिली',
 				'mak' => 'माक',
 				'mas' => 'मसाई',
 				'mdf' => 'मोक्ष',
 				'men' => 'मेंडे',
 				'mer' => 'मेरू',
 				'mfe' => 'मोरिसेन',
 				'mg' => 'मलागसी',
 				'mgh' => 'माखुवा-मिट्टो',
 				'mgo' => 'मेटा',
 				'mh' => 'मार्शली',
 				'mi' => 'मुरी',
 				'mic' => 'मिक्माक',
 				'min' => 'मिनाग्काबौ',
 				'mk' => 'मसीडोनियन्',
 				'ml' => 'मळियाळम',
 				'mn' => 'मंगोलियन्',
 				'mni' => 'मणिपुरी',
 				'moh' => 'मोहाक',
 				'mos' => 'मोस्सी',
 				'mr' => 'मराठी',
 				'ms' => 'मलय',
 				'mt' => 'मालतीस्',
 				'mua' => 'मुडांग',
 				'mul' => 'साबार भाशा',
 				'mus' => 'क्रिक',
 				'mwl' => 'मिरांडीस',
 				'my' => 'बर्मीज़्',
 				'myv' => 'एरझिया',
 				'mzn' => 'मझांडेराणी',
 				'na' => 'नौरो',
 				'nap' => 'नेपोलिटन',
 				'naq' => 'नामा',
 				'nb' => 'नोर्वेजियन बोकमाल',
 				'nd' => 'उत्तर न्डेबेले',
 				'ne' => 'नेपाळी',
 				'new' => 'नेवरी',
 				'ng' => 'डोंगा',
 				'nia' => 'नियास',
 				'niu' => 'नियुन',
 				'nl' => 'डच्',
 				'nl_BE' => 'फ्लेमिश',
 				'nmg' => 'ख्वासी',
 				'nn' => 'नोर्वोजियन नायनोर्स्क',
 				'nnh' => 'न्गेबून',
 				'no' => 'नोर्वेजियन',
 				'nog' => 'नोगाय',
 				'nqo' => 'नको',
 				'nr' => 'दक्षिण डेबेले',
 				'nso' => 'उत्तरीय सोथो',
 				'nus' => 'न्युयर',
 				'nv' => 'नावाजो',
 				'ny' => 'नांन्जा',
 				'nyn' => 'नानकोले',
 				'oc' => 'ओसिटान्',
 				'om' => 'ओरोमो',
 				'or' => 'ओरिया',
 				'os' => 'ओसेटिक',
 				'pa' => 'पंजाबी',
 				'pag' => 'पांगासियान',
 				'pam' => 'पांपान्गा',
 				'pap' => 'पापिमेंटो',
 				'pau' => 'पालुयान',
 				'pcm' => 'नायझेरियन पिडगीन',
 				'pl' => 'पोलिष',
 				'prg' => 'प्रुसियन',
 				'ps' => 'पाष्टो',
 				'pt' => 'पोर्तुगिज',
 				'pt_BR' => 'ब्राझिलियन पोर्तुगिज',
 				'pt_PT' => 'युरोपियन पोर्तुगिज',
 				'qu' => 'क्वेच्वा',
 				'quc' => 'किचे',
 				'rap' => 'रापान्यु',
 				'rar' => 'रारोटोंगान',
 				'rm' => 'रोमांन्श',
 				'rn' => 'रुंदी',
 				'ro' => 'रोमानियन्',
 				'ro_MD' => 'मोल्डावियन्',
 				'rof' => 'रोम्बो',
 				'root' => 'रूट',
 				'ru' => 'रशियन',
 				'rup' => 'आरोमेनियन',
 				'rw' => 'किन्यार्वान्डा',
 				'rwk' => 'रवा',
 				'sa' => 'संस्कृत',
 				'sad' => 'संडावे',
 				'sah' => 'सखा',
 				'saq' => 'सांबारु',
 				'sat' => 'संथाली',
 				'sba' => 'गांबे',
 				'sbp' => 'सांगू',
 				'sc' => 'सार्डिनियान',
 				'scn' => 'सिसिलियान',
 				'sco' => 'स्कॉट्स',
 				'sd' => 'सिंधी',
 				'se' => 'उत्तरीय सामी',
 				'seh' => 'सेना',
 				'ses' => 'कोयराबोरो सेन्नी',
 				'sg' => 'सांग्रो',
 				'sh' => 'सेर्बो-क्रोयेषियन्',
 				'shi' => 'ताछेहीट',
 				'shn' => 'शान',
 				'si' => 'सिन्हलीस्',
 				'sk' => 'स्लोवाक',
 				'sl' => 'स्लोवेनियन्',
 				'sm' => 'समोन',
 				'sma' => 'दक्षिणी सामी',
 				'smj' => 'लुले सामी',
 				'smn' => 'ईनारी सामी',
 				'sms' => 'स्कोल्ट सामी',
 				'sn' => 'शोना',
 				'snk' => 'सोनिके',
 				'so' => 'सोमाली',
 				'sq' => 'आल्बेनियन्',
 				'sr' => 'सर्बियन',
 				'srn' => 'श्रानन टोंगो',
 				'ss' => 'स्वाती',
 				'ssy' => 'साहो',
 				'st' => 'सेसोथो',
 				'su' => 'सुंदनीस',
 				'suk' => 'सुकुमा',
 				'sv' => 'स्वीदीष',
 				'sw' => 'स्वाहिली',
 				'sw_CD' => 'काँगो स्वाहिली',
 				'swb' => 'कोमोरियन',
 				'syr' => 'सिरियाक',
 				'ta' => 'तमिळ',
 				'te' => 'तेलुगू',
 				'tem' => 'तिम्ने',
 				'teo' => 'तेसो',
 				'tet' => 'तेतम',
 				'tg' => 'तजिक',
 				'th' => 'थाई',
 				'ti' => 'तिग्रिन्या',
 				'tig' => 'टिग्रे',
 				'tk' => 'तुर्कमन',
 				'tl' => 'तगालोग',
 				'tlh' => 'लिंगॉन',
 				'tn' => 'सेत्स्वाना',
 				'to' => 'तोंगा',
 				'tpi' => 'तोक पिसीन',
 				'tr' => 'तुर्किष',
 				'trv' => 'तारोको',
 				'ts' => 'त्सोगा',
 				'tt' => 'तटार',
 				'tum' => 'तुंबुका',
 				'tvl' => 'तुवालू',
 				'tw' => 'त्वि',
 				'twq' => 'तासावाक',
 				'ty' => 'ताहीशियन',
 				'tyv' => 'तुविनियन',
 				'tzm' => 'केंद्रीय अटलास तामाझायट',
 				'udm' => 'उडमुर्त',
 				'ug' => 'उयघूर',
 				'uk' => 'युक्रेनियन्',
 				'umb' => 'यमबुंडु',
 				'und' => 'अज्ञात भाशा',
 				'ur' => 'उर्दू',
 				'uz' => 'उज़बेक',
 				'vai' => 'वाई',
 				've' => 'वेंदा',
 				'vi' => 'वियत्नामीज़',
 				'vo' => 'ओलापुक',
 				'vun' => 'वुंजो',
 				'wa' => 'वालून',
 				'wae' => 'वाल्सर',
 				'wal' => 'वोलायटा',
 				'war' => 'वरय',
 				'wo' => 'उलोफ़',
 				'xal' => 'कालमायक',
 				'xh' => 'झ़ौसा',
 				'xog' => 'सोगा',
 				'yav' => 'यांगबेन',
 				'ybb' => 'येम्बा',
 				'yi' => 'इद्दिष्',
 				'yo' => 'यूरुबा',
 				'yue' => 'कांटोसी',
 				'za' => 'झ्हुन्ग',
 				'zgh' => 'प्रमाणित मोरोक्कन तामाझायट',
 				'zh' => 'चिनी',
 				'zh_Hans' => 'सोंपी चिनी',
 				'zh_Hant' => 'पारंपारीक चिनी',
 				'zu' => 'जुलू',
 				'zun' => 'झून',
 				'zxx' => 'अणकार सामुग्री ना',
 				'zza' => 'झाझा',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'अरेबिक',
 			'Armn' => 'आर्मेनियन',
 			'Beng' => 'बांग्ला',
 			'Bopo' => 'बोपोमोफो',
 			'Brai' => 'ब्रैल',
 			'Cyrl' => 'सिरिलिक',
 			'Deva' => 'देवनागरी',
 			'Ethi' => 'इथियोपीक',
 			'Geor' => 'जॉर्जियन',
 			'Grek' => 'ग्रीक',
 			'Gujr' => 'गुजराती',
 			'Guru' => 'गुरमुखी',
 			'Hanb' => 'बोपोमोफो वांगडा हॅन',
 			'Hang' => 'हंगूल',
 			'Hani' => 'हॅन',
 			'Hans' => 'सोंपी',
 			'Hans@alt=stand-alone' => 'सोंपी हॅन',
 			'Hant' => 'पारंपारीक',
 			'Hant@alt=stand-alone' => 'पारंपारीक हॅन',
 			'Hebr' => 'हिब्रू',
 			'Hira' => 'हिरागना',
 			'Hrkt' => 'जपानी अक्षरमाळ',
 			'Jamo' => 'जामो',
 			'Jpan' => 'जपानी',
 			'Kana' => 'काटकाना',
 			'Khmr' => 'खमेर',
 			'Knda' => 'कन्नड',
 			'Kore' => 'कोरियन',
 			'Laoo' => 'लाओ',
 			'Latn' => 'लॅटीन',
 			'Mlym' => 'मलयाळम',
 			'Mong' => 'मोंगोलियन',
 			'Mymr' => 'म्यानमार',
 			'Orya' => 'ओरिया',
 			'Sinh' => 'सिन्हाला',
 			'Taml' => 'तमीळ',
 			'Telu' => 'तेलुगू',
 			'Thaa' => 'थाणा',
 			'Thai' => 'थाई',
 			'Tibt' => 'तिबेटन',
 			'Zmth' => 'गणिताची चिन्नां',
 			'Zsye' => 'Emoji',
 			'Zsym' => 'चिन्नां',
 			'Zxxx' => 'अलिखीत',
 			'Zyyy' => 'सामान्य',
 			'Zzzz' => 'अज्ञात लिपी',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'जग',
 			'002' => 'आफ्रिका',
 			'003' => 'उत्तर अमेरिका',
 			'005' => 'दक्षिण अमेरिका',
 			'009' => 'ओसेनिया',
 			'011' => 'अस्तंत आफ्रिका',
 			'013' => 'मध्य अमेरिका',
 			'014' => 'उदेंत आफ्रिका',
 			'015' => 'उत्तरीय आफ्रिका',
 			'017' => 'मध्य आफ्रिका',
 			'018' => 'दक्षिण आफ्रिका',
 			'019' => 'अमेरिकास',
 			'021' => 'उत्तरीय अमेरिका',
 			'029' => 'कॅरिबियन',
 			'030' => 'उदेंत आशिया',
 			'034' => 'दक्षिण आशिया',
 			'035' => 'आग्नेय आशिया',
 			'039' => 'दक्षिण येवरोप',
 			'053' => 'ऑस्ट्रेलेसिया',
 			'054' => 'मेलानेसिया',
 			'057' => 'मायक्रोनेशियन प्रांत',
 			'061' => 'पोलिनेशिया',
 			'142' => 'आशिया',
 			'143' => 'मध्य आशिया',
 			'145' => 'अस्तंत आशिया',
 			'150' => 'येवरोप',
 			'151' => 'उदेंत येवरोप',
 			'154' => 'उत्तर येवरोप',
 			'155' => 'अस्तंत येवरोप',
 			'202' => 'उप-सहाराई आफ्रिका',
 			'419' => 'लॅटीन अमेरिका',
 			'AC' => 'असेशन आयलँड',
 			'AD' => 'अंडोरा',
 			'AE' => 'युनाइटेड अरब इमीरॅट्स',
 			'AF' => 'अफगानिस्तान',
 			'AG' => 'एँटिगुआ आनी बारबुडा',
 			'AI' => 'अंगुला',
 			'AL' => 'अल्बानीया',
 			'AM' => 'आर्मीनीया',
 			'AO' => 'अंगोला',
 			'AQ' => 'अंटार्क्टिका',
 			'AR' => 'अर्जेंटिना',
 			'AS' => 'अमेरिकी सामोआ',
 			'AT' => 'ऑस्ट्रिया',
 			'AU' => 'ऑस्ट्रेलीया',
 			'AW' => 'अरुबा',
 			'AX' => 'अलांड जुवे',
 			'AZ' => 'अजरबैजान',
 			'BA' => 'बोस्निया आनी हेर्जेगोविना',
 			'BB' => 'बारबाडोस',
 			'BD' => 'बांगलादेश',
 			'BE' => 'बेल्जियम',
 			'BF' => 'बुर्किना फॅसो',
 			'BG' => 'बल्गेरीया',
 			'BH' => 'बेहरेन',
 			'BI' => 'बुरुंडी',
 			'BJ' => 'बेनीन',
 			'BL' => 'सॅंट बार्थेल्मी',
 			'BM' => 'बर्मुडा',
 			'BN' => 'ब्रूनेई',
 			'BO' => 'बोलिव्हिया',
 			'BQ' => 'कॅरिबियन निदरलँड',
 			'BR' => 'ब्राझील',
 			'BS' => 'बहामास',
 			'BT' => 'भूतान',
 			'BV' => 'बोवट आयलँड',
 			'BW' => 'बोत्सवाना',
 			'BY' => 'बेलारूस',
 			'BZ' => 'बेलिझ',
 			'CA' => 'कॅनडा',
 			'CC' => 'कोकोस (कीलिंग) आयलँड',
 			'CD' => 'कोंगो - किंशासा',
 			'CD@alt=variant' => 'कोंगो (डीआरसी)',
 			'CF' => 'मध्य अफ्रीकी लोकसत्तकराज्य',
 			'CG' => 'कोंगो - ब्राझाविला',
 			'CG@alt=variant' => 'कोंगो (प्रजासत्ताक)',
 			'CH' => 'स्विट्ज़रलैंड',
 			'CI' => 'कोत द’ईवोआर',
 			'CI@alt=variant' => 'आयवोरी कोस्ट',
 			'CK' => 'कुक आयलँड्स',
 			'CL' => 'चिली',
 			'CM' => 'कॅमेरून',
 			'CN' => 'चीन',
 			'CO' => 'कोलंबिया',
 			'CP' => 'क्लिपरटॉन आयलँड',
 			'CR' => 'कोस्ता रिका',
 			'CU' => 'क्युबा',
 			'CV' => 'केप वर्दी',
 			'CW' => 'कुरसावो',
 			'CX' => 'क्रिसमस आयलँड',
 			'CY' => 'सायप्रस',
 			'CZ' => 'चेकिया',
 			'CZ@alt=variant' => 'चेक लोकसत्ताक',
 			'DE' => 'जर्मनी',
 			'DG' => 'दिगो गार्सिया',
 			'DJ' => 'जिबूती',
 			'DK' => 'डेनमार्क',
 			'DM' => 'डोमिनीका',
 			'DO' => 'डोमिनिकन प्रजासत्ताक',
 			'DZ' => 'अल्जेरिया',
 			'EA' => 'सिटा आनी मेलिल्ला',
 			'EC' => 'इक्वाडोर',
 			'EE' => 'एस्टोनिया',
 			'EG' => 'ईजिप्त',
 			'EH' => 'अस्तंत सहारा',
 			'ER' => 'इरिट्रिया',
 			'ES' => 'स्पेन',
 			'ET' => 'इथियोपिया',
 			'EU' => 'युरोपियन युनियन',
 			'EZ' => 'युरोझोन',
 			'FI' => 'फिनलँड',
 			'FJ' => 'फिजी',
 			'FK' => 'फ़ॉकलैंड आइलैंड्स',
 			'FK@alt=variant' => 'फ़ॉकलैंड आइलैंड्स (इलास मालविनास)',
 			'FM' => 'मायक्रोनेशिया',
 			'FO' => 'फैरो आयलँड्स',
 			'FR' => 'फ्रान्स',
 			'GA' => 'गॅबोन',
 			'GB' => 'युनायटेड किंगडम',
 			'GB@alt=short' => 'युके',
 			'GD' => 'ग्रेनॅडा',
 			'GE' => 'जॉर्जिया',
 			'GF' => 'फ्रेन्च गयाना',
 			'GG' => 'गर्नसी',
 			'GH' => 'घाना',
 			'GI' => 'जिब्राल्टर',
 			'GL' => 'ग्रीनलँड',
 			'GM' => 'गॅम्बिया',
 			'GN' => 'गुएनिया',
 			'GP' => 'ग्वाडेलोप',
 			'GQ' => 'इक्वेटोरियल गुएनिया',
 			'GR' => 'ग्रीस',
 			'GS' => 'दक्षिण जोर्जिया आनी दक्षिण सॅण्डविच आयलँड्स',
 			'GT' => 'ग्वाटेमाला',
 			'GU' => 'गुआम',
 			'GW' => 'गुअनिया-बिसाउ',
 			'GY' => 'गयाना',
 			'HK' => 'हाँग काँग SAR चीन',
 			'HK@alt=short' => 'हाँग काँग',
 			'HM' => 'हर्ड आयलँड्स ऍंड मॅक्डोनाल्ड आयलँड्स',
 			'HN' => 'हॉनडुरस',
 			'HR' => 'क्रोयेशीया',
 			'HT' => 'हैती',
 			'HU' => 'हंगेरी',
 			'IC' => 'कॅनरी आयलैंड्स',
 			'ID' => 'इंडोनेशीया',
 			'IE' => 'आयरलँड',
 			'IL' => 'इज़राइल',
 			'IM' => 'इसले ऑफ मॅन',
 			'IN' => 'भारत',
 			'IO' => 'ब्रिटिश हिंद महासागरीय क्षेत्र',
 			'IQ' => 'इराक',
 			'IR' => 'इरान',
 			'IS' => 'आइसलैंड',
 			'IT' => 'इटली',
 			'JE' => 'जर्सी',
 			'JM' => 'जमैका',
 			'JO' => 'जॉर्डन',
 			'JP' => 'जपान',
 			'KE' => 'केनया',
 			'KG' => 'किर्गिज़स्तान',
 			'KH' => 'कंबोडिया',
 			'KI' => 'किरिबाती',
 			'KM' => 'कोमोरोस',
 			'KN' => 'सेंट किट्स आनी नेविस',
 			'KP' => 'उत्तर कोरिया',
 			'KR' => 'दक्षिण कोरिया',
 			'KW' => 'कुवेत',
 			'KY' => 'कैमेन आइलैंड्स',
 			'KZ' => 'कझाकस्तान',
 			'LA' => 'लाओस',
 			'LB' => 'लेबनान',
 			'LC' => 'सँट लुसिया',
 			'LI' => 'लिचेंस्टीन',
 			'LK' => 'श्री लंका',
 			'LR' => 'लायबेरीया',
 			'LS' => 'लिसोथो',
 			'LT' => 'लिथुआनिया',
 			'LU' => 'लक्सेमबर्ग',
 			'LV' => 'लॅटविया',
 			'LY' => 'लीबिया',
 			'MA' => 'मोरोक्को',
 			'MC' => 'मोनॅको',
 			'MD' => 'माल्डोवा',
 			'ME' => 'मॉन्टॅनग्रो',
 			'MF' => 'सॅंट मार्टिन',
 			'MG' => 'माडागास्कर',
 			'MH' => 'मार्शल आयलँड्स',
 			'MK' => 'मॅसिडोनिया',
 			'MK@alt=variant' => 'मॅसिडोनिया (FYROM)',
 			'ML' => 'माली',
 			'MM' => 'म्यानमार (बर्मा)',
 			'MN' => 'मंगोलिया',
 			'MO' => 'मकाव SAR चीन',
 			'MO@alt=short' => 'मकाव',
 			'MP' => 'उत्तरी मरिना आयसलैण्ड',
 			'MQ' => 'मार्टीनिक',
 			'MR' => 'मॉरिटानिया',
 			'MS' => 'मॉन्टसेराट',
 			'MT' => 'माल्टा',
 			'MU' => 'मॉरिशस',
 			'MV' => 'मालदीव',
 			'MW' => 'मलावी',
 			'MX' => 'मेक्सिको',
 			'MY' => 'मलेशिया',
 			'MZ' => 'मॉझांबीक',
 			'NA' => 'नामीबिया',
 			'NC' => 'न्यू कॅलिडोनिया',
 			'NE' => 'नायजर',
 			'NF' => 'नॉरफॉक आयलँड',
 			'NG' => 'नायजेरिया',
 			'NI' => 'निकारगुवा',
 			'NL' => 'नॅदरलँड',
 			'NO' => 'नॉर्वे',
 			'NP' => 'नेपाळ',
 			'NR' => 'नावरू',
 			'NU' => 'नीयू',
 			'NZ' => 'न्युझीलॅन्ड',
 			'OM' => 'ओमान',
 			'PA' => 'पनामा',
 			'PE' => 'पेरू',
 			'PF' => 'फ्रेन्च पोलिनेसिया',
 			'PG' => 'पापुआ न्यु गिनी',
 			'PH' => 'फिलीपिन्झ',
 			'PK' => 'पाकिस्तान',
 			'PL' => 'पोलंड',
 			'PM' => 'सँ. पायरे आनी मिकेलन',
 			'PN' => 'पिटकॅरन आयलँड्स',
 			'PR' => 'पिर्टो रिको',
 			'PS' => 'पेलेस्टीनियन प्रांत',
 			'PS@alt=short' => 'पेलेस्टायन',
 			'PT' => 'पुर्तगाल',
 			'PW' => 'पलाऊ',
 			'PY' => 'पैराग्वे',
 			'QA' => 'कतार',
 			'QO' => 'आवटलायींग ओशेनिया',
 			'RE' => 'रीयूनियन',
 			'RO' => 'रोमानीया',
 			'RS' => 'सर्बिया',
 			'RU' => 'रूस',
 			'RW' => 'रवांडा',
 			'SA' => 'सऊदी अरेबिया',
 			'SB' => 'सोलोमन आइलँड्स',
 			'SC' => 'सेशेल्स',
 			'SD' => 'सूडान',
 			'SE' => 'स्वीडन',
 			'SG' => 'सिंगापूर',
 			'SH' => 'सेंट हेलिना',
 			'SI' => 'स्लोवेनिया',
 			'SJ' => 'स्वालबार्ड आनी जान मेयन',
 			'SK' => 'स्लोवाकिया',
 			'SL' => 'सिएरा लियॉन',
 			'SM' => 'सॅन मारीनो',
 			'SN' => 'सिनिगल',
 			'SO' => 'सोमालिया',
 			'SR' => 'सुरीनाम',
 			'SS' => 'दक्षिण सुडान',
 			'ST' => 'सावो टोमे आनी प्रिंसिपल',
 			'SV' => 'एल साल्वाडोर',
 			'SX' => 'सिंट मार्टेन',
 			'SY' => 'सिरिया',
 			'SZ' => 'स्वाजीलँड',
 			'TA' => 'त्रिस्तान दा कुन्हा',
 			'TC' => 'तुर्क्स आनी कॅकोज आयलँड्स',
 			'TD' => 'चाड',
 			'TF' => 'फ्रेंच दक्षिणी प्रांत',
 			'TG' => 'टोगो',
 			'TH' => 'थायलँड',
 			'TJ' => 'तजीकिस्तान',
 			'TK' => 'टोकलाऊ',
 			'TL' => 'तिमोर-लेस्ते',
 			'TL@alt=variant' => 'ईस्ट तिमूर',
 			'TM' => 'तुर्कमेनिस्तान',
 			'TN' => 'ट्यूनीशिया',
 			'TO' => 'टोंगा',
 			'TR' => 'तुर्की',
 			'TT' => 'ट्रिनीडाड आनी टोबॅगो',
 			'TV' => 'टुवालू',
 			'TW' => 'तायवान',
 			'TZ' => 'तांझानिया',
 			'UA' => 'युक्रेन',
 			'UG' => 'युगांडा',
 			'UM' => 'यु. एस. मायनर आवटलायींग आयलँड्‍स',
 			'UN' => 'युनायटेड नेशन्स',
 			'US' => 'युनायटेड स्टेट्स',
 			'US@alt=short' => 'युएस',
 			'UY' => 'उरूग्वे',
 			'UZ' => 'उज़्बेकिस्तान',
 			'VA' => 'वॅटिकन सिटी',
 			'VC' => 'सेंट विंसेंट ऐंड द ग्रेनेडाइंस',
 			'VE' => 'विनेझुएला',
 			'VG' => 'ब्रिटिश वर्जिन आयलँड्स',
 			'VI' => 'यु. एस. वर्जिन आयलँड्‍स',
 			'VN' => 'व्हिएतनाम',
 			'VU' => 'वनातू',
 			'WF' => 'वालिस आनी फ्यूचूना',
 			'WS' => 'सामोआ',
 			'XK' => 'कोसोवो',
 			'YE' => 'येमेन',
 			'YT' => 'मेयोट',
 			'ZA' => 'दक्षिण आफ्रीका',
 			'ZM' => 'झांबिया',
 			'ZW' => 'जिम्बाब्वे',
 			'ZZ' => 'अज्ञात प्रांत',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'दिनदर्शिका',
 			'cf' => 'चलनाचें स्वरूप',
 			'collation' => 'वर्गवारी क्रम',
 			'currency' => 'चलन',
 			'hc' => 'वराचें चक्र (12 वि 24)',
 			'lb' => 'रेग खंड करपाची शैली',
 			'ms' => 'मापन प्रणाली',
 			'numbers' => 'क्रमांक',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{बुध्दीश्ट दिनदर्शिका},
 				'chinese' => q{चीनी दिनदर्शिका},
 				'dangi' => q{डांगी दिनदर्शिका},
 				'ethiopic' => q{इथियोपिक दिनदर्शिका},
 				'gregorian' => q{ग्रेगोरियन दिनदर्शिका},
 				'hebrew' => q{हिब्रू दिनदर्शिका},
 				'islamic' => q{ईस्लामीक दिनदर्शिका},
 				'iso8601' => q{आयएसओ-8601 दिनदर्शिका},
 				'japanese' => q{जपानी},
 				'persian' => q{पर्शियन दिनदर्शिका},
 				'roc' => q{मिंगुआ दिनदर्शिका (अणकाराची कुरू: जाका चिनी दिनदर्शिकेचें प्रजासत्ताक", "रिपब्लिकन दिनदर्शिका")},
 			},
 			'cf' => {
 				'account' => q{लेखा चलन स्वरूप},
 				'standard' => q{प्रमाणित},
 			},
 			'collation' => {
 				'ducet' => q{डिफॉल्ट युनिकोड वर्गवारी क्रम},
 				'search' => q{सोद घेवचो},
 				'standard' => q{प्रमाणित वर्गवारी क्रम},
 			},
 			'hc' => {
 				'h11' => q{12 वरांची यंत्रणा (0–11)},
 				'h12' => q{12 वरांची यंत्रणा (1–12)},
 				'h23' => q{24 वरांची यंत्रणा (0–23)},
 				'h24' => q{24 वरांची यंत्रणा (1–24)},
 			},
 			'lb' => {
 				'loose' => q{लूज रेग खंड शैली},
 				'normal' => q{सामान्य रेग खंड शैली},
 				'strict' => q{सक्तीची रेग खंड शैली},
 			},
 			'ms' => {
 				'metric' => q{मॅट्रीक प्रणाली},
 				'uksystem' => q{व्हडली मापन प्रणाली},
 				'ussystem' => q{युएस मापन प्रणाली},
 			},
 			'numbers' => {
 				'arab' => q{अरेबिक-भारतीय अंक},
 				'arabext' => q{विस्तारीत अरेबीक-भारतीय अंक},
 				'armn' => q{आर्मेनियन संख्या},
 				'armnlow' => q{आर्मेनियन लोवरकेस संख्या},
 				'beng' => q{बांग्ला अंक},
 				'deva' => q{देवनागरी अंक},
 				'ethi' => q{इथियोपिक संख्या},
 				'fullwide' => q{पूर्ण-रुंदी अंक},
 				'geor' => q{जॉर्जियन संख्या},
 				'grek' => q{ग्रीक संख्या},
 				'greklow' => q{ग्रीक लोवरकेस संख्या},
 				'gujr' => q{गुजराती अंक},
 				'guru' => q{गुरुमुखी अंक},
 				'hanidec' => q{चिनी दशांश संख्या},
 				'hans' => q{सोंपी केल्ली चिनी संख्या},
 				'hansfin' => q{सोंपी केल्ली चिनी महसूल संख्या},
 				'hant' => q{पारंपारीक चिनी संख्या},
 				'hantfin' => q{पारंपारीक चिनी महसूल संख्या},
 				'hebr' => q{हिब्रू संख्या},
 				'jpan' => q{जपानी संख्या},
 				'jpanfin' => q{जपानी महसूल संख्या},
 				'khmr' => q{कंबोडियन अंक},
 				'knda' => q{कन्नड अंक},
 				'laoo' => q{लाओ अंक},
 				'latn' => q{अस्तंत अंक},
 				'mlym' => q{मल्याळम अंक},
 				'mymr' => q{म्यानमार अंक},
 				'orya' => q{ओडिया},
 				'roman' => q{रोमन संख्या},
 				'romanlow' => q{रोमन लोवरकेस संख्या},
 				'taml' => q{पारंपारीक तमिळ संख्या},
 				'tamldec' => q{तमिळ अंक},
 				'telu' => q{तेलुगू अंक},
 				'thai' => q{थाय अंक},
 				'tibt' => q{तिबेतियन},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{Metric},
 			'UK' => q{UK},
 			'US' => q{US},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'भाशा: {0}',
 			'script' => 'लिपी: {0}',
 			'region' => 'प्रांत: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[‌‍]},
			index => ['अ', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऋ', 'ऌ', 'ऍ', 'ए', 'ऐ', 'ऑ', 'ओ', 'औ', 'क', 'ख', 'ग', 'घ', 'ङ', 'च', 'छ', 'ज', 'झ', 'ञ', 'ट', 'ठ', 'ड', 'ढ', 'ण', 'त', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'व', 'श', 'ष', 'स', 'ह', 'ळ'],
			main => qr{[़ ० १ २ ३ ४ ५ ६ ७ ८ ९ ॐ ं ँ ः अ आ इ ई उ ऊ ऋ ऌ ऍ ए ऐ ऑ ओ औ क {क़} ख {ख़} ग {ग़} घ ङ च छ ज {ज़} झ ञ ट ठ ड {ड़} ढ {ढ़} ण त थ द ध न प फ {फ़} ब भ म य {य़} र ल व श ष स ह ळ ऽ ा ि ी ु ू ृ ॄ ॅ े ै ॉ ो ौ ्]},
			numbers => qr{[\- , . % ‰ + 0० 1१ 2२ 3३ 4४ 5५ 6६ 7७ 8८ 9९]},
			punctuation => qr{[\- ‐ – — , ; \: ! ? . … ' ‘ ’ " “ ” ( ) \[ \] § @ * / \& # † ‡ ′ ″]},
		};
	},
EOT
: sub {
		return { index => ['अ', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऋ', 'ऌ', 'ऍ', 'ए', 'ऐ', 'ऑ', 'ओ', 'औ', 'क', 'ख', 'ग', 'घ', 'ङ', 'च', 'छ', 'ज', 'झ', 'ञ', 'ट', 'ठ', 'ड', 'ढ', 'ण', 'त', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'व', 'श', 'ष', 'स', 'ह', 'ळ'], };
},
);


has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:हय|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ना|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'deva',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'deva' => {
			'decimal' => q(.),
			'group' => q(,),
			'minusSign' => q(-),
			'percentSign' => q(%),
			'plusSign' => q(+),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'other' => '0K',
				},
				'10000' => {
					'other' => '00K',
				},
				'100000' => {
					'other' => '000K',
				},
				'1000000' => {
					'other' => '0M',
				},
				'10000000' => {
					'other' => '00M',
				},
				'100000000' => {
					'other' => '000M',
				},
				'1000000000' => {
					'other' => '0G',
				},
				'10000000000' => {
					'other' => '00G',
				},
				'100000000000' => {
					'other' => '000G',
				},
				'1000000000000' => {
					'other' => '0T',
				},
				'10000000000000' => {
					'other' => '00T',
				},
				'100000000000000' => {
					'other' => '000T',
				},
				'standard' => {
					'default' => '#,##,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'other' => '0K',
				},
				'10000' => {
					'other' => '00K',
				},
				'100000' => {
					'other' => '000K',
				},
				'1000000' => {
					'other' => '0M',
				},
				'10000000' => {
					'other' => '00M',
				},
				'100000000' => {
					'other' => '000M',
				},
				'1000000000' => {
					'other' => '0G',
				},
				'10000000000' => {
					'other' => '00G',
				},
				'100000000000' => {
					'other' => '000G',
				},
				'1000000000000' => {
					'other' => '0T',
				},
				'10000000000000' => {
					'other' => '00T',
				},
				'100000000000000' => {
					'other' => '000T',
				},
			},
			'short' => {
				'1000' => {
					'other' => '0K',
				},
				'10000' => {
					'other' => '00K',
				},
				'100000' => {
					'other' => '000K',
				},
				'1000000' => {
					'other' => '0M',
				},
				'10000000' => {
					'other' => '00M',
				},
				'100000000' => {
					'other' => '000M',
				},
				'1000000000' => {
					'other' => '0G',
				},
				'10000000000' => {
					'other' => '00G',
				},
				'100000000000' => {
					'other' => '000G',
				},
				'1000000000000' => {
					'other' => '0T',
				},
				'10000000000000' => {
					'other' => '00T',
				},
				'100000000000000' => {
					'other' => '000T',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'deva' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '¤ #,##,##0.00',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '¤ #,##,##0.00',
					},
					'standard' => {
						'positive' => '¤ #,##,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(BRL),
				'other' => q(BRL),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(CNY),
				'other' => q(CNY),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(EUR),
				'other' => q(EUR),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(GBP),
				'other' => q(GBP),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(INR),
				'other' => q(INR),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(JPY),
				'other' => q(JPY),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(RUB),
				'other' => q(RUB),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(USD),
				'other' => q(USD),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(XXX),
				'other' => q(XXX),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'जानेवारी',
							'फेब्रुवारी',
							'मार्च',
							'एप्रिल',
							'मे',
							'जून',
							'जुलाय',
							'आगोस्त',
							'सप्टेंबर',
							'ऑक्टोबर',
							'नोव्हेंबर',
							'डिसेंबर'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'जानेवारी',
							'फेब्रुवारी',
							'मार्च',
							'एप्रिल',
							'मे',
							'जून',
							'जुलाय',
							'आगोस्त',
							'सप्टेंबर',
							'ऑक्टोबर',
							'नोव्हेंबर',
							'डिसेंबर'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'जानेवारी',
							'फेब्रुवारी',
							'मार्च',
							'एप्रिल',
							'मे',
							'जून',
							'जुलाय',
							'आगोस्त',
							'सप्टेंबर',
							'ऑक्टोबर',
							'नोव्हेंबर',
							'डिसेंबर'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'जानेवारी',
							'फेब्रुवारी',
							'मार्च',
							'एप्रिल',
							'मे',
							'जून',
							'जुलाय',
							'आगोस्त',
							'सप्टेंबर',
							'ऑक्टोबर',
							'नोव्हेंबर',
							'डिसेंबर'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'सोमार',
						tue => 'मंगळार',
						wed => 'बुधवार',
						thu => 'गुरुवार',
						fri => 'शुक्रार',
						sat => 'शेनवार',
						sun => 'आयतार'
					},
					narrow => {
						mon => 'सो',
						tue => 'मं',
						wed => 'बु',
						thu => 'गु',
						fri => 'शु',
						sat => 'शे',
						sun => 'आ'
					},
					short => {
						mon => 'सोम',
						tue => 'मंगळ',
						wed => 'बुध',
						thu => 'गुरु',
						fri => 'शुक्र',
						sat => 'शेन',
						sun => 'आय'
					},
					wide => {
						mon => 'सोमार',
						tue => 'मंगळार',
						wed => 'बुधवार',
						thu => 'गुरुवार',
						fri => 'शुक्रार',
						sat => 'शेनवार',
						sun => 'आयतार'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'सोमार',
						tue => 'मंगळार',
						wed => 'बुधवार',
						thu => 'गुरुवार',
						fri => 'शुक्रार',
						sat => 'शेनवार',
						sun => 'आयतार'
					},
					narrow => {
						mon => 'सो',
						tue => 'मं',
						wed => 'बु',
						thu => 'गु',
						fri => 'शु',
						sat => 'शे',
						sun => 'आ'
					},
					short => {
						mon => 'सोम',
						tue => 'मंगळ',
						wed => 'बुध',
						thu => 'गुरु',
						fri => 'शुक्र',
						sat => 'शेन',
						sun => 'आय'
					},
					wide => {
						mon => 'सोमार',
						tue => 'मंगळार',
						wed => 'बुधवार',
						thu => 'गुरुवार',
						fri => 'शुक्रार',
						sat => 'शेनवार',
						sun => 'आयतार'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'am' => q{म.पू.},
					'pm' => q{म.नं.},
				},
				'narrow' => {
					'pm' => q{म.नं.},
					'am' => q{म.पू.},
				},
				'abbreviated' => {
					'pm' => q{म.नं.},
					'am' => q{म.पू.},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'pm' => q{म.नं.},
					'am' => q{म.पू.},
				},
				'wide' => {
					'pm' => q{म.नं.},
					'am' => q{म.पू.},
				},
				'narrow' => {
					'pm' => q{म.नं.},
					'am' => q{म.पू.},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'क्रिस्तपूर्व',
				'1' => 'क्रिस्तशखा'
			},
			wide => {
				'0' => 'क्रिस्तपूर्व',
				'1' => 'क्रिस्तशखा'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE d MMMM y G},
			'long' => q{d MMMM y G},
			'medium' => q{dd-MM-y G},
			'short' => q{d-M-y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE d MMMM y},
			'long' => q{d MMMM y},
			'medium' => q{dd-MM-y},
			'short' => q{d-M-yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{MM-dd, E},
			MMM => q{LLL},
			MMMEd => q{MMM d, E},
			MMMMW => q{'week' W 'of' MMMM},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			Md => q{MM-dd},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{y-MM},
			yMEd => q{y-MM-dd, E},
			yMMM => q{y MMM},
			yMMMEd => q{y MMM d, E},
			yMMMM => q{y MMMM},
			yMMMd => q{y MMM d},
			yMd => q{y-MM-dd},
			yQQQ => q{y QQQ},
			yQQQQ => q{y QQQQ},
			yw => q{'week' w 'of' Y},
		},
		'generic' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E, d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E d, MMM y G},
			GyMMMd => q{d MMM y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, dd-MM},
			MMM => q{LLL},
			MMMEd => q{E d, MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd-MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{MM-y GGGG},
			yyyyMEd => q{E, d/M/y GGGGG},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d MMM y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM y G},
			yyyyMd => q{d/M/y GGGGG},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{MM-dd, E – MM-dd, E},
				d => q{MM-dd, E – MM-dd, E},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{MMM d, E – MMM d, E},
				d => q{MMM d, E – MMM d, E},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d–d},
			},
			Md => {
				M => q{dd-MM –dd-MM},
				d => q{dd-MM –dd-MM},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{MM-y – MM-y},
				y => q{MM-y – MM-y},
			},
			yMEd => {
				M => q{dd-MM-y, E – dd-MM-y, E},
				d => q{dd-MM-y, E – dd-MM-y, E},
				y => q{dd-MM-y, E – dd-MM-y, E},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y– MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y},
				d => q{E, d MMM –E, d MMM y},
				y => q{E, d MMM y – E, d MMM y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d–d MMM y},
				y => q{d MMM y – d MMM y},
			},
			yMd => {
				M => q{dd-MM-y – dd-MM-y},
				d => q{dd-MM-y – dd-MM-y},
				y => q{dd-MM-y – dd-MM-y},
			},
		},
		'generic' => {
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{E, dd-MM, E dd-MM},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M–d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y GGGGG},
				d => q{E, d/M/y – E, d/M/y GGGGG},
				y => q{E, d/M/y – E, d/M/y GGGGG},
			},
			yMMM => {
				M => q{MMM–MMM y G},
				y => q{MMM y G – MMM y},
			},
			yMMMEd => {
				M => q{E, d, MMM y – E, d, MMM y G},
				d => q{E, d MMM – E, d MMM, yG},
				y => q{E, d, MMM y – E, d, MMM y G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y G},
				d => q{d–d MMM, y G},
				y => q{d, MMM y – d, MMM y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y GGGGG},
				d => q{d/M/y – d/M/y GGGGG},
				y => q{d/M/y – d/M/y GGGGG},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} वेळ),
		regionFormat => q({0} डेलायट वेळ),
		regionFormat => q({0} प्रमाणित वेळ),
		fallbackFormat => q({1} ({0})),
		'Africa_Central' => {
			long => {
				'standard' => q#मध्य आफ्रिका वेळ#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#उदेंत आफ्रिका वेळ#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#दक्षिण आफ्रिका प्रमाणित वेळ#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#अस्तंत आफ्रिका ग्रीष्म वेळ#,
				'generic' => q#अस्तंत आफ्रिका वेळ#,
				'standard' => q#अस्तंत आफ्रिका प्रमाणित वेळ#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#अलास्का डेलायट वेळ#,
				'generic' => q#अलास्का वेळ#,
				'standard' => q#अलास्का प्रमाणित वेळ#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#अमेझोन ग्रीष्म वेळ#,
				'generic' => q#अमेझोन वेळ#,
				'standard' => q#अमेझोन प्रमाणित वेळ#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#अडाक#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ऐंकरज#,
		},
		'America/Anguilla' => {
			exemplarCity => q#अंगुला#,
		},
		'America/Antigua' => {
			exemplarCity => q#एँटिगुआ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#अरगुयेना#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ला रियोजा#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#रियो गलेगॉस#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#साल्टा#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#सान जुआन#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#सान लुईस#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#टुकुमॅन#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#उशुआइया#,
		},
		'America/Aruba' => {
			exemplarCity => q#अरुबा#,
		},
		'America/Asuncion' => {
			exemplarCity => q#असंसियन#,
		},
		'America/Bahia' => {
			exemplarCity => q#बहिया#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#बहिया बंदेरस#,
		},
		'America/Barbados' => {
			exemplarCity => q#बारबाडोस#,
		},
		'America/Belem' => {
			exemplarCity => q#बेलेम#,
		},
		'America/Belize' => {
			exemplarCity => q#बेलिझ#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ब्लांक-साब्लोन#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#बाओ विस्टा#,
		},
		'America/Bogota' => {
			exemplarCity => q#बोगोटा#,
		},
		'America/Boise' => {
			exemplarCity => q#बोयस#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ब्यूनस आयर्स#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#केंब्रिज बे#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#कॅम्पो ग्रांड#,
		},
		'America/Cancun' => {
			exemplarCity => q#कानकुन#,
		},
		'America/Caracas' => {
			exemplarCity => q#कराकस#,
		},
		'America/Catamarca' => {
			exemplarCity => q#काटामारका#,
		},
		'America/Cayenne' => {
			exemplarCity => q#केइन#,
		},
		'America/Cayman' => {
			exemplarCity => q#कैमेन#,
		},
		'America/Chicago' => {
			exemplarCity => q#शिकागो#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#चिहुआहुआ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#अतिकोकॉन#,
		},
		'America/Cordoba' => {
			exemplarCity => q#कोरडोबा#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#कोस्ता रिका#,
		},
		'America/Creston' => {
			exemplarCity => q#क्रेस्टोन#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#कुययबा#,
		},
		'America/Curacao' => {
			exemplarCity => q#कुराकाओ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#डेन्मार्कशॉन#,
		},
		'America/Dawson' => {
			exemplarCity => q#डौसन#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#डौसन क्रिक#,
		},
		'America/Denver' => {
			exemplarCity => q#डेन्वेर#,
		},
		'America/Detroit' => {
			exemplarCity => q#डेट्रॉईट#,
		},
		'America/Dominica' => {
			exemplarCity => q#डोमिनीका#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ऍडमोंटन#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ईरुनेपे#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#एल साल्वाडोर#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#फोर्ट नेल्सन#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#फोर्टालेझा#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ग्लेस बे#,
		},
		'America/Godthab' => {
			exemplarCity => q#नूक#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#गूस बे#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ग्रँड तुर्क#,
		},
		'America/Grenada' => {
			exemplarCity => q#ग्रेनॅडा#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ग्वाडेलोप#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ग्वाटेमाला#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ग्वायेकिल#,
		},
		'America/Guyana' => {
			exemplarCity => q#गुयाना#,
		},
		'America/Halifax' => {
			exemplarCity => q#हेलिफॅक्स#,
		},
		'America/Havana' => {
			exemplarCity => q#हवाना#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#हर्मोसिलो#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#नॉक्स, इंडियाना#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#मारेंगो, इंडियाना#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#पिटर्सबर्ग, इंडियाना#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#टेल सिटी, इंडियाना#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#वेवय, इंडियाना#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#विंसेनस, इंडियाना#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#विनामॅक, इंडियाना#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#इंडियानापोलीस#,
		},
		'America/Inuvik' => {
			exemplarCity => q#इनुविक#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#इकालुयीट#,
		},
		'America/Jamaica' => {
			exemplarCity => q#जमैका#,
		},
		'America/Jujuy' => {
			exemplarCity => q#जुजेय#,
		},
		'America/Juneau' => {
			exemplarCity => q#जूनो#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#मोंटीसॅलो, केंटुकाय#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#क्रालेनडीक#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ला पाझ#,
		},
		'America/Lima' => {
			exemplarCity => q#लिमा#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#लॉस एंजलीस#,
		},
		'America/Louisville' => {
			exemplarCity => q#लुईजविले#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#लोवर प्रिंसेस क्वार्टर#,
		},
		'America/Maceio' => {
			exemplarCity => q#मासियो#,
		},
		'America/Managua' => {
			exemplarCity => q#मॅनाग्वा#,
		},
		'America/Manaus' => {
			exemplarCity => q#मनौस#,
		},
		'America/Marigot' => {
			exemplarCity => q#मेरीगॉट#,
		},
		'America/Martinique' => {
			exemplarCity => q#मार्टिनिक#,
		},
		'America/Matamoros' => {
			exemplarCity => q#माटामोरोस#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#माझाट्लान#,
		},
		'America/Mendoza' => {
			exemplarCity => q#मेन्डोझा#,
		},
		'America/Menominee' => {
			exemplarCity => q#मेनोमिनी#,
		},
		'America/Merida' => {
			exemplarCity => q#मेरिडा#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#मेट्लाकाट्ला#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#मेक्सिको शार#,
		},
		'America/Miquelon' => {
			exemplarCity => q#मिक्वेलोन#,
		},
		'America/Moncton' => {
			exemplarCity => q#मोंक्टॉन#,
		},
		'America/Monterrey' => {
			exemplarCity => q#मोंटेरी#,
		},
		'America/Montevideo' => {
			exemplarCity => q#मोंटेव्हिडियो#,
		},
		'America/Montserrat' => {
			exemplarCity => q#मॉन्टसेराट#,
		},
		'America/Nassau' => {
			exemplarCity => q#नसाऊ#,
		},
		'America/New_York' => {
			exemplarCity => q#न्यु यॉर्क#,
		},
		'America/Nipigon' => {
			exemplarCity => q#निपिगोन#,
		},
		'America/Nome' => {
			exemplarCity => q#नोमे#,
		},
		'America/Noronha' => {
			exemplarCity => q#नोरोन्हा#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ब्यूल्लाह, उत्तर डाकोटा#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#मध्य, उत्तर डाकोटा#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#न्यु सालेम, उत्तर डाकोटा#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ओजिनागा#,
		},
		'America/Panama' => {
			exemplarCity => q#पनामा#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#पंगनिर्टुंग#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#परामारिबो#,
		},
		'America/Phoenix' => {
			exemplarCity => q#फिनिक्स#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#पोर्ट-औ-प्रिन्स#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#पोर्ट ऑफ स्पेन#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#पोर्टो वेल्हो#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#पिर्टो रिको#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#पुंटा अरेनास#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#पावसाळी न्हय#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#रँकिन इनलॅट#,
		},
		'America/Recife' => {
			exemplarCity => q#रेसीफ#,
		},
		'America/Regina' => {
			exemplarCity => q#रेजीना#,
		},
		'America/Resolute' => {
			exemplarCity => q#रिसोल्युट#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#रियो ब्रांको#,
		},
		'America/Santarem' => {
			exemplarCity => q#सांतारेम#,
		},
		'America/Santiago' => {
			exemplarCity => q#सँटियागो#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#सांतो डोमिंगो#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#साओ पावलो#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#इटोकॉरटॉर्मीट#,
		},
		'America/Sitka' => {
			exemplarCity => q#सिट्का#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#सेंट बार्थेलेमी#,
		},
		'America/St_Johns' => {
			exemplarCity => q#सेंट जॉन्स#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#सेंट किट्स#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#सेंट लुसीया#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#सेंट थॉमस#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#सेंट विन्सेंट#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#स्विफ्ट करंट#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#तेगुसिगल्पा#,
		},
		'America/Thule' => {
			exemplarCity => q#थुले#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#थंडर बे#,
		},
		'America/Tijuana' => {
			exemplarCity => q#तिजुआना#,
		},
		'America/Toronto' => {
			exemplarCity => q#टॉरंटो#,
		},
		'America/Tortola' => {
			exemplarCity => q#टोरटोला#,
		},
		'America/Vancouver' => {
			exemplarCity => q#व्हँकुव्हर#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#व्हायटहॉर्स#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#विनीपेग#,
		},
		'America/Yakutat' => {
			exemplarCity => q#याकुटाट#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#यलोक्नायफ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#मध्य डेलायट वेळ#,
				'generic' => q#मध्य वेळ#,
				'standard' => q#मध्य प्रमाणित वेळ#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#उदेंतेचो डेलायट वेळ#,
				'generic' => q#उदेंत वेळ#,
				'standard' => q#उदेंत प्रमाणित वेळ#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#पर्वतीय डेलायट वेळ#,
				'generic' => q#पर्वतीय वेळ#,
				'standard' => q#पर्वतीय प्रमाणित वेळ#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#प्रशांत डेलायट वेळ#,
				'generic' => q#प्रशांत वेळ#,
				'standard' => q#प्रशांत प्रमाणित वेळ#,
			},
		},
		'Argentina' => {
			long => {
				'daylight' => q#अर्जेंटिना ग्रीष्म वेळ#,
				'generic' => q#अर्जेंटिना वेळ#,
				'standard' => q#अर्जेंटिना प्रमाणित वेळ#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#अस्तंत अर्जेंटिना ग्रीष्म वेळ#,
				'generic' => q#अस्तंत अर्जेंटिना वेळ#,
				'standard' => q#अस्तंत अर्जेंटिना प्रमाणित वेळ#,
			},
		},
		'Atlantic' => {
			long => {
				'daylight' => q#अटलांटीक डेलायट वेळ#,
				'generic' => q#अटलांटीक वेळ#,
				'standard' => q#अटलांटीक प्रमाणित वेळ#,
			},
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#बर्मुडा#,
		},
		'Bolivia' => {
			long => {
				'standard' => q#बोलिव्हिया वेळ#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ब्राझिलिया ग्रीष्म वेळ#,
				'generic' => q#ब्राझिलिया वेळ#,
				'standard' => q#ब्राझिलिया प्रमाणित वेळ#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#चिली ग्रीष्म वेळ#,
				'generic' => q#चिली वेळ#,
				'standard' => q#चिली प्रमाणित वेळ#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#कोलंबिया ग्रीष्म वेळ#,
				'generic' => q#कोलंबिया#,
				'standard' => q#कोलंबिया प्रमाणित वेळ#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#क्युबा डेलायट वेळ#,
				'generic' => q#क्युबा वेळ#,
				'standard' => q#क्युबा प्रमाणित वेळ#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ईस्टर आयलँड ग्रीष्म वेळ#,
				'generic' => q#ईस्टर आयलँड वेळ#,
				'standard' => q#ईस्टर आयलँड प्रमाणित वेळ#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#इक्वेडोर वेळ#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#समन्वित वैश्विक वेळ#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#अज्ञात शार#,
		},
		'Europe/Dublin' => {
			long => {
				'daylight' => q#आयरिश प्रमाणित वेळ#,
			},
		},
		'Europe/London' => {
			long => {
				'daylight' => q#ब्रिटिश ग्रीष्म वेळ#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#फॉकलँड आयलँड्स ग्रीष्म वेळ#,
				'generic' => q#फॉकलँड आयलँड्स वेळ#,
				'standard' => q#फॉकलँड आयलँड्स प्रमाणित वेळ#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#फ्रेंच गयाना वेळ#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#गालापागोस वेळ#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#उदेंत ग्रीनलँड ग्रीष्म वेळ#,
				'generic' => q#उदेंत ग्रीनलँड वेळ#,
				'standard' => q#उदेंत ग्रीनलँड प्रमाणित वेळ#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#अस्तंत ग्रीनलँड ग्रीष्म वेळ#,
				'generic' => q#अस्तंत ग्रीनलँड वेळ#,
				'standard' => q#अस्तंत ग्रीनलँड प्रमाणित वेळ#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#गुयाना वेळ#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#हवाई-अलेयुशिन डेलायट वेळ#,
				'generic' => q#हवाई-अलेयुशिन वेळ#,
				'standard' => q#हवाई-अलेयुशिन प्रमाणित वेळ#,
			},
		},
		'India' => {
			long => {
				'standard' => q#भारतीय समय#,
			},
			short => {
				'standard' => q#IST#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#वायव्य मेक्सिको डेलायट वेळ#,
				'generic' => q#वायव्य मेक्सिको वेळ#,
				'standard' => q#वायव्य मेक्सिको प्रमाणित वेळ#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#मेक्सिकन प्रशांत डेलायट वेळ#,
				'generic' => q#मेक्सिकन प्रशांत वेळ#,
				'standard' => q#मेक्सिकन प्रशांत प्रमाणित वेळ#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#न्युफावंडलँड डेलायट वेळ#,
				'generic' => q#न्युफावंडलँड वेळ#,
				'standard' => q#न्युफावंडलँड प्रमाणित वेळ#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#Vote फर्नांडो दी नोरोन्हा ग्रीष्म वेळ#,
				'generic' => q#फर्नांडो दी नोरोन्हा वेळ#,
				'standard' => q#फर्नांडो दी नोरोन्हा प्रमाणित वेळ#,
			},
		},
		'Pacific/Easter' => {
			exemplarCity => q#ईस्टर#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#गालापागोस#,
		},
		'Paraguay' => {
			long => {
				'daylight' => q#परागुआ ग्रीष्म वेळ#,
				'generic' => q#परागुआ वेळ#,
				'standard' => q#परागुआ प्रमाणित वेळ#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#पेरू ग्रीष्म वेळ#,
				'generic' => q#पेरू वेळ#,
				'standard' => q#पेरू प्रमाणित वेळ#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#सेंट पियर आनी मिकलान डेलायट वेळ#,
				'generic' => q#सेंट पियर आनी मिकलान वेळ#,
				'standard' => q#सेंट पियर आनी मिकलान प्रमाणित वेळ#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#दक्षिण जॉर्जिया वेळ#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#सुरिनाम वेळ#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#उरुग्वे ग्रीष्म वेळ#,
				'generic' => q#उरुग्वे वेळ#,
				'standard' => q#उरुग्वे प्रमाणित वेळ#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#वेनेझुएला वेळ#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
