#!/usr/local/bin/perl

# Thanks to Graham Barr <gbarr@ti.com> for contributing this test script!

use strict;
use Lingua::EN::Nums2Words;

print "1..",7*3,"\n";

$/ = "";
my $i = 1;
while(<DATA>) {
 my($num,$word,$ord,$dollar) = split(/\n/,$_);
 print "not " unless $word eq &num2word($num);
 printf "ok %d\n",$i++;
 print "not " unless $ord eq &num2word_ordinal($num);
 printf "ok %d\n",$i++;
 print "not " unless $dollar eq &num2usdollars($num);
 printf "ok %d\n",$i++;
}

__DATA__
-3793.793
NEGATIVE THREE THOUSAND, SEVEN HUNDRED NINETY-THREE AND SEVEN HUNDRED NINETY-THREE THOUSANDTHS
NEGATIVE THREE THOUSAND, SEVEN HUNDRED NINETY-THIRD AND SEVEN HUNDRED NINETY-THREE THOUSANDTHS
NEGATIVE THREE THOUSAND, SEVEN HUNDRED NINETY-THREE DOLLARS AND SEVENTY-NINE CENTS

3875.5798
THREE THOUSAND, EIGHT HUNDRED SEVENTY-FIVE AND FIVE THOUSAND, SEVEN HUNDRED NINETY-EIGHT TEN-THOUSANDTHS
THREE THOUSAND, EIGHT HUNDRED SEVENTY-FIFTH AND FIVE THOUSAND, SEVEN HUNDRED NINETY-EIGHT TEN-THOUSANDTHS
THREE THOUSAND, EIGHT HUNDRED SEVENTY-FIVE DOLLARS AND FIFTY-EIGHT CENTS

-318.2983
NEGATIVE THREE HUNDRED EIGHTEEN AND TWO THOUSAND, NINE HUNDRED EIGHTY-THREE TEN-THOUSANDTHS
NEGATIVE THREE HUNDRED EIGHTEENTH AND TWO THOUSAND, NINE HUNDRED EIGHTY-THREE TEN-THOUSANDTHS
NEGATIVE THREE HUNDRED EIGHTEEN DOLLARS AND THIRTY CENTS

1466.8
ONE THOUSAND, FOUR HUNDRED SIXTY-SIX AND EIGHT TENTHS
ONE THOUSAND, FOUR HUNDRED SIXTY-SIXTH AND EIGHT TENTHS
ONE THOUSAND, FOUR HUNDRED SIXTY-SIX DOLLARS AND EIGHTY CENTS

-554.05
NEGATIVE FIVE HUNDRED FIFTY-FOUR AND FIVE HUNDREDTHS
NEGATIVE FIVE HUNDRED FIFTY-FOURTH AND FIVE HUNDREDTHS
NEGATIVE FIVE HUNDRED FIFTY-FOUR DOLLARS AND FIVE CENTS

1470.6421
ONE THOUSAND, FOUR HUNDRED SEVENTY AND SIX THOUSAND, FOUR HUNDRED TWENTY-ONE TEN-THOUSANDTHS
ONE THOUSAND, FOUR HUNDRED SEVENTIETH AND SIX THOUSAND, FOUR HUNDRED TWENTY-ONE TEN-THOUSANDTHS
ONE THOUSAND, FOUR HUNDRED SEVENTY DOLLARS AND SIXTY-FOUR CENTS

476206098657263575912.476206098657263575912
FOUR HUNDRED SEVENTY-SIX QUINTILLION, TWO HUNDRED SIX QUADRILLION, NINETY-EIGHT TRILLION, SIX HUNDRED FIFTY-SEVEN BILLION, TWO HUNDRED SIXTY-THREE MILLION, FIVE HUNDRED SEVENTY-FIVE THOUSAND, NINE HUNDRED TWELVE AND FOUR HUNDRED SEVENTY-SIX QUINTILLION, TWO HUNDRED SIX QUADRILLION, NINETY-EIGHT TRILLION, SIX HUNDRED FIFTY-SEVEN BILLION, TWO HUNDRED SIXTY-THREE MILLION, FIVE HUNDRED SEVENTY-FIVE THOUSAND, NINE HUNDRED TWELVE DUODECILLIONTHS
FOUR HUNDRED SEVENTY-SIX QUINTILLION, TWO HUNDRED SIX QUADRILLION, NINETY-EIGHT TRILLION, SIX HUNDRED FIFTY-SEVEN BILLION, TWO HUNDRED SIXTY-THREE MILLION, FIVE HUNDRED SEVENTY-FIVE THOUSAND, NINE HUNDRED TWELFTH AND FOUR HUNDRED SEVENTY-SIX QUINTILLION, TWO HUNDRED SIX QUADRILLION, NINETY-EIGHT TRILLION, SIX HUNDRED FIFTY-SEVEN BILLION, TWO HUNDRED SIXTY-THREE MILLION, FIVE HUNDRED SEVENTY-FIVE THOUSAND, NINE HUNDRED TWELVE DUODECILLIONTHS
FOUR HUNDRED SEVENTY-SIX QUINTILLION, TWO HUNDRED SIX QUADRILLION, NINETY-EIGHT TRILLION, SIX HUNDRED FIFTY-SEVEN BILLION, TWO HUNDRED SIXTY-THREE MILLION, FIVE HUNDRED SEVENTY-FIVE THOUSAND, NINE HUNDRED TWELVE DOLLARS AND FORTY-EIGHT CENTS

