#!/usr/local/bin/perl -w
use 5.008;
use strict;
use warnings;
use utf8;

use Test::More tests => 10;

BEGIN {
    use_ok( 'CGI::Cookie::Pack' );
};

my @Text = <DATA>;
@Text = split /\n<!-- CUT HERE -- CUT HERE -- CUT HERE -- CUT HERE -- CUT HERE -->\n/, join('', @Text);

my $obj = CGI::Cookie::Pack->new;
isa_ok( $obj, 'CGI::Cookie::Pack' );

my @param = (
    name   => 'Masanori HATA'           ,
    mail   => 'lovewing@geocities.co.jp',
    sex    => 'male'                    ,
    birth  => '2003-04-09'              ,
    nation => 'Japan'                   ,
    pref   => 'Saitama'                 ,
    city   => 'Kawaguchi'               ,
    tel    => '+81-48-2XX-XXXX'         ,
    fax    => '+81-48-2XX-XXXX'         ,
    job    => 'student&teacher'         ,
    role   => 'servant&president'       ,
    hobby  => '99% exaggeration'        ,
    text1  => 'E=I*R'                   ,
    text2  => $Text[0]                  ,
    );

########################################################################
my @got = CGI::Cookie::Pack->packin(
    name  => 'packed',
    param => [@param],
    );

my @Text2 = split /; /, $Text[1];

my $mismatch = 0;
for (my $i = 0; $i <= $#Text2; $i++) {
    unless ($got[$i] eq $Text2[$i]) {
        $mismatch = 1;
    }
}
is($mismatch, 0, 'packin  (splitted)');

########################################################################
$ENV{'HTTP_COOKIE'} = $Text[1];

@got = CGI::Cookie::Pack->packout;

$mismatch = 0;
for (my $i = 0; $i <= $#param; $i++) {
    unless ($got[$i] eq $param[$i]) {
        $mismatch = 1;
    }
}

is($mismatch, 0, 'packout (splitted)');

########################################################################
my $got = CGI::Cookie::Pack->packin(
    name  => 'packed',
    param => [@param],
    monolith => 1,
    );

is($got, $Text[2], 'packin  (monolith)');

########################################################################
$ENV{'HTTP_COOKIE'} = $Text[2];

@got = CGI::Cookie::Pack->packout(
    monolith => 1,
    );

$mismatch = 0;
for (my $i = 0; $i <= $#param; $i++) {
    unless ($got[$i] eq $param[$i]) {
        $mismatch = 1;
    }
}
is($mismatch, 0, 'packout (monolith)');

########################################################################
@param = (
    '名前'   => '畑 正憲',
    'メール' => 'lovewing@geocities.co.jp',
    '性別'   => '男性',
    '誕生日' => '2003-04-09',
    '国籍'   => '日本',
    '県'     => '埼玉',
    '市'     => '川口',
    '電話'   => '+81-48-2XX-XXXX',
    'ＦＡＸ' => '+81-48-2XX-XXXX',
    '職業'   => '生徒&先生',
    '役職'   => '召使&社長',
    '趣味'   => '99% 誇大表現',
    '文章１' => 'Ｅ=Ｉ×Ｒ',
    '文章２' => $Text[0],
);

@got = CGI::Cookie::Pack->packin(
    name  => '梱包',
    param => [@param],
    );

my @Text3 = split /; /, $Text[3];

$mismatch = 0;
for (my $i = 0; $i <= $#Text3; $i++) {
    unless ($got[$i] eq $Text3[$i]) {
        $mismatch = 1;
    }
}
is($mismatch, 0, 'packin  (splitted) w/ Kanji');

########################################################################
$ENV{'HTTP_COOKIE'} = $Text[3];

@got = CGI::Cookie::Pack->packout;

$mismatch = 0;
for (my $i = 0; $i <= $#param; $i++) {
    unless ($got[$i] eq $param[$i]) {
        $mismatch = 1;
    }
}
is($mismatch, 0, 'packout (splitted) w/ Kanji');

########################################################################
$got = CGI::Cookie::Pack->packin(
    name  => '梱包',
    param => [@param],
    monolith => 1,
    );
is($got, $Text[4], ' packin  (monolith) w/ Kanji');

########################################################################
$ENV{'HTTP_COOKIE'} = $Text[4];

@got = CGI::Cookie::Pack->packout(
    monolith => 1,
    );

$mismatch = 0;
for (my $i = 0; $i <= $#param; $i++) {
    unless ($got[$i] eq $param[$i]) {
        $mismatch = 1;
    }
}
is($mismatch, 0, 'packout (monolith) w/ Kanji');

########################################################################
__END__
<h1>PERSISTENT CLIENT STATE HTTP COOKIES</h1>
<h2>Preliminary Specification - Use with caution</h2>

<h2>INTRODUCTION</h2>
<p>Cookies are a general mechanism which server side connections (such as CGI scripts) can use to both store and retrieve information on the client side of the connection. The addition of a simple, persistent, client-side state significantly extends the capabilities of Web-based client/server applications.</p>

<h2>OVERVIEW</h2>
<p>A server, when returning an HTTP object to a client, may also send a piece of state information which the client will store.  Included in that state object is a description of the range of URLs for which that state is valid.  Any future HTTP requests made by the client which fall in that range will include a transmittal of the current value of the state object from the client back to the server.  The state object is called a <strong>cookie</strong>, for no compelling reason. </p>
<p>This simple mechanism provides a powerful new tool which enables a host of new types of applications to be written for web-based environments. Shopping applications can now store information about the currently selected items, for fee services can send back registration information and free the client from retyping a user-id on next connection, sites can store per-user preferences on the client, and have the client supply
those preferences every time that site is connected to.</p>

<h2>SPECIFICATION</h2>
<p>A cookie is introduced to the client by including a <strong>Set-Cookie</strong> header as part of an HTTP response, typically this will be generated by a CGI script.</p>

<h2>Syntax of the Set-Cookie HTTP Response Header</h2>
<p>This is the format a CGI script would use to add to the HTTP headers a new piece of data which is to be stored by the client for later retrieval.</p>
<pre>
Set-Cookie: <em>NAME</em>=<em>VALUE</em>; expires=<em>DATE</em>;
path=<em>PATH</em>; domain=<em>DOMAIN_NAME</em>; secure
</pre>
<dl>
<dt><em>NAME</em>=<em>VALUE</em></dt><dd>This string is a sequence of characters excluding semi-colon, comma and white space.  If there is a need to place such data in the name or value, some encoding method such as URL style %XX encoding is recommended, though no encoding is defined or required. <p>  This is the only required attribute on the <strong>Set-Cookie</strong> header. </dd>
<dt><strong>expires</strong>=<em>DATE</em></dt><dd>The <strong>expires</strong> attribute specifies a date string that defines the valid life time of that cookie.  Once the expiration date has been reached, the cookie will no longer be stored or given out. <br />
The date string is formatted as:
<blockquote><code>Wdy, DD-Mon-YYYY HH:MM:SS GMT</code></blockquote>
This is based on
<a href="http://ds.internic.net/rfc/rfc822.txt">RFC 822</a>, <a href="http://ds.internic.net/rfc/rfc850.txt">RFC 850</a>, <a href="http://www.w3.org/hypertext/WWW/Protocols/rfc1036/rfc1036.html#z6">RFC 1036</a>, and <a href="http://ds1.internic.net/rfc/rfc1123.txt">RFC 1123</a>, with the variations that the only legal time zone is <strong>GMT</strong> and the separators between the elements of the date must be dashes.<br />
<strong>expires</strong> is an optional attribute.  If not specified, the cookie will expire when the user's session ends. <br />
<strong>Note:</strong> There is a bug in Netscape Navigator version 1.1 and earlier. Only cookies whose <strong>path</strong> attribute is set explicitly to "/" will be properly saved between sessions if they have an <strong>expires</strong> attribute.</dd>
<dt><strong>domain</strong>=<em>DOMAIN_NAME</em></dt><dd>When searching the cookie list for valid cookies, a comparison of the <strong>domain</strong> attributes of the cookie is made with the Internet domain name of the host from which the URL will be fetched.  If there is a tail match, then the cookie will go through <strong>path</strong> matching to see if it should be sent.  "Tail matching" means that <strong>domain</strong> attribute is matched against the tail of the fully qualified domain name of the host.  A <strong>domain</strong> attribute of "acme.com" would match host names "anvil.acme.com" as well as "shipping.crate.acme.com". <br />
Only hosts within the specified domain can set a cookie for a domain and domains must have at least two (2)
or three (3) periods in them to prevent domains of the form: ".com", ".edu", and "va.us".  Any domain that fails within one of the seven special top level domains listed below only require two periods.  Any other domain requires at least three.  The seven special top level domains are: "COM", "EDU", "NET", "ORG", "GOV", "MIL", and "INT".<br />
The default value of <strong>domain</strong> is the host name of the server which generated the cookie response. </dd>
<dt><strong>path</strong>=<em>PATH</em></dt><dd>The <strong>path</strong> attribute is used to specify the subset of URLs in a domain for which the cookie is valid.  If a cookie has already passed <strong>domain</strong> matching, then the pathname component of the URL is compared with the path attribute, and if there is a match, the cookie is considered valid and is sent along with the URL request. The path "/foo" would match "/foobar" and "/foo/bar.html".  The path "/" is the most general path. <p>
If the <strong>path</strong> is not specified, it as assumed to be the same path as the document being described by the header which contains the cookie.</dd>
<dt><strong>secure</strong></dt><dd>If a cookie is marked <strong>secure</strong>, it will only be transmitted if the communications channel with the host is a secure one.  Currently this means that secure cookies will only be sent to HTTPS (HTTP over SSL) servers. <br />
If <strong>secure</strong> is not specified, a cookie is considered safe to be sent in the clear over unsecured channels.</dd>
</dl>

<h2>Syntax of the Cookie HTTP Request Header</h2>
<p>When requesting a URL from an HTTP server, the browser will match the URL against all cookies and if any of them match, a line containing the name/value pairs of all matching cookies will be included in the HTTP request.  Here is the format of that line:</p>
<pre>
Cookie: <em>NAME1=OPAQUE_STRING1</em>; <em>NAME2=OPAQUE_STRING2 ...</em>
</pre>

<h2>Additional Notes</h2>
<ul>
<li>Multiple <strong>Set-Cookie</strong> headers can be issued in a single server response.</li>
<li>Instances of the same path and name will overwrite each other, with the latest instance taking precedence.  Instances of the same path but different names will add additional mappings.</li>
<li>Setting the path to a higher-level value does not override other more specific path mappings.  If there are multiple matches for a given cookie name, but with separate paths, all the matching cookies will be sent. (See examples below.)</li>
<li>The expires header lets the client know when it is safe to purge the mapping but the client is not required to do so.  A client may also delete a cookie before it's expiration date arrives if the number of cookies exceeds its internal limits.</li>
<li>When sending cookies to a server, all cookies with a more specific path mapping should be sent before cookies with less specific path mappings.  For example, a cookie "name1=foo" with a path mapping of "/" should be sent after a cookie "name1=foo2" with a path mapping of "/bar" if they are both to be sent.</li>
<li>There are limitations on the number of cookies that a client can store at any one time.  This is a specification of the minimum number of cookies that a client should be prepared to receive and store.
    <ul>
    <li>300 total cookies</li>
    <li>4 kilobytes per cookie, where the name and the OPAQUE_STRING combine to form the 4 kilobyte limit.</li>
    <li>20 cookies per server or domain.  (note that completely specified hosts and domains are treated as separate entities and have a 20 cookie limitation for each, not combined)</li>
    </ul>
Servers should not expect clients to be able to exceed these limits. When the 300 cookie limit or the 20 cookie per server limit is exceeded, clients should delete the least recently used cookie. When a cookie larger than 4 kilobytes is encountered the cookie should be trimmed to fit, but the name should remain intact as long as it is less than 4 kilobytes.</li>
<li>If a CGI script wishes to delete a cookie, it can do so by returning a cookie with the same name, and an <strong>expires</strong> time which is in the past.  The path and name must match exactly in order for the expiring cookie to replace the valid cookie. This requirement makes it difficult for anyone but the originator of a cookie to delete a cookie.</li>
<li>When caching HTTP, as a proxy server might do, the <strong>Set-cookie</strong> response header should never be cached.</li>
<li>If a proxy server receives a response which contains a <strong>Set-cookie</strong> header, it should propagate the <strong>Set-cookie</strong> header to the client, regardless of whether the response was 304
(Not Modified) or 200 (OK).</li>
<li>Similarly, if a client request contains a Cookie: header, it should be forwarded through a proxy, even if the conditional If-modified-since request is being made.</li>
</ul>

<h2>EXAMPLES</h2>
<p>Here are some sample exchanges which are designed to illustrate the use of cookies.</p>
<h3>First Example transaction sequence:</h3>
<dl>
<dt>Client requests a document, and receives in the response:</dt><dd>
<pre>
Set-Cookie: CUSTOMER=WILE_E_COYOTE; path=/; expires=Wednesday, 09-Nov-99 23:12:40 GMT</pre></dd>
<dt>When client requests a URL in path "/" on this server, it sends:</dt><dd>
<pre>Cookie: CUSTOMER=WILE_E_COYOTE</pre></dd>
<dt>Client requests a document, and receives in the response:</dt><dd>
<pre>Set-Cookie: PART_NUMBER=ROCKET_LAUNCHER_0001; path=/</pre></dd>
<dt>When client requests a URL in path "/" on this server, it sends:</dt><dd>
<pre>Cookie: CUSTOMER=WILE_E_COYOTE; PART_NUMBER=ROCKET_LAUNCHER_0001</pre></dd>
<dt>Client receives:</dt><dd>
<pre>Set-Cookie: SHIPPING=FEDEX; path=/foo</pre></dd>
<dt>When client requests a URL in path "/" on this server, it sends:</dt><dd>
<pre>Cookie: CUSTOMER=WILE_E_COYOTE; PART_NUMBER=ROCKET_LAUNCHER_0001</pre></dd>
<dt>When client requests a URL in path "/foo" on this server, it sends:</dt><dd>
<pre>Cookie: CUSTOMER=WILE_E_COYOTE; PART_NUMBER=ROCKET_LAUNCHER_0001; SHIPPING=FEDEX</pre></dd>
</dl>
<h3>Second Example transaction sequence:</h3>
<dl>
<dt>Assume all mappings from above have been cleared.</dt><dd></dd>
<dt>Client receives:</dt><dd>
<pre>Set-Cookie: PART_NUMBER=ROCKET_LAUNCHER_0001; path=/</pre></dd>
<dt>When client requests a URL in path "/" on this server, it sends:</dt><dd>
<pre>Cookie: PART_NUMBER=ROCKET_LAUNCHER_0001</pre></dd>
<dt>Client receives:</dt><dd>
<pre>Set-Cookie: PART_NUMBER=RIDING_ROCKET_0023; path=/ammo</pre></dd>
<dt>When client requests a URL in path "/ammo" on this server, it sends:</dt><dd>
<pre>Cookie: PART_NUMBER=RIDING_ROCKET_0023; PART_NUMBER=ROCKET_LAUNCHER_0001</pre></dd>
<dt></dt><dd>NOTE: There are two name/value pairs named "PART_NUMBER" due to the inheritance of the "/" mapping in addition to the "/ammo" mapping.</dd>
</dl>
<!-- CUT HERE -- CUT HERE -- CUT HERE -- CUT HERE -- CUT HERE -->
packed_00=name%3DMasanori%20HATA%26mail%3Dlovewing%40geocities.co.jp%26sex%3Dmale%26birth%3D2003-04-09%26nation%3DJapan%26pref%3DSaitama%26city%3DKawaguchi%26tel%3D%2B81-48-2XX-XXXX%26fax%3D%2B81-48-2XX-XXXX%26job%3Dstudent%25Ateacher%26role%3Dservant%25Apresident%26hobby%3D99%25P%20exaggeration%26text1%3DE%25EI*R%26text2%3D%3Ch1%3EPERSISTENT%20CLIENT%20STATE%20HTTP%20COOKIES%3C%2Fh1%3E%0A%3Ch2%3EPreliminary%20Specification%20-%20Use%20with%20caution%3C%2Fh2%3E%0A%0A%3Ch2%3EINTRODUCTION%3C%2Fh2%3E%0A%3Cp%3ECookies%20are%20a%20general%20mechanism%20which%20server%20side%20connections%20(such%20as%20CGI%20scripts)%20can%20use%20to%20both%20store%20and%20retrieve%20information%20on%20the%20client%20side%20of%20the%20connection.%20The%20addition%20of%20a%20simple%2C%20persistent%2C%20client-side%20state%20significantly%20extends%20the%20capabilities%20of%20Web-based%20client%2Fserver%20applications.%3C%2Fp%3E%0A%0A%3Ch2%3EOVERVIEW%3C%2Fh2%3E%0A%3Cp%3EA%20server%2C%20when%20returning%20an%20HTTP%20object%20to%20a%20client%2C%20may%20also%20send%20a%20piece%20of%20state%20information%20which%20the%20client%20will%20store.%20%20Included%20in%20that%20state%20object%20is%20a%20description%20of%20the%20range%20of%20URLs%20for%20which%20that%20state%20is%20valid.%20%20Any%20future%20HTTP%20requests%20made%20by%20the%20client%20which%20fall%20in%20that%20range%20will%20include%20a%20transmittal%20of%20the%20current%20value%20of%20the%20state%20object%20from%20the%20client%20back%20to%20the%20server.%20%20The%20state%20object%20is%20called%20a%20%3Cstrong%3Ecookie%3C%2Fstrong%3E%2C%20for%20no%20compelling%20reason.%20%3C%2Fp%3E%0A%3Cp%3EThis%20simple%20mechanism%20provides%20a%20powerful%20new%20tool%20which%20enables%20a%20host%20of%20new%20types%20of%20applications%20to%20be%20written%20for%20web-based%20environments.%20Shopping%20applications%20can%20now%20store%20information%20about%20the%20currently%20selected%20items%2C%20for%20fee%20services%20can%20send%20back%20registration%20information%20and%20free%20the%20client%20from%20retyping%20a%20user-id%20on%20next%20connection%2C%20sites%20can%20store%20per-user%20preferences%20on%20the%20client%2C%20and%20have%20the%20client%20supply%0Athose%20preferences%20every%20time%20that%20site%20is%20connected%20to.%3C%2Fp%3E%0A%0A%3Ch2%3ESPECIFICATION%3C%2Fh2%3E%0A%3Cp%3EA%20cookie%20is%20introduced%20to%20the%20client%20by%20including%20a%20%3Cstrong%3ESet-Cookie%3C%2Fstrong%3E%20header%20as%20part%20of%20an%20HTTP%20response%2C%20typically%20this%20will%20be%20generated%20by%20a%20CGI%20script.%3C%2Fp%3E%0A%0A%3Ch2%3ESyntax%20of%20the%20Set-Cookie%20HTTP%20Response%20Header%3C%2Fh2%3E%0A%3Cp%3EThis%20is%20the%20format%20a%20CGI%20script%20would%20use%20to%20add%20to%20the%20HTTP%20headers%20a%20new%20piece%20of%20data%20which%20is%20to%20be%20stored%20by%20the%20client%20for%20later%20retrieval.%3C%2Fp%3E%0A%3Cpre%3E%0ASet-Cookie%3A%20%3Cem%3ENAME%3C%2Fem%3E%25E%3Cem%3EVALUE%3C%2Fem%3E%3B%20expires%25E%3Cem%3EDATE%3C%2Fem%3E%3B%0Apath%25E%3Cem%3EPATH%3C%2Fem%3E%3B%20domain%25E%3Cem%3EDOMAIN_NAME%3C%2Fem%3E%3B%20secure%0A%3C%2Fpre%3E%0A%3Cdl%3E%0A%3Cdt%3E%3Cem%3ENAME%3C%2Fem%3E%25E%3Cem%3EVALUE%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EThis%20string%20is%20a%20sequence%20of%20characters%20excluding%20semi-colon%2C%20comma%20and%20white%20space.%20%20If%20there%20is%20a%20need%20to%20place%20such%20data%20in%20the%20name%20or%20value%2C%20some%20encoding%20method%20such%20as%20URL%20style%20%25PXX%20encoding%20is%20recommended%2C%20though%20no%20encoding%20is%20defined%20or%20required.%20%3Cp%3E%20%20This%20is%20the%20only%20required%20attribute%20on%20the%20%3Cstrong%3ESet-Cookie%3C%2Fstrong%3E%20header.%20%3C%2Fdd%3E%0A%3Cdt%3E%3Cstrong%3Eexpires%3C%2Fstrong%3E%25E%3Cem%3EDATE%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EThe%20%3Cstrong%3Eexpires%3C%2Fstrong%3E%20attribute%20specifies%20a%20date%20string%20that%20defines%20the%20valid%20life%20time%20of%20that%20cookie.%20%20Once%20the%20expiration%20date%20has%20been%20reached%2C%20the%20cookie%20will%20no%20longer%20be%20stored%20or%20given%20out.%20%3Cbr%20%2F%; packed_01=3E%0AThe%20date%20string%20is%20formatted%20as%3A%0A%3Cblockquote%3E%3Ccode%3EWdy%2C%20DD-Mon-YYYY%20HH%3AMM%3ASS%20GMT%3C%2Fcode%3E%3C%2Fblockquote%3E%0AThis%20is%20based%20on%0A%3Ca%20href%25E%22http%3A%2F%2Fds.internic.net%2Frfc%2Frfc822.txt%22%3ERFC%20822%3C%2Fa%3E%2C%20%3Ca%20href%25E%22http%3A%2F%2Fds.internic.net%2Frfc%2Frfc850.txt%22%3ERFC%20850%3C%2Fa%3E%2C%20%3Ca%20href%25E%22http%3A%2F%2Fwww.w3.org%2Fhypertext%2FWWW%2FProtocols%2Frfc1036%2Frfc1036.html%23z6%22%3ERFC%201036%3C%2Fa%3E%2C%20and%20%3Ca%20href%25E%22http%3A%2F%2Fds1.internic.net%2Frfc%2Frfc1123.txt%22%3ERFC%201123%3C%2Fa%3E%2C%20with%20the%20variations%20that%20the%20only%20legal%20time%20zone%20is%20%3Cstrong%3EGMT%3C%2Fstrong%3E%20and%20the%20separators%20between%20the%20elements%20of%20the%20date%20must%20be%20dashes.%3Cbr%20%2F%3E%0A%3Cstrong%3Eexpires%3C%2Fstrong%3E%20is%20an%20optional%20attribute.%20%20If%20not%20specified%2C%20the%20cookie%20will%20expire%20when%20the%20user's%20session%20ends.%20%3Cbr%20%2F%3E%0A%3Cstrong%3ENote%3A%3C%2Fstrong%3E%20There%20is%20a%20bug%20in%20Netscape%20Navigator%20version%201.1%20and%20earlier.%20Only%20cookies%20whose%20%3Cstrong%3Epath%3C%2Fstrong%3E%20attribute%20is%20set%20explicitly%20to%20%22%2F%22%20will%20be%20properly%20saved%20between%20sessions%20if%20they%20have%20an%20%3Cstrong%3Eexpires%3C%2Fstrong%3E%20attribute.%3C%2Fdd%3E%0A%3Cdt%3E%3Cstrong%3Edomain%3C%2Fstrong%3E%25E%3Cem%3EDOMAIN_NAME%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EWhen%20searching%20the%20cookie%20list%20for%20valid%20cookies%2C%20a%20comparison%20of%20the%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20attributes%20of%20the%20cookie%20is%20made%20with%20the%20Internet%20domain%20name%20of%20the%20host%20from%20which%20the%20URL%20will%20be%20fetched.%20%20If%20there%20is%20a%20tail%20match%2C%20then%20the%20cookie%20will%20go%20through%20%3Cstrong%3Epath%3C%2Fstrong%3E%20matching%20to%20see%20if%20it%20should%20be%20sent.%20%20%22Tail%20matching%22%20means%20that%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20attribute%20is%20matched%20against%20the%20tail%20of%20the%20fully%20qualified%20domain%20name%20of%20the%20host.%20%20A%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20attribute%20of%20%22acme.com%22%20would%20match%20host%20names%20%22anvil.acme.com%22%20as%20well%20as%20%22shipping.crate.acme.com%22.%20%3Cbr%20%2F%3E%0AOnly%20hosts%20within%20the%20specified%20domain%20can%20set%20a%20cookie%20for%20a%20domain%20and%20domains%20must%20have%20at%20least%20two%20(2)%0Aor%20three%20(3)%20periods%20in%20them%20to%20prevent%20domains%20of%20the%20form%3A%20%22.com%22%2C%20%22.edu%22%2C%20and%20%22va.us%22.%20%20Any%20domain%20that%20fails%20within%20one%20of%20the%20seven%20special%20top%20level%20domains%20listed%20below%20only%20require%20two%20periods.%20%20Any%20other%20domain%20requires%20at%20least%20three.%20%20The%20seven%20special%20top%20level%20domains%20are%3A%20%22COM%22%2C%20%22EDU%22%2C%20%22NET%22%2C%20%22ORG%22%2C%20%22GOV%22%2C%20%22MIL%22%2C%20and%20%22INT%22.%3Cbr%20%2F%3E%0AThe%20default%20value%20of%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20is%20the%20host%20name%20of%20the%20server%20which%20generated%20the%20cookie%20response.%20%3C%2Fdd%3E%0A%3Cdt%3E%3Cstrong%3Epath%3C%2Fstrong%3E%25E%3Cem%3EPATH%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EThe%20%3Cstrong%3Epath%3C%2Fstrong%3E%20attribute%20is%20used%20to%20specify%20the%20subset%20of%20URLs%20in%20a%20domain%20for%20which%20the%20cookie%20is%20valid.%20%20If%20a%20cookie%20has%20already%20passed%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20matching%2C%20then%20the%20pathname%20component%20of%20the%20URL%20is%20compared%20with%20the%20path%20attribute%2C%20and%20if%20there%20is%20a%20match%2C%20the%20cookie%20is%20considered%20valid%20and%20is%20sent%20along%20with%20the%20URL%20request.%20The%20path%20%22%2Ffoo%22%20would%20match%20%22%2Ffoobar%22%20and%20%22%2Ffoo%2Fbar.html%22.%20%20The%20path%20%22%2F%22%20is%20the%20most%20general%20path.%20%3Cp%3E%0AIf%20the%20%3Cstrong%3Epath%3C%2Fstrong%3E%20is%20not%20specified%2C%20it%20as%20assumed%20to%20be%20the%20same%20path%20as%20the%20document%20being%; packed_02=20described%20by%20the%20header%20which%20contains%20the%20cookie.%3C%2Fdd%3E%0A%3Cdt%3E%3Cstrong%3Esecure%3C%2Fstrong%3E%3C%2Fdt%3E%3Cdd%3EIf%20a%20cookie%20is%20marked%20%3Cstrong%3Esecure%3C%2Fstrong%3E%2C%20it%20will%20only%20be%20transmitted%20if%20the%20communications%20channel%20with%20the%20host%20is%20a%20secure%20one.%20%20Currently%20this%20means%20that%20secure%20cookies%20will%20only%20be%20sent%20to%20HTTPS%20(HTTP%20over%20SSL)%20servers.%20%3Cbr%20%2F%3E%0AIf%20%3Cstrong%3Esecure%3C%2Fstrong%3E%20is%20not%20specified%2C%20a%20cookie%20is%20considered%20safe%20to%20be%20sent%20in%20the%20clear%20over%20unsecured%20channels.%3C%2Fdd%3E%0A%3C%2Fdl%3E%0A%0A%3Ch2%3ESyntax%20of%20the%20Cookie%20HTTP%20Request%20Header%3C%2Fh2%3E%0A%3Cp%3EWhen%20requesting%20a%20URL%20from%20an%20HTTP%20server%2C%20the%20browser%20will%20match%20the%20URL%20against%20all%20cookies%20and%20if%20any%20of%20them%20match%2C%20a%20line%20containing%20the%20name%2Fvalue%20pairs%20of%20all%20matching%20cookies%20will%20be%20included%20in%20the%20HTTP%20request.%20%20Here%20is%20the%20format%20of%20that%20line%3A%3C%2Fp%3E%0A%3Cpre%3E%0ACookie%3A%20%3Cem%3ENAME1%25EOPAQUE_STRING1%3C%2Fem%3E%3B%20%3Cem%3ENAME2%25EOPAQUE_STRING2%20...%3C%2Fem%3E%0A%3C%2Fpre%3E%0A%0A%3Ch2%3EAdditional%20Notes%3C%2Fh2%3E%0A%3Cul%3E%0A%3Cli%3EMultiple%20%3Cstrong%3ESet-Cookie%3C%2Fstrong%3E%20headers%20can%20be%20issued%20in%20a%20single%20server%20response.%3C%2Fli%3E%0A%3Cli%3EInstances%20of%20the%20same%20path%20and%20name%20will%20overwrite%20each%20other%2C%20with%20the%20latest%20instance%20taking%20precedence.%20%20Instances%20of%20the%20same%20path%20but%20different%20names%20will%20add%20additional%20mappings.%3C%2Fli%3E%0A%3Cli%3ESetting%20the%20path%20to%20a%20higher-level%20value%20does%20not%20override%20other%20more%20specific%20path%20mappings.%20%20If%20there%20are%20multiple%20matches%20for%20a%20given%20cookie%20name%2C%20but%20with%20separate%20paths%2C%20all%20the%20matching%20cookies%20will%20be%20sent.%20(See%20examples%20below.)%3C%2Fli%3E%0A%3Cli%3EThe%20expires%20header%20lets%20the%20client%20know%20when%20it%20is%20safe%20to%20purge%20the%20mapping%20but%20the%20client%20is%20not%20required%20to%20do%20so.%20%20A%20client%20may%20also%20delete%20a%20cookie%20before%20it's%20expiration%20date%20arrives%20if%20the%20number%20of%20cookies%20exceeds%20its%20internal%20limits.%3C%2Fli%3E%0A%3Cli%3EWhen%20sending%20cookies%20to%20a%20server%2C%20all%20cookies%20with%20a%20more%20specific%20path%20mapping%20should%20be%20sent%20before%20cookies%20with%20less%20specific%20path%20mappings.%20%20For%20example%2C%20a%20cookie%20%22name1%25Efoo%22%20with%20a%20path%20mapping%20of%20%22%2F%22%20should%20be%20sent%20after%20a%20cookie%20%22name1%25Efoo2%22%20with%20a%20path%20mapping%20of%20%22%2Fbar%22%20if%20they%20are%20both%20to%20be%20sent.%3C%2Fli%3E%0A%3Cli%3EThere%20are%20limitations%20on%20the%20number%20of%20cookies%20that%20a%20client%20can%20store%20at%20any%20one%20time.%20%20This%20is%20a%20specification%20of%20the%20minimum%20number%20of%20cookies%20that%20a%20client%20should%20be%20prepared%20to%20receive%20and%20store.%0A%20%20%20%20%3Cul%3E%0A%20%20%20%20%3Cli%3E300%20total%20cookies%3C%2Fli%3E%0A%20%20%20%20%3Cli%3E4%20kilobytes%20per%20cookie%2C%20where%20the%20name%20and%20the%20OPAQUE_STRING%20combine%20to%20form%20the%204%20kilobyte%20limit.%3C%2Fli%3E%0A%20%20%20%20%3Cli%3E20%20cookies%20per%20server%20or%20domain.%20%20(note%20that%20completely%20specified%20hosts%20and%20domains%20are%20treated%20as%20separate%20entities%20and%20have%20a%2020%20cookie%20limitation%20for%20each%2C%20not%20combined)%3C%2Fli%3E%0A%20%20%20%20%3C%2Ful%3E%0AServers%20should%20not%20expect%20clients%20to%20be%20able%20to%20exceed%20these%20limits.%20When%20the%20300%20cookie%20limit%20or%20the%2020%20cookie%20per%20server%20limit%20is%20exceeded%2C%20clients%20should%20delete%20the%20least%20recently%20used%20cookie.%20When%20a%20cookie%20larger%20than%204%20kilobytes%20is%20encountered%20the%20cookie%20should%20be%20trimmed%20to%20; packed_03=fit%2C%20but%20the%20name%20should%20remain%20intact%20as%20long%20as%20it%20is%20less%20than%204%20kilobytes.%3C%2Fli%3E%0A%3Cli%3EIf%20a%20CGI%20script%20wishes%20to%20delete%20a%20cookie%2C%20it%20can%20do%20so%20by%20returning%20a%20cookie%20with%20the%20same%20name%2C%20and%20an%20%3Cstrong%3Eexpires%3C%2Fstrong%3E%20time%20which%20is%20in%20the%20past.%20%20The%20path%20and%20name%20must%20match%20exactly%20in%20order%20for%20the%20expiring%20cookie%20to%20replace%20the%20valid%20cookie.%20This%20requirement%20makes%20it%20difficult%20for%20anyone%20but%20the%20originator%20of%20a%20cookie%20to%20delete%20a%20cookie.%3C%2Fli%3E%0A%3Cli%3EWhen%20caching%20HTTP%2C%20as%20a%20proxy%20server%20might%20do%2C%20the%20%3Cstrong%3ESet-cookie%3C%2Fstrong%3E%20response%20header%20should%20never%20be%20cached.%3C%2Fli%3E%0A%3Cli%3EIf%20a%20proxy%20server%20receives%20a%20response%20which%20contains%20a%20%3Cstrong%3ESet-cookie%3C%2Fstrong%3E%20header%2C%20it%20should%20propagate%20the%20%3Cstrong%3ESet-cookie%3C%2Fstrong%3E%20header%20to%20the%20client%2C%20regardless%20of%20whether%20the%20response%20was%20304%0A(Not%20Modified)%20or%20200%20(OK).%3C%2Fli%3E%0A%3Cli%3ESimilarly%2C%20if%20a%20client%20request%20contains%20a%20Cookie%3A%20header%2C%20it%20should%20be%20forwarded%20through%20a%20proxy%2C%20even%20if%20the%20conditional%20If-modified-since%20request%20is%20being%20made.%3C%2Fli%3E%0A%3C%2Ful%3E%0A%0A%3Ch2%3EEXAMPLES%3C%2Fh2%3E%0A%3Cp%3EHere%20are%20some%20sample%20exchanges%20which%20are%20designed%20to%20illustrate%20the%20use%20of%20cookies.%3C%2Fp%3E%0A%3Ch3%3EFirst%20Example%20transaction%20sequence%3A%3C%2Fh3%3E%0A%3Cdl%3E%0A%3Cdt%3EClient%20requests%20a%20document%2C%20and%20receives%20in%20the%20response%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3E%0ASet-Cookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20path%25E%2F%3B%20expires%25EWednesday%2C%2009-Nov-99%2023%3A12%3A40%20GMT%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20requests%20a%20document%2C%20and%20receives%20in%20the%20response%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3B%20path%25E%2F%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20receives%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20SHIPPING%25EFEDEX%3B%20path%25E%2Ffoo%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2Ffoo%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3B%20SHIPPING%25EFEDEX%3C%2Fpre%3E%3C%2Fdd%3E%0A%3C%2Fdl%3E%0A%3Ch3%3ESecond%20Example%20transaction%20sequence%3A%3C%2Fh3%3E%0A%3Cdl%3E%0A%3Cdt%3EAssume%20all%20mappings%20from%20above%20have%20been%20cleared.%3C%2Fdt%3E%3Cdd%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20receives%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3B%20path%25E%2F%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20receives%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20PART_NUMBER%25ERIDING_ROCKET_0023%3B%20path%25E%2Fammo%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2Fammo%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECoo; packed_04=kie%3A%20PART_NUMBER%25ERIDING_ROCKET_0023%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3E%3C%2Fdt%3E%3Cdd%3ENOTE%3A%20There%20are%20two%20name%2Fvalue%20pairs%20named%20%22PART_NUMBER%22%20due%20to%20the%20inheritance%20of%20the%20%22%2F%22%20mapping%20in%20addition%20to%20the%20%22%2Fammo%22%20mapping.%3C%2Fdd%3E%0A%3C%2Fdl%3E
<!-- CUT HERE -- CUT HERE -- CUT HERE -- CUT HERE -- CUT HERE -->
packed=name%3DMasanori%20HATA%26mail%3Dlovewing%40geocities.co.jp%26sex%3Dmale%26birth%3D2003-04-09%26nation%3DJapan%26pref%3DSaitama%26city%3DKawaguchi%26tel%3D%2B81-48-2XX-XXXX%26fax%3D%2B81-48-2XX-XXXX%26job%3Dstudent%25Ateacher%26role%3Dservant%25Apresident%26hobby%3D99%25P%20exaggeration%26text1%3DE%25EI*R%26text2%3D%3Ch1%3EPERSISTENT%20CLIENT%20STATE%20HTTP%20COOKIES%3C%2Fh1%3E%0A%3Ch2%3EPreliminary%20Specification%20-%20Use%20with%20caution%3C%2Fh2%3E%0A%0A%3Ch2%3EINTRODUCTION%3C%2Fh2%3E%0A%3Cp%3ECookies%20are%20a%20general%20mechanism%20which%20server%20side%20connections%20(such%20as%20CGI%20scripts)%20can%20use%20to%20both%20store%20and%20retrieve%20information%20on%20the%20client%20side%20of%20the%20connection.%20The%20addition%20of%20a%20simple%2C%20persistent%2C%20client-side%20state%20significantly%20extends%20the%20capabilities%20of%20Web-based%20client%2Fserver%20applications.%3C%2Fp%3E%0A%0A%3Ch2%3EOVERVIEW%3C%2Fh2%3E%0A%3Cp%3EA%20server%2C%20when%20returning%20an%20HTTP%20object%20to%20a%20client%2C%20may%20also%20send%20a%20piece%20of%20state%20information%20which%20the%20client%20will%20store.%20%20Included%20in%20that%20state%20object%20is%20a%20description%20of%20the%20range%20of%20URLs%20for%20which%20that%20state%20is%20valid.%20%20Any%20future%20HTTP%20requests%20made%20by%20the%20client%20which%20fall%20in%20that%20range%20will%20include%20a%20transmittal%20of%20the%20current%20value%20of%20the%20state%20object%20from%20the%20client%20back%20to%20the%20server.%20%20The%20state%20object%20is%20called%20a%20%3Cstrong%3Ecookie%3C%2Fstrong%3E%2C%20for%20no%20compelling%20reason.%20%3C%2Fp%3E%0A%3Cp%3EThis%20simple%20mechanism%20provides%20a%20powerful%20new%20tool%20which%20enables%20a%20host%20of%20new%20types%20of%20applications%20to%20be%20written%20for%20web-based%20environments.%20Shopping%20applications%20can%20now%20store%20information%20about%20the%20currently%20selected%20items%2C%20for%20fee%20services%20can%20send%20back%20registration%20information%20and%20free%20the%20client%20from%20retyping%20a%20user-id%20on%20next%20connection%2C%20sites%20can%20store%20per-user%20preferences%20on%20the%20client%2C%20and%20have%20the%20client%20supply%0Athose%20preferences%20every%20time%20that%20site%20is%20connected%20to.%3C%2Fp%3E%0A%0A%3Ch2%3ESPECIFICATION%3C%2Fh2%3E%0A%3Cp%3EA%20cookie%20is%20introduced%20to%20the%20client%20by%20including%20a%20%3Cstrong%3ESet-Cookie%3C%2Fstrong%3E%20header%20as%20part%20of%20an%20HTTP%20response%2C%20typically%20this%20will%20be%20generated%20by%20a%20CGI%20script.%3C%2Fp%3E%0A%0A%3Ch2%3ESyntax%20of%20the%20Set-Cookie%20HTTP%20Response%20Header%3C%2Fh2%3E%0A%3Cp%3EThis%20is%20the%20format%20a%20CGI%20script%20would%20use%20to%20add%20to%20the%20HTTP%20headers%20a%20new%20piece%20of%20data%20which%20is%20to%20be%20stored%20by%20the%20client%20for%20later%20retrieval.%3C%2Fp%3E%0A%3Cpre%3E%0ASet-Cookie%3A%20%3Cem%3ENAME%3C%2Fem%3E%25E%3Cem%3EVALUE%3C%2Fem%3E%3B%20expires%25E%3Cem%3EDATE%3C%2Fem%3E%3B%0Apath%25E%3Cem%3EPATH%3C%2Fem%3E%3B%20domain%25E%3Cem%3EDOMAIN_NAME%3C%2Fem%3E%3B%20secure%0A%3C%2Fpre%3E%0A%3Cdl%3E%0A%3Cdt%3E%3Cem%3ENAME%3C%2Fem%3E%25E%3Cem%3EVALUE%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EThis%20string%20is%20a%20sequence%20of%20characters%20excluding%20semi-colon%2C%20comma%20and%20white%20space.%20%20If%20there%20is%20a%20need%20to%20place%20such%20data%20in%20the%20name%20or%20value%2C%20some%20encoding%20method%20such%20as%20URL%20style%20%25PXX%20encoding%20is%20recommended%2C%20though%20no%20encoding%20is%20defined%20or%20required.%20%3Cp%3E%20%20This%20is%20the%20only%20required%20attribute%20on%20the%20%3Cstrong%3ESet-Cookie%3C%2Fstrong%3E%20header.%20%3C%2Fdd%3E%0A%3Cdt%3E%3Cstrong%3Eexpires%3C%2Fstrong%3E%25E%3Cem%3EDATE%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EThe%20%3Cstrong%3Eexpires%3C%2Fstrong%3E%20attribute%20specifies%20a%20date%20string%20that%20defines%20the%20valid%20life%20time%20of%20that%20cookie.%20%20Once%20the%20expiration%20date%20has%20been%20reached%2C%20the%20cookie%20will%20no%20longer%20be%20stored%20or%20given%20out.%20%3Cbr%20%2F%3E%0AThe%20date%20string%20is%20formatted%20as%3A%0A%3Cblockquote%3E%3Ccode%3EWdy%2C%20DD-Mon-YYYY%20HH%3AMM%3ASS%20GMT%3C%2Fcode%3E%3C%2Fblockquote%3E%0AThis%20is%20based%20on%0A%3Ca%20href%25E%22http%3A%2F%2Fds.internic.net%2Frfc%2Frfc822.txt%22%3ERFC%20822%3C%2Fa%3E%2C%20%3Ca%20href%25E%22http%3A%2F%2Fds.internic.net%2Frfc%2Frfc850.txt%22%3ERFC%20850%3C%2Fa%3E%2C%20%3Ca%20href%25E%22http%3A%2F%2Fwww.w3.org%2Fhypertext%2FWWW%2FProtocols%2Frfc1036%2Frfc1036.html%23z6%22%3ERFC%201036%3C%2Fa%3E%2C%20and%20%3Ca%20href%25E%22http%3A%2F%2Fds1.internic.net%2Frfc%2Frfc1123.txt%22%3ERFC%201123%3C%2Fa%3E%2C%20with%20the%20variations%20that%20the%20only%20legal%20time%20zone%20is%20%3Cstrong%3EGMT%3C%2Fstrong%3E%20and%20the%20separators%20between%20the%20elements%20of%20the%20date%20must%20be%20dashes.%3Cbr%20%2F%3E%0A%3Cstrong%3Eexpires%3C%2Fstrong%3E%20is%20an%20optional%20attribute.%20%20If%20not%20specified%2C%20the%20cookie%20will%20expire%20when%20the%20user's%20session%20ends.%20%3Cbr%20%2F%3E%0A%3Cstrong%3ENote%3A%3C%2Fstrong%3E%20There%20is%20a%20bug%20in%20Netscape%20Navigator%20version%201.1%20and%20earlier.%20Only%20cookies%20whose%20%3Cstrong%3Epath%3C%2Fstrong%3E%20attribute%20is%20set%20explicitly%20to%20%22%2F%22%20will%20be%20properly%20saved%20between%20sessions%20if%20they%20have%20an%20%3Cstrong%3Eexpires%3C%2Fstrong%3E%20attribute.%3C%2Fdd%3E%0A%3Cdt%3E%3Cstrong%3Edomain%3C%2Fstrong%3E%25E%3Cem%3EDOMAIN_NAME%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EWhen%20searching%20the%20cookie%20list%20for%20valid%20cookies%2C%20a%20comparison%20of%20the%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20attributes%20of%20the%20cookie%20is%20made%20with%20the%20Internet%20domain%20name%20of%20the%20host%20from%20which%20the%20URL%20will%20be%20fetched.%20%20If%20there%20is%20a%20tail%20match%2C%20then%20the%20cookie%20will%20go%20through%20%3Cstrong%3Epath%3C%2Fstrong%3E%20matching%20to%20see%20if%20it%20should%20be%20sent.%20%20%22Tail%20matching%22%20means%20that%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20attribute%20is%20matched%20against%20the%20tail%20of%20the%20fully%20qualified%20domain%20name%20of%20the%20host.%20%20A%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20attribute%20of%20%22acme.com%22%20would%20match%20host%20names%20%22anvil.acme.com%22%20as%20well%20as%20%22shipping.crate.acme.com%22.%20%3Cbr%20%2F%3E%0AOnly%20hosts%20within%20the%20specified%20domain%20can%20set%20a%20cookie%20for%20a%20domain%20and%20domains%20must%20have%20at%20least%20two%20(2)%0Aor%20three%20(3)%20periods%20in%20them%20to%20prevent%20domains%20of%20the%20form%3A%20%22.com%22%2C%20%22.edu%22%2C%20and%20%22va.us%22.%20%20Any%20domain%20that%20fails%20within%20one%20of%20the%20seven%20special%20top%20level%20domains%20listed%20below%20only%20require%20two%20periods.%20%20Any%20other%20domain%20requires%20at%20least%20three.%20%20The%20seven%20special%20top%20level%20domains%20are%3A%20%22COM%22%2C%20%22EDU%22%2C%20%22NET%22%2C%20%22ORG%22%2C%20%22GOV%22%2C%20%22MIL%22%2C%20and%20%22INT%22.%3Cbr%20%2F%3E%0AThe%20default%20value%20of%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20is%20the%20host%20name%20of%20the%20server%20which%20generated%20the%20cookie%20response.%20%3C%2Fdd%3E%0A%3Cdt%3E%3Cstrong%3Epath%3C%2Fstrong%3E%25E%3Cem%3EPATH%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EThe%20%3Cstrong%3Epath%3C%2Fstrong%3E%20attribute%20is%20used%20to%20specify%20the%20subset%20of%20URLs%20in%20a%20domain%20for%20which%20the%20cookie%20is%20valid.%20%20If%20a%20cookie%20has%20already%20passed%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20matching%2C%20then%20the%20pathname%20component%20of%20the%20URL%20is%20compared%20with%20the%20path%20attribute%2C%20and%20if%20there%20is%20a%20match%2C%20the%20cookie%20is%20considered%20valid%20and%20is%20sent%20along%20with%20the%20URL%20request.%20The%20path%20%22%2Ffoo%22%20would%20match%20%22%2Ffoobar%22%20and%20%22%2Ffoo%2Fbar.html%22.%20%20The%20path%20%22%2F%22%20is%20the%20most%20general%20path.%20%3Cp%3E%0AIf%20the%20%3Cstrong%3Epath%3C%2Fstrong%3E%20is%20not%20specified%2C%20it%20as%20assumed%20to%20be%20the%20same%20path%20as%20the%20document%20being%20described%20by%20the%20header%20which%20contains%20the%20cookie.%3C%2Fdd%3E%0A%3Cdt%3E%3Cstrong%3Esecure%3C%2Fstrong%3E%3C%2Fdt%3E%3Cdd%3EIf%20a%20cookie%20is%20marked%20%3Cstrong%3Esecure%3C%2Fstrong%3E%2C%20it%20will%20only%20be%20transmitted%20if%20the%20communications%20channel%20with%20the%20host%20is%20a%20secure%20one.%20%20Currently%20this%20means%20that%20secure%20cookies%20will%20only%20be%20sent%20to%20HTTPS%20(HTTP%20over%20SSL)%20servers.%20%3Cbr%20%2F%3E%0AIf%20%3Cstrong%3Esecure%3C%2Fstrong%3E%20is%20not%20specified%2C%20a%20cookie%20is%20considered%20safe%20to%20be%20sent%20in%20the%20clear%20over%20unsecured%20channels.%3C%2Fdd%3E%0A%3C%2Fdl%3E%0A%0A%3Ch2%3ESyntax%20of%20the%20Cookie%20HTTP%20Request%20Header%3C%2Fh2%3E%0A%3Cp%3EWhen%20requesting%20a%20URL%20from%20an%20HTTP%20server%2C%20the%20browser%20will%20match%20the%20URL%20against%20all%20cookies%20and%20if%20any%20of%20them%20match%2C%20a%20line%20containing%20the%20name%2Fvalue%20pairs%20of%20all%20matching%20cookies%20will%20be%20included%20in%20the%20HTTP%20request.%20%20Here%20is%20the%20format%20of%20that%20line%3A%3C%2Fp%3E%0A%3Cpre%3E%0ACookie%3A%20%3Cem%3ENAME1%25EOPAQUE_STRING1%3C%2Fem%3E%3B%20%3Cem%3ENAME2%25EOPAQUE_STRING2%20...%3C%2Fem%3E%0A%3C%2Fpre%3E%0A%0A%3Ch2%3EAdditional%20Notes%3C%2Fh2%3E%0A%3Cul%3E%0A%3Cli%3EMultiple%20%3Cstrong%3ESet-Cookie%3C%2Fstrong%3E%20headers%20can%20be%20issued%20in%20a%20single%20server%20response.%3C%2Fli%3E%0A%3Cli%3EInstances%20of%20the%20same%20path%20and%20name%20will%20overwrite%20each%20other%2C%20with%20the%20latest%20instance%20taking%20precedence.%20%20Instances%20of%20the%20same%20path%20but%20different%20names%20will%20add%20additional%20mappings.%3C%2Fli%3E%0A%3Cli%3ESetting%20the%20path%20to%20a%20higher-level%20value%20does%20not%20override%20other%20more%20specific%20path%20mappings.%20%20If%20there%20are%20multiple%20matches%20for%20a%20given%20cookie%20name%2C%20but%20with%20separate%20paths%2C%20all%20the%20matching%20cookies%20will%20be%20sent.%20(See%20examples%20below.)%3C%2Fli%3E%0A%3Cli%3EThe%20expires%20header%20lets%20the%20client%20know%20when%20it%20is%20safe%20to%20purge%20the%20mapping%20but%20the%20client%20is%20not%20required%20to%20do%20so.%20%20A%20client%20may%20also%20delete%20a%20cookie%20before%20it's%20expiration%20date%20arrives%20if%20the%20number%20of%20cookies%20exceeds%20its%20internal%20limits.%3C%2Fli%3E%0A%3Cli%3EWhen%20sending%20cookies%20to%20a%20server%2C%20all%20cookies%20with%20a%20more%20specific%20path%20mapping%20should%20be%20sent%20before%20cookies%20with%20less%20specific%20path%20mappings.%20%20For%20example%2C%20a%20cookie%20%22name1%25Efoo%22%20with%20a%20path%20mapping%20of%20%22%2F%22%20should%20be%20sent%20after%20a%20cookie%20%22name1%25Efoo2%22%20with%20a%20path%20mapping%20of%20%22%2Fbar%22%20if%20they%20are%20both%20to%20be%20sent.%3C%2Fli%3E%0A%3Cli%3EThere%20are%20limitations%20on%20the%20number%20of%20cookies%20that%20a%20client%20can%20store%20at%20any%20one%20time.%20%20This%20is%20a%20specification%20of%20the%20minimum%20number%20of%20cookies%20that%20a%20client%20should%20be%20prepared%20to%20receive%20and%20store.%0A%20%20%20%20%3Cul%3E%0A%20%20%20%20%3Cli%3E300%20total%20cookies%3C%2Fli%3E%0A%20%20%20%20%3Cli%3E4%20kilobytes%20per%20cookie%2C%20where%20the%20name%20and%20the%20OPAQUE_STRING%20combine%20to%20form%20the%204%20kilobyte%20limit.%3C%2Fli%3E%0A%20%20%20%20%3Cli%3E20%20cookies%20per%20server%20or%20domain.%20%20(note%20that%20completely%20specified%20hosts%20and%20domains%20are%20treated%20as%20separate%20entities%20and%20have%20a%2020%20cookie%20limitation%20for%20each%2C%20not%20combined)%3C%2Fli%3E%0A%20%20%20%20%3C%2Ful%3E%0AServers%20should%20not%20expect%20clients%20to%20be%20able%20to%20exceed%20these%20limits.%20When%20the%20300%20cookie%20limit%20or%20the%2020%20cookie%20per%20server%20limit%20is%20exceeded%2C%20clients%20should%20delete%20the%20least%20recently%20used%20cookie.%20When%20a%20cookie%20larger%20than%204%20kilobytes%20is%20encountered%20the%20cookie%20should%20be%20trimmed%20to%20fit%2C%20but%20the%20name%20should%20remain%20intact%20as%20long%20as%20it%20is%20less%20than%204%20kilobytes.%3C%2Fli%3E%0A%3Cli%3EIf%20a%20CGI%20script%20wishes%20to%20delete%20a%20cookie%2C%20it%20can%20do%20so%20by%20returning%20a%20cookie%20with%20the%20same%20name%2C%20and%20an%20%3Cstrong%3Eexpires%3C%2Fstrong%3E%20time%20which%20is%20in%20the%20past.%20%20The%20path%20and%20name%20must%20match%20exactly%20in%20order%20for%20the%20expiring%20cookie%20to%20replace%20the%20valid%20cookie.%20This%20requirement%20makes%20it%20difficult%20for%20anyone%20but%20the%20originator%20of%20a%20cookie%20to%20delete%20a%20cookie.%3C%2Fli%3E%0A%3Cli%3EWhen%20caching%20HTTP%2C%20as%20a%20proxy%20server%20might%20do%2C%20the%20%3Cstrong%3ESet-cookie%3C%2Fstrong%3E%20response%20header%20should%20never%20be%20cached.%3C%2Fli%3E%0A%3Cli%3EIf%20a%20proxy%20server%20receives%20a%20response%20which%20contains%20a%20%3Cstrong%3ESet-cookie%3C%2Fstrong%3E%20header%2C%20it%20should%20propagate%20the%20%3Cstrong%3ESet-cookie%3C%2Fstrong%3E%20header%20to%20the%20client%2C%20regardless%20of%20whether%20the%20response%20was%20304%0A(Not%20Modified)%20or%20200%20(OK).%3C%2Fli%3E%0A%3Cli%3ESimilarly%2C%20if%20a%20client%20request%20contains%20a%20Cookie%3A%20header%2C%20it%20should%20be%20forwarded%20through%20a%20proxy%2C%20even%20if%20the%20conditional%20If-modified-since%20request%20is%20being%20made.%3C%2Fli%3E%0A%3C%2Ful%3E%0A%0A%3Ch2%3EEXAMPLES%3C%2Fh2%3E%0A%3Cp%3EHere%20are%20some%20sample%20exchanges%20which%20are%20designed%20to%20illustrate%20the%20use%20of%20cookies.%3C%2Fp%3E%0A%3Ch3%3EFirst%20Example%20transaction%20sequence%3A%3C%2Fh3%3E%0A%3Cdl%3E%0A%3Cdt%3EClient%20requests%20a%20document%2C%20and%20receives%20in%20the%20response%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3E%0ASet-Cookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20path%25E%2F%3B%20expires%25EWednesday%2C%2009-Nov-99%2023%3A12%3A40%20GMT%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20requests%20a%20document%2C%20and%20receives%20in%20the%20response%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3B%20path%25E%2F%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20receives%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20SHIPPING%25EFEDEX%3B%20path%25E%2Ffoo%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2Ffoo%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3B%20SHIPPING%25EFEDEX%3C%2Fpre%3E%3C%2Fdd%3E%0A%3C%2Fdl%3E%0A%3Ch3%3ESecond%20Example%20transaction%20sequence%3A%3C%2Fh3%3E%0A%3Cdl%3E%0A%3Cdt%3EAssume%20all%20mappings%20from%20above%20have%20been%20cleared.%3C%2Fdt%3E%3Cdd%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20receives%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3B%20path%25E%2F%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20receives%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20PART_NUMBER%25ERIDING_ROCKET_0023%3B%20path%25E%2Fammo%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2Fammo%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20PART_NUMBER%25ERIDING_ROCKET_0023%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3E%3C%2Fdt%3E%3Cdd%3ENOTE%3A%20There%20are%20two%20name%2Fvalue%20pairs%20named%20%22PART_NUMBER%22%20due%20to%20the%20inheritance%20of%20the%20%22%2F%22%20mapping%20in%20addition%20to%20the%20%22%2Fammo%22%20mapping.%3C%2Fdd%3E%0A%3C%2Fdl%3E
<!-- CUT HERE -- CUT HERE -- CUT HERE -- CUT HERE -- CUT HERE -->
%E6%A2%B1%E5%8C%85_00=%E5%90%8D%E5%89%8D%3D%E7%95%91%20%E6%AD%A3%E6%86%B2%26%E3%83%A1%E3%83%BC%E3%83%AB%3Dlovewing%40geocities.co.jp%26%E6%80%A7%E5%88%A5%3D%E7%94%B7%E6%80%A7%26%E8%AA%95%E7%94%9F%E6%97%A5%3D2003-04-09%26%E5%9B%BD%E7%B1%8D%3D%E6%97%A5%E6%9C%AC%26%E7%9C%8C%3D%E5%9F%BC%E7%8E%89%26%E5%B8%82%3D%E5%B7%9D%E5%8F%A3%26%E9%9B%BB%E8%A9%B1%3D%2B81-48-2XX-XXXX%26%EF%BC%A6%EF%BC%A1%EF%BC%B8%3D%2B81-48-2XX-XXXX%26%E8%81%B7%E6%A5%AD%3D%E7%94%9F%E5%BE%92%25A%E5%85%88%E7%94%9F%26%E5%BD%B9%E8%81%B7%3D%E5%8F%AC%E4%BD%BF%25A%E7%A4%BE%E9%95%B7%26%E8%B6%A3%E5%91%B3%3D99%25P%20%E8%AA%87%E5%A4%A7%E8%A1%A8%E7%8F%BE%26%E6%96%87%E7%AB%A0%EF%BC%91%3D%EF%BC%A5%25E%EF%BC%A9%C3%97%EF%BC%B2%26%E6%96%87%E7%AB%A0%EF%BC%92%3D%3Ch1%3EPERSISTENT%20CLIENT%20STATE%20HTTP%20COOKIES%3C%2Fh1%3E%0A%3Ch2%3EPreliminary%20Specification%20-%20Use%20with%20caution%3C%2Fh2%3E%0A%0A%3Ch2%3EINTRODUCTION%3C%2Fh2%3E%0A%3Cp%3ECookies%20are%20a%20general%20mechanism%20which%20server%20side%20connections%20(such%20as%20CGI%20scripts)%20can%20use%20to%20both%20store%20and%20retrieve%20information%20on%20the%20client%20side%20of%20the%20connection.%20The%20addition%20of%20a%20simple%2C%20persistent%2C%20client-side%20state%20significantly%20extends%20the%20capabilities%20of%20Web-based%20client%2Fserver%20applications.%3C%2Fp%3E%0A%0A%3Ch2%3EOVERVIEW%3C%2Fh2%3E%0A%3Cp%3EA%20server%2C%20when%20returning%20an%20HTTP%20object%20to%20a%20client%2C%20may%20also%20send%20a%20piece%20of%20state%20information%20which%20the%20client%20will%20store.%20%20Included%20in%20that%20state%20object%20is%20a%20description%20of%20the%20range%20of%20URLs%20for%20which%20that%20state%20is%20valid.%20%20Any%20future%20HTTP%20requests%20made%20by%20the%20client%20which%20fall%20in%20that%20range%20will%20include%20a%20transmittal%20of%20the%20current%20value%20of%20the%20state%20object%20from%20the%20client%20back%20to%20the%20server.%20%20The%20state%20object%20is%20called%20a%20%3Cstrong%3Ecookie%3C%2Fstrong%3E%2C%20for%20no%20compelling%20reason.%20%3C%2Fp%3E%0A%3Cp%3EThis%20simple%20mechanism%20provides%20a%20powerful%20new%20tool%20which%20enables%20a%20host%20of%20new%20types%20of%20applications%20to%20be%20written%20for%20web-based%20environments.%20Shopping%20applications%20can%20now%20store%20information%20about%20the%20currently%20selected%20items%2C%20for%20fee%20services%20can%20send%20back%20registration%20information%20and%20free%20the%20client%20from%20retyping%20a%20user-id%20on%20next%20connection%2C%20sites%20can%20store%20per-user%20preferences%20on%20the%20client%2C%20and%20have%20the%20client%20supply%0Athose%20preferences%20every%20time%20that%20site%20is%20connected%20to.%3C%2Fp%3E%0A%0A%3Ch2%3ESPECIFICATION%3C%2Fh2%3E%0A%3Cp%3EA%20cookie%20is%20introduced%20to%20the%20client%20by%20including%20a%20%3Cstrong%3ESet-Cookie%3C%2Fstrong%3E%20header%20as%20part%20of%20an%20HTTP%20response%2C%20typically%20this%20will%20be%20generated%20by%20a%20CGI%20script.%3C%2Fp%3E%0A%0A%3Ch2%3ESyntax%20of%20the%20Set-Cookie%20HTTP%20Response%20Header%3C%2Fh2%3E%0A%3Cp%3EThis%20is%20the%20format%20a%20CGI%20script%20would%20use%20to%20add%20to%20the%20HTTP%20headers%20a%20new%20piece%20of%20data%20which%20is%20to%20be%20stored%20by%20the%20client%20for%20later%20retrieval.%3C%2Fp%3E%0A%3Cpre%3E%0ASet-Cookie%3A%20%3Cem%3ENAME%3C%2Fem%3E%25E%3Cem%3EVALUE%3C%2Fem%3E%3B%20expires%25E%3Cem%3EDATE%3C%2Fem%3E%3B%0Apath%25E%3Cem%3EPATH%3C%2Fem%3E%3B%20domain%25E%3Cem%3EDOMAIN_NAME%3C%2Fem%3E%3B%20secure%0A%3C%2Fpre%3E%0A%3Cdl%3E%0A%3Cdt%3E%3Cem%3ENAME%3C%2Fem%3E%25E%3Cem%3EVALUE%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EThis%20string%20is%20a%20sequence%20of%20characters%20excluding%20semi-colon%2C%20comma%20and%20white%20space.%20%20If%20there%20is%20a%20need%20to%20place%20such%20data%20in%20the%20name%20or%20value%2C%20some%20encoding%20method%20such%20as%20URL%20style%20%25PXX%20encoding%20is%20recommended%2C%20though%20no%20encoding%20is%20defined%20or%20required.%20%3Cp%3E%20%20This%20is%20the%20only%20required%20attribute%20on%20the%20%3Cstrong%3ESet-Cookie%3C%2Fstrong%3E%20header.%20%3C%2Fdd%3; %E6%A2%B1%E5%8C%85_01=E%0A%3Cdt%3E%3Cstrong%3Eexpires%3C%2Fstrong%3E%25E%3Cem%3EDATE%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EThe%20%3Cstrong%3Eexpires%3C%2Fstrong%3E%20attribute%20specifies%20a%20date%20string%20that%20defines%20the%20valid%20life%20time%20of%20that%20cookie.%20%20Once%20the%20expiration%20date%20has%20been%20reached%2C%20the%20cookie%20will%20no%20longer%20be%20stored%20or%20given%20out.%20%3Cbr%20%2F%3E%0AThe%20date%20string%20is%20formatted%20as%3A%0A%3Cblockquote%3E%3Ccode%3EWdy%2C%20DD-Mon-YYYY%20HH%3AMM%3ASS%20GMT%3C%2Fcode%3E%3C%2Fblockquote%3E%0AThis%20is%20based%20on%0A%3Ca%20href%25E%22http%3A%2F%2Fds.internic.net%2Frfc%2Frfc822.txt%22%3ERFC%20822%3C%2Fa%3E%2C%20%3Ca%20href%25E%22http%3A%2F%2Fds.internic.net%2Frfc%2Frfc850.txt%22%3ERFC%20850%3C%2Fa%3E%2C%20%3Ca%20href%25E%22http%3A%2F%2Fwww.w3.org%2Fhypertext%2FWWW%2FProtocols%2Frfc1036%2Frfc1036.html%23z6%22%3ERFC%201036%3C%2Fa%3E%2C%20and%20%3Ca%20href%25E%22http%3A%2F%2Fds1.internic.net%2Frfc%2Frfc1123.txt%22%3ERFC%201123%3C%2Fa%3E%2C%20with%20the%20variations%20that%20the%20only%20legal%20time%20zone%20is%20%3Cstrong%3EGMT%3C%2Fstrong%3E%20and%20the%20separators%20between%20the%20elements%20of%20the%20date%20must%20be%20dashes.%3Cbr%20%2F%3E%0A%3Cstrong%3Eexpires%3C%2Fstrong%3E%20is%20an%20optional%20attribute.%20%20If%20not%20specified%2C%20the%20cookie%20will%20expire%20when%20the%20user's%20session%20ends.%20%3Cbr%20%2F%3E%0A%3Cstrong%3ENote%3A%3C%2Fstrong%3E%20There%20is%20a%20bug%20in%20Netscape%20Navigator%20version%201.1%20and%20earlier.%20Only%20cookies%20whose%20%3Cstrong%3Epath%3C%2Fstrong%3E%20attribute%20is%20set%20explicitly%20to%20%22%2F%22%20will%20be%20properly%20saved%20between%20sessions%20if%20they%20have%20an%20%3Cstrong%3Eexpires%3C%2Fstrong%3E%20attribute.%3C%2Fdd%3E%0A%3Cdt%3E%3Cstrong%3Edomain%3C%2Fstrong%3E%25E%3Cem%3EDOMAIN_NAME%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EWhen%20searching%20the%20cookie%20list%20for%20valid%20cookies%2C%20a%20comparison%20of%20the%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20attributes%20of%20the%20cookie%20is%20made%20with%20the%20Internet%20domain%20name%20of%20the%20host%20from%20which%20the%20URL%20will%20be%20fetched.%20%20If%20there%20is%20a%20tail%20match%2C%20then%20the%20cookie%20will%20go%20through%20%3Cstrong%3Epath%3C%2Fstrong%3E%20matching%20to%20see%20if%20it%20should%20be%20sent.%20%20%22Tail%20matching%22%20means%20that%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20attribute%20is%20matched%20against%20the%20tail%20of%20the%20fully%20qualified%20domain%20name%20of%20the%20host.%20%20A%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20attribute%20of%20%22acme.com%22%20would%20match%20host%20names%20%22anvil.acme.com%22%20as%20well%20as%20%22shipping.crate.acme.com%22.%20%3Cbr%20%2F%3E%0AOnly%20hosts%20within%20the%20specified%20domain%20can%20set%20a%20cookie%20for%20a%20domain%20and%20domains%20must%20have%20at%20least%20two%20(2)%0Aor%20three%20(3)%20periods%20in%20them%20to%20prevent%20domains%20of%20the%20form%3A%20%22.com%22%2C%20%22.edu%22%2C%20and%20%22va.us%22.%20%20Any%20domain%20that%20fails%20within%20one%20of%20the%20seven%20special%20top%20level%20domains%20listed%20below%20only%20require%20two%20periods.%20%20Any%20other%20domain%20requires%20at%20least%20three.%20%20The%20seven%20special%20top%20level%20domains%20are%3A%20%22COM%22%2C%20%22EDU%22%2C%20%22NET%22%2C%20%22ORG%22%2C%20%22GOV%22%2C%20%22MIL%22%2C%20and%20%22INT%22.%3Cbr%20%2F%3E%0AThe%20default%20value%20of%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20is%20the%20host%20name%20of%20the%20server%20which%20generated%20the%20cookie%20response.%20%3C%2Fdd%3E%0A%3Cdt%3E%3Cstrong%3Epath%3C%2Fstrong%3E%25E%3Cem%3EPATH%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EThe%20%3Cstrong%3Epath%3C%2Fstrong%3E%20attribute%20is%20used%20to%20specify%20the%20subset%20of%20URLs%20in%20a%20domain%20for%20which%20the%20cookie%20is%20valid.%20%20If%20a%20cookie%20has%20already%20passed%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20matching%2C%20then%20the%20pathname%20component%20of%20the%20URL%20is%20compared%20with%20the%20path%20attribute%2C%20and%20if%20there%20is%20a%20match%2C%20the%20cookie%; %E6%A2%B1%E5%8C%85_02=20is%20considered%20valid%20and%20is%20sent%20along%20with%20the%20URL%20request.%20The%20path%20%22%2Ffoo%22%20would%20match%20%22%2Ffoobar%22%20and%20%22%2Ffoo%2Fbar.html%22.%20%20The%20path%20%22%2F%22%20is%20the%20most%20general%20path.%20%3Cp%3E%0AIf%20the%20%3Cstrong%3Epath%3C%2Fstrong%3E%20is%20not%20specified%2C%20it%20as%20assumed%20to%20be%20the%20same%20path%20as%20the%20document%20being%20described%20by%20the%20header%20which%20contains%20the%20cookie.%3C%2Fdd%3E%0A%3Cdt%3E%3Cstrong%3Esecure%3C%2Fstrong%3E%3C%2Fdt%3E%3Cdd%3EIf%20a%20cookie%20is%20marked%20%3Cstrong%3Esecure%3C%2Fstrong%3E%2C%20it%20will%20only%20be%20transmitted%20if%20the%20communications%20channel%20with%20the%20host%20is%20a%20secure%20one.%20%20Currently%20this%20means%20that%20secure%20cookies%20will%20only%20be%20sent%20to%20HTTPS%20(HTTP%20over%20SSL)%20servers.%20%3Cbr%20%2F%3E%0AIf%20%3Cstrong%3Esecure%3C%2Fstrong%3E%20is%20not%20specified%2C%20a%20cookie%20is%20considered%20safe%20to%20be%20sent%20in%20the%20clear%20over%20unsecured%20channels.%3C%2Fdd%3E%0A%3C%2Fdl%3E%0A%0A%3Ch2%3ESyntax%20of%20the%20Cookie%20HTTP%20Request%20Header%3C%2Fh2%3E%0A%3Cp%3EWhen%20requesting%20a%20URL%20from%20an%20HTTP%20server%2C%20the%20browser%20will%20match%20the%20URL%20against%20all%20cookies%20and%20if%20any%20of%20them%20match%2C%20a%20line%20containing%20the%20name%2Fvalue%20pairs%20of%20all%20matching%20cookies%20will%20be%20included%20in%20the%20HTTP%20request.%20%20Here%20is%20the%20format%20of%20that%20line%3A%3C%2Fp%3E%0A%3Cpre%3E%0ACookie%3A%20%3Cem%3ENAME1%25EOPAQUE_STRING1%3C%2Fem%3E%3B%20%3Cem%3ENAME2%25EOPAQUE_STRING2%20...%3C%2Fem%3E%0A%3C%2Fpre%3E%0A%0A%3Ch2%3EAdditional%20Notes%3C%2Fh2%3E%0A%3Cul%3E%0A%3Cli%3EMultiple%20%3Cstrong%3ESet-Cookie%3C%2Fstrong%3E%20headers%20can%20be%20issued%20in%20a%20single%20server%20response.%3C%2Fli%3E%0A%3Cli%3EInstances%20of%20the%20same%20path%20and%20name%20will%20overwrite%20each%20other%2C%20with%20the%20latest%20instance%20taking%20precedence.%20%20Instances%20of%20the%20same%20path%20but%20different%20names%20will%20add%20additional%20mappings.%3C%2Fli%3E%0A%3Cli%3ESetting%20the%20path%20to%20a%20higher-level%20value%20does%20not%20override%20other%20more%20specific%20path%20mappings.%20%20If%20there%20are%20multiple%20matches%20for%20a%20given%20cookie%20name%2C%20but%20with%20separate%20paths%2C%20all%20the%20matching%20cookies%20will%20be%20sent.%20(See%20examples%20below.)%3C%2Fli%3E%0A%3Cli%3EThe%20expires%20header%20lets%20the%20client%20know%20when%20it%20is%20safe%20to%20purge%20the%20mapping%20but%20the%20client%20is%20not%20required%20to%20do%20so.%20%20A%20client%20may%20also%20delete%20a%20cookie%20before%20it's%20expiration%20date%20arrives%20if%20the%20number%20of%20cookies%20exceeds%20its%20internal%20limits.%3C%2Fli%3E%0A%3Cli%3EWhen%20sending%20cookies%20to%20a%20server%2C%20all%20cookies%20with%20a%20more%20specific%20path%20mapping%20should%20be%20sent%20before%20cookies%20with%20less%20specific%20path%20mappings.%20%20For%20example%2C%20a%20cookie%20%22name1%25Efoo%22%20with%20a%20path%20mapping%20of%20%22%2F%22%20should%20be%20sent%20after%20a%20cookie%20%22name1%25Efoo2%22%20with%20a%20path%20mapping%20of%20%22%2Fbar%22%20if%20they%20are%20both%20to%20be%20sent.%3C%2Fli%3E%0A%3Cli%3EThere%20are%20limitations%20on%20the%20number%20of%20cookies%20that%20a%20client%20can%20store%20at%20any%20one%20time.%20%20This%20is%20a%20specification%20of%20the%20minimum%20number%20of%20cookies%20that%20a%20client%20should%20be%20prepared%20to%20receive%20and%20store.%0A%20%20%20%20%3Cul%3E%0A%20%20%20%20%3Cli%3E300%20total%20cookies%3C%2Fli%3E%0A%20%20%20%20%3Cli%3E4%20kilobytes%20per%20cookie%2C%20where%20the%20name%20and%20the%20OPAQUE_STRING%20combine%20to%20form%20the%204%20kilobyte%20limit.%3C%2Fli%3E%0A%20%20%20%20%3Cli%3E20%20cookies%20per%20server%20or%20domain.%20%20(note%20that%20completely%20specified%20hosts%20and%20domains%20are%20treated%20as%20separate%20entities%20and%20have%20a%2020%20cookie%20limitation%20for%20each%2C%20not%20combined)%3C%2Fl; %E6%A2%B1%E5%8C%85_03=i%3E%0A%20%20%20%20%3C%2Ful%3E%0AServers%20should%20not%20expect%20clients%20to%20be%20able%20to%20exceed%20these%20limits.%20When%20the%20300%20cookie%20limit%20or%20the%2020%20cookie%20per%20server%20limit%20is%20exceeded%2C%20clients%20should%20delete%20the%20least%20recently%20used%20cookie.%20When%20a%20cookie%20larger%20than%204%20kilobytes%20is%20encountered%20the%20cookie%20should%20be%20trimmed%20to%20fit%2C%20but%20the%20name%20should%20remain%20intact%20as%20long%20as%20it%20is%20less%20than%204%20kilobytes.%3C%2Fli%3E%0A%3Cli%3EIf%20a%20CGI%20script%20wishes%20to%20delete%20a%20cookie%2C%20it%20can%20do%20so%20by%20returning%20a%20cookie%20with%20the%20same%20name%2C%20and%20an%20%3Cstrong%3Eexpires%3C%2Fstrong%3E%20time%20which%20is%20in%20the%20past.%20%20The%20path%20and%20name%20must%20match%20exactly%20in%20order%20for%20the%20expiring%20cookie%20to%20replace%20the%20valid%20cookie.%20This%20requirement%20makes%20it%20difficult%20for%20anyone%20but%20the%20originator%20of%20a%20cookie%20to%20delete%20a%20cookie.%3C%2Fli%3E%0A%3Cli%3EWhen%20caching%20HTTP%2C%20as%20a%20proxy%20server%20might%20do%2C%20the%20%3Cstrong%3ESet-cookie%3C%2Fstrong%3E%20response%20header%20should%20never%20be%20cached.%3C%2Fli%3E%0A%3Cli%3EIf%20a%20proxy%20server%20receives%20a%20response%20which%20contains%20a%20%3Cstrong%3ESet-cookie%3C%2Fstrong%3E%20header%2C%20it%20should%20propagate%20the%20%3Cstrong%3ESet-cookie%3C%2Fstrong%3E%20header%20to%20the%20client%2C%20regardless%20of%20whether%20the%20response%20was%20304%0A(Not%20Modified)%20or%20200%20(OK).%3C%2Fli%3E%0A%3Cli%3ESimilarly%2C%20if%20a%20client%20request%20contains%20a%20Cookie%3A%20header%2C%20it%20should%20be%20forwarded%20through%20a%20proxy%2C%20even%20if%20the%20conditional%20If-modified-since%20request%20is%20being%20made.%3C%2Fli%3E%0A%3C%2Ful%3E%0A%0A%3Ch2%3EEXAMPLES%3C%2Fh2%3E%0A%3Cp%3EHere%20are%20some%20sample%20exchanges%20which%20are%20designed%20to%20illustrate%20the%20use%20of%20cookies.%3C%2Fp%3E%0A%3Ch3%3EFirst%20Example%20transaction%20sequence%3A%3C%2Fh3%3E%0A%3Cdl%3E%0A%3Cdt%3EClient%20requests%20a%20document%2C%20and%20receives%20in%20the%20response%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3E%0ASet-Cookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20path%25E%2F%3B%20expires%25EWednesday%2C%2009-Nov-99%2023%3A12%3A40%20GMT%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20requests%20a%20document%2C%20and%20receives%20in%20the%20response%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3B%20path%25E%2F%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20receives%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20SHIPPING%25EFEDEX%3B%20path%25E%2Ffoo%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2Ffoo%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3B%20SHIPPING%25EFEDEX%3C%2Fpre%3E%3C%2Fdd%3E%0A%3C%2Fdl%3E%0A%3Ch3%3ESecond%20Example%20transaction%20sequence%3A%3C%2Fh3%3E%0A%3Cdl%3E%0A%3Cdt%3EAssume%20all%20mappings%20from%20above%20have%20been%20cleared.%3C%2Fdt%3E%3Cdd%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20receives%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3B%20path%25E%2F%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20se; %E6%A2%B1%E5%8C%85_04=rver%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20receives%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20PART_NUMBER%25ERIDING_ROCKET_0023%3B%20path%25E%2Fammo%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2Fammo%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20PART_NUMBER%25ERIDING_ROCKET_0023%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3E%3C%2Fdt%3E%3Cdd%3ENOTE%3A%20There%20are%20two%20name%2Fvalue%20pairs%20named%20%22PART_NUMBER%22%20due%20to%20the%20inheritance%20of%20the%20%22%2F%22%20mapping%20in%20addition%20to%20the%20%22%2Fammo%22%20mapping.%3C%2Fdd%3E%0A%3C%2Fdl%3E
<!-- CUT HERE -- CUT HERE -- CUT HERE -- CUT HERE -- CUT HERE -->
%E6%A2%B1%E5%8C%85=%E5%90%8D%E5%89%8D%3D%E7%95%91%20%E6%AD%A3%E6%86%B2%26%E3%83%A1%E3%83%BC%E3%83%AB%3Dlovewing%40geocities.co.jp%26%E6%80%A7%E5%88%A5%3D%E7%94%B7%E6%80%A7%26%E8%AA%95%E7%94%9F%E6%97%A5%3D2003-04-09%26%E5%9B%BD%E7%B1%8D%3D%E6%97%A5%E6%9C%AC%26%E7%9C%8C%3D%E5%9F%BC%E7%8E%89%26%E5%B8%82%3D%E5%B7%9D%E5%8F%A3%26%E9%9B%BB%E8%A9%B1%3D%2B81-48-2XX-XXXX%26%EF%BC%A6%EF%BC%A1%EF%BC%B8%3D%2B81-48-2XX-XXXX%26%E8%81%B7%E6%A5%AD%3D%E7%94%9F%E5%BE%92%25A%E5%85%88%E7%94%9F%26%E5%BD%B9%E8%81%B7%3D%E5%8F%AC%E4%BD%BF%25A%E7%A4%BE%E9%95%B7%26%E8%B6%A3%E5%91%B3%3D99%25P%20%E8%AA%87%E5%A4%A7%E8%A1%A8%E7%8F%BE%26%E6%96%87%E7%AB%A0%EF%BC%91%3D%EF%BC%A5%25E%EF%BC%A9%C3%97%EF%BC%B2%26%E6%96%87%E7%AB%A0%EF%BC%92%3D%3Ch1%3EPERSISTENT%20CLIENT%20STATE%20HTTP%20COOKIES%3C%2Fh1%3E%0A%3Ch2%3EPreliminary%20Specification%20-%20Use%20with%20caution%3C%2Fh2%3E%0A%0A%3Ch2%3EINTRODUCTION%3C%2Fh2%3E%0A%3Cp%3ECookies%20are%20a%20general%20mechanism%20which%20server%20side%20connections%20(such%20as%20CGI%20scripts)%20can%20use%20to%20both%20store%20and%20retrieve%20information%20on%20the%20client%20side%20of%20the%20connection.%20The%20addition%20of%20a%20simple%2C%20persistent%2C%20client-side%20state%20significantly%20extends%20the%20capabilities%20of%20Web-based%20client%2Fserver%20applications.%3C%2Fp%3E%0A%0A%3Ch2%3EOVERVIEW%3C%2Fh2%3E%0A%3Cp%3EA%20server%2C%20when%20returning%20an%20HTTP%20object%20to%20a%20client%2C%20may%20also%20send%20a%20piece%20of%20state%20information%20which%20the%20client%20will%20store.%20%20Included%20in%20that%20state%20object%20is%20a%20description%20of%20the%20range%20of%20URLs%20for%20which%20that%20state%20is%20valid.%20%20Any%20future%20HTTP%20requests%20made%20by%20the%20client%20which%20fall%20in%20that%20range%20will%20include%20a%20transmittal%20of%20the%20current%20value%20of%20the%20state%20object%20from%20the%20client%20back%20to%20the%20server.%20%20The%20state%20object%20is%20called%20a%20%3Cstrong%3Ecookie%3C%2Fstrong%3E%2C%20for%20no%20compelling%20reason.%20%3C%2Fp%3E%0A%3Cp%3EThis%20simple%20mechanism%20provides%20a%20powerful%20new%20tool%20which%20enables%20a%20host%20of%20new%20types%20of%20applications%20to%20be%20written%20for%20web-based%20environments.%20Shopping%20applications%20can%20now%20store%20information%20about%20the%20currently%20selected%20items%2C%20for%20fee%20services%20can%20send%20back%20registration%20information%20and%20free%20the%20client%20from%20retyping%20a%20user-id%20on%20next%20connection%2C%20sites%20can%20store%20per-user%20preferences%20on%20the%20client%2C%20and%20have%20the%20client%20supply%0Athose%20preferences%20every%20time%20that%20site%20is%20connected%20to.%3C%2Fp%3E%0A%0A%3Ch2%3ESPECIFICATION%3C%2Fh2%3E%0A%3Cp%3EA%20cookie%20is%20introduced%20to%20the%20client%20by%20including%20a%20%3Cstrong%3ESet-Cookie%3C%2Fstrong%3E%20header%20as%20part%20of%20an%20HTTP%20response%2C%20typically%20this%20will%20be%20generated%20by%20a%20CGI%20script.%3C%2Fp%3E%0A%0A%3Ch2%3ESyntax%20of%20the%20Set-Cookie%20HTTP%20Response%20Header%3C%2Fh2%3E%0A%3Cp%3EThis%20is%20the%20format%20a%20CGI%20script%20would%20use%20to%20add%20to%20the%20HTTP%20headers%20a%20new%20piece%20of%20data%20which%20is%20to%20be%20stored%20by%20the%20client%20for%20later%20retrieval.%3C%2Fp%3E%0A%3Cpre%3E%0ASet-Cookie%3A%20%3Cem%3ENAME%3C%2Fem%3E%25E%3Cem%3EVALUE%3C%2Fem%3E%3B%20expires%25E%3Cem%3EDATE%3C%2Fem%3E%3B%0Apath%25E%3Cem%3EPATH%3C%2Fem%3E%3B%20domain%25E%3Cem%3EDOMAIN_NAME%3C%2Fem%3E%3B%20secure%0A%3C%2Fpre%3E%0A%3Cdl%3E%0A%3Cdt%3E%3Cem%3ENAME%3C%2Fem%3E%25E%3Cem%3EVALUE%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EThis%20string%20is%20a%20sequence%20of%20characters%20excluding%20semi-colon%2C%20comma%20and%20white%20space.%20%20If%20there%20is%20a%20need%20to%20place%20such%20data%20in%20the%20name%20or%20value%2C%20some%20encoding%20method%20such%20as%20URL%20style%20%25PXX%20encoding%20is%20recommended%2C%20though%20no%20encoding%20is%20defined%20or%20required.%20%3Cp%3E%20%20This%20is%20the%20only%20required%20attribute%20on%20the%20%3Cstrong%3ESet-Cookie%3C%2Fstrong%3E%20header.%20%3C%2Fdd%3E%0A%3Cdt%3E%3Cstrong%3Eexpires%3C%2Fstrong%3E%25E%3Cem%3EDATE%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EThe%20%3Cstrong%3Eexpires%3C%2Fstrong%3E%20attribute%20specifies%20a%20date%20string%20that%20defines%20the%20valid%20life%20time%20of%20that%20cookie.%20%20Once%20the%20expiration%20date%20has%20been%20reached%2C%20the%20cookie%20will%20no%20longer%20be%20stored%20or%20given%20out.%20%3Cbr%20%2F%3E%0AThe%20date%20string%20is%20formatted%20as%3A%0A%3Cblockquote%3E%3Ccode%3EWdy%2C%20DD-Mon-YYYY%20HH%3AMM%3ASS%20GMT%3C%2Fcode%3E%3C%2Fblockquote%3E%0AThis%20is%20based%20on%0A%3Ca%20href%25E%22http%3A%2F%2Fds.internic.net%2Frfc%2Frfc822.txt%22%3ERFC%20822%3C%2Fa%3E%2C%20%3Ca%20href%25E%22http%3A%2F%2Fds.internic.net%2Frfc%2Frfc850.txt%22%3ERFC%20850%3C%2Fa%3E%2C%20%3Ca%20href%25E%22http%3A%2F%2Fwww.w3.org%2Fhypertext%2FWWW%2FProtocols%2Frfc1036%2Frfc1036.html%23z6%22%3ERFC%201036%3C%2Fa%3E%2C%20and%20%3Ca%20href%25E%22http%3A%2F%2Fds1.internic.net%2Frfc%2Frfc1123.txt%22%3ERFC%201123%3C%2Fa%3E%2C%20with%20the%20variations%20that%20the%20only%20legal%20time%20zone%20is%20%3Cstrong%3EGMT%3C%2Fstrong%3E%20and%20the%20separators%20between%20the%20elements%20of%20the%20date%20must%20be%20dashes.%3Cbr%20%2F%3E%0A%3Cstrong%3Eexpires%3C%2Fstrong%3E%20is%20an%20optional%20attribute.%20%20If%20not%20specified%2C%20the%20cookie%20will%20expire%20when%20the%20user's%20session%20ends.%20%3Cbr%20%2F%3E%0A%3Cstrong%3ENote%3A%3C%2Fstrong%3E%20There%20is%20a%20bug%20in%20Netscape%20Navigator%20version%201.1%20and%20earlier.%20Only%20cookies%20whose%20%3Cstrong%3Epath%3C%2Fstrong%3E%20attribute%20is%20set%20explicitly%20to%20%22%2F%22%20will%20be%20properly%20saved%20between%20sessions%20if%20they%20have%20an%20%3Cstrong%3Eexpires%3C%2Fstrong%3E%20attribute.%3C%2Fdd%3E%0A%3Cdt%3E%3Cstrong%3Edomain%3C%2Fstrong%3E%25E%3Cem%3EDOMAIN_NAME%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EWhen%20searching%20the%20cookie%20list%20for%20valid%20cookies%2C%20a%20comparison%20of%20the%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20attributes%20of%20the%20cookie%20is%20made%20with%20the%20Internet%20domain%20name%20of%20the%20host%20from%20which%20the%20URL%20will%20be%20fetched.%20%20If%20there%20is%20a%20tail%20match%2C%20then%20the%20cookie%20will%20go%20through%20%3Cstrong%3Epath%3C%2Fstrong%3E%20matching%20to%20see%20if%20it%20should%20be%20sent.%20%20%22Tail%20matching%22%20means%20that%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20attribute%20is%20matched%20against%20the%20tail%20of%20the%20fully%20qualified%20domain%20name%20of%20the%20host.%20%20A%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20attribute%20of%20%22acme.com%22%20would%20match%20host%20names%20%22anvil.acme.com%22%20as%20well%20as%20%22shipping.crate.acme.com%22.%20%3Cbr%20%2F%3E%0AOnly%20hosts%20within%20the%20specified%20domain%20can%20set%20a%20cookie%20for%20a%20domain%20and%20domains%20must%20have%20at%20least%20two%20(2)%0Aor%20three%20(3)%20periods%20in%20them%20to%20prevent%20domains%20of%20the%20form%3A%20%22.com%22%2C%20%22.edu%22%2C%20and%20%22va.us%22.%20%20Any%20domain%20that%20fails%20within%20one%20of%20the%20seven%20special%20top%20level%20domains%20listed%20below%20only%20require%20two%20periods.%20%20Any%20other%20domain%20requires%20at%20least%20three.%20%20The%20seven%20special%20top%20level%20domains%20are%3A%20%22COM%22%2C%20%22EDU%22%2C%20%22NET%22%2C%20%22ORG%22%2C%20%22GOV%22%2C%20%22MIL%22%2C%20and%20%22INT%22.%3Cbr%20%2F%3E%0AThe%20default%20value%20of%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20is%20the%20host%20name%20of%20the%20server%20which%20generated%20the%20cookie%20response.%20%3C%2Fdd%3E%0A%3Cdt%3E%3Cstrong%3Epath%3C%2Fstrong%3E%25E%3Cem%3EPATH%3C%2Fem%3E%3C%2Fdt%3E%3Cdd%3EThe%20%3Cstrong%3Epath%3C%2Fstrong%3E%20attribute%20is%20used%20to%20specify%20the%20subset%20of%20URLs%20in%20a%20domain%20for%20which%20the%20cookie%20is%20valid.%20%20If%20a%20cookie%20has%20already%20passed%20%3Cstrong%3Edomain%3C%2Fstrong%3E%20matching%2C%20then%20the%20pathname%20component%20of%20the%20URL%20is%20compared%20with%20the%20path%20attribute%2C%20and%20if%20there%20is%20a%20match%2C%20the%20cookie%20is%20considered%20valid%20and%20is%20sent%20along%20with%20the%20URL%20request.%20The%20path%20%22%2Ffoo%22%20would%20match%20%22%2Ffoobar%22%20and%20%22%2Ffoo%2Fbar.html%22.%20%20The%20path%20%22%2F%22%20is%20the%20most%20general%20path.%20%3Cp%3E%0AIf%20the%20%3Cstrong%3Epath%3C%2Fstrong%3E%20is%20not%20specified%2C%20it%20as%20assumed%20to%20be%20the%20same%20path%20as%20the%20document%20being%20described%20by%20the%20header%20which%20contains%20the%20cookie.%3C%2Fdd%3E%0A%3Cdt%3E%3Cstrong%3Esecure%3C%2Fstrong%3E%3C%2Fdt%3E%3Cdd%3EIf%20a%20cookie%20is%20marked%20%3Cstrong%3Esecure%3C%2Fstrong%3E%2C%20it%20will%20only%20be%20transmitted%20if%20the%20communications%20channel%20with%20the%20host%20is%20a%20secure%20one.%20%20Currently%20this%20means%20that%20secure%20cookies%20will%20only%20be%20sent%20to%20HTTPS%20(HTTP%20over%20SSL)%20servers.%20%3Cbr%20%2F%3E%0AIf%20%3Cstrong%3Esecure%3C%2Fstrong%3E%20is%20not%20specified%2C%20a%20cookie%20is%20considered%20safe%20to%20be%20sent%20in%20the%20clear%20over%20unsecured%20channels.%3C%2Fdd%3E%0A%3C%2Fdl%3E%0A%0A%3Ch2%3ESyntax%20of%20the%20Cookie%20HTTP%20Request%20Header%3C%2Fh2%3E%0A%3Cp%3EWhen%20requesting%20a%20URL%20from%20an%20HTTP%20server%2C%20the%20browser%20will%20match%20the%20URL%20against%20all%20cookies%20and%20if%20any%20of%20them%20match%2C%20a%20line%20containing%20the%20name%2Fvalue%20pairs%20of%20all%20matching%20cookies%20will%20be%20included%20in%20the%20HTTP%20request.%20%20Here%20is%20the%20format%20of%20that%20line%3A%3C%2Fp%3E%0A%3Cpre%3E%0ACookie%3A%20%3Cem%3ENAME1%25EOPAQUE_STRING1%3C%2Fem%3E%3B%20%3Cem%3ENAME2%25EOPAQUE_STRING2%20...%3C%2Fem%3E%0A%3C%2Fpre%3E%0A%0A%3Ch2%3EAdditional%20Notes%3C%2Fh2%3E%0A%3Cul%3E%0A%3Cli%3EMultiple%20%3Cstrong%3ESet-Cookie%3C%2Fstrong%3E%20headers%20can%20be%20issued%20in%20a%20single%20server%20response.%3C%2Fli%3E%0A%3Cli%3EInstances%20of%20the%20same%20path%20and%20name%20will%20overwrite%20each%20other%2C%20with%20the%20latest%20instance%20taking%20precedence.%20%20Instances%20of%20the%20same%20path%20but%20different%20names%20will%20add%20additional%20mappings.%3C%2Fli%3E%0A%3Cli%3ESetting%20the%20path%20to%20a%20higher-level%20value%20does%20not%20override%20other%20more%20specific%20path%20mappings.%20%20If%20there%20are%20multiple%20matches%20for%20a%20given%20cookie%20name%2C%20but%20with%20separate%20paths%2C%20all%20the%20matching%20cookies%20will%20be%20sent.%20(See%20examples%20below.)%3C%2Fli%3E%0A%3Cli%3EThe%20expires%20header%20lets%20the%20client%20know%20when%20it%20is%20safe%20to%20purge%20the%20mapping%20but%20the%20client%20is%20not%20required%20to%20do%20so.%20%20A%20client%20may%20also%20delete%20a%20cookie%20before%20it's%20expiration%20date%20arrives%20if%20the%20number%20of%20cookies%20exceeds%20its%20internal%20limits.%3C%2Fli%3E%0A%3Cli%3EWhen%20sending%20cookies%20to%20a%20server%2C%20all%20cookies%20with%20a%20more%20specific%20path%20mapping%20should%20be%20sent%20before%20cookies%20with%20less%20specific%20path%20mappings.%20%20For%20example%2C%20a%20cookie%20%22name1%25Efoo%22%20with%20a%20path%20mapping%20of%20%22%2F%22%20should%20be%20sent%20after%20a%20cookie%20%22name1%25Efoo2%22%20with%20a%20path%20mapping%20of%20%22%2Fbar%22%20if%20they%20are%20both%20to%20be%20sent.%3C%2Fli%3E%0A%3Cli%3EThere%20are%20limitations%20on%20the%20number%20of%20cookies%20that%20a%20client%20can%20store%20at%20any%20one%20time.%20%20This%20is%20a%20specification%20of%20the%20minimum%20number%20of%20cookies%20that%20a%20client%20should%20be%20prepared%20to%20receive%20and%20store.%0A%20%20%20%20%3Cul%3E%0A%20%20%20%20%3Cli%3E300%20total%20cookies%3C%2Fli%3E%0A%20%20%20%20%3Cli%3E4%20kilobytes%20per%20cookie%2C%20where%20the%20name%20and%20the%20OPAQUE_STRING%20combine%20to%20form%20the%204%20kilobyte%20limit.%3C%2Fli%3E%0A%20%20%20%20%3Cli%3E20%20cookies%20per%20server%20or%20domain.%20%20(note%20that%20completely%20specified%20hosts%20and%20domains%20are%20treated%20as%20separate%20entities%20and%20have%20a%2020%20cookie%20limitation%20for%20each%2C%20not%20combined)%3C%2Fli%3E%0A%20%20%20%20%3C%2Ful%3E%0AServers%20should%20not%20expect%20clients%20to%20be%20able%20to%20exceed%20these%20limits.%20When%20the%20300%20cookie%20limit%20or%20the%2020%20cookie%20per%20server%20limit%20is%20exceeded%2C%20clients%20should%20delete%20the%20least%20recently%20used%20cookie.%20When%20a%20cookie%20larger%20than%204%20kilobytes%20is%20encountered%20the%20cookie%20should%20be%20trimmed%20to%20fit%2C%20but%20the%20name%20should%20remain%20intact%20as%20long%20as%20it%20is%20less%20than%204%20kilobytes.%3C%2Fli%3E%0A%3Cli%3EIf%20a%20CGI%20script%20wishes%20to%20delete%20a%20cookie%2C%20it%20can%20do%20so%20by%20returning%20a%20cookie%20with%20the%20same%20name%2C%20and%20an%20%3Cstrong%3Eexpires%3C%2Fstrong%3E%20time%20which%20is%20in%20the%20past.%20%20The%20path%20and%20name%20must%20match%20exactly%20in%20order%20for%20the%20expiring%20cookie%20to%20replace%20the%20valid%20cookie.%20This%20requirement%20makes%20it%20difficult%20for%20anyone%20but%20the%20originator%20of%20a%20cookie%20to%20delete%20a%20cookie.%3C%2Fli%3E%0A%3Cli%3EWhen%20caching%20HTTP%2C%20as%20a%20proxy%20server%20might%20do%2C%20the%20%3Cstrong%3ESet-cookie%3C%2Fstrong%3E%20response%20header%20should%20never%20be%20cached.%3C%2Fli%3E%0A%3Cli%3EIf%20a%20proxy%20server%20receives%20a%20response%20which%20contains%20a%20%3Cstrong%3ESet-cookie%3C%2Fstrong%3E%20header%2C%20it%20should%20propagate%20the%20%3Cstrong%3ESet-cookie%3C%2Fstrong%3E%20header%20to%20the%20client%2C%20regardless%20of%20whether%20the%20response%20was%20304%0A(Not%20Modified)%20or%20200%20(OK).%3C%2Fli%3E%0A%3Cli%3ESimilarly%2C%20if%20a%20client%20request%20contains%20a%20Cookie%3A%20header%2C%20it%20should%20be%20forwarded%20through%20a%20proxy%2C%20even%20if%20the%20conditional%20If-modified-since%20request%20is%20being%20made.%3C%2Fli%3E%0A%3C%2Ful%3E%0A%0A%3Ch2%3EEXAMPLES%3C%2Fh2%3E%0A%3Cp%3EHere%20are%20some%20sample%20exchanges%20which%20are%20designed%20to%20illustrate%20the%20use%20of%20cookies.%3C%2Fp%3E%0A%3Ch3%3EFirst%20Example%20transaction%20sequence%3A%3C%2Fh3%3E%0A%3Cdl%3E%0A%3Cdt%3EClient%20requests%20a%20document%2C%20and%20receives%20in%20the%20response%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3E%0ASet-Cookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20path%25E%2F%3B%20expires%25EWednesday%2C%2009-Nov-99%2023%3A12%3A40%20GMT%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20requests%20a%20document%2C%20and%20receives%20in%20the%20response%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3B%20path%25E%2F%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20receives%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20SHIPPING%25EFEDEX%3B%20path%25E%2Ffoo%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2Ffoo%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20CUSTOMER%25EWILE_E_COYOTE%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3B%20SHIPPING%25EFEDEX%3C%2Fpre%3E%3C%2Fdd%3E%0A%3C%2Fdl%3E%0A%3Ch3%3ESecond%20Example%20transaction%20sequence%3A%3C%2Fh3%3E%0A%3Cdl%3E%0A%3Cdt%3EAssume%20all%20mappings%20from%20above%20have%20been%20cleared.%3C%2Fdt%3E%3Cdd%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20receives%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3B%20path%25E%2F%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2F%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EClient%20receives%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ESet-Cookie%3A%20PART_NUMBER%25ERIDING_ROCKET_0023%3B%20path%25E%2Fammo%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3EWhen%20client%20requests%20a%20URL%20in%20path%20%22%2Fammo%22%20on%20this%20server%2C%20it%20sends%3A%3C%2Fdt%3E%3Cdd%3E%0A%3Cpre%3ECookie%3A%20PART_NUMBER%25ERIDING_ROCKET_0023%3B%20PART_NUMBER%25EROCKET_LAUNCHER_0001%3C%2Fpre%3E%3C%2Fdd%3E%0A%3Cdt%3E%3C%2Fdt%3E%3Cdd%3ENOTE%3A%20There%20are%20two%20name%2Fvalue%20pairs%20named%20%22PART_NUMBER%22%20due%20to%20the%20inheritance%20of%20the%20%22%2F%22%20mapping%20in%20addition%20to%20the%20%22%2Fammo%22%20mapping.%3C%2Fdd%3E%0A%3C%2Fdl%3E
<!-- CUT HERE -- CUT HERE -- CUT HERE -- CUT HERE -- CUT HERE -->
