#!/usr/bin/perl

use Moose;
use Modern::Perl;
use autodie;
use fastQ_brew;

my $app = fastQ_brew->new_with_options();
$app->run_fastQ_brew();

=head1 OPTIONS

  --i, input file (required)
  --o, output file (required)    
  --lib, library type  (default is sanger)    
  --dup, remove duplicate reads
  --qf, filter by phred probability (quality)
  --dist, std deviations between Phred min and mean
  --lf, filter by read length
  --truseq, removes truseq adapters from reads
  --trim_l, trim reads starting at left end
  --trim_r, trim reads starting at left end
  --adpt, remove a user supplied adapter      
  --fasta, convert to fastA format 
  --dna_rna, convert reads to RNA
  --rev_comp, reverse complement reads
  --no_n, remove non-designated bases from reads
  --help, Print this help
  
=cut
