# This Makefile.PL for List-Gather was generated by
# inc::MakeMaker <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.32.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.006;
use Devel::CallChecker;
use Devel::CallParser;
use IO::File;

write_header('callchecker0.h', Devel::CallChecker::callchecker0_h);
write_header('callparser.h', eval { Devel::CallParser::callparser1_h } || Devel::CallParser::callparser0_h);

sub write_header {
    my ($header, $content) = @_;
    my $fh = IO::File->new($header, 'w') or die $!;
    $fh->print($content) or die $!;
    $fh->close or die $!;
}

1;

use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT" => "Construct lists procedurally without temporary variables",
  "AUTHOR" => "Florian Ragwitz <rafl\@debian.org>",
  "CONFIGURE_REQUIRES" => {
    "Devel::CallChecker" => 0,
    "Devel::CallParser" => 0,
    "ExtUtils::MakeMaker" => 0,
    "IO::File" => 0
  },
  "DISTNAME" => "List-Gather",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.006",
  "NAME" => "List::Gather",
  "OBJECT" => "\$(BASEEXT)\$(OBJ_EXT)",
  "PREREQ_PM" => {
    "Devel::CallChecker" => 0,
    "Devel::CallParser" => 0,
    "Sub::Exporter" => 0,
    "XSLoader" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "Test::Fatal" => 0,
    "Test::More" => "0.98",
    "Try::Tiny" => 0
  },
  "VERSION" => "0.10",
  "clean" => {
    "FILES" => "callchecker0.h callparser.h"
  },
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Devel::CallChecker" => 0,
  "Devel::CallParser" => 0,
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "IO::File" => 0,
  "Sub::Exporter" => 0,
  "Test::Fatal" => 0,
  "Test::More" => "0.98",
  "Try::Tiny" => 0,
  "XSLoader" => 0,
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

$WriteMakefileArgs{CCFLAGS} = ( $Config::Config{ccflags} || '' ) . ' -I.';

$WriteMakefileArgs{PREREQ_PM}->{'B::Hooks::EndOfScope'} = 0 if $] < 5.013008;

WriteMakefile(%WriteMakefileArgs);
