/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.25 from the
 * contents of FCGI.xs. Do not edit this file, edit FCGI.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "FCGI.xs"
/* $Id: FCGI.XL,v 1.10 2003/06/22 00:24:11 robs Exp $ */

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "fcgi_config.h"
#include "fcgiapp.h"
#include "fastcgi.h"

#ifndef FALSE
#define FALSE (0)
#endif

#ifndef TRUE
#define TRUE  (1)
#endif

#ifndef dTHX
#define dTHX
#endif

#ifndef INT2PTR
#define INT2PTR(a,b) ((a) (b))
#endif

/* Deprecation added 2010-10-05.  The deprecated functionality should not be
 * removed for at least a year after that. */
#define WIDE_CHAR_DEPRECATION_MSG "Use of wide characters in %s is deprecated" \
  " and will stop wprking in a future version of FCGI"

#if defined(USE_ITHREADS)
static perl_mutex accept_mutex;
#endif

typedef struct FCGP_Request {
    int         accepted;
    int         bound;
    SV*         svin;
    SV*         svout;
    SV*         sverr;
    GV*         gv[3];
    HV*         hvEnv;
    FCGX_Request*   requestPtr;
} FCGP_Request;

static void FCGI_Finish(FCGP_Request* request);

static void 
FCGI_Flush(FCGP_Request* request) {
    dTHX;
    if(!request->bound)
        return;
    FCGX_FFlush(INT2PTR(FCGX_Stream *, SvIV((SV*) SvRV(request->svout))));
    FCGX_FFlush(INT2PTR(FCGX_Stream *, SvIV((SV*) SvRV(request->sverr))));
}

static void
FCGI_UndoBinding(FCGP_Request* request) {
    dTHX;
#ifdef USE_PERLIO
    sv_unmagic((SV *)GvIOp(request->gv[0]), 'q');
    sv_unmagic((SV *)GvIOp(request->gv[1]), 'q');
    sv_unmagic((SV *)GvIOp(request->gv[2]), 'q');
#else
    sv_unmagic((SV *)request->gv[0], 'q');
    sv_unmagic((SV *)request->gv[1], 'q');
    sv_unmagic((SV *)request->gv[2], 'q');
#endif
    request->bound = FALSE;
}

static void
FCGI_Bind(FCGP_Request* request) {
    dTHX;
#ifdef USE_PERLIO
    /* For tied filehandles, we apply tiedscalar magic to the IO
       slot of the GP rather than the GV itself. */

    if (!GvIOp(request->gv[1]))
        GvIOp(request->gv[1]) = newIO();
    if (!GvIOp(request->gv[2]))
        GvIOp(request->gv[2]) = newIO();
    if (!GvIOp(request->gv[0]))
        GvIOp(request->gv[0]) = newIO();

    sv_magic((SV *)GvIOp(request->gv[1]), request->svout, 'q', Nullch, 0);
    sv_magic((SV *)GvIOp(request->gv[2]), request->sverr, 'q', Nullch, 0);
    sv_magic((SV *)GvIOp(request->gv[0]), request->svin, 'q', Nullch, 0);
#else
    sv_magic((SV *)request->gv[1], request->svout, 'q', Nullch, 0);
    sv_magic((SV *)request->gv[2], request->sverr, 'q', Nullch, 0);
    sv_magic((SV *)request->gv[0], request->svin, 'q', Nullch, 0);
#endif
    request->bound = TRUE;
}

static void
populate_env(char **envp, HV *hv) {
    int i;
    char *p, *p1;
    SV *sv;
    dTHX;

    hv_clear(hv);
    for(i = 0; ; i++) {
        if((p = envp[i]) == NULL)
            break;
        p1 = strchr(p, '=');
        assert(p1 != NULL);
        sv = newSVpv(p1 + 1, 0);
        /* call magic for this value ourselves */
        hv_store(hv, p, p1 - p, sv, 0);
        SvSETMAGIC(sv);
    }
}

static int
FCGI_IsFastCGI(FCGP_Request* request) {
    static int isCGI = -1; /* -1: not checked; 0: FCGI; 1: CGI */

    if (request->requestPtr->listen_sock == FCGI_LISTENSOCK_FILENO) {
        if (isCGI == -1)
            isCGI = FCGX_IsCGI();
        return !isCGI;
    }

    /* A explicit socket is being used -> assume FastCGI */
    return 1;
}

static int 
FCGI_Accept(FCGP_Request* request) {
    dTHX;

    if (!FCGI_IsFastCGI(request)) {
        static int been_here = 0;

        /*
        * Not first call to FCGI_Accept and running as CGI means
        * application is done.
        */
        if (been_here)
            return EOF;
        been_here = 1;
    } 
    else {
        FCGX_Request *fcgx_req = request->requestPtr;
        int acceptResult;

        FCGI_Finish(request);
#if defined(USE_ITHREADS)
        MUTEX_LOCK(&accept_mutex);
#endif
        acceptResult = FCGX_Accept_r(fcgx_req);
#if defined(USE_ITHREADS)
        MUTEX_UNLOCK(&accept_mutex);
#endif
        if(acceptResult < 0) {
            return acceptResult;
        }

        populate_env(fcgx_req->envp, request->hvEnv);

        if (!request->svout) {
            newSVrv(request->svout = newSV(0), "FCGI::Stream");
            newSVrv(request->sverr = newSV(0), "FCGI::Stream");
            newSVrv(request->svin = newSV(0), "FCGI::Stream");
        }
        sv_setiv(SvRV(request->svout), INT2PTR(IV, fcgx_req->out));
        sv_setiv(SvRV(request->sverr), INT2PTR(IV, fcgx_req->err));
        sv_setiv(SvRV(request->svin), INT2PTR(IV, fcgx_req->in));
        FCGI_Bind(request);
        request->accepted = TRUE;
    }
    return 0;
}

static void 
FCGI_Finish(FCGP_Request* request) {
    int was_bound;
    dTHX;

    if(!request->accepted)
        return;

    if (was_bound = request->bound)
        FCGI_UndoBinding(request);
    if (was_bound)
        FCGX_Finish_r(request->requestPtr);
    else
        FCGX_Free(request->requestPtr, 1);
    request->accepted = FALSE;
}

static int 
FCGI_StartFilterData(FCGP_Request* request) {
    return request->requestPtr->in ? 
        FCGX_StartFilterData(request->requestPtr->in) : -1;
}

static FCGP_Request *
FCGI_Request(GV *in, GV *out, GV *err, HV *env, int socket, int flags) {
    FCGX_Request* fcgx_req;
    FCGP_Request* req;

    Newz(551, fcgx_req, 1, FCGX_Request);
    FCGX_InitRequest(fcgx_req, socket, flags);
    Newz(551, req, 1, FCGP_Request);
    req->requestPtr = fcgx_req;
    SvREFCNT_inc(in);
    req->gv[0] = in;
    SvREFCNT_inc(out);
    req->gv[1] = out;
    SvREFCNT_inc(err);
    req->gv[2] = err;
    SvREFCNT_inc(env);
    req->hvEnv = env;

    return req;
}

static void
FCGI_Release_Request(FCGP_Request *req) {
    SvREFCNT_dec(req->gv[0]);
    SvREFCNT_dec(req->gv[1]);
    SvREFCNT_dec(req->gv[2]);
    SvREFCNT_dec(req->hvEnv);
    FCGI_Finish(req);
    Safefree(req->requestPtr);
    Safefree(req);
}

static void
FCGI_Init() {
#if defined(USE_ITHREADS)
    dTHX;
    MUTEX_INIT(&accept_mutex);
#endif
    FCGX_Init();
}

typedef FCGX_Stream* FCGI__Stream;
typedef FCGP_Request* FCGI;
typedef GV* GLOBREF;
typedef HV* HASHREF;

#line 258 "FCGI.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)    S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage        S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 400 "FCGI.c"

XS_EUPXS(XS_FCGI_RequestX); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI_RequestX)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "in, out, err, env, socket, flags");
    {
	GLOBREF	in;
	GLOBREF	out;
	GLOBREF	err;
	HASHREF	env;
	int	socket = (int)SvIV(ST(4))
;
	int	flags = (int)SvIV(ST(5))
;
	SV *	RETVAL;

    if (SvROK(ST(0)) && isGV(SvRV(ST(0)))) {
	in = (GV*)SvRV(ST(0));
    } else
	croak("in is not a GLOB reference")
;

    if (SvROK(ST(1)) && isGV(SvRV(ST(1)))) {
	out = (GV*)SvRV(ST(1));
    } else
	croak("out is not a GLOB reference")
;

    if (SvROK(ST(2)) && isGV(SvRV(ST(2)))) {
	err = (GV*)SvRV(ST(2));
    } else
	croak("err is not a GLOB reference")
;

    if (SvROK(ST(3)) && SvTYPE(SvRV(ST(3))) == SVt_PVHV) {
	env = (HV*)SvRV(ST(3));
    } else
	croak("env is not a reference to a hash")
;
#line 263 "FCGI.xs"
    RETVAL = sv_setref_pv(newSV(0), "FCGI", 
        FCGI_Request(in, out, err, env, socket, flags));
#line 445 "FCGI.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_FCGI_OpenSocket); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI_OpenSocket)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "path, backlog");
    {
	char*	path = (char *)SvPV_nolen(ST(0))
;
	int	backlog = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;
#line 274 "FCGI.xs"
    RETVAL = FCGX_OpenSocket(path, backlog);
#line 468 "FCGI.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_FCGI_CloseSocket); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI_CloseSocket)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "socket");
    {
	int	socket = (int)SvIV(ST(0))
;
#line 283 "FCGI.xs"
    close(socket);
#line 486 "FCGI.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_FCGI_Accept); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI_Accept)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "request");
    {
	FCGI	request;
	int	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    request = INT2PTR(FCGI,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::Accept",
			"request", "FCGI")
;

	RETVAL = FCGI_Accept(request);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_FCGI_Finish); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI_Finish)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "request");
    {
	FCGI	request;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    request = INT2PTR(FCGI,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::Finish",
			"request", "FCGI")
;

	FCGI_Finish(request);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_FCGI_Flush); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI_Flush)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "request");
    {
	FCGI	request;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    request = INT2PTR(FCGI,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::Flush",
			"request", "FCGI")
;

	FCGI_Flush(request);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_FCGI_GetEnvironment); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI_GetEnvironment)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "request");
    {
	FCGI	request;
	HV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    request = INT2PTR(FCGI,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::GetEnvironment",
			"request", "FCGI")
;
#line 305 "FCGI.xs"
    RETVAL = request->hvEnv;
#line 591 "FCGI.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_FCGI_GetHandles); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI_GetHandles)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "request");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	FCGI	request;
#line 314 "FCGI.xs"
    int i;
#line 611 "FCGI.c"

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    request = INT2PTR(FCGI,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::GetHandles",
			"request", "FCGI")
;
#line 316 "FCGI.xs"
    EXTEND(sp,3);
    for (i = 0; i < 3; ++i)
        PUSHs(sv_2mortal(newRV((SV *) request->gv[i])));
#line 626 "FCGI.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_FCGI_IsFastCGI); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI_IsFastCGI)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "request");
    {
	FCGI	request;
	int	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    request = INT2PTR(FCGI,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::IsFastCGI",
			"request", "FCGI")
;

	RETVAL = FCGI_IsFastCGI(request);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_FCGI_Detach); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI_Detach)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "request");
    {
	FCGI	request;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    request = INT2PTR(FCGI,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::Detach",
			"request", "FCGI")
;
#line 330 "FCGI.xs"
    if (request->accepted && request->bound) {
        FCGI_UndoBinding(request);
        FCGX_Detach(request->requestPtr);
    }
#line 684 "FCGI.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_FCGI_Attach); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI_Attach)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "request");
    {
	FCGI	request;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    request = INT2PTR(FCGI,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::Attach",
			"request", "FCGI")
;
#line 340 "FCGI.xs"
    if (request->accepted && !request->bound) {
        FCGI_Bind(request);
        FCGX_Attach(request->requestPtr);
    }
#line 713 "FCGI.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_FCGI_LastCall); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI_LastCall)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "request");
    {
	FCGI	request;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    request = INT2PTR(FCGI,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::LastCall",
			"request", "FCGI")
;
#line 350 "FCGI.xs"
    FCGX_ShutdownPending();
#line 739 "FCGI.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_FCGI_StartFilterData); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI_StartFilterData)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "request");
    {
	FCGI	request;
	int	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    request = INT2PTR(FCGI,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::StartFilterData",
			"request", "FCGI")
;

	RETVAL = FCGI_StartFilterData(request);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_FCGI_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "request");
    {
	FCGI	request;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    request = INT2PTR(FCGI,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not a reference",
			"FCGI::DESTROY",
			"request")
;
#line 361 "FCGI.xs"
    FCGI_Release_Request(request);
#line 793 "FCGI.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_FCGI__Stream_PRINT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI__Stream_PRINT)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "stream, ...");
    {
	FCGI__Stream	stream;
#line 369 "FCGI.xs"
    int n;
    STRLEN len;
    register char *str;
    bool ok = TRUE;
#line 812 "FCGI.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    stream = INT2PTR(FCGI__Stream,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::Stream::PRINT",
			"stream", "FCGI::Stream")
;
#line 374 "FCGI.xs"
    for (n = 1; ok && n < items; ++n) {
#ifdef DO_UTF8
        if (DO_UTF8(ST(n)) && !sv_utf8_downgrade(ST(n), 1) && ckWARN_d(WARN_UTF8))
            Perl_warner(aTHX_ WARN_UTF8, WIDE_CHAR_DEPRECATION_MSG,
                        "FCGI::Stream::PRINT");
#endif
        str = (char *)SvPV(ST(n),len);
        if (FCGX_PutStr(str, len, stream) < 0)
            ok = FALSE;
    }
    if (ok && SvTRUEx(perl_get_sv("|", FALSE)) && FCGX_FFlush(stream) < 0)
        ok = FALSE;
    RETVAL = ok ? &PL_sv_yes : &PL_sv_undef;
#line 838 "FCGI.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_FCGI__Stream_WRITE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI__Stream_WRITE)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "stream, bufsv, len, ...");
    {
	FCGI__Stream	stream;
	SV *	bufsv = ST(1)
;
	int	len = (int)SvIV(ST(2))
;
#line 396 "FCGI.xs"
    int offset;
    char *buf;
    STRLEN blen;
    int n;
#line 863 "FCGI.c"
	int	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    stream = INT2PTR(FCGI__Stream,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::Stream::WRITE",
			"stream", "FCGI::Stream")
;
#line 401 "FCGI.xs"
    offset = (items == 4) ? (int)SvIV(ST(3)) : 0;
#ifdef DO_UTF8
    if (DO_UTF8(bufsv) && !sv_utf8_downgrade(bufsv, 1) && ckWARN_d(WARN_UTF8))
         Perl_warner(aTHX_ WARN_UTF8, WIDE_CHAR_DEPRECATION_MSG,
                     "FCGI::Stream::WRITE");
#endif
    buf = SvPV(bufsv, blen);
    if (offset < 0) offset += blen;
    if (len > blen - offset)
        len = blen - offset;
    if (offset < 0 || offset >= blen ||
        (n = FCGX_PutStr(buf+offset, len, stream)) < 0) 
        ST(0) = &PL_sv_undef;
    else {
        ST(0) = sv_newmortal();
        sv_setiv(ST(0), n);
    }
#line 894 "FCGI.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_FCGI__Stream_READ); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI__Stream_READ)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "stream, bufsv, len, ...");
    {
	FCGI__Stream	stream;
	SV *	bufsv = ST(1)
;
	int	len = (int)SvIV(ST(2))
;
#line 425 "FCGI.xs"
    int offset = 0;
    char *buf;
    STRLEN blen;
#line 916 "FCGI.c"

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    stream = INT2PTR(FCGI__Stream,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::Stream::READ",
			"stream", "FCGI::Stream")
;
#line 429 "FCGI.xs"
    if (items < 3 || items > 4)
        croak("Usage: FCGI::Stream::READ(STREAM, SCALAR, LENGTH [, OFFSET ])");
    if (len < 0)
        croak("Negative length");
    if (!SvOK(bufsv))
        sv_setpvn(bufsv, "", 0);
#ifdef DO_UTF8
    if (DO_UTF8(bufsv) && !sv_utf8_downgrade(bufsv, 1) && ckWARN_d(WARN_UTF8))
         Perl_warner(aTHX_ WARN_UTF8, WIDE_CHAR_DEPRECATION_MSG,
                     "FCGI::Stream::READ");
#endif
    buf = SvPV_force(bufsv, blen);
    if (items == 4) {
        offset = SvIV(ST(3));
        if (offset < 0) {
            if (-offset > (int)blen)
                croak("Offset outside string");
            offset += blen;
        }
    }
    buf = SvGROW(bufsv, len + offset + 1);
    if (offset > blen)
        Zero(buf + blen, offset - blen, char);
    len = FCGX_GetStr(buf + offset, len, stream);
    SvCUR_set(bufsv, len + offset);
    *SvEND(bufsv) = '\0';
    (void)SvPOK_only(bufsv);
    SvSETMAGIC(bufsv);
    XSRETURN_IV(len);
#line 957 "FCGI.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_FCGI__Stream_GETC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI__Stream_GETC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "stream");
    {
	FCGI__Stream	stream;
#line 463 "FCGI.xs"
    int retval;
#line 973 "FCGI.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    stream = INT2PTR(FCGI__Stream,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::Stream::GETC",
			"stream", "FCGI::Stream")
;
#line 465 "FCGI.xs"
    if ((retval = FCGX_GetChar(stream)) != -1) {
        ST(0) = sv_newmortal();
        sv_setpvf(ST(0), "%c", retval);
    }
    else
        ST(0) = &PL_sv_undef;
#line 992 "FCGI.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_FCGI__Stream_EOF); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI__Stream_EOF)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "stream, called=0");
    {
	FCGI__Stream	stream;
	IV	called;
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    stream = INT2PTR(FCGI__Stream,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::Stream::EOF",
			"stream", "FCGI::Stream")
;

	if (items < 2)
	    called = 0;
	else {
	    called = (IV)SvIV(ST(1))
;
	}
#line 477 "FCGI.xs"
    RETVAL = boolSV(FCGX_HasSeenEOF(stream));
#line 1027 "FCGI.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_FCGI__Stream_FILENO); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI__Stream_FILENO)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "stream");
    {
	FCGI__Stream	stream;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    stream = INT2PTR(FCGI__Stream,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::Stream::FILENO",
			"stream", "FCGI::Stream")
;
#line 485 "FCGI.xs"
    if (FCGX_HasSeenEOF(stream) != 0)
        XSRETURN_UNDEF;
    else
        XSRETURN_IV(-1);
#line 1058 "FCGI.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_FCGI__Stream_CLOSE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_FCGI__Stream_CLOSE)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "stream");
    {
	FCGI__Stream	stream;
	bool	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "FCGI::Stream")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    stream = INT2PTR(FCGI__Stream,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"FCGI::Stream::CLOSE",
			"stream", "FCGI::Stream")
;
#line 494 "FCGI.xs"
    RETVAL = FCGX_FClose(stream) != -1;
#line 1085 "FCGI.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_FCGI); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_FCGI)
{
    dVAR; dXSARGS;
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK;

        (void)newXSproto_portable("FCGI::RequestX", XS_FCGI_RequestX, file, "***$$$");
        (void)newXSproto_portable("FCGI::OpenSocket", XS_FCGI_OpenSocket, file, "$$");
        (void)newXSproto_portable("FCGI::CloseSocket", XS_FCGI_CloseSocket, file, "$");
        (void)newXSproto_portable("FCGI::Accept", XS_FCGI_Accept, file, "$");
        (void)newXSproto_portable("FCGI::Finish", XS_FCGI_Finish, file, "$");
        (void)newXSproto_portable("FCGI::Flush", XS_FCGI_Flush, file, "$");
        (void)newXSproto_portable("FCGI::GetEnvironment", XS_FCGI_GetEnvironment, file, "$");
        (void)newXSproto_portable("FCGI::GetHandles", XS_FCGI_GetHandles, file, "$");
        (void)newXSproto_portable("FCGI::IsFastCGI", XS_FCGI_IsFastCGI, file, "$");
        (void)newXSproto_portable("FCGI::Detach", XS_FCGI_Detach, file, "$");
        (void)newXSproto_portable("FCGI::Attach", XS_FCGI_Attach, file, "$");
        (void)newXSproto_portable("FCGI::LastCall", XS_FCGI_LastCall, file, "$");
        (void)newXSproto_portable("FCGI::StartFilterData", XS_FCGI_StartFilterData, file, "$");
        newXS("FCGI::DESTROY", XS_FCGI_DESTROY, file);
        newXS("FCGI::Stream::PRINT", XS_FCGI__Stream_PRINT, file);
        newXS("FCGI::Stream::WRITE", XS_FCGI__Stream_WRITE, file);
        newXS("FCGI::Stream::READ", XS_FCGI__Stream_READ, file);
        newXS("FCGI::Stream::GETC", XS_FCGI__Stream_GETC, file);
        newXS("FCGI::Stream::EOF", XS_FCGI__Stream_EOF, file);
        newXS("FCGI::Stream::FILENO", XS_FCGI__Stream_FILENO, file);
        newXS("FCGI::Stream::CLOSE", XS_FCGI__Stream_CLOSE, file);

    /* Initialisation Section */

#line 251 "FCGI.xs"
    FCGI_Init();

#line 1138 "FCGI.c"

    /* End of Initialisation Section */

#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

