package Locales::DB::Territory::ko;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::ko::VERSION = '0.09';

$Locales::DB::Territory::ko::cldr_version = '2.0';

%Locales::DB::Territory::ko::code_to_name = (
    '001' => '세계',
    '002' => '아프리카',
    '003' => '북아메리카',
    '005' => "남아메리카\[남미\]",
    '009' => '오세아니아',
    '011' => '서아프리카',
    '013' => "중앙\ 아메리카",
    '014' => "동부\ 아프리카",
    '015' => "북부\ 아프리카",
    '017' => "중부\ 아프리카",
    '018' => "남부\ 아프리카",
    '019' => "아메리카\ 대륙",
    '021' => "북부\ 아메리카",
    '029' => "카리브\ 해\ 제도",
    '030' => '동아시아',
    '034' => '남아시아',
    '035' => "동남\ 아시아",
    '039' => '남유럽',
    '053' => "오스트레일리아와\ 뉴질랜드",
    '054' => '멜라네시아',
    '057' => "미크로네시아\ 지역",
    '061' => '폴리네시아',
    '062' => "중남\ 아시아",
    142   => '아시아',
    143   => "중앙\ 아시아",
    145   => '서아시아',
    150   => '유럽',
    151   => '동유럽',
    154   => '북유럽',
    155   => '서유럽',
    172   => "독립\ 국가\ 연합",
    200   => 'Czechoslovakia',
    419   => "라틴\ 아메리카\ 및\ 카리브\ 해\ 제도",
    830   => "Channel\ Islands",
    'ac'  => "어센션\ 섬",
    'ad'  => '안도라',
    'ae'  => "아랍에미리트\ 연합",
    'af'  => '아프가니스탄',
    'ag'  => "앤티가\ 바부다",
    'ai'  => '안길라',
    'al'  => '알바니아',
    'am'  => '아르메니아',
    'an'  => "네덜란드령\ 안틸레스",
    'ao'  => '앙골라',
    'aq'  => "남극\ 대륙",
    'ar'  => '아르헨티나',
    'as'  => "아메리칸\ 사모아",
    'at'  => '오스트리아',
    'au'  => '오스트레일리아',
    'aw'  => '아루바',
    'ax'  => "올란드\ 제도",
    'az'  => '아제르바이잔',
    'ba'  => "보스니아\ 헤르체고비나",
    'bb'  => '바베이도스',
    'bd'  => '방글라데시',
    'be'  => '벨기에',
    'bf'  => '부르키나파소',
    'bg'  => '불가리아',
    'bh'  => '바레인',
    'bi'  => '부룬디',
    'bj'  => '베냉',
    'bl'  => "생\ 바르텔르미",
    'bm'  => '버뮤다',
    'bn'  => '브루나이',
    'bo'  => '볼리비아',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => '브라질',
    'bs'  => '바하마',
    'bt'  => '부탄',
    'bv'  => '부베',
    'bw'  => '보츠와나',
    'by'  => '벨라루스',
    'bz'  => '벨리즈',
    'ca'  => '캐나다',
    'cc'  => '코코스제도',
    'cd'  => '콩고민주공화국',
    'cf'  => "중앙\ 아프리카\ 공화국",
    'cg'  => "콩고\ 공화국",
    'ch'  => '스위스',
    'ci'  => '코트디부아르',
    'ck'  => '쿡제도',
    'cl'  => '칠레',
    'cm'  => '카메룬',
    'cn'  => '중국',
    'co'  => '콜롬비아',
    'cp'  => "클립퍼튼\ 섬",
    'cr'  => '코스타리카',
    'cs'  => "세르비아\ 및\ 몬테네그로",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => '쿠바',
    'cv'  => '까뽀베르데',
    'cx'  => '크리스마스섬',
    'cy'  => '사이프러스',
    'cz'  => '체코',
    'dd'  => "East\ Germany",
    'de'  => '독일',
    'dg'  => "디에고\ 가르시아",
    'dj'  => '지부티',
    'dk'  => '덴마크',
    'dm'  => '도미니카',
    'do'  => "도미니카\ 공화국",
    'dz'  => '알제리',
    'ea'  => "세우타\ 및\ 멜리야",
    'ec'  => '에콰도르',
    'ee'  => '에스토니아',
    'eg'  => '이집트',
    'eh'  => '서사하라',
    'er'  => '에리트리아',
    'es'  => '스페인',
    'et'  => '이디오피아',
    'eu'  => "유럽\ 연합",
    'fi'  => '핀란드',
    'fj'  => '피지',
    'fk'  => "포클랜드\ 제도\[말비나스\ 군도\]",
    'fm'  => '미크로네시아',
    'fo'  => '페로제도',
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => '프랑스',
    'fx'  => "Metropolitan\ France",
    'ga'  => '가봉',
    'gb'  => '영국',
    'gd'  => '그레나다',
    'ge'  => '그루지야',
    'gf'  => "프랑스령\ 기아나",
    'gg'  => '건지',
    'gh'  => '가나',
    'gi'  => '지브롤터',
    'gl'  => '그린란드',
    'gm'  => '감비아',
    'gn'  => '기니',
    'gp'  => '과들루프',
    'gq'  => "적도\ 기니",
    'gr'  => '그리스',
    'gs'  => "사우스조지아\ 사우스샌드위치\ 제도",
    'gt'  => '과테말라',
    'gu'  => '괌',
    'gw'  => '기네비쏘',
    'gy'  => '가이아나',
    'hk'  => '홍콩',
    'hm'  => "허드섬\-맥도널드제도",
    'hn'  => '온두라스',
    'hr'  => '크로아티아',
    'ht'  => '아이티',
    'hu'  => '헝가리',
    'ic'  => "카나리아\ 제도",
    'id'  => '인도네시아',
    'ie'  => '아일랜드',
    'il'  => '이스라엘',
    'im'  => "맨\ 섬",
    'in'  => '인도',
    'io'  => '영국령인도양식민지',
    'iq'  => '이라크',
    'ir'  => '이란',
    'is'  => '아이슬란드',
    'it'  => '이탈리아',
    'je'  => '저지',
    'jm'  => '자메이카',
    'jo'  => '요르단',
    'jp'  => '일본',
    'jt'  => "Johnston\ Island",
    'ke'  => '케냐',
    'kg'  => '키르기스스탄',
    'kh'  => '캄보디아',
    'ki'  => '키리바시',
    'km'  => '코모로스',
    'kn'  => "세인트크리스토퍼\ 네비스",
    'kp'  => "조선\ 민주주의\ 인민\ 공화국",
    'kr'  => '대한민국',
    'kw'  => '쿠웨이트',
    'ky'  => '케이맨제도',
    'kz'  => '카자흐스탄',
    'la'  => '라오스',
    'lb'  => '레바논',
    'lc'  => '세인트루시아',
    'li'  => '리히텐슈타인',
    'lk'  => '스리랑카',
    'lr'  => '라이베리아',
    'ls'  => '레소토',
    'lt'  => '리투아니아',
    'lu'  => '룩셈부르크',
    'lv'  => '라트비아',
    'ly'  => '리비아',
    'ma'  => '모로코',
    'mc'  => '모나코',
    'md'  => '몰도바',
    'me'  => '몬테네그로',
    'mf'  => "생\ 마르탱",
    'mg'  => '마다가스카르',
    'mh'  => "마샬\ 군도",
    'mi'  => "Midway\ Islands",
    'mk'  => "마케도니아\[FYROM\]",
    'ml'  => '말리',
    'mm'  => '미얀마',
    'mn'  => '몽골',
    'mo'  => '마카오',
    'mp'  => '북마리아나제도',
    'mq'  => '말티니크',
    'mr'  => '모리타니',
    'ms'  => '몬트세라트',
    'mt'  => '몰타',
    'mu'  => '모리셔스',
    'mv'  => '몰디브',
    'mw'  => '말라위',
    'mx'  => '멕시코',
    'my'  => '말레이시아',
    'mz'  => '모잠비크',
    'na'  => '나미비아',
    'nc'  => "뉴\ 칼레도니아",
    'ne'  => '니제르',
    'nf'  => '노퍽섬',
    'ng'  => '나이지리아',
    'ni'  => '니카라과',
    'nl'  => '네덜란드',
    'no'  => '노르웨이',
    'np'  => '네팔',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => '나우루',
    'nt'  => "Neutral\ Zone",
    'nu'  => '니우에',
    'nz'  => '뉴질랜드',
    'om'  => '오만',
    'pa'  => '파나마',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => '페루',
    'pf'  => "프랑스령\ 폴리네시아",
    'pg'  => '파푸아뉴기니',
    'ph'  => '필리핀',
    'pk'  => '파키스탄',
    'pl'  => '폴란드',
    'pm'  => "세인트피에르\-미케롱",
    'pn'  => '핏케언섬',
    'pr'  => '푸에르토리코',
    'ps'  => "팔레스타인\ 지구",
    'pt'  => '포르투갈',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => '팔라우',
    'py'  => '파라과이',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => '카타르',
    'qo'  => "오세아니아\ 외곽",
    're'  => '리유니온',
    'ro'  => '루마니아',
    'rs'  => '세르비아',
    'ru'  => '러시아',
    'rw'  => '르완다',
    'sa'  => '사우디아라비아',
    'sb'  => "솔로몬\ 제도",
    'sc'  => '쉐이쉘',
    'sd'  => '수단',
    'se'  => '스웨덴',
    'sg'  => '싱가포르',
    'sh'  => '세인트헬레나',
    'si'  => '슬로베니아',
    'sj'  => "스발바르제도\-얀마웬섬",
    'sk'  => '슬로바키아',
    'sl'  => '시에라리온',
    'sm'  => '산마리노',
    'sn'  => '세네갈',
    'so'  => '소말리아',
    'sr'  => '수리남',
    'st'  => "상투메\ 프린시페",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => '엘살바도르',
    'sy'  => '시리아',
    'sz'  => '스와질랜드',
    'ta'  => '트리스탄다쿠나',
    'tc'  => '터크스케이커스제도',
    'td'  => '차드',
    'tf'  => "프랑스\ 남부\ 지방",
    'tg'  => '토고',
    'th'  => '태국',
    'tj'  => '타지키스탄',
    'tk'  => '토켈라우',
    'tl'  => '동티모르',
    'tm'  => '투르크메니스탄',
    'tn'  => '튀니지',
    'to'  => '통가',
    'tr'  => '터키',
    'tt'  => "트리니다드\ 토바고",
    'tv'  => '투발루',
    'tw'  => '대만',
    'tz'  => '탄자니아',
    'ua'  => '우크라이나',
    'ug'  => '우간다',
    'um'  => "미국령\ 해외\ 제도",
    'us'  => '미국',
    'uy'  => '우루과이',
    'uz'  => '우즈베키스탄',
    'va'  => '바티칸',
    'vc'  => '세인트빈센트그레나딘',
    'vd'  => "North\ Vietnam",
    've'  => '베네수엘라',
    'vg'  => "영국령\ 버진\ 아일랜드",
    'vi'  => "미국령\ 버진\ 아일랜드",
    'vn'  => '베트남',
    'vu'  => '바누아투',
    'wf'  => "왈리스\-푸투나\ 제도",
    'wk'  => "Wake\ Island",
    'ws'  => '사모아',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => '예멘',
    'yt'  => '마요티',
    'za'  => '남아프리카',
    'zm'  => '잠비아',
    'zw'  => '짐바브웨',
    'zz'  => "알수없거나\ 유효하지\ 않은\ 지역",
);

%Locales::DB::Territory::ko::name_to_code = (
    'britishantarcticterritory'                     => 'bq',
    'cantonandenderburyislands'                     => 'ct',
    'channelislands'                                => 830,
    'czechoslovakia'                                => 200,
    'dronningmaudland'                              => 'nq',
    'eastgermany'                                   => 'dd',
    'frenchsouthernandantarcticterritories'         => 'fq',
    'johnstonisland'                                => 'jt',
    'metropolitanfrance'                            => 'fx',
    'midwayislands'                                 => 'mi',
    'neutralzone'                                   => 'nt',
    'northvietnam'                                  => 'vd',
    'pacificislandstrustterritory'                  => 'pc',
    'panamacanalzone'                               => 'pz',
    "people\â\\sdemocraticrepublicofyemen"     => 'yd',
    "u\.s\.miscellaneouspacificislands"             => 'pu',
    'unionofsovietsocialistrepublics'               => 'su',
    'wakeisland'                                    => 'wk',
    '가나'                                        => 'gh',
    '가봉'                                        => 'ga',
    '가이아나'                                  => 'gy',
    '감비아'                                     => 'gm',
    '건지'                                        => 'gg',
    '과들루프'                                  => 'gp',
    '과테말라'                                  => 'gt',
    '괌'                                           => 'gu',
    '그레나다'                                  => 'gd',
    '그루지야'                                  => 'ge',
    '그리스'                                     => 'gr',
    '그린란드'                                  => 'gl',
    '기네비쏘'                                  => 'gw',
    '기니'                                        => 'gn',
    '까뽀베르데'                               => 'cv',
    '나미비아'                                  => 'na',
    '나우루'                                     => 'nr',
    '나이지리아'                               => 'ng',
    '남극대륙'                                  => 'aq',
    '남부아프리카'                            => '018',
    '남아메리카남미'                         => '005',
    '남아시아'                                  => '034',
    '남아프리카'                               => 'za',
    '남유럽'                                     => '039',
    '네덜란드'                                  => 'nl',
    '네덜란드령안틸레스'                   => 'an',
    '네팔'                                        => 'np',
    '노르웨이'                                  => 'no',
    '노퍽섬'                                     => 'nf',
    '뉴질랜드'                                  => 'nz',
    '뉴칼레도니아'                            => 'nc',
    '니우에'                                     => 'nu',
    '니제르'                                     => 'ne',
    '니카라과'                                  => 'ni',
    '대만'                                        => 'tw',
    '대한민국'                                  => 'kr',
    '덴마크'                                     => 'dk',
    '도미니카'                                  => 'dm',
    '도미니카공화국'                         => 'do',
    '독립국가연합'                            => 172,
    '독일'                                        => 'de',
    '동남아시아'                               => '035',
    '동부아프리카'                            => '014',
    '동아시아'                                  => '030',
    '동유럽'                                     => 151,
    '동티모르'                                  => 'tl',
    '디에고가르시아'                         => 'dg',
    '라오스'                                     => 'la',
    '라이베리아'                               => 'lr',
    '라트비아'                                  => 'lv',
    '라틴아메리카및카리브해제도'       => 419,
    '러시아'                                     => 'ru',
    '레바논'                                     => 'lb',
    '레소토'                                     => 'ls',
    '루마니아'                                  => 'ro',
    '룩셈부르크'                               => 'lu',
    '르완다'                                     => 'rw',
    '리비아'                                     => 'ly',
    '리유니온'                                  => 're',
    '리투아니아'                               => 'lt',
    '리히텐슈타인'                            => 'li',
    '마다가스카르'                            => 'mg',
    '마샬군도'                                  => 'mh',
    '마요티'                                     => 'yt',
    '마카오'                                     => 'mo',
    '마케도니아fyrom'                          => 'mk',
    '말라위'                                     => 'mw',
    '말레이시아'                               => 'my',
    '말리'                                        => 'ml',
    '말티니크'                                  => 'mq',
    '맨섬'                                        => 'im',
    '멕시코'                                     => 'mx',
    '멜라네시아'                               => '054',
    '모나코'                                     => 'mc',
    '모로코'                                     => 'ma',
    '모리셔스'                                  => 'mu',
    '모리타니'                                  => 'mr',
    '모잠비크'                                  => 'mz',
    '몬테네그로'                               => 'me',
    '몬트세라트'                               => 'ms',
    '몰도바'                                     => 'md',
    '몰디브'                                     => 'mv',
    '몰타'                                        => 'mt',
    '몽골'                                        => 'mn',
    '미국'                                        => 'us',
    '미국령버진아일랜드'                   => 'vi',
    '미국령해외제도'                         => 'um',
    '미얀마'                                     => 'mm',
    '미크로네시아'                            => 'fm',
    '미크로네시아지역'                      => '057',
    '바누아투'                                  => 'vu',
    '바레인'                                     => 'bh',
    '바베이도스'                               => 'bb',
    '바티칸'                                     => 'va',
    '바하마'                                     => 'bs',
    '방글라데시'                               => 'bd',
    '버뮤다'                                     => 'bm',
    '베냉'                                        => 'bj',
    '베네수엘라'                               => 've',
    '베트남'                                     => 'vn',
    '벨기에'                                     => 'be',
    '벨라루스'                                  => 'by',
    '벨리즈'                                     => 'bz',
    '보스니아헤르체고비나'                => 'ba',
    '보츠와나'                                  => 'bw',
    '볼리비아'                                  => 'bo',
    '부룬디'                                     => 'bi',
    '부르키나파소'                            => 'bf',
    '부베'                                        => 'bv',
    '부탄'                                        => 'bt',
    '북마리아나제도'                         => 'mp',
    '북부아메리카'                            => '021',
    '북부아프리카'                            => '015',
    '북아메리카'                               => '003',
    '북유럽'                                     => 154,
    '불가리아'                                  => 'bg',
    '브라질'                                     => 'br',
    '브루나이'                                  => 'bn',
    '사모아'                                     => 'ws',
    '사우디아라비아'                         => 'sa',
    '사우스조지아사우스샌드위치제도' => 'gs',
    '사이프러스'                               => 'cy',
    '산마리노'                                  => 'sm',
    '상투메프린시페'                         => 'st',
    '생마르탱'                                  => 'mf',
    '생바르텔르미'                            => 'bl',
    '서사하라'                                  => 'eh',
    '서아시아'                                  => 145,
    '서아프리카'                               => '011',
    '서유럽'                                     => 155,
    '세계'                                        => '001',
    '세네갈'                                     => 'sn',
    '세르비아'                                  => 'rs',
    '세르비아및몬테네그로'                => 'cs',
    '세우타및멜리야'                         => 'ea',
    '세인트루시아'                            => 'lc',
    '세인트빈센트그레나딘'                => 'vc',
    '세인트크리스토퍼네비스'             => 'kn',
    '세인트피에르미케롱'                   => 'pm',
    '세인트헬레나'                            => 'sh',
    '소말리아'                                  => 'so',
    '솔로몬제도'                               => 'sb',
    '수단'                                        => 'sd',
    '수리남'                                     => 'sr',
    '쉐이쉘'                                     => 'sc',
    '스리랑카'                                  => 'lk',
    '스발바르제도얀마웬섬'                => 'sj',
    '스와질랜드'                               => 'sz',
    '스웨덴'                                     => 'se',
    '스위스'                                     => 'ch',
    '스페인'                                     => 'es',
    '슬로바키아'                               => 'sk',
    '슬로베니아'                               => 'si',
    '시리아'                                     => 'sy',
    '시에라리온'                               => 'sl',
    '싱가포르'                                  => 'sg',
    '아랍에미리트연합'                      => 'ae',
    '아루바'                                     => 'aw',
    '아르메니아'                               => 'am',
    '아르헨티나'                               => 'ar',
    '아메리카대륙'                            => '019',
    '아메리칸사모아'                         => 'as',
    '아시아'                                     => 142,
    '아이슬란드'                               => 'is',
    '아이티'                                     => 'ht',
    '아일랜드'                                  => 'ie',
    '아제르바이잔'                            => 'az',
    '아프가니스탄'                            => 'af',
    '아프리카'                                  => '002',
    '안길라'                                     => 'ai',
    '안도라'                                     => 'ad',
    '알바니아'                                  => 'al',
    '알수없거나유효하지않은지역'       => 'zz',
    '알제리'                                     => 'dz',
    '앙골라'                                     => 'ao',
    '앤티가바부다'                            => 'ag',
    '어센션섬'                                  => 'ac',
    '에리트리아'                               => 'er',
    '에스토니아'                               => 'ee',
    '에콰도르'                                  => 'ec',
    '엘살바도르'                               => 'sv',
    '영국'                                        => 'gb',
    '영국령버진아일랜드'                   => 'vg',
    '영국령인도양식민지'                   => 'io',
    '예멘'                                        => 'ye',
    '오만'                                        => 'om',
    '오세아니아'                               => '009',
    '오세아니아외곽'                         => 'qo',
    '오스트레일리아'                         => 'au',
    '오스트레일리아와뉴질랜드'          => '053',
    '오스트리아'                               => 'at',
    '온두라스'                                  => 'hn',
    '올란드제도'                               => 'ax',
    '왈리스푸투나제도'                      => 'wf',
    '요르단'                                     => 'jo',
    '우간다'                                     => 'ug',
    '우루과이'                                  => 'uy',
    '우즈베키스탄'                            => 'uz',
    '우크라이나'                               => 'ua',
    '유럽'                                        => 150,
    '유럽연합'                                  => 'eu',
    '이디오피아'                               => 'et',
    '이라크'                                     => 'iq',
    '이란'                                        => 'ir',
    '이스라엘'                                  => 'il',
    '이집트'                                     => 'eg',
    '이탈리아'                                  => 'it',
    '인도'                                        => 'in',
    '인도네시아'                               => 'id',
    '일본'                                        => 'jp',
    '자메이카'                                  => 'jm',
    '잠비아'                                     => 'zm',
    '저지'                                        => 'je',
    '적도기니'                                  => 'gq',
    '조선민주주의인민공화국'             => 'kp',
    '중국'                                        => 'cn',
    '중남아시아'                               => '062',
    '중부아프리카'                            => '017',
    '중앙아메리카'                            => '013',
    '중앙아시아'                               => 143,
    '중앙아프리카공화국'                   => 'cf',
    '지부티'                                     => 'dj',
    '지브롤터'                                  => 'gi',
    '짐바브웨'                                  => 'zw',
    '차드'                                        => 'td',
    '체코'                                        => 'cz',
    '칠레'                                        => 'cl',
    '카나리아제도'                            => 'ic',
    '카리브해제도'                            => '029',
    '카메룬'                                     => 'cm',
    '카자흐스탄'                               => 'kz',
    '카타르'                                     => 'qa',
    '캄보디아'                                  => 'kh',
    '캐나다'                                     => 'ca',
    '케냐'                                        => 'ke',
    '케이맨제도'                               => 'ky',
    '코모로스'                                  => 'km',
    '코스타리카'                               => 'cr',
    '코코스제도'                               => 'cc',
    '코트디부아르'                            => 'ci',
    '콜롬비아'                                  => 'co',
    '콩고공화국'                               => 'cg',
    '콩고민주공화국'                         => 'cd',
    '쿠바'                                        => 'cu',
    '쿠웨이트'                                  => 'kw',
    '쿡제도'                                     => 'ck',
    '크로아티아'                               => 'hr',
    '크리스마스섬'                            => 'cx',
    '클립퍼튼섬'                               => 'cp',
    '키르기스스탄'                            => 'kg',
    '키리바시'                                  => 'ki',
    '타지키스탄'                               => 'tj',
    '탄자니아'                                  => 'tz',
    '태국'                                        => 'th',
    '터크스케이커스제도'                   => 'tc',
    '터키'                                        => 'tr',
    '토고'                                        => 'tg',
    '토켈라우'                                  => 'tk',
    '통가'                                        => 'to',
    '투르크메니스탄'                         => 'tm',
    '투발루'                                     => 'tv',
    '튀니지'                                     => 'tn',
    '트리니다드토바고'                      => 'tt',
    '트리스탄다쿠나'                         => 'ta',
    '파나마'                                     => 'pa',
    '파라과이'                                  => 'py',
    '파키스탄'                                  => 'pk',
    '파푸아뉴기니'                            => 'pg',
    '팔라우'                                     => 'pw',
    '팔레스타인지구'                         => 'ps',
    '페로제도'                                  => 'fo',
    '페루'                                        => 'pe',
    '포르투갈'                                  => 'pt',
    '포클랜드제도말비나스군도'          => 'fk',
    '폴란드'                                     => 'pl',
    '폴리네시아'                               => '061',
    '푸에르토리코'                            => 'pr',
    '프랑스'                                     => 'fr',
    '프랑스남부지방'                         => 'tf',
    '프랑스령기아나'                         => 'gf',
    '프랑스령폴리네시아'                   => 'pf',
    '피지'                                        => 'fj',
    '핀란드'                                     => 'fi',
    '필리핀'                                     => 'ph',
    '핏케언섬'                                  => 'pn',
    '허드섬맥도널드제도'                   => 'hm',
    '헝가리'                                     => 'hu',
    '홍콩'                                        => 'hk',
);

1;

