use strict;
use warnings;

package App::Embra::Role::ExtraListDeps;
$App::Embra::Role::ExtraListDeps::VERSION = '0.001'; # TRIAL
# ABSTRACT: allow a plugin to add more things to listdeps

use Method::Signatures;
use Moo::Role;


requires 'extra_list_deps';


method add_extra_deps( $class:, HashRef :$config, CPAN::Meta::Requirements :$reqs ) {
    for my $extra ( $class->extra_list_deps( config => $config )) {
        my ($p, $ver) = split qr{[ ]* = [ ]*}xms, $extra;
        if( ! defined $ver ) {
            $ver = 0;
        }
        $reqs->add_minimum( $p, $ver );
    }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Role::ExtraListDeps - allow a plugin to add more things to listdeps

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This role is used by plugins to add extra pacakges to the list of required dependencies when C<embra listdeps> is executed.

Plugins which consume this role must define C<extra_list_deps>, which will be passed the values for the associated section in config and returns a list of package names.

=head1 METHODS

=head2 add_extra_deps

    App::Embra::Role::ExtraListDeps->add_extra_deps( $config, $reqs );

Static method which adds all of the plugin's extra dependencies to C<$reqs>, which is a L<CPAN::Meta::Requirements>. The values for the plugin set in the relevant config section are passed as C<$config> (HashRef).

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
