package App::I18N::Command::Gen;
use warnings;
use strict;
use Cwd;
use App::I18N::Config;
use App::I18N::Logger;
use File::Basename;
use File::Path qw(mkpath);
use File::Find::Rule;
use base qw(App::I18N::Command);

sub options { (
    'podir=s'  => 'podir',
    'g|gettext'  => 'gettext',
    'l|lang=s'   => 'language',
    ) }


# XXX: provide template option ?

=pod

Generate inline i18n dictionary dictionary:

For Perl:

    # This is auto-generated by App::I18N
    # ------------------------------
    our %DICT;
    $DICT{"en"} = {
        "msgid" => "msgstr",
        ...
    };

    $DICT{"zh-tw"} => {
        "msgid" => "msgstr",
        ....
    };

For PHP:

    $DICT = array();
    $DICT["en"] = array( 
        "msgid" => "msgstr"
    );

    ....

For JavaScript: (XXX: or just JSON ?)

    var DICT;
    DICT["en"] = {
        "msgid..." : "msgstr"
    };

    DICT["zh-tw"] = {
        ....
    };


=cut

sub run {
    my ( $self, $lang ) = @_;
    my $logger = App::I18N->logger();
    my $podir;
    $self->{mo} = $self->{locale} = 1 if $self->{gettext};
    unless( $podir ) {
        $podir = 'po' if -e 'po';
        $podir = 'locale' if -e 'locale' && $self->{locale};
        $podir ||= 'po';
    }

    my @pofiles = File::Find::Rule->file->name( "*.po" )->in( $podir );
    for my $pofile ( @pofiles ) {

        # TODO: implement this command.


#         $logger->info( "Updating $pofile" );
#         if( $self->{mo} ) {
#             my $mofile = $pofile;
#             $mofile =~ s{\.po$}{.mo};
#             $logger->info( "Updating $mofile" );
#             qx{msgfmt -v $pofile -o $mofile};
#         }
    }
}



1;
