#! perl
# Copyright (C) 2007, The Perl Foundation.
# $Id: 113-init_optimize.03.t 21449 2007-09-21 09:32:00Z paultcochrane $
# 113-init_optimize.03.t

use strict;
use warnings;
use Test::More tests => 12;
use Carp;
use lib qw( lib t/configure/testlib );
use_ok('config::init::defaults');
use_ok('config::init::optimize');
use Parrot::Configure;
use Parrot::Configure::Options qw( process_options );
use Parrot::Configure::Test qw( test_step_thru_runstep);
use Parrot::IO::Capture::Mini;

=for hints_for_testing Check latest reports of Parrot configuration
tools testing coverage to see where your time available for writing
tests is spent.  You may need to create some dummy optimizations to
boost test coverage.  Note the comment in POD:  "Should this be part of
config/inter/progs.pm?"  Also note the reference to
http://rt.perl.org/rt3//Ticket/Display.html?id=43151.

=cut

my $args = process_options(
    {
        argv => [q{--verbose}],
        mode => q{configure},
    }
);

my $conf = Parrot::Configure->new();

test_step_thru_runstep( $conf, q{init::defaults}, $args );

my ( $task, $step_name, @step_params, $step, $ret );
my $pkg = q{init::optimize};

$conf->add_steps($pkg);
$conf->options->set( %{$args} );
$task        = $conf->steps->[1];
$step_name   = $task->step;
@step_params = @{ $task->params };

$step = $step_name->new();
ok( defined $step, "$step_name constructor returned defined value" );
isa_ok( $step, $step_name );
ok( $step->description(), "$step_name has description" );

# need to capture the --verbose output,
# because the fact that it does not end
# in a newline confuses Test::Harness
{
    my $tie_out = tie *STDOUT, "Parrot::IO::Capture::Mini"
        or croak "Unable to tie";
    $ret = $step->runstep($conf);
    ok( defined $ret, "$step_name runstep() returned defined value" );
    my @more_lines = $tie_out->READLINE;
    ok( @more_lines, "verbose output:  hints were captured" );
}
untie *STDOUT;

pass("Completed all tests in $0");

################### DOCUMENTATION ###################

=head1 NAME

113-init_optimize.03.t - test config::init::optimize

=head1 SYNOPSIS

    % prove t/configure/113-init_optimize.t

=head1 DESCRIPTION

The files in this directory test functionality used by F<Configure.pl>.

The tests in this file test subroutines exported by
config::init::optimize in the case where C<--optimize> was not requested
on the command-line but C<--verbose> was.

=head1 AUTHOR

James E Keenan

=head1 SEE ALSO

config::init::optimize, F<Configure.pl>.

=cut

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
