# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 1.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test::More tests => 50;
BEGIN { use_ok('Lingua::PT::Nums2Ords') };

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

is(num2ord(1),'primeiro');
is(num2ord(2),'segundo');
is(num2ord(3),'terceiro');
is(num2ord(4),'quarto');
is(num2ord(5),'quinto');
is(num2ord(6),'sexto');
is(num2ord(7),'stimo');
is(num2ord(8),'oitavo');
is(num2ord(9),'nono');

is(num2ord(10),'dcimo');
is(num2ord(11),'dcimo primeiro');

is(num2ord(30),'trigsimo');
is(num2ord(33),'trigsimo terceiro');
is(num2ord(70),'septuagsimo');

is(num2ord(101),'centsimo primeiro');
is(num2ord(150),'centsimo quinquagsimo');
is(num2ord(199),'centsimo nonagsimo nono');
is(num2ord(299),'ducentsimo nonagsimo nono');
is(num2ord(301),'tricentsimo primeiro');
is(num2ord(421),'quadrigentsimo vigsimo primeiro');
is(num2ord(520),'quingentsimo vigsimo');
is(num2ord(622),'seiscentsimo vigsimo segundo');
is(num2ord(700),'septigentsimo');
is(num2ord(855),'octigentsimo quinquagsimo quinto');
is(num2ord(988),'nongentsimo octogsimo oitavo');

is(num2ord(1000),'milsimo');
is(num2ord(10000),'dez milsimos');
is(num2ord(11000),'onze milsimos');
is(num2ord(10090),'dez milsimos nonagsimo');
is(num2ord(100000),'cem milsimos');
is(num2ord(300000),'trezentos milsimos');
is(num2ord(321987),'trezentos e vinte e um milsimos nongentsimo octogsimo stimo');
is(num2ord(444444),'quatrocentos e quarenta e quatro milsimos quadrigentsimo quadragsimo quarto');
is(num2ord(987654),'novecentos e oitenta e sete milsimos seiscentsimo quinquagsimo quarto');

is(num2ord(1000000),'milionsimo');
is(num2ord(1000001),'milionsimo primeiro');
is(num2ord(1001001),'milionsimo milsimo primeiro');
is(num2ord(2000000),'dois milionsimos');
is(num2ord(999999999),'novecentos e noventa e nove milionsimos novecentos e noventa e nove milsimos nongentsimo nonagsimo nono');

is(num2ord(1000000000),'bilionsimo');
is(num2ord(1000000001),'bilionsimo primeiro');
is(num2ord(2000000000),'dois bilionsimos');
is(num2ord(2000002000),'dois bilionsimos dois milsimos');
is(num2ord(3002001000),'trs bilionsimos dois milionsimos milsimo');
is(num2ord(3002001009),'trs bilionsimos dois milionsimos milsimo nono');
is(num2ord(9090909090),'nove bilionsimos noventa milionsimos novecentos e nove milsimos nonagsimo');
is(num2ord(8808080808),'oito bilionsimos oitocentos e oito milionsimos oitenta milsimos octigentsimo oitavo');
is(num2ord(7654321987),'sete bilionsimos seiscentos e cinquenta e quatro milionsimos trezentos e vinte e um milsimos nongentsimo octogsimo stimo');
is(num2ord(999999999999),'novecentos e noventa e nove bilionsimos novecentos e noventa e nove milionsimos novecentos e noventa e nove milsimos nongentsimo nonagsimo nono');
