/*
 * This file was generated automatically by xsubpp version 1.9508 from the 
 * contents of Memory.xs. Do not edit this file, edit Memory.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "Memory.xs"
/*
 *
 *    Copyright (c) 1996 Matthias Neeracher
 *
 *    You may distribute under the terms of the Perl Artistic License,
 *    as specified in the README file.
 *
 * $Log: Memory.xs,v $
 * Revision 1.8  2002/11/13 02:04:52  pudge
 * Aieeeeee!  Big ol' Carbon update.
 *
 * Revision 1.7  2002/01/23 20:24:58  pudge
 * Fix silly error
 *
 * Revision 1.6  2002/01/23 05:44:42  pudge
 * Update whitespace etc., from Thomas
 *
 * Revision 1.5  2002/01/05 02:21:54  pudge
 * Sync with perforce
 *
 * Revision 1.4  2002/01/04 03:38:19  pudge
 * Disable Mac::Memory::_open (HandleSocket::OpenHandle) for now
 *
 * Revision 1.3  2001/12/19 22:57:11  pudge
 * Start to make Mac::Memory::_open work.  HandleSocket.cp still needs some lovin ' ... the entire thing is a bit unstable.
 *
 * Revision 1.2  2000/09/09 22:18:27  neeri
 * Dynamic libraries compile under 5.6
 *
 * Revision 1.1  2000/08/14 03:39:31  neeri
 * Checked into Sourceforge
 *
 * Revision 1.4  1999/06/04 16:01:31  pudge
 * Fixed Handle::get again.  Added version number (1.20).
 *
 * Revision 1.3  1999/06/03 19:27:41  pudge
 * Fixed bug in Handle::get, for returning data when handle size is 0.
 *
 * Revision 1.2  1997/11/18 00:52:34  neeri
 * MacPerl 5.1.5
 *
 * Revision 1.1  1997/04/07 20:49:55  neeri
 * Synchronized with MacPerl 5.1.4a1
 *
 */

#define MAC_CONTEXT

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifndef MACOS_TRADITIONAL
#include "../Carbon.h"
#endif
#include <Types.h>
#include <Memory.h>
#include <TextUtils.h>

typedef int	SysRet;

#define MemErrorReturn	\
	ST(0) = sv_newmortal();					\
	if (!(gMacPerl_OSErr = MemError()))	\
		sv_setiv(ST(0), 1);

#line 76 "Memory.c"
XS(XS_Handle_new)
{
    dXSARGS;
    if (items < 1 || items > 2)
	Perl_croak(aTHX_ "Usage: Handle::new(package, data=0)");
    {
	SV *	package = ST(0);
	SV *	data;
	HandleRet	RETVAL;

	if (items < 2)
	    data = 0;
	else {
	    data = ST(1);
	}
#line 90 "Memory.xs"
	if (data) {
		STRLEN	len;
		Ptr		ptr	=	SvPV(data, len);
		if (gMacPerl_OSErr = PtrToHand(ptr, &RETVAL, len)) {
			XSRETURN_UNDEF;
		}
	} else
		RETVAL = NewHandle(0);
#line 101 "Memory.c"
	ST(0) = sv_newmortal();
	if (RETVAL)
	    sv_setref_pv(ST(0), "Handle", (void*)RETVAL);
	else
	    gMacPerl_OSErr = MemError();
    }
    XSRETURN(1);
}

XS(XS_Handle_size)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Handle::size(hand)");
    {
	Handle	hand;
	long	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    hand = INT2PTR(Handle,tmp);
	}
	else
	    croak("hand is not of type Handle");
#line 114 "Memory.xs"
	RETVAL = GetHandleSize(hand);
#line 129 "Memory.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Handle_append)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: Handle::append(hand, data)");
    {
	Handle	hand;
	SV *	data = ST(1);
	Boolean	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    hand = INT2PTR(Handle,tmp);
	}
	else
	    croak("hand is not of type Handle");
#line 133 "Memory.xs"
	{
		STRLEN	len;
		Ptr		ptr	=	SvPV(data, len);
		RETVAL = !PtrAndHand(ptr, hand, len);
	}
#line 158 "Memory.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Handle_set)
{
    dXSARGS;
    if (items < 1 || items > 4)
	Perl_croak(aTHX_ "Usage: Handle::set(hand, offset=0, length=-1, data=0)");
    {
	Handle	hand;
	long	offset;
	long	length;
	SV *	data;
	Boolean	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    hand = INT2PTR(Handle,tmp);
	}
	else
	    croak("hand is not of type Handle");

	if (items < 2)
	    offset = 0;
	else {
	    offset = (long)SvIV(ST(1));
	}

	if (items < 3)
	    length = -1;
	else {
	    length = (long)SvIV(ST(2));
	}

	if (items < 4)
	    data = 0;
	else {
	    data = ST(3);
	}
#line 169 "Memory.xs"
	{
		STRLEN	len;
		Ptr		ptr;
		if (data)
			ptr =	SvPV(data, len);
		else {
			len = 0;
			ptr = (char *) -1;
		}
		RETVAL = 0 <= Munger(hand, offset, nil, length, ptr, len);
	}
#line 213 "Memory.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Handle_get)
{
    dXSARGS;
    if (items < 1 || items > 3)
	Perl_croak(aTHX_ "Usage: Handle::get(hand, offset=0, length=-1)");
    {
	Handle	hand;
	long	offset;
	long	length;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    hand = INT2PTR(Handle,tmp);
	}
	else
	    croak("hand is not of type Handle");

	if (items < 2)
	    offset = 0;
	else {
	    offset = (long)SvIV(ST(1));
	}

	if (items < 3)
	    length = -1;
	else {
	    length = (long)SvIV(ST(2));
	}
#line 203 "Memory.xs"
	{
		char state = HGetState(hand);
		HLock(hand);
		if (GetHandleSize(hand) > 0) {
			if (length < 0)
				length = GetHandleSize(hand) - offset;
			RETVAL = newSVpv(*hand+offset, length);
			HSetState(hand, state);
		} else {
		    XSRETURN_UNDEF;
		}
	}
#line 261 "Memory.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_Handle_address)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Handle::address(hand)");
    {
	Handle	hand;
	RawPtr	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    hand = INT2PTR(Handle,tmp);
	}
	else
	    croak("hand is not of type Handle");
#line 228 "Memory.xs"
	RETVAL = *hand;
#line 286 "Memory.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Handle_state)
{
    dXSARGS;
    if (items < 1 || items > 2)
	Perl_croak(aTHX_ "Usage: Handle::state(hand, state=0)");
    {
	Handle	hand;
	char	state;
	char	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    hand = INT2PTR(Handle,tmp);
	}
	else
	    croak("hand is not of type Handle");

	if (items < 2)
	    state = 0;
	else {
	    state = (char)*SvPV(ST(1),PL_na);
	}
#line 254 "Memory.xs"
	if (items == 1)
		RETVAL = HGetState(hand);
	else {
		HSetState(hand, state);
		RETVAL = 1;
	}
#line 322 "Memory.c"
	XSprePUSH; PUSHp((char *)&RETVAL, 1);
    }
    XSRETURN(1);
}

XS(XS_Handle_dispose)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Handle::dispose(hand)");
    {
	Handle	hand;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    hand = INT2PTR(Handle,tmp);
	}
	else
	    croak("hand is not of type Handle");
#line 289 "Memory.xs"
	DisposeHandle(hand);
#line 344 "Memory.c"
#line 291 "Memory.xs"
	MemErrorReturn
#line 347 "Memory.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Ptr_new)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: Ptr::new(package, len)");
    {
	SV *	package = ST(0);
	long	len = (long)SvIV(ST(1));
	PtrRet	RETVAL;
#line 313 "Memory.xs"
	RETVAL = NewPtr(len);
#line 363 "Memory.c"
	ST(0) = sv_newmortal();
	if (RETVAL)
	    sv_setref_pv(ST(0), "Ptr", (void*)RETVAL);
	else
	    gMacPerl_OSErr = MemError();
    }
    XSRETURN(1);
}

XS(XS_Ptr_size)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Ptr::size(ptr)");
    {
	Ptr	ptr;
	long	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Ptr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ptr = INT2PTR(Ptr,tmp);
	}
	else
	    croak("ptr is not of type Ptr");
#line 329 "Memory.xs"
	RETVAL = GetPtrSize(ptr);
#line 391 "Memory.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Ptr_set)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: Ptr::set(ptr, offset, data)");
    {
	Ptr	ptr;
	long	offset = (long)SvIV(ST(1));
	SV *	data = ST(2);
	Boolean	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Ptr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ptr = INT2PTR(Ptr,tmp);
	}
	else
	    croak("ptr is not of type Ptr");
#line 342 "Memory.xs"
	{
		STRLEN	len;
		Ptr		p;
		p =	SvPV(data, len);
		BlockMove(p, ptr+offset, len);
		RETVAL = 1;
	}
#line 423 "Memory.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Ptr_get)
{
    dXSARGS;
    if (items < 1 || items > 3)
	Perl_croak(aTHX_ "Usage: Ptr::get(ptr, offset=0, length=-1)");
    {
	Ptr	ptr;
	long	offset;
	long	length;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "Ptr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ptr = INT2PTR(Ptr,tmp);
	}
	else
	    croak("ptr is not of type Ptr");

	if (items < 2)
	    offset = 0;
	else {
	    offset = (long)SvIV(ST(1));
	}

	if (items < 3)
	    length = -1;
	else {
	    length = (long)SvIV(ST(2));
	}
#line 372 "Memory.xs"
	{
		if (length < 0)
			length = GetPtrSize(ptr) - offset;
		RETVAL = newSVpv(ptr+offset, length);
	}
#line 464 "Memory.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_Ptr_address)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Ptr::address(ptr)");
    {
	Ptr	ptr;
	RawPtr	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Ptr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ptr = INT2PTR(Ptr,tmp);
	}
	else
	    croak("ptr is not of type Ptr");
#line 390 "Memory.xs"
	RETVAL = ptr;
#line 489 "Memory.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Ptr_dispose)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Ptr::dispose(ptr)");
    {
	Ptr	ptr;

	if (sv_derived_from(ST(0), "Ptr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ptr = INT2PTR(Ptr,tmp);
	}
	else
	    croak("ptr is not of type Ptr");
#line 406 "Memory.xs"
	DisposePtr(ptr);
#line 511 "Memory.c"
#line 408 "Memory.xs"
	MemErrorReturn
#line 514 "Memory.c"
    }
    XSRETURN_EMPTY;
}

#ifndef MACOS_TRADITIONAL
#define XSubPPtmpAAAA 1

XS(XS_Mac__Memory_GetApplLimit)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::GetApplLimit()");
    {
	RawPtr	RETVAL;
	dXSTARG;
#line 429 "Memory.xs"
	croak("Usage: Mac::Memory::GetApplLimit unsupported in Carbon");
#line 532 "Memory.c"
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAB 1

XS(XS_Mac__Memory_GetApplLimit)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::GetApplLimit()");
    {
	RawPtr	RETVAL;
	dXSTARG;

	RETVAL = GetApplLimit();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif
XS(XS_Mac__Memory_TopMem)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::TopMem()");
    {
	RawPtr	RETVAL;
	dXSTARG;

	RETVAL = TopMem();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Mac__Memory_NewHandle)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::NewHandle(byteCount)");
    {
	long	byteCount = (long)SvIV(ST(0));
	HandleRet	RETVAL;

	RETVAL = NewHandle(byteCount);
	ST(0) = sv_newmortal();
	if (RETVAL)
	    sv_setref_pv(ST(0), "Handle", (void*)RETVAL);
	else
	    gMacPerl_OSErr = MemError();
    }
    XSRETURN(1);
}

#ifndef MACOS_TRADITIONAL
#define XSubPPtmpAAAC 1

XS(XS_Mac__Memory_NewHandleSys)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::NewHandleSys(byteCount)");
    {
	long	byteCount = (long)SvIV(ST(0));
	HandleRet	RETVAL;
#line 478 "Memory.xs"
	croak("Usage: Mac::Memory::NewHandleSys unsupported in Carbon");
#line 603 "Memory.c"
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAD 1

XS(XS_Mac__Memory_NewHandleSys)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::NewHandleSys(byteCount)");
    {
	long	byteCount = (long)SvIV(ST(0));
	HandleRet	RETVAL;

	RETVAL = NewHandleSys(byteCount);
	ST(0) = sv_newmortal();
	if (RETVAL)
	    sv_setref_pv(ST(0), "Handle", (void*)RETVAL);
	else
	    gMacPerl_OSErr = MemError();
    }
    XSRETURN(1);
}

#endif
XS(XS_Mac__Memory_NewHandleClear)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::NewHandleClear(byteCount)");
    {
	long	byteCount = (long)SvIV(ST(0));
	HandleRet	RETVAL;

	RETVAL = NewHandleClear(byteCount);
	ST(0) = sv_newmortal();
	if (RETVAL)
	    sv_setref_pv(ST(0), "Handle", (void*)RETVAL);
	else
	    gMacPerl_OSErr = MemError();
    }
    XSRETURN(1);
}

#ifndef MACOS_TRADITIONAL
#define XSubPPtmpAAAE 1

XS(XS_Mac__Memory_NewHandleSysClear)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::NewHandleSysClear(byteCount)");
    {
	long	byteCount = (long)SvIV(ST(0));
	HandleRet	RETVAL;
#line 498 "Memory.xs"
	croak("Usage: Mac::Memory::NewHandleSysClear unsupported in Carbon");
#line 663 "Memory.c"
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAF 1

XS(XS_Mac__Memory_NewHandleSysClear)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::NewHandleSysClear(byteCount)");
    {
	long	byteCount = (long)SvIV(ST(0));
	HandleRet	RETVAL;

	RETVAL = NewHandleSysClear(byteCount);
	ST(0) = sv_newmortal();
	if (RETVAL)
	    sv_setref_pv(ST(0), "Handle", (void*)RETVAL);
	else
	    gMacPerl_OSErr = MemError();
    }
    XSRETURN(1);
}

#endif
XS(XS_Mac__Memory_NewPtr)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::NewPtr(byteCount)");
    {
	long	byteCount = (long)SvIV(ST(0));
	PtrRet	RETVAL;

	RETVAL = NewPtr(byteCount);
	ST(0) = sv_newmortal();
	if (RETVAL)
	    sv_setref_pv(ST(0), "Ptr", (void*)RETVAL);
	else
	    gMacPerl_OSErr = MemError();
#line 528 "Memory.xs"
	gMacPerl_OSErr = MemError();
#line 708 "Memory.c"
    }
    XSRETURN(1);
}

#ifndef MACOS_TRADITIONAL
#define XSubPPtmpAAAG 1

XS(XS_Mac__Memory_NewPtrSys)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::NewPtrSys(byteCount)");
    {
	long	byteCount = (long)SvIV(ST(0));
	PtrRet	RETVAL;
#line 536 "Memory.xs"
	croak("Usage: Mac::Memory::NewPtrSys unsupported in Carbon");
#line 726 "Memory.c"
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAH 1

XS(XS_Mac__Memory_NewPtrSys)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::NewPtrSys(byteCount)");
    {
	long	byteCount = (long)SvIV(ST(0));
	PtrRet	RETVAL;

	RETVAL = NewPtrSys(byteCount);
	ST(0) = sv_newmortal();
	if (RETVAL)
	    sv_setref_pv(ST(0), "Ptr", (void*)RETVAL);
	else
	    gMacPerl_OSErr = MemError();
#line 544 "Memory.xs"
	gMacPerl_OSErr = MemError();
#line 751 "Memory.c"
    }
    XSRETURN(1);
}

#endif
XS(XS_Mac__Memory_NewPtrClear)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::NewPtrClear(byteCount)");
    {
	long	byteCount = (long)SvIV(ST(0));
	PtrRet	RETVAL;

	RETVAL = NewPtrClear(byteCount);
	ST(0) = sv_newmortal();
	if (RETVAL)
	    sv_setref_pv(ST(0), "Ptr", (void*)RETVAL);
	else
	    gMacPerl_OSErr = MemError();
#line 552 "Memory.xs"
	gMacPerl_OSErr = MemError();
#line 774 "Memory.c"
    }
    XSRETURN(1);
}

#ifndef MACOS_TRADITIONAL
#define XSubPPtmpAAAI 1

XS(XS_Mac__Memory_NewPtrSysClear)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::NewPtrSysClear(byteCount)");
    {
	long	byteCount = (long)SvIV(ST(0));
	PtrRet	RETVAL;
#line 560 "Memory.xs"
	croak("Usage: Mac::Memory::NewPtrSysClear unsupported in Carbon");
#line 792 "Memory.c"
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAJ 1

XS(XS_Mac__Memory_NewPtrSysClear)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::NewPtrSysClear(byteCount)");
    {
	long	byteCount = (long)SvIV(ST(0));
	PtrRet	RETVAL;

	RETVAL = NewPtrSysClear(byteCount);
	ST(0) = sv_newmortal();
	if (RETVAL)
	    sv_setref_pv(ST(0), "Ptr", (void*)RETVAL);
	else
	    gMacPerl_OSErr = MemError();
#line 568 "Memory.xs"
	gMacPerl_OSErr = MemError();
#line 817 "Memory.c"
    }
    XSRETURN(1);
}

#endif
XS(XS_Mac__Memory_MaxBlock)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::MaxBlock()");
    {
	long	RETVAL;
	dXSTARG;

	RETVAL = MaxBlock();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifndef MACOS_TRADITIONAL
#define XSubPPtmpAAAK 1

XS(XS_Mac__Memory_MaxBlockSys)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::MaxBlockSys()");
    {
	long	RETVAL;
	dXSTARG;
#line 592 "Memory.xs"
	croak("Usage: Mac::Memory::MaxBlockSys unsupported in Carbon");
#line 851 "Memory.c"
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAL 1

XS(XS_Mac__Memory_MaxBlockSys)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::MaxBlockSys()");
    {
	long	RETVAL;
	dXSTARG;

	RETVAL = MaxBlockSys();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif
XS(XS_Mac__Memory_StackSpace)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::StackSpace()");
    {
	long	RETVAL;
	dXSTARG;

	RETVAL = StackSpace();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Mac__Memory_NewEmptyHandle)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::NewEmptyHandle()");
    {
	HandleRet	RETVAL;

	RETVAL = NewEmptyHandle();
	ST(0) = sv_newmortal();
	if (RETVAL)
	    sv_setref_pv(ST(0), "Handle", (void*)RETVAL);
	else
	    gMacPerl_OSErr = MemError();
    }
    XSRETURN(1);
}

#ifndef MACOS_TRADITIONAL
#define XSubPPtmpAAAM 1

XS(XS_Mac__Memory_NewEmptyHandleSys)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::NewEmptyHandleSys()");
    {
	HandleRet	RETVAL;
#line 633 "Memory.xs"
	croak("Usage: Mac::Memory::NewEmptyHandleSys unsupported in Carbon");
#line 920 "Memory.c"
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAN 1

XS(XS_Mac__Memory_NewEmptyHandleSys)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::NewEmptyHandleSys()");
    {
	HandleRet	RETVAL;

	RETVAL = NewEmptyHandleSys();
	ST(0) = sv_newmortal();
	if (RETVAL)
	    sv_setref_pv(ST(0), "Handle", (void*)RETVAL);
	else
	    gMacPerl_OSErr = MemError();
    }
    XSRETURN(1);
}

#endif
XS(XS_Mac__Memory_HLock)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::HLock(h)");
    {
	Handle	h;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    h = INT2PTR(Handle,tmp);
	}
	else
	    croak("h is not of type Handle");

	HLock(h);
#line 655 "Memory.xs"
	MemErrorReturn
#line 965 "Memory.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_HUnlock)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::HUnlock(h)");
    {
	Handle	h;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    h = INT2PTR(Handle,tmp);
	}
	else
	    croak("h is not of type Handle");

	HUnlock(h);
#line 667 "Memory.xs"
	MemErrorReturn
#line 988 "Memory.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_HPurge)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::HPurge(h)");
    {
	Handle	h;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    h = INT2PTR(Handle,tmp);
	}
	else
	    croak("h is not of type Handle");

	HPurge(h);
#line 680 "Memory.xs"
	MemErrorReturn
#line 1011 "Memory.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_HNoPurge)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::HNoPurge(h)");
    {
	Handle	h;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    h = INT2PTR(Handle,tmp);
	}
	else
	    croak("h is not of type Handle");

	HNoPurge(h);
#line 692 "Memory.xs"
	MemErrorReturn
#line 1034 "Memory.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_HLockHi)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::HLockHi(h)");
    {
	Handle	h;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    h = INT2PTR(Handle,tmp);
	}
	else
	    croak("h is not of type Handle");

	HLockHi(h);
#line 706 "Memory.xs"
	MemErrorReturn
#line 1057 "Memory.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_TempNewHandle)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::TempNewHandle(logicalSize)");
    {
	long	logicalSize = (long)SvIV(ST(0));
	Handle	RETVAL;
#line 720 "Memory.xs"
	{
		OSErr myErr;

		RETVAL = TempNewHandle(logicalSize, &myErr);
		gMacPerl_OSErr = myErr;
		if (gMacPerl_OSErr) {
			XSRETURN_UNDEF;
		}
	}
#line 1080 "Memory.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "Handle", (void*)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Mac__Memory_TempMaxMem)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::TempMaxMem()");
    {
	long	RETVAL;
	dXSTARG;
#line 744 "Memory.xs"
	{
		long	grow;
		RETVAL = TempMaxMem(&grow);
	}
#line 1100 "Memory.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Mac__Memory_TempFreeMem)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::TempFreeMem()");
    {
	long	RETVAL;
	dXSTARG;

	RETVAL = TempFreeMem();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Mac__Memory_CompactMem)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::CompactMem(cbNeeded)");
    {
	long	cbNeeded = (long)SvIV(ST(0));
	long	RETVAL;
	dXSTARG;

	RETVAL = CompactMem(cbNeeded);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifndef MACOS_TRADITIONAL
#define XSubPPtmpAAAO 1

XS(XS_Mac__Memory_CompactMemSys)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::CompactMemSys(cbNeeded)");
    {
	long	cbNeeded = (long)SvIV(ST(0));
	long	RETVAL;
	dXSTARG;
#line 794 "Memory.xs"
	croak("Usage: Mac::Memory::CompactMemSys unsupported in Carbon");
#line 1151 "Memory.c"
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAP 1

XS(XS_Mac__Memory_CompactMemSys)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::CompactMemSys(cbNeeded)");
    {
	long	cbNeeded = (long)SvIV(ST(0));
	long	RETVAL;
	dXSTARG;

	RETVAL = CompactMemSys(cbNeeded);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif
XS(XS_Mac__Memory_PurgeMem)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::PurgeMem(cbNeeded)");
    {
	long	cbNeeded = (long)SvIV(ST(0));

	PurgeMem(cbNeeded);
    }
    XSRETURN_EMPTY;
}

#ifndef MACOS_TRADITIONAL
#define XSubPPtmpAAAQ 1

XS(XS_Mac__Memory_PurgeMemSys)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::PurgeMemSys(cbNeeded)");
    {
	long	cbNeeded = (long)SvIV(ST(0));
#line 833 "Memory.xs"
	croak("Usage: Mac::Memory::PurgeMemSys unsupported in Carbon");
#line 1201 "Memory.c"
    }
    XSRETURN_EMPTY;
}

#else
#define XSubPPtmpAAAR 1

XS(XS_Mac__Memory_PurgeMemSys)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::PurgeMemSys(cbNeeded)");
    {
	long	cbNeeded = (long)SvIV(ST(0));

	PurgeMemSys(cbNeeded);
    }
    XSRETURN_EMPTY;
}

#endif
XS(XS_Mac__Memory_FreeMem)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::FreeMem()");
    {
	long	RETVAL;
	dXSTARG;

	RETVAL = FreeMem();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifndef MACOS_TRADITIONAL
#define XSubPPtmpAAAS 1

XS(XS_Mac__Memory_FreeMemSys)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::FreeMemSys()");
    {
	long	RETVAL;
	dXSTARG;
#line 863 "Memory.xs"
	croak("Usage: Mac::Memory::FreeMemSys unsupported in Carbon");
#line 1251 "Memory.c"
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAT 1

XS(XS_Mac__Memory_FreeMemSys)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::FreeMemSys()");
    {
	long	RETVAL;
	dXSTARG;

	RETVAL = FreeMemSys();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif
XS(XS_Mac__Memory_ReserveMem)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::ReserveMem(cbNeeded)");
    {
	long	cbNeeded = (long)SvIV(ST(0));

	ReserveMem(cbNeeded);
    }
    XSRETURN_EMPTY;
}

#ifndef MACOS_TRADITIONAL
#define XSubPPtmpAAAU 1

XS(XS_Mac__Memory_ReserveMemSys)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::ReserveMemSys(cbNeeded)");
    {
	long	cbNeeded = (long)SvIV(ST(0));
#line 896 "Memory.xs"
	croak("Usage: Mac::Memory::ReserveMemSys unsupported in Carbon");
#line 1300 "Memory.c"
    }
    XSRETURN_EMPTY;
}

#else
#define XSubPPtmpAAAV 1

XS(XS_Mac__Memory_ReserveMemSys)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::ReserveMemSys(cbNeeded)");
    {
	long	cbNeeded = (long)SvIV(ST(0));

	ReserveMemSys(cbNeeded);
    }
    XSRETURN_EMPTY;
}

#endif
XS(XS_Mac__Memory_MaxMem)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::MaxMem()");
    SP -= items;
    {
#line 924 "Memory.xs"
	{
		long	grow;

	++sp;
	*sp = sv_newmortal();
	sv_setiv(*sp, (IV)(MaxMem(&grow)));
		if (GIMME == G_ARRAY) {
	++sp;
	*sp = sv_newmortal();
	sv_setiv(*sp, (IV)(grow));
		}
	}
#line 1342 "Memory.c"
	PUTBACK;
	return;
    }
}

XS(XS_Mac__Memory_MaxMemSys)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::MaxMemSys()");
    SP -= items;
    {
#line 936 "Memory.xs"
	{
#ifndef MACOS_TRADITIONAL
	croak("Usage: Mac::Memory::MaxMemSys unsupported in Carbon");
#else
		long	grow;

	++sp;
	*sp = sv_newmortal();
	sv_setiv(*sp, (IV)(MaxMemSys(&grow)));
		if (GIMME == G_ARRAY) {
	++sp;
	*sp = sv_newmortal();
	sv_setiv(*sp, (IV)(grow));
		}
#endif
	}
#line 1372 "Memory.c"
	PUTBACK;
	return;
    }
}

XS(XS_Mac__Memory_MoveHHi)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::MoveHHi(h)");
    {
	Handle	h;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    h = INT2PTR(Handle,tmp);
	}
	else
	    croak("h is not of type Handle");

	MoveHHi(h);
#line 961 "Memory.xs"
	MemErrorReturn
#line 1396 "Memory.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_DisposePtr)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::DisposePtr(p)");
    {
	Ptr	p;

	if (sv_derived_from(ST(0), "Ptr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    p = INT2PTR(Ptr,tmp);
	}
	else
	    croak("p is not of type Ptr");

	DisposePtr(p);
#line 973 "Memory.xs"
	MemErrorReturn
#line 1419 "Memory.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_GetPtrSize)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::GetPtrSize(p)");
    {
	Ptr	p;
	long	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Ptr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    p = INT2PTR(Ptr,tmp);
	}
	else
	    croak("p is not of type Ptr");

	RETVAL = GetPtrSize(p);
	XSprePUSH; PUSHi((IV)RETVAL);
#line 986 "Memory.xs"
	gMacPerl_OSErr = MemError();
#line 1445 "Memory.c"
    }
    XSRETURN(1);
}

XS(XS_Mac__Memory_SetPtrSize)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: Mac::Memory::SetPtrSize(p, newSize)");
    {
	Ptr	p;
	long	newSize = (long)SvIV(ST(1));

	if (sv_derived_from(ST(0), "Ptr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    p = INT2PTR(Ptr,tmp);
	}
	else
	    croak("p is not of type Ptr");

	SetPtrSize(p, newSize);
#line 1002 "Memory.xs"
	MemErrorReturn
#line 1469 "Memory.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_DisposeHandle)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::DisposeHandle(h)");
    {
	Handle	h;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    h = INT2PTR(Handle,tmp);
	}
	else
	    croak("h is not of type Handle");

	DisposeHandle(h);
#line 1015 "Memory.xs"
	MemErrorReturn
#line 1492 "Memory.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_SetHandleSize)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: Mac::Memory::SetHandleSize(h, newSize)");
    {
	Handle	h;
	long	newSize = (long)SvIV(ST(1));

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    h = INT2PTR(Handle,tmp);
	}
	else
	    croak("h is not of type Handle");

	SetHandleSize(h, newSize);
#line 1031 "Memory.xs"
	MemErrorReturn
#line 1516 "Memory.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_GetHandleSize)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::GetHandleSize(h)");
    {
	Handle	h;
	long	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    h = INT2PTR(Handle,tmp);
	}
	else
	    croak("h is not of type Handle");

	RETVAL = GetHandleSize(h);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Mac__Memory_ReallocateHandle)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: Mac::Memory::ReallocateHandle(h, byteCount)");
    {
	Handle	h;
	long	byteCount = (long)SvIV(ST(1));

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    h = INT2PTR(Handle,tmp);
	}
	else
	    croak("h is not of type Handle");

	ReallocateHandle(h, byteCount);
#line 1058 "Memory.xs"
	MemErrorReturn
#line 1563 "Memory.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_EmptyHandle)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::EmptyHandle(h)");
    {
	Handle	h;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    h = INT2PTR(Handle,tmp);
	}
	else
	    croak("h is not of type Handle");

	EmptyHandle(h);
#line 1071 "Memory.xs"
	MemErrorReturn
#line 1586 "Memory.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_MoreMasters)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::MoreMasters()");
    {

	MoreMasters();
#line 1085 "Memory.xs"
	MemErrorReturn
#line 1601 "Memory.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_BlockMove)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: Mac::Memory::BlockMove(srcPtr, destPtr, byteCount)");
    {
	RawPtr	srcPtr = (RawPtr)SvIV(ST(0));
	RawPtr	destPtr = (RawPtr)SvIV(ST(1));
	long	byteCount = (long)SvIV(ST(2));

	BlockMove(srcPtr, destPtr, byteCount);
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_BlockMoveData)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: Mac::Memory::BlockMoveData(srcPtr, destPtr, byteCount)");
    {
	RawPtr	srcPtr = (RawPtr)SvIV(ST(0));
	RawPtr	destPtr = (RawPtr)SvIV(ST(1));
	long	byteCount = (long)SvIV(ST(2));

	BlockMoveData(srcPtr, destPtr, byteCount);
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_PurgeSpace)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Mac::Memory::PurgeSpace()");
    SP -= items;
    {
#line 1120 "Memory.xs"
	{
		long	total;
		long	contig;

		PurgeSpace(&total, &contig);
		EXTEND(sp, 2);
		PUSHs(sv_2mortal(newSViv(total)));
		PUSHs(sv_2mortal(newSViv(contig)));
	}	
#line 1653 "Memory.c"
	PUTBACK;
	return;
    }
}

XS(XS_Mac__Memory_HGetState)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::HGetState(h)");
    {
	Handle	h;
	char	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    h = INT2PTR(Handle,tmp);
	}
	else
	    croak("h is not of type Handle");

	RETVAL = HGetState(h);
	XSprePUSH; PUSHp((char *)&RETVAL, 1);
#line 1141 "Memory.xs"
	if (gMacPerl_OSErr = MemError())
		RETVAL = 0;
#line 1681 "Memory.c"
    }
    XSRETURN(1);
}

XS(XS_Mac__Memory_HSetState)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: Mac::Memory::HSetState(h, flags)");
    {
	Handle	h;
	char	flags = (char)*SvPV(ST(1),PL_na);

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    h = INT2PTR(Handle,tmp);
	}
	else
	    croak("h is not of type Handle");

	HSetState(h, flags);
#line 1155 "Memory.xs"
	MemErrorReturn
#line 1705 "Memory.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Mac__Memory_HandToHand)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Mac::Memory::HandToHand(theHndl)");
    {
	Handle	theHndl;
	Handle	RETVAL;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    theHndl = INT2PTR(Handle,tmp);
	}
	else
	    croak("theHndl is not of type Handle");
#line 1169 "Memory.xs"
	if (gMacPerl_OSErr = HandToHand(&theHndl)) {
		XSRETURN_UNDEF;
	} else {
		RETVAL = theHndl;
	}
#line 1731 "Memory.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "Handle", (void*)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Mac__Memory_PtrToHand)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: Mac::Memory::PtrToHand(srcPtr, size)");
    {
	Ptr	srcPtr;
	long	size = (long)SvIV(ST(1));
	Handle	RETVAL;

	if (sv_derived_from(ST(0), "Ptr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    srcPtr = INT2PTR(Ptr,tmp);
	}
	else
	    croak("srcPtr is not of type Ptr");
#line 1191 "Memory.xs"
	if (gMacPerl_OSErr = PtrToHand(srcPtr, &RETVAL, size)) {
		XSRETURN_UNDEF;
	}
#line 1758 "Memory.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "Handle", (void*)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Mac__Memory_PtrToXHand)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: Mac::Memory::PtrToXHand(srcPtr, dstHndl, size)");
    {
	Ptr	srcPtr;
	Handle	dstHndl;
	long	size = (long)SvIV(ST(2));
	MacOSRet	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Ptr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    srcPtr = INT2PTR(Ptr,tmp);
	}
	else
	    croak("srcPtr is not of type Ptr");

	if (sv_derived_from(ST(1), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    dstHndl = INT2PTR(Handle,tmp);
	}
	else
	    croak("dstHndl is not of type Handle");

	RETVAL = PtrToXHand(srcPtr, dstHndl, size);
	XSprePUSH; PUSHi((IV)!(gMacPerl_OSErr = (short)(RETVAL)));
    }
    XSRETURN(1);
}

XS(XS_Mac__Memory_HandAndHand)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: Mac::Memory::HandAndHand(hand1, hand2)");
    {
	Handle	hand1;
	Handle	hand2;
	MacOSRet	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    hand1 = INT2PTR(Handle,tmp);
	}
	else
	    croak("hand1 is not of type Handle");

	if (sv_derived_from(ST(1), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    hand2 = INT2PTR(Handle,tmp);
	}
	else
	    croak("hand2 is not of type Handle");
#line 1226 "Memory.xs"
	{
		char	state = HGetState(hand1);
		HLock(hand1);
		RETVAL = HandAndHand(hand1, hand2);
		HSetState(hand1, state);
	}
#line 1828 "Memory.c"
	XSprePUSH; PUSHi((IV)!(gMacPerl_OSErr = (short)(RETVAL)));
    }
    XSRETURN(1);
}

XS(XS_Mac__Memory_PtrAndHand)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: Mac::Memory::PtrAndHand(ptr1, hand2, size)");
    {
	Ptr	ptr1;
	Handle	hand2;
	long	size = (long)SvIV(ST(2));
	MacOSRet	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Ptr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ptr1 = INT2PTR(Ptr,tmp);
	}
	else
	    croak("ptr1 is not of type Ptr");

	if (sv_derived_from(ST(1), "Handle")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    hand2 = INT2PTR(Handle,tmp);
	}
	else
	    croak("hand2 is not of type Handle");

	RETVAL = PtrAndHand(ptr1, hand2, size);
	XSprePUSH; PUSHi((IV)!(gMacPerl_OSErr = (short)(RETVAL)));
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_Mac__Memory)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXS("Handle::new", XS_Handle_new, file);
        newXS("Handle::size", XS_Handle_size, file);
        newXS("Handle::append", XS_Handle_append, file);
        newXS("Handle::set", XS_Handle_set, file);
        newXS("Handle::get", XS_Handle_get, file);
        newXS("Handle::address", XS_Handle_address, file);
        newXS("Handle::state", XS_Handle_state, file);
        newXS("Handle::dispose", XS_Handle_dispose, file);
        newXS("Ptr::new", XS_Ptr_new, file);
        newXS("Ptr::size", XS_Ptr_size, file);
        newXS("Ptr::set", XS_Ptr_set, file);
        newXS("Ptr::get", XS_Ptr_get, file);
        newXS("Ptr::address", XS_Ptr_address, file);
        newXS("Ptr::dispose", XS_Ptr_dispose, file);
#if XSubPPtmpAAAA
        newXS("Mac::Memory::GetApplLimit", XS_Mac__Memory_GetApplLimit, file);
#endif
#if XSubPPtmpAAAB
        newXS("Mac::Memory::GetApplLimit", XS_Mac__Memory_GetApplLimit, file);
#endif
        newXS("Mac::Memory::TopMem", XS_Mac__Memory_TopMem, file);
        newXS("Mac::Memory::NewHandle", XS_Mac__Memory_NewHandle, file);
#if XSubPPtmpAAAC
        newXS("Mac::Memory::NewHandleSys", XS_Mac__Memory_NewHandleSys, file);
#endif
#if XSubPPtmpAAAD
        newXS("Mac::Memory::NewHandleSys", XS_Mac__Memory_NewHandleSys, file);
#endif
        newXS("Mac::Memory::NewHandleClear", XS_Mac__Memory_NewHandleClear, file);
#if XSubPPtmpAAAE
        newXS("Mac::Memory::NewHandleSysClear", XS_Mac__Memory_NewHandleSysClear, file);
#endif
#if XSubPPtmpAAAF
        newXS("Mac::Memory::NewHandleSysClear", XS_Mac__Memory_NewHandleSysClear, file);
#endif
        newXS("Mac::Memory::NewPtr", XS_Mac__Memory_NewPtr, file);
#if XSubPPtmpAAAG
        newXS("Mac::Memory::NewPtrSys", XS_Mac__Memory_NewPtrSys, file);
#endif
#if XSubPPtmpAAAH
        newXS("Mac::Memory::NewPtrSys", XS_Mac__Memory_NewPtrSys, file);
#endif
        newXS("Mac::Memory::NewPtrClear", XS_Mac__Memory_NewPtrClear, file);
#if XSubPPtmpAAAI
        newXS("Mac::Memory::NewPtrSysClear", XS_Mac__Memory_NewPtrSysClear, file);
#endif
#if XSubPPtmpAAAJ
        newXS("Mac::Memory::NewPtrSysClear", XS_Mac__Memory_NewPtrSysClear, file);
#endif
        newXS("Mac::Memory::MaxBlock", XS_Mac__Memory_MaxBlock, file);
#if XSubPPtmpAAAK
        newXS("Mac::Memory::MaxBlockSys", XS_Mac__Memory_MaxBlockSys, file);
#endif
#if XSubPPtmpAAAL
        newXS("Mac::Memory::MaxBlockSys", XS_Mac__Memory_MaxBlockSys, file);
#endif
        newXS("Mac::Memory::StackSpace", XS_Mac__Memory_StackSpace, file);
        newXS("Mac::Memory::NewEmptyHandle", XS_Mac__Memory_NewEmptyHandle, file);
#if XSubPPtmpAAAM
        newXS("Mac::Memory::NewEmptyHandleSys", XS_Mac__Memory_NewEmptyHandleSys, file);
#endif
#if XSubPPtmpAAAN
        newXS("Mac::Memory::NewEmptyHandleSys", XS_Mac__Memory_NewEmptyHandleSys, file);
#endif
        newXS("Mac::Memory::HLock", XS_Mac__Memory_HLock, file);
        newXS("Mac::Memory::HUnlock", XS_Mac__Memory_HUnlock, file);
        newXS("Mac::Memory::HPurge", XS_Mac__Memory_HPurge, file);
        newXS("Mac::Memory::HNoPurge", XS_Mac__Memory_HNoPurge, file);
        newXS("Mac::Memory::HLockHi", XS_Mac__Memory_HLockHi, file);
        newXS("Mac::Memory::TempNewHandle", XS_Mac__Memory_TempNewHandle, file);
        newXS("Mac::Memory::TempMaxMem", XS_Mac__Memory_TempMaxMem, file);
        newXS("Mac::Memory::TempFreeMem", XS_Mac__Memory_TempFreeMem, file);
        newXS("Mac::Memory::CompactMem", XS_Mac__Memory_CompactMem, file);
#if XSubPPtmpAAAO
        newXS("Mac::Memory::CompactMemSys", XS_Mac__Memory_CompactMemSys, file);
#endif
#if XSubPPtmpAAAP
        newXS("Mac::Memory::CompactMemSys", XS_Mac__Memory_CompactMemSys, file);
#endif
        newXS("Mac::Memory::PurgeMem", XS_Mac__Memory_PurgeMem, file);
#if XSubPPtmpAAAQ
        newXS("Mac::Memory::PurgeMemSys", XS_Mac__Memory_PurgeMemSys, file);
#endif
#if XSubPPtmpAAAR
        newXS("Mac::Memory::PurgeMemSys", XS_Mac__Memory_PurgeMemSys, file);
#endif
        newXS("Mac::Memory::FreeMem", XS_Mac__Memory_FreeMem, file);
#if XSubPPtmpAAAS
        newXS("Mac::Memory::FreeMemSys", XS_Mac__Memory_FreeMemSys, file);
#endif
#if XSubPPtmpAAAT
        newXS("Mac::Memory::FreeMemSys", XS_Mac__Memory_FreeMemSys, file);
#endif
        newXS("Mac::Memory::ReserveMem", XS_Mac__Memory_ReserveMem, file);
#if XSubPPtmpAAAU
        newXS("Mac::Memory::ReserveMemSys", XS_Mac__Memory_ReserveMemSys, file);
#endif
#if XSubPPtmpAAAV
        newXS("Mac::Memory::ReserveMemSys", XS_Mac__Memory_ReserveMemSys, file);
#endif
        newXS("Mac::Memory::MaxMem", XS_Mac__Memory_MaxMem, file);
        newXS("Mac::Memory::MaxMemSys", XS_Mac__Memory_MaxMemSys, file);
        newXS("Mac::Memory::MoveHHi", XS_Mac__Memory_MoveHHi, file);
        newXS("Mac::Memory::DisposePtr", XS_Mac__Memory_DisposePtr, file);
        newXS("Mac::Memory::GetPtrSize", XS_Mac__Memory_GetPtrSize, file);
        newXS("Mac::Memory::SetPtrSize", XS_Mac__Memory_SetPtrSize, file);
        newXS("Mac::Memory::DisposeHandle", XS_Mac__Memory_DisposeHandle, file);
        newXS("Mac::Memory::SetHandleSize", XS_Mac__Memory_SetHandleSize, file);
        newXS("Mac::Memory::GetHandleSize", XS_Mac__Memory_GetHandleSize, file);
        newXS("Mac::Memory::ReallocateHandle", XS_Mac__Memory_ReallocateHandle, file);
        newXS("Mac::Memory::EmptyHandle", XS_Mac__Memory_EmptyHandle, file);
        newXS("Mac::Memory::MoreMasters", XS_Mac__Memory_MoreMasters, file);
        newXS("Mac::Memory::BlockMove", XS_Mac__Memory_BlockMove, file);
        newXS("Mac::Memory::BlockMoveData", XS_Mac__Memory_BlockMoveData, file);
        newXS("Mac::Memory::PurgeSpace", XS_Mac__Memory_PurgeSpace, file);
        newXS("Mac::Memory::HGetState", XS_Mac__Memory_HGetState, file);
        newXS("Mac::Memory::HSetState", XS_Mac__Memory_HSetState, file);
        newXS("Mac::Memory::HandToHand", XS_Mac__Memory_HandToHand, file);
        newXS("Mac::Memory::PtrToHand", XS_Mac__Memory_PtrToHand, file);
        newXS("Mac::Memory::PtrToXHand", XS_Mac__Memory_PtrToXHand, file);
        newXS("Mac::Memory::HandAndHand", XS_Mac__Memory_HandAndHand, file);
        newXS("Mac::Memory::PtrAndHand", XS_Mac__Memory_PtrAndHand, file);

    /* Initialisation Section */

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif
#if XSubPPtmpAAAF
#endif
#if XSubPPtmpAAAG
#endif
#if XSubPPtmpAAAH
#endif
#if XSubPPtmpAAAI
#endif
#if XSubPPtmpAAAJ
#endif
#if XSubPPtmpAAAK
#endif
#if XSubPPtmpAAAL
#endif
#if XSubPPtmpAAAM
#endif
#if XSubPPtmpAAAN
#endif
#if XSubPPtmpAAAO
#endif
#if XSubPPtmpAAAP
#endif
#if XSubPPtmpAAAQ
#endif
#if XSubPPtmpAAAR
#endif
#if XSubPPtmpAAAS
#endif
#if XSubPPtmpAAAT
#endif
#if XSubPPtmpAAAU
#endif
#if XSubPPtmpAAAV
#endif
#line 2045 "Memory.c"

    /* End of Initialisation Section */

    XSRETURN_YES;
}

