use Test::More tests => 14;
use Number::Phone::Normalize;

my $obj = Number::Phone::Normalize->new(own_prefix => '+49-89');
is($obj->intl('+1 (555)  123     4567'), '+1-555-123 4567');
is($obj->intl('(001-555) 123 4567'), '+1-555-123 4567');
is($obj->intl('00(1-555) 123 4567'), '+1-555-123 4567');
is($obj->intl('(089) 53709493'), '+49-89-53709493');
is($obj->intl('(0800) 12345678'), '+49-800-12345678');
is($obj->intl('53709493'), '+49-89-53709493');
is($obj->intl('8953709493'), '+49-89-8953709493');

$obj = Number::Phone::Normalize->new(own_prefix => '+1 555');
is($obj->intl('+1 (555)  123     4567'), '+1-555-123 4567');
is($obj->intl('(11-1-555) 123 4567'), '+1-555-123 4567');
is($obj->intl('11-1 (555) 123 4567'), '+1-555-123 4567');
is($obj->intl('11 49 (89) 53709493'), '+49-89-53709493');
is($obj->intl('(800) 1234567'), '+1-800-1234567');
is($obj->intl('1 (800) 12345678'), '+1-800-12345678');
is($obj->intl('53709493'), '+1-555-53709493');
