package main;

use 5.026;
use strict;
use warnings;
use utf8;
use Benchmark qw/ cmpthese timethese /;
use Getopt::Long ();
use Array::Shuffle ();
use List::Helpers::XS ();
use List::Util ();

my ($total);
my %opts_rules = ('total|t=i' => \$total);

Getopt::Long::Configure('prefix_pattern=--', 'ignore_case', 'auto_version');
Getopt::Long::GetOptionsFromArray(\@main::ARGV, %opts_rules);

$total //= 250;

printf("Total elements in initial array is %i\n", $total);

my @array = (1 .. $total);
my @array2 = (1 .. $total);
my @array3 = (1 .. $total);
my @array4 = (1 .. $total);

cmpthese timethese(
    1_000_000,
    {
        'Array::Shuffle::shuffle_array' => sub {
            Array::Shuffle::shuffle_array(@array);
            Array::Shuffle::shuffle_array(@array2);
            Array::Shuffle::shuffle_array(@array3);
            Array::Shuffle::shuffle_array(@array4);
        },
        'List::Helpers::XS::shuffle' => sub {
            List::Helpers::XS::shuffle(@array);
            List::Helpers::XS::shuffle(@array2);
            List::Helpers::XS::shuffle(@array3);
            List::Helpers::XS::shuffle(@array4);
        },
        'List::Helpers::XS::shuffle_multi' => sub {
            List::Helpers::XS::shuffle_multi(\@array, \@array2, \@array3, \@array4);
        },
    }
);

=z
cmpthese timethese(
    1_000_000,
    {
        'Array::Shuffle::shuffle_huge_array' => sub {
            my $arr = [@array];
            Array::Shuffle::shuffle_huge_array(@$arr);
        },
        'List::Helpers::XS::shuffle' => sub {
            my $arr = [@array];
            List::Helpers::XS::shuffle(@$arr);
        },
    }
);

printf("\n");

cmpthese timethese(
    1_000_000,
    {
        'Array::Shuffle::shuffle_array' => sub {
            my $arr = [@array];
            Array::Shuffle::shuffle_array(@$arr);
        },
        'List::Helpers::XS::shuffle' => sub {
            my $arr = [@array];
            List::Helpers::XS::shuffle(@$arr);
        },
    }
);

printf("\n");

cmpthese timethese(
    1_000_000,
    {
        'List::Helpers::XS::shuffle' => sub {
            my $arr = [@array];
            List::Helpers::XS::shuffle(@$arr);
        },
        'List::Util::shuffle' => sub {
            my $arr = [@array];
            my @values = List::Util::shuffle(@$arr)
        },
    }
);
=cut

1;
__END__
                                      Rate List::Util::shuffle List::Helpers::XS::shuffle Array::Shuffle::shuffle_array Array::Shuffle::shuffle_huge_array
List::Util::shuffle                 6689/s                  --                       -40%                          -42%                               -42%
List::Helpers::XS::shuffle         11236/s                 68%                         --                           -3%                                -3%
Array::Shuffle::shuffle_array      11534/s                 72%                         3%                            --                                -0%
Array::Shuffle::shuffle_huge_array 11534/s                 72%                         3%                            0%                                 --


                                    Rate Array::Shuffle::shuffle_array List::Helpers::XS::shuffle_multi List::Helpers::XS::shuffle
Array::Shuffle::shuffle_array    58651/s                            --                              -5%                        -8%
List::Helpers::XS::shuffle_multi 61501/s                            5%                               --                        -4%
List::Helpers::XS::shuffle       63857/s                            9%                               4%                         --
