package WWW::B_Rail::Cities::English;

$WWW::B_Rail::Cities::English::VERSION = 0.01;

use Exporter;
@ISA = qw(Exporter);
use strict;
use vars qw(%cities @EXPORT);

@EXPORT = qw(%cities);

%cities = (
"AACHEN-HBF (D)"=>"1003567",
"AALTER"=>"1000008",
"AARSCHOT"=>"1000009",
"AARSELE"=>"1000010",
"ACREN"=>"1000012",
"AEROPORT CDG TGV"=>"1007532",
"AGDE (F)"=>"1007519",
"AIGLE (CH)"=>"1007010",
"AIME-LA-PLAGNE (F)"=>"1007520",
"AISEAU"=>"1000016",
"AIX TGV"=>"1007633",
"AIX-LES-BAINS-LE-RE.(F)"=>"1007522",
"ALBERTVILLE (F)"=>"1007524",
"ALKEN"=>"1000019",
"ALKMAAR (NL)"=>"1003042",
"ALOST"=>"1000006",
"ALOST KERREBROEK"=>"1000104",
"AMAY"=>"1000022",
"AMERSFOORT (NL)"=>"1003027",
"AMPSIN"=>"1000024",
"AMSTERDAM AMSTEL (NL)"=>"1003066",
"AMSTERDAM-C.S. (NL)"=>"1003010",
"ANCONA (I)"=>"1006517",
"ANDENNE"=>"1000025",
"ANGLEUR"=>"1000027",
"ANGOULEME (F)"=>"1007594",
"ANNAPPES (F)"=>"1007690",
"ANNECY (F)"=>"1007526",
"ANS"=>"1000031",
"ANSEREMME"=>"1000034",
"ANTIBES (F)"=>"1007528",
"ANTOING"=>"1000035",
"ANTWERPEN-BERCHEM"=>"1000139",
"ANVERS-CENTRAL"=>"1000037",
"ANVERS-DAM"=>"1000038",
"ANVERS-EST"=>"1000061",
"ANVERS-NOORDERDOKKEN"=>"1000058",
"ANVERS-SUD"=>"1000064",
"ANZEGEM"=>"1000066",
"APPELTERRE"=>"1000067",
"ARCHENNES"=>"1000068",
"ARGELES-SUR-MER (F)"=>"1007840",
"ARLES (F)"=>"1007530",
"ARLON"=>"1000070",
"ARNHEM (NL)"=>"1003050",
"ARONA (I)"=>"1006520",
"ARRAS (F)"=>"1007636",
"ASCQ (F)"=>"1007692",
"ASHFORD (GB)"=>"1008523",
"ASSE"=>"1000074",
"ASSESSE"=>"1000075",
"ATH"=>"1000077",
"ATHUS"=>"1005114",
"AUDENARDE"=>"1000939",
"AUDUN-LE-TICHE (L)"=>"1005038",
"AUGSBURG (D)"=>"1003520",
"AULNOYE AYMERIES (F)"=>"1007694",
"AUVELAIS"=>"1000082",
"AVIGNON (F)"=>"1007534",
"AVIGNON TGV"=>"1007637",
"AYE"=>"1000100",
"AYWAILLE"=>"1000084",
"BAASRODE-ZUID"=>"1000102",
"BAD HOFGASTEIN (AU)"=>"1006004",
"BAD RAGAZ (CH)"=>"1007017",
"BADEN (CH)"=>"1007020",
"BADGASTEIN (AU)"=>"1006006",
"BAISIEUX (F)"=>"1007696",
"BALEGEM-DORP"=>"1000105",
"BALEGEM-ZUID"=>"1000106",
"BALEN"=>"1000107",
"BAMBRUGGE"=>"1000110",
"BANYULS (F)"=>"1007615",
"BARVAUX"=>"1000114",
"BAS-OHA"=>"1000118",
"BASCHARAGE-SANEM (L)"=>"1005026",
"BASEL (CH)"=>"1007022",
"BASSE-WAVRE"=>"1000120",
"BASTOGNE-NORD"=>"1000124",
"BASTOGNE-SUD"=>"1000123",
"BAYONNE (F)"=>"1007535",
"BEAULIEU S/MER (F)"=>"1007536",
"BEAURAING"=>"1000126",
"BEERNEM"=>"1000127",
"BEERSEL"=>"1000128",
"BEGIJNENDIJK"=>"1000132",
"BEIGNEE"=>"1000133",
"BELLEGARDE (F)"=>"1007669",
"BELLEM"=>"1000136",
"BELLINZONA (CH)"=>"1007023",
"BELSELE"=>"1000138",
"BELVAL-REDANGE (L)"=>"1005040",
"BELVAL-USINES (L)"=>"1005042",
"BELVAUX-SOLEUVRE (L)"=>"1005044",
"BERCHEM (ANTWERPEN)"=>"1000139",
"BERCHEM (L)"=>"1005046",
"BERGEN OP ZOOM (NL)"=>"1003056",
"BERINGEN"=>"1000143",
"BERLAAR"=>"1000142",
"BERLIN OBF (D)"=>"1003555",
"BERLIN SPANDAU (D)"=>"1003553",
"BERLIN ZOO (D)"=>"1003523",
"BERN (CH)"=>"1007024",
"BERTRANGE-STRASSEN (L)"=>"1005254",
"BERTRIX"=>"1000146",
"BERZEE"=>"1000147",
"BETTEMBOURG (L)"=>"1005008",
"BETZDORF (L)"=>"1005016",
"BEUZET"=>"1000148",
"BEVEREN"=>"1000151",
"BEX (CH)"=>"1007025",
"BEZIERS (F)"=>"1007820",
"BIARRITZ (F)"=>"1007537",
"BIEL (CH)"=>"1007026",
"BIELEFELD HBF (D)"=>"1003524",
"BIERGES-WALIBI"=>"1000153",
"BIERSET-AWANS"=>"1000155",
"BILZEN"=>"1000157",
"BINCHE"=>"1000158",
"BISCHOFSHOFEN (AU)"=>"1006010",
"BISSEGEM"=>"1000160",
"BLANKENBERGE"=>"1000166",
"BLANMONT"=>"1000167",
"BLATON"=>"1000169",
"BLERET"=>"1000171",
"BOCKSTAEL"=>"1001767",
"BOECHOUT"=>"1000177",
"BOHAIN (F)"=>"1007614",
"BOKRIJK"=>"1000184",
"BOLOGNA CENTRALE (I)"=>"1006522",
"BOMAL"=>"1000185",
"BOOISCHOT"=>"1000187",
"BOOM"=>"1000188",
"BOONDAAL"=>"1000189",
"BOORTMEERBEEK"=>"1000190",
"BORDEAUX-SAINT-JEAN (F)"=>"1007538",
"BORDET"=>"1000191",
"BORNEM"=>"1000192",
"BOSVOORDE"=>"1000183",
"BOURG EN BRESSE (F)"=>"1007671",
"BOURG-SAINT-MAURICE (F)"=>"1007539",
"BOUSSU"=>"1000195",
"BOUWEL"=>"1000199",
"BRACQUEGNIES"=>"1000201",
"BRAINE-L'ALLEUD"=>"1000203",
"BRAINE-LE-COMTE"=>"1000205",
"BREDA (NL)"=>"1003044",
"BREMEN HBF (D)"=>"1003532",
"BRENNERO (I)"=>"1006524",
"BRESCIA (I)"=>"1006504",
"BRESSOUX"=>"1000208",
"BRIANON (F)"=>"1007540",
"BRIG (CH)"=>"1007028",
"BRIVE-LA-GAILLARDE (F)"=>"1007545",
"BRUGELETTE"=>"1000209",
"BRUGES"=>"1000210",
"BRUGES-SINT-PIETERS"=>"1000212",
"BRUGG(AG) (CH)"=>"1007030",
"BRUNICO (I)"=>"1006557",
"BRUSSELS EUROSTAR"=>"1001800",
"BRUXELLES-CENTRAL"=>"1000215",
"BRUXELLES-CHAPELLE"=>"1000217",
"CAHORS (F)"=>"1007541",
"CALLENELLE"=>"1000246",
"CAMBRON-CASTEAU"=>"1000247",
"CAMPIGLIA MARITTI (I)"=>"1006550",
"CANNES (F)"=>"1007542",
"CAPELLEN (L)"=>"1005256",
"CARLSBOURG"=>"1000249",
"CARNIERES"=>"1000250",
"CATTOLICA (I)"=>"1006509",
"CENTS-HAMM (L)"=>"1005024",
"CERBERE (F)"=>"1007543",
"CEROUX-MOUSTY"=>"1000252",
"CHALINDREY (F)"=>"1007546",
"CHAMBERY-CHALLES-L. (F)"=>"1007544",
"CHAPELLE-DIEU"=>"1000255",
"CHAPOIS"=>"1000257",
"CHARLEROI-OUEST"=>"1000258",
"CHARLEROI-SUD"=>"1000259",
"CHASTRE"=>"1000261",
"CHATEAU-DE-SEILLES"=>"1000262",
"CHATELET"=>"1000263",
"CHAUNY (F)"=>"1007898",
"CHENEE"=>"1000266",
"CHIASSO (CH)"=>"1007032",
"CHUR (CH)"=>"1007034",
"CINEY"=>"1000272",
"CIVITAVECCHIA (I)"=>"1006552",
"CLERVAUX (L)"=>"1005002",
"CLUSES (F)"=>"1007548",
"COLLE ISARCO (I)"=>"1006525",
"COLLIOURE (F)"=>"1007610",
"COLMAR (F)"=>"1007550",
"COLMAR-BERG (L)"=>"1005028",
"COMBLAIN-LA-TOUR"=>"1000277",
"COMINES"=>"1000278",
"COMO S. GIOVANNI (I)"=>"1006527",
"COMPIEGNE (F)"=>"1007698",
"COO"=>"1000992",
"COUILLET"=>"1000281",
"COUR-SUR-HEURE"=>"1000288",
"COURCELLES-MOTTE"=>"1000286",
"COURRIERE"=>"1000287",
"COURT-SAINT-ETIENNE"=>"1000289",
"COUVIN"=>"1000291",
"CREIL (F)"=>"1007616",
"CROIX-L'ALLUMETTE (F)"=>"1007700",
"CROIX-WASQUEHAL (F)"=>"1007702",
"CRUCHTEN (L)"=>"1005018",
"DAVE-SAINT-MARTIN"=>"1000313",
"DAX (F)"=>"1007552",
"DE HOEK"=>"1000316",
"DE PANNE"=>"1000013",
"DE PINTE"=>"1000320",
"DEINZE"=>"1000317",
"DELFT (NL)"=>"1003036",
"DELTA"=>"1001761",
"DEN HAAG CS (NL)"=>"1003011",
"DEN HAAG-H.S. (NL)"=>"1003016",
"DEN HELDER (NL)"=>"1003045",
"DENDERLEEUW"=>"1000318",
"DENDERMONDE"=>"1000319",
"DESENZANO DEL GUARDA-SI"=>"1006568",
"DEVENTER (NL)"=>"1003054",
"DIEGEM"=>"1000325",
"DIEKIRCH (L)"=>"1005048",
"DIEPENBEEK"=>"1000324",
"DIEREN (NL)"=>"1003033",
"DIEST"=>"1000326",
"DIFFERDANGE (L)"=>"1005050",
"DIKSMUIDE"=>"1000327",
"DILBEEK"=>"1000328",
"DINANT"=>"1000329",
"DIPPACH-RECKANGE (L)"=>"1005052",
"DOBBIACO (I)"=>"1006559",
"DOLHAIN-GILEPPE"=>"1000331",
"DOMMELDANGE (L)"=>"1005054",
"DOMODOSSOLA (I)"=>"1006526",
"DONAUWORTH (D)"=>"1003636",
"DORDRECHT (NL)"=>"1003012",
"DORFGASTEIN (AU)"=>"1006009",
"DOUAI (F)"=>"1007634",
"DRAUFFELT (L)"=>"1005056",
"DRONGEN"=>"1000335",
"DUDELANGE-BURANGE"=>"1005007",
"DUDELANGE-CENTRE (L)"=>"1005003",
"DUDELANGE-USINES (L)"=>"1005020",
"DUDELANGE-VILLE (L)"=>"1005058",
"DUFFEL"=>"1000336",
"DUINBERGEN"=>"1000337",
"DUREN (D)"=>"1003538",
"DUSSELDORF (D)"=>"1003540",
"ECAUSSINNES"=>"1000342",
"EDE"=>"1000345",
"EEKLO"=>"1000346",
"EICHEM"=>"1000347",
"EIJSDEN (NL)"=>"1003014",
"EINDHOVEN (NL)"=>"1003022",
"EINE"=>"1000348",
"EKE-NAZARETH"=>"1000351",
"EKEREN"=>"1000352",
"ELST (NL)"=>"1003031",
"EMBRUN (F)"=>"1007599",
"ENGHIEN"=>"1000360",
"ENGIS"=>"1000361",
"EPPEGEM"=>"1000363",
"ERBISOEUL"=>"1000364",
"EREMBODEGEM"=>"1000365",
"ERNAGE"=>"1000366",
"ERPE-MERE"=>"1000367",
"ERPS-KWERPS"=>"1000368",
"ERQUELINNES"=>"1000369",
"ERQUELINNES-VILLAGE"=>"1000371",
"ESCH-SUR-ALZETTE (L)"=>"1005010",
"ESNEUX"=>"1000375",
"ESSEN"=>"1000376",
"ESSENE-LOMBEEK"=>"1000378",
"ETTELBRUCK (L)"=>"1005252",
"ETTERBEEK"=>"1000380",
"EUPEN"=>"1000382",
"EVERE"=>"1000383",
"EZEMAAL"=>"1000384",
"FAMILLEUREUX"=>"1000391",
"FARCIENNES"=>"1000392",
"FAUX"=>"1000395",
"FEXHE-LE-HAUT-CLOCHER"=>"1000399",
"FIEBERBRUNN (AU)"=>"1006018",
"FLAWINNE"=>"1000400",
"FLEMALLE-GRANDE"=>"1000401",
"FLEMALLE-HAUTE"=>"1000402",
"FLEURUS"=>"1000404",
"FLOREE"=>"1000405",
"FLOREFFE"=>"1000406",
"FLORENVILLE"=>"1000409",
"FLORIVAL"=>"1000410",
"FONTAINE-VALMONT"=>"1000412",
"FORCHIES"=>"1000413",
"FORRIERES"=>"1000418",
"FORTEZZA (I)"=>"1006530",
"FRAIPONT"=>"1000421",
"FRAMERIES"=>"1000422",
"FRANCHIMONT"=>"1000423",
"FRANIERE"=>"1000424",
"FRANKFURT FLUGH. (D)"=>"1003539",
"FREJUS-SAINT-RAPHAEL(F)"=>"1007547",
"FRICK (CH)"=>"1007019",
"FROYENNES"=>"1000427",
"FRUTIGEN (CH)"=>"1007036",
"GALLERATE (I)"=>"1006563",
"GALMAARDEN"=>"1000432",
"GAP (F)"=>"1007597",
"GASTUCHE"=>"1000433",
"GAVERE-ASPER"=>"1000434",
"GEDINNE"=>"1000435",
"GEEL"=>"1000436",
"GEMBLOUX"=>"1000438",
"GENDRON-CELLES"=>"1000442",
"GENEVE (CH)"=>"1007039",
"GENK"=>"1001670",
"GENLY"=>"1000446",
"GENOVA PP (I)"=>"1006539",
"GENT-DAMPOORT"=>"1000449",
"GENT-SINT-PIETERS"=>"1000455",
"GENTBRUGGE"=>"1000447",
"GENVAL"=>"1000457",
"GERAARDSBERGEN"=>"1000458",
"GERONSTERE"=>"1000459",
"GHLIN"=>"1000462",
"GLONS"=>"1000470",
"GOBELSMUHLE (L)"=>"1005060",
"GODARVILLE"=>"1000471",
"GODINNE"=>"1000472",
"GOES (NL)"=>"1003023",
"GOLLING-ABTENAU (AU)"=>"1006005",
"GONTRODE"=>"1000474",
"GOPPENSTEIN (CH)"=>"1007038",
"GOUVY"=>"1000477",
"GOUY-LEZ-PIETON"=>"1000479",
"GRAIDE"=>"1000480",
"GRENOBLE (F)"=>"1007831",
"GROENENDAAL"=>"1000486",
"GRONINGEN (NL)"=>"1003032",
"GROOT-BIJGAARDEN"=>"1000488",
"GROSSETO (I)"=>"1006551",
"GRUPONT"=>"1000489",
"GUMLINGEN (CH)"=>"1007033",
"HAACHT"=>"1000493",
"HAALTERT"=>"1000494",
"HAARLEM (NL)"=>"1003040",
"HABAY"=>"1000496",
"HAININ"=>"1000501",
"HALLE"=>"1000504",
"HAM-SUR-HEURE"=>"1000514",
"HAM-SUR-SAMBRE"=>"1000515",
"HAMBOS"=>"1000507",
"HAMBURG (D)"=>"1003544",
"HAMBURG DAM (D)"=>"1003547",
"HAMBURG-ALTONA (D)"=>"1003546",
"HAMBURG-HARBURG (D)"=>"1003548",
"HAMOIR"=>"1000510",
"HANNOVER (D)"=>"1003552",
"HANSBEKE"=>"1000518",
"HARCHIES"=>"1000519",
"HARELBEKE"=>"1000520",
"HAREN"=>"1001663",
"HAREN-ZUID"=>"1000521",
"HASSELT"=>"1000523",
"HAUTE-FLONE"=>"1000530",
"HAVERSIN"=>"1000532",
"HAVRE"=>"1000535",
"HEIDE"=>"1000539",
"HEISDORF (L)"=>"1005034",
"HEIST"=>"1000540",
"HEIST-OP-DEN-BERG"=>"1000541",
"HEIZIJDE"=>"1000542",
"HELLEMMES (F)"=>"1007704",
"HEMIKSEM"=>"1000546",
"HENNUYERES"=>"1000550",
"HERENT"=>"1000553",
"HERENTALS"=>"1000554",
"HERNE"=>"1000559",
"HERSEAUX"=>"1000560",
"HERSTAL"=>"1000562",
"HERZELE"=>"1000563",
"HERZOGENBUCHSEE (CH)"=>"1007056",
"HEUSDEN"=>"1000565",
"HEVER"=>"1000566",
"HEVERLEE"=>"1000567",
"HILLEGEM"=>"1000568",
"HILVERSUM (NL)"=>"1003038",
"HOBOKEN-POLDER"=>"1000570",
"HOEILAART"=>"1000572",
"HOFSTADE"=>"1000574",
"HOLLEKEN"=>"1000578",
"HOLLERICH (L)"=>"1005062",
"HONY"=>"1000579",
"HOURAING"=>"1000583",
"HOURPES"=>"1000585",
"HOUYET"=>"1000589",
"HOVE"=>"1000590",
"HOWALD (L)"=>"1005022",
"HUIZINGEN"=>"1000591",
"HUY"=>"1000592",
"IDDERGEM"=>"1000600",
"IDEGEM"=>"1000601",
"IEPER"=>"1000602",
"IGEL (D)"=>"1003588",
"INGELMUNSTER"=>"1000604",
"INNSBRUCK HBF (AU)"=>"1006019",
"IZEGEM"=>"1000606",
"JAMBES"=>"1000611",
"JAMBES-EST"=>"1000610",
"JAMIOULX"=>"1000612",
"JEMAPPES"=>"1000615",
"JEMELLE"=>"1000617",
"JEMEPPE-SUR-MEUSE"=>"1000619",
"JEMEPPE-SUR-SAMBRE"=>"1000620",
"JENBACH (AU)"=>"1006020",
"JETTE"=>"1000621",
"JEUMONT (F)"=>"1007706",
"JUAN-LES-PINS (F)"=>"1007650",
"JURBISE"=>"1000628",
"JUSLENVILLE"=>"1000629",
"KALMTHOUT"=>"1000630",
"KANDERSTEG (CH)"=>"1007040",
"KAPELLE-OP-DEN-BOS"=>"1000634",
"KAPELLEN"=>"1000632",
"KARTHAUS (D)"=>"1003590",
"KAUTENBACH (L)"=>"1005032",
"KAYL (L)"=>"1005064",
"KESSEL"=>"1000635",
"KIEWIT"=>"1000636",
"KIJKUIT"=>"1000637",
"KIRCHBERG IN TIROL (AU)"=>"1006021",
"KITZBUHEL (AU)"=>"1006022",
"KLEINBETTINGEN (L)"=>"1005258",
"KNOKKE"=>"1000642",
"KOKSIJDE"=>"1000643",
"KOLN-HBF (D)"=>"1003551",
"KONTICH"=>"1000644",
"KORTEMARK"=>"1000647",
"KORTENBERG"=>"1000648",
"KORTRIJK"=>"1000649",
"KREUZ KONZ (D)"=>"1003592",
"KRUININGEN-YERSEKE (NL)"=>"1003049",
"KUFSTEIN (AU)"=>"1006025",
"KWATRECHT"=>"1000654",
"L'ARGENTIERE (F)"=>"1007604",
"L'HOSPITALET (F)"=>"1007628",
"LA HULPE"=>"1000672",
"LA LOUVIERE-CENTRE"=>"1000673",
"LA LOUVIERE-SUD"=>"1001744",
"LA ROCHE"=>"1000692",
"LA ROCHE/FORON (F)"=>"1007590",
"LA SPEZIA CENTRALE (I)"=>"1006546",
"LA TOUR DE CAROL (F)"=>"1007632",
"LABUISSIERE"=>"1000664",
"LANDEGEM"=>"1000682",
"LANDELIES"=>"1000683",
"LANDEN"=>"1000684",
"LANDQUART (CH)"=>"1007041",
"LANDRECIES (F)"=>"1007611",
"LANDRY (F)"=>"1007554",
"LANDSKOUTER"=>"1000685",
"LANGDORP"=>"1000686",
"LANGENTHAL (CH)"=>"1007055",
"LAUFEN (CH)"=>"1007058",
"LAUSANNE (CH)"=>"1007042",
"LE CAMPINAIRE"=>"1000700",
"LE CATEAU (F)"=>"1007613",
"LE CREUSOT (F)"=>"1007523",
"LEBBEKE"=>"1000699",
"LEDE"=>"1000701",
"LEEUWARDEN (NL)"=>"1003034",
"LEIDEN CENTRAAL (NL)"=>"1003018",
"LEIGNON"=>"1000704",
"LEMAN"=>"1000705",
"LEMBEEK"=>"1000706",
"LENS"=>"1000707",
"LEOPOLDSBURG"=>"1000708",
"LES ARCS (F)"=>"1007826",
"LES AUBRAIS (F)"=>"1007619",
"LESSINES"=>"1000710",
"LEUDELANGE (L)"=>"1005066",
"LEUZE"=>"1000719",
"LEVAL"=>"1000720",
"LEZENNES (F)"=>"1007708",
"LIBOURNE (F)"=>"1007596",
"LIBRAMONT"=>"1000723",
"LICHTERVELDE"=>"1000724",
"LIEDEKERKE"=>"1000725",
"LIEGE-GUILLEMINS"=>"1000726",
"LIEGE-JONFOSSE"=>"1000728",
"LIEGE-PALAIS"=>"1000730",
"LIER"=>"1000732",
"LIERDE"=>"1001085",
"LIERS"=>"1000733",
"LIESTAL (CH)"=>"1007049",
"LIGNY"=>"1000736",
"LILLE EUROPE (F)"=>"1007651",
"LILLE FLANDRES(F)"=>"1007710",
"LILLE-EUROPE(EUROSTAR) "=>"1007572",
"LILLOIS"=>"1000738",
"LIMAL"=>"1000739",
"LINKEBEEK"=>"1000742",
"LINTGEN (L)"=>"1005068",
"LINZ HBF (AU)"=>"1006027",
"LISSEWEGE"=>"1000743",
"LIVORNO CENTRALE (I)"=>"1006549",
"LOBBES"=>"1000744",
"LODELINSART"=>"1000747",
"LOKEREN"=>"1000748",
"LOMMEL"=>"1000750",
"LONDERZEEL"=>"1000751",
"LONDON WATERLOO (GB)"=>"1008521",
"LONGWY (F)"=>"1007674",
"LONZEE"=>"1000754",
"LORENTZWEILER (L)"=>"1005070",
"LOT"=>"1000759",
"LOURDES (F)"=>"1007557",
"LOUVAIN"=>"1000715",
"LOUVAIN-LA-NEUVE-UNIV."=>"1000762",
"LUCHTBAL"=>"1000764",
"LUGANO (CH)"=>"1007015",
"LUSTIN"=>"1000767",
"LUTTRE"=>"1000768",
"LUXEMBOURG (L)"=>"1005250",
"LYON PART-DIEU (F)"=>"1007647",
"LYON-PERRACHE (F)"=>"1007648",
"LYON-ST.-EXUPERY-TGV(F)"=>"1007623",
"MAASTRICHT (NL)"=>"1003021",
"MAASTRICHT-RANDWYCK(NL)"=>"1003019",
"MAFFLE"=>"1000782",
"MAIENFELD (CH)"=>"1007037",
"MALDEREN"=>"1000781",
"MALENFELD (CH)"=>"1007062",
"MALLNITZ-OBERV. (AU)"=>"1006028",
"MAMER (L)"=>"1005260",
"MANAGE"=>"1000784",
"MANTERNACH (L)"=>"1005072",
"MARBEHAN"=>"1000786",
"MARCHE-EN-FAMENNE"=>"1000788",
"MARCHE-LES-DAMES"=>"1000789",
"MARCHE-LEZ-ECAUSSINNES"=>"1000790",
"MARCHIENNE-AU-PONT"=>"1000791",
"MARCHIENNE-ZONE"=>"1000793",
"MARIA-AALTER"=>"1000797",
"MARIEMBOURG"=>"1000798",
"MARLOIE"=>"1000801",
"MARNE LA VALLEE (F)"=>"1007558",
"MARSEILLE-BLANCARDE (F)"=>"1007607",
"MARSEILLE-SAINT-CH.(F)"=>"1007556",
"MARTIGNY (CH)"=>"1007008",
"MASNUY-SAINT-PIERRE"=>"1000805",
"MASSY TGV (F)"=>"1007549",
"MAUBEUGE (F)"=>"1007676",
"MAUBRAY"=>"1000807",
"MAULUSMUHLE (L)"=>"1005030",
"MAZY"=>"1000809",
"MECHELEN"=>"1000810",
"MECHELEN-NEKKERSPOEL"=>"1000811",
"MEISER"=>"1000812",
"MELKOUWEN"=>"1000814",
"MELLE"=>"1000815",
"MELREUX-HOTTON"=>"1000818",
"MELSELE"=>"1000819",
"MENEN"=>"1000820",
"MENTON (F)"=>"1007560",
"MERCHTEM"=>"1000821",
"MERELBEKE"=>"1000822",
"MERKHOLTZ (L)"=>"1005074",
"MERODE"=>"1000826",
"MERSCH (L)"=>"1005000",
"MERTERT (L)"=>"1005076",
"MERY"=>"1000827",
"METZ (F)"=>"1007562",
"MEVERGNIES-ATTRE"=>"1000832",
"MICHELAU (L)"=>"1005078",
"MIDDELBURG (NL)"=>"1003058",
"MIDDELBURG (NL)"=>"1003025",
"MILANO CENTRALE (I)"=>"1006532",
"MILANO LAMBRATE (I)"=>"1006531",
"MILANO S.CRISTOFORO (I)"=>"1006544",
"MILMORT"=>"1000835",
"MOENSBERG"=>"1000837",
"MOL"=>"1000840",
"MOLLEM"=>"1000841",
"MOMALLE"=>"1000842",
"MONACO-MONTE-CARLO (F)"=>"1007563",
"MONGUELFO-VALLE DI CASI"=>"1006507",
"MONS"=>"1000848",
"MONT-SAINT-GUIBERT"=>"1000855",
"MONTAUBAN (F)"=>"1007518",
"MONTDAUPHIN (F)"=>"1007602",
"MONTPELLIER (F)"=>"1007564",
"MONTREUX (CH)"=>"1007011",
"MOORTSELE"=>"1000860",
"MORLANWELZ"=>"1000862",
"MORTSEL"=>"1000863",
"MORTSEL-DEURNESTEENWEG"=>"1000864",
"MORTSEL-OUDE-GOD"=>"1000866",
"MOUSCRON"=>"1000868",
"MOUSTIER"=>"1000870",
"MOUTIERS-S.B.-LES-B.(F)"=>"1007566",
"MUIZEN"=>"1000871",
"MULHOUSE (F)"=>"1007568",
"MUNCHEN HBF (D)"=>"1003562",
"MUNCHEN-PASING (D)"=>"1003637",
"MUNKZWALM"=>"1000873",
"MUNSBACH (L)"=>"1005036",
"NAMECHE"=>"1000894",
"NAMUR"=>"1000895",
"NANINNE"=>"1000896",
"NARBONNE (F)"=>"1007569",
"NATOYE"=>"1000897",
"NEERPELT"=>"1000899",
"NEERWINDEN"=>"1000900",
"NESSONVAUX"=>"1000901",
"NEUCHATEL (CH)"=>"1007014",
"NEUFCHATEAU"=>"1000752",
"NEUFVILLES"=>"1000902",
"NEUMARKT-KAL (AU)"=>"1006076",
"NICE-VILLE (F)"=>"1007570",
"NIEDERKORN (L)"=>"1005080",
"NIEL"=>"1000905",
"NIEUWKERKEN-WAAS"=>"1000906",
"NIJLEN"=>"1000907",
"NIJMEGEN (NL)"=>"1003048",
"NIMES (F)"=>"1007571",
"NIMY"=>"1000908",
"NINOVE"=>"1000910",
"NIVELLES"=>"1000911",
"NORTZANGE (L)"=>"1005082",
"NOSSEGEM"=>"1000916",
"NOYON (F)"=>"1007897",
"NURNBERG (D)"=>"1003564",
"OBAIX-BUZET"=>"1000919",
"OBERKORN (L)"=>"1005084",
"OBOURG"=>"1000920",
"OKEGEM"=>"1000923",
"OLEN"=>"1000924",
"OLTEN (CH)"=>"1007044",
"OOSTKAMP"=>"1000931",
"OPWIJK"=>"1000933",
"OSNABRUCK (D)"=>"1003566",
"OSS (NL)"=>"1003029",
"OSTENDE"=>"1000929",
"OTRANGE (L)"=>"1005086",
"OTTIGNIES"=>"1000936",
"OUD-HEVERLEE"=>"1000941",
"OUDEGEM"=>"1000938",
"OUDENAARDE"=>"1000939",
"OVERPELT"=>"1001666",
"PADOVA (I)"=>"1006513",
"PALISEUL"=>"1000951",
"PAPIGNIES"=>"1000952",
"PARADISO (L)"=>"1005001",
"PARIS-NORD (F)"=>"1007678",
"PASSAU (D)"=>"1003569",
"PECROT"=>"1000954",
"PEPINSTER"=>"1000956",
"PEPINSTER-CITE"=>"1000957",
"PERPIGNAN (F)"=>"1007573",
"PERUWELZ"=>"1000958",
"PESARO (I)"=>"1006510",
"PETANGE (L)"=>"1005004",
"PFAFFIKON SZ (CH)"=>"1007029",
"PHILIPPEVILLE"=>"1000961",
"PIETON"=>"1000962",
"PISA CENTRALE (I)"=>"1006548",
"PLATTLING (D)"=>"1003528",
"POITIERS (F)"=>"1007592",
"POIX-SAINT-HUBERT"=>"1000968",
"PONT-A-CELLES"=>"1000970",
"PONT-DE-BOIS (F)"=>"1007680",
"PONT-DE-SERAING"=>"1000971",
"POPERINGE"=>"1000973",
"PORT BOU (SP)"=>"1008032",
"PORT-VENDRES (F)"=>"1007612",
"PORTE PUYMORENS (F)"=>"1007630",
"POULSEUR"=>"1000974",
"PROFONDSART"=>"1000975",
"PRY"=>"1000976",
"PUURS"=>"1000977",
"QUAREGNON"=>"1000979",
"QUEVY"=>"1000982",
"QUIEVRAIN"=>"1000984",
"REBAIX"=>"1000989",
"REGENSBURG HBF (D)"=>"1003572",
"REMICOURT"=>"1000991",
"RHEINFELDEN (CH)"=>"1007018",
"RHISNES"=>"1000995",
"RICCIONE (I)"=>"1006533",
"RIMINI (I)"=>"1006508",
"RIVAGE"=>"1000996",
"RIXENSART"=>"1000997",
"RODANGE (L)"=>"1005012",
"ROERMOND (NL)"=>"1003020",
"ROESELARE"=>"1001005",
"ROISSY CDG (F)"=>"1007559",
"ROMA OSTIENSE (I)"=>"1006553",
"ROMA TUSCOLANA (I)"=>"1006554",
"RONET"=>"1001009",
"RONSE"=>"1001013",
"ROODT/SYRE (L)"=>"1005088",
"ROOSENDAAL (NL)"=>"1003017",
"ROSENHEIM (D)"=>"1003573",
"ROTTERDAM-C.S. (NL)"=>"1003015",
"ROUBAIX (F)"=>"1007682",
"ROUX"=>"1001018",
"RUISBROEK"=>"1001021",
"RUISBROEK-SAUVEGARDE"=>"1001017",
"RUMELANGE (L)"=>"1005090",
"SAALFELDEN (AU)"=>"1006030",
"SAINT GERVAIS (F)"=>"1007574",
"SAINT MAURICE (CH)"=>"1007006",
"SAINT RAPHAEL VAL. (F)"=>"1007578",
"SAINT-DENIS-BOVESSE"=>"1001031",
"SAINT-GHISLAIN"=>"1001034",
"SAINT-LOUIS (F)"=>"1007531",
"SAINT-PIERRE-CORPS (F)"=>"1007591",
"SAINT-QUENTIN (F)"=>"1007684",
"SALLANCHES (F)"=>"1007593",
"SALZBURG (AU)"=>"1006031",
"SAN BONIFACIO (I)"=>"1006556",
"SAN CANDIDO (I)"=>"1006535",
"SANDWEILER (L)"=>"1005094",
"SANKT POLTEN (AU)"=>"1006035",
"SARGANS (CH)"=>"1007013",
"SART-BERNARD"=>"1001043",
"SATOLAS (F)"=>"1007521",
"SCHAARBEEK"=>"1001048",
"SCHARDING (AU)"=>"1006078",
"SCHELDEWINDEKE"=>"1001056",
"SCHELLEBELLE"=>"1001058",
"SCHENDELBEKE"=>"1001059",
"SCHIEREN (L)"=>"1005096",
"SCHIFFLANGE (L)"=>"1005098",
"SCHIPHOL (NL)"=>"1003013",
"SCHOONAARDE"=>"1001060",
"SCHOUWEILER (L)"=>"1005100",
"SCHULEN"=>"1001061",
"SCHWARZACH-ST. VE. (AU)"=>"1006032",
"SCLAIGNEAUX"=>"1001062",
"SCLESSIN"=>"1001063",
"SENIGALLIA (I)"=>"1006512",
"SERSKAMP"=>"1001068",
"SETE (F)"=>"1007822",
"SIERRE/SIDERS (CH)"=>"1007046",
"SILLY"=>"1000121",
"SINAAI"=>"1001073",
"SINT-AGATHA-BERCHEM"=>"1000243",
"SINT-DENIJS-BOEKEL"=>"1001076",
"SINT-GENESIUS-RODE"=>"1001079",
"SINT-GILLIS"=>"1001730",
"SINT-JOB"=>"1001081",
"SINT-JORIS-WEERT"=>"1001082",
"SINT-KATELIJNE-WAVER"=>"1001083",
"SINT-MARIABURG"=>"1001084",
"SINT-MARTENS-BODEGEM"=>"1001087",
"SINT-NIKLAAS"=>"1001088",
"SINT-TRUIDEN"=>"1001090",
"SION (CH)"=>"1007047",
"SISSACH (CH)"=>"1007053",
"SITTARD (NL)"=>"1003062",
"SLEIDINGE"=>"1001091",
"SOIGNIES"=>"1001092",
"SOLOTHURN (CH)"=>"1007043",
"SOLRE-SUR-SAMBRE"=>"1001093",
"SOUILLAC (F)"=>"1007640",
"SPA"=>"1001097",
"SPIEZ (CH)"=>"1007048",
"SPITTAL-MILLSTAT. (AU)"=>"1006033",
"ST JOHANN-TIROL(AU)"=>"1006034",
"ST. JOHANN/PONGAU (AU)"=>"1006008",
"ST. VALENTIN"=>"1006015",
"STATTE"=>"1001102",
"STEINACH IN TIROL (AU)"=>"1006036",
"STOCKEM"=>"1001107",
"STRASBOURG (F)"=>"1007580",
"STRAUBING (D)"=>"1003574",
"STRESA (I)"=>"1006536",
"SY"=>"1001113",
"TAMINES"=>"1001125",
"TARBES (F)"=>"1007581",
"TEMSE"=>"1001128",
"TERGNIER (F)"=>"1007899",
"TERHAGEN"=>"1001130",
"TERNAT"=>"1001131",
"TESTELT"=>"1001134",
"TETANGE (L)"=>"1005102",
"TGV HAUTE PICARDIE (F)"=>"1007561",
"THALWIL (CH)"=>"1007021",
"THEUX"=>"1001135",
"THIEU"=>"1001136",
"THIONVILLE (F)"=>"1007686",
"THUIN"=>"1001139",
"THULIN"=>"1001141",
"THUN (CH)"=>"1007050",
"TIELEN"=>"1001144",
"TIELT"=>"1001145",
"TIENEN"=>"1001146",
"TILBURG (NL)"=>"1003046",
"TILFF"=>"1001147",
"TILLY"=>"1001149",
"TOLLEMBEEK"=>"1001150",
"TONGEREN"=>"1001151",
"TORHOUT"=>"1001152",
"TOUL (F)"=>"1007864",
"TOULON (F)"=>"1007584",
"TOULOUSE-MATABIAU (F)"=>"1007585",
"TOURCOING (F)"=>"1007688",
"TOURNAI"=>"1001154",
"TREUCHTLINGEN (D)"=>"1003635",
"TREVIGLIO (I)"=>"1006564",
"TRIER HBF (D)"=>"1003584",
"TRIER SUD (D)"=>"1003594",
"TROIS-PONTS"=>"1001157",
"TROISVIERGES (L)"=>"1005262",
"TROOZ"=>"1001159",
"TUBIZE"=>"1001160",
"TURNHOUT"=>"1001161",
"UKKEL-KALEVOET"=>"1001167",
"UKKEL-STALLE"=>"1001168",
"UTRECHT (NL)"=>"1003026",
"VALDAORA-ANTERS (I)"=>"1006505",
"VALENCE (F)"=>"1007586",
"VALENCE TGV"=>"1007653",
"VELTEM"=>"1001174",
"VENEZIA MESTRE (I)"=>"1006565",
"VENEZIA S.L. (I)"=>"1006545",
"VENTIMIGLIA (I)"=>"1006538",
"VERBANIA-PAL (I)"=>"1006561",
"VERONA (I)"=>"1006540",
"VERTRIJK"=>"1001176",
"VERVIERS-CENTRAL"=>"1001177",
"VERVIERS-PALAIS"=>"1001180",
"VEURNE"=>"1001181",
"VEVEY (CH)"=>"1007012",
"VEYNES-DEVOLUY (F)"=>"1007595",
"VIANE-MOERBEKE"=>"1001182",
"VIAREGGIO (I)"=>"1006547",
"VICENZA (I)"=>"1006542",
"VICHTE"=>"1001184",
"VIELSALM"=>"1001185",
"VIJFHUIZEN"=>"1001186",
"VILLABASSA (I)"=>"1006511",
"VILLACH HBF (AU)"=>"1006038",
"VILLE-POMMEROEUL"=>"1001187",
"VILLERS-LA-VILLE"=>"1001189",
"VILVOORDE"=>"1001192",
"VIPITENO (I)"=>"1006541",
"VIRTON"=>"1001194",
"VISE"=>"1001195",
"VISP/VIGE (CH)"=>"1007009",
"VIVILLE"=>"1001198",
"VLISSINGEN (NL)"=>"1003060",
"VLISSINGEN-SOUBURG (NL)"=>"1003028",
"VOROUX"=>"1001202",
"VORST-OOST"=>"1000414",
"VORST-ZUID"=>"1000415",
"WAARSCHOOT"=>"1001206",
"WADENSWIL (CH)"=>"1007027",
"WALCOURT"=>"1001207",
"WALFERDANGE (L)"=>"1005104",
"WAREGEM"=>"1001212",
"WAREMME"=>"1001213",
"WASSERBILLIG (L)"=>"1005006",
"WATERLOO"=>"1001218",
"WATERMAAL"=>"1001219",
"WAVRE"=>"1001223",
"WECKER (L)"=>"1005106",
"WEERDE"=>"1001224",
"WEERT (NL)"=>"1003064",
"WELKENRAEDT"=>"1001226",
"WELLE"=>"1001228",
"WELS (AU)"=>"1006040",
"WERVIK"=>"1001229",
"WESPELAAR-TILDONK"=>"1001230",
"WETTEREN"=>"1001234",
"WEVELGEM"=>"1001235",
"WEZEMAAL"=>"1001238",
"WICHELEN"=>"1001253",
"WIEN WESTBF (AU)"=>"1006042",
"WIEN-HTTELDORF (AU)"=>"1006080",
"WIJCHEN (NL)"=>"1003035",
"WIJGMAAL"=>"1001242",
"WILDERT"=>"1001244",
"WILLEBROEK"=>"1001245",
"WILTZ (L)"=>"1005108",
"WILWERWILTZ (L)"=>"1005110",
"WONDELGEM"=>"1001248",
"WORGL (AU)"=>"1006044",
"WURZBURG (D)"=>"1003631",
"YVERDON (CH)"=>"1007061",
"YVES-GOMEZEE"=>"1001254",
"YVOIR"=>"1001255",
"ZANDBERGEN"=>"1001256",
"ZAVENTEM "=>"1001260",
"ZAVENTEM (AIRPORT)"=>"1000219",
"ZEDELGEM"=>"1001261",
"ZEEBRUGGE-DORP"=>"1001262",
"ZEEBRUGGE-STRAND"=>"1001723",
"ZELE"=>"1001265",
"ZELL AM SEE (AU)"=>"1006045",
"ZELLIK"=>"1001266",
"ZICHEM"=>"1001270",
"ZIEGELBRUCKE (CH)"=>"1007051",
"ZINGEM"=>"1001272",
"ZOTTEGEM"=>"1001274",
"ZURICH (CH)"=>"1007052",
"ZUTPHEN (NL)"=>"1003052",
"ZWANKENDAMME"=>"1001275",
"ZWIJNDRECHT"=>"1001278",
"ZWOLLE (NL)"=>"1003030",
);

1;

__END__
=head1 NAME

WWW::B_Rail::Cities::English - Lists english city names on b-rail.be

=head1 SYNOPSIS

  use WWW::B_Rail::Cities::English;

=head1 DESCRIPTION

WWW::B_Rail::Cities::English is basically a hash package (*grin*), it exports
a hash filled with cities and there respective IDs. These cities and IDs are
used on b-rail.be. These are the english city names.

=head2 EXPORT

%cities

=head1 AUTHOR

Hendrik Van Belleghem  <lt> beatnik - at - quickndirty - dot - org <gt>

=head1 SEE ALSO

WWW::B_Rail

=cut

=head1 LICENSE

WWW::B_Rail is released under the GPL. See COPYING and COPYRIGHT for more info