package List::Generator;
BEGIN {require List::Gen}

=head1 NAME

List::Generator - provides functions for generating lists

=head1 VERSION

version 0.971

=head1 SYNOPSIS

this module is an alias for L<List::Gen>.  it is the same as L<List::Gen> in
every way.

    use List::Generator;

    my $range = <1 .. 1_000_000_000 by 3>;

    my $squares = gen {$_ ** 2} <1..>;

    my $fib = <0, 1, *+* ...>;

    say "@$fib[0 .. 10]"; # 0 1 1 2 3 5 8 13 21 34 55

each line below prints C< '1 9 25 49 81' >:

    functions:           (gen {$_**2} filter {$_ % 2} 1, 10)->say;

    list comprehensions: <**2 for 1 .. 10 if odd>->say;

    dwimmy methods:      <1..10>->grep('odd')->map('**2')->say;

    normal methods:      range(1, 10)->grep(sub {$_%2})->map(sub {$_**2})->say;

=head1 LINKS

=over 4

=item * see L<List::Gen> for core documentation.

=item * see L<List::Gen::Benchmark> for performance tips.

=item * see L<List::Gen::Cookbook> for usage tips.

=item * see L<List::Gen::Haskell> for an experimental implementation of haskell's
lazy list behavior.

=item * see L<List::Gen::Lazy> for the tools used to create L<List::Gen::Haskell>.

=item * see L<List::Gen::Lazy::Ops> for some of perl's operators implemented as lazy
haskell like functions.

=item * see L<List::Gen::Lazy::Builtins> for most of perl's builtin functions
implemented as lazy haskell like functions.

=item * see L<List::Gen::Perl6> for a source filter that adds perl6's meta
operators to use with generators, rather than the default overloaded operators

=back

=head1 AUTHOR

Eric Strom, C<< <asg at cpan.org> >>

=head1 COPYRIGHT & LICENSE

copyright 2009-2011 Eric Strom.

this program is free software; you can redistribute it and/or modify it under
the terms of either: the GNU General Public License as published by the Free
Software Foundation; or the Artistic License.

see http://dev.perl.org/licenses/ for more information.

=cut

1;
