package Test::Action::ListParams;

use base 'Test::Class';
use Test::Most;
use Siebel::Srvrmgr::ListParser;
use Storable;

sub class { 'Siebel::Srvrmgr::Daemon::Action::ListParams' }

sub startup : Tests(startup => 1) {
    my $test = shift;
    use_ok $test->class;
}

sub constructor : Tests(6) {

    my $test  = shift;
    my $class = $test->class;

    can_ok( $class,
        qw(new get_params get_parser get_params do get_dump_file set_dump_file)
    );

    my $file = 'list_comp_def.storable';

    my $action;

    ok(
        $action = $class->new(
            {
                parser =>
                  Siebel::Srvrmgr::ListParser->new( { is_warn_enabled => 1 } ),
                params => [$file]
            }
        ),
        'the constructor should suceed'
    );

    is( $action->get_dump_file(),
        $file, 'get_dump_file returns the correct string' );

    ok( $action->set_dump_file($file), 'set_dump_file works' );

    my @data = <Test::Action::ListParams::DATA>;
    close(Test::Action::ListParams::DATA);

    ok( $action->do( \@data ), 'do methods works fine' );

    my $params = retrieve($file);

    isa_ok(
        $params,
        'Siebel::Srvrmgr::ListParser::Output::ListParams',
        'component definitions were recovered successfuly'
    );

    unlink($file) or die "Cannot remove $file: $!\n";

}

1;

__DATA__
srvrmgr:SUsrvr> list params for component SRProc

PA_ALIAS                 PA_VALUE           PA_DATATYPE  PA_SCOPE   PA_SUBSYSTEM                 PA_SETLEVEL       PA_DISP_SETLEVEL                PA  PA  PA  PA  PA_NAME                                         
-----------------------  -----------------  -----------  ---------  ---------------------------  ----------------  ------------------------------  --  --  --  --  ----------------------------------------------  
CACertFileName                              String       Subsystem  Networking                   Never set         Never set                       N   N   Y   N   CA certificate file name                        
CertFileName                                String       Subsystem  Networking                   Never set         Never set                       N   N   Y   N   Certificate file name                           
ConnIdleTime             -1                 Integer      Subsystem  Networking                   Default value     Default value                   Y   N   N   N   SISNAPI connection maximum idle time            
Connect                  Siebel_DSN         String       Subsystem  Database Access              Enterprise level  Enterprise level set            Y   N   N   N   ODBC Data Source                                
DisableNotification      False              Boolean      Subsystem  Infrastructure Notification  Default value     Default value                   N   N   N   N   Disable Notification                            
EnableDbSessCorrelation  False              Boolean      Subsystem  Database Access              Default value     Default value                   Y   N   N   N   Enable Database Session Correlation             
EnableHousekeeping       False              Boolean      Component                               Default value     Default value                   N   N   N   N   Enable Various Housekeeping Tasks               
EnableUsageTracking      False              Boolean      Subsystem  Usage Tracking               Default value     Default value                   N   N   N   N   UsageTracking Enabled                           
FDRAppendFile            False              Boolean      Subsystem  (FDR) Flight Data Recorder   Default value     Default value                   N   N   N   N   FDR Periodic Dump and Append                    
FDRBufferSize            5000000            Integer      Subsystem  (FDR) Flight Data Recorder   Default value     Default value                   N   Y   N   Y   FDR Buffer Size                                 
KeyFileName                                 String       Subsystem  Networking                   Never set         Never set                       N   N   Y   N   Private key file name                           
KeyFilePassword          ********           String       Subsystem  Networking                   Never set         Never set                       N   N   Y   N   Private key file password                       
Lang                     enu                String       Subsystem  Infrastructure Core          Server level      Server level set                Y   N   N   N   Language Code                                   
LogArchiveDir                               String       Subsystem  Event Logging                Never set         Never set                       Y   N   N   N   Log Archive Directory                           
LogDir                                      String       Subsystem  Event Logging                Never set         Never set                       N   N   N   N   Log directory                                   
LogFileDir               c:\temp            String       Subsystem  Usage Tracking               Default value     Default value                   N   N   N   N   UsageTracking LogFile Dir                       
LogFileEncoding          ASCII              String       Subsystem  Usage Tracking               Default value     Default value                   N   N   N   N   UsageTracking LogFile Encoding                  
LogFileFormat            XML                String       Subsystem  Usage Tracking               Default value     Default value                   N   N   N   N   UsageTracking LogFile Format                    
LogFilePeriod            Hourly             String       Subsystem  Usage Tracking               Default value     Default value                   N   N   N   N   UsageTracking LogFile Period                    
LogMaxSegments           100                Integer      Subsystem  Event Logging                Compdef level     Component definition level set  N   N   N   N   Maximum number of log file segments             
LogSegmentSize           100                Integer      Subsystem  Event Logging                Compdef level     Component definition level set  N   N   N   N   Log file segment size in KB                     
MaxMTServers             1                  Integer      Subsystem  Multi-Threading              Compdef level     Component definition level set  N   N   Y   N   Maximum MT Servers                              
MaxTasks                 20                 Integer      Subsystem  Process Management           Compdef level     Component definition level set  N   N   Y   N   Maximum Tasks                                   
MemoryBasedRecycle       False              Boolean      Subsystem  Multi-Threading              Default value     Default value                   Y   N   N   N   Memory usage based multithread shell recycling  
MemoryLimit              1500               Integer      Subsystem  Multi-Threading              Default value     Default value                   Y   N   N   N   Process VM usage lower limit                    
MemoryLimitPercent       20                 Integer      Subsystem  Multi-Threading              Default value     Default value                   Y   N   N   N   Process VM usage upper limit                    
MinMTServers             1                  Integer      Subsystem  Multi-Threading              Compdef level     Component definition level set  N   N   Y   N   Minimum MT Servers                              
NotifyHandler            AdminEmailAlert    String       Subsystem  Infrastructure Notification  Server level      Server level set                N   N   N   N   Notification Handler                            
NotifyTimeOut            100                Integer      Subsystem  Infrastructure Notification  Default value     Default value                   N   N   N   N   Time to wait for doing notification             
NumRetries               10000              Integer      Subsystem  Recovery                     Default value     Default value                   Y   N   N   N   Number of Retries                               
Password                 ********           String       Subsystem  Database Access              Enterprise level  Enterprise level set            Y   N   N   N   Password                                        
PeerAuth                 False              Boolean      Subsystem  Networking                   Default value     Default value                   N   N   Y   N   Peer Authentication                             
PeerCertValidation       False              Boolean      Subsystem  Networking                   Default value     Default value                   N   N   Y   N   Validate peer certificate                       
Repository               Siebel Repository  String       Subsystem  Database Access              Default value     Default value                   Y   N   N   N   Siebel Repository                               
RetryInterval            5                  Integer      Subsystem  Recovery                     Default value     Default value                   Y   N   N   N   Retry Interval                                  
RetryUpTime              600                Integer      Subsystem  Recovery                     Default value     Default value                   Y   N   N   N   Retry Up Time                                   
SARMLevel                0                  Integer      Subsystem  (SARM) Response Measurement  Default value     Default value                   N   N   N   N   SARM Granularity Level                          
SRB ReqId                0                  String       Subsystem  Infrastructure Core          Default value     Default value                   Y   N   N   N   SRB RequestId                                   
SessionCacheSize         100                Integer      Subsystem  Usage Tracking               Default value     Default value                   N   N   N   N   UsageTracking Session Cache Size                
TableOwnPass             ********           String       Subsystem  Database Access              Never set         Never set                       Y   N   N   N   Table Owner Password                            
TableOwner               SIEBEL             String       Subsystem  Database Access              Enterprise level  Enterprise level set            Y   N   N   N   Table Owner                                     
TblSpace                                    String       Subsystem  Database Access              Never set         Never set                       Y   N   N   N   Tablespace Name                                 
UserList                                    String       Subsystem  Event Logging                Never set         Never set                       N   N   N   N   List of users                                   
Username                 SADMIN             String       Subsystem  Database Access              Enterprise level  Enterprise level set            Y   N   N   N   User Name                                       

44 rows returned.

