#============================================================= -*-Perl-*-
#
# Lemplate::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Ingy döt Net   <ingy@cpan.org>
#
# ORIGINAL AUTHOR
#   Andy Wardley   <abw@kfs.org>
#
# COPYRIGHT
#   Copyright (C) 2006-2008 Ingy döt Net.
#   Copyright (C) 1996-2000 Andy Wardley.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#------------------------------------------------------------------------
#
# NOTE: this module is constructed from the parser/Grammar.pm.skel
# file by running the parser/yc script.  You only need to do this if 
# you have modified the grammar in the parser/Parser.yp file and need
# to-recompile it.  See the README in the 'parser' directory for more
# information (sub-directory of the Lemplate distribution).
#
#========================================================================

package Lemplate::Grammar;

require 5.004;

use strict;
use vars qw( $VERSION );

$VERSION  = sprintf("%d.%02d", q$Revision: 2.10 $ =~ /(\d+)\.(\d+)/);

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================
# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE RAW PLUGIN FILTER MACRO JAVASCRIPT TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META IN
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG
    );

# for historical reasons, != and == are converted to ne and eq to perform 
# stringwise comparison (mainly because it doesn't generate "non-numerical 
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al, 
# briefly for v2.04d and then took them out again in 2.04e.

%CMPOP = qw( 
    != ~=
    == ==
    <  <
    >  >
    >= >=
    <= <=
);


#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
#    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
#    my @binop  = qw( + - * % );              # '/' above, in @tokens
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'RAW' => 45,
			'IF' => 44,
			'JAVASCRIPT' => 42,
			'PROCESS' => 43,
			'META' => 41,
			'STOP' => 5,
			'FOR' => 3,
			'NUMBER' => 4,
			"\${" => 9,
			'GET' => 10,
			'WHILE' => 51,
			'NOT' => 8,
			'DEFAULT' => 7,
			'FILTER' => 12,
			'TEXT' => 15,
			'LITERAL' => 13,
			'rawperl' => 55,
			'NEXT' => 18,
			'TRY' => 59,
			'WRAPPER' => 58,
			'SET' => 20,
			'IDENT' => 23,
			'DEBUG' => 62,
			'LAST' => 60,
			";" => -19,
			'SWITCH' => 24,
			'MACRO' => 66,
			'UNLESS' => 63,
			'VIEW' => 64,
			'USE' => 68,
			'perl' => 28,
			'INCLUDE' => 26,
			'REF' => 32,
			'BLOCK' => 69,
			'CALL' => 30,
			"\$" => 71,
			'INSERT' => 33,
			"[" => 37,
			"(" => 36,
			"\"" => 73,
			'THROW' => 72,
			'RETURN' => 34,
			'CLEAR' => 74,
			"{" => 39
		},
		DEFAULT => -3,
		GOTOS => {
			'switch' => 2,
			'sterm' => 48,
			'chunk' => 1,
			'item' => 46,
			'defblock' => 47,
			'condition' => 53,
			'directive' => 52,
			'statement' => 50,
			'ident' => 11,
			'atomexpr' => 49,
			'template' => 6,
			'setlist' => 56,
			'capture' => 16,
			'lterm' => 54,
			'atomdir' => 14,
			'raw' => 19,
			'chunks' => 57,
			'defblockname' => 17,
			'filter' => 65,
			'expr' => 61,
			'use' => 21,
			'macro' => 22,
			'node' => 31,
			'wrapper' => 29,
			'javascript' => 25,
			'anonblock' => 27,
			'term' => 67,
			'assign' => 38,
			'block' => 35,
			'view' => 70,
			'loop' => 75,
			'try' => 40
		}
	},
	{#State 1
		DEFAULT => -5
	},
	{#State 2
		DEFAULT => -23
	},
	{#State 3
		ACTIONS => {
			'LITERAL' => 77,
			"\$" => 71,
			'IDENT' => 78,
			"\"" => 73,
			"[" => 37,
			'NUMBER' => 4,
			"{" => 39,
			"\${" => 9,
			'REF' => 32
		},
		GOTOS => {
			'lterm' => 54,
			'ident' => 76,
			'item' => 46,
			'term' => 79,
			'sterm' => 48,
			'node' => 31,
			'loopvar' => 80
		}
	},
	{#State 4
		DEFAULT => -114
	},
	{#State 5
		DEFAULT => -39
	},
	{#State 6
		ACTIONS => {
			'' => 81
		}
	},
	{#State 7
		ACTIONS => {
			"\$" => 71,
			'IDENT' => 23,
			"\${" => 9,
			'LITERAL' => 84
		},
		GOTOS => {
			'ident' => 83,
			'item' => 46,
			'assign' => 38,
			'setlist' => 82,
			'node' => 31
		}
	},
	{#State 8
		ACTIONS => {
			'REF' => 32,
			"{" => 39,
			'NOT' => 8,
			"\${" => 9,
			"\"" => 73,
			"(" => 36,
			'NUMBER' => 4,
			"[" => 37,
			'LITERAL' => 77,
			'IDENT' => 23,
			"\$" => 71
		},
		GOTOS => {
			'term' => 67,
			'lterm' => 54,
			'expr' => 85,
			'item' => 46,
			'ident' => 76,
			'node' => 31,
			'sterm' => 48
		}
	},
	{#State 9
		ACTIONS => {
			"\"" => 73,
			'NUMBER' => 4,
			'REF' => 32,
			'IDENT' => 23,
			"\$" => 71,
			"\${" => 9,
			'LITERAL' => 77
		},
		GOTOS => {
			'node' => 31,
			'sterm' => 86,
			'ident' => 76,
			'item' => 46
		}
	},
	{#State 10
		ACTIONS => {
			"\${" => 9,
			'NOT' => 8,
			"{" => 39,
			'REF' => 32,
			'IDENT' => 23,
			"\$" => 71,
			'LITERAL' => 77,
			"[" => 37,
			'NUMBER' => 4,
			"(" => 36,
			"\"" => 73
		},
		GOTOS => {
			'sterm' => 48,
			'node' => 31,
			'expr' => 87,
			'lterm' => 54,
			'item' => 46,
			'ident' => 76,
			'term' => 67
		}
	},
	{#State 11
		ACTIONS => {
			'ASSIGN' => 88,
			'DOT' => 89
		},
		DEFAULT => -110
	},
	{#State 12
		ACTIONS => {
			"\"" => 102,
			'FILENAME' => 93,
			'NUMBER' => 92,
			'LITERAL' => 90,
			'IDENT' => 95,
			"\$" => 101,
			"\${" => 9
		},
		GOTOS => {
			'filepart' => 94,
			'name' => 91,
			'names' => 98,
			'lvalue' => 96,
			'filename' => 97,
			'nameargs' => 103,
			'lnameargs' => 99,
			'item' => 100
		}
	},
	{#State 13
		ACTIONS => {
			'ASSIGN' => 104
		},
		DEFAULT => -113
	},
	{#State 14
		ACTIONS => {
			";" => -21
		},
		DEFAULT => -29
	},
	{#State 15
		DEFAULT => -6
	},
	{#State 16
		DEFAULT => -11
	},
	{#State 17
		ACTIONS => {
			'IDENT' => 105
		},
		DEFAULT => -88,
		GOTOS => {
			'blockargs' => 108,
			'meta' => 106,
			'metadata' => 107
		}
	},
	{#State 18
		DEFAULT => -42
	},
	{#State 19
		DEFAULT => -14
	},
	{#State 20
		ACTIONS => {
			'LITERAL' => 84,
			'IDENT' => 23,
			"\$" => 71,
			"\${" => 9
		},
		GOTOS => {
			'item' => 46,
			'ident' => 83,
			'assign' => 38,
			'node' => 31,
			'setlist' => 109
		}
	},
	{#State 21
		DEFAULT => -13
	},
	{#State 22
		DEFAULT => -12
	},
	{#State 23
		DEFAULT => -131
	},
	{#State 24
		ACTIONS => {
			"\${" => 9,
			'NOT' => 8,
			"{" => 39,
			'REF' => 32,
			'IDENT' => 23,
			"\$" => 71,
			'LITERAL' => 77,
			'NUMBER' => 4,
			"[" => 37,
			"\"" => 73,
			"(" => 36
		},
		GOTOS => {
			'sterm' => 48,
			'node' => 31,
			'expr' => 110,
			'lterm' => 54,
			'item' => 46,
			'ident' => 76,
			'term' => 67
		}
	},
	{#State 25
		DEFAULT => -26
	},
	{#State 26
		ACTIONS => {
			'LITERAL' => 112,
			"\$" => 115,
			'IDENT' => 111,
			"\"" => 113,
			'NUMBER' => 92,
			'FILENAME' => 93
		},
		GOTOS => {
			'nameargs' => 114,
			'names' => 98,
			'filepart' => 94,
			'name' => 91,
			'filename' => 97
		}
	},
	{#State 27
		DEFAULT => -10
	},
	{#State 28
		DEFAULT => -27
	},
	{#State 29
		DEFAULT => -44
	},
	{#State 30
		ACTIONS => {
			"[" => 37,
			'NUMBER' => 4,
			"(" => 36,
			"\"" => 73,
			'IDENT' => 23,
			"\$" => 71,
			'LITERAL' => 77,
			'REF' => 32,
			"\${" => 9,
			'NOT' => 8,
			"{" => 39
		},
		GOTOS => {
			'sterm' => 48,
			'node' => 31,
			'term' => 67,
			'ident' => 76,
			'item' => 46,
			'expr' => 116,
			'lterm' => 54
		}
	},
	{#State 31
		DEFAULT => -128
	},
	{#State 32
		ACTIONS => {
			"\${" => 9,
			"\$" => 71,
			'IDENT' => 23
		},
		GOTOS => {
			'ident' => 117,
			'item' => 46,
			'node' => 31
		}
	},
	{#State 33
		ACTIONS => {
			"\$" => 115,
			'IDENT' => 111,
			'LITERAL' => 112,
			'FILENAME' => 93,
			'NUMBER' => 92,
			"\"" => 113
		},
		GOTOS => {
			'nameargs' => 118,
			'names' => 98,
			'filepart' => 94,
			'name' => 91,
			'filename' => 97
		}
	},
	{#State 34
		DEFAULT => -38
	},
	{#State 35
		DEFAULT => -1
	},
	{#State 36
		ACTIONS => {
			'REF' => 32,
			"{" => 39,
			'NOT' => 8,
			"\${" => 9,
			"\"" => 73,
			"(" => 36,
			"[" => 37,
			'NUMBER' => 4,
			'LITERAL' => 13,
			'IDENT' => 23,
			"\$" => 71
		},
		GOTOS => {
			'node' => 31,
			'ident' => 120,
			'term' => 67,
			'sterm' => 48,
			'assign' => 119,
			'lterm' => 54,
			'expr' => 121,
			'item' => 46
		}
	},
	{#State 37
		ACTIONS => {
			'REF' => 32,
			"\${" => 9,
			"{" => 39,
			'NUMBER' => 4,
			"[" => 37,
			"\"" => 73,
			"]" => 124,
			"\$" => 71,
			'IDENT' => 23,
			'LITERAL' => 77
		},
		GOTOS => {
			'node' => 31,
			'ident' => 76,
			'term' => 122,
			'sterm' => 123,
			'range' => 126,
			'list' => 125,
			'lterm' => 54,
			'item' => 46
		}
	},
	{#State 38
		DEFAULT => -150
	},
	{#State 39
		ACTIONS => {
			"\${" => 9,
			'IDENT' => 23,
			"\$" => 71,
			'LITERAL' => 127
		},
		DEFAULT => -120,
		GOTOS => {
			'param' => 129,
			'hash' => 131,
			'params' => 128,
			'item' => 130
		}
	},
	{#State 40
		DEFAULT => -25
	},
	{#State 41
		ACTIONS => {
			'IDENT' => 105
		},
		GOTOS => {
			'meta' => 106,
			'metadata' => 132
		}
	},
	{#State 42
		ACTIONS => {
			";" => 133
		}
	},
	{#State 43
		ACTIONS => {
			"\$" => 115,
			'IDENT' => 111,
			'LITERAL' => 112,
			'FILENAME' => 93,
			'NUMBER' => 92,
			"\"" => 113
		},
		GOTOS => {
			'filename' => 97,
			'nameargs' => 134,
			'name' => 91,
			'filepart' => 94,
			'names' => 98
		}
	},
	{#State 44
		ACTIONS => {
			"{" => 39,
			'NOT' => 8,
			"\${" => 9,
			'REF' => 32,
			'LITERAL' => 77,
			'IDENT' => 23,
			"\$" => 71,
			"(" => 36,
			"\"" => 73,
			"[" => 37,
			'NUMBER' => 4
		},
		GOTOS => {
			'sterm' => 48,
			'node' => 31,
			'expr' => 135,
			'lterm' => 54,
			'item' => 46,
			'ident' => 76,
			'term' => 67
		}
	},
	{#State 45
		ACTIONS => {
			'IDENT' => 95,
			"\$" => 101,
			"\${" => 9,
			'LITERAL' => 90,
			"\"" => 102,
			'FILENAME' => 93,
			'NUMBER' => 92
		},
		GOTOS => {
			'nameargs' => 103,
			'item' => 100,
			'lnameargs' => 136,
			'lvalue' => 96,
			'filepart' => 94,
			'name' => 91,
			'names' => 98,
			'filename' => 97
		}
	},
	{#State 46
		ACTIONS => {
			"(" => 137
		},
		DEFAULT => -129
	},
	{#State 47
		DEFAULT => -9
	},
	{#State 48
		DEFAULT => -105
	},
	{#State 49
		ACTIONS => {
			'FOR' => 143,
			'UNLESS' => 138,
			'FILTER' => 142,
			'WRAPPER' => 141,
			'WHILE' => 139,
			'IF' => 140
		}
	},
	{#State 50
		ACTIONS => {
			";" => 144
		}
	},
	{#State 51
		ACTIONS => {
			'NUMBER' => 4,
			"[" => 37,
			"\"" => 73,
			"(" => 36,
			'LITERAL' => 77,
			"\$" => 71,
			'IDENT' => 23,
			'REF' => 32,
			"{" => 39,
			"\${" => 9,
			'NOT' => 8
		},
		GOTOS => {
			'item' => 46,
			'ident' => 76,
			'expr' => 145,
			'lterm' => 54,
			'term' => 67,
			'sterm' => 48,
			'node' => 31
		}
	},
	{#State 52
		DEFAULT => -8
	},
	{#State 53
		DEFAULT => -22
	},
	{#State 54
		DEFAULT => -104
	},
	{#State 55
		DEFAULT => -16
	},
	{#State 56
		ACTIONS => {
			'COMMA' => 147,
			'LITERAL' => 84,
			"\${" => 9,
			'IDENT' => 23,
			"\$" => 71
		},
		DEFAULT => -20,
		GOTOS => {
			'item' => 46,
			'ident' => 83,
			'assign' => 146,
			'node' => 31
		}
	},
	{#State 57
		ACTIONS => {
			'DEFAULT' => 7,
			'WHILE' => 51,
			'NOT' => 8,
			"\${" => 9,
			'GET' => 10,
			'FILTER' => 12,
			'PROCESS' => 43,
			'IF' => 44,
			'JAVASCRIPT' => 42,
			'META' => 41,
			'RAW' => 45,
			'STOP' => 5,
			'NUMBER' => 4,
			'FOR' => 3,
			'NEXT' => 18,
			'SET' => 20,
			'WRAPPER' => 58,
			'TRY' => 59,
			'LITERAL' => 13,
			'TEXT' => 15,
			'rawperl' => 55,
			'INCLUDE' => 26,
			'perl' => 28,
			'USE' => 68,
			'CALL' => 30,
			'BLOCK' => 69,
			'REF' => 32,
			'LAST' => 60,
			'IDENT' => 23,
			'DEBUG' => 62,
			'UNLESS' => 63,
			'VIEW' => 64,
			'MACRO' => 66,
			'SWITCH' => 24,
			";" => -19,
			"{" => 39,
			'CLEAR' => 74,
			'INSERT' => 33,
			"\$" => 71,
			'RETURN' => 34,
			'THROW' => 72,
			"(" => 36,
			"\"" => 73,
			"[" => 37
		},
		DEFAULT => -2,
		GOTOS => {
			'item' => 46,
			'defblock' => 47,
			'expr' => 61,
			'use' => 21,
			'macro' => 22,
			'switch' => 2,
			'sterm' => 48,
			'filter' => 65,
			'chunk' => 148,
			'wrapper' => 29,
			'ident' => 11,
			'statement' => 50,
			'atomexpr' => 49,
			'term' => 67,
			'anonblock' => 27,
			'javascript' => 25,
			'node' => 31,
			'condition' => 53,
			'directive' => 52,
			'lterm' => 54,
			'atomdir' => 14,
			'view' => 70,
			'capture' => 16,
			'assign' => 38,
			'setlist' => 56,
			'defblockname' => 17,
			'try' => 40,
			'loop' => 75,
			'raw' => 19
		}
	},
	{#State 58
		ACTIONS => {
			'NUMBER' => 92,
			'FILENAME' => 93,
			"\"" => 113,
			'LITERAL' => 112,
			'IDENT' => 111,
			"\$" => 115
		},
		GOTOS => {
			'filename' => 97,
			'name' => 91,
			'filepart' => 94,
			'names' => 98,
			'nameargs' => 149
		}
	},
	{#State 59
		ACTIONS => {
			";" => 150
		}
	},
	{#State 60
		DEFAULT => -41
	},
	{#State 61
		ACTIONS => {
			";" => -17,
			'MOD' => 152,
			'CAT' => 159,
			'CMPOP' => 157,
			'DIV' => 158,
			'AND' => 160,
			"?" => 153,
			'OR' => 154,
			"+" => 151,
			"/" => 155,
			'BINOP' => 156
		},
		DEFAULT => -28
	},
	{#State 62
		ACTIONS => {
			"\"" => 113,
			'FILENAME' => 93,
			'NUMBER' => 92,
			'LITERAL' => 112,
			"\$" => 115,
			'IDENT' => 111
		},
		GOTOS => {
			'nameargs' => 161,
			'filepart' => 94,
			'name' => 91,
			'names' => 98,
			'filename' => 97
		}
	},
	{#State 63
		ACTIONS => {
			'REF' => 32,
			"{" => 39,
			"\${" => 9,
			'NOT' => 8,
			'NUMBER' => 4,
			"[" => 37,
			"(" => 36,
			"\"" => 73,
			'LITERAL' => 77,
			'IDENT' => 23,
			"\$" => 71
		},
		GOTOS => {
			'term' => 67,
			'expr' => 162,
			'lterm' => 54,
			'item' => 46,
			'ident' => 76,
			'node' => 31,
			'sterm' => 48
		}
	},
	{#State 64
		ACTIONS => {
			"\"" => 113,
			'NUMBER' => 92,
			'FILENAME' => 93,
			"\$" => 115,
			'IDENT' => 111,
			'LITERAL' => 112
		},
		GOTOS => {
			'filename' => 97,
			'nameargs' => 163,
			'names' => 98,
			'name' => 91,
			'filepart' => 94
		}
	},
	{#State 65
		DEFAULT => -45
	},
	{#State 66
		ACTIONS => {
			'IDENT' => 164
		}
	},
	{#State 67
		DEFAULT => -147
	},
	{#State 68
		ACTIONS => {
			'LITERAL' => 90,
			"\${" => 9,
			"\$" => 101,
			'IDENT' => 95,
			'NUMBER' => 92,
			'FILENAME' => 93,
			"\"" => 102
		},
		GOTOS => {
			'nameargs' => 103,
			'item' => 100,
			'lnameargs' => 165,
			'lvalue' => 96,
			'filepart' => 94,
			'name' => 91,
			'names' => 98,
			'filename' => 97
		}
	},
	{#State 69
		ACTIONS => {
			'FILENAME' => 93,
			'NUMBER' => 92,
			'IDENT' => 167,
			'LITERAL' => 168
		},
		DEFAULT => -88,
		GOTOS => {
			'meta' => 106,
			'metadata' => 107,
			'filename' => 170,
			'blockname' => 166,
			'filepart' => 94,
			'blockargs' => 169
		}
	},
	{#State 70
		DEFAULT => -15
	},
	{#State 71
		ACTIONS => {
			'IDENT' => 171
		}
	},
	{#State 72
		ACTIONS => {
			'NUMBER' => 92,
			'FILENAME' => 93,
			"\"" => 113,
			'LITERAL' => 112,
			'IDENT' => 111,
			"\$" => 115
		},
		GOTOS => {
			'filename' => 97,
			'nameargs' => 172,
			'name' => 91,
			'filepart' => 94,
			'names' => 98
		}
	},
	{#State 73
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 173
		}
	},
	{#State 74
		DEFAULT => -40
	},
	{#State 75
		DEFAULT => -24
	},
	{#State 76
		ACTIONS => {
			'DOT' => 89
		},
		DEFAULT => -110
	},
	{#State 77
		DEFAULT => -113
	},
	{#State 78
		ACTIONS => {
			'ASSIGN' => 174,
			'IN' => 175
		},
		DEFAULT => -131
	},
	{#State 79
		DEFAULT => -157,
		GOTOS => {
			'args' => 176
		}
	},
	{#State 80
		ACTIONS => {
			";" => 177
		}
	},
	{#State 81
		DEFAULT => 0
	},
	{#State 82
		ACTIONS => {
			'COMMA' => 147,
			"\${" => 9,
			'LITERAL' => 84,
			'IDENT' => 23,
			"\$" => 71
		},
		DEFAULT => -33,
		GOTOS => {
			'assign' => 146,
			'node' => 31,
			'ident' => 83,
			'item' => 46
		}
	},
	{#State 83
		ACTIONS => {
			'DOT' => 89,
			'ASSIGN' => 178
		}
	},
	{#State 84
		ACTIONS => {
			'ASSIGN' => 104
		}
	},
	{#State 85
		ACTIONS => {
			"/" => 155,
			'BINOP' => 156,
			'CAT' => 159,
			'MOD' => 152,
			"+" => 151,
			'DIV' => 158,
			'CMPOP' => 157
		},
		DEFAULT => -143
	},
	{#State 86
		ACTIONS => {
			"}" => 179
		}
	},
	{#State 87
		ACTIONS => {
			'CMPOP' => 157,
			'CAT' => 159,
			'MOD' => 152,
			"/" => 155,
			'BINOP' => 156,
			"+" => 151,
			'OR' => 154,
			"?" => 153,
			'AND' => 160,
			'DIV' => 158
		},
		DEFAULT => -30
	},
	{#State 88
		ACTIONS => {
			'LITERAL' => 13,
			'WRAPPER' => 58,
			'TRY' => 59,
			'SET' => 20,
			'NEXT' => 18,
			'FOR' => 3,
			'NUMBER' => 4,
			'STOP' => 5,
			'IF' => 44,
			'PROCESS' => 43,
			'JAVASCRIPT' => 42,
			'FILTER' => 12,
			'DEFAULT' => 7,
			"\${" => 9,
			'GET' => 10,
			'WHILE' => 51,
			'NOT' => 8,
			'THROW' => 72,
			'RETURN' => 34,
			"[" => 37,
			"(" => 36,
			"\"" => 73,
			'INSERT' => 33,
			"\$" => 71,
			"{" => 39,
			'CLEAR' => 74,
			'UNLESS' => 63,
			'SWITCH' => 24,
			'LAST' => 60,
			'DEBUG' => 62,
			'IDENT' => 23,
			'CALL' => 30,
			'REF' => 32,
			'BLOCK' => 181,
			'INCLUDE' => 26,
			'perl' => 28
		},
		GOTOS => {
			'mdir' => 182,
			'expr' => 183,
			'item' => 46,
			'filter' => 65,
			'sterm' => 48,
			'switch' => 2,
			'javascript' => 25,
			'term' => 67,
			'atomexpr' => 49,
			'wrapper' => 29,
			'ident' => 120,
			'directive' => 180,
			'condition' => 53,
			'node' => 31,
			'atomdir' => 14,
			'lterm' => 54,
			'setlist' => 56,
			'assign' => 38,
			'try' => 40,
			'loop' => 75
		}
	},
	{#State 89
		ACTIONS => {
			'IDENT' => 23,
			"\$" => 71,
			"\${" => 9,
			'NUMBER' => 185
		},
		GOTOS => {
			'node' => 184,
			'item' => 46
		}
	},
	{#State 90
		ACTIONS => {
			'ASSIGN' => -162
		},
		DEFAULT => -170
	},
	{#State 91
		DEFAULT => -167
	},
	{#State 92
		DEFAULT => -175
	},
	{#State 93
		DEFAULT => -173
	},
	{#State 94
		DEFAULT => -172
	},
	{#State 95
		ACTIONS => {
			'ASSIGN' => -131
		},
		DEFAULT => -174
	},
	{#State 96
		ACTIONS => {
			'ASSIGN' => 186
		}
	},
	{#State 97
		ACTIONS => {
			'DOT' => 187
		},
		DEFAULT => -169
	},
	{#State 98
		ACTIONS => {
			"+" => 189,
			"(" => 188
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 190
		}
	},
	{#State 99
		ACTIONS => {
			";" => 191
		}
	},
	{#State 100
		DEFAULT => -160
	},
	{#State 101
		ACTIONS => {
			'IDENT' => 193,
			"\$" => 71,
			"\${" => 9
		},
		GOTOS => {
			'item' => 46,
			'ident' => 192,
			'node' => 31
		}
	},
	{#State 102
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 194
		}
	},
	{#State 103
		DEFAULT => -159
	},
	{#State 104
		ACTIONS => {
			"(" => 36,
			"\"" => 73,
			'NUMBER' => 4,
			"[" => 37,
			'LITERAL' => 77,
			"\$" => 71,
			'IDENT' => 23,
			'REF' => 32,
			"{" => 39,
			'NOT' => 8,
			"\${" => 9
		},
		GOTOS => {
			'term' => 67,
			'ident' => 76,
			'item' => 46,
			'expr' => 195,
			'lterm' => 54,
			'sterm' => 48,
			'node' => 31
		}
	},
	{#State 105
		ACTIONS => {
			'ASSIGN' => 196
		}
	},
	{#State 106
		DEFAULT => -100
	},
	{#State 107
		ACTIONS => {
			'COMMA' => 198,
			'IDENT' => 105
		},
		DEFAULT => -87,
		GOTOS => {
			'meta' => 197
		}
	},
	{#State 108
		ACTIONS => {
			";" => 199
		}
	},
	{#State 109
		ACTIONS => {
			"\${" => 9,
			'COMMA' => 147,
			'LITERAL' => 84,
			'IDENT' => 23,
			"\$" => 71
		},
		DEFAULT => -32,
		GOTOS => {
			'node' => 31,
			'assign' => 146,
			'item' => 46,
			'ident' => 83
		}
	},
	{#State 110
		ACTIONS => {
			'AND' => 160,
			'DIV' => 158,
			'OR' => 154,
			"?" => 153,
			"+" => 151,
			'CAT' => 159,
			'MOD' => 152,
			";" => 200,
			'CMPOP' => 157,
			'BINOP' => 156,
			"/" => 155
		}
	},
	{#State 111
		DEFAULT => -174
	},
	{#State 112
		DEFAULT => -170
	},
	{#State 113
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 201
		}
	},
	{#State 114
		DEFAULT => -35
	},
	{#State 115
		ACTIONS => {
			"\${" => 9,
			"\$" => 71,
			'IDENT' => 23
		},
		GOTOS => {
			'node' => 31,
			'item' => 46,
			'ident' => 192
		}
	},
	{#State 116
		ACTIONS => {
			'CAT' => 159,
			'MOD' => 152,
			'CMPOP' => 157,
			'AND' => 160,
			'DIV' => 158,
			"?" => 153,
			'OR' => 154,
			"+" => 151,
			'BINOP' => 156,
			"/" => 155
		},
		DEFAULT => -31
	},
	{#State 117
		ACTIONS => {
			'DOT' => 89
		},
		DEFAULT => -111
	},
	{#State 118
		DEFAULT => -34
	},
	{#State 119
		ACTIONS => {
			")" => 202
		}
	},
	{#State 120
		ACTIONS => {
			'ASSIGN' => 178,
			'DOT' => 89
		},
		DEFAULT => -110
	},
	{#State 121
		ACTIONS => {
			'CMPOP' => 157,
			")" => 203,
			"/" => 155,
			'BINOP' => 156,
			'CAT' => 159,
			'MOD' => 152,
			"+" => 151,
			"?" => 153,
			'OR' => 154,
			'AND' => 160,
			'DIV' => 158
		}
	},
	{#State 122
		DEFAULT => -117
	},
	{#State 123
		ACTIONS => {
			'TO' => 204
		},
		DEFAULT => -105
	},
	{#State 124
		DEFAULT => -108
	},
	{#State 125
		ACTIONS => {
			'LITERAL' => 77,
			"]" => 206,
			'IDENT' => 23,
			"\$" => 71,
			"[" => 37,
			'NUMBER' => 4,
			"\"" => 73,
			"{" => 39,
			"\${" => 9,
			'COMMA' => 207,
			'REF' => 32
		},
		GOTOS => {
			'term' => 205,
			'lterm' => 54,
			'item' => 46,
			'ident' => 76,
			'node' => 31,
			'sterm' => 48
		}
	},
	{#State 126
		ACTIONS => {
			"]" => 208
		}
	},
	{#State 127
		ACTIONS => {
			'ASSIGN' => 209
		}
	},
	{#State 128
		ACTIONS => {
			'LITERAL' => 127,
			"\${" => 9,
			"\$" => 71,
			'IDENT' => 23,
			'COMMA' => 210
		},
		DEFAULT => -119,
		GOTOS => {
			'item' => 130,
			'param' => 211
		}
	},
	{#State 129
		DEFAULT => -123
	},
	{#State 130
		ACTIONS => {
			'ASSIGN' => 212
		}
	},
	{#State 131
		ACTIONS => {
			"}" => 213
		}
	},
	{#State 132
		ACTIONS => {
			'IDENT' => 105,
			'COMMA' => 198
		},
		DEFAULT => -18,
		GOTOS => {
			'meta' => 197
		}
	},
	{#State 133
		DEFAULT => -79,
		GOTOS => {
			'@4-2' => 214
		}
	},
	{#State 134
		DEFAULT => -36
	},
	{#State 135
		ACTIONS => {
			'DIV' => 158,
			'AND' => 160,
			"?" => 153,
			"+" => 151,
			'OR' => 154,
			";" => 215,
			'MOD' => 152,
			'CAT' => 159,
			"/" => 155,
			'BINOP' => 156,
			'CMPOP' => 157
		}
	},
	{#State 136
		DEFAULT => -76
	},
	{#State 137
		DEFAULT => -157,
		GOTOS => {
			'args' => 216
		}
	},
	{#State 138
		ACTIONS => {
			"\${" => 9,
			'NOT' => 8,
			"{" => 39,
			'REF' => 32,
			"\$" => 71,
			'IDENT' => 23,
			'LITERAL' => 77,
			'NUMBER' => 4,
			"[" => 37,
			"(" => 36,
			"\"" => 73
		},
		GOTOS => {
			'node' => 31,
			'sterm' => 48,
			'term' => 67,
			'item' => 46,
			'ident' => 76,
			'lterm' => 54,
			'expr' => 217
		}
	},
	{#State 139
		ACTIONS => {
			'REF' => 32,
			"{" => 39,
			'NOT' => 8,
			"\${" => 9,
			"(" => 36,
			"\"" => 73,
			'NUMBER' => 4,
			"[" => 37,
			'LITERAL' => 77,
			'IDENT' => 23,
			"\$" => 71
		},
		GOTOS => {
			'sterm' => 48,
			'node' => 31,
			'lterm' => 54,
			'expr' => 218,
			'item' => 46,
			'ident' => 76,
			'term' => 67
		}
	},
	{#State 140
		ACTIONS => {
			"\${" => 9,
			'NOT' => 8,
			"{" => 39,
			'REF' => 32,
			'IDENT' => 23,
			"\$" => 71,
			'LITERAL' => 77,
			'NUMBER' => 4,
			"[" => 37,
			"\"" => 73,
			"(" => 36
		},
		GOTOS => {
			'term' => 67,
			'item' => 46,
			'ident' => 76,
			'expr' => 219,
			'lterm' => 54,
			'node' => 31,
			'sterm' => 48
		}
	},
	{#State 141
		ACTIONS => {
			"\"" => 113,
			'NUMBER' => 92,
			'FILENAME' => 93,
			'LITERAL' => 112,
			'IDENT' => 111,
			"\$" => 115
		},
		GOTOS => {
			'nameargs' => 220,
			'filepart' => 94,
			'name' => 91,
			'names' => 98,
			'filename' => 97
		}
	},
	{#State 142
		ACTIONS => {
			'IDENT' => 95,
			"\$" => 101,
			"\${" => 9,
			'LITERAL' => 90,
			"\"" => 102,
			'FILENAME' => 93,
			'NUMBER' => 92
		},
		GOTOS => {
			'lvalue' => 96,
			'filepart' => 94,
			'name' => 91,
			'names' => 98,
			'filename' => 97,
			'nameargs' => 103,
			'item' => 100,
			'lnameargs' => 221
		}
	},
	{#State 143
		ACTIONS => {
			'REF' => 32,
			"\${" => 9,
			"{" => 39,
			"[" => 37,
			'NUMBER' => 4,
			"\"" => 73,
			'IDENT' => 78,
			"\$" => 71,
			'LITERAL' => 77
		},
		GOTOS => {
			'loopvar' => 222,
			'sterm' => 48,
			'node' => 31,
			'term' => 79,
			'item' => 46,
			'ident' => 76,
			'lterm' => 54
		}
	},
	{#State 144
		DEFAULT => -7
	},
	{#State 145
		ACTIONS => {
			"/" => 155,
			'BINOP' => 156,
			'CMPOP' => 157,
			";" => 223,
			'MOD' => 152,
			'CAT' => 159,
			"+" => 151,
			"?" => 153,
			'OR' => 154,
			'DIV' => 158,
			'AND' => 160
		}
	},
	{#State 146
		DEFAULT => -148
	},
	{#State 147
		DEFAULT => -149
	},
	{#State 148
		DEFAULT => -4
	},
	{#State 149
		ACTIONS => {
			";" => 224
		}
	},
	{#State 150
		ACTIONS => {
			'rawperl' => 55,
			'TEXT' => 15,
			'LITERAL' => 13,
			'TRY' => 59,
			'WRAPPER' => 58,
			'SET' => 20,
			'NEXT' => 18,
			'NUMBER' => 4,
			'STOP' => 5,
			'FOR' => 3,
			'RAW' => 45,
			'PROCESS' => 43,
			'META' => 41,
			'IF' => 44,
			'JAVASCRIPT' => 42,
			'FILTER' => 12,
			"\${" => 9,
			'GET' => 10,
			'NOT' => 8,
			'WHILE' => 51,
			'DEFAULT' => 7,
			"[" => 37,
			"(" => 36,
			"\"" => 73,
			'THROW' => 72,
			'RETURN' => 34,
			"\$" => 71,
			'INSERT' => 33,
			'CLEAR' => 74,
			"{" => 39,
			";" => -19,
			'SWITCH' => 24,
			'MACRO' => 66,
			'VIEW' => 64,
			'UNLESS' => 63,
			'IDENT' => 23,
			'DEBUG' => 62,
			'LAST' => 60,
			'REF' => 32,
			'BLOCK' => 69,
			'CALL' => 30,
			'USE' => 68,
			'perl' => 28,
			'INCLUDE' => 26
		},
		DEFAULT => -3,
		GOTOS => {
			'raw' => 19,
			'loop' => 75,
			'try' => 40,
			'defblockname' => 17,
			'chunks' => 57,
			'block' => 225,
			'setlist' => 56,
			'capture' => 16,
			'assign' => 38,
			'view' => 70,
			'lterm' => 54,
			'atomdir' => 14,
			'condition' => 53,
			'directive' => 52,
			'node' => 31,
			'javascript' => 25,
			'term' => 67,
			'atomexpr' => 49,
			'anonblock' => 27,
			'statement' => 50,
			'wrapper' => 29,
			'ident' => 11,
			'filter' => 65,
			'chunk' => 1,
			'sterm' => 48,
			'switch' => 2,
			'use' => 21,
			'macro' => 22,
			'expr' => 61,
			'item' => 46,
			'defblock' => 47
		}
	},
	{#State 151
		ACTIONS => {
			'LITERAL' => 77,
			"\$" => 71,
			'IDENT' => 23,
			'NUMBER' => 4,
			"[" => 37,
			"(" => 36,
			"\"" => 73,
			"{" => 39,
			"\${" => 9,
			'NOT' => 8,
			'REF' => 32
		},
		GOTOS => {
			'ident' => 76,
			'item' => 46,
			'expr' => 226,
			'lterm' => 54,
			'term' => 67,
			'sterm' => 48,
			'node' => 31
		}
	},
	{#State 152
		ACTIONS => {
			"{" => 39,
			"\${" => 9,
			'NOT' => 8,
			'REF' => 32,
			'LITERAL' => 77,
			'IDENT' => 23,
			"\$" => 71,
			"[" => 37,
			'NUMBER' => 4,
			"\"" => 73,
			"(" => 36
		},
		GOTOS => {
			'node' => 31,
			'sterm' => 48,
			'term' => 67,
			'item' => 46,
			'ident' => 76,
			'lterm' => 54,
			'expr' => 227
		}
	},
	{#State 153
		ACTIONS => {
			"\$" => 71,
			'IDENT' => 23,
			'LITERAL' => 77,
			'NUMBER' => 4,
			"[" => 37,
			"(" => 36,
			"\"" => 73,
			"\${" => 9,
			'NOT' => 8,
			"{" => 39,
			'REF' => 32
		},
		GOTOS => {
			'expr' => 228,
			'lterm' => 54,
			'item' => 46,
			'ident' => 76,
			'term' => 67,
			'sterm' => 48,
			'node' => 31
		}
	},
	{#State 154
		ACTIONS => {
			"(" => 36,
			"\"" => 73,
			'NUMBER' => 4,
			"[" => 37,
			"\$" => 71,
			'IDENT' => 23,
			'LITERAL' => 77,
			'REF' => 32,
			'NOT' => 8,
			"\${" => 9,
			"{" => 39
		},
		GOTOS => {
			'sterm' => 48,
			'node' => 31,
			'term' => 67,
			'ident' => 76,
			'item' => 46,
			'expr' => 229,
			'lterm' => 54
		}
	},
	{#State 155
		ACTIONS => {
			"(" => 36,
			"\"" => 73,
			'NUMBER' => 4,
			"[" => 37,
			'IDENT' => 23,
			"\$" => 71,
			'LITERAL' => 77,
			'REF' => 32,
			'NOT' => 8,
			"\${" => 9,
			"{" => 39
		},
		GOTOS => {
			'expr' => 230,
			'lterm' => 54,
			'ident' => 76,
			'item' => 46,
			'term' => 67,
			'node' => 31,
			'sterm' => 48
		}
	},
	{#State 156
		ACTIONS => {
			"\"" => 73,
			"(" => 36,
			"[" => 37,
			'NUMBER' => 4,
			"\$" => 71,
			'IDENT' => 23,
			'LITERAL' => 77,
			'REF' => 32,
			'NOT' => 8,
			"\${" => 9,
			"{" => 39
		},
		GOTOS => {
			'term' => 67,
			'ident' => 76,
			'item' => 46,
			'lterm' => 54,
			'expr' => 231,
			'sterm' => 48,
			'node' => 31
		}
	},
	{#State 157
		ACTIONS => {
			'REF' => 32,
			'NOT' => 8,
			"\${" => 9,
			"{" => 39,
			"(" => 36,
			"\"" => 73,
			"[" => 37,
			'NUMBER' => 4,
			"\$" => 71,
			'IDENT' => 23,
			'LITERAL' => 77
		},
		GOTOS => {
			'node' => 31,
			'sterm' => 48,
			'term' => 67,
			'item' => 46,
			'ident' => 76,
			'expr' => 232,
			'lterm' => 54
		}
	},
	{#State 158
		ACTIONS => {
			'REF' => 32,
			"{" => 39,
			'NOT' => 8,
			"\${" => 9,
			"(" => 36,
			"\"" => 73,
			"[" => 37,
			'NUMBER' => 4,
			'LITERAL' => 77,
			'IDENT' => 23,
			"\$" => 71
		},
		GOTOS => {
			'term' => 67,
			'expr' => 233,
			'lterm' => 54,
			'ident' => 76,
			'item' => 46,
			'sterm' => 48,
			'node' => 31
		}
	},
	{#State 159
		ACTIONS => {
			"\${" => 9,
			'NOT' => 8,
			"{" => 39,
			'REF' => 32,
			'IDENT' => 23,
			"\$" => 71,
			'LITERAL' => 77,
			'NUMBER' => 4,
			"[" => 37,
			"(" => 36,
			"\"" => 73
		},
		GOTOS => {
			'node' => 31,
			'sterm' => 48,
			'lterm' => 54,
			'expr' => 234,
			'item' => 46,
			'ident' => 76,
			'term' => 67
		}
	},
	{#State 160
		ACTIONS => {
			'REF' => 32,
			"{" => 39,
			"\${" => 9,
			'NOT' => 8,
			"[" => 37,
			'NUMBER' => 4,
			"(" => 36,
			"\"" => 73,
			'LITERAL' => 77,
			'IDENT' => 23,
			"\$" => 71
		},
		GOTOS => {
			'node' => 31,
			'sterm' => 48,
			'term' => 67,
			'lterm' => 54,
			'expr' => 235,
			'ident' => 76,
			'item' => 46
		}
	},
	{#State 161
		DEFAULT => -43
	},
	{#State 162
		ACTIONS => {
			'CAT' => 159,
			";" => 236,
			'MOD' => 152,
			'CMPOP' => 157,
			"/" => 155,
			'BINOP' => 156,
			'AND' => 160,
			'DIV' => 158,
			"?" => 153,
			"+" => 151,
			'OR' => 154
		}
	},
	{#State 163
		ACTIONS => {
			";" => 237
		}
	},
	{#State 164
		ACTIONS => {
			'FILTER' => 12,
			'DEFAULT' => 7,
			'NOT' => 8,
			'WHILE' => 51,
			"\${" => 9,
			'GET' => 10,
			'FOR' => 3,
			'STOP' => 5,
			'NUMBER' => 4,
			'JAVASCRIPT' => 42,
			'IF' => 44,
			'PROCESS' => 43,
			'SET' => 20,
			'WRAPPER' => 58,
			'TRY' => 59,
			'NEXT' => 18,
			'LITERAL' => 13,
			'CALL' => 30,
			'BLOCK' => 181,
			'REF' => 32,
			'INCLUDE' => 26,
			'perl' => 28,
			'UNLESS' => 63,
			'SWITCH' => 24,
			'LAST' => 60,
			'DEBUG' => 62,
			'IDENT' => 23,
			"{" => 39,
			'CLEAR' => 74,
			'RETURN' => 34,
			'THROW' => 72,
			"(" => 240,
			"\"" => 73,
			"[" => 37,
			'INSERT' => 33,
			"\$" => 71
		},
		GOTOS => {
			'try' => 40,
			'loop' => 75,
			'setlist' => 56,
			'assign' => 38,
			'atomdir' => 14,
			'lterm' => 54,
			'node' => 31,
			'directive' => 180,
			'condition' => 53,
			'ident' => 120,
			'wrapper' => 29,
			'javascript' => 25,
			'atomexpr' => 49,
			'term' => 67,
			'sterm' => 48,
			'switch' => 2,
			'filter' => 65,
			'expr' => 239,
			'mdir' => 238,
			'item' => 46
		}
	},
	{#State 165
		DEFAULT => -75
	},
	{#State 166
		DEFAULT => -84
	},
	{#State 167
		ACTIONS => {
			'ASSIGN' => 196
		},
		DEFAULT => -174
	},
	{#State 168
		DEFAULT => -86
	},
	{#State 169
		ACTIONS => {
			";" => 241
		}
	},
	{#State 170
		ACTIONS => {
			'DOT' => 187
		},
		DEFAULT => -85
	},
	{#State 171
		DEFAULT => -133
	},
	{#State 172
		DEFAULT => -37
	},
	{#State 173
		ACTIONS => {
			"\"" => 242,
			";" => 243,
			'TEXT' => 246,
			'IDENT' => 23,
			"\$" => 71,
			"\${" => 9
		},
		GOTOS => {
			'quotable' => 244,
			'node' => 31,
			'ident' => 245,
			'item' => 46
		}
	},
	{#State 174
		ACTIONS => {
			"\${" => 9,
			"{" => 39,
			'REF' => 32,
			'IDENT' => 23,
			"\$" => 71,
			'LITERAL' => 77,
			"[" => 37,
			'NUMBER' => 4,
			"\"" => 73
		},
		GOTOS => {
			'term' => 247,
			'lterm' => 54,
			'ident' => 76,
			'item' => 46,
			'node' => 31,
			'sterm' => 48
		}
	},
	{#State 175
		ACTIONS => {
			'LITERAL' => 77,
			"\$" => 71,
			'IDENT' => 23,
			"[" => 37,
			'NUMBER' => 4,
			"\"" => 73,
			"{" => 39,
			"\${" => 9,
			'REF' => 32
		},
		GOTOS => {
			'lterm' => 54,
			'ident' => 76,
			'item' => 46,
			'term' => 248,
			'sterm' => 48,
			'node' => 31
		}
	},
	{#State 176
		ACTIONS => {
			"{" => 39,
			"\${" => 9,
			'NOT' => 8,
			'COMMA' => 252,
			'REF' => 32,
			'LITERAL' => 251,
			"\$" => 71,
			'IDENT' => 23,
			'NUMBER' => 4,
			"[" => 37,
			"(" => 36,
			"\"" => 73
		},
		DEFAULT => -66,
		GOTOS => {
			'node' => 31,
			'term' => 67,
			'ident' => 254,
			'param' => 253,
			'sterm' => 48,
			'expr' => 249,
			'lterm' => 54,
			'item' => 250
		}
	},
	{#State 177
		DEFAULT => -58,
		GOTOS => {
			'@1-3' => 255
		}
	},
	{#State 178
		ACTIONS => {
			"(" => 36,
			"\"" => 73,
			'NUMBER' => 4,
			"[" => 37,
			'LITERAL' => 77,
			'IDENT' => 23,
			"\$" => 71,
			'REF' => 32,
			"{" => 39,
			'NOT' => 8,
			"\${" => 9
		},
		GOTOS => {
			'term' => 67,
			'ident' => 76,
			'item' => 46,
			'expr' => 256,
			'lterm' => 54,
			'node' => 31,
			'sterm' => 48
		}
	},
	{#State 179
		DEFAULT => -132
	},
	{#State 180
		DEFAULT => -93
	},
	{#State 181
		ACTIONS => {
			";" => 257
		}
	},
	{#State 182
		DEFAULT => -90
	},
	{#State 183
		ACTIONS => {
			"\${" => -151,
			'IDENT' => -151,
			'CMPOP' => 157,
			'MOD' => 152,
			";" => -151,
			'CAT' => 159,
			"+" => 151,
			'OR' => 154,
			"?" => 153,
			'DIV' => 158,
			'AND' => 160,
			'COMMA' => -151,
			"\$" => -151,
			"/" => 155,
			'BINOP' => 156,
			'LITERAL' => -151
		},
		DEFAULT => -28
	},
	{#State 184
		DEFAULT => -126
	},
	{#State 185
		DEFAULT => -127
	},
	{#State 186
		ACTIONS => {
			'NUMBER' => 92,
			'FILENAME' => 93,
			"\"" => 113,
			'IDENT' => 111,
			"\$" => 115,
			'LITERAL' => 112
		},
		GOTOS => {
			'filename' => 97,
			'nameargs' => 258,
			'filepart' => 94,
			'name' => 91,
			'names' => 98
		}
	},
	{#State 187
		ACTIONS => {
			'NUMBER' => 92,
			'FILENAME' => 93,
			'IDENT' => 111
		},
		GOTOS => {
			'filepart' => 259
		}
	},
	{#State 188
		DEFAULT => -157,
		GOTOS => {
			'args' => 260
		}
	},
	{#State 189
		ACTIONS => {
			'LITERAL' => 112,
			'IDENT' => 111,
			'FILENAME' => 93,
			'NUMBER' => 92,
			"\"" => 113
		},
		GOTOS => {
			'filepart' => 94,
			'name' => 261,
			'filename' => 97
		}
	},
	{#State 190
		ACTIONS => {
			"\${" => 9,
			'NOT' => 8,
			'REF' => 32,
			'IDENT' => 23,
			'NUMBER' => 4,
			"{" => 39,
			'COMMA' => 252,
			"\$" => 71,
			'LITERAL' => 251,
			"[" => 37,
			"\"" => 73,
			"(" => 36
		},
		DEFAULT => -164,
		GOTOS => {
			'ident' => 254,
			'term' => 67,
			'node' => 31,
			'item' => 250,
			'expr' => 249,
			'lterm' => 54,
			'sterm' => 48,
			'param' => 253
		}
	},
	{#State 191
		ACTIONS => {
			'FILTER' => 12,
			'DEFAULT' => 7,
			"\${" => 9,
			'GET' => 10,
			'NOT' => 8,
			'WHILE' => 51,
			'FOR' => 3,
			'NUMBER' => 4,
			'STOP' => 5,
			'META' => 41,
			'PROCESS' => 43,
			'IF' => 44,
			'JAVASCRIPT' => 42,
			'RAW' => 45,
			'TRY' => 59,
			'WRAPPER' => 58,
			'SET' => 20,
			'NEXT' => 18,
			'rawperl' => 55,
			'LITERAL' => 13,
			'TEXT' => 15,
			'CALL' => 30,
			'REF' => 32,
			'BLOCK' => 69,
			'INCLUDE' => 26,
			'USE' => 68,
			'perl' => 28,
			'MACRO' => 66,
			'UNLESS' => 63,
			'VIEW' => 64,
			";" => -19,
			'SWITCH' => 24,
			'LAST' => 60,
			'DEBUG' => 62,
			'IDENT' => 23,
			"{" => 39,
			'CLEAR' => 74,
			'THROW' => 72,
			'RETURN' => 34,
			"[" => 37,
			"\"" => 73,
			"(" => 36,
			'INSERT' => 33,
			"\$" => 71
		},
		DEFAULT => -3,
		GOTOS => {
			'view' => 70,
			'lterm' => 54,
			'atomdir' => 14,
			'block' => 262,
			'capture' => 16,
			'assign' => 38,
			'setlist' => 56,
			'defblockname' => 17,
			'chunks' => 57,
			'raw' => 19,
			'try' => 40,
			'loop' => 75,
			'macro' => 22,
			'use' => 21,
			'defblock' => 47,
			'item' => 46,
			'expr' => 61,
			'chunk' => 1,
			'filter' => 65,
			'sterm' => 48,
			'switch' => 2,
			'atomexpr' => 49,
			'anonblock' => 27,
			'term' => 67,
			'javascript' => 25,
			'wrapper' => 29,
			'ident' => 11,
			'statement' => 50,
			'condition' => 53,
			'directive' => 52,
			'node' => 31
		}
	},
	{#State 192
		ACTIONS => {
			'DOT' => 89
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 263
		}
	},
	{#State 193
		ACTIONS => {
			'ASSIGN' => -133
		},
		DEFAULT => -131
	},
	{#State 194
		ACTIONS => {
			";" => 243,
			"\"" => 264,
			"\${" => 9,
			'TEXT' => 246,
			"\$" => 71,
			'IDENT' => 23
		},
		GOTOS => {
			'node' => 31,
			'quotable' => 244,
			'item' => 46,
			'ident' => 245
		}
	},
	{#State 195
		ACTIONS => {
			"/" => 155,
			'BINOP' => 156,
			'DIV' => 158,
			'AND' => 160,
			"+" => 151,
			"?" => 153,
			'OR' => 154,
			'MOD' => 152,
			'CAT' => 159,
			'CMPOP' => 157
		},
		DEFAULT => -152
	},
	{#State 196
		ACTIONS => {
			'LITERAL' => 267,
			"\"" => 265,
			'NUMBER' => 266
		}
	},
	{#State 197
		DEFAULT => -98
	},
	{#State 198
		DEFAULT => -99
	},
	{#State 199
		ACTIONS => {
			'CLEAR' => 74,
			"{" => 39,
			"[" => 37,
			"(" => 36,
			"\"" => 73,
			'THROW' => 72,
			'RETURN' => 34,
			"\$" => 71,
			'INSERT' => 33,
			'REF' => 32,
			'BLOCK' => 69,
			'CALL' => 30,
			'USE' => 68,
			'perl' => 28,
			'INCLUDE' => 26,
			";" => -19,
			'SWITCH' => 24,
			'MACRO' => 66,
			'VIEW' => 64,
			'UNLESS' => 63,
			'DEBUG' => 62,
			'IDENT' => 23,
			'LAST' => 60,
			'WRAPPER' => 58,
			'TRY' => 59,
			'SET' => 20,
			'NEXT' => 18,
			'rawperl' => 55,
			'TEXT' => 15,
			'LITERAL' => 13,
			'FILTER' => 12,
			'GET' => 10,
			"\${" => 9,
			'WHILE' => 51,
			'NOT' => 8,
			'DEFAULT' => 7,
			'FOR' => 3,
			'NUMBER' => 4,
			'STOP' => 5,
			'RAW' => 45,
			'META' => 41,
			'JAVASCRIPT' => 42,
			'PROCESS' => 43,
			'IF' => 44
		},
		DEFAULT => -3,
		GOTOS => {
			'view' => 70,
			'block' => 35,
			'assign' => 38,
			'try' => 40,
			'loop' => 75,
			'use' => 21,
			'macro' => 22,
			'expr' => 61,
			'filter' => 65,
			'term' => 67,
			'anonblock' => 27,
			'javascript' => 25,
			'wrapper' => 29,
			'node' => 31,
			'lterm' => 54,
			'atomdir' => 14,
			'capture' => 16,
			'setlist' => 56,
			'defblockname' => 17,
			'chunks' => 57,
			'raw' => 19,
			'defblock' => 47,
			'item' => 46,
			'chunk' => 1,
			'switch' => 2,
			'sterm' => 48,
			'atomexpr' => 49,
			'template' => 268,
			'ident' => 11,
			'statement' => 50,
			'directive' => 52,
			'condition' => 53
		}
	},
	{#State 200
		ACTIONS => {
			'LITERAL' => 13,
			'TEXT' => 15,
			'rawperl' => 55,
			'NEXT' => 18,
			'TRY' => 59,
			'WRAPPER' => 58,
			'SET' => 20,
			'PROCESS' => 43,
			'JAVASCRIPT' => 42,
			'IF' => 44,
			'META' => 41,
			'RAW' => 45,
			'FOR' => 3,
			'STOP' => 5,
			'NUMBER' => 4,
			'DEFAULT' => 7,
			'GET' => 10,
			"\${" => 9,
			'NOT' => 8,
			'WHILE' => 51,
			'FILTER' => 12,
			'INSERT' => 33,
			"\$" => 71,
			'THROW' => 72,
			'RETURN' => 34,
			"[" => 37,
			"\"" => 73,
			"(" => 36,
			"{" => 39,
			'CLEAR' => 74,
			'LAST' => 60,
			'DEBUG' => 62,
			'IDENT' => 23,
			'MACRO' => 66,
			'UNLESS' => 63,
			'VIEW' => 64,
			";" => -19,
			'SWITCH' => 24,
			'INCLUDE' => 26,
			'USE' => 68,
			'perl' => 28,
			'CALL' => 30,
			'REF' => 32,
			'BLOCK' => 69
		},
		DEFAULT => -3,
		GOTOS => {
			'switch' => 2,
			'sterm' => 48,
			'filter' => 65,
			'chunk' => 1,
			'expr' => 61,
			'item' => 46,
			'defblock' => 47,
			'macro' => 22,
			'use' => 21,
			'node' => 31,
			'directive' => 52,
			'condition' => 53,
			'statement' => 50,
			'ident' => 11,
			'wrapper' => 29,
			'javascript' => 25,
			'term' => 67,
			'anonblock' => 27,
			'atomexpr' => 49,
			'setlist' => 56,
			'capture' => 16,
			'assign' => 38,
			'block' => 269,
			'atomdir' => 14,
			'lterm' => 54,
			'view' => 70,
			'try' => 40,
			'loop' => 75,
			'raw' => 19,
			'chunks' => 57,
			'defblockname' => 17
		}
	},
	{#State 201
		ACTIONS => {
			";" => 243,
			"\"" => 270,
			"\${" => 9,
			'IDENT' => 23,
			"\$" => 71,
			'TEXT' => 246
		},
		GOTOS => {
			'node' => 31,
			'quotable' => 244,
			'ident' => 245,
			'item' => 46
		}
	},
	{#State 202
		DEFAULT => -145
	},
	{#State 203
		DEFAULT => -146
	},
	{#State 204
		ACTIONS => {
			'LITERAL' => 77,
			"\${" => 9,
			"\$" => 71,
			'IDENT' => 23,
			'REF' => 32,
			'NUMBER' => 4,
			"\"" => 73
		},
		GOTOS => {
			'item' => 46,
			'ident' => 76,
			'node' => 31,
			'sterm' => 271
		}
	},
	{#State 205
		DEFAULT => -115
	},
	{#State 206
		DEFAULT => -106
	},
	{#State 207
		DEFAULT => -116
	},
	{#State 208
		DEFAULT => -107
	},
	{#State 209
		ACTIONS => {
			'REF' => 32,
			'NOT' => 8,
			"\${" => 9,
			"{" => 39,
			"\"" => 73,
			"(" => 36,
			"[" => 37,
			'NUMBER' => 4,
			"\$" => 71,
			'IDENT' => 23,
			'LITERAL' => 77
		},
		GOTOS => {
			'term' => 67,
			'expr' => 272,
			'lterm' => 54,
			'ident' => 76,
			'item' => 46,
			'node' => 31,
			'sterm' => 48
		}
	},
	{#State 210
		DEFAULT => -122
	},
	{#State 211
		DEFAULT => -121
	},
	{#State 212
		ACTIONS => {
			"\"" => 73,
			"(" => 36,
			'NUMBER' => 4,
			"[" => 37,
			"\$" => 71,
			'IDENT' => 23,
			'LITERAL' => 77,
			'REF' => 32,
			'NOT' => 8,
			"\${" => 9,
			"{" => 39
		},
		GOTOS => {
			'node' => 31,
			'sterm' => 48,
			'item' => 46,
			'ident' => 76,
			'expr' => 273,
			'lterm' => 54,
			'term' => 67
		}
	},
	{#State 213
		DEFAULT => -109
	},
	{#State 214
		ACTIONS => {
			'NEXT' => 18,
			'TRY' => 59,
			'WRAPPER' => 58,
			'SET' => 20,
			'TEXT' => 15,
			'LITERAL' => 13,
			'rawperl' => 55,
			"\${" => 9,
			'GET' => 10,
			'WHILE' => 51,
			'NOT' => 8,
			'DEFAULT' => 7,
			'FILTER' => 12,
			'RAW' => 45,
			'IF' => 44,
			'PROCESS' => 43,
			'META' => 41,
			'JAVASCRIPT' => 42,
			'STOP' => 5,
			'NUMBER' => 4,
			'FOR' => 3,
			'CLEAR' => 74,
			"{" => 39,
			"\$" => 71,
			'INSERT' => 33,
			"[" => 37,
			"\"" => 73,
			"(" => 36,
			'THROW' => 72,
			'RETURN' => 34,
			'USE' => 68,
			'perl' => 28,
			'INCLUDE' => 26,
			'REF' => 32,
			'BLOCK' => 69,
			'CALL' => 30,
			'IDENT' => 23,
			'DEBUG' => 62,
			'LAST' => 60,
			";" => -19,
			'SWITCH' => 24,
			'MACRO' => 66,
			'UNLESS' => 63,
			'VIEW' => 64
		},
		DEFAULT => -3,
		GOTOS => {
			'directive' => 52,
			'condition' => 53,
			'node' => 31,
			'javascript' => 25,
			'atomexpr' => 49,
			'term' => 67,
			'anonblock' => 27,
			'statement' => 50,
			'wrapper' => 29,
			'ident' => 11,
			'filter' => 65,
			'chunk' => 1,
			'sterm' => 48,
			'switch' => 2,
			'use' => 21,
			'macro' => 22,
			'expr' => 61,
			'item' => 46,
			'defblock' => 47,
			'raw' => 19,
			'loop' => 75,
			'try' => 40,
			'defblockname' => 17,
			'chunks' => 57,
			'block' => 274,
			'setlist' => 56,
			'assign' => 38,
			'capture' => 16,
			'view' => 70,
			'atomdir' => 14,
			'lterm' => 54
		}
	},
	{#State 215
		ACTIONS => {
			'THROW' => 72,
			'RETURN' => 34,
			"[" => 37,
			"(" => 36,
			"\"" => 73,
			'INSERT' => 33,
			"\$" => 71,
			"{" => 39,
			'CLEAR' => 74,
			'MACRO' => 66,
			'UNLESS' => 63,
			'VIEW' => 64,
			";" => -19,
			'SWITCH' => 24,
			'LAST' => 60,
			'IDENT' => 23,
			'DEBUG' => 62,
			'CALL' => 30,
			'REF' => 32,
			'BLOCK' => 69,
			'INCLUDE' => 26,
			'USE' => 68,
			'perl' => 28,
			'rawperl' => 55,
			'LITERAL' => 13,
			'TEXT' => 15,
			'WRAPPER' => 58,
			'TRY' => 59,
			'SET' => 20,
			'NEXT' => 18,
			'STOP' => 5,
			'FOR' => 3,
			'NUMBER' => 4,
			'PROCESS' => 43,
			'META' => 41,
			'IF' => 44,
			'JAVASCRIPT' => 42,
			'RAW' => 45,
			'FILTER' => 12,
			'DEFAULT' => 7,
			"\${" => 9,
			'GET' => 10,
			'WHILE' => 51,
			'NOT' => 8
		},
		DEFAULT => -3,
		GOTOS => {
			'defblockname' => 17,
			'chunks' => 57,
			'raw' => 19,
			'try' => 40,
			'loop' => 75,
			'view' => 70,
			'atomdir' => 14,
			'lterm' => 54,
			'block' => 275,
			'assign' => 38,
			'capture' => 16,
			'setlist' => 56,
			'anonblock' => 27,
			'atomexpr' => 49,
			'term' => 67,
			'javascript' => 25,
			'wrapper' => 29,
			'ident' => 11,
			'statement' => 50,
			'condition' => 53,
			'directive' => 52,
			'node' => 31,
			'macro' => 22,
			'use' => 21,
			'item' => 46,
			'defblock' => 47,
			'expr' => 61,
			'chunk' => 1,
			'filter' => 65,
			'switch' => 2,
			'sterm' => 48
		}
	},
	{#State 216
		ACTIONS => {
			"(" => 36,
			"\"" => 73,
			'NUMBER' => 4,
			"[" => 37,
			'IDENT' => 23,
			"\$" => 71,
			'LITERAL' => 251,
			")" => 276,
			'REF' => 32,
			'COMMA' => 252,
			'NOT' => 8,
			"\${" => 9,
			"{" => 39
		},
		GOTOS => {
			'ident' => 254,
			'term' => 67,
			'node' => 31,
			'lterm' => 54,
			'expr' => 249,
			'item' => 250,
			'sterm' => 48,
			'param' => 253
		}
	},
	{#State 217
		ACTIONS => {
			'MOD' => 152,
			'CAT' => 159,
			"/" => 155,
			'BINOP' => 156,
			'CMPOP' => 157,
			'DIV' => 158,
			'AND' => 160,
			"+" => 151,
			'OR' => 154,
			"?" => 153
		},
		DEFAULT => -49
	},
	{#State 218
		ACTIONS => {
			'CAT' => 159,
			'MOD' => 152,
			'CMPOP' => 157,
			'BINOP' => 156,
			"/" => 155,
			'AND' => 160,
			'DIV' => 158,
			"+" => 151,
			'OR' => 154,
			"?" => 153
		},
		DEFAULT => -63
	},
	{#State 219
		ACTIONS => {
			"/" => 155,
			'BINOP' => 156,
			'CMPOP' => 157,
			'MOD' => 152,
			'CAT' => 159,
			"?" => 153,
			'OR' => 154,
			"+" => 151,
			'DIV' => 158,
			'AND' => 160
		},
		DEFAULT => -47
	},
	{#State 220
		DEFAULT => -68
	},
	{#State 221
		DEFAULT => -82
	},
	{#State 222
		DEFAULT => -60
	},
	{#State 223
		DEFAULT => -61,
		GOTOS => {
			'@2-3' => 277
		}
	},
	{#State 224
		ACTIONS => {
			'NEXT' => 18,
			'SET' => 20,
			'WRAPPER' => 58,
			'TRY' => 59,
			'LITERAL' => 13,
			'TEXT' => 15,
			'rawperl' => 55,
			'DEFAULT' => 7,
			'NOT' => 8,
			'WHILE' => 51,
			'GET' => 10,
			"\${" => 9,
			'FILTER' => 12,
			'JAVASCRIPT' => 42,
			'META' => 41,
			'PROCESS' => 43,
			'IF' => 44,
			'RAW' => 45,
			'STOP' => 5,
			'NUMBER' => 4,
			'FOR' => 3,
			"{" => 39,
			'CLEAR' => 74,
			'INSERT' => 33,
			"\$" => 71,
			'RETURN' => 34,
			'THROW' => 72,
			"\"" => 73,
			"(" => 36,
			"[" => 37,
			'INCLUDE' => 26,
			'perl' => 28,
			'USE' => 68,
			'CALL' => 30,
			'BLOCK' => 69,
			'REF' => 32,
			'LAST' => 60,
			'DEBUG' => 62,
			'IDENT' => 23,
			'UNLESS' => 63,
			'VIEW' => 64,
			'MACRO' => 66,
			'SWITCH' => 24,
			";" => -19
		},
		DEFAULT => -3,
		GOTOS => {
			'chunks' => 57,
			'defblockname' => 17,
			'loop' => 75,
			'try' => 40,
			'raw' => 19,
			'lterm' => 54,
			'atomdir' => 14,
			'view' => 70,
			'setlist' => 56,
			'capture' => 16,
			'assign' => 38,
			'block' => 278,
			'statement' => 50,
			'wrapper' => 29,
			'ident' => 11,
			'javascript' => 25,
			'atomexpr' => 49,
			'anonblock' => 27,
			'term' => 67,
			'node' => 31,
			'directive' => 52,
			'condition' => 53,
			'expr' => 61,
			'item' => 46,
			'defblock' => 47,
			'use' => 21,
			'macro' => 22,
			'sterm' => 48,
			'switch' => 2,
			'chunk' => 1,
			'filter' => 65
		}
	},
	{#State 225
		ACTIONS => {
			'CATCH' => 279,
			'FINAL' => 281
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 280
		}
	},
	{#State 226
		ACTIONS => {
			'DIV' => 158,
			"/" => 155,
			'MOD' => 152
		},
		DEFAULT => -136
	},
	{#State 227
		DEFAULT => -138
	},
	{#State 228
		ACTIONS => {
			'OR' => 154,
			"?" => 153,
			"+" => 151,
			":" => 282,
			'DIV' => 158,
			'AND' => 160,
			"/" => 155,
			'BINOP' => 156,
			'CMPOP' => 157,
			'MOD' => 152,
			'CAT' => 159
		}
	},
	{#State 229
		ACTIONS => {
			"/" => 155,
			'BINOP' => 156,
			'CAT' => 159,
			'MOD' => 152,
			'DIV' => 158,
			"+" => 151,
			'CMPOP' => 157
		},
		DEFAULT => -142
	},
	{#State 230
		ACTIONS => {
			'MOD' => 152,
			'DIV' => 158
		},
		DEFAULT => -135
	},
	{#State 231
		ACTIONS => {
			'DIV' => 158,
			"+" => 151,
			'MOD' => 152,
			"/" => 155
		},
		DEFAULT => -134
	},
	{#State 232
		ACTIONS => {
			"/" => 155,
			'BINOP' => 156,
			'MOD' => 152,
			"+" => 151,
			'DIV' => 158
		},
		DEFAULT => -139
	},
	{#State 233
		ACTIONS => {
			'MOD' => 152
		},
		DEFAULT => -137
	},
	{#State 234
		ACTIONS => {
			'BINOP' => 156,
			"/" => 155,
			'MOD' => 152,
			'DIV' => 158,
			"+" => 151,
			'CMPOP' => 157
		},
		DEFAULT => -140
	},
	{#State 235
		ACTIONS => {
			"+" => 151,
			'DIV' => 158,
			'CMPOP' => 157,
			'BINOP' => 156,
			"/" => 155,
			'CAT' => 159,
			'MOD' => 152
		},
		DEFAULT => -141
	},
	{#State 236
		ACTIONS => {
			'RAW' => 45,
			'META' => 41,
			'IF' => 44,
			'JAVASCRIPT' => 42,
			'PROCESS' => 43,
			'FOR' => 3,
			'STOP' => 5,
			'NUMBER' => 4,
			'NOT' => 8,
			'WHILE' => 51,
			'GET' => 10,
			"\${" => 9,
			'DEFAULT' => 7,
			'FILTER' => 12,
			'TEXT' => 15,
			'LITERAL' => 13,
			'rawperl' => 55,
			'NEXT' => 18,
			'SET' => 20,
			'TRY' => 59,
			'WRAPPER' => 58,
			'DEBUG' => 62,
			'IDENT' => 23,
			'LAST' => 60,
			'SWITCH' => 24,
			";" => -19,
			'UNLESS' => 63,
			'VIEW' => 64,
			'MACRO' => 66,
			'perl' => 28,
			'USE' => 68,
			'INCLUDE' => 26,
			'BLOCK' => 69,
			'REF' => 32,
			'CALL' => 30,
			"\$" => 71,
			'INSERT' => 33,
			"(" => 36,
			"\"" => 73,
			"[" => 37,
			'RETURN' => 34,
			'THROW' => 72,
			'CLEAR' => 74,
			"{" => 39
		},
		DEFAULT => -3,
		GOTOS => {
			'directive' => 52,
			'condition' => 53,
			'node' => 31,
			'javascript' => 25,
			'term' => 67,
			'anonblock' => 27,
			'atomexpr' => 49,
			'statement' => 50,
			'wrapper' => 29,
			'ident' => 11,
			'filter' => 65,
			'chunk' => 1,
			'switch' => 2,
			'sterm' => 48,
			'macro' => 22,
			'use' => 21,
			'expr' => 61,
			'defblock' => 47,
			'item' => 46,
			'raw' => 19,
			'loop' => 75,
			'try' => 40,
			'defblockname' => 17,
			'chunks' => 57,
			'block' => 283,
			'setlist' => 56,
			'capture' => 16,
			'assign' => 38,
			'view' => 70,
			'atomdir' => 14,
			'lterm' => 54
		}
	},
	{#State 237
		DEFAULT => -77,
		GOTOS => {
			'@3-3' => 284
		}
	},
	{#State 238
		DEFAULT => -92
	},
	{#State 239
		ACTIONS => {
			'CMPOP' => 157,
			'CAT' => 159,
			'MOD' => 152,
			"?" => 153,
			"+" => 151,
			'OR' => 154,
			'AND' => 160,
			'DIV' => 158,
			'BINOP' => 156,
			"/" => 155
		},
		DEFAULT => -28
	},
	{#State 240
		ACTIONS => {
			'NUMBER' => 4,
			"[" => 37,
			"\"" => 73,
			"(" => 36,
			'LITERAL' => 13,
			"\$" => 71,
			'IDENT' => 285,
			'REF' => 32,
			"{" => 39,
			"\${" => 9,
			'NOT' => 8
		},
		GOTOS => {
			'ident' => 120,
			'term' => 67,
			'node' => 31,
			'margs' => 286,
			'lterm' => 54,
			'expr' => 121,
			'item' => 46,
			'sterm' => 48,
			'assign' => 119
		}
	},
	{#State 241
		ACTIONS => {
			'RAW' => 45,
			'META' => 41,
			'JAVASCRIPT' => 42,
			'IF' => 44,
			'PROCESS' => 43,
			'FOR' => 3,
			'STOP' => 5,
			'NUMBER' => 4,
			'WHILE' => 51,
			'NOT' => 8,
			"\${" => 9,
			'GET' => 10,
			'DEFAULT' => 7,
			'FILTER' => 12,
			'TEXT' => 15,
			'LITERAL' => 13,
			'rawperl' => 55,
			'NEXT' => 18,
			'SET' => 20,
			'WRAPPER' => 58,
			'TRY' => 59,
			'DEBUG' => 62,
			'IDENT' => 23,
			'LAST' => 60,
			'SWITCH' => 24,
			";" => -19,
			'UNLESS' => 63,
			'VIEW' => 64,
			'MACRO' => 66,
			'perl' => 28,
			'USE' => 68,
			'INCLUDE' => 26,
			'BLOCK' => 69,
			'REF' => 32,
			'CALL' => 30,
			"\$" => 71,
			'INSERT' => 33,
			"(" => 36,
			"\"" => 73,
			"[" => 37,
			'RETURN' => 34,
			'THROW' => 72,
			'CLEAR' => 74,
			"{" => 39
		},
		DEFAULT => -3,
		GOTOS => {
			'block' => 287,
			'assign' => 38,
			'capture' => 16,
			'setlist' => 56,
			'view' => 70,
			'lterm' => 54,
			'atomdir' => 14,
			'raw' => 19,
			'loop' => 75,
			'try' => 40,
			'defblockname' => 17,
			'chunks' => 57,
			'chunk' => 1,
			'filter' => 65,
			'sterm' => 48,
			'switch' => 2,
			'use' => 21,
			'macro' => 22,
			'defblock' => 47,
			'item' => 46,
			'expr' => 61,
			'directive' => 52,
			'condition' => 53,
			'node' => 31,
			'atomexpr' => 49,
			'anonblock' => 27,
			'term' => 67,
			'javascript' => 25,
			'wrapper' => 29,
			'ident' => 11,
			'statement' => 50
		}
	},
	{#State 242
		DEFAULT => -112
	},
	{#State 243
		DEFAULT => -180
	},
	{#State 244
		DEFAULT => -176
	},
	{#State 245
		ACTIONS => {
			'DOT' => 89
		},
		DEFAULT => -178
	},
	{#State 246
		DEFAULT => -179
	},
	{#State 247
		DEFAULT => -157,
		GOTOS => {
			'args' => 288
		}
	},
	{#State 248
		DEFAULT => -157,
		GOTOS => {
			'args' => 289
		}
	},
	{#State 249
		ACTIONS => {
			'CAT' => 159,
			'MOD' => 152,
			'CMPOP' => 157,
			"/" => 155,
			'BINOP' => 156,
			'AND' => 160,
			'DIV' => 158,
			"+" => 151,
			"?" => 153,
			'OR' => 154
		},
		DEFAULT => -153
	},
	{#State 250
		ACTIONS => {
			"(" => 137,
			'ASSIGN' => 212
		},
		DEFAULT => -129
	},
	{#State 251
		ACTIONS => {
			'ASSIGN' => 209
		},
		DEFAULT => -113
	},
	{#State 252
		DEFAULT => -156
	},
	{#State 253
		DEFAULT => -154
	},
	{#State 254
		ACTIONS => {
			'ASSIGN' => 290,
			'DOT' => 89
		},
		DEFAULT => -110
	},
	{#State 255
		ACTIONS => {
			'rawperl' => 55,
			'LITERAL' => 13,
			'TEXT' => 15,
			'SET' => 20,
			'WRAPPER' => 58,
			'TRY' => 59,
			'NEXT' => 18,
			'STOP' => 5,
			'NUMBER' => 4,
			'FOR' => 3,
			'IF' => 44,
			'META' => 41,
			'JAVASCRIPT' => 42,
			'PROCESS' => 43,
			'RAW' => 45,
			'FILTER' => 12,
			'DEFAULT' => 7,
			'WHILE' => 51,
			'NOT' => 8,
			"\${" => 9,
			'GET' => 10,
			'RETURN' => 34,
			'THROW' => 72,
			"\"" => 73,
			"(" => 36,
			"[" => 37,
			'INSERT' => 33,
			"\$" => 71,
			"{" => 39,
			'CLEAR' => 74,
			'UNLESS' => 63,
			'VIEW' => 64,
			'MACRO' => 66,
			'SWITCH' => 24,
			";" => -19,
			'LAST' => 60,
			'DEBUG' => 62,
			'IDENT' => 23,
			'CALL' => 30,
			'BLOCK' => 69,
			'REF' => 32,
			'INCLUDE' => 26,
			'perl' => 28,
			'USE' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'filter' => 65,
			'chunk' => 1,
			'switch' => 2,
			'sterm' => 48,
			'use' => 21,
			'macro' => 22,
			'defblock' => 47,
			'item' => 46,
			'expr' => 61,
			'condition' => 53,
			'directive' => 52,
			'node' => 31,
			'term' => 67,
			'atomexpr' => 49,
			'anonblock' => 27,
			'javascript' => 25,
			'wrapper' => 29,
			'ident' => 11,
			'statement' => 50,
			'block' => 291,
			'assign' => 38,
			'capture' => 16,
			'setlist' => 56,
			'view' => 70,
			'atomdir' => 14,
			'lterm' => 54,
			'raw' => 19,
			'try' => 40,
			'loop' => 75,
			'defblockname' => 17,
			'chunks' => 57
		}
	},
	{#State 256
		ACTIONS => {
			'DIV' => 158,
			'AND' => 160,
			"?" => 153,
			"+" => 151,
			'OR' => 154,
			'BINOP' => 156,
			"/" => 155,
			'MOD' => 152,
			'CAT' => 159,
			'CMPOP' => 157
		},
		DEFAULT => -151
	},
	{#State 257
		ACTIONS => {
			'CALL' => 30,
			'REF' => 32,
			'BLOCK' => 69,
			'INCLUDE' => 26,
			'USE' => 68,
			'perl' => 28,
			'MACRO' => 66,
			'UNLESS' => 63,
			'VIEW' => 64,
			";" => -19,
			'SWITCH' => 24,
			'LAST' => 60,
			'IDENT' => 23,
			'DEBUG' => 62,
			"{" => 39,
			'CLEAR' => 74,
			'THROW' => 72,
			'RETURN' => 34,
			"[" => 37,
			"(" => 36,
			"\"" => 73,
			'INSERT' => 33,
			"\$" => 71,
			'FILTER' => 12,
			'DEFAULT' => 7,
			'GET' => 10,
			"\${" => 9,
			'WHILE' => 51,
			'NOT' => 8,
			'STOP' => 5,
			'NUMBER' => 4,
			'FOR' => 3,
			'PROCESS' => 43,
			'IF' => 44,
			'META' => 41,
			'JAVASCRIPT' => 42,
			'RAW' => 45,
			'TRY' => 59,
			'WRAPPER' => 58,
			'SET' => 20,
			'NEXT' => 18,
			'rawperl' => 55,
			'LITERAL' => 13,
			'TEXT' => 15
		},
		DEFAULT => -3,
		GOTOS => {
			'atomdir' => 14,
			'lterm' => 54,
			'view' => 70,
			'setlist' => 56,
			'capture' => 16,
			'assign' => 38,
			'block' => 292,
			'chunks' => 57,
			'defblockname' => 17,
			'loop' => 75,
			'try' => 40,
			'raw' => 19,
			'expr' => 61,
			'defblock' => 47,
			'item' => 46,
			'macro' => 22,
			'use' => 21,
			'sterm' => 48,
			'switch' => 2,
			'chunk' => 1,
			'filter' => 65,
			'statement' => 50,
			'wrapper' => 29,
			'ident' => 11,
			'javascript' => 25,
			'atomexpr' => 49,
			'term' => 67,
			'anonblock' => 27,
			'node' => 31,
			'directive' => 52,
			'condition' => 53
		}
	},
	{#State 258
		DEFAULT => -158
	},
	{#State 259
		DEFAULT => -171
	},
	{#State 260
		ACTIONS => {
			"\"" => 73,
			"(" => 36,
			"[" => 37,
			'NUMBER' => 4,
			")" => 293,
			'LITERAL' => 251,
			'IDENT' => 23,
			"\$" => 71,
			'COMMA' => 252,
			'REF' => 32,
			"{" => 39,
			'NOT' => 8,
			"\${" => 9
		},
		GOTOS => {
			'node' => 31,
			'term' => 67,
			'ident' => 254,
			'param' => 253,
			'sterm' => 48,
			'lterm' => 54,
			'expr' => 249,
			'item' => 250
		}
	},
	{#State 261
		DEFAULT => -166
	},
	{#State 262
		ACTIONS => {
			'END' => 294
		}
	},
	{#State 263
		ACTIONS => {
			"[" => 37,
			"\"" => 73,
			"(" => 36,
			"\$" => 71,
			'LITERAL' => 251,
			'COMMA' => 252,
			"{" => 39,
			'NUMBER' => 4,
			'IDENT' => 23,
			'REF' => 32,
			"\${" => 9,
			'NOT' => 8
		},
		DEFAULT => -163,
		GOTOS => {
			'param' => 253,
			'sterm' => 48,
			'lterm' => 54,
			'expr' => 249,
			'item' => 250,
			'node' => 31,
			'term' => 67,
			'ident' => 254
		}
	},
	{#State 264
		ACTIONS => {
			'ASSIGN' => -161
		},
		DEFAULT => -168
	},
	{#State 265
		ACTIONS => {
			'TEXT' => 295
		}
	},
	{#State 266
		DEFAULT => -103
	},
	{#State 267
		DEFAULT => -101
	},
	{#State 268
		ACTIONS => {
			'END' => 296
		}
	},
	{#State 269
		ACTIONS => {
			'CASE' => 297
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 298
		}
	},
	{#State 270
		DEFAULT => -168
	},
	{#State 271
		DEFAULT => -118
	},
	{#State 272
		ACTIONS => {
			'CMPOP' => 157,
			"+" => 151,
			'DIV' => 158,
			'MOD' => 152,
			'CAT' => 159,
			'OR' => 154,
			"?" => 153,
			'AND' => 160,
			'BINOP' => 156,
			"/" => 155
		},
		DEFAULT => -124
	},
	{#State 273
		ACTIONS => {
			'DIV' => 158,
			"+" => 151,
			'CMPOP' => 157,
			'AND' => 160,
			'OR' => 154,
			"?" => 153,
			'BINOP' => 156,
			"/" => 155,
			'MOD' => 152,
			'CAT' => 159
		},
		DEFAULT => -125
	},
	{#State 274
		ACTIONS => {
			'END' => 299
		}
	},
	{#State 275
		ACTIONS => {
			'ELSIF' => 300,
			'ELSE' => 302
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 301
		}
	},
	{#State 276
		DEFAULT => -130
	},
	{#State 277
		ACTIONS => {
			'REF' => 32,
			'BLOCK' => 69,
			'CALL' => 30,
			'USE' => 68,
			'perl' => 28,
			'INCLUDE' => 26,
			";" => -19,
			'SWITCH' => 24,
			'MACRO' => 66,
			'UNLESS' => 63,
			'VIEW' => 64,
			'IDENT' => 23,
			'DEBUG' => 62,
			'LAST' => 60,
			'CLEAR' => 74,
			"{" => 39,
			"[" => 37,
			"(" => 36,
			"\"" => 73,
			'THROW' => 72,
			'RETURN' => 34,
			"\$" => 71,
			'INSERT' => 33,
			'FILTER' => 12,
			'GET' => 10,
			"\${" => 9,
			'NOT' => 8,
			'WHILE' => 51,
			'DEFAULT' => 7,
			'NUMBER' => 4,
			'STOP' => 5,
			'FOR' => 3,
			'RAW' => 45,
			'PROCESS' => 43,
			'META' => 41,
			'IF' => 44,
			'JAVASCRIPT' => 42,
			'TRY' => 59,
			'WRAPPER' => 58,
			'SET' => 20,
			'NEXT' => 18,
			'rawperl' => 55,
			'TEXT' => 15,
			'LITERAL' => 13
		},
		DEFAULT => -3,
		GOTOS => {
			'block' => 303,
			'setlist' => 56,
			'assign' => 38,
			'capture' => 16,
			'view' => 70,
			'lterm' => 54,
			'atomdir' => 14,
			'raw' => 19,
			'try' => 40,
			'loop' => 75,
			'defblockname' => 17,
			'chunks' => 57,
			'filter' => 65,
			'chunk' => 1,
			'switch' => 2,
			'sterm' => 48,
			'use' => 21,
			'macro' => 22,
			'expr' => 61,
			'defblock' => 47,
			'item' => 46,
			'condition' => 53,
			'directive' => 52,
			'node' => 31,
			'javascript' => 25,
			'atomexpr' => 49,
			'term' => 67,
			'anonblock' => 27,
			'statement' => 50,
			'ident' => 11,
			'wrapper' => 29
		}
	},
	{#State 278
		ACTIONS => {
			'END' => 304
		}
	},
	{#State 279
		ACTIONS => {
			'IDENT' => 111,
			'DEFAULT' => 305,
			";" => 306,
			'FILENAME' => 93,
			'NUMBER' => 92
		},
		GOTOS => {
			'filepart' => 94,
			'filename' => 307
		}
	},
	{#State 280
		ACTIONS => {
			'END' => 308
		}
	},
	{#State 281
		ACTIONS => {
			";" => 309
		}
	},
	{#State 282
		ACTIONS => {
			'LITERAL' => 77,
			'IDENT' => 23,
			"\$" => 71,
			"\"" => 73,
			"(" => 36,
			"[" => 37,
			'NUMBER' => 4,
			"{" => 39,
			'NOT' => 8,
			"\${" => 9,
			'REF' => 32
		},
		GOTOS => {
			'ident' => 76,
			'item' => 46,
			'lterm' => 54,
			'expr' => 310,
			'term' => 67,
			'node' => 31,
			'sterm' => 48
		}
	},
	{#State 283
		ACTIONS => {
			'ELSE' => 302,
			'ELSIF' => 300
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 311
		}
	},
	{#State 284
		ACTIONS => {
			'CLEAR' => 74,
			"{" => 39,
			"\$" => 71,
			'INSERT' => 33,
			"[" => 37,
			"(" => 36,
			"\"" => 73,
			'THROW' => 72,
			'RETURN' => 34,
			'USE' => 68,
			'perl' => 28,
			'INCLUDE' => 26,
			'REF' => 32,
			'BLOCK' => 69,
			'CALL' => 30,
			'IDENT' => 23,
			'DEBUG' => 62,
			'LAST' => 60,
			";" => -19,
			'SWITCH' => 24,
			'MACRO' => 66,
			'VIEW' => 64,
			'UNLESS' => 63,
			'NEXT' => 18,
			'WRAPPER' => 58,
			'TRY' => 59,
			'SET' => 20,
			'TEXT' => 15,
			'LITERAL' => 13,
			'rawperl' => 55,
			'GET' => 10,
			"\${" => 9,
			'WHILE' => 51,
			'NOT' => 8,
			'DEFAULT' => 7,
			'FILTER' => 12,
			'RAW' => 45,
			'META' => 41,
			'IF' => 44,
			'PROCESS' => 43,
			'JAVASCRIPT' => 42,
			'STOP' => 5,
			'NUMBER' => 4,
			'FOR' => 3
		},
		DEFAULT => -3,
		GOTOS => {
			'defblockname' => 17,
			'chunks' => 57,
			'raw' => 19,
			'try' => 40,
			'loop' => 75,
			'view' => 70,
			'atomdir' => 14,
			'lterm' => 54,
			'block' => 312,
			'assign' => 38,
			'capture' => 16,
			'setlist' => 56,
			'anonblock' => 27,
			'term' => 67,
			'atomexpr' => 49,
			'javascript' => 25,
			'ident' => 11,
			'wrapper' => 29,
			'statement' => 50,
			'condition' => 53,
			'directive' => 52,
			'node' => 31,
			'use' => 21,
			'macro' => 22,
			'item' => 46,
			'defblock' => 47,
			'expr' => 61,
			'chunk' => 1,
			'filter' => 65,
			'sterm' => 48,
			'switch' => 2
		}
	},
	{#State 285
		ACTIONS => {
			'IDENT' => -97,
			")" => -97,
			'COMMA' => -97
		},
		DEFAULT => -131
	},
	{#State 286
		ACTIONS => {
			")" => 314,
			'IDENT' => 315,
			'COMMA' => 313
		}
	},
	{#State 287
		ACTIONS => {
			'END' => 316
		}
	},
	{#State 288
		ACTIONS => {
			"[" => 37,
			'NUMBER' => 4,
			"\"" => 73,
			"(" => 36,
			'LITERAL' => 251,
			"\$" => 71,
			'IDENT' => 23,
			'COMMA' => 252,
			'REF' => 32,
			"{" => 39,
			"\${" => 9,
			'NOT' => 8
		},
		DEFAULT => -64,
		GOTOS => {
			'ident' => 254,
			'term' => 67,
			'node' => 31,
			'item' => 250,
			'lterm' => 54,
			'expr' => 249,
			'sterm' => 48,
			'param' => 253
		}
	},
	{#State 289
		ACTIONS => {
			"[" => 37,
			'NUMBER' => 4,
			"(" => 36,
			"\"" => 73,
			'LITERAL' => 251,
			"\$" => 71,
			'IDENT' => 23,
			'COMMA' => 252,
			'REF' => 32,
			"{" => 39,
			"\${" => 9,
			'NOT' => 8
		},
		DEFAULT => -65,
		GOTOS => {
			'term' => 67,
			'ident' => 254,
			'node' => 31,
			'item' => 250,
			'lterm' => 54,
			'expr' => 249,
			'param' => 253,
			'sterm' => 48
		}
	},
	{#State 290
		ACTIONS => {
			'NUMBER' => 4,
			"[" => 37,
			"\"" => 73,
			"(" => 36,
			'LITERAL' => 77,
			"\$" => 71,
			'IDENT' => 23,
			'REF' => 32,
			"{" => 39,
			"\${" => 9,
			'NOT' => 8
		},
		GOTOS => {
			'term' => 67,
			'item' => 46,
			'ident' => 76,
			'lterm' => 54,
			'expr' => 317,
			'sterm' => 48,
			'node' => 31
		}
	},
	{#State 291
		ACTIONS => {
			'END' => 318
		}
	},
	{#State 292
		ACTIONS => {
			'END' => 319
		}
	},
	{#State 293
		DEFAULT => -165
	},
	{#State 294
		DEFAULT => -81
	},
	{#State 295
		ACTIONS => {
			"\"" => 320
		}
	},
	{#State 296
		DEFAULT => -83
	},
	{#State 297
		ACTIONS => {
			'LITERAL' => 77,
			'IDENT' => 23,
			"\$" => 71,
			'NUMBER' => 4,
			";" => 322,
			"[" => 37,
			"\"" => 73,
			'DEFAULT' => 323,
			"{" => 39,
			"\${" => 9,
			'REF' => 32
		},
		GOTOS => {
			'sterm' => 48,
			'node' => 31,
			'lterm' => 54,
			'item' => 46,
			'ident' => 76,
			'term' => 321
		}
	},
	{#State 298
		ACTIONS => {
			'END' => 324
		}
	},
	{#State 299
		DEFAULT => -80
	},
	{#State 300
		ACTIONS => {
			"\"" => 73,
			"(" => 36,
			"[" => 37,
			'NUMBER' => 4,
			'LITERAL' => 77,
			'IDENT' => 23,
			"\$" => 71,
			'REF' => 32,
			"{" => 39,
			'NOT' => 8,
			"\${" => 9
		},
		GOTOS => {
			'node' => 31,
			'sterm' => 48,
			'term' => 67,
			'item' => 46,
			'ident' => 76,
			'lterm' => 54,
			'expr' => 325
		}
	},
	{#State 301
		ACTIONS => {
			'END' => 326
		}
	},
	{#State 302
		ACTIONS => {
			";" => 327
		}
	},
	{#State 303
		ACTIONS => {
			'END' => 328
		}
	},
	{#State 304
		DEFAULT => -67
	},
	{#State 305
		ACTIONS => {
			";" => 329
		}
	},
	{#State 306
		ACTIONS => {
			'FILTER' => 12,
			'DEFAULT' => 7,
			"\${" => 9,
			'GET' => 10,
			'WHILE' => 51,
			'NOT' => 8,
			'NUMBER' => 4,
			'FOR' => 3,
			'STOP' => 5,
			'IF' => 44,
			'META' => 41,
			'PROCESS' => 43,
			'JAVASCRIPT' => 42,
			'RAW' => 45,
			'WRAPPER' => 58,
			'TRY' => 59,
			'SET' => 20,
			'NEXT' => 18,
			'rawperl' => 55,
			'LITERAL' => 13,
			'TEXT' => 15,
			'CALL' => 30,
			'REF' => 32,
			'BLOCK' => 69,
			'INCLUDE' => 26,
			'USE' => 68,
			'perl' => 28,
			'MACRO' => 66,
			'VIEW' => 64,
			'UNLESS' => 63,
			";" => -19,
			'SWITCH' => 24,
			'LAST' => 60,
			'IDENT' => 23,
			'DEBUG' => 62,
			"{" => 39,
			'CLEAR' => 74,
			'THROW' => 72,
			'RETURN' => 34,
			"[" => 37,
			"\"" => 73,
			"(" => 36,
			'INSERT' => 33,
			"\$" => 71
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 29,
			'ident' => 11,
			'statement' => 50,
			'anonblock' => 27,
			'atomexpr' => 49,
			'term' => 67,
			'javascript' => 25,
			'node' => 31,
			'directive' => 52,
			'condition' => 53,
			'defblock' => 47,
			'item' => 46,
			'expr' => 61,
			'macro' => 22,
			'use' => 21,
			'switch' => 2,
			'sterm' => 48,
			'chunk' => 1,
			'filter' => 65,
			'chunks' => 57,
			'defblockname' => 17,
			'try' => 40,
			'loop' => 75,
			'raw' => 19,
			'atomdir' => 14,
			'lterm' => 54,
			'view' => 70,
			'assign' => 38,
			'capture' => 16,
			'setlist' => 56,
			'block' => 330
		}
	},
	{#State 307
		ACTIONS => {
			'DOT' => 187,
			";" => 331
		}
	},
	{#State 308
		DEFAULT => -69
	},
	{#State 309
		ACTIONS => {
			'DEFAULT' => 7,
			"\${" => 9,
			'GET' => 10,
			'NOT' => 8,
			'WHILE' => 51,
			'FILTER' => 12,
			'PROCESS' => 43,
			'META' => 41,
			'JAVASCRIPT' => 42,
			'IF' => 44,
			'RAW' => 45,
			'NUMBER' => 4,
			'STOP' => 5,
			'FOR' => 3,
			'NEXT' => 18,
			'TRY' => 59,
			'WRAPPER' => 58,
			'SET' => 20,
			'LITERAL' => 13,
			'TEXT' => 15,
			'rawperl' => 55,
			'INCLUDE' => 26,
			'USE' => 68,
			'perl' => 28,
			'CALL' => 30,
			'REF' => 32,
			'BLOCK' => 69,
			'LAST' => 60,
			'IDENT' => 23,
			'DEBUG' => 62,
			'MACRO' => 66,
			'VIEW' => 64,
			'UNLESS' => 63,
			";" => -19,
			'SWITCH' => 24,
			"{" => 39,
			'CLEAR' => 74,
			'INSERT' => 33,
			"\$" => 71,
			'THROW' => 72,
			'RETURN' => 34,
			"[" => 37,
			"(" => 36,
			"\"" => 73
		},
		DEFAULT => -3,
		GOTOS => {
			'condition' => 53,
			'directive' => 52,
			'node' => 31,
			'javascript' => 25,
			'anonblock' => 27,
			'atomexpr' => 49,
			'term' => 67,
			'statement' => 50,
			'ident' => 11,
			'wrapper' => 29,
			'filter' => 65,
			'chunk' => 1,
			'sterm' => 48,
			'switch' => 2,
			'use' => 21,
			'macro' => 22,
			'expr' => 61,
			'defblock' => 47,
			'item' => 46,
			'raw' => 19,
			'loop' => 75,
			'try' => 40,
			'defblockname' => 17,
			'chunks' => 57,
			'block' => 332,
			'setlist' => 56,
			'assign' => 38,
			'capture' => 16,
			'view' => 70,
			'lterm' => 54,
			'atomdir' => 14
		}
	},
	{#State 310
		ACTIONS => {
			"+" => 151,
			'DIV' => 158,
			'CMPOP' => 157,
			'OR' => 154,
			"?" => 153,
			'AND' => 160,
			'BINOP' => 156,
			"/" => 155,
			'MOD' => 152,
			'CAT' => 159
		},
		DEFAULT => -144
	},
	{#State 311
		ACTIONS => {
			'END' => 333
		}
	},
	{#State 312
		ACTIONS => {
			'END' => 334
		}
	},
	{#State 313
		DEFAULT => -96
	},
	{#State 314
		ACTIONS => {
			'LAST' => 60,
			'DEBUG' => 62,
			'IDENT' => 23,
			'UNLESS' => 63,
			'SWITCH' => 24,
			'INCLUDE' => 26,
			'perl' => 28,
			'CALL' => 30,
			'REF' => 32,
			'BLOCK' => 181,
			'INSERT' => 33,
			"\$" => 71,
			'THROW' => 72,
			'RETURN' => 34,
			"[" => 37,
			"(" => 36,
			"\"" => 73,
			"{" => 39,
			'CLEAR' => 74,
			'JAVASCRIPT' => 42,
			'IF' => 44,
			'PROCESS' => 43,
			'STOP' => 5,
			'FOR' => 3,
			'NUMBER' => 4,
			'DEFAULT' => 7,
			'GET' => 10,
			"\${" => 9,
			'WHILE' => 51,
			'NOT' => 8,
			'FILTER' => 12,
			'LITERAL' => 13,
			'NEXT' => 18,
			'TRY' => 59,
			'WRAPPER' => 58,
			'SET' => 20
		},
		GOTOS => {
			'loop' => 75,
			'try' => 40,
			'setlist' => 56,
			'assign' => 38,
			'lterm' => 54,
			'atomdir' => 14,
			'condition' => 53,
			'directive' => 180,
			'node' => 31,
			'javascript' => 25,
			'atomexpr' => 49,
			'term' => 67,
			'ident' => 120,
			'wrapper' => 29,
			'filter' => 65,
			'switch' => 2,
			'sterm' => 48,
			'expr' => 239,
			'mdir' => 335,
			'item' => 46
		}
	},
	{#State 315
		DEFAULT => -95
	},
	{#State 316
		DEFAULT => -89
	},
	{#State 317
		ACTIONS => {
			'CMPOP' => 157,
			'CAT' => 159,
			'MOD' => 152,
			"+" => 151,
			'OR' => 154,
			"?" => 153,
			'AND' => 160,
			'DIV' => 158,
			"/" => 155,
			'BINOP' => 156
		},
		DEFAULT => -155
	},
	{#State 318
		DEFAULT => -59
	},
	{#State 319
		DEFAULT => -94
	},
	{#State 320
		DEFAULT => -102
	},
	{#State 321
		ACTIONS => {
			";" => 336
		}
	},
	{#State 322
		ACTIONS => {
			'FILTER' => 12,
			'DEFAULT' => 7,
			'NOT' => 8,
			'WHILE' => 51,
			'GET' => 10,
			"\${" => 9,
			'FOR' => 3,
			'NUMBER' => 4,
			'STOP' => 5,
			'PROCESS' => 43,
			'JAVASCRIPT' => 42,
			'META' => 41,
			'IF' => 44,
			'RAW' => 45,
			'SET' => 20,
			'WRAPPER' => 58,
			'TRY' => 59,
			'NEXT' => 18,
			'rawperl' => 55,
			'LITERAL' => 13,
			'TEXT' => 15,
			'CALL' => 30,
			'BLOCK' => 69,
			'REF' => 32,
			'INCLUDE' => 26,
			'perl' => 28,
			'USE' => 68,
			'UNLESS' => 63,
			'VIEW' => 64,
			'MACRO' => 66,
			'SWITCH' => 24,
			";" => -19,
			'LAST' => 60,
			'IDENT' => 23,
			'DEBUG' => 62,
			"{" => 39,
			'CLEAR' => 74,
			'RETURN' => 34,
			'THROW' => 72,
			"(" => 36,
			"\"" => 73,
			"[" => 37,
			'INSERT' => 33,
			"\$" => 71
		},
		DEFAULT => -3,
		GOTOS => {
			'chunks' => 57,
			'defblockname' => 17,
			'try' => 40,
			'loop' => 75,
			'raw' => 19,
			'lterm' => 54,
			'atomdir' => 14,
			'view' => 70,
			'setlist' => 56,
			'assign' => 38,
			'capture' => 16,
			'block' => 337,
			'statement' => 50,
			'wrapper' => 29,
			'ident' => 11,
			'javascript' => 25,
			'anonblock' => 27,
			'atomexpr' => 49,
			'term' => 67,
			'node' => 31,
			'condition' => 53,
			'directive' => 52,
			'expr' => 61,
			'item' => 46,
			'defblock' => 47,
			'macro' => 22,
			'use' => 21,
			'switch' => 2,
			'sterm' => 48,
			'filter' => 65,
			'chunk' => 1
		}
	},
	{#State 323
		ACTIONS => {
			";" => 338
		}
	},
	{#State 324
		DEFAULT => -53
	},
	{#State 325
		ACTIONS => {
			"+" => 151,
			'OR' => 154,
			"?" => 153,
			'DIV' => 158,
			'AND' => 160,
			'BINOP' => 156,
			"/" => 155,
			'CMPOP' => 157,
			";" => 339,
			'MOD' => 152,
			'CAT' => 159
		}
	},
	{#State 326
		DEFAULT => -46
	},
	{#State 327
		ACTIONS => {
			'CALL' => 30,
			'REF' => 32,
			'BLOCK' => 69,
			'INCLUDE' => 26,
			'USE' => 68,
			'perl' => 28,
			'MACRO' => 66,
			'UNLESS' => 63,
			'VIEW' => 64,
			";" => -19,
			'SWITCH' => 24,
			'LAST' => 60,
			'IDENT' => 23,
			'DEBUG' => 62,
			"{" => 39,
			'CLEAR' => 74,
			'THROW' => 72,
			'RETURN' => 34,
			"[" => 37,
			"(" => 36,
			"\"" => 73,
			'INSERT' => 33,
			"\$" => 71,
			'FILTER' => 12,
			'DEFAULT' => 7,
			'GET' => 10,
			"\${" => 9,
			'NOT' => 8,
			'WHILE' => 51,
			'FOR' => 3,
			'STOP' => 5,
			'NUMBER' => 4,
			'JAVASCRIPT' => 42,
			'PROCESS' => 43,
			'IF' => 44,
			'META' => 41,
			'RAW' => 45,
			'TRY' => 59,
			'WRAPPER' => 58,
			'SET' => 20,
			'NEXT' => 18,
			'rawperl' => 55,
			'LITERAL' => 13,
			'TEXT' => 15
		},
		DEFAULT => -3,
		GOTOS => {
			'node' => 31,
			'directive' => 52,
			'condition' => 53,
			'statement' => 50,
			'ident' => 11,
			'wrapper' => 29,
			'javascript' => 25,
			'anonblock' => 27,
			'atomexpr' => 49,
			'term' => 67,
			'switch' => 2,
			'sterm' => 48,
			'filter' => 65,
			'chunk' => 1,
			'expr' => 61,
			'item' => 46,
			'defblock' => 47,
			'use' => 21,
			'macro' => 22,
			'loop' => 75,
			'try' => 40,
			'raw' => 19,
			'chunks' => 57,
			'defblockname' => 17,
			'setlist' => 56,
			'capture' => 16,
			'assign' => 38,
			'block' => 340,
			'lterm' => 54,
			'atomdir' => 14,
			'view' => 70
		}
	},
	{#State 328
		DEFAULT => -62
	},
	{#State 329
		ACTIONS => {
			'CLEAR' => 74,
			"{" => 39,
			"\$" => 71,
			'INSERT' => 33,
			"(" => 36,
			"\"" => 73,
			"[" => 37,
			'RETURN' => 34,
			'THROW' => 72,
			'perl' => 28,
			'USE' => 68,
			'INCLUDE' => 26,
			'BLOCK' => 69,
			'REF' => 32,
			'CALL' => 30,
			'DEBUG' => 62,
			'IDENT' => 23,
			'LAST' => 60,
			'SWITCH' => 24,
			";" => -19,
			'VIEW' => 64,
			'UNLESS' => 63,
			'MACRO' => 66,
			'NEXT' => 18,
			'SET' => 20,
			'WRAPPER' => 58,
			'TRY' => 59,
			'TEXT' => 15,
			'LITERAL' => 13,
			'rawperl' => 55,
			'WHILE' => 51,
			'NOT' => 8,
			'GET' => 10,
			"\${" => 9,
			'DEFAULT' => 7,
			'FILTER' => 12,
			'RAW' => 45,
			'PROCESS' => 43,
			'META' => 41,
			'IF' => 44,
			'JAVASCRIPT' => 42,
			'FOR' => 3,
			'NUMBER' => 4,
			'STOP' => 5
		},
		DEFAULT => -3,
		GOTOS => {
			'block' => 341,
			'capture' => 16,
			'assign' => 38,
			'setlist' => 56,
			'view' => 70,
			'atomdir' => 14,
			'lterm' => 54,
			'raw' => 19,
			'loop' => 75,
			'try' => 40,
			'defblockname' => 17,
			'chunks' => 57,
			'filter' => 65,
			'chunk' => 1,
			'sterm' => 48,
			'switch' => 2,
			'use' => 21,
			'macro' => 22,
			'defblock' => 47,
			'item' => 46,
			'expr' => 61,
			'directive' => 52,
			'condition' => 53,
			'node' => 31,
			'term' => 67,
			'atomexpr' => 49,
			'anonblock' => 27,
			'javascript' => 25,
			'ident' => 11,
			'wrapper' => 29,
			'statement' => 50
		}
	},
	{#State 330
		ACTIONS => {
			'CATCH' => 279,
			'FINAL' => 281
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 342
		}
	},
	{#State 331
		ACTIONS => {
			'RAW' => 45,
			'JAVASCRIPT' => 42,
			'META' => 41,
			'IF' => 44,
			'PROCESS' => 43,
			'STOP' => 5,
			'NUMBER' => 4,
			'FOR' => 3,
			'GET' => 10,
			"\${" => 9,
			'WHILE' => 51,
			'NOT' => 8,
			'DEFAULT' => 7,
			'FILTER' => 12,
			'TEXT' => 15,
			'LITERAL' => 13,
			'rawperl' => 55,
			'NEXT' => 18,
			'TRY' => 59,
			'WRAPPER' => 58,
			'SET' => 20,
			'IDENT' => 23,
			'DEBUG' => 62,
			'LAST' => 60,
			";" => -19,
			'SWITCH' => 24,
			'MACRO' => 66,
			'VIEW' => 64,
			'UNLESS' => 63,
			'USE' => 68,
			'perl' => 28,
			'INCLUDE' => 26,
			'REF' => 32,
			'BLOCK' => 69,
			'CALL' => 30,
			"\$" => 71,
			'INSERT' => 33,
			"[" => 37,
			"\"" => 73,
			"(" => 36,
			'THROW' => 72,
			'RETURN' => 34,
			'CLEAR' => 74,
			"{" => 39
		},
		DEFAULT => -3,
		GOTOS => {
			'macro' => 22,
			'use' => 21,
			'item' => 46,
			'defblock' => 47,
			'expr' => 61,
			'filter' => 65,
			'chunk' => 1,
			'sterm' => 48,
			'switch' => 2,
			'term' => 67,
			'atomexpr' => 49,
			'anonblock' => 27,
			'javascript' => 25,
			'ident' => 11,
			'wrapper' => 29,
			'statement' => 50,
			'directive' => 52,
			'condition' => 53,
			'node' => 31,
			'view' => 70,
			'atomdir' => 14,
			'lterm' => 54,
			'block' => 343,
			'capture' => 16,
			'assign' => 38,
			'setlist' => 56,
			'defblockname' => 17,
			'chunks' => 57,
			'raw' => 19,
			'try' => 40,
			'loop' => 75
		}
	},
	{#State 332
		DEFAULT => -73
	},
	{#State 333
		DEFAULT => -48
	},
	{#State 334
		DEFAULT => -78
	},
	{#State 335
		DEFAULT => -91
	},
	{#State 336
		ACTIONS => {
			'CLEAR' => 74,
			"{" => 39,
			"\$" => 71,
			'INSERT' => 33,
			"[" => 37,
			"(" => 36,
			"\"" => 73,
			'THROW' => 72,
			'RETURN' => 34,
			'USE' => 68,
			'perl' => 28,
			'INCLUDE' => 26,
			'REF' => 32,
			'BLOCK' => 69,
			'CALL' => 30,
			'IDENT' => 23,
			'DEBUG' => 62,
			'LAST' => 60,
			";" => -19,
			'SWITCH' => 24,
			'MACRO' => 66,
			'UNLESS' => 63,
			'VIEW' => 64,
			'NEXT' => 18,
			'WRAPPER' => 58,
			'TRY' => 59,
			'SET' => 20,
			'TEXT' => 15,
			'LITERAL' => 13,
			'rawperl' => 55,
			"\${" => 9,
			'GET' => 10,
			'NOT' => 8,
			'WHILE' => 51,
			'DEFAULT' => 7,
			'FILTER' => 12,
			'RAW' => 45,
			'PROCESS' => 43,
			'IF' => 44,
			'JAVASCRIPT' => 42,
			'META' => 41,
			'FOR' => 3,
			'STOP' => 5,
			'NUMBER' => 4
		},
		DEFAULT => -3,
		GOTOS => {
			'block' => 344,
			'setlist' => 56,
			'assign' => 38,
			'capture' => 16,
			'view' => 70,
			'atomdir' => 14,
			'lterm' => 54,
			'raw' => 19,
			'try' => 40,
			'loop' => 75,
			'defblockname' => 17,
			'chunks' => 57,
			'filter' => 65,
			'chunk' => 1,
			'sterm' => 48,
			'switch' => 2,
			'use' => 21,
			'macro' => 22,
			'expr' => 61,
			'item' => 46,
			'defblock' => 47,
			'directive' => 52,
			'condition' => 53,
			'node' => 31,
			'javascript' => 25,
			'atomexpr' => 49,
			'anonblock' => 27,
			'term' => 67,
			'statement' => 50,
			'ident' => 11,
			'wrapper' => 29
		}
	},
	{#State 337
		DEFAULT => -56
	},
	{#State 338
		ACTIONS => {
			"{" => 39,
			'CLEAR' => 74,
			'THROW' => 72,
			'RETURN' => 34,
			"[" => 37,
			"(" => 36,
			"\"" => 73,
			'INSERT' => 33,
			"\$" => 71,
			'CALL' => 30,
			'REF' => 32,
			'BLOCK' => 69,
			'INCLUDE' => 26,
			'USE' => 68,
			'perl' => 28,
			'MACRO' => 66,
			'VIEW' => 64,
			'UNLESS' => 63,
			";" => -19,
			'SWITCH' => 24,
			'LAST' => 60,
			'DEBUG' => 62,
			'IDENT' => 23,
			'TRY' => 59,
			'WRAPPER' => 58,
			'SET' => 20,
			'NEXT' => 18,
			'rawperl' => 55,
			'LITERAL' => 13,
			'TEXT' => 15,
			'FILTER' => 12,
			'DEFAULT' => 7,
			'GET' => 10,
			"\${" => 9,
			'WHILE' => 51,
			'NOT' => 8,
			'NUMBER' => 4,
			'FOR' => 3,
			'STOP' => 5,
			'PROCESS' => 43,
			'IF' => 44,
			'META' => 41,
			'JAVASCRIPT' => 42,
			'RAW' => 45
		},
		DEFAULT => -3,
		GOTOS => {
			'macro' => 22,
			'use' => 21,
			'defblock' => 47,
			'item' => 46,
			'expr' => 61,
			'filter' => 65,
			'chunk' => 1,
			'sterm' => 48,
			'switch' => 2,
			'term' => 67,
			'anonblock' => 27,
			'atomexpr' => 49,
			'javascript' => 25,
			'wrapper' => 29,
			'ident' => 11,
			'statement' => 50,
			'condition' => 53,
			'directive' => 52,
			'node' => 31,
			'view' => 70,
			'lterm' => 54,
			'atomdir' => 14,
			'block' => 345,
			'capture' => 16,
			'assign' => 38,
			'setlist' => 56,
			'defblockname' => 17,
			'chunks' => 57,
			'raw' => 19,
			'loop' => 75,
			'try' => 40
		}
	},
	{#State 339
		ACTIONS => {
			'perl' => 28,
			'USE' => 68,
			'INCLUDE' => 26,
			'BLOCK' => 69,
			'REF' => 32,
			'CALL' => 30,
			'DEBUG' => 62,
			'IDENT' => 23,
			'LAST' => 60,
			'SWITCH' => 24,
			";" => -19,
			'VIEW' => 64,
			'UNLESS' => 63,
			'MACRO' => 66,
			'CLEAR' => 74,
			"{" => 39,
			"\$" => 71,
			'INSERT' => 33,
			"(" => 36,
			"\"" => 73,
			"[" => 37,
			'RETURN' => 34,
			'THROW' => 72,
			'WHILE' => 51,
			'NOT' => 8,
			'GET' => 10,
			"\${" => 9,
			'DEFAULT' => 7,
			'FILTER' => 12,
			'RAW' => 45,
			'IF' => 44,
			'PROCESS' => 43,
			'META' => 41,
			'JAVASCRIPT' => 42,
			'FOR' => 3,
			'STOP' => 5,
			'NUMBER' => 4,
			'NEXT' => 18,
			'SET' => 20,
			'TRY' => 59,
			'WRAPPER' => 58,
			'TEXT' => 15,
			'LITERAL' => 13,
			'rawperl' => 55
		},
		DEFAULT => -3,
		GOTOS => {
			'switch' => 2,
			'sterm' => 48,
			'filter' => 65,
			'chunk' => 1,
			'item' => 46,
			'defblock' => 47,
			'expr' => 61,
			'use' => 21,
			'macro' => 22,
			'node' => 31,
			'directive' => 52,
			'condition' => 53,
			'ident' => 11,
			'wrapper' => 29,
			'statement' => 50,
			'term' => 67,
			'anonblock' => 27,
			'atomexpr' => 49,
			'javascript' => 25,
			'assign' => 38,
			'capture' => 16,
			'setlist' => 56,
			'block' => 346,
			'atomdir' => 14,
			'lterm' => 54,
			'view' => 70,
			'loop' => 75,
			'try' => 40,
			'raw' => 19,
			'chunks' => 57,
			'defblockname' => 17
		}
	},
	{#State 340
		DEFAULT => -51
	},
	{#State 341
		ACTIONS => {
			'FINAL' => 281,
			'CATCH' => 279
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 347
		}
	},
	{#State 342
		DEFAULT => -72
	},
	{#State 343
		ACTIONS => {
			'FINAL' => 281,
			'CATCH' => 279
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 348
		}
	},
	{#State 344
		ACTIONS => {
			'CASE' => 297
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 349
		}
	},
	{#State 345
		DEFAULT => -55
	},
	{#State 346
		ACTIONS => {
			'ELSIF' => 300,
			'ELSE' => 302
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 350
		}
	},
	{#State 347
		DEFAULT => -71
	},
	{#State 348
		DEFAULT => -70
	},
	{#State 349
		DEFAULT => -54
	},
	{#State 350
		DEFAULT => -50
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 68 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 71 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 72 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 75 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
					if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 77 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 80 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2,
sub
#line 81 "Parser.yp"
{ return '' unless $_[1];
                           $_[0]->location() . $_[1];
                         }
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1, undef
	],
	[#Rule 17
		 'statement', 1,
sub
#line 95 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 18
		 'statement', 2,
sub
#line 96 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 19
		 'statement', 0, undef
	],
	[#Rule 20
		 'directive', 1,
sub
#line 100 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'directive', 1, undef
	],
	[#Rule 27
		 'directive', 1, undef
	],
	[#Rule 28
		 'atomexpr', 1,
sub
#line 115 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 29
		 'atomexpr', 1, undef
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 119 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 120 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 121 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 122 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 123 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 124 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 36
		 'atomdir', 2,
sub
#line 125 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 37
		 'atomdir', 2,
sub
#line 126 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 127 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 128 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 129 "Parser.yp"
{ $factory->clear()                   }
	],
	[#Rule 41
		 'atomdir', 1,
sub
#line 130 "Parser.yp"
{ $factory->break()                   }
	],
	[#Rule 42
		 'atomdir', 1,
sub
#line 131 "Parser.yp"
{ $factory->next()                    }
	],
	[#Rule 43
		 'atomdir', 2,
sub
#line 132 "Parser.yp"
{ if ($_[2]->[0]->[0] =~ /^'(on|off)'$/) {
				          $_[0]->{ DEBUG_DIRS } = ($1 eq 'on');
					  $factory->debug($_[2]);
				      }
				      else {
					  $_[0]->{ DEBUG_DIRS } ? $factory->debug($_[2]) : '';
				      }
				    }
	],
	[#Rule 44
		 'atomdir', 1, undef
	],
	[#Rule 45
		 'atomdir', 1, undef
	],
	[#Rule 46
		 'condition', 6,
sub
#line 145 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 47
		 'condition', 3,
sub
#line 146 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 48
		 'condition', 6,
sub
#line 148 "Parser.yp"
{ $factory->if("tt2_not($_[2])", @_[4, 5])  }
	],
	[#Rule 49
		 'condition', 3,
sub
#line 149 "Parser.yp"
{ $factory->if("tt2_not($_[3])", $_[1])     }
	],
	[#Rule 50
		 'else', 5,
sub
#line 153 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
				      $_[5];                              }
	],
	[#Rule 51
		 'else', 3,
sub
#line 155 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 52
		 'else', 0,
sub
#line 156 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 53
		 'switch', 6,
sub
#line 160 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 54
		 'case', 5,
sub
#line 164 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
				      $_[5];                              }
	],
	[#Rule 55
		 'case', 4,
sub
#line 166 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 56
		 'case', 3,
sub
#line 167 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 57
		 'case', 0,
sub
#line 168 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 58
		 '@1-3', 0,
sub
#line 171 "Parser.yp"
{ $_[0]->{ INFOR }++                  }
	],
	[#Rule 59
		 'loop', 6,
sub
#line 172 "Parser.yp"
{ $_[0]->{ INFOR }--;
				      $factory->foreach(@{$_[2]}, $_[5])  }
	],
	[#Rule 60
		 'loop', 3,
sub
#line 176 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 61
		 '@2-3', 0,
sub
#line 177 "Parser.yp"
{ $_[0]->{ INWHILE }++                }
	],
	[#Rule 62
		 'loop', 6,
sub
#line 178 "Parser.yp"
{ $_[0]->{ INWHILE }--;
                                      $factory->while(@_[2, 5])           }
	],
	[#Rule 63
		 'loop', 3,
sub
#line 180 "Parser.yp"
{ $factory->while(@_[3, 1])           }
	],
	[#Rule 64
		 'loopvar', 4,
sub
#line 183 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 65
		 'loopvar', 4,
sub
#line 184 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 66
		 'loopvar', 2,
sub
#line 185 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 67
		 'wrapper', 5,
sub
#line 189 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 68
		 'wrapper', 3,
sub
#line 191 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 69
		 'try', 5,
sub
#line 195 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 70
		 'final', 5,
sub
#line 199 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
				      $_[5];                              }
	],
	[#Rule 71
		 'final', 5,
sub
#line 202 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
				      $_[5];                              }
	],
	[#Rule 72
		 'final', 4,
sub
#line 205 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
				      $_[4];                              }
	],
	[#Rule 73
		 'final', 3,
sub
#line 207 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 74
		 'final', 0,
sub
#line 208 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 75
		 'use', 2,
sub
#line 211 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 76
		 'raw', 2,
sub
#line 214 "Parser.yp"
{ $factory->raw($_[2])                }
	],
	[#Rule 77
		 '@3-3', 0,
sub
#line 217 "Parser.yp"
{ $_[0]->push_defblock();		  }
	],
	[#Rule 78
		 'view', 6,
sub
#line 218 "Parser.yp"
{ $factory->view(@_[2,5], 
						     $_[0]->pop_defblock) }
	],
	[#Rule 79
		 '@4-2', 0,
sub
#line 222 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}++;             }
	],
	[#Rule 80
		 'javascript', 5,
sub
#line 223 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}--;
				      $_[0]->{ EVAL_JAVASCRIPT } 
				      ? $factory->javascript($_[4])             
				      : $factory->no_javascript();              }
	],
	[#Rule 81
		 'filter', 5,
sub
#line 230 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 82
		 'filter', 3,
sub
#line 232 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 83
		 'defblock', 5,
sub
#line 237 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
				      pop(@{ $_[0]->{ DEFBLOCKS } });
				      $_[0]->define_block($name, $_[4]); 
				      undef
				    }
	],
	[#Rule 84
		 'defblockname', 2,
sub
#line 244 "Parser.yp"
{ push(@{ $_[0]->{ DEFBLOCKS } }, $_[2]);
				      $_[2];
				    }
	],
	[#Rule 85
		 'blockname', 1, undef
	],
	[#Rule 86
		 'blockname', 1,
sub
#line 250 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 87
		 'blockargs', 1, undef
	],
	[#Rule 88
		 'blockargs', 0, undef
	],
	[#Rule 89
		 'anonblock', 5,
sub
#line 258 "Parser.yp"
{ local $" = ', ';
				      print STDERR "experimental block args: [@{ $_[2] }]\n"
					  if $_[2];
				      $factory->anon_block($_[4])         }
	],
	[#Rule 90
		 'capture', 3,
sub
#line 264 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 91
		 'macro', 6,
sub
#line 268 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 92
		 'macro', 3,
sub
#line 269 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 93
		 'mdir', 1, undef
	],
	[#Rule 94
		 'mdir', 4,
sub
#line 273 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 95
		 'margs', 2,
sub
#line 276 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 96
		 'margs', 2,
sub
#line 277 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 97
		 'margs', 1,
sub
#line 278 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 98
		 'metadata', 2,
sub
#line 281 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 99
		 'metadata', 2, undef
	],
	[#Rule 100
		 'metadata', 1, undef
	],
	[#Rule 101
		 'meta', 3,
sub
#line 286 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
						       s/\\'/'/g  }; 
					 [ @_[1,3] ] }
	],
	[#Rule 102
		 'meta', 5,
sub
#line 289 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 103
		 'meta', 3,
sub
#line 290 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 104
		 'term', 1, undef
	],
	[#Rule 105
		 'term', 1, undef
	],
	[#Rule 106
		 'lterm', 3,
sub
#line 302 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 107
		 'lterm', 3,
sub
#line 303 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 108
		 'lterm', 2,
sub
#line 304 "Parser.yp"
{ "{ }"                               }
	],
	[#Rule 109
		 'lterm', 3,
sub
#line 305 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 110
		 'sterm', 1,
sub
#line 308 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 111
		 'sterm', 2,
sub
#line 309 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 112
		 'sterm', 3,
sub
#line 310 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 113
		 'sterm', 1, undef
	],
	[#Rule 114
		 'sterm', 1, undef
	],
	[#Rule 115
		 'list', 2,
sub
#line 315 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 116
		 'list', 2, undef
	],
	[#Rule 117
		 'list', 1, undef
	],
	[#Rule 118
		 'range', 3,
sub
#line 320 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 119
		 'hash', 1, undef
	],
	[#Rule 120
		 'hash', 0,
sub
#line 325 "Parser.yp"
{ "" }
	],
	[#Rule 121
		 'params', 2,
sub
#line 328 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 122
		 'params', 2, undef
	],
	[#Rule 123
		 'params', 1, undef
	],
	[#Rule 124
		 'param', 3,
sub
#line 333 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 125
		 'param', 3,
sub
#line 334 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 126
		 'ident', 3,
sub
#line 337 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 127
		 'ident', 3,
sub
#line 338 "Parser.yp"
{ push(@{$_[1]}, 
					   map {($_, 0)} split(/\./, $_[3]));
				      $_[1];			          }
	],
	[#Rule 128
		 'ident', 1, undef
	],
	[#Rule 129
		 'node', 1,
sub
#line 344 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 130
		 'node', 4,
sub
#line 345 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 131
		 'item', 1,
sub
#line 348 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 132
		 'item', 3,
sub
#line 349 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 133
		 'item', 2,
sub
#line 350 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
				       ? "'$_[2]'" 
				       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 355 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 356 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 357 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 137
		 'expr', 3,
sub
#line 358 "Parser.yp"
{ "math_floor($_[1] / $_[3])"         }
	],
	[#Rule 138
		 'expr', 3,
sub
#line 359 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 139
		 'expr', 3,
sub
#line 360 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 140
		 'expr', 3,
sub
#line 361 "Parser.yp"
{ "$_[1] .. $_[3]"                    }
	],
	[#Rule 141
		 'expr', 3,
sub
#line 362 "Parser.yp"
{ "tt2_true($_[1]) and tt2_true($_[3])"                   }
	],
	[#Rule 142
		 'expr', 3,
sub
#line 363 "Parser.yp"
{ "tt2_true($_[1]) or tt2_true($_[3])"                    }
	],
	[#Rule 143
		 'expr', 2,
sub
#line 364 "Parser.yp"
{ "tt2_not($_[2])"                         }
	],
	[#Rule 144
		 'expr', 5,
sub
#line 365 "Parser.yp"
{ "tt2_true($_[1]) and $_[3] or $_[5]"          }
	],
	[#Rule 145
		 'expr', 3,
sub
#line 366 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 146
		 'expr', 3,
sub
#line 367 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 147
		 'expr', 1, undef
	],
	[#Rule 148
		 'setlist', 2,
sub
#line 371 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 149
		 'setlist', 2, undef
	],
	[#Rule 150
		 'setlist', 1, undef
	],
	[#Rule 151
		 'assign', 3,
sub
#line 377 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 152
		 'assign', 3,
sub
#line 378 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 153
		 'args', 2,
sub
#line 385 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 154
		 'args', 2,
sub
#line 386 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 155
		 'args', 4,
sub
#line 387 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
				      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 156
		 'args', 2,
sub
#line 389 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 157
		 'args', 0,
sub
#line 390 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 158
		 'lnameargs', 3,
sub
#line 400 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 159
		 'lnameargs', 1, undef
	],
	[#Rule 160
		 'lvalue', 1, undef
	],
	[#Rule 161
		 'lvalue', 3,
sub
#line 405 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 162
		 'lvalue', 1, undef
	],
	[#Rule 163
		 'nameargs', 3,
sub
#line 409 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 164
		 'nameargs', 2,
sub
#line 410 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 165
		 'nameargs', 4,
sub
#line 411 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 166
		 'names', 3,
sub
#line 414 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 167
		 'names', 1,
sub
#line 415 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 168
		 'name', 3,
sub
#line 418 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 169
		 'name', 1,
sub
#line 419 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 170
		 'name', 1, undef
	],
	[#Rule 171
		 'filename', 3,
sub
#line 431 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 172
		 'filename', 1, undef
	],
	[#Rule 173
		 'filepart', 1, undef
	],
	[#Rule 174
		 'filepart', 1, undef
	],
	[#Rule 175
		 'filepart', 1, undef
	],
	[#Rule 176
		 'quoted', 2,
sub
#line 445 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
				          if defined $_[2]; $_[1]         }
	],
	[#Rule 177
		 'quoted', 0,
sub
#line 447 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 178
		 'quotable', 1,
sub
#line 450 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 179
		 'quotable', 1,
sub
#line 451 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 180
		 'quotable', 1,
sub
#line 452 "Parser.yp"
{ undef                               }
	]
];

1;
