package CTK::Skel::Module; # $Id: Module.pm 263 2019-05-17 21:10:40Z minus $
use strict;
use utf8;

=encoding utf8

=head1 NAME

CTK::Skel::Module - Module project skeleton for CTK::Helper

=head1 VIRSION

Version 1.01

=head1 SYNOPSIS

none

=head1 DESCRIPTION

Module project skeleton for CTK::Helper

no public methods

=head2 build, dirs, pool

Main methods. For internal use only

=head1 SEE ALSO

L<CTK::Skel>, L<CTK::Helper>

=head1 AUTHOR

Serż Minus (Sergey Lepenkov) L<http://www.serzik.com> E<lt>abalama@cpan.orgE<gt>

=head1 COPYRIGHT

Copyright (C) 1998-2019 D&D Corporation. All Rights Reserved

=head1 LICENSE

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

See C<LICENSE> file and L<https://dev.perl.org/licenses/>

=cut

use constant SIGNATURE => "module";

use vars qw($VERSION);
$VERSION = '1.01';

sub build {
    my $self = shift;
    my $rplc = $self->{rplc};
    $self->maybe::next::method();
    return 1;
}
sub dirs {
    my $self = shift;
    $self->{subdirs}{(SIGNATURE)} = [
        {
            path => 'lib',
            mode => 0755,
        },
        {
            path => 't',
            mode => 0755,
        },
    ];
    $self->maybe::next::method();
    return 1;
}
sub pool {
    my $self = shift;
    my $pos =  tell DATA;
    my $data = scalar(do { local $/; <DATA> });
    seek DATA, $pos, 0;
    $self->{pools}{(SIGNATURE)} = $data;
    $self->maybe::next::method();
    return 1;
}

1;

__DATA__

-----BEGIN FILE-----
Name: %PROJECT_NAME%.pm
File: lib/%PROJECT_NAME%.pm
Mode: 644

package %PROJECT_NAME%; # %DOLLAR%Id%DOLLAR%
use strict;

%PODSIG%head1 NAME

%PROJECT_NAME% - %PROJECT_NAME% project

%PODSIG%head1 VERSION

Version %PROJECT_VERSION%

%PODSIG%head1 SYNOPSIS

    use %PROJECT_NAME%;

%PODSIG%head1 DESCRIPTION

%PROJECT_NAME% project

%PODSIG%head1 HISTORY

%PODSIG%over

%PODSIG%item B<%PROJECT_VERSION% %GMT%>

Init version

%PODSIG%back

See C<Changes> file

%PODSIG%head1 SEE ALSO

L<CTK>

%PODSIG%head1 AUTHOR

%AUTHOR% E<lt>%ADMIN%E<gt>

%PODSIG%head1 COPYRIGHT

Copyright (C) %YEAR% %AUTHOR%. All Rights Reserved

%PODSIG%head1 LICENSE

This program is distributed under the GNU GPL v3.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

See C<LICENSE> file

%PODSIG%cut

use vars qw($VERSION);
$VERSION = '%PROJECT_VERSION%';

use base qw/ CTK /;

#
# Your CTK methods here
#

1;
-----END FILE-----

-----BEGIN FILE-----
Name: 01-use.t
File: t/01-use.t
Mode: 644

#!/usr/bin/perl -w
#########################################################################
#
# %AUTHOR%, <%ADMIN%>
#
# Copyright (C) %YEAR% %AUTHOR%. All Rights Reserved
#
# This is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.
#
# %DOLLAR%Id%DOLLAR%
#
#########################################################################
use Test::More tests => 2;
BEGIN { use_ok('%PROJECT_NAME%') };

ok(%PROJECT_NAME%->VERSION,'%PROJECT_NAME% version');

1;
-----END FILE-----

-----BEGIN FILE-----
Name: Makefile.PL
File: Makefile.PL
Mode: 755

#!/usr/bin/perl -w
use strict;
use ExtUtils::MakeMaker;

my $prereq_pm = {
        'CTK'   => %CTKVERSION%,
    };

WriteMakefile(
    'NAME'              => '%PROJECT_NAME%',
    'DISTNAME'          => '%PROJECT_NAME%',
    'MIN_PERL_VERSION'  => 5.016001,
    'VERSION_FROM'      => 'lib/%PROJECT_NAME%.pm',
    'ABSTRACT_FROM'     => 'lib/%PROJECT_NAME%.pm',
    'PREREQ_PM'         => $prereq_pm,
    'AUTHOR'            => '%AUTHOR% <%HOMEPAGE%>, <%ADMIN%>',
    'LICENSE'           => 'gpl',
    'META_MERGE'        => {
        resources => {
            homepage        => '%HOMEPAGE%',
            repository      => 'https://my.git.com/%PROJECT_NAMEL%.git',
            license         => 'http://opensource.org/licenses/gpl-license.php',
        },
    },
);

1;
-----END FILE-----

-----BEGIN FILE-----
Name: MANIFEST
File: MANIFEST
Mode: 644

# Generated by CTKlib %CTKVERSION%
# %DOLLAR%Id%DOLLAR%

# General files
Changes                         Changes list
INSTALL                         Installation instructions
LICENSE                         License file
Makefile.PL                     Makefile builder
MANIFEST                        This file
README                          !!! README FIRST !!!
TODO                            TO DO

# Libraries
lib/%PROJECT_NAME%.pm

# Tests
t/01-use.t

-----END FILE-----
