#!/usr/bin/perl

package eBay::API::XML::DataType::SMSSubscriptionType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SMSSubscriptionType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SMSSubscriptionType

=head1 DESCRIPTION

User data related to notifications. Note that SMS is currently reserved for future use.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SMSSubscriptionType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::Enum::SMSSubscriptionErrorCodeCodeType;
use eBay::API::XML::DataType::Enum::SMSSubscriptionUserStatusCodeType;
use eBay::API::XML::DataType::Enum::WirelessCarrierIDCodeType;


my @gaProperties = ( [ 'CarrierID', 'ns:WirelessCarrierIDCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::WirelessCarrierIDCodeType', '' ]
	, [ 'ErrorCode', 'ns:SMSSubscriptionErrorCodeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::SMSSubscriptionErrorCodeCodeType', '' ]
	, [ 'ItemToUnsubscribe', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'SMSPhone', 'xs:string', '', '', '' ]
	, [ 'UserStatus', 'ns:SMSSubscriptionUserStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::SMSSubscriptionUserStatusCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCarrierID()

The wireless carrier ID.

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: 'ns:WirelessCarrierIDCodeType'

=cut

sub setCarrierID {
  my $self = shift;
  $self->{'CarrierID'} = shift
}

=head2 getCarrierID()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'ns:WirelessCarrierIDCodeType'

=cut

sub getCarrierID {
  my $self = shift;
  return $self->{'CarrierID'};
}


=head2 setErrorCode()

Reason for SMS subscription error (postback from thired-party integrator).

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: 'ns:SMSSubscriptionErrorCodeCodeType'

=cut

sub setErrorCode {
  my $self = shift;
  $self->{'ErrorCode'} = shift
}

=head2 getErrorCode()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'ns:SMSSubscriptionErrorCodeCodeType'

=cut

sub getErrorCode {
  my $self = shift;
  return $self->{'ErrorCode'};
}


=head2 setItemToUnsubscribe()

ID of item to unsubscribe from SMS notification.

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: 'ns:ItemIDType'

=cut

sub setItemToUnsubscribe {
  my $self = shift;
  $self->{'ItemToUnsubscribe'} = shift
}

=head2 getItemToUnsubscribe()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'ns:ItemIDType'

=cut

sub getItemToUnsubscribe {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemToUnsubscribe'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setSMSPhone()

The wireless phone number to be used for receiving SMS messages.
Max length of phone number varies by country.

MaxLength: varies by country

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setSMSPhone {
  my $self = shift;
  $self->{'SMSPhone'} = shift
}

=head2 getSMSPhone()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getSMSPhone {
  my $self = shift;
  return $self->{'SMSPhone'};
}


=head2 setUserStatus()

Registered/Unregistered/Pending.

  Calls: SetNotificationPreferences
  RequiredInput: No
  AllValuesExcept: Failed, Pending, Registered, Unregistered

#    Argument: 'ns:SMSSubscriptionUserStatusCodeType'

=cut

sub setUserStatus {
  my $self = shift;
  $self->{'UserStatus'} = shift
}

=head2 getUserStatus()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'ns:SMSSubscriptionUserStatusCodeType'

=cut

sub getUserStatus {
  my $self = shift;
  return $self->{'UserStatus'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
