package Shipment::UPS::WSDL::XAVTypes::CandidateType;
$Shipment::UPS::WSDL::XAVTypes::CandidateType::VERSION = '3.08';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://www.ups.com/XMLSchema/XOLTWS/xav/v1.0'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %AddressClassification_of : ATTR(:get<AddressClassification>);
    my %AddressKeyFormat_of : ATTR(:get<AddressKeyFormat>);

    __PACKAGE__->_factory(
        [   qw(        AddressClassification
              AddressKeyFormat

            )
        ],
        {   'AddressClassification' => \%AddressClassification_of,
            'AddressKeyFormat'      => \%AddressKeyFormat_of,
        },
        {   'AddressClassification' =>
              'Shipment::UPS::WSDL::XAVTypes::AddressClassificationType',
            'AddressKeyFormat' =>
              'Shipment::UPS::WSDL::XAVTypes::AddressKeyFormatType',
        },
        {

            'AddressClassification' => 'AddressClassification',
            'AddressKeyFormat'      => 'AddressKeyFormat',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::UPS::WSDL::XAVTypes::CandidateType

=head1 VERSION

version 3.08

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CandidateType from the namespace http://www.ups.com/XMLSchema/XOLTWS/xav/v1.0.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * AddressClassification (min/maxOccurs: 0/1)

=item * AddressKeyFormat (min/maxOccurs: 1/1)

=back

=head1 NAME

Shipment::UPS::WSDL::XAVTypes::CandidateType

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::UPS::WSDL::XAVTypes::CandidateType
   AddressClassification =>  { # Shipment::UPS::WSDL::XAVTypes::AddressClassificationType
     Code =>  $some_value, # string
     Description =>  $some_value, # string
   },
   AddressKeyFormat =>  { # Shipment::UPS::WSDL::XAVTypes::AddressKeyFormatType
     ConsigneeName =>  $some_value, # string
     AttentionName =>  $some_value, # string
     AddressLine =>  $some_value, # string
     PoliticalDivision2 =>  $some_value, # string
     PoliticalDivision1 =>  $some_value, # string
     PostcodePrimaryLow =>  $some_value, # string
     PostcodeExtendedLow =>  $some_value, # string
     Region =>  $some_value, # string
     Urbanization =>  $some_value, # string
     CountryCode =>  $some_value, # string
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
