#!/usr/local/bin/perl
# 	$Id: tal.pl,v 1.22 1998/12/10 01:14:39 cinar Exp cinar $	
#
# Tal.pl: Generate personalized messages to your users.
#
# This file and all associated files and documentation:
#	 Copyright (C) 1998,1999 Ali Onur Cinar <root@zdo.com>
#
# Latest version can be downloaded from:
#
#   ftp://hun.ece.drexel.edu/pub/cinar/tal*
#   ftp://ftp.cpan.org/pub/CPAN/authors/id/A/AO/AOCINAR/tal*
#   ftp://sunsite.unc.edu/pub/Linux/system/mail/misc/tal*
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. And also
# please DO NOT REMOVE my name, and give me a CREDIT when you use
# whole or a part of this program in an other program.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

$tal_ver_raw  = '$Revision: 1.22 $'; $tal_ver_raw =~ /.{11}(.{4})/g; $tal_version = "1.$1";
$passwd_file = '/etc/passwd';
$given_file = $ARGV[0];
$alias_file = '/etc/aliases';
$remove_file = '/usr/lib/tal/removefile';
$sendmail = '/usr/lib/sendmail';
$localhost = 'hun.ece.drexel.edu';

	($mday, $mon, $year) = (localtime)[3,4,5]; 
        @monthnames = ('January','February','March','April','May','June','July','August','September','October','November','December');
        @dayendings = ('th','st','nd','rd','th','th','th','th','th','th');
$curdate = "$monthnames[$mon] $mday$dayendings[substr($mday, (length($mday) -1), 1)], 19$year";

open PasswdFile, $passwd_file;

&GenTargetList;
&ShowTargetList;
&BufferDocument;

foreach(@TargetList)
{
     &GetPersonelInfo($_);
     &GenOutput;
}

close PasswdFile;
die;

sub GotoLC
{
    print "\x1B[$_[0];$_[1]H";
}

sub ColorFB
{
    print "\x1B[$_[0];$_[1]m";
}

sub GetPersonelInfo
{  
    local ($listId, $tarusr, @ExtraInfos);
    seek (PasswdFile, 0, 0);
    $tarusr = @_[0];
	
    while (<PasswdFile>)
    {
	next if ( /^#/ | /^\s/);
	$listId++;
	@PersonelInfo = split(":", $_);
	last if ($PersonelInfo[0] eq $tarusr);
    }
    
	@ExtraInfos = split(",", $PersonelInfo[4]);
	splice (@PersonelInfo, $#PersonelInfo+1, 0, @ExtraInfos);
	$PersonelInfo[4] = $listId;
	$PersonelInfo[12] = $PersonelInfo[7]; $PersonelInfo[12] =~ s/ /./g;
	$PersonelInfo[13] = substr($PersonelInfo[7],0,index($PersonelInfo[7]," "));
	$PersonelInfo[14] = reverse(substr(reverse($PersonelInfo[7]),0,index(reverse($PersonelInfo[7])," ")));
	$PersonelInfo[15] = substr($PersonelInfo[7],0,1);
}

sub BufferDocument
{
    open GivenDocument, $given_file;
    
    while (<GivenDocument>)
    {
	push(@BufferedDocument, $_);
    }

    close GivenDocument;
}

sub GenOutput
{
    local(@MirrorBufferedDocument);
    @MirrorBufferedDocument = @BufferedDocument;

    print "Sending mail to $PersonelInfo[7] <$PersonelInfo[0]>\n";

    open SENDMAIL, "|$sendmail -oem $PersonelInfo[0]";

    $genuine = ((int(rand(100)+1) * $PersonelInfo[4]) + (int(rand(100)+1) * $PersonelInfo[2]));
    ($sec, $min, $hour) = (localtime)[0,1,2];

    print SENDMAIL "Message-ID: <TAL-$tal_version-$hour$min$sec$mday$mon$year-$genuine\@$localhost>\n";
    print SENDMAIL "Lines: $#BufferedDocument\n";
    print SENDMAIL "To: $PersonelInfo[7] <$PersonelInfo[0]\@$localhost>\n";

    foreach (@MirrorBufferedDocument)
    {
	s/<TAL_USERNAME>/$PersonelInfo[0]/g;
	s/<TAL_UID>/$PersonelInfo[2]/g;
	s/<TAL_GID>/$PersonelInfo[3]/g;
	s/<TAL_USERNO>/$PersonelInfo[4]/g;
	s/<TAL_HOMEDIR>/$PersonelInfo[5]/g;
	s/<TAL_SHELL>/$PersonelInfo[6]/g;
	s/<TAL_REALNAME>/$PersonelInfo[7]/g;
	s/<TAL_ROOM>/$PersonelInfo[8]/g;
	s/<TAL_WORKPHONE>/$PersonelInfo[9]/g;
	s/<TAL_HOMEPHONE>/$PersonelInfo[10]/g;
	s/<TAL_OTHER>/$PersonelInfo[11]/g;
	s/<TAL_DOTED_REALNAME>/$PersonelInfo[12]/g;
	s/<TAL_FIRSTNAME>/$PersonelInfo[13]/g;
	s/<TAL_LASTNAME>/$PersonelInfo[14]/g;
	s/<TAL_1ST_CHAR_FIRSTNAME>/$PersonelInfo[15]/g;
	s/<TAL_CURRENT_DATE>/$curdate/g;
	print SENDMAIL;
    }

    print SENDMAIL "\n\n[Automatically generated by TAL v$tal_version (c) 1998 Ali Onur Cinar <root\@zdo.com>]\n\n";
    close SENDMAIL;
}

sub GenTargetList
{
    local ($i=0, $m=0, @PasswdEntry, @AliasEntry, @NonTargetsTmp);
    seek (PasswdFile, 0, 0);

    while (<PasswdFile>)
    {
	next if ( /^#/ | /^\s/);
	@PasswdEntry = split (":", $_);
	push(@TargetList, $PasswdEntry[0]);
    }
    
	@TargetList = sort(@TargetList);
	open AliasFile, $alias_file;

    while (<AliasFile>)
    {
	next if ( /^#/ | /^\s/);
	@AliasEntry = split (":", $_);
	next if ($AliasEntry[2] eq 'include');
	$AliasEntry[0] =~ /^(\S+)/;
        push (@NonTargets, $1);
    }
	close AliasFile;
	open RemoveFile, $remove_file;

    while (<RemoveFile>)
    {
	next if ( /^#/ | /^\s/);
	push(@NonTargets, $_);
    }

	close RemoveFile;
	@NonTargets = sort(@NonTargets);
   
    foreach (@NonTargets)
    {
	$m=$i+1;

	while ($NonTargets[$m] eq $_)
	{
	    $NonTargets[$m] = '';
	    $m++;
	}
	
	$i++;
    }

	@NonTargets = sort(@NonTargets);
	@NonTargetsTmp = @NonTargets;

    foreach (@NonTargetsTmp)
    {
	last if ($_ ne '');
	shift @NonTargets;
    }

	$m=0;
	$i=0;

    while (($i <= $#TargetList) && ($m <= $#NonTargets))
    {
	if ($NonTargets[$m] eq $TargetList[$i])
	{
	    $TargetList[$i] = '';
	    $i++; $m++;
	}

	elsif ($NonTargets[$m] lt $TargetList[$i])
	{
	    $m++;
	}

	else
	{
	    $i++;
	}
    }

	@TargetList = sort(@TargetList);
	@TargetListTmp = @TargetList;

    foreach (@TargetListTmp)
    {
	last if ($_ ne '');
	shift @TargetList;
    }
}

sub ShowTargetList
{
    local ($stl_line=0, $stl_pointer=0, $stl_end=$#TargetList, $key, $m, $n, %delete_temp, @TargetListTmp);

    &ColorFB(7,0);
    &GotoLC(9,9);  print '+---------------+-----------------------------------+';
    &GotoLC(10,9); print '|               |      $$$$$$  $$$$  $$             |';
    &GotoLC(11,9); print "|               |        \$\$   \$\$  \$\$ \$\$   v$tal_version   |"; 
    &GotoLC(12,9); print '|               |        $$   $$^^$$ $$$$           |'; 
    &GotoLC(13,9); print '|               |                                   |'; 
    &GotoLC(14,9); print '|               | (c) Ali Onur Cinar <root@zdo.com> |'; 
    &GotoLC(15,9); print '|               |-----------------------------------|'; 
    &GotoLC(16,9); print '|               |  <space> del/undel        <s>end  |';
    &GotoLC(17,9); print '|               |  <arrows> to move         <q>uit  |';
    &GotoLC(18,9);  print '+---------------+-----------------------------------+'; 

    if ($BSD_STYLE)
    {
	system "stty cbreak </dev/tty >/dev/tty 2>&1";
    }
    else
    {
	system "stty", '-icanon', 'eol', "\001";
    }
    
    system "stty -echo";

    while (($key ne 'q') && ($key ne 's'))
    {
	$m = $stl_pointer - $stl_line;
	&ColorFB(4,0);
	
	for ($n=0; $n<8; $n++)
	{
	    &GotoLC(($n+10),10);
	    &GenListLine($m+$n);
	}

	&ColorFB(0,7);
	&GotoLC(($stl_line+10),10);
	&GenListLine($stl_pointer);

	$key = getc(STDIN);
	if ($key == 27)
	{
	    $key = getc(STDIN);
	    if (($key eq '[') || ($key eq 'O'))
	    {
		$key = getc(STDIN);
	    }
	}

# Case DN ARROW
	if ((($key eq 'B') || ($key eq 'r')) && ($stl_pointer < $stl_end))
	{
	    if ($stl_line < 7)
	    {
		$stl_line ++;
		$stl_pointer ++;
	    }

	    elsif ($stl_line == 7)
	    {
		$stl_pointer ++;
	    }
	}

# Case UP ARROW
	elsif (($key eq 'A') || ($key eq 'x'))
	{
	    if ($stl_line > 0)
	    {
		$stl_line --;
		$stl_pointer --;
	    }

	    elsif (($stl_line == 0) && ($stl_pointer > 0))
	    {
		$stl_pointer --;
	    }
	}

# Case SPACE BAR
	elsif ($key eq ' ')
	{
	    if (exists $delete_temp{$stl_pointer})
	    {
		delete ($delete_temp{$stl_pointer});
	    }
	    else
	    {
		$delete_temp{$stl_pointer} = '';
	    }
	}
     }

    &ColorFB(7,0);

    if ($BSD_STYLE)
    {
	system "stty -cbreak </dev/tty >/dev/tty 2>&1";
    }
    else
    {
	system "stty", '-icanon', 'eol', '^@';
    }

    system "stty echo";

    GotoLC(20,1);
    ColorFB(7,0);
    if ($key eq 'q') {print 'Program teminated.';die;}
   
    foreach (keys(%delete_temp))
    {
	$TargetList[$_] = '';
    }
	@TargetList = sort(@TargetList);
	@TargetListTmp = @TargetList;

    foreach (@TargetListTmp)
    {
	last if ($_ ne '');
	shift @TargetList;
    }
 }

sub GenListLine
{
    local ($list_temp, $lst_pointer);
    $lst_pointer = $_[0];

    if (exists $delete_temp{$lst_pointer})
    {
	$list_temp = 'D';
    }
    else
    {
	$list_temp = ' ';
    }

    print " $list_temp  $TargetList[$lst_pointer]", ' ' x (10-length($TargetList[$lst_pointer]));
}




