(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Created by stolfi on Wed Apr 26 03:55:29 1989               *)
(* Last modified on Fri Mar 13 14:54:05 PST 1992 by muller     *)
(*      modified on Thu Oct 25  9:24:42 PDT 1990 by stolfi     *)

INTERFACE RGBSort;

(* Procedures for sorting RGB arrays.

   Procedures for sorting RGB arrays.

   Index:  colors; graphics, colors; display, color.
*)

IMPORT Color, RGBDist;

TYPE
  NAT = CARDINAL;

  Table = ARRAY OF Color.T;
    (* 
      An array of triples *)

  DistFn = Color.DistFn;
    (* 
      A client-defined metric on color triples. *)

  CheckProc = PROCEDURE (
      READONLY color: Table; 
      READONLY pos: ARRAY OF CARDINAL;
      value: REAL;
      data: REFANY
    ): BOOLEAN;
   (* 
     A client-defined procedure for monitoring the progress of the
     sort. *)

PROCEDURE Sort (
    READONLY color: Table;              (* Colors to be sorted *)
    READONLY model: Table;              (* "Ideal" color table *)
    READONLY weight: ARRAY OF REAL;     (* Relative importance of model entries *)
    dist: DistFn := RGBDist.Perceptual; (* Distance function to use *)
    parm: REAL := 1.0;                  (* Controlling parameter for /dist/ *)
    credit: NAT := LAST (NAT);          (* Max number of calls to /dist/ *)
    tolerance: REAL := 0.005;           (* An insignificant /dist/ *)
    check: CheckProc := NIL;            (* Client's progress-monitoring proc *)
    checkData: REFANY := NIL;           (* Data for same. *)
  ): REF ARRAY OF CARDINAL    (* Where each /color/ should go. *) 
  RAISES {};
  (*
    This procedures finds the rearrangement of /color/ that best matches
    the /model/ table given.

    More precisely, it returns a vector pos[] that is a permutation
    of the indices [0..MAX(LAST(model),LAST(color))] that approximately
    minimizes the "mismatch" between color[] and model[pos[]], defined as
|
|    sum_i [ weight[pos[i]]
|            *
|            ( dist(color[i], model[pos[i]], lumWeight) - tolerance ) ^ 2
|          ]
|

    The mismatch is taken to be zero if color[i] and/or model[pos[i]]
    are RGB.Undefined, or if the distance between them is less than
    or equal to /tolerance/. If the vectors /color/ and /model/ have
    unequal lengths, the shorter is implicitly extended with
    RGB.Undefined.

    If /credit/ is specified, the routine will stop the computation
    after approximately that many distance computations, and return
    the best match obtained up to that point.  For a reasonaly good
    match, this argument should be on the order of NUMBER(color) *
    NUMBER(model).

    The procedure periodically calls check(color, pos, val, checkData),
    approximately every NUMBER(color) steps.  Here pos[p] is the current
    placement of color[p], and val[p] is the current mismatch between
    color[p] and model[pos[p]].  The /check/ procedure should normally
    return FALSE; returning TRUE will cause /Sort/ to stop and return
    the current placement /pos/ "as is". *)

END RGBSort.

