(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Created by stolfi on Fri Dec 30 22:45:04 1988               *)
(* Last modified on Tue Feb 11 21:39:42 PST 1992 by muller     *)
(*      modified on Thu Oct 25  0:14:47 PDT 1990 by stolfi     *)

INTERFACE RGBCIE;

(* Private definitions of the RGB module.
  
  This interface defines the relation of RGB coordinates to the 
  CIE 1937 color system.

  The RGB coordinates are related to the standard CIE 1937 coordinates
  by a fixed 3x3 linear matrix, which assumes an idealized display device
  with linear light response and phosphors of specific colors and
  intensities.
  
  In order for RGB values to be coreectly rendered (that is, to produce
  light with the CIE coordinates computed by RGB.CIEFormRGB), the gun
  intensities and light curves of the display device should be adjusted
  (by hardware and/or by software) to match those of the idealized display
  as closely as possible.
  
  Index: colors; graphics, colors; display, color; CIE.
*)

CONST
  rX = 0.426; rY = 0.239; rZ = 0.034;
  gX = 0.348; gY = 0.686; gZ = 0.133;
  bX = 0.177; bY = 0.075; bZ = 0.922;
  
  (* 
    XYZ coordinates of the RGB primaries.  
    
    These numbers were computed from the nominal x, y chromaticity
    coordinates of the Hitachi HM-4119 monitor phosphors, namely

|          rx = 0.610  ry = 0.342
|          gx = 0.298  gy = 0.588
|          bx = 0.151  by = 0.064

    assuming the gun intensities are calibrated to produce 
    daylight white (CIE illuminant D65).  *)

CONST 
  Xr = +3.26107804200;  Xg = -1.14099516300;  Xb = +0.04433373461;
  Yr = -1.55749548700;  Yg = +2.02602495500;  Yb = -0.23482263830;
  Zr = -0.49934777860;  Zg = +0.05423456864;  Zb = +1.09518940000;
  (* 
    RGB coordinates of the CIE XYZ primaries. *)
    
END RGBCIE.

