(* Test ref operations *)

structure Main =
struct
   val say = outputc std_out
   val printOp = fn (name,v:int) => say (name ^ " = "^ (makestring v) ^ "\n")
   val getInteger = fn () =>
	     (say "Please enter a number:";
	      flush_out std_out;
	      let val s = input_line std_in
	      in fold (fn (x,y) => (x-48)+10*y)
		      (map ord (tl (rev (explode s)))) 0
	      end)
    val i = getInteger()

    (* integer ref ops *)

    val j = ref i
    val _ = printOp("i ",i)
    val _ = printOp("deref j ",!j)
    val _ = j := (!j) + 1
    val _ = printOp("j := (!j) + 1",!j)

    (* noninteger ref ops *)
    val f  = ref(fn () => i)
    val _  = map (fn i=>i) [f]
    val _ = f:=(fn () => i *2)
    val _ = printOp("lambda () => i",(!f) ())
end 






